function [ avgData ] = avgAcrossDelays( data )
% Expects data to have time as the first dim and delay as second

maxDelay = size(data, 2);
maxTime = size(data, 1);

if (length(size(data)) == 2)
    newSize = [maxTime, 1];
else
    newSize = [maxTime, size(data, 3)];
end

newData = zeros(newSize);

if (length(size(data)) == 2)
    for t = 2:maxTime
        if t > maxDelay
            newData(t) = mean(data(t, :), 2);
        else
            newData(t) = mean(data(t, 1:(t-1)), 2);
        end
    end
else
    for t = 2:maxTime
        if t > maxDelay
            newData(t, :) = squeeze(mean(data(t, :, :), 2));
        else
            newData(t, :) = squeeze(mean(data(t, 1:(t-1), :), 2));
        end
    end
end

avgData = newData;

