function plot_allROIs_forward_feedback_transm_v1(selectedFreq, selDir, directTransf, computedROIs, ordered_rois, params)

% Whole hierarchy in the network
hyerarchy_idxs = zeros(1,numel(computedROIs));
tmp_hyerarchy_idxs = hyerarchy_idxs;
for roiIdx = 1:numel(computedROIs)
    tmp_hyerarchy_idxs(roiIdx)=find(strcmp(ordered_rois,computedROIs{roiIdx})); % Idxs of computed ROIs ordered w.r.t. hyerarchy
end
[~,tmp_hyerarchy_idxs]=sort(tmp_hyerarchy_idxs);
for roiIdx = 1:numel(computedROIs)
    hyerarchy_idxs(roiIdx) = find(tmp_hyerarchy_idxs==roiIdx);
end

for dirIdx = 1:2
    dirLab = selDir{dirIdx};
    for infoIdx = 1:numel(params.info_type)
        infoLab = params.info_type{infoIdx}; 
        figure()
        hold on
        for roiIdx = 1:numel(computedROIs)
            ROIvalidName=(matlab.lang.makeValidName(computedROIs{roiIdx}));
            % Check whether the region is sending any information in the
            % forward/feedback direction
            if isfield(directTransf.(infoLab).(selectedFreq).(ROIvalidName),dirLab)
                if strcmp(params.fwd_fbk_pooling,'mean')
                    bar(hyerarchy_idxs(roiIdx),nanmean(directTransf.(infoLab).(selectedFreq).(ROIvalidName).(dirLab)));
                elseif strcmp(params.fwd_fbk_pooling,'sum')
                     bar(hyerarchy_idxs(roiIdx),sum(directTransf.(infoLab).(selectedFreq).(ROIvalidName).(dirLab),'omitnan'));
                end
            else % for extremal ROIs in the network
                bar(hyerarchy_idxs(roiIdx),0);
            end
        end
        set(gca, 'XTick', [1:numel(computedROIs)], 'XTickLabel', computedROIs(tmp_hyerarchy_idxs), 'fontsize', 12)
        title([infoLab,' ',selectedFreq,' ',dirLab, ' T=stim. window'])
    end
end

end