function plot_corr_err_GLME_visNet_v5(sessDirectTransf,staticNetworks,sort_idxs,sel_time_window,params,paths)
% Comparison of corr vs err information transmission for DI and FIT session
% level

% FIT corr vs err
% maxYFIT = max([nanmean(sessDirectTransf.corr.(params.info_type{2}).(params.band_label).allROIs.forward),nanmean(sessDirectTransf.corr.(params.info_type{2}).(params.band_label).allROIs.feedback),...
%     nanmean(sessDirectTransf.err.(params.info_type{2}).(params.band_label).allROIs.forward),nanmean(sessDirectTransf.err.(params.info_type{2}).(params.band_label).allROIs.feedback)]);
maxYFIT = 0;

fig=figure('Position', [360, 200, 675, 420]);
subplot(1,2,1,'Position',[0.13,0.11,0.33,0.71])
hold on
measure1 = sessDirectTransf.corr.(params.info_type{2}).(params.band_label).allROIs.forward(:)';
measure2 = sessDirectTransf.err.(params.info_type{2}).(params.band_label).allROIs.forward(:)';

if params.doGLMEstat
    subjMeas1 = sessDirectTransf.corr.(params.info_type{2}).(params.band_label).allROIs.forward(:); % (:) sorts the elements by colums first (i.e. we have that first values are all from subj 1)
    subjMeas2 = sessDirectTransf.err.(params.info_type{2}).(params.band_label).allROIs.forward(:);
    corr_err_idx = [zeros(1,numel(subjMeas1)),ones(1,numel(subjMeas2))];
    subj_groups = 1:params.nSubj;
    %subj_groups = repelem(subj_groups,1,params.nSess);
    subj_groups = repelem(subj_groups,1,params.nSess*size(sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward,2));
    subj_groups = [subj_groups,subj_groups]';

    measures=[subjMeas1;subjMeas2];
    tbl = table(measures,subj_groups,corr_err_idx','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'Cond~measures + (1|Subj)', 'Distribution', 'Binomial');
    p = model.Coefficients.pValue(2);
else
    [a,p] = ttest(measure1,measure2);
    %[~,p] = ttest(measure1,measure2);
end
mean1 = mean(measure1);
sem1 = std(measure1)/sqrt(numel(measure1));
mean2 = mean(measure2);
sem2 = std(measure2)/sqrt(numel(measure2));

scatter(1,mean1,12,'r','filled')
scatter(2,mean2,12,'b','filled')
errorbar(1,mean1,sem1,'r')
errorbar(2,mean2,sem2,'b')

maxY = max([mean1+sem1;mean2+sem2]);
maxYFIT = max([maxYFIT,maxY]);

ylim([0,(3/2)*maxYFIT])
xlim([0.5,2.5])
pvalues_plot(p,1.5,(5/4)*maxYFIT,maxYFIT/10,maxYFIT/10,14,0.5,'k',0)
set(gca, 'XTick', [1 2], 'XTickLabel', {'Corr','Err'}, 'fontsize', 12)
title('Feedforward','FontSize',16)

subplot(1,2,2,'Position',[0.57,0.11,0.33,0.71])
hold on
measure1 = sessDirectTransf.corr.(params.info_type{2}).(params.band_label).allROIs.feedback(:)';
measure2 = sessDirectTransf.err.(params.info_type{2}).(params.band_label).allROIs.feedback(:)';

if params.doGLMEstat
    subjMeas1 = sessDirectTransf.corr.(params.info_type{2}).(params.band_label).allROIs.feedback(:); % (:) sorts the elements by colums first (i.e. we have that first values are all from subj 1)
    subjMeas2 = sessDirectTransf.err.(params.info_type{2}).(params.band_label).allROIs.feedback(:);
    corr_err_idx = [zeros(1,numel(subjMeas1)),ones(1,numel(subjMeas2))];
    subj_groups = 1:params.nSubj;
    %subj_groups = repelem(subj_groups,1,params.nSess);
    subj_groups = repelem(subj_groups,1,params.nSess*size(sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward,2));
    subj_groups = [subj_groups,subj_groups]';

    measures=[subjMeas1;subjMeas2];
    tbl = table(measures,subj_groups,corr_err_idx','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'Cond~measures + (1|Subj)', 'Distribution', 'Binomial');
    p = model.Coefficients.pValue(2);
else
    [~,p] = ttest(measure1,measure2);
    %[~,p] = ttest(measure1,measure2);
end
mean1 = mean(measure1);
sem1 = std(measure1)/sqrt(numel(measure1));
mean2 = mean(measure2);
sem2 = std(measure2)/sqrt(numel(measure2));

scatter(1,mean1,12,'r','filled')
scatter(2,mean2,12,'b','filled')
errorbar(1,mean1,sem1,'r')
errorbar(2,mean2,sem2,'b')
        
maxY = max([mean1+sem1;mean2+sem2]);
maxYFIT = max([maxYFIT,maxY]);

ylim([0,(3/2)*maxYFIT])
xlim([0.5,2.5])
pvalues_plot(p,1.5,(5/4)*maxYFIT,maxYFIT/10,maxYFIT/10,14,0.5,'k',0)
set(gca, 'XTick', [1 2], 'XTickLabel', {'Corr','Err'}, 'fontsize', 12)
title('Feedback','FontSize',16)

sgtitle(['FIT corr vs err T = [',num2str(sel_time_window(1)),',',num2str(sel_time_window(2)),'] ', params.bands_labels{params.bandIdx}])
if params.save_figures
    if params.doGLMEstat
        fnamePNG = [paths.figuresPath,'\allROIs_FIT_corr_vs_err_sessGLME_',date,'.png'];
        fnameFIG = [paths.figuresPath,'\allROIs_FIT_corr_vs_err_sessGLME_',date,'.fig'];
        fnameSVG = [paths.figuresPath,'\allROIs_FIT_corr_vs_err_sessGLME_',date,'.svg'];
    else
        fnamePNG = [paths.figuresPath,'\allROIs_FIT_corr_vs_err_ttest_',date,'.png'];
        fnameFIG = [paths.figuresPath,'\allROIs_FIT_corr_vs_err_ttest_',date,'.fig'];
        fnameSVG = [paths.figuresPath,'\allROIs_FIT_corr_vs_err_ttest_',date,'.svg'];
    end
    saveas(fig,fnamePNG)
    saveas(fig,fnameFIG)
    fig.Renderer = 'painters';
    saveas(fig,fnameSVG)
end

%% DI corr vs err
% maxYDI = max([nanmean(sessDirectTransf.corr.DI.(params.band_label).allROIs.forward),nanmean(sessDirectTransf.corr.DI.(params.band_label).allROIs.feedback),...
%     nanmean(sessDirectTransf.err.DI.(params.band_label).allROIs.forward),nanmean(sessDirectTransf.err.DI.(params.band_label).allROIs.feedback)]);
maxYDI = 0;

fig=figure('Position', [360, 200, 675, 420]);
subplot(1,2,1,'Position',[0.13,0.11,0.33,0.71])
hold on
measure1 = sessDirectTransf.corr.DI.(params.band_label).allROIs.forward(:)';
measure2 = sessDirectTransf.err.DI.(params.band_label).allROIs.forward(:)';

if params.doGLMEstat
    subjMeas1 = sessDirectTransf.corr.DI.(params.band_label).allROIs.forward(:); % (:) sorts the elements by colums first (i.e. we have that first values are all from subj 1)
    subjMeas2 = sessDirectTransf.err.DI.(params.band_label).allROIs.forward(:);
    corr_err_idx = [zeros(1,numel(subjMeas1)),ones(1,numel(subjMeas2))];
    subj_groups = 1:params.nSubj;
    %subj_groups = repelem(subj_groups,1,params.nSess);
    subj_groups = repelem(subj_groups,1,params.nSess*size(sessDirectTransf.all.DI.(params.band_label).allROIs.forward,2));
    subj_groups = [subj_groups,subj_groups]';

    measures=[subjMeas1;subjMeas2];
    tbl = table(measures,subj_groups,corr_err_idx','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'Cond~measures + (1|Subj)', 'Distribution', 'Binomial');
    p = model.Coefficients.pValue(2);
else
    [a,p] = ttest(measure1,measure2);
    %[~,p] = ttest(measure1,measure2);
end
mean1 = mean(measure1);
sem1 = std(measure1)/sqrt(numel(measure1));
mean2 = mean(measure2);
sem2 = std(measure2)/sqrt(numel(measure2));

scatter(1,mean1,12,'r','filled')
scatter(2,mean2,12,'b','filled')
errorbar(1,mean1,sem1,'r')
errorbar(2,mean2,sem2,'b')

maxY = max([mean1+sem1;mean2+sem2]);
maxYDI = max([maxYDI,maxY]);

ylim([0,(3/2)*maxYDI])
xlim([0.5,2.5])
pvalues_plot(p,1.5,(5/4)*maxYDI,maxYDI/10,maxYDI/10,14,0.5,'k',0)
set(gca, 'XTick', [1 2], 'XTickLabel', {'Corr','Err'}, 'fontsize', 12)
title('Feedforward','FontSize',16)

subplot(1,2,2,'Position',[0.57,0.11,0.33,0.71])
hold on
measure1 = sessDirectTransf.corr.DI.(params.band_label).allROIs.feedback(:)';
measure2 = sessDirectTransf.err.DI.(params.band_label).allROIs.feedback(:)';

if params.doGLMEstat
    subjMeas1 = sessDirectTransf.corr.DI.(params.band_label).allROIs.feedback(:); % (:) sorts the elements by colums first (i.e. we have that first values are all from subj 1)
    subjMeas2 = sessDirectTransf.err.DI.(params.band_label).allROIs.feedback(:);
    corr_err_idx = [zeros(1,numel(subjMeas1)),ones(1,numel(subjMeas2))];
    subj_groups = 1:params.nSubj;
    %subj_groups = repelem(subj_groups,1,params.nSess);
    subj_groups = repelem(subj_groups,1,params.nSess*size(sessDirectTransf.all.DI.(params.band_label).allROIs.forward,2));
    subj_groups = [subj_groups,subj_groups]';

    measures=[subjMeas1;subjMeas2];
    tbl = table(measures,subj_groups,corr_err_idx','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'Cond~measures + (1|Subj)', 'Distribution', 'Binomial');
    p = model.Coefficients.pValue(2);
else
    [~,p] = ttest(measure1,measure2);
    %[~,p] = ttest(measure1,measure2);
end
mean1 = mean(measure1);
sem1 = std(measure1)/sqrt(numel(measure1));
mean2 = mean(measure2);
sem2 = std(measure2)/sqrt(numel(measure2));

scatter(1,mean1,12,'r','filled')
scatter(2,mean2,12,'b','filled')
errorbar(1,mean1,sem1,'r')
errorbar(2,mean2,sem2,'b')

maxY = max([mean1+sem1;mean2+sem2]);
maxYDI = max([maxYDI,maxY]);

ylim([0,(3/2)*maxYDI])
xlim([0.5,2.5])
pvalues_plot(p,1.5,(5/4)*maxYDI,maxYDI/10,maxYDI/10,14,0.5,'k',0)
set(gca, 'XTick', [1 2], 'XTickLabel', {'Corr','Err'}, 'fontsize', 12)
title('Feedback','FontSize',16)

sgtitle(['DI corr vs err T = [',num2str(sel_time_window(1)),',',num2str(sel_time_window(2)),'] ', params.bands_labels{params.bandIdx}])
if params.save_figures
    if params.doGLMEstat
        fnamePNG = [paths.figuresPath,'\allROIs_DI_corr_vs_err_sessGLME_',date,'.png'];
        fnameFIG = [paths.figuresPath,'\allROIs_DI_corr_vs_err_sessGLME_',date,'.fig'];
        fnameSVG = [paths.figuresPath,'\allROIs_DI_corr_vs_err_sessGLME_',date,'.svg'];
    else
        fnamePNG = [paths.figuresPath,'\allROIs_DI_corr_vs_err_ttest_',date,'.png'];
        fnameFIG = [paths.figuresPath,'\allROIs_DI_corr_vs_err_ttest_',date,'.fig'];
        fnameSVG = [paths.figuresPath,'\allROIs_DI_corr_vs_err_ttest_',date,'.svg'];
    end
    saveas(fig,fnamePNG)
    saveas(fig,fnameFIG)
    fig.Renderer = 'painters';
    saveas(fig,fnameSVG)
end

%% Correct vs error trials networks
if numel(staticNetworks.all.DI.band_40_75.Nodes) == 4 % Only plot networks for V1, V3A, V3CD, LO3 (since in static_network_plot_v3 we specify the nodes locations and colors)
    fwd_id = [1,2,3,5,6,9]; % idx of feedforward links
    fbk_id = setdiff(1:size(staticNetworks.all.DI.band_40_75.Edges,1),fwd_id);
    
    figAll = figure('Position', [56, 219, 1189, 379]);

    for infoIdx = 1:2
        infoLab = params.info_type{infoIdx};

        tmpNetworkCorr = staticNetworks.corr.(infoLab).(params.band_label);
        tmpNetworkCorr = reordernodes(tmpNetworkCorr,sort_idxs); 
        
        tmpNetworkErr = staticNetworks.err.(infoLab).(params.band_label);
        tmpNetworkErr = reordernodes(tmpNetworkErr,sort_idxs);  % reorder links according to hierarchy
        
        % Replace fbk edges with feedforward errors
        tmpNetworkCorrErr = tmpNetworkCorr;
        tmpNetworkCorrErr = rmedge(tmpNetworkCorrErr,fbk_id);
        for edgeIdx = 1:numel(fwd_id)
            % Use name of fbk edges but assign value of fwd error
            [node1] = tmpNetworkErr.Edges.EndNodes(fbk_id(edgeIdx),1);
            [node2] = tmpNetworkErr.Edges.EndNodes(fbk_id(edgeIdx),2);
            weight = tmpNetworkErr.Edges.Weight(fwd_id(edgeIdx));
            
            tmpNetworkCorrErr = addedge(tmpNetworkCorrErr,node1,node2,weight);
        end
        
        figure(figAll)
        subplot(1,2,infoIdx)

        G=tmpNetworkCorrErr;
        static_network_plot_v4(G,zeros(4,3));
        title([infoLab])


    end
   
    figure(figAll)
    sgtitle(['Corr vs err feedforward nets'])
    if params.save_figures
        fname = [paths.figuresPath,'\graph_CorrErr_',params.across_subj_method,'_',date,'.png'];
        saveas(figAll,fname)
        fname = [paths.figuresPath,'\graph_CorrErr_',params.across_subj_method,'_',date,'fig'];
        saveas(figAll,fname)
        fname = [paths.figuresPath,'\graph_CorrErr_',params.across_subj_method,'_',date,'.svg'];
        figAll.Renderer = 'painters';
        saveas(figAll,fname)
    end

end

end

