function [hrDFIf,margInfoMatT, margInfoMatD,maxInfoTransA1A2,maxInfoTransA2A1,maxTimeTransA1A2,maxTimeTransA2A1] =...
    PlotTransInfoMeasuresMSJan(InfoMat_all,InfoMatSem_all,I_S_SSETCP_R_t_mean,I_S_SSETCP_R_t_sem,post_stim_time_vector,figname,...
    area1,area2,name_area1, name_area2, name_stim1, name_stim2, YLIM, opts)

if numel(size(InfoMat_all)) > 2
    InfoMat = squeeze(InfoMat_all(:,:,1));
    InfoMatSem = squeeze(InfoMatSem_all(:,:,1));
else
    InfoMat = squeeze(InfoMat_all(:,:,1));
    InfoMatSem = squeeze(InfoMatSem_all(:,:,1));
end

FIG_DIMS = [120 120 200 150];
FNT_SIZE = 6;
PNT_SIZE = 7;
MarkerFormat.MarkerSize = PNT_SIZE;
MAXTIME = 200;

for t1 = 1:size(InfoMat,2)-1
    for t2 = 1:size(InfoMat,1)
        if t2 > t1 +1 
            InfoMatJB(t2-t1,t2) = InfoMat(t1,t2);
        else
            if t2 > t1
                InfoMatJB(t2-t1,t2) = 0;
            end
        end
    end
end


if ~isempty(InfoMatSem)
    for t1 = 1:size(InfoMat,2)-1
        for t2 = 1:size(InfoMat,1)
            if t2 > t1 +1 
                InfoMatJBSem(t2-t1,t2) = InfoMatSem(t1,t2);
            else
                if t2 > t1
                    InfoMatJBSem(t2-t1,t2) = 0;
                end
            end
        end
    end
end


if opts.plot_zoom == 1
    zoom_indices = (post_stim_time_vector <= MAXTIME);
    post_stim_time_vector = post_stim_time_vector(zoom_indices);
    InfoMat = InfoMat(zoom_indices,zoom_indices);
    InfoMatSem = InfoMatSem(zoom_indices,zoom_indices);
end



InfoMatJB(:,22:end)=[];
InfoMatJB(7:end,:)=[];



InfoMatJBSem(:,22:end)=[];
InfoMatJBSem(7:end,:)=[];

% zoom_indices = (post_stim_time_vector <= (MAXTIME/2));
% post_stim_time_vector = post_stim_time_vector(zoom_indices);
% InfoMat = InfoMat(zoom_indices,zoom_indices);
% InfoMatSem = InfoMatSem(zoom_indices,zoom_indices);

post_stim_time_vector = post_stim_time_vector(1:21);
delay_vector = post_stim_time_vector(1:6);

margInfoMatT=nanmean(InfoMatJB,1);
[maxInfoMatT, maxInfoMatT_index]=max(margInfoMatT);
margInfoMatD=nanmean(InfoMatJB,2);
[maxInfoMatD, maxInfoMatD_index]=max(margInfoMatD);

maxtimeTD = post_stim_time_vector([maxInfoMatT_index,maxInfoMatD_index+1]);


%hrDFIf=figure('Name',figname,'units','normalized','outerposition',[0 0 1 1 ]);
hrDFIf=figure('Name',figname,'units','normalized','outerposition',[0.3 0.3 0.3 0.5]);

% UPPER PLOT MI-SENDER AT RX TIME
if ~isempty(I_S_SSETCP_R_t_mean)
axes('Position',[.1 .65 .75 .15]);
defaultColMap=get(gca,'ColorOrder');
% hplot = plot(post_stim_time_vector,squeeze(I_S_SSETCP_R_t_mean(area1,1:21)),'r','Linewidth',2);
hplot = shadedErrorBar(post_stim_time_vector,squeeze(I_S_SSETCP_R_t_mean(area1,1:21)),...
    squeeze(I_S_SSETCP_R_t_sem(area1,1:21)),'lineProps',{'r-'});%,'Linewidth',2);

% title([name_area1, ' to ', name_area2, '  \rm Stim Set = \{', name_stim1,' , ', name_stim2, '\}'],'FontSize',12);
ylim([0 0.6]);
% [val,time]=max(squeeze(I_S_SSETCP_R_t_mean(area1,1:21)))
% post_stim_time_vector(time)
ax1 = gca;
set(ax1,'linewidth',2)
set(ax1,'XTickLabel',{[]});
set(ax1,'xtick',[]);
set(ax1, 'YAxisLocation', 'right')
yticks ([0 0.25 0.5]);
set(gca, 'FontSize', 12)
for i = 1:length(ax1.YTickLabel)
    ax1.YTickLabel{i} = ['\color{red}' ax1.YTickLabel{i}];
end
ylabel('MI sender (bits)')

end

% SURF PLOT
axes('Position',[.1 .40 .75 .25])
%surf(post_stim_time_vector,post_stim_time_vector,exp(InfoMat)-1,'edgecolor','none','FaceColor','interp'); view(2);
surf(post_stim_time_vector,delay_vector,InfoMatJB,'edgecolor','none','FaceColor','interp'); view(2);
set(gca,'FontSize',12);
set(gca,'linewidth',2);
ylim([delay_vector(1),delay_vector(end)])
set(gca,'YTickLabels',{'5','15','25'})
ylabel('delay (ms)')
parulamod = parula;
if opts.plotsig == 1
    parulamod(1:5,:) = 1;
end
colormap(parulamod)
cb=colorbar(); 
cb.Position=[.87 .42 .015 .21];
if YLIM(3) > 0
    caxis([0 YLIM(3)]);
end
if length(cb.Ticks)>3
    CbTempTicks = [cb.Ticks(2), cb.Ticks(3), cb.Ticks(4)];
    if opts.plotsig == 1
        CbTempTicks = [cb.Ticks(1) cb.Ticks(2), cb.Ticks(3), cb.Ticks(4)];
    end
else
    CbTempTicks = cb.Ticks;
end
cb.Ticks = CbTempTicks;
cb.TickLabels = num2cell(CbTempTicks);
if opts.plotsig == 1
    cb.TickLabels = num2cell(CbTempTicks);
    cb.TickLabels{1} = 'non-sig';
end
%set(cb,'TickLabels',get(cb, 'Ticks'));
cb.FontSize = 12;
cb.Label.String = '(bits)';
cb.Label.FontSize = 12;
measurename = ['\bf ',figname];
hold on
if isempty(I_S_SSETCP_R_t_mean)
    xlabel('Time at receiver (ms)')
    if opts.plotsig == 0
        title([measurename,': ',name_area1, ' to ', name_area2, '  \rm Stim Set = \{', name_stim1,' , ', name_stim2, '\}'],'FontSize',12);
    else
        title(['Sign. ',measurename,': ',name_area1, ' to ', name_area2, '  \rm Stim Set = \{', name_stim1,' , ', name_stim2, '\}'],'FontSize',12);
    end
else
    set(gca,'XTickLabel',{[]});
end

% LOWER PLOT MI-RECEIVER AT RX TIME
if ~isempty(I_S_SSETCP_R_t_mean)
axes('Position',[.1 .25 .75 .15]);
defaultColMap=get(gca,'ColorOrder');
% hplot = plot(post_stim_time_vector,squeeze(I_S_SSETCP_R_t_mean(area2,1:21)),'b','Linewidth',2);
hplot = shadedErrorBar(post_stim_time_vector,squeeze(I_S_SSETCP_R_t_mean(area2,1:21)),...
    squeeze(I_S_SSETCP_R_t_sem(area2,1:21)),'lineProps',{'b-'});
ylim([0 0.6]);
% [val,time]=max(squeeze(I_S_SSETCP_R_t_mean(area2,1:21)))
% post_stim_time_vector(time)
xlabel('Time at receiver (ms)')
ax2 = gca;
set(ax2,'linewidth',2)
set(ax2, 'YAxisLocation', 'right')
yticks ([0 0.25 0.5]);
set(gca, 'FontSize', 12)
for i = 1:length(ax2.YTickLabel)
    ax2.YTickLabel{i} = ['\color{blue}' ax2.YTickLabel{i}];
end
ylabel('MI receiver (bits)')
end

maxInfoTransA1A2 = [];
maxInfoTransA2A1 = [];
maxTimeTransA1A2 = [];
maxTimeTransA2A1 = [];
end