function pvalues_plot(pval, pos, maxY, dpt, scale, f2, width, color, star)

if nargin<7
    width = 0.1;
    color = 'k';
    star = 1;
elseif nargin<8
    color = 'k';
    star = 1;
elseif nargin < 9
    star = 1;
end

if maxY > 0
    if star
        if pval > 0.055
            text(pos,maxY+scale*dpt,sprintf('%.1g', pval),'color',color,'horizontalalignment','center','FontSize',f2-4)
        elseif (pval <= 0.055 && pval > 0.01)
            text(pos,maxY+scale*dpt,sprintf('*'),'color',color,'horizontalalignment','center','FontSize',f2)
        elseif (pval <= 0.01 && pval > 0.001)
            text(pos,maxY+scale*dpt,sprintf('**'),'color',color,'horizontalalignment','center','FontSize',f2)
        elseif pval <= 0.001
            text(pos,maxY+scale*dpt,sprintf('***'),'color',color,'horizontalalignment','center','FontSize',f2)
        end
    else
        text(pos,maxY+scale*dpt,sprintf('%.2g', pval),'color',color,'horizontalalignment','center','FontSize',f2-4)
    end

    plot([pos-width,pos+width],[maxY+(scale-.5)*dpt,maxY+(scale-.5)*dpt],['-',color],'LineWidth',1)

elseif maxY < 0
    dpt = -dpt;
    if star
        if pval > 0.05
            text(pos,maxY+scale*dpt,sprintf('%.1g', pval),'color',color,'horizontalalignment','center','FontSize',f2-4)
        elseif (pval < 0.05 && pval > 0.01)
            text(pos,maxY+scale*dpt,sprintf('*'),'color',color,'horizontalalignment','center','FontSize',f2)
        elseif (pval < 0.01 && pval > 0.001)
            text(pos,maxY+scale*dpt,sprintf('**'),'color',color,'horizontalalignment','center','FontSize',f2)
        elseif pval < 0.001
            text(pos,maxY+scale*dpt,sprintf('***'),'color',color,'horizontalalignment','center','FontSize',f2)
        end
    else
        text(pos,maxY-(scale+.5)*dpt,sprintf('%.2g', pval),'color',color,'horizontalalignment','center','FontSize',f2-4)
    end

    plot([pos-width,pos+width],[maxY-(scale)*dpt,maxY-(scale)*dpt],['-',color],'LineWidth',1)
end

end