% Time significance plot function for the cFIT EEG analysis
% (find 1D clusters of significant time points)

function mask = time_significance_mask(infoTime, infoTimeNull, params)
% Input
% infoTime = 1 x timeSteps array
% infoTimeNull = timeSteps x NullPermutations array
% sign_thresh = single point significant threshold
% adjTime = time points significant clusters
%%
pval = mean(infoTimeNull > infoTime',2);
% Find self-significant points
pval = (pval < params.sign_threshold);
% Find clusters
[L,n] = bwlabel(pval);
clus_points = zeros(1,n);
for idx = 1:n
    clus_points(idx) = sum(L == idx);
end
% Find significant clusters
sig_clus = find(clus_points > params.adjSigTime);
sig_time_points = zeros(1,params.tMax-params.tMin+1);
for idx = 1:numel(sig_clus)
    sig_time_points(L == sig_clus(idx)) = 1;
end
mask = logical(sig_time_points);

end