function outArray = bootstrap_rep(nboot, inArray, params)
% Bootstrap with resampling function for FIT WIP networks
% data should be a nSubj x n_ROIs x nROIs array

nSubj  = size(inArray.all.DI.(params.band_label),1);
n_ROIs = size(inArray.all.DI.(params.band_label),2);

for infoIdx = 1:numel(params.info_type)
    infoLab = params.info_type{infoIdx};
    outArray.all.(infoLab).(params.band_label) = zeros(n_ROIs, n_ROIs, nboot);
end

for bidx = 1:nboot
    ridx = randi(nSubj,1,nSubj);
    for infoIdx = 1:numel(params.info_type)
        infoLab = params.info_type{infoIdx};
        if strcmp(params.across_subj_method,'mean')
            outArray.all.(infoLab).(params.band_label)(:,:,bidx) = nanmean(inArray.all.(infoLab).(params.band_label)(ridx,:,:),1);
        elseif strcmp(params.across_subj_method,'median')
            outArray.all.(infoLab).(params.band_label)(:,:,bidx) = median(inArray.all.(infoLab).(params.band_label)(ridx,:,:),1,'omitnan');
        end
    end
end

end

