% Compute directionality idxs

function [directTransf, sessDirectTransf, subjDirectTransf] = compute_fwd_fbk_transfer_v2(connStrenghts,sessConnStrenghts,relativeOrder,computedROIs,params,vis_idxs)

directTransf = []; % indexed of forward/feedback information transmission for each ROI
sessDirectTransf = []; % Notice directTransf is the average of subjDirectTransf across sess

% Should I take the mean or the sum when computing these idxs? At the
% moment I'm averaging across forward/feedback regions
for freqIdx = 1:numel(params.frequency_bands)
    freqLab = params.frequency_bands{freqIdx};
    for infoIdx = 1:numel(params.info_type)
        infoLab = params.info_type{infoIdx};
        directTransf.(infoLab).(freqLab).allROIs.forward = [];
        directTransf.(infoLab).(freqLab).allROIs.feedback = [];
        sessDirectTransf.(infoLab).(freqLab).allROIs.forward = [];
        sessDirectTransf.(infoLab).(freqLab).allROIs.feedback = [];
        
        % directionality transf measures within visual network
        directTransf.(infoLab).(freqLab).visROIs.forward = [];
        directTransf.(infoLab).(freqLab).visROIs.feedback = [];
        sessDirectTransf.(infoLab).(freqLab).visROIs.forward = [];
        sessDirectTransf.(infoLab).(freqLab).visROIs.feedback = [];
        
        for roiIdx = 1:numel(computedROIs)
            roiLab = computedROIs{roiIdx};
            emitted_info=connStrenghts.(infoLab).(freqLab)(roiIdx,:);
            subj_emitted_info=squeeze(sessConnStrenghts.(infoLab).(freqLab)(:,roiIdx,:));
            % Info emitted only within the visual network
            emitted_info_vis=connStrenghts.(infoLab).(freqLab)(roiIdx,vis_idxs);
            subj_emitted_info_vis=squeeze(sessConnStrenghts.(infoLab).(freqLab)(:,roiIdx,vis_idxs));
            
            ROIvalidName=(matlab.lang.makeValidName(roiLab));
            
            if isfield(relativeOrder.all.(ROIvalidName).idxs,'forward') % control that the selected ROIs has some forward ROIs
                directTransf.(infoLab).(freqLab).(ROIvalidName).forward = emitted_info(relativeOrder.all.(ROIvalidName).idxs.forward);
                sessDirectTransf.(infoLab).(freqLab).(ROIvalidName).forward = subj_emitted_info(:,relativeOrder.all.(ROIvalidName).idxs.forward);
                directTransf.(infoLab).(freqLab).allROIs.forward = [directTransf.(infoLab).(freqLab).allROIs.forward, emitted_info(relativeOrder.all.(ROIvalidName).idxs.forward)];
                sessDirectTransf.(infoLab).(freqLab).allROIs.forward = [sessDirectTransf.(infoLab).(freqLab).allROIs.forward, subj_emitted_info(:,relativeOrder.all.(ROIvalidName).idxs.forward)];
            end
            if isfield(relativeOrder.all.(ROIvalidName).idxs,'feedback') % control that the selected ROIs has some feedback ROIs
                directTransf.(infoLab).(freqLab).(ROIvalidName).feedback = emitted_info(relativeOrder.all.(ROIvalidName).idxs.feedback);
                sessDirectTransf.(infoLab).(freqLab).(ROIvalidName).feedback = subj_emitted_info(:,relativeOrder.all.(ROIvalidName).idxs.feedback);
                directTransf.(infoLab).(freqLab).allROIs.feedback = [directTransf.(infoLab).(freqLab).allROIs.feedback, emitted_info(relativeOrder.all.(ROIvalidName).idxs.feedback)];
                sessDirectTransf.(infoLab).(freqLab).allROIs.feedback = [sessDirectTransf.(infoLab).(freqLab).allROIs.feedback, subj_emitted_info(:,relativeOrder.all.(ROIvalidName).idxs.feedback)];
            end
            
            if vis_idxs(roiIdx) == 1
                if isfield(relativeOrder.visual.(ROIvalidName).idxs,'forward')
                    directTransf.(infoLab).(freqLab).visROIs.forward = [directTransf.(infoLab).(freqLab).visROIs.forward, emitted_info_vis(relativeOrder.visual.(ROIvalidName).idxs.forward)];
                    sessDirectTransf.(infoLab).(freqLab).visROIs.forward = [sessDirectTransf.(infoLab).(freqLab).visROIs.forward, subj_emitted_info_vis(:,relativeOrder.visual.(ROIvalidName).idxs.forward)];
                end
                if isfield(relativeOrder.visual.(ROIvalidName).idxs,'feedback')
                    directTransf.(infoLab).(freqLab).visROIs.feedback = [directTransf.(infoLab).(freqLab).visROIs.feedback, emitted_info_vis(relativeOrder.visual.(ROIvalidName).idxs.feedback)];
                    sessDirectTransf.(infoLab).(freqLab).visROIs.feedback = [sessDirectTransf.(infoLab).(freqLab).visROIs.feedback, subj_emitted_info_vis(:,relativeOrder.visual.(ROIvalidName).idxs.feedback)];
                end
            end
        end
        subjDirectTransf.(infoLab).(freqLab).visROIs.forward=temporal_rebinning(sessDirectTransf.(infoLab).(freqLab).visROIs.forward',4,'mean',4); % 4 sessions per subject
        subjDirectTransf.(infoLab).(freqLab).visROIs.feedback=temporal_rebinning(sessDirectTransf.(infoLab).(freqLab).visROIs.feedback',4,'mean',4);
        subjDirectTransf.(infoLab).(freqLab).allROIs.forward=temporal_rebinning(sessDirectTransf.(infoLab).(freqLab).allROIs.forward',4,'mean',4);
        subjDirectTransf.(infoLab).(freqLab).allROIs.feedback=temporal_rebinning(sessDirectTransf.(infoLab).(freqLab).allROIs.feedback',4,'mean',4);
    end
end

end