function plot_FIT_S_vs_C_GLME_visNet_v4(sessDirectTransf,sel_time_window,params,paths)
% Comparison of forward vs backward information transmission for DI, FIT_S
% and FIT_C

% maxYFIT = max([nanmean(sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward),nanmean(sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.feedback),...
%     nanmean(sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.forward),nanmean(sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.feedback)]);
maxYFIT = 0;

fig=figure('Position', [360, 200, 675, 420]);
subplot(1,3,1,'Position',[0.1,0.11,0.24,0.71])
hold on
measure1 = sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward(:);
measure2 = sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.forward(:);

if params.doGLMEstat
    subjMeas1 = sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward(:); % (:) sorts the elements by colums first (i.e. we have that first values are all from subj 1)
    subjMeas2 = sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.forward(:);
    fwd_fbk_idx = [zeros(1,numel(subjMeas1)),ones(1,numel(subjMeas2))];
    subj_groups = 1:params.nSubj;
    %subj_groups = repelem(subj_groups,1,params.nSess);
    subj_groups = repelem(subj_groups,1,params.nSess*size(sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward,2));
    subj_groups = [subj_groups,subj_groups]';

    measures=[subjMeas1;subjMeas2];
    tbl = table(measures,subj_groups,fwd_fbk_idx','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'Cond~measures + (1|Subj)', 'Distribution', 'Binomial');
    p = model.Coefficients.pValue(2);
else
    [a,p] = ttest(measure1,measure2);
    %[~,p] = ttest(measure1,measure2);
end
mean1 = mean(measure1);
sem1 = std(measure1)/sqrt(numel(measure1));
mean2 = mean(measure2);
sem2 = std(measure2)/sqrt(numel(measure2));

scatter(1,mean1,12,'r','filled')
scatter(2,mean2,12,'b','filled')
errorbar(1,mean1,sem1,'r')
errorbar(2,mean2,sem2,'b')

maxY = max([mean1+sem1;mean2+sem2]);
maxYFIT = max([maxYFIT,maxY]);

ylim([0,(3/2)*maxYFIT])
xlim([0.5,2.5])
pvalues_plot(p,1.5,(5/4)*maxYFIT,maxYFIT/10,maxYFIT/10,14,0.5,'k',0)
set(gca, 'XTick', [1 2], 'XTickLabel', {'FIT_S','FIT_C'}, 'fontsize', 12)
title('Forward','FontSize',16)

subplot(1,3,2,'Position',[0.4,0.11,0.24,0.71])
hold on
measure1 = sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.feedback(:);
measure2 = sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.feedback(:);

if params.doGLMEstat
    subjMeas1 = sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.feedback(:); % (:) sorts the elements by colums first (i.e. we have that first values are all from subj 1)
    subjMeas2 = sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.feedback(:);
    fwd_fbk_idx = [zeros(1,numel(subjMeas1)),ones(1,numel(subjMeas2))];
    subj_groups = 1:params.nSubj;
    %subj_groups = repelem(subj_groups,1,params.nSess);
    subj_groups = repelem(subj_groups,1,params.nSess*size(sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward,2));
    subj_groups = [subj_groups,subj_groups]';

    measures=[subjMeas1;subjMeas2];
    tbl = table(measures,subj_groups,fwd_fbk_idx','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'Cond~measures + (1|Subj)', 'Distribution', 'Binomial');
    p = model.Coefficients.pValue(2);
else
    [~,p] = ttest(measure1,measure2);
    %[~,p] = ttest(measure1,measure2);
end
mean1 = mean(measure1);
sem1 = std(measure1)/sqrt(numel(measure1));
mean2 = mean(measure2);
sem2 = std(measure2)/sqrt(numel(measure2));

scatter(1,mean1,12,'r','filled')
scatter(2,mean2,12,'b','filled')
errorbar(1,mean1,sem1,'r')
errorbar(2,mean2,sem2,'b')

maxY = max([mean1+sem1;mean2+sem2]);
maxYFIT = max([maxYFIT,maxY]);

ylim([0,(3/2)*maxYFIT])
xlim([0.5,2.5])
pvalues_plot(p,1.5,(5/4)*maxYFIT,maxYFIT/10,maxYFIT/10,14,0.5,'k',0)
set(gca, 'XTick', [1 2], 'XTickLabel', {'FIT_S','FIT_C'}, 'fontsize', 12)
title('Feedback','FontSize',16)

subplot(1,3,3,'Position',[0.7,0.11,0.24,0.71])
hold on
tmp1a = sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward(:);
tmp1b = sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.feedback(:);
measure1 = mean([tmp1a,tmp1b],2);

tmp2a = sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.forward(:);
tmp2b = sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.feedback(:);
measure2 = mean([tmp2a,tmp2b],2);

if params.doGLMEstat
    subjMeas1 = sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.feedback(:); % (:) sorts the elements by colums first (i.e. we have that first values are all from subj 1)
    subjMeas2 = sessDirectTransf.all.(params.info_type{3}).(params.band_label).allROIs.feedback(:);
    fwd_fbk_idx = [zeros(1,numel(subjMeas1)),ones(1,numel(subjMeas2))];
    subj_groups = 1:params.nSubj;
    %subj_groups = repelem(subj_groups,1,params.nSess);
    subj_groups = repelem(subj_groups,1,params.nSess*size(sessDirectTransf.all.(params.info_type{2}).(params.band_label).allROIs.forward,2));
    subj_groups = [subj_groups,subj_groups]';

    measures=[subjMeas1;subjMeas2];
    tbl = table(measures,subj_groups,fwd_fbk_idx','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'Cond~measures + (1|Subj)', 'Distribution', 'Binomial');
    p = model.Coefficients.pValue(2);
else
    [~,p] = ttest(measure1,measure2);
    %[~,p] = ttest(measure1,measure2);
end
mean1 = mean(measure1);
sem1 = std(measure1)/sqrt(numel(measure1));
mean2 = mean(measure2);
sem2 = std(measure2)/sqrt(numel(measure2));

scatter(1,mean1,12,'r','filled')
scatter(2,mean2,12,'b','filled')
errorbar(1,mean1,sem1,'r')
errorbar(2,mean2,sem2,'b')

maxY = max([mean1+sem1;mean2+sem2]);
maxYFIT = max([maxYFIT,maxY]);

ylim([0,(3/2)*maxYFIT])
xlim([0.5,2.5])
pvalues_plot(p,1.5,(5/4)*maxYFIT,maxYFIT/10,maxYFIT/10,14,0.5,'k',0)
set(gca, 'XTick', [1 2], 'XTickLabel', {'FIT_S','FIT_C'}, 'fontsize', 12)
title('Overall','FontSize',16)

sgtitle(['FIT_S vs FIT_C T = [',num2str(sel_time_window(1)),',',num2str(sel_time_window(2)),'] ', params.bands_labels{params.bandIdx}])
if params.save_figures
    if params.doGLMEstat
        fnamePNG = [paths.figuresPath,'\allROIs_FITS_vs_FITC_sessGLME_',date,'.png'];
        fnameFIG = [paths.figuresPath,'\allROIs_FITS_vs_FITC_sessGLME_',date,'.fig'];
        fnameSVG = [paths.figuresPath,'\allROIs_FITS_vs_FITC_sessGLME_',date,'.svg'];
    else
        fnamePNG = [paths.figuresPath,'\allROIs_FITS_vs_FITC_ttest_',date,'.png'];
        fnameFIG = [paths.figuresPath,'\allROIs_FITS_vs_FITC_ttest_',date,'.fig'];
        fnameSVG = [paths.figuresPath,'\allROIs_FITS_vs_FITC_ttest_',date,'.svg'];
    end
    saveas(fig,fnamePNG)
    saveas(fig,fnameFIG)
    fig.Renderer = 'painters';
    saveas(fig,fnameSVG)
end
end

