function h = static_network_plot_v2(G,cols)
    h=plot(G,'Layout','circle','NodeColor',cols);
    h.MarkerSize = 7.5;
    lineWeights = mat2cell((3/(max(G.Edges.Weight)))*G.Edges.Weight,numel(G.Edges.Weight),1);
    set(h,{'LineWidth'},lineWeights)
    %h.LineWidth = 2.5;
    h.NodeFontSize = 10;
    h.ArrowSize = 10;
    % hide axes:
    set(gca,'XTickLabel',{' '})
    set(gca,'YTickLabel',{' '})
    set(gca,'YTick',[])
    set(gca,'XTick',[])
end

