function [] = PlotCondMeasures(AREAS, FIT_EXP_MEAN_SC, ...
                                       cFIT_EXP_MEAN_SC,FITshared_EXP_MEAN_SC)
if AREAS(1) == 5
    STIMS(1) = 7;
    STIMS(2) = 1;
    load('Examples/DI_FIT_cFIT_FITshared_sigMasks_VPM_S1I_stims_7_1.mat')
    
elseif AREAS(1) == 1
    STIMS(1) = 5;
    STIMS(2) = 1;
    load('Examples/DI_FIT_cFIT_FITshared_sigMasks_LGN_V1I_stims_5_1.mat');
end

InfoMat = squeeze(FIT_EXP_MEAN_SC(AREAS(1),AREAS(2),STIMS(1),STIMS(2),:,:,1));
c_InfoMat = squeeze(cFIT_EXP_MEAN_SC(AREAS(1),AREAS(2),STIMS(1),STIMS(2),:,:,1));
shared_InfoMat = squeeze(FITshared_EXP_MEAN_SC(AREAS(1),AREAS(2),STIMS(1),STIMS(2),:,:,1));

mask_InfoMat = FIT_EXP_MEAN_SC_SigMask.*1;
mask_cInfoMat = cFIT_EXP_MEAN_SC_SigMask.*1;
mask_shared_InfoMat = FITshared_EXP_MEAN_SC_SigMask.*1;
MAXTIME = 200;

for t1 = 1:size(InfoMat,2)-1
    for t2 = 1:size(InfoMat,1)
        if t2 > t1 +1 
            InfoMatJB(t2-t1,t2) = InfoMat(t1,t2);
            mask_InfoMatJB(t2-t1,t2) = mask_InfoMat(t1,t2);
            cInfoMatJB(t2-t1,t2) = c_InfoMat(t1,t2);
            mask_cInfoMatJB(t2-t1,t2) = mask_cInfoMat(t1,t2);
            shared_InfoMatJB(t2-t1,t2) = shared_InfoMat(t1,t2);
            mask_shared_InfoMatJB(t2-t1,t2) = mask_shared_InfoMat(t1,t2);
        else
            if t2 > t1
            InfoMatJB(t2-t1,t2) = 0;
            mask_InfoMatJB(t2-t1,t2) = 0;
            cInfoMatJB(t2-t1,t2) = 0;
            mask_cInfoMatJB(t2-t1,t2) = 0;
            shared_InfoMatJB(t2-t1,t2) = 0;
            mask_shared_InfoMatJB(t2-t1,t2) = 0;
            end
        end
    end
end

ttime = 1:21;
ddelay = 1:6;

subplot(311)
%surf(ttime,ddelay,squeeze(InfoMatJB(ddelay,ttime)),'edgecolor','none'); view(2);caxis([0 0.007])
surf(ttime,ddelay,squeeze(InfoMatJB(ddelay,ttime).*mask_InfoMatJB(ddelay,ttime)),'edgecolor','none','FaceColor','interp'); view(2);caxis([0 0.007])
if AREAS(1) == 1
    title('Significant FIT^{LGN \rightarrow V1}')
elseif AREAS(1) == 5
    title('Significant FIT^{VPM \rightarrow S1}')
end
colorbar
xt=arrayfun(@num2str,get(gca,'xtick')*5,'un',0);
yt=arrayfun(@num2str,get(gca,'ytick')*5,'un',0);
set(gca,'xticklabel',xt,'yticklabel',yt)
ylabel('Delay [ms]');
xlabel('Time [ms]');
xlim([1 21]);
ylim([1 6])
ax = gca;
pr = {'10','20','30','40','50','60','70','80','90',''};
pr2 = {'5','','15','','25',''};
set(ax,'XTicklabel',pr);
set(ax,'YTicklabel',pr2);
ax.FontSize = 16;

subplot(312)
%surf(ttime,ddelay,squeeze(shared_InfoMatJB(ddelay,ttime)),'edgecolor','none'); view(2);caxis([0 0.007])
surf(ttime,ddelay,squeeze(shared_InfoMatJB(ddelay,ttime).*mask_shared_InfoMatJB(ddelay,ttime)),'edgecolor','none','FaceColor','interp'); view(2);caxis([0 0.007])
if AREAS(1) == 1
    title('Significant FIT^{LGN \rightarrow V1} (shared)')
elseif AREAS(1) == 5
    title('Significant FIT^{VPM \rightarrow S1} (shared)')
end

colorbar
xt=arrayfun(@num2str,get(gca,'xtick')*5,'un',0);
yt=arrayfun(@num2str,get(gca,'ytick')*5,'un',0);
set(gca,'xticklabel',xt,'yticklabel',yt)
ylabel('Delay [ms]');
xlabel('Time [ms]');
xlim([1 21]);
ylim([1 6])
ax = gca;
pr = {'10','20','30','40','50','60','70','80','90',''};
pr2 = {'5','','15','','25',''};
set(ax,'XTicklabel',pr);
set(ax,'YTicklabel',pr2);
ax.FontSize = 16;

subplot(313)
%surf(ttime,ddelay,squeeze(cInfoMatJB(ddelay,ttime)),'edgecolor','none'); view(2);caxis([0 0.007])
surf(ttime,ddelay,squeeze(cInfoMatJB(ddelay,ttime).*mask_InfoMatJB(ddelay,ttime)),'edgecolor','none','FaceColor','interp'); view(2);caxis([0 0.007])
if AREAS(1) == 1
    title('Significant cFIT^{LGN \rightarrow V1} (conditioned to VPM)')
elseif AREAS(1) == 5
    title('Significant cFIT^{VPM \rightarrow S1} (conditioned to LGN)')
end

colorbar
xt=arrayfun(@num2str,get(gca,'xtick')*5,'un',0);
yt=arrayfun(@num2str,get(gca,'ytick')*5,'un',0);
set(gca,'xticklabel',xt,'yticklabel',yt)
ylabel('Delay [ms]');
xlabel('Time [ms]');
xlim([1 21]);
ylim([1 6])
ax = gca;
pr = {'10','20','30','40','50','60','70','80','90',''};
pr2 = {'5','','15','','25',''};
set(ax,'XTicklabel',pr);
set(ax,'YTicklabel',pr2);
ax.FontSize = 16;

end