# Copyright 2020 DeepMind Technologies Limited.
# Copyright 2023 Bytedance Ltd. and/or its affiliate
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Constants for Slater-type orbitals."""

# Zeta and c coefficient for Slater-type orbitals reverse-fit from STO-6G
STO_6G_COEFFS = {
    'Al': {
        '1s': (12.557246008517494, 25.106698511179705),
        '2s': (4.359619258385573, 12.927028645707773),
        '3s': (1.6997831803065009, 0.7615604776424957),
        '2p': (6.554000435218195, 94.73883433477683),
        '3p': (2.2351712617093247, 1.3827832310783092),
    },
    'Ar': {
        '1s': (17.39539980503338, 40.93071746434361),
        '2s': (6.7395274109023875, 38.411458472102076),
        '3s': (2.329717983859512, 2.295580734042915),
        '2p': (10.084117748829376, 424.5775400483707),
        '3p': (3.060265563420203, 5.664664351842427),
    },
    'B': {
        '1s': (4.67868616774112, 5.70938862708008),
        '2s': (1.4999288235962795, 0.8976437475218287),
        '2p': (2.2716468438938575, 2.3554214877163155),
    },
    'Be': {
        '1s': (3.6790735046348035, 3.9812194646017587),
        '2s': (1.1499342729534248, 0.4619650556409617),
        '2p': (1.737594734756709, 0.9201071798798099),
    },
    'C': {
        '1s': (5.668891371758942, 7.615256589029782),
        '2s': (1.719877299055101, 1.2637414721616658),
        '2p': (2.603224975467389, 3.791736047605733),
    },
    'Ca': {
        '1s': (19.5709944613605, 48.83583953845113),
        '2s': (7.738732968586929, 54.260484887280676),
        '3s': (3.0096391625807035, 5.625243917454751),
        '4s': (1.3601380588639749, 0.12698321714720479),
        '2p': (11.44277220950772, 656.1541713931504),
        '3p': (3.951008639686456, 17.85199403770938),
        '4p': (1.6981898284489827, 0.14655638210969082),
    },
    'Cl': {
        '1s': (16.42714984359141, 37.564449406190995),
        '2s': (6.258720160253116, 31.915499495709224),
        '3s': (2.0997377724242736, 1.5955272516248895),
        '2p': (9.379020216891835, 331.94837422065166),
        '3p': (2.7582728076424314, 3.550609030735584),
    },
    'F': {
        '1s': (8.647725610389443, 14.3478532498991),
        '2s': (2.5498686974182796, 3.3822880320590616),
        '2p': (3.8381983263962307, 14.689479350772942),
    },
    'H': {
        '1s': (1.2396569932253754, 0.7786482598438814),
    },
    'He': {
        '1s': (1.6895399166477436, 1.2389169650053704),
    },
    'K': {
        '1s': (18.603597538983905, 45.2640252413769),
        '2s': (7.259222119835751, 46.24588987232522),
        '3s': (2.7496572800200547, 4.100159535853956),
        '4s': (1.4301411982280272, 0.1591563672673338),
        '2p': (10.773926382192002, 534.0140415145601),
        '3p': (3.62088857101528, 12.145661267587803),
        '4p': (1.7834260775485395, 0.19104940003516785),
    },
    'Li': {
        '1s': (2.689237663677221, 2.487921264218123),
        '2s': (0.7999592565921534, 0.18646529682488083),
        '2p': (1.2131148771860853, 0.2626425031316319),
    },
    'Mg': {
        '1s': (10.606505744603167, 19.48727485747987),
        '2s': (3.4797896476024155, 7.358433661799946),
        '3s': (1.7497617130189205, 0.8428386648793419),
        '2p': (5.214100079417301, 42.5456609714464),
        '3p': (2.304293894314714, 1.5934349371819814),
    },
    'N': {
        '1s': (6.668046567851146, 9.714119765863773),
        '2s': (1.9498640428999283, 1.7295555428587879),
        '2p': (2.953104555611183, 5.903584171692387),
    },
    'Na': {
        '1s': (10.606505744603167, 19.48727485747987),
        '2s': (3.4797896476024155, 7.358433661799946),
        '3s': (1.7497617130189205, 0.8428386648793419),
        '2p': (5.214100079417301, 42.5456609714464),
        '3p': (2.304293894314714, 1.5934349371819814),
    },
    'Ne': {
        '1s': (9.638169483462994, 16.882135191702933),
        '2s': (2.879839514936209, 4.5849782106230474),
        '2p': (4.313575648976462, 21.89010672369113),
    },
    'O': {
        '1s': (7.658312143014643, 11.957311431836787),
        '2s': (2.2498858861805417, 2.4735485371920998),
        '2p': (3.382554479984454, 9.404304291880152),
    },
    'P': {
        '1s': (14.49840434649223, 31.149470127449554),
        '2s': (5.3092768063608204, 21.157258029235972),
        '3s': (1.8997434641776487, 1.1239662327153015),
        '2p': (7.868086018599397, 177.5301649474899),
        '3p': (2.504478963796671, 2.3183467992744076),
    },
    'S': {
        '1s': (15.468177117665267, 34.325592817926776),
        '2s': (5.788995339687754, 26.26240044766998),
        '3s': (2.0497271436527353, 1.4664153516476472),
        '2p': (8.713206244747633, 257.8924790569185),
        '3p': (2.69317030051437, 3.1966886670849703),
    },
    'Si': {
        '1s': (13.528008654654725, 28.074801445575115),
        '2s': (4.8295674907671104, 16.69869883644322),
        '3s': (1.7497617129910332, 0.8428386647959631),
        '2p': (7.211841900405304, 131.56735728268595),
        '3p': (2.304293894345575, 1.5934349373181378),
    }
}
