# Implementation for paper [Quadratic Quantum Variational Monte Carlo]

## Overview
This repository contains the source code used for the experiments in our paper titled "[Quadratic Quantum Variational Monte Carlo]". The code is primarily based on two public repositories, which are organized here in two separate folders: `ferminet` and `LapNet`.

## Structure
- `ferminet/`: Contains the adapted codebase from the public repository of google-deepmind/ferminet.
- `LapNet/`: Contains the adapted codebase from the public repository of bytedance/LapNet.

Each folder contains its own README.md file with specific instructions on installation and execution of the code.

## Modifications
The code has been modified to implement our proposed algorithm, Q^2VMC, which enhances the performance of neural ansatze optimization based on original implementations of mdoel Psiformer and LapNet in `ferminet/` and `LapNet/`. Modifications are commented within the code files. 

## Configuration
To replicate the results presented in the paper or to experiment with the proposed enhancements:

### Using Q^2VMC
- Navigate to the `base_config.py` file in either `ferminet/ferminet/base_config.py` or `LapNet/lapnet/base_config.py`.
- Set the `use_quadratic` configuration parameter to `True`.

### Using Standard QVMC
- If you wish to use the standard QVMC method as implemented in the original repositories:
  - Set the `use_quadratic` configuration parameter in `base_config.py` to `False`.

## Running the Code
Please refer to the README.md files within each of the subfolders for detailed instructions on how to run the experiments and use the software. These instructions include details on dependencies, environment setup, and execution commands.

## License
This software is released under license Apache-2.0. Please see the LICENSE file in each subfolder for details pertaining to the original repositories' licenses.

