%% Test: PAGD & ANCGD on non-quadratic function
n = 512;
n1 = n+1;
a = 6/n1;
xaxis = -3+a:a:3-a;
yaxis = -3+a:a:3-a;
[X,Y]=meshgrid(xaxis,yaxis);
func1 = @(x,y) 1./(1.+exp(x.^2.))+(y-(x.^2.).*exp(-x.^2.)).^2-1.;
Z1 = func1(X,Y);
%%
eta = .03; % descent step size
r = 0.1; % radius of perturbation ball
M = 300; % # of samples

outcome_neon = zeros(1,M);
outcome_ancgd = zeros(1,M);
outcome_neonx = zeros(1,M);
outcome_ancgdx = zeros(1,M);
outcome_neony = zeros(1,M);
outcome_ancgdy = zeros(1,M);
T1 = 40;
T2 = 20;
    
% sample
    seed_neon = randsphere(M,2,r);
    seed_ancgd = randsphere(M,2,r);

% PGD & qPGD
tic
    for t = 1:M
        x0 = seed_neon(t,:)';
        xT = neon(x0,eta,T1);
        outcome_neonx(t) = xT(1);
        outcome_neony(t) = xT(2);
        outcome_neon(t) = f(xT);
        
        x0 = seed_ancgd(t,:)';
        xT = anc(x0,eta,T2,r);
        outcome_ancgdx(t) = xT(1);
        outcome_ancgdy(t) = xT(2);
        outcome_ancgd(t) = f(xT);
    end
tEnd=toc;
fprintf('Test neon_decrease, running time = %d\n',tEnd);

%% plot 
figure(1)
subplot(1,3,1)
scatter(outcome_neonx,outcome_neony,30,'.','r');
hold on
contour(X,Y,Z1, [-0.95,-0.8,-0.6,-0.4,0,1,2],'ShowText','on');
set(gca,...
    'TickDir','out','TickLength',[0.02 0.02],...
    'FontSize',12,'FontName','Times');
set(gcf, 'units','points','position',[0 0 1000 400]);
xticks([-2,-1,0,1,2]);
yticks([-2,-1,0,1,2]);
xlabel('X')
ylabel('Y')
legend('NEON+ sampling','landscape')
title('t_{NEON} = 40');

subplot(1,3,2)
scatter(outcome_ancgdx,outcome_ancgdy,30,'.','b');
hold on
contour(X,Y,Z1, [-0.95,-0.8,-0.6,-0.4,0,1,2],'ShowText','on');
set(gca,...
    'TickDir','out','TickLength',[0.02 0.02],...
    'FontSize',12,'FontName','Times');
set(gcf, 'units','points','position',[0 0 1000 400]);
xticks([-2,-1,0,1,2]);
yticks([-2,-1,0,1,2]);
xlabel('X')
ylabel('Y')
legend('ANCGD sampling','landscape')
title('t_{ANCGD} = 20');

subplot(1,3,3)
binRange = -1:0.1:-0.6;
hcx = histcounts(outcome_ancgd(:),[binRange Inf]);
hcy = histcounts(outcome_neon(:),[binRange Inf]);
b = bar(binRange,[hcx;hcy]);
b(1).FaceColor = [0 .3 .9];
b(2).FaceColor = [.9 .2 .1];
xtips1 = b(1).XEndPoints;
ytips1 = b(1).YEndPoints;
labels1 = string(b(1).YData);
text(xtips1,ytips1,labels1,'HorizontalAlignment','center',...
    'VerticalAlignment','bottom')
xtips2 = b(2).XEndPoints;
ytips2 = b(2).YEndPoints;
labels2 = string(b(2).YData);
text(xtips2,ytips2,labels2,'HorizontalAlignment','center',...
    'VerticalAlignment','bottom')
set(gca,...
    'XDir','reverse',...
        'FontSize',12,'FontName','Times');
xticks([-1 -0.9 -0.8 -0.7 -0.6]);
xticklabels({'[-1,-0.9]','(-0.9,-0.8]','(-0.8,-0.7]','(-0.7,-0.6]','>-0.6'});
xlabel('Descent value')
ylabel('Frequency')
legend('ANCGD','PAGD','Location','northwest');
title('descent value sampling at t_{NEON} = 40, t_{ANCGD} = 20')



%%

function x = anc(x0,eta,T,r)
v0 = 0;
for k = 1:T
    v = v0 - eta.*grad(x0);
    x = x0 + v;
    v0 = v * r / norm(x);
    x0 = x * r / norm(x);
end
x = 2 * x / norm(x);
end

function res = neon(x0,eta,T)
v = 0;
res = x0;
for k = 1:T
    y = x0 + 0.9 * v;
    x = y - eta.*grad(y);
    v = x - x0;
    x0 = x;
    if (f(x)<f(res))
        res = x;
    end
end
res = 2 * res / norm(res);
end

function y = f(x)
y = 1/(1+exp(x(1)^2))+(x(2)-x(1)^2*exp(-x(1)^2))^2-1;
end

function v = grad(x)
v = [-2*x(1)*exp(x(1)^2)/(1+exp(x(1)^2)^2)-4*x(1)*exp(-x(1)^2)*(1-x(1)^2)*(x(2)-x(1)^2*exp(-x(1)^2)) ; 2 * (x(2)-x(1)^2*exp(-x(1)^2))];
end


