Include = 'keywords.g'
#Include = 'kin-stickHandover.g'

FOL_World{
  hasWait=false
  gamma = 1.
  stepCost = 1.
  timeCost = 0.
}

## activities
grasping
placing
handing
attaching
pushing

## basic predicates
gripper
object
table
wall
attachable
pusher
partOf
world

on
busy     # involved in an ongoing (durative) activity
animate  # the object is in principle movable
free     # gripper hand is free
held     # object is held by an gripper
notheld  # triggers the rule to set !held for all parts
grasped  # gripper X holds/has grasped object Y
placed   # gripper X holds/has grasped object Y
attached
hasScrew # gripper X holds a screw (screws are not objects/constrants, just a predicate of having a screw...)
fixed    # object X and Y are fixed together
never    # (for debugging)

## KOMO symbols
inside
above
lift
notAbove

touch
impulse
stable
stableOn
dynamic
dynamicOn
dynamicTrans
liftDownUp

fricSlide
dynamicVert
flagClear

## constants (added by the code)
redBall
blueBall
bucket

## initial state (generated by the code)
START_STATE {}

### RULES

#####################################################################

#termination rule
Rule {
  { (held redBall) }
  { (QUIT) }
}

Rule {
  { (on blueBall bucket) }
  { (QUIT) }
}

### Reward
REWARD {
#  tree{
#    leaf{ { (grasped handR screwdriverHandle) }, r=10. }
#    weight=1.
#  }
}

#####################################################################

DecisionRule grasp {
  X, Y
  { (gripper X) (object Y) (busy X)! (held Y)! (INFEASIBLE grasp X Y)! }
  { (grasped X Y) (held Y) (animate Y) (busy X) komo(flagClear Y) komo(touch X Y) (dynamic Y)! (dynamicOn ANY Y)! (stable ANY Y)! (stableOn ANY Y)! (stable X Y) komo(liftDownUp X) } #komo(grasp X Y) } #komo(lift X)
}

#####################################################################

DecisionRule handover {
  X, Y, Z
  { (INFEASIBLE handover X Y Z)! (grasped X Y) (gripper X) (gripper Z) (object Y) (busy Z)! }
  { (grasped X Y)! (grasped Z Y) (busy X)! (busy Z) komo(flagClear Y) komo(touch Z Y) (dynamic Y)! (dynamicOn ANY Y)! (stable ANY Y)! (stableOn ANY Y)! (stable Z Y) } #komo(handover X Y Z) }
}

#####################################################################

DecisionRule place {
  X, Y, Z,
  { (grasped X Y) (table Z) (held Y) }
  { (placed Y Z) (on Y Z) (grasped X Y)! (busy X)! (busy Y)! (notheld Y) (INFEASIBLE grasp ANY Y)! block(INFEASIBLE grasp ANY Y)  komo(flagClear Y) komo(above Y Z) (stableOn Z Y) (dynamic Y)! (dynamicOn ANY Y)! (stable ANY Y)! } #komo(place X Y Z)=1. }
}

#####################################################################

DecisionRule place2 {
  OBJ, TAB,
  { (never) (animate TAB) (object OBJ) (table TAB) }
  { (placed OBJ TAB) (busy OBJ)! (on OBJ ANY)! (on OBJ TAB) (INFEASIBLE grasp ANY OBJ)! block(INFEASIBLE grasp ANY OBJ) komo(flagClear OBJ) komo(above OBJ TAB) (stableOn TAB OBJ) (dynamic OBJ)! (dynamicOn ANY OBJ)! (stable ANY OBJ)! } #komo(place OBJ TAB)=1. }
}

#####################################################################

DecisionRule place3 {
  OBJ, TAB,
  { (animate OBJ) (object OBJ) (held OBJ)! (table TAB) }
  { (placed OBJ TAB) (busy OBJ)! (on OBJ ANY)! (on OBJ TAB) (INFEASIBLE grasp ANY OBJ)! block(INFEASIBLE grasp ANY OBJ) komo(flagClear OBJ) komo(above OBJ TAB) (stableOn TAB OBJ) (dynamic OBJ)! (dynamicOn ANY OBJ)! (dynamicTrans OBJ)! (stable ANY OBJ)! } #komo(place OBJ TAB)=1. }
}

#####################################################################

DecisionRule throw {
  X, OBJ,
  { (held OBJ) (object OBJ) (grasped X OBJ) }
  { (notheld OBJ) (grasped X OBJ)! (busy X)! (dynamicTrans OBJ) (dynamicOn ANY OBJ)! (stable ANY OBJ)! (stableOn ANY OBJ)! } # komoThrow(OBJ)=1. }
}

#####################################################################

DecisionRule hit {
  BAT, OBJ,
  { (held BAT) (object BAT) (object OBJ) (partOf BAT OBJ)! (partOf OBJ BAT)! (partOf BAT OBJ)! }
  { (animate OBJ) (on OBJ ANY)! komo(touch BAT OBJ) komo(impulse BAT OBJ) (dynamicTrans OBJ)  } # komoHit(BAT, OBJ) }
}

#####################################################################

DecisionRule hitSlide {
  BAT, OBJ, TABLE
  {  (object BAT) (object OBJ) (table TABLE) (on OBJ TABLE) (partOf OBJ BAT)! (partOf BAT OBJ)! }
  { (animate OBJ) komo(touch BAT OBJ) komo(impulse BAT OBJ) (dynamicOn TABLE OBJ) (dynamic OBJ)! (stable ANY OBJ)! (stableOn ANY OBJ)! komo(fricSlide BAT TABLE)! } # komoHit(BAT OBJ TABLE) }
}

#####################################################################
#same as above, but only when OBJ is flying with fricSlide

DecisionRule hitSlideAndSit {
  BAT, OBJ, TABLE
  { (animate BAT) (held BAT)! (object BAT) (object OBJ) (table TABLE) (on OBJ TABLE) (partOf OBJ BAT)! (partOf BAT OBJ)! }
  { (animate OBJ) komo(touch BAT OBJ) komo(impulse BAT OBJ) (dynamicOn TABLE OBJ) (dynamic OBJ)! (stable ANY OBJ)! (stableOn ANY OBJ)!  komo(fricSlide BAT TABLE) } # komoHit(BAT OBJ TABLE) }
}


#####################################################################

DecisionRule push {
  X, Y, Z,
  { (held X) (pusher X) (busy X)! (object Y) (table Z) (held Y)! (on Y Z) }
  { (animate Y)  komo(push X Y Z) (INFEASIBLE grasp ANY Y)! block(INFEASIBLE grasp ANY Y) } #(busy X)
}

#####################################################################

#DecisionRule push2 {
#  X, Y, Z,
#  { (held X) (pusher X) (object Y) (table Z) (held Y)! }
#  { komo(push X Y Z) (grasped X Y) (INFEASIBLE grasp ANY Y)! block(INFEASIBLE grasp ANY Y) }
#}

#####################################################################

DecisionRule graspSlide {
  X, Y, Z,
  { (gripper X) (object Y) (table Z) (busy X)! (on Y Z) }
  { (busy X) (animate Y) (held Y) (grasped X Y) komo(graspSlide X Y Z) (dynamic Y)! (dynamicOn ANY Y)! (stableOn ANY Y)! (INFEASIBLE grasp ANY Y)! block(INFEASIBLE grasp ANY Y) }
}

#####################################################################

DecisionRule slideAlong {
  A, X, Y,
  { (held A) (object X) (wall Y) }
  { komoSlideAlong(A X Y)=1. }
}

#####################################################################

DecisionRule drop {
  OBJ, FROM, TO,
  { (never) (held OBJ)! (object OBJ) (table FROM) (table TO) (on OBJ FROM) }
  { (grasped world OBJ) (on OBJ FROM)! (INFEASIBLE grasp ANY OBJ)! block(INFEASIBLE grasp ANY OBJ) komo(notAbove OBJ FROM) komo(dynamicVert OBJ TO) } #komoDrop(OBJ FROM TO)=1. }
#  { (grasped world OBJ) (on OBJ FROM)! (INFEASIBLE grasp ANY OBJ)! block(INFEASIBLE grasp ANY OBJ) komo(dynamicVert OBJ TO) } #komoDrop(OBJ FROM TO)=1. }
}

#####################################################################

#Rule {
#  A, B
#  { (on A B) }
#  { komo(above A B) }
#}

Rule {
  A, B
  { (held A) (partOf A B) }
  { (held B) (animate B) }
}

Rule {
  A, B
  { (held A) (partOf B A) }
  { (held B) (animate A) }
}

Rule {
  A, B
  { (notheld A) (partOf A B) }
  { (held A)! (held B)! (animate A)! (animate B)! }
}

Rule {
  A, B
  { (notheld B) (partOf A B) }
  { (held A)! (held B)! (animate A)! (animate B)! }
}

Rule {
  A
  { (notheld A) }
  { (held A)! }
}
