import argparse

NUMERICAL_OUTPUT_TASKS = {
    "object_counting",
    "multistep_arithmetic_two",
}

MULTIPLE_CHOICE_TASKS = {
    "date_understanding",
    "disambiguation_qa",
    "geometric_shapes",
    "hyperbaton",
    "logical_deduction_five_objects",
    "logical_deduction_seven_objects",
    "logical_deduction_three_objects",
    "movie_recommendation",
    "penguins_in_a_table",
    "reasoning_about_colored_objects",
    "ruin_names",
    "salient_translation_error_detection",
    "snarks",
    "temporal_sequences",
    "tracking_shuffled_objects_five_objects",
    "tracking_shuffled_objects_seven_objects",
    "tracking_shuffled_objects_three_objects",
}

BOOLEAN_TASKS = {
    "boolean_expressions",  # True or False
    "causal_judgement",  # yes or no
    "formal_fallacies",  # valid or invalid
    "navigate",  # yes or no
    "sports_understanding",  # yes or no
    "web_of_lies",  # yes or no
    "sentiment_analysis",  # non-negative or negative
}

PROJECT_FOLDER = "../../test"

BBH_DATA_FOLDER = "../../test/test_datasets"


def get_args():
    """This function provides all related arguments.
    return: args
    """
    parser = argparse.ArgumentParser(description="Proposed Framework Implementation")
    parser.add_argument(
        "--dataset_name", default="bbh", choices=["bbh", "internal_sa"], help="Dataset to proceed"
    )
    parser.add_argument(
        "--task_name", default="logical_deduction_three_objects", type=str, help="Task to process"
    )
    parser.add_argument(
        "--experiment_folder",
        default="results_finalized_bbh",
        type=str,
        help="Save specific experimental results",
    )
    parser.add_argument("--eval_prefix", default="", type=str, help="File prefix for evaluation")
    parser.add_argument("--re_eval", action="store_true", help="Whether eval file contains results")
    parser.add_argument(
        "--initial_prompt",
        default="Let's solve the problem",
        type=str,
        help="The prompt to start with",
    )
    parser.add_argument("--do_train", action="store_true", help="Whether to train")
    parser.add_argument("--do_eval", action="store_true", help="Whether to evaluate")
    parser.add_argument("--temperature", default=1.0, type=float, help="Temperature")
    parser.add_argument("--top_p", default=1.0, type=float, help="top_p")
    parser.add_argument("--top_k", default=1.0, type=float, help="top_k")
    parser.add_argument("--max_tokens", default=1.0, type=float, help="maximum generated tokens")
    parser.add_argument("--steps", default=2, type=int, help="The number of generated iteration")
    parser.add_argument("--batch_size", default=50, type=int, help="Batch size to inference")
    parser.add_argument(
        "--num_candidates", default=10, type=int, help="number of prompt candidates"
    )
    parser.add_argument("--num_hints", default=3, type=int, help="number of hints to generate")
    parser.add_argument(
        "--prompt_limit", default=4095, type=int, help="maximum length of input prompts"
    )
    parser.add_argument(
        "--optimization_strategy", default="optimization", choices=["optimization", "adaptation"]
    )
    parser.add_argument(
        "--model_id",
        default="anthropic.claude-3-sonnet-20240229-v1:0",
        type=str,
        help="LLM API call",
    )
    parser.add_argument(
        "--prev_model_id", default="", type=str, help="Should provide if adapting across models"
    )
    parser.add_argument("--flipping_strategy", default="c->w", choices=["w->w", "c->w", "w->c"])
    args = parser.parse_args()
    return args
