import logging
import time

from prompt_optimization_lcp import arguments, train
from prompt_optimization_lcp.arguments import BBH_DATA_FOLDER, BOOLEAN_TASKS, PROJECT_FOLDER

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


def main():
    args = arguments.get_args()
    if args.optimization_strategy == "adaptation":
        assert args.prev_model_id != ""
    timestr = time.strftime("%Y%m%d-%H%M%S")
    args.prefix = f"{timestr}"
    args.output_folder = train.generate_output_folder(PROJECT_FOLDER, args.experiment_folder)
    data_folder = ""
    if args.dataset_name == "bbh":
        data_folder = BBH_DATA_FOLDER
    else:
        raise NotImplementedError("Please check your dataset!")
    args.dataset, args.train_index, args.test_index = train.test_train_split(
        data_folder, args.task_name
    )
    args.is_boolean = True if args.task_name in BOOLEAN_TASKS else False
    logger.info(f"Task to proceed: {args.task_name}")
    if args.do_train:
        train.train(args)
    return


if __name__ == "__main__":
    main()
