# this file contains all the prompt templates used in our approach


def generate_prompt_for_hint_generation():
    """Provide a prompt template for hint generation.
    return: prompt template
    """
    hint_prompt = "Given input: <INPUT>\nAnd its expected output: <OUTPUT>\nList the reason or hint why its with this expected output within tag <hint> and </hint>. The hint or explaination should be necassarily between the tags."
    return hint_prompt


def generate_prompt_for_hint_summarization():
    """Provide a prompt template for hint summarization.
    return: prompt template
    """
    summarize_prompt = "We have some expected input and output pairs and have asked labeler to give reason or hint for each expected output. Given following data each contains input, output and reason for the expected output, summarize a general reason for all these cases:\n<HINTS>\nGive a summary of the reasons for the example output, and do not give a reason particular to the respective example. Also do not mention the number of examples nor give any reference to entities in examples in the summary directly or indirectly. Be as general as possible. Put the summarized reasons within tag <hint> and </hint>:"
    return summarize_prompt


def generation_high_level_prompt(dataset_name, task_name, prompt_candidates):
    """Provide a prompt template for prompt generation
    return: prompt template
    """
    good_cands_list = [
        f"Prompt_{i+1}:\n{prompt_cand[0]}\nScore_{i+1}: {prompt_cand[1]}\n"
        for i, prompt_cand in enumerate(prompt_candidates[:3])
    ]
    good_cands = "".join(good_cands_list)
    bad_cands_list = [
        f"Prompt_{i+1}:\n{prompt_cand[0]}\nScore_{i+1}: {prompt_cand[1]}\n"
        for i, prompt_cand in enumerate(prompt_candidates[-3:])
    ]
    bad_cands = "".join(bad_cands_list)
    generation_prompt = f"Given 3 examples of good prompts and their corresponding scores and 3 examples of bad prompts and their corresponding scores, explore the underlying pattern of good prompts, generate a new prompt based on this pattern. Put the new prompt within tag <prompt> and </prompt>.\nGood prompts and scores:\n{good_cands}Bad prompts and scores:\n{bad_cands}"
    return generation_prompt
