from osls import OSLSModel
import argparse
import math


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--context_smiles', type=str)
    parser.add_argument('--context_affinity', type=float)
    parser.add_argument('--query_smiles', type=str)
    parser.add_argument('--model_file', type=str)
    args = parser.parse_args()
    model = OSLSModel(args.model_file)
    print(10 ** model.predict([(args.context_smiles, math.log10(args.context_affinity + 1e-10))], args.query_smiles) - 1e-10)
