# MRAugment
This is the supplementary code for the ICLR2021 submission *Data augmentation for deep learning based accelerated MRI reconstruction*.

## Requirements
CUDA-enabled GPU is necessary to run the code. We tested this code using:
- Ubuntu 18.04
- CUDA 11.0
- Python 3.7

## Installation
To install the necessary packages, create a new virtual environment and run
```
    pip install -r requirements.txt.
    pip install git+https://github.com/ismrmrd/ismrmrd-python.git
```

## Dataset
FastMRI is an open dataset, however you need to apply for access at https://fastmri.med.nyu.edu/. To replicate our results, you need the download the
following files:
- knee_singlecoil_train.tar.gz
- knee_singlecoil_val.tar.gz
- knee_multicoil_train.tar.gz
- knee_multicoil_val.tar.gz

After downloading these files, extract them into the same directory. We refer to this directory as **$DATA_DIR$**. Make sure that **$DATA_DIR$** contains exactly the following folders:
- singlecoil_train
- singlecoil_val
- multicoil_train
- multicoil_val

## Training
The configuration file for each experiment can be found in the `experiments` folder in `.yaml` format. The naming format is as follows:

```$TRACK$ _ train$SIZE$ _$DATYPE$.yaml```

Where:
- **$TRACK$** is either 'singlecoil' or 'multicoil' depending on the acquisition type
- **$SIZE$** is the percentage of full training data used, for instance **$SIZE$=33** means 33% of training data used
- **$DATYPE$** is optional, if **$DATYPE$=DA** then our data augmentation will be used, if  **$DATYPE$=DA_naive** then naive data augmentation is used, and no augmentation is applied otherwise.

To train the model run the following in the terminal:
```
python train_varnet_DA.py --data-path $DATA_DIR$ \
                          --load-config experiments/$CONFIG$ \
                          --exp-dir $OUT_DIR$
```
Here substitute **$CONFIG$** for the selected experiment's `.yaml` file. The trained model will be saved at **$OUT_DIR$**.

## Evaluating models
To evaluate a trained model on the validation dataset, run
```
python train_varnet_DA.py --mode eval \
                          --data-path $DATA_DIR$\
                          --checkpoint $CKPT_PATH$
```
Here **$CKPT_PATH$** is the path to the saved `.ckpt` checkpoint file of the model to be evaluated.

## Custom training
To experiment with different data augmentation settings see all available training options by running
```
python train_varnet_DA.py --help
```
Alternatively, the `.yaml` files in `experiments` can be customized and used as config files as described before.

## Acknowledgment
Our source code builds on the fastMRI code base found at https://github.com/facebookresearch/fastMRI. Some of our code have been adapted from scripts from the fastMRI repository.
