import sys, os, hashlib
import pathlib
from common.args import Args
import yaml

def load_args(args):
    config_file = args.load_config
    if config_file.exists():
        with config_file.open('r') as f:
            d = yaml.safe_load(f)
            for k,v in d.items():
                setattr(args, k, v)
    else:
        print('Config file does not exist.')
    return args
