import pynvml
import time
import sys
import os

env_names={'Alien-v5':{'llm_temperature':1,'adjust_frequency':1,'sample_rate':100}}

pynvml.nvmlInit()  # 初始化
min_memory = 1 # GB
target_device = [1]

# deviceCount = pynvml.nvmlDeviceGetCount()  # 获得计算机中GPU的个数
# target_device= range(deviceCount)

for env_name,paras in env_names.items():
    llm_temperature=paras['llm_temperature']
    adjust_frequency=paras['adjust_frequency']
    sample_rate=paras['sample_rate']

    task_list=[
        f'python DQN.py --env_name {env_name} --manual_seed 1 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',
        f'python DQN.py --env_name {env_name} --manual_seed 2 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',
        f'python DQN.py --env_name {env_name} --manual_seed 3 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',


        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_main --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_main --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_main --cpu_num 1 --LLM_max_try 100',


        f'python DQN_LLM_ablation.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_ablation --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM_ablation.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_ablation --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM_ablation.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_ablation --cpu_num 1 --LLM_max_try 100',


        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-2024-08-06 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-2024-08-06 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-2024-08-06 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',

        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-3.5-turbo-0125 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-3.5-turbo-0125 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-3.5-turbo-0125 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',

        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name Llama-3.1-405B-Instruct --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name Llama-3.1-405B-Instruct --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name Llama-3.1-405B-Instruct --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',

        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name Llama-3.1-70B-Instruct --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name Llama-3.1-70B-Instruct --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name Llama-3.1-70B-Instruct --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_llmtype --cpu_num 1 --LLM_max_try 100',


        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type name --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_prompt --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type name --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_prompt --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type name --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_prompt --cpu_num 1 --LLM_max_try 100',


        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {2*adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adjust --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {2*adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adjust --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {2*adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adjust --cpu_num 1 --LLM_max_try 100',

        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {3*adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adjust --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {3*adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adjust --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {3*adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adjust --cpu_num 1 --LLM_max_try 100',


        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {2*sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_sample --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {2*sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_sample --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {2*sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_sample --cpu_num 1 --LLM_max_try 100',

        f'python DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {int(0.5*sample_rate)} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_sample --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {int(0.5*sample_rate)} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_sample --cpu_num 1 --LLM_max_try 100',
        f'python DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {int(0.5*sample_rate)} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_sample --cpu_num 1 --LLM_max_try 100',


        f'python Vanilla_DQN.py --env_name {env_name} --manual_seed 1 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --save_interval 50 --save_folder model_base --cpu_num 1',
        f'python Vanilla_DQN.py --env_name {env_name} --manual_seed 2 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --save_interval 50 --save_folder model_base --cpu_num 1',
        f'python Vanilla_DQN.py --env_name {env_name} --manual_seed 3 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --save_interval 50 --save_folder model_base --cpu_num 1',

        f'python Vanilla_DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python Vanilla_DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python Vanilla_DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',

        f'python PER_DQN.py --env_name {env_name} --manual_seed 1 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',
        f'python PER_DQN.py --env_name {env_name} --manual_seed 2 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',
        f'python PER_DQN.py --env_name {env_name} --manual_seed 3 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',

        f'python PER_DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python PER_DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python PER_DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',

        f'python Dueling_DQN.py --env_name {env_name} --manual_seed 1 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',
        f'python Dueling_DQN.py --env_name {env_name} --manual_seed 2 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',
        f'python Dueling_DQN.py --env_name {env_name} --manual_seed 3 --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_base --cpu_num 1',

        f'python Dueling_DQN_LLM.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python Dueling_DQN_LLM.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python Dueling_DQN_LLM.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --batch_size 256 --start_epsilon 1 --min_epsilon 0.1 --epsilon_decay 0.99999 --gamma 0.99 --learning_rate 0.0001 --buffer_size 10000 --target_update_interval 1000 --save_interval 50 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',

        f'python ./Rainbow_DQN/train.py --env_name {env_name} --manual_seed 1 --episodes 1000 --max_step 310000 --save_folder model_base --cpu_num 1',
        f'python ./Rainbow_DQN/train.py --env_name {env_name} --manual_seed 2 --episodes 1000 --max_step 310000 --save_folder model_base --cpu_num 1',
        f'python ./Rainbow_DQN/train.py --env_name {env_name} --manual_seed 3 --episodes 1000 --max_step 310000 --save_folder model_base --cpu_num 1',

        f'python ./Rainbow_DQN_LLM/train.py --env_name {env_name} --manual_seed 1 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python ./Rainbow_DQN_LLM/train.py --env_name {env_name} --manual_seed 2 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python ./Rainbow_DQN_LLM/train.py --env_name {env_name} --manual_seed 3 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --episodes 1000 --max_step 310000 --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',

        f'python ./CURL/main.py --game {env_name} --seed 1 --episodes 1000 --max_step 310000 --save_folder model_base --cpu_num 1',
        f'python ./CURL/main.py --game {env_name} --seed 2 --episodes 1000 --max_step 310000 --save_folder model_base --cpu_num 1',
        f'python ./CURL/main.py --game {env_name} --seed 3 --episodes 1000 --max_step 310000 --save_folder model_base --cpu_num 1',

        f'python ./CURL_LLM/main.py --game {env_name} --seed 1 --episodes 1000 --max_step 310000 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python ./CURL_LLM/main.py --game {env_name} --seed 2 --episodes 1000 --max_step 310000 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
        f'python ./CURL_LLM/main.py --game {env_name} --seed 3 --episodes 1000 --max_step 310000 --LLM_name gpt-4o-mini-2024-07-18 --LLM_temperature {llm_temperature} --adjust_frequency {adjust_frequency} --sample_rate {sample_rate} --prompt_type full --save_folder model_adaption --cpu_num 1 --LLM_max_try 100',
    ]

    for task in task_list:
        while True:
            available_device=-1
            for i in target_device:
                handle = pynvml.nvmlDeviceGetHandleByIndex(i)
                info = pynvml.nvmlDeviceGetMemoryInfo(handle)
                print('Device %d has %f GB memory available'%(i,info.free/1024/1024/1024))
                if info.free/1024/1024/1024>=min_memory:
                    available_device = i
                    break
            
            if available_device!=-1:
                os.system('CUDA_VISIBLE_DEVICES=%d %s &'%(available_device,task))
                print('Task %s is running on device %d'%(task,available_device))
                time.sleep(30)
                break
            else:
                print('No available device, waiting for 10s')
                time.sleep(30)
            sys.stdout.flush()