# Contributing to SCDS

Thank you for your interest in contributing to the SCDS project! We're excited to have you on board and will do our best to assist you throughout the process. All contributions, big or small, are greatly appreciated and help make the project even better.

Before you begin, we encourage you to start a discussion regarding any significant changes by creating an issue or reaching out via email or other communication methods with the project maintainers. This ensures that your contribution aligns with the project’s goals and is recognized as an improvement. However, feel free to skip this step for minor adjustments.

## Pull Request Guidelines

To help streamline the contribution process, please follow these steps:

1. **Dependency Management**: Ensure any new installation or build dependencies are added to the docker image.
2. **Documentation**: Update the ReadMe and tutorials with any changes that affect the interface or core functionality.
3. **Code Style**: Maintain compatibility with the project's coding standards and [Python PEP 8 style guide](https://peps.python.org/pep-0008/).
4. **Clarity and Readability**: Focus on writing clear, maintainable code that others can easily understand.
5. **Pull Request Submission**: Once your work is complete, submit a pull request to merge your changes into the repository.

