#!/bin/bash

# Full batch
python periodic-linearisation.py --dataset CIFAR10 --model lenet-large --optimizer sgd --batch-size 250 --full-batch --learning-rate 1e-3 --epochs 100000 -k 1 --eval-frequency 1000 --tag full-batch-cifar
python periodic-linearisation.py --dataset CIFAR10 --model lenet-large --optimizer sgd --batch-size 250 --full-batch --learning-rate 1e-3 --epochs 100000 -k 10000 --eval-frequency 1000 --tag full-batch-cifar

# Mini-batch
python periodic-linearisation.py --dataset CIFAR10 --model lenet-large --optimizer sgd --batch-size 250 --learning-rate 1e-4 --epochs 20000 -k 1 --eval-frequency 1000 --tag sgd-cifar
python periodic-linearisation.py --dataset CIFAR10 --model lenet-large --optimizer sgd --batch-size 250 --learning-rate 1e-4 --epochs 10000 -k 100000 --eval-frequency 1000 --tag sgd-cifar

# With data augmentations

python periodic-linearisation.py --dataset CIFAR10 --model lenet-large --optimizer sgd --batch-size 250 --include-flip --random-crop --learning-rate 1e-5 --epochs 200000 -k 5000000 --eval-frequency 1000 --tag data-aug
python periodic-linearisation.py --dataset CIFAR10 --model lenet-large --optimizer sgd --batch-size 250 --include-flip --random-crop --learning-rate 1e-5 --epochs 200000 -k 1 --eval-frequency 1000 --tag data-aug

# Optimising to convergence
# K=1 SGD run above with tag sgd-cifar
python periodic-linearisation.py --dataset CIFAR10 --model lenet-large --optimizer adam --batch-size 250 --learning-rate 1e-4 --epochs 20000 -k 200000 --eval-frequency 1000 --tag adam-il



