import argparse
import os, io

# Setup command line argument parsing
parser = argparse.ArgumentParser(description='Shuffle and dump data.')
parser.add_argument('--save_path', type=str, required=True, help='Path where the shuffled data will be saved')
parser.add_argument('--data_path', type=str, required=True, help='Path to the data to be processed')
args = parser.parse_args()

s_path = args.save_path
d_path = args.data_path

skip = False
s_lines = []

with io.open(d_path, mode='r', encoding='utf-8') as f:
    for i, line in enumerate(f):
        print(f'Number of test expressions: {len(s_lines)}', end='\r')
        if skip:
            if line == '\n':
                res = prev_line.split('\t\t')[-1].strip()
                testline = integral + '\t' + res
                s_lines.append(testline)
                skip = False
            prev_line = line
            continue

        integral = line.split('\t\t')[0].strip()
        skip = True
        prev_line = line
    print()

with io.open(s_path, mode='w', encoding='utf-8') as f:
    for line in s_lines:
        f.write(line)
        f.write('\n')

