import sympy as sp
import io
import timeout_decorator
from alpha_integrate.synthetic_data.expression_tokenizer import ExpressionTokenizer

class TimeoutErr(Exception):
    pass

def main(args):
    
    dataset = args.dataset

    @timeout_decorator.timeout(args.timeout, timeout_exception=TimeoutErr)
    def manual_integrate(expr: sp.Expr, x: sp.Symbol):
        return sp.integrate(expr, x, manual=True)

    e = ExpressionTokenizer()
    expression_path = f'alpha_integrate/train/temp_files/expression_temp_{dataset}.txt'
    result_path = f'alpha_integrate/train/temp_files/result_temp_{dataset}.txt'

    with io.open(expression_path, mode='r', encoding='utf-8') as f:
        for l in f:
            line = l.split()
            break

    sp_expr = e.seq_to_sp(line)
    x = sp.Symbol('x')

    try:
        integral = manual_integrate(sp_expr, x)
        integral = ' '.join(e.sp_to_seq(integral))
    except TimeoutErr:
        integral = 'TimeoutError'
    except:
        integral = 'Error'

    with io.open(result_path, mode='w', encoding='utf-8') as f:
        f.write(str(integral))

if __name__ == '__main__':
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument('--dataset', type=str, default=None)
    parser.add_argument('--timeout', type=int, default=5)
    args = parser.parse_args()
    main(args)