import sympy as sp

OPERATORS = {
        # Elementary functions
        'add': 2,
        'sub': 2,
        'mul': 2,
        'div': 2,
        'pow': 2,
        'rac': 2,
        'sqrt': 1,
        'exp': 1,
        'ln': 1,
        'abs': 1,
        'sign': 1,
        # Trigonometric Functions
        'sin': 1,
        'cos': 1,
        'tan': 1,
        'cot': 1,
        'sec': 1,
        'csc': 1,
        # Trigonometric Inverses
        'asin': 1,
        'acos': 1,
        'atan': 1,
        'acot': 1,
        'asec': 1,
        'acsc': 1,
        # Hyperbolic Functions
        'sinh': 1,
        'cosh': 1,
        'tanh': 1,
        'coth': 1,
        'sech': 1,
        'csch': 1,
        # Hyperbolic Inverses
        'asinh': 1,
        'acosh': 1,
        'atanh': 1,
        'acoth': 1,
        'asech': 1,
        'acsch': 1,
}

OPERATOR_TO_SYMPY = {
    'add': sp.Add,
    'mul': sp.Mul,
    'pow': sp.Pow,
    'exp': sp.exp,
    'ln': sp.log,
    'abs': sp.Abs,
    'sign': sp.sign,
    'sqrt': sp.sqrt,
    'sin': sp.sin,
    'cos': sp.cos,
    'tan': sp.tan,
    'cot': sp.cot,
    'sec': sp.sec,
    'csc': sp.csc,
    'asin': sp.asin,
    'acos': sp.acos,
    'atan': sp.atan,
    'acot': sp.acot,
    'asec': sp.asec,
    'acsc': sp.acsc,
    'sinh': sp.sinh,
    'cosh': sp.cosh,
    'tanh': sp.tanh,
    'coth': sp.coth,
    'sech': sp.sech,
    'csch': sp.csch,
    'asinh': sp.asinh,
    'acosh': sp.acosh,
    'atanh': sp.atanh,
    'acoth': sp.acoth,
    'asech': sp.asech,
    'acsch': sp.acsch,
}

SYMBOLS = {
    'x': sp.Symbol('x'),
    'y': sp.Symbol('y'),
    'z': sp.Symbol('z'),
    't': sp.Symbol('t'),
}

CONSTANTS = {
    'pi': sp.pi,
    'E': sp.E,
}