from sympy.integrals.manualintegrate import *

# Rules that do not have any substeps
SIMPLE_STEPS = (ConstantRule, PowerRule, ExpRule, TrigRule, HyperbolicRule, ReciprocalRule, NestedPowRule,
               ArcsinRule, ArcsinhRule, SinRule, CosRule, SecTanRule, CscCotRule, Sec2Rule, Csc2Rule, SinhRule, 
               CoshRule, ArctanRule, ReciprocalSqrtQuadraticRule) # (SqrtQuadraticDenomRule, SqrtQaudraticRule))

SPECIAL_SIMPLE_STEPS = (OrthogonalPolyRule, JacobiRule, GegenbauerRule, ChebyshevTRule, ChebyshevURule, 
                        LegendreRule, HermiteRule, LaguerreRule, AssocLaguerreRule, IRule, CiRule, SiRule,
                        ChiRule, EiRule, ShiRule, LiRule, ErfRule, FresnelSRule, FresnelCRule, PolylogRule,
                        UpperGammaRule, EllipticERule, EllipticFRule)

# temporarily restrict SPECIAL_SIMPLE_STEPS to only include the following rules
SPECIAL_SIMPLE_STEPS = (CiRule, EiRule, UpperGammaRule)

OTHER_INTEGRAL_STEPS = (AddRule, ConstantTimesRule, URule, PartsRule)

REWRITE_STEPS = ('PartialFractions', 'Cancel', 'Expand', 'Tan1', 'Cot1', 'Cos1', 'Sec1', 'Csc1', 
                 'Tanh1', 'Coth1', 'Sech1', 'Csch1', 'TrigExpand', 'SinCosEven', 'SinOddCos', 'CosOddSin',
                 'SecEvenTan', 'TanOddSec', 'Tan2', 'CotCscEven', 'CotOddCsc', 'QuadraticDenom1', 'QuadraticDenom2',
                 'SqrtQuadraticDenom1', 'SqrtQuadratic1')

# temporarily turn off some rewrite rules
REWRITE_STEPS = ('PartialFractions', 'Cancel', 'Expand', 'Tan1', 'Cot1', 'Cos1', 'Sec1', 'Csc1', 
                 'Tanh1', 'Coth1', 'Sech1', 'Csch1', 'TrigExpand', 'SinCosEven', 'SinOddCos', 'CosOddSin',
                 'SecEvenTan', 'TanOddSec', 'Tan2', 'CotCscEven', 'CotOddCsc')

# get the names of all the steps in string format and store them in a list
NAMES = [[step.__name__ for step in ls] for ls in [SIMPLE_STEPS, SPECIAL_SIMPLE_STEPS, OTHER_INTEGRAL_STEPS]]
RULE_TOKENS = NAMES[0] + NAMES[1] + NAMES[2] + list(REWRITE_STEPS)

ALL_STEPS = NAMES[0] + NAMES[1] + NAMES[2] + list(REWRITE_STEPS)

PARAM2_RULES = ['URule', 'PartsRule']
