import sympy as sp
from sympy.functions.special.elliptic_integrals import elliptic_e, elliptic_f

SYMBOLS = {
    'x': 'x',
    'y': 'y',
    'z': 'z',
    't': 't',
    'v': 'v',
    'w': 'w',
    'p': 'p',
    'q': 'q',
}


DIGITS = {
    '0': '0',
    '1': '1',
    '2': '2',
    '3': '3',
    '4': '4',
    '5': '5',
    '6': '6',
    '7': '7',
    '8': '8',
    '9': '9'
}

RATIONAL = '/'
INTPLUS = 'INT+'
INTMINUS = 'INT-'

EXP = 'E'
PI = 'pi'
I = 'I'

BINARY_OPERATORS = {
    sp.Add: '+', 
    sp.Mul: '*',
    sp.Pow: '^'
}

UNARY_OPERATORS = {
    sp.exp: 'exp',
    sp.log: 'ln',
    sp.Abs: 'abs',
    sp.sign: 'sign',

    sp.sin: 'sin',
    sp.cos: 'cos',
    sp.tan: 'tan',
    sp.cot: 'cot',

    sp.sec: 'sec',
    sp.csc: 'csc',

    sp.asin: 'asin',
    sp.acos: 'acos',
    sp.atan: 'atan',
    sp.acot: 'acot',
    sp.asec: 'asec',
    sp.acsc: 'acsc',

    sp.sinh: 'sinh',
    sp.cosh: 'cosh',
    sp.tanh: 'tanh',
    sp.coth: 'coth',

    sp.sech: 'sech',
    sp.csch: 'csch',

    sp.asinh: 'asinh',
    sp.acosh: 'acosh',
    sp.atanh: 'atanh',
    sp.acoth: 'acoth',
    sp.asech: 'asech',
    sp.acsch: 'acsch',
}



SPECIAL_FUNCTIONS = {
    sp.jacobi: 'jacobi',
    sp.gegenbauer: 'gegenbauer',
    sp.chebyshevt: 'chebyshevt',
    sp.legendre: 'legendre',
    sp.hermite: 'hermite',
    sp.laguerre: 'laguerre',
    sp.assoc_laguerre: 'assoc_laguerre',
    sp.Chi: 'Chi',
    sp.Shi: 'Shi',
    sp.Si: 'Si',
    sp.Ci: 'Ci',
    sp.Ei: 'Ei',
    sp.li: 'li',
    sp.erf: 'erf',
    sp.erfi: 'erfi',
    sp.erfc: 'erfc',
    sp.fresnelc: 'fresnelc',
    sp.fresnels: 'fresnels',
    sp.polylog: 'polylog',
    elliptic_f: 'elliptic_f',
    elliptic_e: 'elliptic_e',
}

SPECIAL_FUNCTIONS2 = {
    sp.expint: 'expint',
    sp.uppergamma: 'uppergamma',
}

INTEGRAL = 'Integral'

EXPRESSION_TOKENS = [INTEGRAL, RATIONAL, INTPLUS, INTMINUS, EXP, PI, I] + list(UNARY_OPERATORS.values()) + list(BINARY_OPERATORS.values()) + list(SYMBOLS.values()) + list(DIGITS.values()) + list(SPECIAL_FUNCTIONS.values()) + list(SPECIAL_FUNCTIONS2.values())
