#!/bin/bash

n=3 # Set the number of bottom processes to keep

while true
do
  # Get the list of PIDs
  PIDS=$(nvidia-smi --query-compute-apps=pid --format=csv,noheader,nounits)
  
  # Print all PIDs
  echo "All PIDs:"
  echo "$PIDS"
  
  # Count total number of PIDs
  TOTAL_PIDS=$(echo "$PIDS" | wc -l)
  
  if [ "$TOTAL_PIDS" -gt "$n" ]; then
    # Determine the number of PIDs to keep
    KILL_COUNT=$((TOTAL_PIDS - n))
    
    # Determine the PIDs to kill (all except the last n)
    PIDS_TO_KILL=$(echo "$PIDS" | head -n "$KILL_COUNT")
    
    # Print PIDs that will be killed
    echo "Killing PIDs:"
    echo "$PIDS_TO_KILL"
    
    # Kill each PID individually
    for PID in $PIDS_TO_KILL; do
      kill -9 "$PID"
    done
  else
    echo "No PIDs to kill."
  fi
  
  sleep 120
done
