# Reconciling Hessian-Informed Acceleration and Scalar-Only Communication for Efficient Zeroth-Order Federated Fine-Tuning

## Environment Setup

We use [conda](https://docs.conda.io/projects/conda/en/stable/) as our cross-platform environment management tool. However, due to macOS' lacking support for cuda, we have to make 2 different environment setup files:

- Use `environment.yml` on macOS or if you do not have cuda at hand.
- Use `environment_cuda.yml` otherwise.

For READMD.md, we will use `environment.yml` whenever an environment file is needed.

### Set Up Steps

1. Make sure `conda` is available. See https://conda.io/projects/conda/en/latest/user-guide/install/index.html for more detail.
2. At the root of this repo, run `conda env create -f environment.yml -y`.
3. Once installation is finished, run `conda activate hiso` to use the created virtual env.
4. (Optional) If you see something like `conda init before activate`. Run `conda init`, then restart your terminal/powershell. Then repeat step 3.

## Run Experiments

- **Run HiSo:** `python hiso_main.py --dataset=sst2 --eval-iterations=25 --large-model=opt-1.3b --model-dtype=float32 --seed=365 --iterations=3000 --train-batch-size=32 --test-batch-size=32 --no-iid --dirichlet-alpha=1 --num-clients=6 --num-sample-clients=2 --local-update-steps=1 --num-pert=5 --lr=0.000005 --momentum=0 --grad-estimate-method=rge-forward --mu=0.001 --estimator-type=adam_forward --k_update_strategy=last_local_update --hessian-smooth=0.95`
