"""
analytic expressions of spherical harmonics generated with sympy file 

run 
python spherical_harmonics_generate_ylms.py > spherical_harmonics_ylm.py

to generate the source code
"""

import torch
from torch import cos, sin

def get_SH(m,l):
  fname = f"Yl{l}_m{m}".replace("-","_minus_")
  return globals()[fname]

def SH(m, l, phi, theta):
  Ylm = get_SH(m,l)
  return Ylm(theta, phi)



@torch.jit.script
def Yl0_m0(theta, phi):
    return 0.282094791773878

@torch.jit.script
def Yl1_m_minus_1(theta, phi):
    return 0.48860251190292*(1.0 - cos(theta)**2)**0.5*sin(phi)

@torch.jit.script
def Yl1_m0(theta, phi):
    return 0.48860251190292*cos(theta)

@torch.jit.script
def Yl1_m1(theta, phi):
    return 0.48860251190292*(1.0 - cos(theta)**2)**0.5*cos(phi)

@torch.jit.script
def Yl2_m_minus_2(theta, phi):
    return 0.18209140509868*(3.0 - 3.0*cos(theta)**2)*sin(2*phi)

@torch.jit.script
def Yl2_m_minus_1(theta, phi):
    return 1.09254843059208*(1.0 - cos(theta)**2)**0.5*sin(phi)*cos(theta)

@torch.jit.script
def Yl2_m0(theta, phi):
    return 0.94617469575756*cos(theta)**2 - 0.31539156525252

@torch.jit.script
def Yl2_m1(theta, phi):
    return 1.09254843059208*(1.0 - cos(theta)**2)**0.5*cos(phi)*cos(theta)

@torch.jit.script
def Yl2_m2(theta, phi):
    return 0.18209140509868*(3.0 - 3.0*cos(theta)**2)*cos(2*phi)

@torch.jit.script
def Yl3_m_minus_3(theta, phi):
    return 0.590043589926644*(1.0 - cos(theta)**2)**1.5*sin(3*phi)

@torch.jit.script
def Yl3_m_minus_2(theta, phi):
    return 1.44530572132028*(1.0 - cos(theta)**2)*sin(2*phi)*cos(theta)

@torch.jit.script
def Yl3_m_minus_1(theta, phi):
    return 0.304697199642977*(1.0 - cos(theta)**2)**0.5*(7.5*cos(theta)**2 - 1.5)*sin(phi)

@torch.jit.script
def Yl3_m0(theta, phi):
    return 1.86588166295058*cos(theta)**3 - 1.11952899777035*cos(theta)

@torch.jit.script
def Yl3_m1(theta, phi):
    return 0.304697199642977*(1.0 - cos(theta)**2)**0.5*(7.5*cos(theta)**2 - 1.5)*cos(phi)

@torch.jit.script
def Yl3_m2(theta, phi):
    return 1.44530572132028*(1.0 - cos(theta)**2)*cos(2*phi)*cos(theta)

@torch.jit.script
def Yl3_m3(theta, phi):
    return 0.590043589926644*(1.0 - cos(theta)**2)**1.5*cos(3*phi)

@torch.jit.script
def Yl4_m_minus_4(theta, phi):
    return 0.625835735449176*(1.0 - cos(theta)**2)**2*sin(4*phi)

@torch.jit.script
def Yl4_m_minus_3(theta, phi):
    return 1.77013076977993*(1.0 - cos(theta)**2)**1.5*sin(3*phi)*cos(theta)

@torch.jit.script
def Yl4_m_minus_2(theta, phi):
    return 0.063078313050504*(1.0 - cos(theta)**2)*(52.5*cos(theta)**2 - 7.5)*sin(2*phi)

@torch.jit.script
def Yl4_m_minus_1(theta, phi):
    return 0.267618617422916*(1.0 - cos(theta)**2)**0.5*(17.5*cos(theta)**3 - 7.5*cos(theta))*sin(phi)

@torch.jit.script
def Yl4_m0(theta, phi):
    return 3.70249414203215*cos(theta)**4 - 3.17356640745613*cos(theta)**2 + 0.317356640745613

@torch.jit.script
def Yl4_m1(theta, phi):
    return 0.267618617422916*(1.0 - cos(theta)**2)**0.5*(17.5*cos(theta)**3 - 7.5*cos(theta))*cos(phi)

@torch.jit.script
def Yl4_m2(theta, phi):
    return 0.063078313050504*(1.0 - cos(theta)**2)*(52.5*cos(theta)**2 - 7.5)*cos(2*phi)

@torch.jit.script
def Yl4_m3(theta, phi):
    return 1.77013076977993*(1.0 - cos(theta)**2)**1.5*cos(3*phi)*cos(theta)

@torch.jit.script
def Yl4_m4(theta, phi):
    return 0.625835735449176*(1.0 - cos(theta)**2)**2*cos(4*phi)

@torch.jit.script
def Yl5_m_minus_5(theta, phi):
    return 0.65638205684017*(1.0 - cos(theta)**2)**2.5*sin(5*phi)

@torch.jit.script
def Yl5_m_minus_4(theta, phi):
    return 2.07566231488104*(1.0 - cos(theta)**2)**2*sin(4*phi)*cos(theta)

@torch.jit.script
def Yl5_m_minus_3(theta, phi):
    return 0.00931882475114763*(1.0 - cos(theta)**2)**1.5*(472.5*cos(theta)**2 - 52.5)*sin(3*phi)

@torch.jit.script
def Yl5_m_minus_2(theta, phi):
    return 0.0456527312854602*(1.0 - cos(theta)**2)*(157.5*cos(theta)**3 - 52.5*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl5_m_minus_1(theta, phi):
    return 0.241571547304372*(1.0 - cos(theta)**2)**0.5*(39.375*cos(theta)**4 - 26.25*cos(theta)**2 + 1.875)*sin(phi)

@torch.jit.script
def Yl5_m0(theta, phi):
    return 7.36787031456569*cos(theta)**5 - 8.18652257173965*cos(theta)**3 + 1.75425483680135*cos(theta)

@torch.jit.script
def Yl5_m1(theta, phi):
    return 0.241571547304372*(1.0 - cos(theta)**2)**0.5*(39.375*cos(theta)**4 - 26.25*cos(theta)**2 + 1.875)*cos(phi)

@torch.jit.script
def Yl5_m2(theta, phi):
    return 0.0456527312854602*(1.0 - cos(theta)**2)*(157.5*cos(theta)**3 - 52.5*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl5_m3(theta, phi):
    return 0.00931882475114763*(1.0 - cos(theta)**2)**1.5*(472.5*cos(theta)**2 - 52.5)*cos(3*phi)

@torch.jit.script
def Yl5_m4(theta, phi):
    return 2.07566231488104*(1.0 - cos(theta)**2)**2*cos(4*phi)*cos(theta)

@torch.jit.script
def Yl5_m5(theta, phi):
    return 0.65638205684017*(1.0 - cos(theta)**2)**2.5*cos(5*phi)

@torch.jit.script
def Yl6_m_minus_6(theta, phi):
    return 0.683184105191914*(1.0 - cos(theta)**2)**3*sin(6*phi)

@torch.jit.script
def Yl6_m_minus_5(theta, phi):
    return 2.36661916223175*(1.0 - cos(theta)**2)**2.5*sin(5*phi)*cos(theta)

@torch.jit.script
def Yl6_m_minus_4(theta, phi):
    return 0.0010678622237645*(1.0 - cos(theta)**2)**2*(5197.5*cos(theta)**2 - 472.5)*sin(4*phi)

@torch.jit.script
def Yl6_m_minus_3(theta, phi):
    return 0.00584892228263444*(1.0 - cos(theta)**2)**1.5*(1732.5*cos(theta)**3 - 472.5*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl6_m_minus_2(theta, phi):
    return 0.0350935336958066*(1.0 - cos(theta)**2)*(433.125*cos(theta)**4 - 236.25*cos(theta)**2 + 13.125)*sin(2*phi)

@torch.jit.script
def Yl6_m_minus_1(theta, phi):
    return 0.221950995245231*(1.0 - cos(theta)**2)**0.5*(86.625*cos(theta)**5 - 78.75*cos(theta)**3 + 13.125*cos(theta))*sin(phi)

@torch.jit.script
def Yl6_m0(theta, phi):
    return 14.6844857238222*cos(theta)**6 - 20.024298714303*cos(theta)**4 + 6.67476623810098*cos(theta)**2 - 0.317846011338142

@torch.jit.script
def Yl6_m1(theta, phi):
    return 0.221950995245231*(1.0 - cos(theta)**2)**0.5*(86.625*cos(theta)**5 - 78.75*cos(theta)**3 + 13.125*cos(theta))*cos(phi)

@torch.jit.script
def Yl6_m2(theta, phi):
    return 0.0350935336958066*(1.0 - cos(theta)**2)*(433.125*cos(theta)**4 - 236.25*cos(theta)**2 + 13.125)*cos(2*phi)

@torch.jit.script
def Yl6_m3(theta, phi):
    return 0.00584892228263444*(1.0 - cos(theta)**2)**1.5*(1732.5*cos(theta)**3 - 472.5*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl6_m4(theta, phi):
    return 0.0010678622237645*(1.0 - cos(theta)**2)**2*(5197.5*cos(theta)**2 - 472.5)*cos(4*phi)

@torch.jit.script
def Yl6_m5(theta, phi):
    return 2.36661916223175*(1.0 - cos(theta)**2)**2.5*cos(5*phi)*cos(theta)

@torch.jit.script
def Yl6_m6(theta, phi):
    return 0.683184105191914*(1.0 - cos(theta)**2)**3*cos(6*phi)

@torch.jit.script
def Yl7_m_minus_7(theta, phi):
    return 0.707162732524596*(1.0 - cos(theta)**2)**3.5*sin(7*phi)

@torch.jit.script
def Yl7_m_minus_6(theta, phi):
    return 2.6459606618019*(1.0 - cos(theta)**2)**3*sin(6*phi)*cos(theta)

@torch.jit.script
def Yl7_m_minus_5(theta, phi):
    return 9.98394571852353e-5*(1.0 - cos(theta)**2)**2.5*(67567.5*cos(theta)**2 - 5197.5)*sin(5*phi)

@torch.jit.script
def Yl7_m_minus_4(theta, phi):
    return 0.000599036743111412*(1.0 - cos(theta)**2)**2*(22522.5*cos(theta)**3 - 5197.5*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl7_m_minus_3(theta, phi):
    return 0.00397356022507413*(1.0 - cos(theta)**2)**1.5*(5630.625*cos(theta)**4 - 2598.75*cos(theta)**2 + 118.125)*sin(3*phi)

@torch.jit.script
def Yl7_m_minus_2(theta, phi):
    return 0.0280973138060306*(1.0 - cos(theta)**2)*(1126.125*cos(theta)**5 - 866.25*cos(theta)**3 + 118.125*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl7_m_minus_1(theta, phi):
    return 0.206472245902897*(1.0 - cos(theta)**2)**0.5*(187.6875*cos(theta)**6 - 216.5625*cos(theta)**4 + 59.0625*cos(theta)**2 - 2.1875)*sin(phi)

@torch.jit.script
def Yl7_m0(theta, phi):
    return 29.2939547952501*cos(theta)**7 - 47.3210039000194*cos(theta)**5 + 21.5095472272816*cos(theta)**3 - 2.38994969192017*cos(theta)

@torch.jit.script
def Yl7_m1(theta, phi):
    return 0.206472245902897*(1.0 - cos(theta)**2)**0.5*(187.6875*cos(theta)**6 - 216.5625*cos(theta)**4 + 59.0625*cos(theta)**2 - 2.1875)*cos(phi)

@torch.jit.script
def Yl7_m2(theta, phi):
    return 0.0280973138060306*(1.0 - cos(theta)**2)*(1126.125*cos(theta)**5 - 866.25*cos(theta)**3 + 118.125*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl7_m3(theta, phi):
    return 0.00397356022507413*(1.0 - cos(theta)**2)**1.5*(5630.625*cos(theta)**4 - 2598.75*cos(theta)**2 + 118.125)*cos(3*phi)

@torch.jit.script
def Yl7_m4(theta, phi):
    return 0.000599036743111412*(1.0 - cos(theta)**2)**2*(22522.5*cos(theta)**3 - 5197.5*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl7_m5(theta, phi):
    return 9.98394571852353e-5*(1.0 - cos(theta)**2)**2.5*(67567.5*cos(theta)**2 - 5197.5)*cos(5*phi)

@torch.jit.script
def Yl7_m6(theta, phi):
    return 2.6459606618019*(1.0 - cos(theta)**2)**3*cos(6*phi)*cos(theta)

@torch.jit.script
def Yl7_m7(theta, phi):
    return 0.707162732524596*(1.0 - cos(theta)**2)**3.5*cos(7*phi)

@torch.jit.script
def Yl8_m_minus_8(theta, phi):
    return 0.72892666017483*(1.0 - cos(theta)**2)**4*sin(8*phi)

@torch.jit.script
def Yl8_m_minus_7(theta, phi):
    return 2.91570664069932*(1.0 - cos(theta)**2)**3.5*sin(7*phi)*cos(theta)

@torch.jit.script
def Yl8_m_minus_6(theta, phi):
    return 7.87853281621404e-6*(1.0 - cos(theta)**2)**3*(1013512.5*cos(theta)**2 - 67567.5)*sin(6*phi)

@torch.jit.script
def Yl8_m_minus_5(theta, phi):
    return 5.10587282657803e-5*(1.0 - cos(theta)**2)**2.5*(337837.5*cos(theta)**3 - 67567.5*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl8_m_minus_4(theta, phi):
    return 0.000368189725644507*(1.0 - cos(theta)**2)**2*(84459.375*cos(theta)**4 - 33783.75*cos(theta)**2 + 1299.375)*sin(4*phi)

@torch.jit.script
def Yl8_m_minus_3(theta, phi):
    return 0.0028519853513317*(1.0 - cos(theta)**2)**1.5*(16891.875*cos(theta)**5 - 11261.25*cos(theta)**3 + 1299.375*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl8_m_minus_2(theta, phi):
    return 0.0231696385236779*(1.0 - cos(theta)**2)*(2815.3125*cos(theta)**6 - 2815.3125*cos(theta)**4 + 649.6875*cos(theta)**2 - 19.6875)*sin(2*phi)

@torch.jit.script
def Yl8_m_minus_1(theta, phi):
    return 0.193851103820053*(1.0 - cos(theta)**2)**0.5*(402.1875*cos(theta)**7 - 563.0625*cos(theta)**5 + 216.5625*cos(theta)**3 - 19.6875*cos(theta))*sin(phi)

@torch.jit.script
def Yl8_m0(theta, phi):
    return 58.4733681132208*cos(theta)**8 - 109.150287144679*cos(theta)**6 + 62.9713195065454*cos(theta)**4 - 11.4493308193719*cos(theta)**2 + 0.318036967204775

@torch.jit.script
def Yl8_m1(theta, phi):
    return 0.193851103820053*(1.0 - cos(theta)**2)**0.5*(402.1875*cos(theta)**7 - 563.0625*cos(theta)**5 + 216.5625*cos(theta)**3 - 19.6875*cos(theta))*cos(phi)

@torch.jit.script
def Yl8_m2(theta, phi):
    return 0.0231696385236779*(1.0 - cos(theta)**2)*(2815.3125*cos(theta)**6 - 2815.3125*cos(theta)**4 + 649.6875*cos(theta)**2 - 19.6875)*cos(2*phi)

@torch.jit.script
def Yl8_m3(theta, phi):
    return 0.0028519853513317*(1.0 - cos(theta)**2)**1.5*(16891.875*cos(theta)**5 - 11261.25*cos(theta)**3 + 1299.375*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl8_m4(theta, phi):
    return 0.000368189725644507*(1.0 - cos(theta)**2)**2*(84459.375*cos(theta)**4 - 33783.75*cos(theta)**2 + 1299.375)*cos(4*phi)

@torch.jit.script
def Yl8_m5(theta, phi):
    return 5.10587282657803e-5*(1.0 - cos(theta)**2)**2.5*(337837.5*cos(theta)**3 - 67567.5*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl8_m6(theta, phi):
    return 7.87853281621404e-6*(1.0 - cos(theta)**2)**3*(1013512.5*cos(theta)**2 - 67567.5)*cos(6*phi)

@torch.jit.script
def Yl8_m7(theta, phi):
    return 2.91570664069932*(1.0 - cos(theta)**2)**3.5*cos(7*phi)*cos(theta)

@torch.jit.script
def Yl8_m8(theta, phi):
    return 0.72892666017483*(1.0 - cos(theta)**2)**4*cos(8*phi)

@torch.jit.script
def Yl9_m_minus_9(theta, phi):
    return 0.748900951853188*(1.0 - cos(theta)**2)**4.5*sin(9*phi)

@torch.jit.script
def Yl9_m_minus_8(theta, phi):
    return 3.1773176489547*(1.0 - cos(theta)**2)**4*sin(8*phi)*cos(theta)

@torch.jit.script
def Yl9_m_minus_7(theta, phi):
    return 5.37640612566745e-7*(1.0 - cos(theta)**2)**3.5*(17229712.5*cos(theta)**2 - 1013512.5)*sin(7*phi)

@torch.jit.script
def Yl9_m_minus_6(theta, phi):
    return 3.72488342871223e-6*(1.0 - cos(theta)**2)**3*(5743237.5*cos(theta)**3 - 1013512.5*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl9_m_minus_5(theta, phi):
    return 2.88528229719329e-5*(1.0 - cos(theta)**2)**2.5*(1435809.375*cos(theta)**4 - 506756.25*cos(theta)**2 + 16891.875)*sin(5*phi)

@torch.jit.script
def Yl9_m_minus_4(theta, phi):
    return 0.000241400036332803*(1.0 - cos(theta)**2)**2*(287161.875*cos(theta)**5 - 168918.75*cos(theta)**3 + 16891.875*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl9_m_minus_3(theta, phi):
    return 0.00213198739401417*(1.0 - cos(theta)**2)**1.5*(47860.3125*cos(theta)**6 - 42229.6875*cos(theta)**4 + 8445.9375*cos(theta)**2 - 216.5625)*sin(3*phi)

@torch.jit.script
def Yl9_m_minus_2(theta, phi):
    return 0.0195399872275232*(1.0 - cos(theta)**2)*(6837.1875*cos(theta)**7 - 8445.9375*cos(theta)**5 + 2815.3125*cos(theta)**3 - 216.5625*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl9_m_minus_1(theta, phi):
    return 0.183301328077446*(1.0 - cos(theta)**2)**0.5*(854.6484375*cos(theta)**8 - 1407.65625*cos(theta)**6 + 703.828125*cos(theta)**4 - 108.28125*cos(theta)**2 + 2.4609375)*sin(phi)

@torch.jit.script
def Yl9_m0(theta, phi):
    return 116.766123398619*cos(theta)**9 - 247.269437785311*cos(theta)**7 + 173.088606449718*cos(theta)**5 - 44.3816939614661*cos(theta)**3 + 3.02602458828178*cos(theta)

@torch.jit.script
def Yl9_m1(theta, phi):
    return 0.183301328077446*(1.0 - cos(theta)**2)**0.5*(854.6484375*cos(theta)**8 - 1407.65625*cos(theta)**6 + 703.828125*cos(theta)**4 - 108.28125*cos(theta)**2 + 2.4609375)*cos(phi)

@torch.jit.script
def Yl9_m2(theta, phi):
    return 0.0195399872275232*(1.0 - cos(theta)**2)*(6837.1875*cos(theta)**7 - 8445.9375*cos(theta)**5 + 2815.3125*cos(theta)**3 - 216.5625*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl9_m3(theta, phi):
    return 0.00213198739401417*(1.0 - cos(theta)**2)**1.5*(47860.3125*cos(theta)**6 - 42229.6875*cos(theta)**4 + 8445.9375*cos(theta)**2 - 216.5625)*cos(3*phi)

@torch.jit.script
def Yl9_m4(theta, phi):
    return 0.000241400036332803*(1.0 - cos(theta)**2)**2*(287161.875*cos(theta)**5 - 168918.75*cos(theta)**3 + 16891.875*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl9_m5(theta, phi):
    return 2.88528229719329e-5*(1.0 - cos(theta)**2)**2.5*(1435809.375*cos(theta)**4 - 506756.25*cos(theta)**2 + 16891.875)*cos(5*phi)

@torch.jit.script
def Yl9_m6(theta, phi):
    return 3.72488342871223e-6*(1.0 - cos(theta)**2)**3*(5743237.5*cos(theta)**3 - 1013512.5*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl9_m7(theta, phi):
    return 5.37640612566745e-7*(1.0 - cos(theta)**2)**3.5*(17229712.5*cos(theta)**2 - 1013512.5)*cos(7*phi)

@torch.jit.script
def Yl9_m8(theta, phi):
    return 3.1773176489547*(1.0 - cos(theta)**2)**4*cos(8*phi)*cos(theta)

@torch.jit.script
def Yl9_m9(theta, phi):
    return 0.748900951853188*(1.0 - cos(theta)**2)**4.5*cos(9*phi)

@torch.jit.script
def Yl10_m_minus_10(theta, phi):
    return 0.76739511822199*(1.0 - cos(theta)**2)**5*sin(10*phi)

@torch.jit.script
def Yl10_m_minus_9(theta, phi):
    return 3.43189529989171*(1.0 - cos(theta)**2)**4.5*sin(9*phi)*cos(theta)

@torch.jit.script
def Yl10_m_minus_8(theta, phi):
    return 3.23120268385452e-8*(1.0 - cos(theta)**2)**4*(327364537.5*cos(theta)**2 - 17229712.5)*sin(8*phi)

@torch.jit.script
def Yl10_m_minus_7(theta, phi):
    return 2.37443934928654e-7*(1.0 - cos(theta)**2)**3.5*(109121512.5*cos(theta)**3 - 17229712.5*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl10_m_minus_6(theta, phi):
    return 1.95801284774625e-6*(1.0 - cos(theta)**2)**3*(27280378.125*cos(theta)**4 - 8614856.25*cos(theta)**2 + 253378.125)*sin(6*phi)

@torch.jit.script
def Yl10_m_minus_5(theta, phi):
    return 1.75129993135143e-5*(1.0 - cos(theta)**2)**2.5*(5456075.625*cos(theta)**5 - 2871618.75*cos(theta)**3 + 253378.125*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl10_m_minus_4(theta, phi):
    return 0.000166142899475011*(1.0 - cos(theta)**2)**2*(909345.9375*cos(theta)**6 - 717904.6875*cos(theta)**4 + 126689.0625*cos(theta)**2 - 2815.3125)*sin(4*phi)

@torch.jit.script
def Yl10_m_minus_3(theta, phi):
    return 0.00164473079210685*(1.0 - cos(theta)**2)**1.5*(129906.5625*cos(theta)**7 - 143580.9375*cos(theta)**5 + 42229.6875*cos(theta)**3 - 2815.3125*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl10_m_minus_2(theta, phi):
    return 0.0167730288071195*(1.0 - cos(theta)**2)*(16238.3203125*cos(theta)**8 - 23930.15625*cos(theta)**6 + 10557.421875*cos(theta)**4 - 1407.65625*cos(theta)**2 + 27.0703125)*sin(2*phi)

@torch.jit.script
def Yl10_m_minus_1(theta, phi):
    return 0.174310428544485*(1.0 - cos(theta)**2)**0.5*(1804.2578125*cos(theta)**9 - 3418.59375*cos(theta)**7 + 2111.484375*cos(theta)**5 - 469.21875*cos(theta)**3 + 27.0703125*cos(theta))*sin(phi)

@torch.jit.script
def Yl10_m0(theta, phi):
    return 233.240148813258*cos(theta)**10 - 552.410878768242*cos(theta)**8 + 454.926606044435*cos(theta)**6 - 151.642202014812*cos(theta)**4 + 17.4971771555552*cos(theta)**2 - 0.318130493737367

@torch.jit.script
def Yl10_m1(theta, phi):
    return 0.174310428544485*(1.0 - cos(theta)**2)**0.5*(1804.2578125*cos(theta)**9 - 3418.59375*cos(theta)**7 + 2111.484375*cos(theta)**5 - 469.21875*cos(theta)**3 + 27.0703125*cos(theta))*cos(phi)

@torch.jit.script
def Yl10_m2(theta, phi):
    return 0.0167730288071195*(1.0 - cos(theta)**2)*(16238.3203125*cos(theta)**8 - 23930.15625*cos(theta)**6 + 10557.421875*cos(theta)**4 - 1407.65625*cos(theta)**2 + 27.0703125)*cos(2*phi)

@torch.jit.script
def Yl10_m3(theta, phi):
    return 0.00164473079210685*(1.0 - cos(theta)**2)**1.5*(129906.5625*cos(theta)**7 - 143580.9375*cos(theta)**5 + 42229.6875*cos(theta)**3 - 2815.3125*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl10_m4(theta, phi):
    return 0.000166142899475011*(1.0 - cos(theta)**2)**2*(909345.9375*cos(theta)**6 - 717904.6875*cos(theta)**4 + 126689.0625*cos(theta)**2 - 2815.3125)*cos(4*phi)

@torch.jit.script
def Yl10_m5(theta, phi):
    return 1.75129993135143e-5*(1.0 - cos(theta)**2)**2.5*(5456075.625*cos(theta)**5 - 2871618.75*cos(theta)**3 + 253378.125*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl10_m6(theta, phi):
    return 1.95801284774625e-6*(1.0 - cos(theta)**2)**3*(27280378.125*cos(theta)**4 - 8614856.25*cos(theta)**2 + 253378.125)*cos(6*phi)

@torch.jit.script
def Yl10_m7(theta, phi):
    return 2.37443934928654e-7*(1.0 - cos(theta)**2)**3.5*(109121512.5*cos(theta)**3 - 17229712.5*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl10_m8(theta, phi):
    return 3.23120268385452e-8*(1.0 - cos(theta)**2)**4*(327364537.5*cos(theta)**2 - 17229712.5)*cos(8*phi)

@torch.jit.script
def Yl10_m9(theta, phi):
    return 3.43189529989171*(1.0 - cos(theta)**2)**4.5*cos(9*phi)*cos(theta)

@torch.jit.script
def Yl10_m10(theta, phi):
    return 0.76739511822199*(1.0 - cos(theta)**2)**5*cos(10*phi)

@torch.jit.script
def Yl11_m_minus_11(theta, phi):
    return 0.784642105787197*(1.0 - cos(theta)**2)**5.5*sin(11*phi)

@torch.jit.script
def Yl11_m_minus_10(theta, phi):
    return 3.68029769880531*(1.0 - cos(theta)**2)**5*sin(10*phi)*cos(theta)

@torch.jit.script
def Yl11_m_minus_9(theta, phi):
    return 1.73470916587426e-9*(1.0 - cos(theta)**2)**4.5*(6874655287.5*cos(theta)**2 - 327364537.5)*sin(9*phi)

@torch.jit.script
def Yl11_m_minus_8(theta, phi):
    return 1.34369994198887e-8*(1.0 - cos(theta)**2)**4*(2291551762.5*cos(theta)**3 - 327364537.5*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl11_m_minus_7(theta, phi):
    return 1.17141045151419e-7*(1.0 - cos(theta)**2)**3.5*(572887940.625*cos(theta)**4 - 163682268.75*cos(theta)**2 + 4307428.125)*sin(7*phi)

@torch.jit.script
def Yl11_m_minus_6(theta, phi):
    return 1.11129753051333e-6*(1.0 - cos(theta)**2)**3*(114577588.125*cos(theta)**5 - 54560756.25*cos(theta)**3 + 4307428.125*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl11_m_minus_5(theta, phi):
    return 1.12235548974089e-5*(1.0 - cos(theta)**2)**2.5*(19096264.6875*cos(theta)**6 - 13640189.0625*cos(theta)**4 + 2153714.0625*cos(theta)**2 - 42229.6875)*sin(5*phi)

@torch.jit.script
def Yl11_m_minus_4(theta, phi):
    return 0.0001187789403385*(1.0 - cos(theta)**2)**2*(2728037.8125*cos(theta)**7 - 2728037.8125*cos(theta)**5 + 717904.6875*cos(theta)**3 - 42229.6875*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl11_m_minus_3(theta, phi):
    return 0.00130115809959914*(1.0 - cos(theta)**2)**1.5*(341004.7265625*cos(theta)**8 - 454672.96875*cos(theta)**6 + 179476.171875*cos(theta)**4 - 21114.84375*cos(theta)**2 + 351.9140625)*sin(3*phi)

@torch.jit.script
def Yl11_m_minus_2(theta, phi):
    return 0.0146054634441776*(1.0 - cos(theta)**2)*(37889.4140625*cos(theta)**9 - 64953.28125*cos(theta)**7 + 35895.234375*cos(theta)**5 - 7038.28125*cos(theta)**3 + 351.9140625*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl11_m_minus_1(theta, phi):
    return 0.166527904912351*(1.0 - cos(theta)**2)**0.5*(3788.94140625*cos(theta)**10 - 8119.16015625*cos(theta)**8 + 5982.5390625*cos(theta)**6 - 1759.5703125*cos(theta)**4 + 175.95703125*cos(theta)**2 - 2.70703125)*sin(phi)

@torch.jit.script
def Yl11_m0(theta, phi):
    return 465.998147319252*cos(theta)**11 - 1220.47133821709*cos(theta)**9 + 1156.23600462672*cos(theta)**7 - 476.097178375706*cos(theta)**5 + 79.3495297292844*cos(theta)**3 - 3.66228598750543*cos(theta)

@torch.jit.script
def Yl11_m1(theta, phi):
    return 0.166527904912351*(1.0 - cos(theta)**2)**0.5*(3788.94140625*cos(theta)**10 - 8119.16015625*cos(theta)**8 + 5982.5390625*cos(theta)**6 - 1759.5703125*cos(theta)**4 + 175.95703125*cos(theta)**2 - 2.70703125)*cos(phi)

@torch.jit.script
def Yl11_m2(theta, phi):
    return 0.0146054634441776*(1.0 - cos(theta)**2)*(37889.4140625*cos(theta)**9 - 64953.28125*cos(theta)**7 + 35895.234375*cos(theta)**5 - 7038.28125*cos(theta)**3 + 351.9140625*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl11_m3(theta, phi):
    return 0.00130115809959914*(1.0 - cos(theta)**2)**1.5*(341004.7265625*cos(theta)**8 - 454672.96875*cos(theta)**6 + 179476.171875*cos(theta)**4 - 21114.84375*cos(theta)**2 + 351.9140625)*cos(3*phi)

@torch.jit.script
def Yl11_m4(theta, phi):
    return 0.0001187789403385*(1.0 - cos(theta)**2)**2*(2728037.8125*cos(theta)**7 - 2728037.8125*cos(theta)**5 + 717904.6875*cos(theta)**3 - 42229.6875*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl11_m5(theta, phi):
    return 1.12235548974089e-5*(1.0 - cos(theta)**2)**2.5*(19096264.6875*cos(theta)**6 - 13640189.0625*cos(theta)**4 + 2153714.0625*cos(theta)**2 - 42229.6875)*cos(5*phi)

@torch.jit.script
def Yl11_m6(theta, phi):
    return 1.11129753051333e-6*(1.0 - cos(theta)**2)**3*(114577588.125*cos(theta)**5 - 54560756.25*cos(theta)**3 + 4307428.125*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl11_m7(theta, phi):
    return 1.17141045151419e-7*(1.0 - cos(theta)**2)**3.5*(572887940.625*cos(theta)**4 - 163682268.75*cos(theta)**2 + 4307428.125)*cos(7*phi)

@torch.jit.script
def Yl11_m8(theta, phi):
    return 1.34369994198887e-8*(1.0 - cos(theta)**2)**4*(2291551762.5*cos(theta)**3 - 327364537.5*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl11_m9(theta, phi):
    return 1.73470916587426e-9*(1.0 - cos(theta)**2)**4.5*(6874655287.5*cos(theta)**2 - 327364537.5)*cos(9*phi)

@torch.jit.script
def Yl11_m10(theta, phi):
    return 3.68029769880531*(1.0 - cos(theta)**2)**5*cos(10*phi)*cos(theta)

@torch.jit.script
def Yl11_m11(theta, phi):
    return 0.784642105787197*(1.0 - cos(theta)**2)**5.5*cos(11*phi)

@torch.jit.script
def Yl12_m_minus_12(theta, phi):
    return 0.800821995783972*(1.0 - cos(theta)**2)**6*sin(12*phi)

@torch.jit.script
def Yl12_m_minus_11(theta, phi):
    return 3.92321052893598*(1.0 - cos(theta)**2)**5.5*sin(11*phi)*cos(theta)

@torch.jit.script
def Yl12_m_minus_10(theta, phi):
    return 8.4141794839602e-11*(1.0 - cos(theta)**2)**5*(158117071612.5*cos(theta)**2 - 6874655287.5)*sin(10*phi)

@torch.jit.script
def Yl12_m_minus_9(theta, phi):
    return 6.83571172711927e-10*(1.0 - cos(theta)**2)**4.5*(52705690537.5*cos(theta)**3 - 6874655287.5*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl12_m_minus_8(theta, phi):
    return 6.26503328368427e-9*(1.0 - cos(theta)**2)**4*(13176422634.375*cos(theta)**4 - 3437327643.75*cos(theta)**2 + 81841134.375)*sin(8*phi)

@torch.jit.script
def Yl12_m_minus_7(theta, phi):
    return 6.26503328368427e-8*(1.0 - cos(theta)**2)**3.5*(2635284526.875*cos(theta)**5 - 1145775881.25*cos(theta)**3 + 81841134.375*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl12_m_minus_6(theta, phi):
    return 6.68922506214776e-7*(1.0 - cos(theta)**2)**3*(439214087.8125*cos(theta)**6 - 286443970.3125*cos(theta)**4 + 40920567.1875*cos(theta)**2 - 717904.6875)*sin(6*phi)

@torch.jit.script
def Yl12_m_minus_5(theta, phi):
    return 7.50863650967357e-6*(1.0 - cos(theta)**2)**2.5*(62744869.6875*cos(theta)**7 - 57288794.0625*cos(theta)**5 + 13640189.0625*cos(theta)**3 - 717904.6875*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl12_m_minus_4(theta, phi):
    return 8.75649965675714e-5*(1.0 - cos(theta)**2)**2*(7843108.7109375*cos(theta)**8 - 9548132.34375*cos(theta)**6 + 3410047.265625*cos(theta)**4 - 358952.34375*cos(theta)**2 + 5278.7109375)*sin(4*phi)

@torch.jit.script
def Yl12_m_minus_3(theta, phi):
    return 0.00105077995881086*(1.0 - cos(theta)**2)**1.5*(871456.5234375*cos(theta)**9 - 1364018.90625*cos(theta)**7 + 682009.453125*cos(theta)**5 - 119650.78125*cos(theta)**3 + 5278.7109375*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl12_m_minus_2(theta, phi):
    return 0.0128693736551466*(1.0 - cos(theta)**2)*(87145.65234375*cos(theta)**10 - 170502.36328125*cos(theta)**8 + 113668.2421875*cos(theta)**6 - 29912.6953125*cos(theta)**4 + 2639.35546875*cos(theta)**2 - 35.19140625)*sin(2*phi)

@torch.jit.script
def Yl12_m_minus_1(theta, phi):
    return 0.159704727088682*(1.0 - cos(theta)**2)**0.5*(7922.33203125*cos(theta)**11 - 18944.70703125*cos(theta)**9 + 16238.3203125*cos(theta)**7 - 5982.5390625*cos(theta)**5 + 879.78515625*cos(theta)**3 - 35.19140625*cos(theta))*sin(phi)

@torch.jit.script
def Yl12_m0(theta, phi):
    return 931.186918632914*cos(theta)**12 - 2672.1015925988*cos(theta)**10 + 2862.96599207014*cos(theta)**8 - 1406.36925926252*cos(theta)**6 + 310.228513072616*cos(theta)**4 - 24.8182810458093*cos(theta)**2 + 0.318183090330888

@torch.jit.script
def Yl12_m1(theta, phi):
    return 0.159704727088682*(1.0 - cos(theta)**2)**0.5*(7922.33203125*cos(theta)**11 - 18944.70703125*cos(theta)**9 + 16238.3203125*cos(theta)**7 - 5982.5390625*cos(theta)**5 + 879.78515625*cos(theta)**3 - 35.19140625*cos(theta))*cos(phi)

@torch.jit.script
def Yl12_m2(theta, phi):
    return 0.0128693736551466*(1.0 - cos(theta)**2)*(87145.65234375*cos(theta)**10 - 170502.36328125*cos(theta)**8 + 113668.2421875*cos(theta)**6 - 29912.6953125*cos(theta)**4 + 2639.35546875*cos(theta)**2 - 35.19140625)*cos(2*phi)

@torch.jit.script
def Yl12_m3(theta, phi):
    return 0.00105077995881086*(1.0 - cos(theta)**2)**1.5*(871456.5234375*cos(theta)**9 - 1364018.90625*cos(theta)**7 + 682009.453125*cos(theta)**5 - 119650.78125*cos(theta)**3 + 5278.7109375*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl12_m4(theta, phi):
    return 8.75649965675714e-5*(1.0 - cos(theta)**2)**2*(7843108.7109375*cos(theta)**8 - 9548132.34375*cos(theta)**6 + 3410047.265625*cos(theta)**4 - 358952.34375*cos(theta)**2 + 5278.7109375)*cos(4*phi)

@torch.jit.script
def Yl12_m5(theta, phi):
    return 7.50863650967357e-6*(1.0 - cos(theta)**2)**2.5*(62744869.6875*cos(theta)**7 - 57288794.0625*cos(theta)**5 + 13640189.0625*cos(theta)**3 - 717904.6875*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl12_m6(theta, phi):
    return 6.68922506214776e-7*(1.0 - cos(theta)**2)**3*(439214087.8125*cos(theta)**6 - 286443970.3125*cos(theta)**4 + 40920567.1875*cos(theta)**2 - 717904.6875)*cos(6*phi)

@torch.jit.script
def Yl12_m7(theta, phi):
    return 6.26503328368427e-8*(1.0 - cos(theta)**2)**3.5*(2635284526.875*cos(theta)**5 - 1145775881.25*cos(theta)**3 + 81841134.375*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl12_m8(theta, phi):
    return 6.26503328368427e-9*(1.0 - cos(theta)**2)**4*(13176422634.375*cos(theta)**4 - 3437327643.75*cos(theta)**2 + 81841134.375)*cos(8*phi)

@torch.jit.script
def Yl12_m9(theta, phi):
    return 6.83571172711927e-10*(1.0 - cos(theta)**2)**4.5*(52705690537.5*cos(theta)**3 - 6874655287.5*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl12_m10(theta, phi):
    return 8.4141794839602e-11*(1.0 - cos(theta)**2)**5*(158117071612.5*cos(theta)**2 - 6874655287.5)*cos(10*phi)

@torch.jit.script
def Yl12_m11(theta, phi):
    return 3.92321052893598*(1.0 - cos(theta)**2)**5.5*cos(11*phi)*cos(theta)

@torch.jit.script
def Yl12_m12(theta, phi):
    return 0.800821995783972*(1.0 - cos(theta)**2)**6*cos(12*phi)

@torch.jit.script
def Yl13_m_minus_13(theta, phi):
    return 0.816077118837628*(1.0 - cos(theta)**2)**6.5*sin(13*phi)

@torch.jit.script
def Yl13_m_minus_12(theta, phi):
    return 4.16119315354964*(1.0 - cos(theta)**2)**6*sin(12*phi)*cos(theta)

@torch.jit.script
def Yl13_m_minus_11(theta, phi):
    return 3.72180924766049e-12*(1.0 - cos(theta)**2)**5.5*(3952926790312.5*cos(theta)**2 - 158117071612.5)*sin(11*phi)

@torch.jit.script
def Yl13_m_minus_10(theta, phi):
    return 3.15805986876424e-11*(1.0 - cos(theta)**2)**5*(1317642263437.5*cos(theta)**3 - 158117071612.5*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl13_m_minus_9(theta, phi):
    return 3.02910461422567e-10*(1.0 - cos(theta)**2)**4.5*(329410565859.375*cos(theta)**4 - 79058535806.25*cos(theta)**2 + 1718663821.875)*sin(9*phi)

@torch.jit.script
def Yl13_m_minus_8(theta, phi):
    return 3.17695172143292e-9*(1.0 - cos(theta)**2)**4*(65882113171.875*cos(theta)**5 - 26352845268.75*cos(theta)**3 + 1718663821.875*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl13_m_minus_7(theta, phi):
    return 3.5661194627771e-8*(1.0 - cos(theta)**2)**3.5*(10980352195.3125*cos(theta)**6 - 6588211317.1875*cos(theta)**4 + 859331910.9375*cos(theta)**2 - 13640189.0625)*sin(7*phi)

@torch.jit.script
def Yl13_m_minus_6(theta, phi):
    return 4.21948945157073e-7*(1.0 - cos(theta)**2)**3*(1568621742.1875*cos(theta)**7 - 1317642263.4375*cos(theta)**5 + 286443970.3125*cos(theta)**3 - 13640189.0625*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl13_m_minus_5(theta, phi):
    return 5.2021359721285e-6*(1.0 - cos(theta)**2)**2.5*(196077717.773438*cos(theta)**8 - 219607043.90625*cos(theta)**6 + 71610992.578125*cos(theta)**4 - 6820094.53125*cos(theta)**2 + 89738.0859375)*sin(5*phi)

@torch.jit.script
def Yl13_m_minus_4(theta, phi):
    return 6.62123812058377e-5*(1.0 - cos(theta)**2)**2*(21786413.0859375*cos(theta)**9 - 31372434.84375*cos(theta)**7 + 14322198.515625*cos(theta)**5 - 2273364.84375*cos(theta)**3 + 89738.0859375*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl13_m_minus_3(theta, phi):
    return 0.000863303829622583*(1.0 - cos(theta)**2)**1.5*(2178641.30859375*cos(theta)**10 - 3921554.35546875*cos(theta)**8 + 2387033.0859375*cos(theta)**6 - 568341.2109375*cos(theta)**4 + 44869.04296875*cos(theta)**2 - 527.87109375)*sin(3*phi)

@torch.jit.script
def Yl13_m_minus_2(theta, phi):
    return 0.0114530195317401*(1.0 - cos(theta)**2)*(198058.30078125*cos(theta)**11 - 435728.26171875*cos(theta)**9 + 341004.7265625*cos(theta)**7 - 113668.2421875*cos(theta)**5 + 14956.34765625*cos(theta)**3 - 527.87109375*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl13_m_minus_1(theta, phi):
    return 0.153658381323621*(1.0 - cos(theta)**2)**0.5*(16504.8583984375*cos(theta)**12 - 43572.826171875*cos(theta)**10 + 42625.5908203125*cos(theta)**8 - 18944.70703125*cos(theta)**6 + 3739.0869140625*cos(theta)**4 - 263.935546875*cos(theta)**2 + 2.9326171875)*sin(phi)

@torch.jit.script
def Yl13_m0(theta, phi):
    return 1860.99583201813*cos(theta)**13 - 5806.30699589657*cos(theta)**11 + 6942.32358205025*cos(theta)**9 - 3967.04204688585*cos(theta)**7 + 1096.15635506056*cos(theta)**5 - 128.959571183596*cos(theta)**3 + 4.29865237278653*cos(theta)

@torch.jit.script
def Yl13_m1(theta, phi):
    return 0.153658381323621*(1.0 - cos(theta)**2)**0.5*(16504.8583984375*cos(theta)**12 - 43572.826171875*cos(theta)**10 + 42625.5908203125*cos(theta)**8 - 18944.70703125*cos(theta)**6 + 3739.0869140625*cos(theta)**4 - 263.935546875*cos(theta)**2 + 2.9326171875)*cos(phi)

@torch.jit.script
def Yl13_m2(theta, phi):
    return 0.0114530195317401*(1.0 - cos(theta)**2)*(198058.30078125*cos(theta)**11 - 435728.26171875*cos(theta)**9 + 341004.7265625*cos(theta)**7 - 113668.2421875*cos(theta)**5 + 14956.34765625*cos(theta)**3 - 527.87109375*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl13_m3(theta, phi):
    return 0.000863303829622583*(1.0 - cos(theta)**2)**1.5*(2178641.30859375*cos(theta)**10 - 3921554.35546875*cos(theta)**8 + 2387033.0859375*cos(theta)**6 - 568341.2109375*cos(theta)**4 + 44869.04296875*cos(theta)**2 - 527.87109375)*cos(3*phi)

@torch.jit.script
def Yl13_m4(theta, phi):
    return 6.62123812058377e-5*(1.0 - cos(theta)**2)**2*(21786413.0859375*cos(theta)**9 - 31372434.84375*cos(theta)**7 + 14322198.515625*cos(theta)**5 - 2273364.84375*cos(theta)**3 + 89738.0859375*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl13_m5(theta, phi):
    return 5.2021359721285e-6*(1.0 - cos(theta)**2)**2.5*(196077717.773438*cos(theta)**8 - 219607043.90625*cos(theta)**6 + 71610992.578125*cos(theta)**4 - 6820094.53125*cos(theta)**2 + 89738.0859375)*cos(5*phi)

@torch.jit.script
def Yl13_m6(theta, phi):
    return 4.21948945157073e-7*(1.0 - cos(theta)**2)**3*(1568621742.1875*cos(theta)**7 - 1317642263.4375*cos(theta)**5 + 286443970.3125*cos(theta)**3 - 13640189.0625*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl13_m7(theta, phi):
    return 3.5661194627771e-8*(1.0 - cos(theta)**2)**3.5*(10980352195.3125*cos(theta)**6 - 6588211317.1875*cos(theta)**4 + 859331910.9375*cos(theta)**2 - 13640189.0625)*cos(7*phi)

@torch.jit.script
def Yl13_m8(theta, phi):
    return 3.17695172143292e-9*(1.0 - cos(theta)**2)**4*(65882113171.875*cos(theta)**5 - 26352845268.75*cos(theta)**3 + 1718663821.875*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl13_m9(theta, phi):
    return 3.02910461422567e-10*(1.0 - cos(theta)**2)**4.5*(329410565859.375*cos(theta)**4 - 79058535806.25*cos(theta)**2 + 1718663821.875)*cos(9*phi)

@torch.jit.script
def Yl13_m10(theta, phi):
    return 3.15805986876424e-11*(1.0 - cos(theta)**2)**5*(1317642263437.5*cos(theta)**3 - 158117071612.5*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl13_m11(theta, phi):
    return 3.72180924766049e-12*(1.0 - cos(theta)**2)**5.5*(3952926790312.5*cos(theta)**2 - 158117071612.5)*cos(11*phi)

@torch.jit.script
def Yl13_m12(theta, phi):
    return 4.16119315354964*(1.0 - cos(theta)**2)**6*cos(12*phi)*cos(theta)

@torch.jit.script
def Yl13_m13(theta, phi):
    return 0.816077118837628*(1.0 - cos(theta)**2)**6.5*cos(13*phi)

@torch.jit.script
def Yl14_m_minus_14(theta, phi):
    return 0.830522083064524*(1.0 - cos(theta)**2)**7*sin(14*phi)

@torch.jit.script
def Yl14_m_minus_13(theta, phi):
    return 4.39470978027212*(1.0 - cos(theta)**2)**6.5*sin(13*phi)*cos(theta)

@torch.jit.script
def Yl14_m_minus_12(theta, phi):
    return 1.51291507116349e-13*(1.0 - cos(theta)**2)**6*(106729023338438.0*cos(theta)**2 - 3952926790312.5)*sin(12*phi)

@torch.jit.script
def Yl14_m_minus_11(theta, phi):
    return 1.33617041195793e-12*(1.0 - cos(theta)**2)**5.5*(35576341112812.5*cos(theta)**3 - 3952926790312.5*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl14_m_minus_10(theta, phi):
    return 1.33617041195793e-11*(1.0 - cos(theta)**2)**5*(8894085278203.13*cos(theta)**4 - 1976463395156.25*cos(theta)**2 + 39529267903.125)*sin(10*phi)

@torch.jit.script
def Yl14_m_minus_9(theta, phi):
    return 1.46370135060066e-10*(1.0 - cos(theta)**2)**4.5*(1778817055640.63*cos(theta)**5 - 658821131718.75*cos(theta)**3 + 39529267903.125*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl14_m_minus_8(theta, phi):
    return 1.71945976061531e-9*(1.0 - cos(theta)**2)**4*(296469509273.438*cos(theta)**6 - 164705282929.688*cos(theta)**4 + 19764633951.5625*cos(theta)**2 - 286443970.3125)*sin(8*phi)

@torch.jit.script
def Yl14_m_minus_7(theta, phi):
    return 2.13379344766496e-8*(1.0 - cos(theta)**2)**3.5*(42352787039.0625*cos(theta)**7 - 32941056585.9375*cos(theta)**5 + 6588211317.1875*cos(theta)**3 - 286443970.3125*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl14_m_minus_6(theta, phi):
    return 2.76571240765567e-7*(1.0 - cos(theta)**2)**3*(5294098379.88281*cos(theta)**8 - 5490176097.65625*cos(theta)**6 + 1647052829.29688*cos(theta)**4 - 143221985.15625*cos(theta)**2 + 1705023.6328125)*sin(6*phi)

@torch.jit.script
def Yl14_m_minus_5(theta, phi):
    return 3.71059256983961e-6*(1.0 - cos(theta)**2)**2.5*(588233153.320313*cos(theta)**9 - 784310871.09375*cos(theta)**7 + 329410565.859375*cos(theta)**5 - 47740661.71875*cos(theta)**3 + 1705023.6328125*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl14_m_minus_4(theta, phi):
    return 5.11469888818129e-5*(1.0 - cos(theta)**2)**2*(58823315.3320313*cos(theta)**10 - 98038858.8867188*cos(theta)**8 + 54901760.9765625*cos(theta)**6 - 11935165.4296875*cos(theta)**4 + 852511.81640625*cos(theta)**2 - 8973.80859375)*sin(4*phi)

@torch.jit.script
def Yl14_m_minus_3(theta, phi):
    return 0.000719701928156307*(1.0 - cos(theta)**2)**1.5*(5347574.12109375*cos(theta)**11 - 10893206.5429688*cos(theta)**9 + 7843108.7109375*cos(theta)**7 - 2387033.0859375*cos(theta)**5 + 284170.60546875*cos(theta)**3 - 8973.80859375*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl14_m_minus_2(theta, phi):
    return 0.0102793996196251*(1.0 - cos(theta)**2)*(445631.176757813*cos(theta)**12 - 1089320.65429688*cos(theta)**10 + 980388.588867188*cos(theta)**8 - 397838.84765625*cos(theta)**6 + 71042.6513671875*cos(theta)**4 - 4486.904296875*cos(theta)**2 + 43.9892578125)*sin(2*phi)

@torch.jit.script
def Yl14_m_minus_1(theta, phi):
    return 0.148251609638173*(1.0 - cos(theta)**2)**0.5*(34279.3212890625*cos(theta)**13 - 99029.150390625*cos(theta)**11 + 108932.065429688*cos(theta)**9 - 56834.12109375*cos(theta)**7 + 14208.5302734375*cos(theta)**5 - 1495.634765625*cos(theta)**3 + 43.9892578125*cos(theta))*sin(phi)

@torch.jit.script
def Yl14_m0(theta, phi):
    return 3719.61718745389*cos(theta)**14 - 12536.487557715*cos(theta)**12 + 16548.1635761838*cos(theta)**10 - 10792.2805931633*cos(theta)**8 + 3597.42686438778*cos(theta)**6 - 568.014768061228*cos(theta)**4 + 33.4126334153663*cos(theta)**2 - 0.318215556336822

@torch.jit.script
def Yl14_m1(theta, phi):
    return 0.148251609638173*(1.0 - cos(theta)**2)**0.5*(34279.3212890625*cos(theta)**13 - 99029.150390625*cos(theta)**11 + 108932.065429688*cos(theta)**9 - 56834.12109375*cos(theta)**7 + 14208.5302734375*cos(theta)**5 - 1495.634765625*cos(theta)**3 + 43.9892578125*cos(theta))*cos(phi)

@torch.jit.script
def Yl14_m2(theta, phi):
    return 0.0102793996196251*(1.0 - cos(theta)**2)*(445631.176757813*cos(theta)**12 - 1089320.65429688*cos(theta)**10 + 980388.588867188*cos(theta)**8 - 397838.84765625*cos(theta)**6 + 71042.6513671875*cos(theta)**4 - 4486.904296875*cos(theta)**2 + 43.9892578125)*cos(2*phi)

@torch.jit.script
def Yl14_m3(theta, phi):
    return 0.000719701928156307*(1.0 - cos(theta)**2)**1.5*(5347574.12109375*cos(theta)**11 - 10893206.5429688*cos(theta)**9 + 7843108.7109375*cos(theta)**7 - 2387033.0859375*cos(theta)**5 + 284170.60546875*cos(theta)**3 - 8973.80859375*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl14_m4(theta, phi):
    return 5.11469888818129e-5*(1.0 - cos(theta)**2)**2*(58823315.3320313*cos(theta)**10 - 98038858.8867188*cos(theta)**8 + 54901760.9765625*cos(theta)**6 - 11935165.4296875*cos(theta)**4 + 852511.81640625*cos(theta)**2 - 8973.80859375)*cos(4*phi)

@torch.jit.script
def Yl14_m5(theta, phi):
    return 3.71059256983961e-6*(1.0 - cos(theta)**2)**2.5*(588233153.320313*cos(theta)**9 - 784310871.09375*cos(theta)**7 + 329410565.859375*cos(theta)**5 - 47740661.71875*cos(theta)**3 + 1705023.6328125*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl14_m6(theta, phi):
    return 2.76571240765567e-7*(1.0 - cos(theta)**2)**3*(5294098379.88281*cos(theta)**8 - 5490176097.65625*cos(theta)**6 + 1647052829.29688*cos(theta)**4 - 143221985.15625*cos(theta)**2 + 1705023.6328125)*cos(6*phi)

@torch.jit.script
def Yl14_m7(theta, phi):
    return 2.13379344766496e-8*(1.0 - cos(theta)**2)**3.5*(42352787039.0625*cos(theta)**7 - 32941056585.9375*cos(theta)**5 + 6588211317.1875*cos(theta)**3 - 286443970.3125*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl14_m8(theta, phi):
    return 1.71945976061531e-9*(1.0 - cos(theta)**2)**4*(296469509273.438*cos(theta)**6 - 164705282929.688*cos(theta)**4 + 19764633951.5625*cos(theta)**2 - 286443970.3125)*cos(8*phi)

@torch.jit.script
def Yl14_m9(theta, phi):
    return 1.46370135060066e-10*(1.0 - cos(theta)**2)**4.5*(1778817055640.63*cos(theta)**5 - 658821131718.75*cos(theta)**3 + 39529267903.125*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl14_m10(theta, phi):
    return 1.33617041195793e-11*(1.0 - cos(theta)**2)**5*(8894085278203.13*cos(theta)**4 - 1976463395156.25*cos(theta)**2 + 39529267903.125)*cos(10*phi)

@torch.jit.script
def Yl14_m11(theta, phi):
    return 1.33617041195793e-12*(1.0 - cos(theta)**2)**5.5*(35576341112812.5*cos(theta)**3 - 3952926790312.5*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl14_m12(theta, phi):
    return 1.51291507116349e-13*(1.0 - cos(theta)**2)**6*(106729023338438.0*cos(theta)**2 - 3952926790312.5)*cos(12*phi)

@torch.jit.script
def Yl14_m13(theta, phi):
    return 4.39470978027212*(1.0 - cos(theta)**2)**6.5*cos(13*phi)*cos(theta)

@torch.jit.script
def Yl14_m14(theta, phi):
    return 0.830522083064524*(1.0 - cos(theta)**2)**7*cos(14*phi)

@torch.jit.script
def Yl15_m_minus_15(theta, phi):
    return 0.844250650857373*(1.0 - cos(theta)**2)**7.5*sin(15*phi)

@torch.jit.script
def Yl15_m_minus_14(theta, phi):
    return 4.62415125663001*(1.0 - cos(theta)**2)**7*sin(14*phi)*cos(theta)

@torch.jit.script
def Yl15_m_minus_13(theta, phi):
    return 5.68899431025918e-15*(1.0 - cos(theta)**2)**6.5*(3.09514167681469e+15*cos(theta)**2 - 106729023338438.0)*sin(13*phi)

@torch.jit.script
def Yl15_m_minus_12(theta, phi):
    return 5.21404941098716e-14*(1.0 - cos(theta)**2)**6*(1.03171389227156e+15*cos(theta)**3 - 106729023338438.0*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl15_m_minus_11(theta, phi):
    return 5.4185990958026e-13*(1.0 - cos(theta)**2)**5.5*(257928473067891.0*cos(theta)**4 - 53364511669218.8*cos(theta)**2 + 988231697578.125)*sin(11*phi)

@torch.jit.script
def Yl15_m_minus_10(theta, phi):
    return 6.17815352749854e-12*(1.0 - cos(theta)**2)**5*(51585694613578.1*cos(theta)**5 - 17788170556406.3*cos(theta)**3 + 988231697578.125*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl15_m_minus_9(theta, phi):
    return 7.56666184747369e-11*(1.0 - cos(theta)**2)**4.5*(8597615768929.69*cos(theta)**6 - 4447042639101.56*cos(theta)**4 + 494115848789.063*cos(theta)**2 - 6588211317.1875)*sin(9*phi)

@torch.jit.script
def Yl15_m_minus_8(theta, phi):
    return 9.80751467720255e-10*(1.0 - cos(theta)**2)**4*(1228230824132.81*cos(theta)**7 - 889408527820.313*cos(theta)**5 + 164705282929.688*cos(theta)**3 - 6588211317.1875*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl15_m_minus_7(theta, phi):
    return 1.33035601710264e-8*(1.0 - cos(theta)**2)**3.5*(153528853016.602*cos(theta)**8 - 148234754636.719*cos(theta)**6 + 41176320732.4219*cos(theta)**4 - 3294105658.59375*cos(theta)**2 + 35805496.2890625)*sin(7*phi)

@torch.jit.script
def Yl15_m_minus_6(theta, phi):
    return 1.87197684863824e-7*(1.0 - cos(theta)**2)**3*(17058761446.2891*cos(theta)**9 - 21176393519.5313*cos(theta)**7 + 8235264146.48438*cos(theta)**5 - 1098035219.53125*cos(theta)**3 + 35805496.2890625*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl15_m_minus_5(theta, phi):
    return 2.71275217737612e-6*(1.0 - cos(theta)**2)**2.5*(1705876144.62891*cos(theta)**10 - 2647049189.94141*cos(theta)**8 + 1372544024.41406*cos(theta)**6 - 274508804.882813*cos(theta)**4 + 17902748.1445313*cos(theta)**2 - 170502.36328125)*sin(5*phi)

@torch.jit.script
def Yl15_m_minus_4(theta, phi):
    return 4.02366171874445e-5*(1.0 - cos(theta)**2)**2*(155079649.511719*cos(theta)**11 - 294116576.660156*cos(theta)**9 + 196077717.773438*cos(theta)**7 - 54901760.9765625*cos(theta)**5 + 5967582.71484375*cos(theta)**3 - 170502.36328125*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl15_m_minus_3(theta, phi):
    return 0.000607559596001151*(1.0 - cos(theta)**2)**1.5*(12923304.1259766*cos(theta)**12 - 29411657.6660156*cos(theta)**10 + 24509714.7216797*cos(theta)**8 - 9150293.49609375*cos(theta)**6 + 1491895.67871094*cos(theta)**4 - 85251.181640625*cos(theta)**2 + 747.8173828125)*sin(3*phi)

@torch.jit.script
def Yl15_m_minus_2(theta, phi):
    return 0.00929387470704126*(1.0 - cos(theta)**2)*(994100.317382813*cos(theta)**13 - 2673787.06054688*cos(theta)**11 + 2723301.63574219*cos(theta)**9 - 1307184.78515625*cos(theta)**7 + 298379.135742188*cos(theta)**5 - 28417.060546875*cos(theta)**3 + 747.8173828125*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl15_m_minus_1(theta, phi):
    return 0.143378915753688*(1.0 - cos(theta)**2)**0.5*(71007.1655273438*cos(theta)**14 - 222815.588378906*cos(theta)**12 + 272330.163574219*cos(theta)**10 - 163398.098144531*cos(theta)**8 + 49729.8559570313*cos(theta)**6 - 7104.26513671875*cos(theta)**4 + 373.90869140625*cos(theta)**2 - 3.14208984375)*sin(phi)

@torch.jit.script
def Yl15_m0(theta, phi):
    return 7435.10031825349*cos(theta)**15 - 26920.1908074695*cos(theta)**13 + 38884.7200552338*cos(theta)**11 - 28515.4613738381*cos(theta)**9 + 11158.2240158497*cos(theta)**7 - 2231.64480316994*cos(theta)**5 + 195.758316067539*cos(theta)**3 - 4.93508359834131*cos(theta)

@torch.jit.script
def Yl15_m1(theta, phi):
    return 0.143378915753688*(1.0 - cos(theta)**2)**0.5*(71007.1655273438*cos(theta)**14 - 222815.588378906*cos(theta)**12 + 272330.163574219*cos(theta)**10 - 163398.098144531*cos(theta)**8 + 49729.8559570313*cos(theta)**6 - 7104.26513671875*cos(theta)**4 + 373.90869140625*cos(theta)**2 - 3.14208984375)*cos(phi)

@torch.jit.script
def Yl15_m2(theta, phi):
    return 0.00929387470704126*(1.0 - cos(theta)**2)*(994100.317382813*cos(theta)**13 - 2673787.06054688*cos(theta)**11 + 2723301.63574219*cos(theta)**9 - 1307184.78515625*cos(theta)**7 + 298379.135742188*cos(theta)**5 - 28417.060546875*cos(theta)**3 + 747.8173828125*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl15_m3(theta, phi):
    return 0.000607559596001151*(1.0 - cos(theta)**2)**1.5*(12923304.1259766*cos(theta)**12 - 29411657.6660156*cos(theta)**10 + 24509714.7216797*cos(theta)**8 - 9150293.49609375*cos(theta)**6 + 1491895.67871094*cos(theta)**4 - 85251.181640625*cos(theta)**2 + 747.8173828125)*cos(3*phi)

@torch.jit.script
def Yl15_m4(theta, phi):
    return 4.02366171874445e-5*(1.0 - cos(theta)**2)**2*(155079649.511719*cos(theta)**11 - 294116576.660156*cos(theta)**9 + 196077717.773438*cos(theta)**7 - 54901760.9765625*cos(theta)**5 + 5967582.71484375*cos(theta)**3 - 170502.36328125*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl15_m5(theta, phi):
    return 2.71275217737612e-6*(1.0 - cos(theta)**2)**2.5*(1705876144.62891*cos(theta)**10 - 2647049189.94141*cos(theta)**8 + 1372544024.41406*cos(theta)**6 - 274508804.882813*cos(theta)**4 + 17902748.1445313*cos(theta)**2 - 170502.36328125)*cos(5*phi)

@torch.jit.script
def Yl15_m6(theta, phi):
    return 1.87197684863824e-7*(1.0 - cos(theta)**2)**3*(17058761446.2891*cos(theta)**9 - 21176393519.5313*cos(theta)**7 + 8235264146.48438*cos(theta)**5 - 1098035219.53125*cos(theta)**3 + 35805496.2890625*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl15_m7(theta, phi):
    return 1.33035601710264e-8*(1.0 - cos(theta)**2)**3.5*(153528853016.602*cos(theta)**8 - 148234754636.719*cos(theta)**6 + 41176320732.4219*cos(theta)**4 - 3294105658.59375*cos(theta)**2 + 35805496.2890625)*cos(7*phi)

@torch.jit.script
def Yl15_m8(theta, phi):
    return 9.80751467720255e-10*(1.0 - cos(theta)**2)**4*(1228230824132.81*cos(theta)**7 - 889408527820.313*cos(theta)**5 + 164705282929.688*cos(theta)**3 - 6588211317.1875*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl15_m9(theta, phi):
    return 7.56666184747369e-11*(1.0 - cos(theta)**2)**4.5*(8597615768929.69*cos(theta)**6 - 4447042639101.56*cos(theta)**4 + 494115848789.063*cos(theta)**2 - 6588211317.1875)*cos(9*phi)

@torch.jit.script
def Yl15_m10(theta, phi):
    return 6.17815352749854e-12*(1.0 - cos(theta)**2)**5*(51585694613578.1*cos(theta)**5 - 17788170556406.3*cos(theta)**3 + 988231697578.125*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl15_m11(theta, phi):
    return 5.4185990958026e-13*(1.0 - cos(theta)**2)**5.5*(257928473067891.0*cos(theta)**4 - 53364511669218.8*cos(theta)**2 + 988231697578.125)*cos(11*phi)

@torch.jit.script
def Yl15_m12(theta, phi):
    return 5.21404941098716e-14*(1.0 - cos(theta)**2)**6*(1.03171389227156e+15*cos(theta)**3 - 106729023338438.0*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl15_m13(theta, phi):
    return 5.68899431025918e-15*(1.0 - cos(theta)**2)**6.5*(3.09514167681469e+15*cos(theta)**2 - 106729023338438.0)*cos(13*phi)

@torch.jit.script
def Yl15_m14(theta, phi):
    return 4.62415125663001*(1.0 - cos(theta)**2)**7*cos(14*phi)*cos(theta)

@torch.jit.script
def Yl15_m15(theta, phi):
    return 0.844250650857373*(1.0 - cos(theta)**2)**7.5*cos(15*phi)

@torch.jit.script
def Yl16_m_minus_16(theta, phi):
    return 0.857340588838025*(1.0 - cos(theta)**2)**8*sin(16*phi)

@torch.jit.script
def Yl16_m_minus_15(theta, phi):
    return 4.84985075323068*(1.0 - cos(theta)**2)**7.5*sin(15*phi)*cos(theta)

@torch.jit.script
def Yl16_m_minus_14(theta, phi):
    return 1.98999505000411e-16*(1.0 - cos(theta)**2)**7*(9.59493919812553e+16*cos(theta)**2 - 3.09514167681469e+15)*sin(14*phi)

@torch.jit.script
def Yl16_m_minus_13(theta, phi):
    return 1.8878750671421e-15*(1.0 - cos(theta)**2)**6.5*(3.19831306604184e+16*cos(theta)**3 - 3.09514167681469e+15*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl16_m_minus_12(theta, phi):
    return 2.03330367436807e-14*(1.0 - cos(theta)**2)**6*(7.99578266510461e+15*cos(theta)**4 - 1.54757083840734e+15*cos(theta)**2 + 26682255834609.4)*sin(12*phi)

@torch.jit.script
def Yl16_m_minus_11(theta, phi):
    return 2.40583735216622e-13*(1.0 - cos(theta)**2)**5.5*(1.59915653302092e+15*cos(theta)**5 - 515856946135781.0*cos(theta)**3 + 26682255834609.4*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl16_m_minus_10(theta, phi):
    return 3.06213103106751e-12*(1.0 - cos(theta)**2)**5*(266526088836820.0*cos(theta)**6 - 128964236533945.0*cos(theta)**4 + 13341127917304.7*cos(theta)**2 - 164705282929.688)*sin(10*phi)

@torch.jit.script
def Yl16_m_minus_9(theta, phi):
    return 4.1310406124361e-11*(1.0 - cos(theta)**2)**4.5*(38075155548117.2*cos(theta)**7 - 25792847306789.1*cos(theta)**5 + 4447042639101.56*cos(theta)**3 - 164705282929.688*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl16_m_minus_8(theta, phi):
    return 5.84217366082119e-10*(1.0 - cos(theta)**2)**4*(4759394443514.65*cos(theta)**8 - 4298807884464.84*cos(theta)**6 + 1111760659775.39*cos(theta)**4 - 82352641464.8438*cos(theta)**2 + 823526414.648438)*sin(8*phi)

@torch.jit.script
def Yl16_m_minus_7(theta, phi):
    return 8.58620667464373e-9*(1.0 - cos(theta)**2)**3.5*(528821604834.961*cos(theta)**9 - 614115412066.406*cos(theta)**7 + 222352131955.078*cos(theta)**5 - 27450880488.2813*cos(theta)**3 + 823526414.648438*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl16_m_minus_6(theta, phi):
    return 1.30216271501415e-7*(1.0 - cos(theta)**2)**3*(52882160483.4961*cos(theta)**10 - 76764426508.3008*cos(theta)**8 + 37058688659.1797*cos(theta)**6 - 6862720122.07031*cos(theta)**4 + 411763207.324219*cos(theta)**2 - 3580549.62890625)*sin(6*phi)

@torch.jit.script
def Yl16_m_minus_5(theta, phi):
    return 2.02568978918854e-6*(1.0 - cos(theta)**2)**2.5*(4807469134.86328*cos(theta)**11 - 8529380723.14453*cos(theta)**9 + 5294098379.88281*cos(theta)**7 - 1372544024.41406*cos(theta)**5 + 137254402.441406*cos(theta)**3 - 3580549.62890625*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl16_m_minus_4(theta, phi):
    return 3.21568284933344e-5*(1.0 - cos(theta)**2)**2*(400622427.905273*cos(theta)**12 - 852938072.314453*cos(theta)**10 + 661762297.485352*cos(theta)**8 - 228757337.402344*cos(theta)**6 + 34313600.6103516*cos(theta)**4 - 1790274.81445313*cos(theta)**2 + 14208.5302734375)*sin(4*phi)

@torch.jit.script
def Yl16_m_minus_3(theta, phi):
    return 0.000518513279362185*(1.0 - cos(theta)**2)**1.5*(30817109.8388672*cos(theta)**13 - 77539824.7558594*cos(theta)**11 + 73529144.1650391*cos(theta)**9 - 32679619.6289063*cos(theta)**7 + 6862720.12207031*cos(theta)**5 - 596758.271484375*cos(theta)**3 + 14208.5302734375*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl16_m_minus_2(theta, phi):
    return 0.00845669566395355*(1.0 - cos(theta)**2)*(2201222.13134766*cos(theta)**14 - 6461652.06298828*cos(theta)**12 + 7352914.41650391*cos(theta)**10 - 4084952.45361328*cos(theta)**8 + 1143786.68701172*cos(theta)**6 - 149189.567871094*cos(theta)**4 + 7104.26513671875*cos(theta)**2 - 53.41552734375)*sin(2*phi)

@torch.jit.script
def Yl16_m_minus_1(theta, phi):
    return 0.138957689313105*(1.0 - cos(theta)**2)**0.5*(146748.142089844*cos(theta)**15 - 497050.158691406*cos(theta)**13 + 668446.765136719*cos(theta)**11 - 453883.605957031*cos(theta)**9 + 163398.098144531*cos(theta)**7 - 29837.9135742188*cos(theta)**5 + 2368.08837890625*cos(theta)**3 - 53.41552734375*cos(theta))*sin(phi)

@torch.jit.script
def Yl16_m0(theta, phi):
    return 14862.9380228203*cos(theta)**16 - 57533.9536367237*cos(theta)**14 + 90268.7893265838*cos(theta)**12 - 73552.3468586979*cos(theta)**10 + 33098.5560864141*cos(theta)**8 - 8058.77887321386*cos(theta)**6 + 959.378437287364*cos(theta)**4 - 43.2802302535653*cos(theta)**2 + 0.318236987158568

@torch.jit.script
def Yl16_m1(theta, phi):
    return 0.138957689313105*(1.0 - cos(theta)**2)**0.5*(146748.142089844*cos(theta)**15 - 497050.158691406*cos(theta)**13 + 668446.765136719*cos(theta)**11 - 453883.605957031*cos(theta)**9 + 163398.098144531*cos(theta)**7 - 29837.9135742188*cos(theta)**5 + 2368.08837890625*cos(theta)**3 - 53.41552734375*cos(theta))*cos(phi)

@torch.jit.script
def Yl16_m2(theta, phi):
    return 0.00845669566395355*(1.0 - cos(theta)**2)*(2201222.13134766*cos(theta)**14 - 6461652.06298828*cos(theta)**12 + 7352914.41650391*cos(theta)**10 - 4084952.45361328*cos(theta)**8 + 1143786.68701172*cos(theta)**6 - 149189.567871094*cos(theta)**4 + 7104.26513671875*cos(theta)**2 - 53.41552734375)*cos(2*phi)

@torch.jit.script
def Yl16_m3(theta, phi):
    return 0.000518513279362185*(1.0 - cos(theta)**2)**1.5*(30817109.8388672*cos(theta)**13 - 77539824.7558594*cos(theta)**11 + 73529144.1650391*cos(theta)**9 - 32679619.6289063*cos(theta)**7 + 6862720.12207031*cos(theta)**5 - 596758.271484375*cos(theta)**3 + 14208.5302734375*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl16_m4(theta, phi):
    return 3.21568284933344e-5*(1.0 - cos(theta)**2)**2*(400622427.905273*cos(theta)**12 - 852938072.314453*cos(theta)**10 + 661762297.485352*cos(theta)**8 - 228757337.402344*cos(theta)**6 + 34313600.6103516*cos(theta)**4 - 1790274.81445313*cos(theta)**2 + 14208.5302734375)*cos(4*phi)

@torch.jit.script
def Yl16_m5(theta, phi):
    return 2.02568978918854e-6*(1.0 - cos(theta)**2)**2.5*(4807469134.86328*cos(theta)**11 - 8529380723.14453*cos(theta)**9 + 5294098379.88281*cos(theta)**7 - 1372544024.41406*cos(theta)**5 + 137254402.441406*cos(theta)**3 - 3580549.62890625*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl16_m6(theta, phi):
    return 1.30216271501415e-7*(1.0 - cos(theta)**2)**3*(52882160483.4961*cos(theta)**10 - 76764426508.3008*cos(theta)**8 + 37058688659.1797*cos(theta)**6 - 6862720122.07031*cos(theta)**4 + 411763207.324219*cos(theta)**2 - 3580549.62890625)*cos(6*phi)

@torch.jit.script
def Yl16_m7(theta, phi):
    return 8.58620667464373e-9*(1.0 - cos(theta)**2)**3.5*(528821604834.961*cos(theta)**9 - 614115412066.406*cos(theta)**7 + 222352131955.078*cos(theta)**5 - 27450880488.2813*cos(theta)**3 + 823526414.648438*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl16_m8(theta, phi):
    return 5.84217366082119e-10*(1.0 - cos(theta)**2)**4*(4759394443514.65*cos(theta)**8 - 4298807884464.84*cos(theta)**6 + 1111760659775.39*cos(theta)**4 - 82352641464.8438*cos(theta)**2 + 823526414.648438)*cos(8*phi)

@torch.jit.script
def Yl16_m9(theta, phi):
    return 4.1310406124361e-11*(1.0 - cos(theta)**2)**4.5*(38075155548117.2*cos(theta)**7 - 25792847306789.1*cos(theta)**5 + 4447042639101.56*cos(theta)**3 - 164705282929.688*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl16_m10(theta, phi):
    return 3.06213103106751e-12*(1.0 - cos(theta)**2)**5*(266526088836820.0*cos(theta)**6 - 128964236533945.0*cos(theta)**4 + 13341127917304.7*cos(theta)**2 - 164705282929.688)*cos(10*phi)

@torch.jit.script
def Yl16_m11(theta, phi):
    return 2.40583735216622e-13*(1.0 - cos(theta)**2)**5.5*(1.59915653302092e+15*cos(theta)**5 - 515856946135781.0*cos(theta)**3 + 26682255834609.4*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl16_m12(theta, phi):
    return 2.03330367436807e-14*(1.0 - cos(theta)**2)**6*(7.99578266510461e+15*cos(theta)**4 - 1.54757083840734e+15*cos(theta)**2 + 26682255834609.4)*cos(12*phi)

@torch.jit.script
def Yl16_m13(theta, phi):
    return 1.8878750671421e-15*(1.0 - cos(theta)**2)**6.5*(3.19831306604184e+16*cos(theta)**3 - 3.09514167681469e+15*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl16_m14(theta, phi):
    return 1.98999505000411e-16*(1.0 - cos(theta)**2)**7*(9.59493919812553e+16*cos(theta)**2 - 3.09514167681469e+15)*cos(14*phi)

@torch.jit.script
def Yl16_m15(theta, phi):
    return 4.84985075323068*(1.0 - cos(theta)**2)**7.5*cos(15*phi)*cos(theta)

@torch.jit.script
def Yl16_m16(theta, phi):
    return 0.857340588838025*(1.0 - cos(theta)**2)**8*cos(16*phi)

@torch.jit.script
def Yl17_m_minus_17(theta, phi):
    return 0.869857171920628*(1.0 - cos(theta)**2)**8.5*sin(17*phi)

@torch.jit.script
def Yl17_m_minus_16(theta, phi):
    return 5.07209532485536*(1.0 - cos(theta)**2)**8*sin(16*phi)*cos(theta)

@torch.jit.script
def Yl17_m_minus_15(theta, phi):
    return 6.50688621401289e-18*(1.0 - cos(theta)**2)**7.5*(3.16632993538143e+18*cos(theta)**2 - 9.59493919812553e+16)*sin(15*phi)

@torch.jit.script
def Yl17_m_minus_14(theta, phi):
    return 6.37542041547274e-17*(1.0 - cos(theta)**2)**7*(1.05544331179381e+18*cos(theta)**3 - 9.59493919812553e+16*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl17_m_minus_13(theta, phi):
    return 7.09936771746562e-16*(1.0 - cos(theta)**2)**6.5*(2.63860827948452e+17*cos(theta)**4 - 4.79746959906277e+16*cos(theta)**2 + 773785419203672.0)*sin(13*phi)

@torch.jit.script
def Yl17_m_minus_12(theta, phi):
    return 8.69491420208903e-15*(1.0 - cos(theta)**2)**6*(5.27721655896904e+16*cos(theta)**5 - 1.59915653302092e+16*cos(theta)**3 + 773785419203672.0*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl17_m_minus_11(theta, phi):
    return 1.14693795555008e-13*(1.0 - cos(theta)**2)**5.5*(8.79536093161507e+15*cos(theta)**6 - 3.9978913325523e+15*cos(theta)**4 + 386892709601836.0*cos(theta)**2 - 4447042639101.56)*sin(11*phi)

@torch.jit.script
def Yl17_m_minus_10(theta, phi):
    return 1.60571313777011e-12*(1.0 - cos(theta)**2)**5*(1.25648013308787e+15*cos(theta)**7 - 799578266510461.0*cos(theta)**5 + 128964236533945.0*cos(theta)**3 - 4447042639101.56*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl17_m_minus_9(theta, phi):
    return 2.35990671649205e-11*(1.0 - cos(theta)**2)**4.5*(157060016635983.0*cos(theta)**8 - 133263044418410.0*cos(theta)**6 + 32241059133486.3*cos(theta)**4 - 2223521319550.78*cos(theta)**2 + 20588160366.2109)*sin(9*phi)

@torch.jit.script
def Yl17_m_minus_8(theta, phi):
    return 3.60996311929549e-10*(1.0 - cos(theta)**2)**4*(17451112959553.7*cos(theta)**9 - 19037577774058.6*cos(theta)**7 + 6448211826697.27*cos(theta)**5 - 741173773183.594*cos(theta)**3 + 20588160366.2109*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl17_m_minus_7(theta, phi):
    return 5.70785286308994e-9*(1.0 - cos(theta)**2)**3.5*(1745111295955.37*cos(theta)**10 - 2379697221757.32*cos(theta)**8 + 1074701971116.21*cos(theta)**6 - 185293443295.898*cos(theta)**4 + 10294080183.1055*cos(theta)**2 - 82352641.4648438)*sin(7*phi)

@torch.jit.script
def Yl17_m_minus_6(theta, phi):
    return 9.2741631735508e-8*(1.0 - cos(theta)**2)**3*(158646481450.488*cos(theta)**11 - 264410802417.48*cos(theta)**9 + 153528853016.602*cos(theta)**7 - 37058688659.1797*cos(theta)**5 + 3431360061.03516*cos(theta)**3 - 82352641.4648438*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl17_m_minus_5(theta, phi):
    return 1.54073970252026e-6*(1.0 - cos(theta)**2)**2.5*(13220540120.874*cos(theta)**12 - 26441080241.748*cos(theta)**10 + 19191106627.0752*cos(theta)**8 - 6176448109.86328*cos(theta)**6 + 857840015.258789*cos(theta)**4 - 41176320.7324219*cos(theta)**2 + 298379.135742188)*sin(5*phi)

@torch.jit.script
def Yl17_m_minus_4(theta, phi):
    return 2.6056272673653e-5*(1.0 - cos(theta)**2)**2*(1016964624.68262*cos(theta)**13 - 2403734567.43164*cos(theta)**11 + 2132345180.78613*cos(theta)**9 - 882349729.980469*cos(theta)**7 + 171568003.051758*cos(theta)**5 - 13725440.2441406*cos(theta)**3 + 298379.135742188*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl17_m_minus_3(theta, phi):
    return 0.000446772008544923*(1.0 - cos(theta)**2)**1.5*(72640330.3344727*cos(theta)**14 - 200311213.952637*cos(theta)**12 + 213234518.078613*cos(theta)**10 - 110293716.247559*cos(theta)**8 + 28594667.175293*cos(theta)**6 - 3431360.06103516*cos(theta)**4 + 149189.567871094*cos(theta)**2 - 1014.89501953125)*sin(3*phi)

@torch.jit.script
def Yl17_m_minus_2(theta, phi):
    return 0.00773831818199403*(1.0 - cos(theta)**2)*(4842688.68896484*cos(theta)**15 - 15408554.9194336*cos(theta)**13 + 19384956.1889648*cos(theta)**11 - 12254857.3608398*cos(theta)**9 + 4084952.45361328*cos(theta)**7 - 686272.012207031*cos(theta)**5 + 49729.8559570313*cos(theta)**3 - 1014.89501953125*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl17_m_minus_1(theta, phi):
    return 0.134922187793101*(1.0 - cos(theta)**2)**0.5*(302668.043060303*cos(theta)**16 - 1100611.06567383*cos(theta)**14 + 1615413.01574707*cos(theta)**12 - 1225485.73608398*cos(theta)**10 + 510619.05670166*cos(theta)**8 - 114378.668701172*cos(theta)**6 + 12432.4639892578*cos(theta)**4 - 507.447509765625*cos(theta)**2 + 3.33847045898438)*sin(phi)

@torch.jit.script
def Yl17_m0(theta, phi):
    return 29713.0160510757*cos(theta)**17 - 122453.641907463*cos(theta)**15 + 207381.167746511*cos(theta)**13 - 185927.943496872*cos(theta)**11 + 94685.5267808142*cos(theta)**9 - 27269.4317128745*cos(theta)**7 + 4149.69613022003*cos(theta)**5 - 282.292253756465*cos(theta)**3 + 5.57155763993023*cos(theta)

@torch.jit.script
def Yl17_m1(theta, phi):
    return 0.134922187793101*(1.0 - cos(theta)**2)**0.5*(302668.043060303*cos(theta)**16 - 1100611.06567383*cos(theta)**14 + 1615413.01574707*cos(theta)**12 - 1225485.73608398*cos(theta)**10 + 510619.05670166*cos(theta)**8 - 114378.668701172*cos(theta)**6 + 12432.4639892578*cos(theta)**4 - 507.447509765625*cos(theta)**2 + 3.33847045898438)*cos(phi)

@torch.jit.script
def Yl17_m2(theta, phi):
    return 0.00773831818199403*(1.0 - cos(theta)**2)*(4842688.68896484*cos(theta)**15 - 15408554.9194336*cos(theta)**13 + 19384956.1889648*cos(theta)**11 - 12254857.3608398*cos(theta)**9 + 4084952.45361328*cos(theta)**7 - 686272.012207031*cos(theta)**5 + 49729.8559570313*cos(theta)**3 - 1014.89501953125*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl17_m3(theta, phi):
    return 0.000446772008544923*(1.0 - cos(theta)**2)**1.5*(72640330.3344727*cos(theta)**14 - 200311213.952637*cos(theta)**12 + 213234518.078613*cos(theta)**10 - 110293716.247559*cos(theta)**8 + 28594667.175293*cos(theta)**6 - 3431360.06103516*cos(theta)**4 + 149189.567871094*cos(theta)**2 - 1014.89501953125)*cos(3*phi)

@torch.jit.script
def Yl17_m4(theta, phi):
    return 2.6056272673653e-5*(1.0 - cos(theta)**2)**2*(1016964624.68262*cos(theta)**13 - 2403734567.43164*cos(theta)**11 + 2132345180.78613*cos(theta)**9 - 882349729.980469*cos(theta)**7 + 171568003.051758*cos(theta)**5 - 13725440.2441406*cos(theta)**3 + 298379.135742188*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl17_m5(theta, phi):
    return 1.54073970252026e-6*(1.0 - cos(theta)**2)**2.5*(13220540120.874*cos(theta)**12 - 26441080241.748*cos(theta)**10 + 19191106627.0752*cos(theta)**8 - 6176448109.86328*cos(theta)**6 + 857840015.258789*cos(theta)**4 - 41176320.7324219*cos(theta)**2 + 298379.135742188)*cos(5*phi)

@torch.jit.script
def Yl17_m6(theta, phi):
    return 9.2741631735508e-8*(1.0 - cos(theta)**2)**3*(158646481450.488*cos(theta)**11 - 264410802417.48*cos(theta)**9 + 153528853016.602*cos(theta)**7 - 37058688659.1797*cos(theta)**5 + 3431360061.03516*cos(theta)**3 - 82352641.4648438*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl17_m7(theta, phi):
    return 5.70785286308994e-9*(1.0 - cos(theta)**2)**3.5*(1745111295955.37*cos(theta)**10 - 2379697221757.32*cos(theta)**8 + 1074701971116.21*cos(theta)**6 - 185293443295.898*cos(theta)**4 + 10294080183.1055*cos(theta)**2 - 82352641.4648438)*cos(7*phi)

@torch.jit.script
def Yl17_m8(theta, phi):
    return 3.60996311929549e-10*(1.0 - cos(theta)**2)**4*(17451112959553.7*cos(theta)**9 - 19037577774058.6*cos(theta)**7 + 6448211826697.27*cos(theta)**5 - 741173773183.594*cos(theta)**3 + 20588160366.2109*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl17_m9(theta, phi):
    return 2.35990671649205e-11*(1.0 - cos(theta)**2)**4.5*(157060016635983.0*cos(theta)**8 - 133263044418410.0*cos(theta)**6 + 32241059133486.3*cos(theta)**4 - 2223521319550.78*cos(theta)**2 + 20588160366.2109)*cos(9*phi)

@torch.jit.script
def Yl17_m10(theta, phi):
    return 1.60571313777011e-12*(1.0 - cos(theta)**2)**5*(1.25648013308787e+15*cos(theta)**7 - 799578266510461.0*cos(theta)**5 + 128964236533945.0*cos(theta)**3 - 4447042639101.56*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl17_m11(theta, phi):
    return 1.14693795555008e-13*(1.0 - cos(theta)**2)**5.5*(8.79536093161507e+15*cos(theta)**6 - 3.9978913325523e+15*cos(theta)**4 + 386892709601836.0*cos(theta)**2 - 4447042639101.56)*cos(11*phi)

@torch.jit.script
def Yl17_m12(theta, phi):
    return 8.69491420208903e-15*(1.0 - cos(theta)**2)**6*(5.27721655896904e+16*cos(theta)**5 - 1.59915653302092e+16*cos(theta)**3 + 773785419203672.0*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl17_m13(theta, phi):
    return 7.09936771746562e-16*(1.0 - cos(theta)**2)**6.5*(2.63860827948452e+17*cos(theta)**4 - 4.79746959906277e+16*cos(theta)**2 + 773785419203672.0)*cos(13*phi)

@torch.jit.script
def Yl17_m14(theta, phi):
    return 6.37542041547274e-17*(1.0 - cos(theta)**2)**7*(1.05544331179381e+18*cos(theta)**3 - 9.59493919812553e+16*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl17_m15(theta, phi):
    return 6.50688621401289e-18*(1.0 - cos(theta)**2)**7.5*(3.16632993538143e+18*cos(theta)**2 - 9.59493919812553e+16)*cos(15*phi)

@torch.jit.script
def Yl17_m16(theta, phi):
    return 5.07209532485536*(1.0 - cos(theta)**2)**8*cos(16*phi)*cos(theta)

@torch.jit.script
def Yl17_m17(theta, phi):
    return 0.869857171920628*(1.0 - cos(theta)**2)**8.5*cos(17*phi)

@torch.jit.script
def Yl18_m_minus_18(theta, phi):
    return 0.881855768678329*(1.0 - cos(theta)**2)**9*sin(18*phi)

@torch.jit.script
def Yl18_m_minus_17(theta, phi):
    return 5.29113461206997*(1.0 - cos(theta)**2)**8.5*sin(17*phi)*cos(theta)

@torch.jit.script
def Yl18_m_minus_16(theta, phi):
    return 1.99730147939357e-19*(1.0 - cos(theta)**2)**8*(1.1082154773835e+20*cos(theta)**2 - 3.16632993538143e+18)*sin(16*phi)

@torch.jit.script
def Yl18_m_minus_15(theta, phi):
    return 2.01717561545333e-18*(1.0 - cos(theta)**2)**7.5*(3.69405159127833e+19*cos(theta)**3 - 3.16632993538143e+18*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl18_m_minus_14(theta, phi):
    return 2.31755833840811e-17*(1.0 - cos(theta)**2)**7*(9.23512897819582e+18*cos(theta)**4 - 1.58316496769071e+18*cos(theta)**2 + 2.39873479953138e+16)*sin(14*phi)

@torch.jit.script
def Yl18_m_minus_13(theta, phi):
    return 2.93150518387396e-16*(1.0 - cos(theta)**2)**6.5*(1.84702579563916e+18*cos(theta)**5 - 5.27721655896904e+17*cos(theta)**3 + 2.39873479953138e+16*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl18_m_minus_12(theta, phi):
    return 3.9980400343329e-15*(1.0 - cos(theta)**2)**6*(3.07837632606527e+17*cos(theta)**6 - 1.31930413974226e+17*cos(theta)**4 + 1.19936739976569e+16*cos(theta)**2 - 128964236533945.0)*sin(12*phi)

@torch.jit.script
def Yl18_m_minus_11(theta, phi):
    return 5.79371043838662e-14*(1.0 - cos(theta)**2)**5.5*(4.39768046580754e+16*cos(theta)**7 - 2.63860827948452e+16*cos(theta)**5 + 3.9978913325523e+15*cos(theta)**3 - 128964236533945.0*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl18_m_minus_10(theta, phi):
    return 8.82471682796557e-13*(1.0 - cos(theta)**2)**5*(5.49710058225942e+15*cos(theta)**8 - 4.39768046580754e+15*cos(theta)**6 + 999472833138076.0*cos(theta)**4 - 64482118266972.7*cos(theta)**2 + 555880329887.695)*sin(10*phi)

@torch.jit.script
def Yl18_m_minus_9(theta, phi):
    return 1.40088036704182e-11*(1.0 - cos(theta)**2)**4.5*(610788953584380.0*cos(theta)**9 - 628240066543934.0*cos(theta)**7 + 199894566627615.0*cos(theta)**5 - 21494039422324.2*cos(theta)**3 + 555880329887.695*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl18_m_minus_8(theta, phi):
    return 2.30188133218476e-10*(1.0 - cos(theta)**2)**4*(61078895358438.0*cos(theta)**10 - 78530008317991.7*cos(theta)**8 + 33315761104602.5*cos(theta)**6 - 5373509855581.05*cos(theta)**4 + 277940164943.848*cos(theta)**2 - 2058816036.62109)*sin(8*phi)

@torch.jit.script
def Yl18_m_minus_7(theta, phi):
    return 3.8928345622358e-9*(1.0 - cos(theta)**2)**3.5*(5552626850767.09*cos(theta)**11 - 8725556479776.86*cos(theta)**9 + 4759394443514.65*cos(theta)**7 - 1074701971116.21*cos(theta)**5 + 92646721647.9492*cos(theta)**3 - 2058816036.62109*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl18_m_minus_6(theta, phi):
    return 6.74258724725256e-8*(1.0 - cos(theta)**2)**3*(462718904230.591*cos(theta)**12 - 872555647977.686*cos(theta)**10 + 594924305439.331*cos(theta)**8 - 179116995186.035*cos(theta)**6 + 23161680411.9873*cos(theta)**4 - 1029408018.31055*cos(theta)**2 + 6862720.12207031)*sin(6*phi)

@torch.jit.script
def Yl18_m_minus_5(theta, phi):
    return 1.19097836376173e-6*(1.0 - cos(theta)**2)**2.5*(35593761863.8916*cos(theta)**13 - 79323240725.2441*cos(theta)**11 + 66102700604.3701*cos(theta)**9 - 25588142169.4336*cos(theta)**7 + 4632336082.39746*cos(theta)**5 - 343136006.103516*cos(theta)**3 + 6862720.12207031*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl18_m_minus_4(theta, phi):
    return 2.13713426594923e-5*(1.0 - cos(theta)**2)**2*(2542411561.70654*cos(theta)**14 - 6610270060.43701*cos(theta)**12 + 6610270060.43701*cos(theta)**10 - 3198517771.1792*cos(theta)**8 + 772056013.73291*cos(theta)**6 - 85784001.5258789*cos(theta)**4 + 3431360.06103516*cos(theta)**2 - 21312.7954101563)*sin(4*phi)

@torch.jit.script
def Yl18_m_minus_3(theta, phi):
    return 0.000388229719023305*(1.0 - cos(theta)**2)**1.5*(169494104.11377*cos(theta)**15 - 508482312.341309*cos(theta)**13 + 600933641.85791*cos(theta)**11 - 355390863.464355*cos(theta)**9 + 110293716.247559*cos(theta)**7 - 17156800.3051758*cos(theta)**5 + 1143786.68701172*cos(theta)**3 - 21312.7954101563*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl18_m_minus_2(theta, phi):
    return 0.00711636829782292*(1.0 - cos(theta)**2)*(10593381.5071106*cos(theta)**16 - 36320165.1672363*cos(theta)**14 + 50077803.4881592*cos(theta)**12 - 35539086.3464355*cos(theta)**10 + 13786714.5309448*cos(theta)**8 - 2859466.7175293*cos(theta)**6 + 285946.67175293*cos(theta)**4 - 10656.3977050781*cos(theta)**2 + 63.4309387207031)*sin(2*phi)

@torch.jit.script
def Yl18_m_minus_1(theta, phi):
    return 0.131219347792496*(1.0 - cos(theta)**2)**0.5*(623140.088653564*cos(theta)**17 - 2421344.34448242*cos(theta)**15 + 3852138.7298584*cos(theta)**13 - 3230826.03149414*cos(theta)**11 + 1531857.17010498*cos(theta)**9 - 408495.245361328*cos(theta)**7 + 57189.3343505859*cos(theta)**5 - 3552.13256835938*cos(theta)**3 + 63.4309387207031*cos(theta))*sin(phi)

@torch.jit.script
def Yl18_m0(theta, phi):
    return 59403.1009679377*cos(theta)**18 - 259676.412802699*cos(theta)**16 + 472138.932368544*cos(theta)**14 - 461985.406941263*cos(theta)**12 + 262853.766018305*cos(theta)**10 - 87617.9220061016*cos(theta)**8 + 16355.345441139*cos(theta)**6 - 1523.7899479322*cos(theta)**4 + 54.4210695690072*cos(theta)**2 - 0.318251868824604

@torch.jit.script
def Yl18_m1(theta, phi):
    return 0.131219347792496*(1.0 - cos(theta)**2)**0.5*(623140.088653564*cos(theta)**17 - 2421344.34448242*cos(theta)**15 + 3852138.7298584*cos(theta)**13 - 3230826.03149414*cos(theta)**11 + 1531857.17010498*cos(theta)**9 - 408495.245361328*cos(theta)**7 + 57189.3343505859*cos(theta)**5 - 3552.13256835938*cos(theta)**3 + 63.4309387207031*cos(theta))*cos(phi)

@torch.jit.script
def Yl18_m2(theta, phi):
    return 0.00711636829782292*(1.0 - cos(theta)**2)*(10593381.5071106*cos(theta)**16 - 36320165.1672363*cos(theta)**14 + 50077803.4881592*cos(theta)**12 - 35539086.3464355*cos(theta)**10 + 13786714.5309448*cos(theta)**8 - 2859466.7175293*cos(theta)**6 + 285946.67175293*cos(theta)**4 - 10656.3977050781*cos(theta)**2 + 63.4309387207031)*cos(2*phi)

@torch.jit.script
def Yl18_m3(theta, phi):
    return 0.000388229719023305*(1.0 - cos(theta)**2)**1.5*(169494104.11377*cos(theta)**15 - 508482312.341309*cos(theta)**13 + 600933641.85791*cos(theta)**11 - 355390863.464355*cos(theta)**9 + 110293716.247559*cos(theta)**7 - 17156800.3051758*cos(theta)**5 + 1143786.68701172*cos(theta)**3 - 21312.7954101563*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl18_m4(theta, phi):
    return 2.13713426594923e-5*(1.0 - cos(theta)**2)**2*(2542411561.70654*cos(theta)**14 - 6610270060.43701*cos(theta)**12 + 6610270060.43701*cos(theta)**10 - 3198517771.1792*cos(theta)**8 + 772056013.73291*cos(theta)**6 - 85784001.5258789*cos(theta)**4 + 3431360.06103516*cos(theta)**2 - 21312.7954101563)*cos(4*phi)

@torch.jit.script
def Yl18_m5(theta, phi):
    return 1.19097836376173e-6*(1.0 - cos(theta)**2)**2.5*(35593761863.8916*cos(theta)**13 - 79323240725.2441*cos(theta)**11 + 66102700604.3701*cos(theta)**9 - 25588142169.4336*cos(theta)**7 + 4632336082.39746*cos(theta)**5 - 343136006.103516*cos(theta)**3 + 6862720.12207031*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl18_m6(theta, phi):
    return 6.74258724725256e-8*(1.0 - cos(theta)**2)**3*(462718904230.591*cos(theta)**12 - 872555647977.686*cos(theta)**10 + 594924305439.331*cos(theta)**8 - 179116995186.035*cos(theta)**6 + 23161680411.9873*cos(theta)**4 - 1029408018.31055*cos(theta)**2 + 6862720.12207031)*cos(6*phi)

@torch.jit.script
def Yl18_m7(theta, phi):
    return 3.8928345622358e-9*(1.0 - cos(theta)**2)**3.5*(5552626850767.09*cos(theta)**11 - 8725556479776.86*cos(theta)**9 + 4759394443514.65*cos(theta)**7 - 1074701971116.21*cos(theta)**5 + 92646721647.9492*cos(theta)**3 - 2058816036.62109*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl18_m8(theta, phi):
    return 2.30188133218476e-10*(1.0 - cos(theta)**2)**4*(61078895358438.0*cos(theta)**10 - 78530008317991.7*cos(theta)**8 + 33315761104602.5*cos(theta)**6 - 5373509855581.05*cos(theta)**4 + 277940164943.848*cos(theta)**2 - 2058816036.62109)*cos(8*phi)

@torch.jit.script
def Yl18_m9(theta, phi):
    return 1.40088036704182e-11*(1.0 - cos(theta)**2)**4.5*(610788953584380.0*cos(theta)**9 - 628240066543934.0*cos(theta)**7 + 199894566627615.0*cos(theta)**5 - 21494039422324.2*cos(theta)**3 + 555880329887.695*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl18_m10(theta, phi):
    return 8.82471682796557e-13*(1.0 - cos(theta)**2)**5*(5.49710058225942e+15*cos(theta)**8 - 4.39768046580754e+15*cos(theta)**6 + 999472833138076.0*cos(theta)**4 - 64482118266972.7*cos(theta)**2 + 555880329887.695)*cos(10*phi)

@torch.jit.script
def Yl18_m11(theta, phi):
    return 5.79371043838662e-14*(1.0 - cos(theta)**2)**5.5*(4.39768046580754e+16*cos(theta)**7 - 2.63860827948452e+16*cos(theta)**5 + 3.9978913325523e+15*cos(theta)**3 - 128964236533945.0*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl18_m12(theta, phi):
    return 3.9980400343329e-15*(1.0 - cos(theta)**2)**6*(3.07837632606527e+17*cos(theta)**6 - 1.31930413974226e+17*cos(theta)**4 + 1.19936739976569e+16*cos(theta)**2 - 128964236533945.0)*cos(12*phi)

@torch.jit.script
def Yl18_m13(theta, phi):
    return 2.93150518387396e-16*(1.0 - cos(theta)**2)**6.5*(1.84702579563916e+18*cos(theta)**5 - 5.27721655896904e+17*cos(theta)**3 + 2.39873479953138e+16*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl18_m14(theta, phi):
    return 2.31755833840811e-17*(1.0 - cos(theta)**2)**7*(9.23512897819582e+18*cos(theta)**4 - 1.58316496769071e+18*cos(theta)**2 + 2.39873479953138e+16)*cos(14*phi)

@torch.jit.script
def Yl18_m15(theta, phi):
    return 2.01717561545333e-18*(1.0 - cos(theta)**2)**7.5*(3.69405159127833e+19*cos(theta)**3 - 3.16632993538143e+18*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl18_m16(theta, phi):
    return 1.99730147939357e-19*(1.0 - cos(theta)**2)**8*(1.1082154773835e+20*cos(theta)**2 - 3.16632993538143e+18)*cos(16*phi)

@torch.jit.script
def Yl18_m17(theta, phi):
    return 5.29113461206997*(1.0 - cos(theta)**2)**8.5*cos(17*phi)*cos(theta)

@torch.jit.script
def Yl18_m18(theta, phi):
    return 0.881855768678329*(1.0 - cos(theta)**2)**9*cos(18*phi)

@torch.jit.script
def Yl19_m_minus_19(theta, phi):
    return 0.893383784349949*(1.0 - cos(theta)**2)**9.5*sin(19*phi)

@torch.jit.script
def Yl19_m_minus_18(theta, phi):
    return 5.50718751027224*(1.0 - cos(theta)**2)**9*sin(18*phi)*cos(theta)

@torch.jit.script
def Yl19_m_minus_17(theta, phi):
    return 5.77683273022057e-21*(1.0 - cos(theta)**2)**8.5*(4.10039726631895e+21*cos(theta)**2 - 1.1082154773835e+20)*sin(17*phi)

@torch.jit.script
def Yl19_m_minus_16(theta, phi):
    return 6.00346067734132e-20*(1.0 - cos(theta)**2)**8*(1.36679908877298e+21*cos(theta)**3 - 1.1082154773835e+20*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl19_m_minus_15(theta, phi):
    return 7.1033904683705e-19*(1.0 - cos(theta)**2)**7.5*(3.41699772193245e+20*cos(theta)**4 - 5.54107738691749e+19*cos(theta)**2 + 7.91582483845356e+17)*sin(15*phi)

@torch.jit.script
def Yl19_m_minus_14(theta, phi):
    return 9.26168804529891e-18*(1.0 - cos(theta)**2)**7*(6.83399544386491e+19*cos(theta)**5 - 1.84702579563916e+19*cos(theta)**3 + 7.91582483845356e+17*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl19_m_minus_13(theta, phi):
    return 1.30323502710715e-16*(1.0 - cos(theta)**2)**6.5*(1.13899924064415e+19*cos(theta)**6 - 4.61756448909791e+18*cos(theta)**4 + 3.95791241922678e+17*cos(theta)**2 - 3.9978913325523e+15)*sin(13*phi)

@torch.jit.script
def Yl19_m_minus_12(theta, phi):
    return 1.9505035863512e-15*(1.0 - cos(theta)**2)**6*(1.62714177234879e+18*cos(theta)**7 - 9.23512897819582e+17*cos(theta)**5 + 1.31930413974226e+17*cos(theta)**3 - 3.9978913325523e+15*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl19_m_minus_11(theta, phi):
    return 3.07165611944352e-14*(1.0 - cos(theta)**2)**5.5*(2.03392721543598e+17*cos(theta)**8 - 1.53918816303264e+17*cos(theta)**6 + 3.29826034935565e+16*cos(theta)**4 - 1.99894566627615e+15*cos(theta)**2 + 16120529566743.2)*sin(11*phi)

@torch.jit.script
def Yl19_m_minus_10(theta, phi):
    return 5.047246036554e-13*(1.0 - cos(theta)**2)**5*(2.25991912826221e+16*cos(theta)**9 - 2.19884023290377e+16*cos(theta)**7 + 6.5965206987113e+15*cos(theta)**5 - 666315222092051.0*cos(theta)**3 + 16120529566743.2*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl19_m_minus_9(theta, phi):
    return 8.59515028403688e-12*(1.0 - cos(theta)**2)**4.5*(2.25991912826221e+15*cos(theta)**10 - 2.74855029112971e+15*cos(theta)**8 + 1.09942011645188e+15*cos(theta)**6 - 166578805523013.0*cos(theta)**4 + 8060264783371.58*cos(theta)**2 - 55588032988.7695)*sin(9*phi)

@torch.jit.script
def Yl19_m_minus_8(theta, phi):
    return 1.50844275293414e-10*(1.0 - cos(theta)**2)**4*(205447193478382.0*cos(theta)**11 - 305394476792190.0*cos(theta)**9 + 157060016635983.0*cos(theta)**7 - 33315761104602.5*cos(theta)**5 + 2686754927790.53*cos(theta)**3 - 55588032988.7695*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl19_m_minus_7(theta, phi):
    return 2.71519695528145e-9*(1.0 - cos(theta)**2)**3.5*(17120599456531.9*cos(theta)**12 - 30539447679219.0*cos(theta)**10 + 19632502079497.9*cos(theta)**8 - 5552626850767.09*cos(theta)**6 + 671688731947.632*cos(theta)**4 - 27794016494.3848*cos(theta)**2 + 171568003.051758)*sin(7*phi)

@torch.jit.script
def Yl19_m_minus_6(theta, phi):
    return 4.99182886627511e-8*(1.0 - cos(theta)**2)**3*(1316969188963.99*cos(theta)**13 - 2776313425383.54*cos(theta)**11 + 2181389119944.21*cos(theta)**9 - 793232407252.441*cos(theta)**7 + 134337746389.526*cos(theta)**5 - 9264672164.79492*cos(theta)**3 + 171568003.051758*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl19_m_minus_5(theta, phi):
    return 9.33885667550482e-7*(1.0 - cos(theta)**2)**2.5*(94069227783.1421*cos(theta)**14 - 231359452115.295*cos(theta)**12 + 218138911994.421*cos(theta)**10 - 99154050906.5552*cos(theta)**8 + 22389624398.2544*cos(theta)**6 - 2316168041.19873*cos(theta)**4 + 85784001.5258789*cos(theta)**2 - 490194.294433594)*sin(5*phi)

@torch.jit.script
def Yl19_m_minus_4(theta, phi):
    return 1.77192347018779e-5*(1.0 - cos(theta)**2)**2*(6271281852.20947*cos(theta)**15 - 17796880931.9458*cos(theta)**13 + 19830810181.311*cos(theta)**11 - 11017116767.395*cos(theta)**9 + 3198517771.1792*cos(theta)**7 - 463233608.239746*cos(theta)**5 + 28594667.175293*cos(theta)**3 - 490194.294433594*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl19_m_minus_3(theta, phi):
    return 0.000339913857408971*(1.0 - cos(theta)**2)**1.5*(391955115.763092*cos(theta)**16 - 1271205780.85327*cos(theta)**14 + 1652567515.10925*cos(theta)**12 - 1101711676.7395*cos(theta)**10 + 399814721.3974*cos(theta)**8 - 77205601.373291*cos(theta)**6 + 7148666.79382324*cos(theta)**4 - 245097.147216797*cos(theta)**2 + 1332.04971313477)*sin(3*phi)

@torch.jit.script
def Yl19_m_minus_2(theta, phi):
    return 0.00657362114755131*(1.0 - cos(theta)**2)*(23056183.2801819*cos(theta)**17 - 84747052.0568848*cos(theta)**15 + 127120578.085327*cos(theta)**13 - 100155606.976318*cos(theta)**11 + 44423857.9330444*cos(theta)**9 - 11029371.6247559*cos(theta)**7 + 1429733.35876465*cos(theta)**5 - 81699.0490722656*cos(theta)**3 + 1332.04971313477*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl19_m_minus_1(theta, phi):
    return 0.127805802320551*(1.0 - cos(theta)**2)**0.5*(1280899.07112122*cos(theta)**18 - 5296690.7535553*cos(theta)**16 + 9080041.29180908*cos(theta)**14 - 8346300.58135986*cos(theta)**12 + 4442385.79330444*cos(theta)**10 - 1378671.45309448*cos(theta)**8 + 238288.893127441*cos(theta)**6 - 20424.7622680664*cos(theta)**4 + 666.024856567383*cos(theta)**2 - 3.52394104003906)*sin(phi)

@torch.jit.script
def Yl19_m0(theta, phi):
    return 118765.056929642*cos(theta)**19 - 548887.154999156*cos(theta)**17 + 1066409.32971265*cos(theta)**15 - 1131040.19818008*cos(theta)**13 + 711460.769822953*cos(theta)**11 - 269864.429932844*cos(theta)**9 + 59969.8733184099*cos(theta)**7 - 7196.38479820918*cos(theta)**5 + 391.10786946789*cos(theta)**3 - 6.20806142012525*cos(theta)

@torch.jit.script
def Yl19_m1(theta, phi):
    return 0.127805802320551*(1.0 - cos(theta)**2)**0.5*(1280899.07112122*cos(theta)**18 - 5296690.7535553*cos(theta)**16 + 9080041.29180908*cos(theta)**14 - 8346300.58135986*cos(theta)**12 + 4442385.79330444*cos(theta)**10 - 1378671.45309448*cos(theta)**8 + 238288.893127441*cos(theta)**6 - 20424.7622680664*cos(theta)**4 + 666.024856567383*cos(theta)**2 - 3.52394104003906)*cos(phi)

@torch.jit.script
def Yl19_m2(theta, phi):
    return 0.00657362114755131*(1.0 - cos(theta)**2)*(23056183.2801819*cos(theta)**17 - 84747052.0568848*cos(theta)**15 + 127120578.085327*cos(theta)**13 - 100155606.976318*cos(theta)**11 + 44423857.9330444*cos(theta)**9 - 11029371.6247559*cos(theta)**7 + 1429733.35876465*cos(theta)**5 - 81699.0490722656*cos(theta)**3 + 1332.04971313477*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl19_m3(theta, phi):
    return 0.000339913857408971*(1.0 - cos(theta)**2)**1.5*(391955115.763092*cos(theta)**16 - 1271205780.85327*cos(theta)**14 + 1652567515.10925*cos(theta)**12 - 1101711676.7395*cos(theta)**10 + 399814721.3974*cos(theta)**8 - 77205601.373291*cos(theta)**6 + 7148666.79382324*cos(theta)**4 - 245097.147216797*cos(theta)**2 + 1332.04971313477)*cos(3*phi)

@torch.jit.script
def Yl19_m4(theta, phi):
    return 1.77192347018779e-5*(1.0 - cos(theta)**2)**2*(6271281852.20947*cos(theta)**15 - 17796880931.9458*cos(theta)**13 + 19830810181.311*cos(theta)**11 - 11017116767.395*cos(theta)**9 + 3198517771.1792*cos(theta)**7 - 463233608.239746*cos(theta)**5 + 28594667.175293*cos(theta)**3 - 490194.294433594*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl19_m5(theta, phi):
    return 9.33885667550482e-7*(1.0 - cos(theta)**2)**2.5*(94069227783.1421*cos(theta)**14 - 231359452115.295*cos(theta)**12 + 218138911994.421*cos(theta)**10 - 99154050906.5552*cos(theta)**8 + 22389624398.2544*cos(theta)**6 - 2316168041.19873*cos(theta)**4 + 85784001.5258789*cos(theta)**2 - 490194.294433594)*cos(5*phi)

@torch.jit.script
def Yl19_m6(theta, phi):
    return 4.99182886627511e-8*(1.0 - cos(theta)**2)**3*(1316969188963.99*cos(theta)**13 - 2776313425383.54*cos(theta)**11 + 2181389119944.21*cos(theta)**9 - 793232407252.441*cos(theta)**7 + 134337746389.526*cos(theta)**5 - 9264672164.79492*cos(theta)**3 + 171568003.051758*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl19_m7(theta, phi):
    return 2.71519695528145e-9*(1.0 - cos(theta)**2)**3.5*(17120599456531.9*cos(theta)**12 - 30539447679219.0*cos(theta)**10 + 19632502079497.9*cos(theta)**8 - 5552626850767.09*cos(theta)**6 + 671688731947.632*cos(theta)**4 - 27794016494.3848*cos(theta)**2 + 171568003.051758)*cos(7*phi)

@torch.jit.script
def Yl19_m8(theta, phi):
    return 1.50844275293414e-10*(1.0 - cos(theta)**2)**4*(205447193478382.0*cos(theta)**11 - 305394476792190.0*cos(theta)**9 + 157060016635983.0*cos(theta)**7 - 33315761104602.5*cos(theta)**5 + 2686754927790.53*cos(theta)**3 - 55588032988.7695*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl19_m9(theta, phi):
    return 8.59515028403688e-12*(1.0 - cos(theta)**2)**4.5*(2.25991912826221e+15*cos(theta)**10 - 2.74855029112971e+15*cos(theta)**8 + 1.09942011645188e+15*cos(theta)**6 - 166578805523013.0*cos(theta)**4 + 8060264783371.58*cos(theta)**2 - 55588032988.7695)*cos(9*phi)

@torch.jit.script
def Yl19_m10(theta, phi):
    return 5.047246036554e-13*(1.0 - cos(theta)**2)**5*(2.25991912826221e+16*cos(theta)**9 - 2.19884023290377e+16*cos(theta)**7 + 6.5965206987113e+15*cos(theta)**5 - 666315222092051.0*cos(theta)**3 + 16120529566743.2*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl19_m11(theta, phi):
    return 3.07165611944352e-14*(1.0 - cos(theta)**2)**5.5*(2.03392721543598e+17*cos(theta)**8 - 1.53918816303264e+17*cos(theta)**6 + 3.29826034935565e+16*cos(theta)**4 - 1.99894566627615e+15*cos(theta)**2 + 16120529566743.2)*cos(11*phi)

@torch.jit.script
def Yl19_m12(theta, phi):
    return 1.9505035863512e-15*(1.0 - cos(theta)**2)**6*(1.62714177234879e+18*cos(theta)**7 - 9.23512897819582e+17*cos(theta)**5 + 1.31930413974226e+17*cos(theta)**3 - 3.9978913325523e+15*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl19_m13(theta, phi):
    return 1.30323502710715e-16*(1.0 - cos(theta)**2)**6.5*(1.13899924064415e+19*cos(theta)**6 - 4.61756448909791e+18*cos(theta)**4 + 3.95791241922678e+17*cos(theta)**2 - 3.9978913325523e+15)*cos(13*phi)

@torch.jit.script
def Yl19_m14(theta, phi):
    return 9.26168804529891e-18*(1.0 - cos(theta)**2)**7*(6.83399544386491e+19*cos(theta)**5 - 1.84702579563916e+19*cos(theta)**3 + 7.91582483845356e+17*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl19_m15(theta, phi):
    return 7.1033904683705e-19*(1.0 - cos(theta)**2)**7.5*(3.41699772193245e+20*cos(theta)**4 - 5.54107738691749e+19*cos(theta)**2 + 7.91582483845356e+17)*cos(15*phi)

@torch.jit.script
def Yl19_m16(theta, phi):
    return 6.00346067734132e-20*(1.0 - cos(theta)**2)**8*(1.36679908877298e+21*cos(theta)**3 - 1.1082154773835e+20*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl19_m17(theta, phi):
    return 5.77683273022057e-21*(1.0 - cos(theta)**2)**8.5*(4.10039726631895e+21*cos(theta)**2 - 1.1082154773835e+20)*cos(17*phi)

@torch.jit.script
def Yl19_m18(theta, phi):
    return 5.50718751027224*(1.0 - cos(theta)**2)**9*cos(18*phi)*cos(theta)

@torch.jit.script
def Yl19_m19(theta, phi):
    return 0.893383784349949*(1.0 - cos(theta)**2)**9.5*cos(19*phi)

@torch.jit.script
def Yl20_m_minus_20(theta, phi):
    return 0.904482145093491*(1.0 - cos(theta)**2)**10*sin(20*phi)

@torch.jit.script
def Yl20_m_minus_19(theta, phi):
    return 5.72044736290064*(1.0 - cos(theta)**2)**9.5*sin(19*phi)*cos(theta)

@torch.jit.script
def Yl20_m_minus_18(theta, phi):
    return 1.57963503371958e-22*(1.0 - cos(theta)**2)**9*(1.59915493386439e+23*cos(theta)**2 - 4.10039726631895e+21)*sin(18*phi)

@torch.jit.script
def Yl20_m_minus_17(theta, phi):
    return 1.68658868646741e-21*(1.0 - cos(theta)**2)**8.5*(5.33051644621463e+22*cos(theta)**3 - 4.10039726631895e+21*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl20_m_minus_16(theta, phi):
    return 2.05182369321377e-20*(1.0 - cos(theta)**2)**8*(1.33262911155366e+22*cos(theta)**4 - 2.05019863315947e+21*cos(theta)**2 + 2.77053869345875e+19)*sin(16*phi)

@torch.jit.script
def Yl20_m_minus_15(theta, phi):
    return 2.7528103535224e-19*(1.0 - cos(theta)**2)**7.5*(2.66525822310731e+21*cos(theta)**5 - 6.83399544386491e+20*cos(theta)**3 + 2.77053869345875e+19*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl20_m_minus_14(theta, phi):
    return 3.9892011943704e-18*(1.0 - cos(theta)**2)**7*(4.44209703851219e+20*cos(theta)**6 - 1.70849886096623e+20*cos(theta)**4 + 1.38526934672937e+19*cos(theta)**2 - 1.31930413974226e+17)*sin(14*phi)

@torch.jit.script
def Yl20_m_minus_13(theta, phi):
    return 6.15423986229134e-17*(1.0 - cos(theta)**2)**6.5*(6.34585291216027e+19*cos(theta)**7 - 3.41699772193245e+19*cos(theta)**5 + 4.61756448909791e+18*cos(theta)**3 - 1.31930413974226e+17*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl20_m_minus_12(theta, phi):
    return 9.99945619851927e-16*(1.0 - cos(theta)**2)**6*(7.93231614020034e+18*cos(theta)**8 - 5.69499620322076e+18*cos(theta)**6 + 1.15439112227448e+18*cos(theta)**4 - 6.5965206987113e+16*cos(theta)**2 + 499736416569038.0)*sin(12*phi)

@torch.jit.script
def Yl20_m_minus_11(theta, phi):
    return 1.6969639886762e-14*(1.0 - cos(theta)**2)**5.5*(8.8136846002226e+17*cos(theta)**9 - 8.13570886174394e+17*cos(theta)**7 + 2.30878224454896e+17*cos(theta)**5 - 2.19884023290377e+16*cos(theta)**3 + 499736416569038.0*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl20_m_minus_10(theta, phi):
    return 2.98781341694522e-13*(1.0 - cos(theta)**2)**5*(8.8136846002226e+16*cos(theta)**10 - 1.01696360771799e+17*cos(theta)**8 + 3.84797040758159e+16*cos(theta)**6 - 5.49710058225942e+15*cos(theta)**4 + 249868208284519.0*cos(theta)**2 - 1612052956674.32)*sin(10*phi)

@torch.jit.script
def Yl20_m_minus_9(theta, phi):
    return 5.42763260987486e-12*(1.0 - cos(theta)**2)**4.5*(8.01244054565691e+15*cos(theta)**11 - 1.1299595641311e+16*cos(theta)**9 + 5.49710058225942e+15*cos(theta)**7 - 1.09942011645188e+15*cos(theta)**5 + 83289402761506.3*cos(theta)**3 - 1612052956674.32*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl20_m_minus_8(theta, phi):
    return 1.01251173426417e-10*(1.0 - cos(theta)**2)**4*(667703378804743.0*cos(theta)**12 - 1.1299595641311e+15*cos(theta)**10 + 687137572782427.0*cos(theta)**8 - 183236686075314.0*cos(theta)**6 + 20822350690376.6*cos(theta)**4 - 806026478337.158*cos(theta)**2 + 4632336082.39746)*sin(8*phi)

@torch.jit.script
def Yl20_m_minus_7(theta, phi):
    return 1.9317492704185e-9*(1.0 - cos(theta)**2)**3.5*(51361798369595.6*cos(theta)**13 - 102723596739191.0*cos(theta)**11 + 76348619198047.5*cos(theta)**9 - 26176669439330.6*cos(theta)**7 + 4164470138075.32*cos(theta)**5 - 268675492779.053*cos(theta)**3 + 4632336082.39746*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl20_m_minus_6(theta, phi):
    return 3.75574983477626e-8*(1.0 - cos(theta)**2)**3*(3668699883542.54*cos(theta)**14 - 8560299728265.93*cos(theta)**12 + 7634861919804.75*cos(theta)**10 - 3272083679916.32*cos(theta)**8 + 694078356345.886*cos(theta)**6 - 67168873194.7632*cos(theta)**4 + 2316168041.19873*cos(theta)**2 - 12254857.3608398)*sin(6*phi)

@torch.jit.script
def Yl20_m_minus_5(theta, phi):
    return 7.417011635662e-7*(1.0 - cos(theta)**2)**2.5*(244579992236.169*cos(theta)**15 - 658484594481.995*cos(theta)**13 + 694078356345.886*cos(theta)**11 - 363564853324.036*cos(theta)**9 + 99154050906.5552*cos(theta)**7 - 13433774638.9526*cos(theta)**5 + 772056013.73291*cos(theta)**3 - 12254857.3608398*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl20_m_minus_4(theta, phi):
    return 1.4834023271324e-5*(1.0 - cos(theta)**2)**2*(15286249514.7606*cos(theta)**16 - 47034613891.571*cos(theta)**14 + 57839863028.8239*cos(theta)**12 - 36356485332.4036*cos(theta)**10 + 12394256363.3194*cos(theta)**8 - 2238962439.82544*cos(theta)**6 + 193014003.433228*cos(theta)**4 - 6127428.68041992*cos(theta)**2 + 30637.1434020996)*sin(4*phi)

@torch.jit.script
def Yl20_m_minus_3(theta, phi):
    return 0.000299632582569029*(1.0 - cos(theta)**2)**1.5*(899191147.927094*cos(theta)**17 - 3135640926.10474*cos(theta)**15 + 4449220232.98645*cos(theta)**13 - 3305135030.21851*cos(theta)**11 + 1377139595.92438*cos(theta)**9 - 319851777.11792*cos(theta)**7 + 38602800.6866455*cos(theta)**5 - 2042476.22680664*cos(theta)**3 + 30637.1434020996*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl20_m_minus_2(theta, phi):
    return 0.00609662114603756*(1.0 - cos(theta)**2)*(49955063.7737274*cos(theta)**18 - 195977557.881546*cos(theta)**16 + 317801445.213318*cos(theta)**14 - 275427919.184875*cos(theta)**12 + 137713959.592438*cos(theta)**10 - 39981472.13974*cos(theta)**8 + 6433800.11444092*cos(theta)**6 - 510619.05670166*cos(theta)**4 + 15318.5717010498*cos(theta)**2 - 74.0027618408203)*sin(2*phi)

@torch.jit.script
def Yl20_m_minus_1(theta, phi):
    return 0.12464571379913*(1.0 - cos(theta)**2)**0.5*(2629213.88282776*cos(theta)**19 - 11528091.6400909*cos(theta)**17 + 21186763.0142212*cos(theta)**15 - 21186763.0142212*cos(theta)**13 + 12519450.8720398*cos(theta)**11 - 4442385.79330444*cos(theta)**9 + 919114.302062988*cos(theta)**7 - 102123.811340332*cos(theta)**5 + 5106.1905670166*cos(theta)**3 - 74.0027618408203*cos(theta))*sin(phi)

@torch.jit.script
def Yl20_m0(theta, phi):
    return 237455.874096927*cos(theta)**20 - 1156836.30970298*cos(theta)**18 + 2391837.23492643*cos(theta)**16 - 2733528.26848735*cos(theta)**14 + 1884477.82145719*cos(theta)**12 - 802422.814297898*cos(theta)**10 + 207523.141628767*cos(theta)**8 - 30744.1691301877*cos(theta)**6 + 2305.81268476408*cos(theta)**4 - 66.8351502830167*cos(theta)**2 + 0.318262620395318

@torch.jit.script
def Yl20_m1(theta, phi):
    return 0.12464571379913*(1.0 - cos(theta)**2)**0.5*(2629213.88282776*cos(theta)**19 - 11528091.6400909*cos(theta)**17 + 21186763.0142212*cos(theta)**15 - 21186763.0142212*cos(theta)**13 + 12519450.8720398*cos(theta)**11 - 4442385.79330444*cos(theta)**9 + 919114.302062988*cos(theta)**7 - 102123.811340332*cos(theta)**5 + 5106.1905670166*cos(theta)**3 - 74.0027618408203*cos(theta))*cos(phi)

@torch.jit.script
def Yl20_m2(theta, phi):
    return 0.00609662114603756*(1.0 - cos(theta)**2)*(49955063.7737274*cos(theta)**18 - 195977557.881546*cos(theta)**16 + 317801445.213318*cos(theta)**14 - 275427919.184875*cos(theta)**12 + 137713959.592438*cos(theta)**10 - 39981472.13974*cos(theta)**8 + 6433800.11444092*cos(theta)**6 - 510619.05670166*cos(theta)**4 + 15318.5717010498*cos(theta)**2 - 74.0027618408203)*cos(2*phi)

@torch.jit.script
def Yl20_m3(theta, phi):
    return 0.000299632582569029*(1.0 - cos(theta)**2)**1.5*(899191147.927094*cos(theta)**17 - 3135640926.10474*cos(theta)**15 + 4449220232.98645*cos(theta)**13 - 3305135030.21851*cos(theta)**11 + 1377139595.92438*cos(theta)**9 - 319851777.11792*cos(theta)**7 + 38602800.6866455*cos(theta)**5 - 2042476.22680664*cos(theta)**3 + 30637.1434020996*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl20_m4(theta, phi):
    return 1.4834023271324e-5*(1.0 - cos(theta)**2)**2*(15286249514.7606*cos(theta)**16 - 47034613891.571*cos(theta)**14 + 57839863028.8239*cos(theta)**12 - 36356485332.4036*cos(theta)**10 + 12394256363.3194*cos(theta)**8 - 2238962439.82544*cos(theta)**6 + 193014003.433228*cos(theta)**4 - 6127428.68041992*cos(theta)**2 + 30637.1434020996)*cos(4*phi)

@torch.jit.script
def Yl20_m5(theta, phi):
    return 7.417011635662e-7*(1.0 - cos(theta)**2)**2.5*(244579992236.169*cos(theta)**15 - 658484594481.995*cos(theta)**13 + 694078356345.886*cos(theta)**11 - 363564853324.036*cos(theta)**9 + 99154050906.5552*cos(theta)**7 - 13433774638.9526*cos(theta)**5 + 772056013.73291*cos(theta)**3 - 12254857.3608398*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl20_m6(theta, phi):
    return 3.75574983477626e-8*(1.0 - cos(theta)**2)**3*(3668699883542.54*cos(theta)**14 - 8560299728265.93*cos(theta)**12 + 7634861919804.75*cos(theta)**10 - 3272083679916.32*cos(theta)**8 + 694078356345.886*cos(theta)**6 - 67168873194.7632*cos(theta)**4 + 2316168041.19873*cos(theta)**2 - 12254857.3608398)*cos(6*phi)

@torch.jit.script
def Yl20_m7(theta, phi):
    return 1.9317492704185e-9*(1.0 - cos(theta)**2)**3.5*(51361798369595.6*cos(theta)**13 - 102723596739191.0*cos(theta)**11 + 76348619198047.5*cos(theta)**9 - 26176669439330.6*cos(theta)**7 + 4164470138075.32*cos(theta)**5 - 268675492779.053*cos(theta)**3 + 4632336082.39746*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl20_m8(theta, phi):
    return 1.01251173426417e-10*(1.0 - cos(theta)**2)**4*(667703378804743.0*cos(theta)**12 - 1.1299595641311e+15*cos(theta)**10 + 687137572782427.0*cos(theta)**8 - 183236686075314.0*cos(theta)**6 + 20822350690376.6*cos(theta)**4 - 806026478337.158*cos(theta)**2 + 4632336082.39746)*cos(8*phi)

@torch.jit.script
def Yl20_m9(theta, phi):
    return 5.42763260987486e-12*(1.0 - cos(theta)**2)**4.5*(8.01244054565691e+15*cos(theta)**11 - 1.1299595641311e+16*cos(theta)**9 + 5.49710058225942e+15*cos(theta)**7 - 1.09942011645188e+15*cos(theta)**5 + 83289402761506.3*cos(theta)**3 - 1612052956674.32*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl20_m10(theta, phi):
    return 2.98781341694522e-13*(1.0 - cos(theta)**2)**5*(8.8136846002226e+16*cos(theta)**10 - 1.01696360771799e+17*cos(theta)**8 + 3.84797040758159e+16*cos(theta)**6 - 5.49710058225942e+15*cos(theta)**4 + 249868208284519.0*cos(theta)**2 - 1612052956674.32)*cos(10*phi)

@torch.jit.script
def Yl20_m11(theta, phi):
    return 1.6969639886762e-14*(1.0 - cos(theta)**2)**5.5*(8.8136846002226e+17*cos(theta)**9 - 8.13570886174394e+17*cos(theta)**7 + 2.30878224454896e+17*cos(theta)**5 - 2.19884023290377e+16*cos(theta)**3 + 499736416569038.0*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl20_m12(theta, phi):
    return 9.99945619851927e-16*(1.0 - cos(theta)**2)**6*(7.93231614020034e+18*cos(theta)**8 - 5.69499620322076e+18*cos(theta)**6 + 1.15439112227448e+18*cos(theta)**4 - 6.5965206987113e+16*cos(theta)**2 + 499736416569038.0)*cos(12*phi)

@torch.jit.script
def Yl20_m13(theta, phi):
    return 6.15423986229134e-17*(1.0 - cos(theta)**2)**6.5*(6.34585291216027e+19*cos(theta)**7 - 3.41699772193245e+19*cos(theta)**5 + 4.61756448909791e+18*cos(theta)**3 - 1.31930413974226e+17*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl20_m14(theta, phi):
    return 3.9892011943704e-18*(1.0 - cos(theta)**2)**7*(4.44209703851219e+20*cos(theta)**6 - 1.70849886096623e+20*cos(theta)**4 + 1.38526934672937e+19*cos(theta)**2 - 1.31930413974226e+17)*cos(14*phi)

@torch.jit.script
def Yl20_m15(theta, phi):
    return 2.7528103535224e-19*(1.0 - cos(theta)**2)**7.5*(2.66525822310731e+21*cos(theta)**5 - 6.83399544386491e+20*cos(theta)**3 + 2.77053869345875e+19*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl20_m16(theta, phi):
    return 2.05182369321377e-20*(1.0 - cos(theta)**2)**8*(1.33262911155366e+22*cos(theta)**4 - 2.05019863315947e+21*cos(theta)**2 + 2.77053869345875e+19)*cos(16*phi)

@torch.jit.script
def Yl20_m17(theta, phi):
    return 1.68658868646741e-21*(1.0 - cos(theta)**2)**8.5*(5.33051644621463e+22*cos(theta)**3 - 4.10039726631895e+21*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl20_m18(theta, phi):
    return 1.57963503371958e-22*(1.0 - cos(theta)**2)**9*(1.59915493386439e+23*cos(theta)**2 - 4.10039726631895e+21)*cos(18*phi)

@torch.jit.script
def Yl20_m19(theta, phi):
    return 5.72044736290064*(1.0 - cos(theta)**2)**9.5*cos(19*phi)*cos(theta)

@torch.jit.script
def Yl20_m20(theta, phi):
    return 0.904482145093491*(1.0 - cos(theta)**2)**10*cos(20*phi)

@torch.jit.script
def Yl21_m_minus_21(theta, phi):
    return 0.915186448400331*(1.0 - cos(theta)**2)**10.5*sin(21*phi)

@torch.jit.script
def Yl21_m_minus_20(theta, phi):
    return 5.93108606277937*(1.0 - cos(theta)**2)**10*sin(20*phi)*cos(theta)

@torch.jit.script
def Yl21_m_minus_19(theta, phi):
    return 4.09578128625229e-24*(1.0 - cos(theta)**2)**9.5*(6.55653522884399e+24*cos(theta)**2 - 1.59915493386439e+23)*sin(19*phi)

@torch.jit.script
def Yl21_m_minus_18(theta, phi):
    return 4.48670360217581e-23*(1.0 - cos(theta)**2)**9*(2.185511742948e+24*cos(theta)**3 - 1.59915493386439e+23*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl21_m_minus_17(theta, phi):
    return 5.60389100299896e-22*(1.0 - cos(theta)**2)**8.5*(5.46377935737e+23*cos(theta)**4 - 7.99577466932194e+22*cos(theta)**2 + 1.02509931657974e+21)*sin(17*phi)

@torch.jit.script
def Yl21_m_minus_16(theta, phi):
    return 7.72443067867375e-21*(1.0 - cos(theta)**2)**8*(1.092755871474e+23*cos(theta)**5 - 2.66525822310731e+22*cos(theta)**3 + 1.02509931657974e+21*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl21_m_minus_15(theta, phi):
    return 1.15091424992218e-19*(1.0 - cos(theta)**2)**7.5*(1.82125978579e+22*cos(theta)**6 - 6.66314555776829e+21*cos(theta)**4 + 5.12549658289868e+20*cos(theta)**2 - 4.61756448909791e+18)*sin(15*phi)

@torch.jit.script
def Yl21_m_minus_14(theta, phi):
    return 1.82701973139271e-18*(1.0 - cos(theta)**2)**7*(2.60179969398571e+21*cos(theta)**7 - 1.33262911155366e+21*cos(theta)**5 + 1.70849886096623e+20*cos(theta)**3 - 4.61756448909791e+18*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl21_m_minus_13(theta, phi):
    return 3.05718875389061e-17*(1.0 - cos(theta)**2)**6.5*(3.25224961748214e+20*cos(theta)**8 - 2.2210485192561e+20*cos(theta)**6 + 4.27124715241557e+19*cos(theta)**4 - 2.30878224454896e+18*cos(theta)**2 + 1.64913017467783e+16)*sin(13*phi)

@torch.jit.script
def Yl21_m_minus_12(theta, phi):
    return 5.34789616721945e-16*(1.0 - cos(theta)**2)**6*(3.61361068609127e+19*cos(theta)**9 - 3.17292645608014e+19*cos(theta)**7 + 8.54249430483114e+18*cos(theta)**5 - 7.69594081516319e+17*cos(theta)**3 + 1.64913017467783e+16*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl21_m_minus_11(theta, phi):
    return 9.71493583461516e-15*(1.0 - cos(theta)**2)**5.5*(3.61361068609127e+18*cos(theta)**10 - 3.96615807010017e+18*cos(theta)**8 + 1.42374905080519e+18*cos(theta)**6 - 1.9239852037908e+17*cos(theta)**4 + 8.24565087338913e+15*cos(theta)**2 - 49973641656903.8)*sin(11*phi)

@torch.jit.script
def Yl21_m_minus_10(theta, phi):
    return 1.82268352577409e-13*(1.0 - cos(theta)**2)**5*(3.28510062371933e+17*cos(theta)**11 - 4.4068423001113e+17*cos(theta)**9 + 2.03392721543598e+17*cos(theta)**7 - 3.84797040758159e+16*cos(theta)**5 + 2.74855029112971e+15*cos(theta)**3 - 49973641656903.8*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl21_m_minus_9(theta, phi):
    return 3.51546467407613e-12*(1.0 - cos(theta)**2)**4.5*(2.73758385309944e+16*cos(theta)**12 - 4.4068423001113e+16*cos(theta)**10 + 2.54240901929498e+16*cos(theta)**8 - 6.41328401263599e+15*cos(theta)**6 + 687137572782427.0*cos(theta)**4 - 24986820828451.9*cos(theta)**2 + 134337746389.526)*sin(9*phi)

@torch.jit.script
def Yl21_m_minus_8(theta, phi):
    return 6.94248646460625e-11*(1.0 - cos(theta)**2)**4*(2.10583373315342e+15*cos(theta)**13 - 4.00622027282846e+15*cos(theta)**11 + 2.82489891032776e+15*cos(theta)**9 - 916183430376570.0*cos(theta)**7 + 137427514556485.0*cos(theta)**5 - 8328940276150.63*cos(theta)**3 + 134337746389.526*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl21_m_minus_7(theta, phi):
    return 1.39887226130065e-9*(1.0 - cos(theta)**2)**3.5*(150416695225244.0*cos(theta)**14 - 333851689402371.0*cos(theta)**12 + 282489891032776.0*cos(theta)**10 - 114522928797071.0*cos(theta)**8 + 22904585759414.2*cos(theta)**6 - 2082235069037.66*cos(theta)**4 + 67168873194.7632*cos(theta)**2 - 330881148.742676)*sin(7*phi)

@torch.jit.script
def Yl21_m_minus_6(theta, phi):
    return 2.86683503788286e-8*(1.0 - cos(theta)**2)**3*(10027779681682.9*cos(theta)**15 - 25680899184797.8*cos(theta)**13 + 25680899184797.8*cos(theta)**11 - 12724769866341.2*cos(theta)**9 + 3272083679916.32*cos(theta)**7 - 416447013807.532*cos(theta)**5 + 22389624398.2544*cos(theta)**3 - 330881148.742676*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl21_m_minus_5(theta, phi):
    return 5.95860473103812e-7*(1.0 - cos(theta)**2)**2.5*(626736230105.184*cos(theta)**16 - 1834349941771.27*cos(theta)**14 + 2140074932066.48*cos(theta)**12 - 1272476986634.12*cos(theta)**10 + 409010459989.54*cos(theta)**8 - 69407835634.5886*cos(theta)**6 + 5597406099.5636*cos(theta)**4 - 165440574.371338*cos(theta)**2 + 765928.58505249)*sin(5*phi)

@torch.jit.script
def Yl21_m_minus_4(theta, phi):
    return 1.25272490558029e-5*(1.0 - cos(theta)**2)**2*(36866837065.0108*cos(theta)**17 - 122289996118.085*cos(theta)**15 + 164621148620.499*cos(theta)**13 - 115679726057.648*cos(theta)**11 + 45445606665.5045*cos(theta)**9 - 9915405090.65552*cos(theta)**7 + 1119481219.91272*cos(theta)**5 - 55146858.1237793*cos(theta)**3 + 765928.58505249*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl21_m_minus_3(theta, phi):
    return 0.00026574308270913*(1.0 - cos(theta)**2)**1.5*(2048157614.72282*cos(theta)**18 - 7643124757.38029*cos(theta)**16 + 11758653472.8928*cos(theta)**14 - 9639977171.47064*cos(theta)**12 + 4544560666.55045*cos(theta)**10 - 1239425636.33194*cos(theta)**8 + 186580203.318787*cos(theta)**6 - 13786714.5309448*cos(theta)**4 + 382964.292526245*cos(theta)**2 - 1702.06352233887)*sin(3*phi)

@torch.jit.script
def Yl21_m_minus_2(theta, phi):
    return 0.00567471937804281*(1.0 - cos(theta)**2)*(107797769.195938*cos(theta)**19 - 449595573.963547*cos(theta)**17 + 783910231.526184*cos(theta)**15 - 741536705.497742*cos(theta)**13 + 413141878.777313*cos(theta)**11 - 137713959.592438*cos(theta)**9 + 26654314.7598267*cos(theta)**7 - 2757342.90618896*cos(theta)**5 + 127654.764175415*cos(theta)**3 - 1702.06352233887*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl21_m_minus_1(theta, phi):
    return 0.121709171425106*(1.0 - cos(theta)**2)**0.5*(5389888.45979691*cos(theta)**20 - 24977531.8868637*cos(theta)**18 + 48994389.4703865*cos(theta)**16 - 52966907.535553*cos(theta)**14 + 34428489.8981094*cos(theta)**12 - 13771395.9592438*cos(theta)**10 + 3331789.34497833*cos(theta)**8 - 459557.151031494*cos(theta)**6 + 31913.6910438538*cos(theta)**4 - 851.031761169434*cos(theta)**2 + 3.70013809204102)*sin(phi)

@torch.jit.script
def Yl21_m0(theta, phi):
    return 474777.116937231*cos(theta)**21 - 2431785.23309314*cos(theta)**19 + 5331221.47255034*cos(theta)**17 - 6531947.02943104*cos(theta)**15 + 4898960.27207328*cos(theta)**13 - 2315872.12861646*cos(theta)**11 + 684800.898246803*cos(theta)**9 - 121442.523827019*cos(theta)**7 + 11806.912038738*cos(theta)**5 - 524.751646166133*cos(theta)**3 + 6.84458668912347*cos(theta)

@torch.jit.script
def Yl21_m1(theta, phi):
    return 0.121709171425106*(1.0 - cos(theta)**2)**0.5*(5389888.45979691*cos(theta)**20 - 24977531.8868637*cos(theta)**18 + 48994389.4703865*cos(theta)**16 - 52966907.535553*cos(theta)**14 + 34428489.8981094*cos(theta)**12 - 13771395.9592438*cos(theta)**10 + 3331789.34497833*cos(theta)**8 - 459557.151031494*cos(theta)**6 + 31913.6910438538*cos(theta)**4 - 851.031761169434*cos(theta)**2 + 3.70013809204102)*cos(phi)

@torch.jit.script
def Yl21_m2(theta, phi):
    return 0.00567471937804281*(1.0 - cos(theta)**2)*(107797769.195938*cos(theta)**19 - 449595573.963547*cos(theta)**17 + 783910231.526184*cos(theta)**15 - 741536705.497742*cos(theta)**13 + 413141878.777313*cos(theta)**11 - 137713959.592438*cos(theta)**9 + 26654314.7598267*cos(theta)**7 - 2757342.90618896*cos(theta)**5 + 127654.764175415*cos(theta)**3 - 1702.06352233887*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl21_m3(theta, phi):
    return 0.00026574308270913*(1.0 - cos(theta)**2)**1.5*(2048157614.72282*cos(theta)**18 - 7643124757.38029*cos(theta)**16 + 11758653472.8928*cos(theta)**14 - 9639977171.47064*cos(theta)**12 + 4544560666.55045*cos(theta)**10 - 1239425636.33194*cos(theta)**8 + 186580203.318787*cos(theta)**6 - 13786714.5309448*cos(theta)**4 + 382964.292526245*cos(theta)**2 - 1702.06352233887)*cos(3*phi)

@torch.jit.script
def Yl21_m4(theta, phi):
    return 1.25272490558029e-5*(1.0 - cos(theta)**2)**2*(36866837065.0108*cos(theta)**17 - 122289996118.085*cos(theta)**15 + 164621148620.499*cos(theta)**13 - 115679726057.648*cos(theta)**11 + 45445606665.5045*cos(theta)**9 - 9915405090.65552*cos(theta)**7 + 1119481219.91272*cos(theta)**5 - 55146858.1237793*cos(theta)**3 + 765928.58505249*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl21_m5(theta, phi):
    return 5.95860473103812e-7*(1.0 - cos(theta)**2)**2.5*(626736230105.184*cos(theta)**16 - 1834349941771.27*cos(theta)**14 + 2140074932066.48*cos(theta)**12 - 1272476986634.12*cos(theta)**10 + 409010459989.54*cos(theta)**8 - 69407835634.5886*cos(theta)**6 + 5597406099.5636*cos(theta)**4 - 165440574.371338*cos(theta)**2 + 765928.58505249)*cos(5*phi)

@torch.jit.script
def Yl21_m6(theta, phi):
    return 2.86683503788286e-8*(1.0 - cos(theta)**2)**3*(10027779681682.9*cos(theta)**15 - 25680899184797.8*cos(theta)**13 + 25680899184797.8*cos(theta)**11 - 12724769866341.2*cos(theta)**9 + 3272083679916.32*cos(theta)**7 - 416447013807.532*cos(theta)**5 + 22389624398.2544*cos(theta)**3 - 330881148.742676*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl21_m7(theta, phi):
    return 1.39887226130065e-9*(1.0 - cos(theta)**2)**3.5*(150416695225244.0*cos(theta)**14 - 333851689402371.0*cos(theta)**12 + 282489891032776.0*cos(theta)**10 - 114522928797071.0*cos(theta)**8 + 22904585759414.2*cos(theta)**6 - 2082235069037.66*cos(theta)**4 + 67168873194.7632*cos(theta)**2 - 330881148.742676)*cos(7*phi)

@torch.jit.script
def Yl21_m8(theta, phi):
    return 6.94248646460625e-11*(1.0 - cos(theta)**2)**4*(2.10583373315342e+15*cos(theta)**13 - 4.00622027282846e+15*cos(theta)**11 + 2.82489891032776e+15*cos(theta)**9 - 916183430376570.0*cos(theta)**7 + 137427514556485.0*cos(theta)**5 - 8328940276150.63*cos(theta)**3 + 134337746389.526*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl21_m9(theta, phi):
    return 3.51546467407613e-12*(1.0 - cos(theta)**2)**4.5*(2.73758385309944e+16*cos(theta)**12 - 4.4068423001113e+16*cos(theta)**10 + 2.54240901929498e+16*cos(theta)**8 - 6.41328401263599e+15*cos(theta)**6 + 687137572782427.0*cos(theta)**4 - 24986820828451.9*cos(theta)**2 + 134337746389.526)*cos(9*phi)

@torch.jit.script
def Yl21_m10(theta, phi):
    return 1.82268352577409e-13*(1.0 - cos(theta)**2)**5*(3.28510062371933e+17*cos(theta)**11 - 4.4068423001113e+17*cos(theta)**9 + 2.03392721543598e+17*cos(theta)**7 - 3.84797040758159e+16*cos(theta)**5 + 2.74855029112971e+15*cos(theta)**3 - 49973641656903.8*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl21_m11(theta, phi):
    return 9.71493583461516e-15*(1.0 - cos(theta)**2)**5.5*(3.61361068609127e+18*cos(theta)**10 - 3.96615807010017e+18*cos(theta)**8 + 1.42374905080519e+18*cos(theta)**6 - 1.9239852037908e+17*cos(theta)**4 + 8.24565087338913e+15*cos(theta)**2 - 49973641656903.8)*cos(11*phi)

@torch.jit.script
def Yl21_m12(theta, phi):
    return 5.34789616721945e-16*(1.0 - cos(theta)**2)**6*(3.61361068609127e+19*cos(theta)**9 - 3.17292645608014e+19*cos(theta)**7 + 8.54249430483114e+18*cos(theta)**5 - 7.69594081516319e+17*cos(theta)**3 + 1.64913017467783e+16*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl21_m13(theta, phi):
    return 3.05718875389061e-17*(1.0 - cos(theta)**2)**6.5*(3.25224961748214e+20*cos(theta)**8 - 2.2210485192561e+20*cos(theta)**6 + 4.27124715241557e+19*cos(theta)**4 - 2.30878224454896e+18*cos(theta)**2 + 1.64913017467783e+16)*cos(13*phi)

@torch.jit.script
def Yl21_m14(theta, phi):
    return 1.82701973139271e-18*(1.0 - cos(theta)**2)**7*(2.60179969398571e+21*cos(theta)**7 - 1.33262911155366e+21*cos(theta)**5 + 1.70849886096623e+20*cos(theta)**3 - 4.61756448909791e+18*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl21_m15(theta, phi):
    return 1.15091424992218e-19*(1.0 - cos(theta)**2)**7.5*(1.82125978579e+22*cos(theta)**6 - 6.66314555776829e+21*cos(theta)**4 + 5.12549658289868e+20*cos(theta)**2 - 4.61756448909791e+18)*cos(15*phi)

@torch.jit.script
def Yl21_m16(theta, phi):
    return 7.72443067867375e-21*(1.0 - cos(theta)**2)**8*(1.092755871474e+23*cos(theta)**5 - 2.66525822310731e+22*cos(theta)**3 + 1.02509931657974e+21*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl21_m17(theta, phi):
    return 5.60389100299896e-22*(1.0 - cos(theta)**2)**8.5*(5.46377935737e+23*cos(theta)**4 - 7.99577466932194e+22*cos(theta)**2 + 1.02509931657974e+21)*cos(17*phi)

@torch.jit.script
def Yl21_m18(theta, phi):
    return 4.48670360217581e-23*(1.0 - cos(theta)**2)**9*(2.185511742948e+24*cos(theta)**3 - 1.59915493386439e+23*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl21_m19(theta, phi):
    return 4.09578128625229e-24*(1.0 - cos(theta)**2)**9.5*(6.55653522884399e+24*cos(theta)**2 - 1.59915493386439e+23)*cos(19*phi)

@torch.jit.script
def Yl21_m20(theta, phi):
    return 5.93108606277937*(1.0 - cos(theta)**2)**10*cos(20*phi)*cos(theta)

@torch.jit.script
def Yl21_m21(theta, phi):
    return 0.915186448400331*(1.0 - cos(theta)**2)**10.5*cos(21*phi)

@torch.jit.script
def Yl22_m_minus_22(theta, phi):
    return 0.925527866459589*(1.0 - cos(theta)**2)**11*sin(22*phi)

@torch.jit.script
def Yl22_m_minus_21(theta, phi):
    return 6.13925733212923*(1.0 - cos(theta)**2)**10.5*sin(21*phi)*cos(theta)

@torch.jit.script
def Yl22_m_minus_20(theta, phi):
    return 1.00969966670912e-25*(1.0 - cos(theta)**2)**10*(2.81931014840292e+26*cos(theta)**2 - 6.55653522884399e+24)*sin(20*phi)

@torch.jit.script
def Yl22_m_minus_19(theta, phi):
    return 1.13338506490961e-24*(1.0 - cos(theta)**2)**9.5*(9.39770049467639e+25*cos(theta)**3 - 6.55653522884399e+24*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl22_m_minus_18(theta, phi):
    return 1.45144107589342e-23*(1.0 - cos(theta)**2)**9*(2.3494251236691e+25*cos(theta)**4 - 3.278267614422e+24*cos(theta)**2 + 3.99788733466097e+22)*sin(18*phi)

@torch.jit.script
def Yl22_m_minus_17(theta, phi):
    return 2.05264765451388e-22*(1.0 - cos(theta)**2)**8.5*(4.6988502473382e+24*cos(theta)**5 - 1.092755871474e+24*cos(theta)**3 + 3.99788733466097e+22*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl22_m_minus_16(theta, phi):
    return 3.13994713346901e-21*(1.0 - cos(theta)**2)**8*(7.83141707889699e+23*cos(theta)**6 - 2.731889678685e+23*cos(theta)**4 + 1.99894366733049e+22*cos(theta)**2 - 1.70849886096623e+20)*sin(16*phi)

@torch.jit.script
def Yl22_m_minus_15(theta, phi):
    return 5.12109879641152e-20*(1.0 - cos(theta)**2)**7.5*(1.11877386841386e+23*cos(theta)**7 - 5.46377935737e+22*cos(theta)**5 + 6.66314555776829e+21*cos(theta)**3 - 1.70849886096623e+20*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl22_m_minus_14(theta, phi):
    return 8.81067151427848e-19*(1.0 - cos(theta)**2)**7*(1.39846733551732e+22*cos(theta)**8 - 9.10629892894999e+21*cos(theta)**6 + 1.66578638944207e+21*cos(theta)**4 - 8.54249430483114e+19*cos(theta)**2 + 5.77195561137239e+17)*sin(14*phi)

@torch.jit.script
def Yl22_m_minus_13(theta, phi):
    return 1.58592087257013e-17*(1.0 - cos(theta)**2)**6.5*(1.55385259501924e+21*cos(theta)**9 - 1.30089984699286e+21*cos(theta)**7 + 3.33157277888414e+20*cos(theta)**5 - 2.84749810161038e+19*cos(theta)**3 + 5.77195561137239e+17*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl22_m_minus_12(theta, phi):
    return 2.9669862738455e-16*(1.0 - cos(theta)**2)**6*(1.55385259501924e+20*cos(theta)**10 - 1.62612480874107e+20*cos(theta)**8 + 5.55262129814024e+19*cos(theta)**6 - 7.11874525402595e+18*cos(theta)**4 + 2.8859778056862e+17*cos(theta)**2 - 1.64913017467783e+15)*sin(12*phi)

@torch.jit.script
def Yl22_m_minus_11(theta, phi):
    return 5.73787837392547e-15*(1.0 - cos(theta)**2)**5.5*(1.41259326819931e+19*cos(theta)**11 - 1.80680534304563e+19*cos(theta)**9 + 7.93231614020034e+18*cos(theta)**7 - 1.42374905080519e+18*cos(theta)**5 + 9.61992601895398e+16*cos(theta)**3 - 1.64913017467783e+15*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl22_m_minus_10(theta, phi):
    return 1.14182337954032e-13*(1.0 - cos(theta)**2)**5*(1.17716105683276e+18*cos(theta)**12 - 1.80680534304563e+18*cos(theta)**10 + 9.91539517525043e+17*cos(theta)**8 - 2.37291508467532e+17*cos(theta)**6 + 2.4049815047385e+16*cos(theta)**4 - 824565087338913.0*cos(theta)**2 + 4164470138075.32)*sin(10*phi)

@torch.jit.script
def Yl22_m_minus_9(theta, phi):
    return 2.32887187734102e-12*(1.0 - cos(theta)**2)**4.5*(9.0550850525597e+16*cos(theta)**13 - 1.64255031185967e+17*cos(theta)**11 + 1.10171057502783e+17*cos(theta)**9 - 3.38987869239331e+16*cos(theta)**7 + 4.80996300947699e+15*cos(theta)**5 - 274855029112971.0*cos(theta)**3 + 4164470138075.32*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl22_m_minus_8(theta, phi):
    return 4.85166115051776e-11*(1.0 - cos(theta)**2)**4*(6.4679178946855e+15*cos(theta)**14 - 1.36879192654972e+16*cos(theta)**12 + 1.10171057502783e+16*cos(theta)**10 - 4.23734836549164e+15*cos(theta)**8 + 801660501579499.0*cos(theta)**6 - 68713757278242.7*cos(theta)**4 + 2082235069037.66*cos(theta)**2 - 9595553313.5376)*sin(8*phi)

@torch.jit.script
def Yl22_m_minus_7(theta, phi):
    return 1.02919274986513e-9*(1.0 - cos(theta)**2)**3.5*(431194526312367.0*cos(theta)**15 - 1.05291686657671e+15*cos(theta)**13 + 1.00155506820711e+15*cos(theta)**11 - 470816485054626.0*cos(theta)**9 + 114522928797071.0*cos(theta)**7 - 13742751455648.5*cos(theta)**5 + 694078356345.886*cos(theta)**3 - 9595553313.5376*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl22_m_minus_6(theta, phi):
    return 2.21694903053267e-8*(1.0 - cos(theta)**2)**3*(26949657894522.9*cos(theta)**16 - 75208347612622.1*cos(theta)**14 + 83462922350592.8*cos(theta)**12 - 47081648505462.6*cos(theta)**10 + 14315366099633.9*cos(theta)**8 - 2290458575941.42*cos(theta)**6 + 173519589086.472*cos(theta)**4 - 4797776656.7688*cos(theta)**2 + 20680071.7964172)*sin(6*phi)

@torch.jit.script
def Yl22_m_minus_5(theta, phi):
    return 4.83681174938034e-7*(1.0 - cos(theta)**2)**2.5*(1585273993795.47*cos(theta)**17 - 5013889840841.47*cos(theta)**15 + 6420224796199.45*cos(theta)**13 - 4280149864132.96*cos(theta)**11 + 1590596233292.66*cos(theta)**9 - 327208367991.632*cos(theta)**7 + 34703917817.2943*cos(theta)**5 - 1599258885.5896*cos(theta)**3 + 20680071.7964172*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl22_m_minus_4(theta, phi):
    return 1.06629486910923e-5*(1.0 - cos(theta)**2)**2*(88070777433.0814*cos(theta)**18 - 313368115052.592*cos(theta)**16 + 458587485442.818*cos(theta)**14 - 356679155344.414*cos(theta)**12 + 159059623329.266*cos(theta)**10 - 40901045998.954*cos(theta)**8 + 5783986302.88239*cos(theta)**6 - 399814721.3974*cos(theta)**4 + 10340035.8982086*cos(theta)**2 - 42551.5880584717)*sin(4*phi)

@torch.jit.script
def Yl22_m_minus_3(theta, phi):
    return 0.000236995878752564*(1.0 - cos(theta)**2)**1.5*(4635304075.42534*cos(theta)**19 - 18433418532.5054*cos(theta)**17 + 30572499029.5212*cos(theta)**15 - 27436858103.4164*cos(theta)**13 + 14459965757.206*cos(theta)**11 - 4544560666.55045*cos(theta)**9 + 826283757.554626*cos(theta)**7 - 79962944.27948*cos(theta)**5 + 3446678.63273621*cos(theta)**3 - 42551.5880584717*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl22_m_minus_2(theta, phi):
    return 0.00529938895278031*(1.0 - cos(theta)**2)*(231765203.771267*cos(theta)**20 - 1024078807.36141*cos(theta)**18 + 1910781189.34507*cos(theta)**16 - 1959775578.81546*cos(theta)**14 + 1204997146.43383*cos(theta)**12 - 454456066.655045*cos(theta)**10 + 103285469.694328*cos(theta)**8 - 13327157.3799133*cos(theta)**6 + 861669.658184052*cos(theta)**4 - 21275.7940292358*cos(theta)**2 + 85.1031761169434)*sin(2*phi)

@torch.jit.script
def Yl22_m_minus_1(theta, phi):
    return 0.118970986923352*(1.0 - cos(theta)**2)**0.5*(11036438.2748222*cos(theta)**21 - 53898884.5979691*cos(theta)**19 + 112398893.490887*cos(theta)**17 - 130651705.254364*cos(theta)**15 + 92692088.1872177*cos(theta)**13 - 41314187.8777313*cos(theta)**11 + 11476163.2993698*cos(theta)**9 - 1903879.6257019*cos(theta)**7 + 172333.93163681*cos(theta)**5 - 7091.93134307861*cos(theta)**3 + 85.1031761169434*cos(theta))*sin(phi)

@torch.jit.script
def Yl22_m0(theta, phi):
    return 949308.966084274*cos(theta)**22 - 5099776.07361552*cos(theta)**20 + 11816554.316914*cos(theta)**18 - 15452417.1836568*cos(theta)**16 + 12528986.9056677*cos(theta)**14 - 6515073.19094719*cos(theta)**12 + 2171691.06364906*cos(theta)**10 - 450350.681401879*cos(theta)**8 + 54352.6684450544*cos(theta)**6 - 3355.10299043546*cos(theta)**4 + 80.5224717704509*cos(theta)**2 - 0.318270639408897

@torch.jit.script
def Yl22_m1(theta, phi):
    return 0.118970986923352*(1.0 - cos(theta)**2)**0.5*(11036438.2748222*cos(theta)**21 - 53898884.5979691*cos(theta)**19 + 112398893.490887*cos(theta)**17 - 130651705.254364*cos(theta)**15 + 92692088.1872177*cos(theta)**13 - 41314187.8777313*cos(theta)**11 + 11476163.2993698*cos(theta)**9 - 1903879.6257019*cos(theta)**7 + 172333.93163681*cos(theta)**5 - 7091.93134307861*cos(theta)**3 + 85.1031761169434*cos(theta))*cos(phi)

@torch.jit.script
def Yl22_m2(theta, phi):
    return 0.00529938895278031*(1.0 - cos(theta)**2)*(231765203.771267*cos(theta)**20 - 1024078807.36141*cos(theta)**18 + 1910781189.34507*cos(theta)**16 - 1959775578.81546*cos(theta)**14 + 1204997146.43383*cos(theta)**12 - 454456066.655045*cos(theta)**10 + 103285469.694328*cos(theta)**8 - 13327157.3799133*cos(theta)**6 + 861669.658184052*cos(theta)**4 - 21275.7940292358*cos(theta)**2 + 85.1031761169434)*cos(2*phi)

@torch.jit.script
def Yl22_m3(theta, phi):
    return 0.000236995878752564*(1.0 - cos(theta)**2)**1.5*(4635304075.42534*cos(theta)**19 - 18433418532.5054*cos(theta)**17 + 30572499029.5212*cos(theta)**15 - 27436858103.4164*cos(theta)**13 + 14459965757.206*cos(theta)**11 - 4544560666.55045*cos(theta)**9 + 826283757.554626*cos(theta)**7 - 79962944.27948*cos(theta)**5 + 3446678.63273621*cos(theta)**3 - 42551.5880584717*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl22_m4(theta, phi):
    return 1.06629486910923e-5*(1.0 - cos(theta)**2)**2*(88070777433.0814*cos(theta)**18 - 313368115052.592*cos(theta)**16 + 458587485442.818*cos(theta)**14 - 356679155344.414*cos(theta)**12 + 159059623329.266*cos(theta)**10 - 40901045998.954*cos(theta)**8 + 5783986302.88239*cos(theta)**6 - 399814721.3974*cos(theta)**4 + 10340035.8982086*cos(theta)**2 - 42551.5880584717)*cos(4*phi)

@torch.jit.script
def Yl22_m5(theta, phi):
    return 4.83681174938034e-7*(1.0 - cos(theta)**2)**2.5*(1585273993795.47*cos(theta)**17 - 5013889840841.47*cos(theta)**15 + 6420224796199.45*cos(theta)**13 - 4280149864132.96*cos(theta)**11 + 1590596233292.66*cos(theta)**9 - 327208367991.632*cos(theta)**7 + 34703917817.2943*cos(theta)**5 - 1599258885.5896*cos(theta)**3 + 20680071.7964172*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl22_m6(theta, phi):
    return 2.21694903053267e-8*(1.0 - cos(theta)**2)**3*(26949657894522.9*cos(theta)**16 - 75208347612622.1*cos(theta)**14 + 83462922350592.8*cos(theta)**12 - 47081648505462.6*cos(theta)**10 + 14315366099633.9*cos(theta)**8 - 2290458575941.42*cos(theta)**6 + 173519589086.472*cos(theta)**4 - 4797776656.7688*cos(theta)**2 + 20680071.7964172)*cos(6*phi)

@torch.jit.script
def Yl22_m7(theta, phi):
    return 1.02919274986513e-9*(1.0 - cos(theta)**2)**3.5*(431194526312367.0*cos(theta)**15 - 1.05291686657671e+15*cos(theta)**13 + 1.00155506820711e+15*cos(theta)**11 - 470816485054626.0*cos(theta)**9 + 114522928797071.0*cos(theta)**7 - 13742751455648.5*cos(theta)**5 + 694078356345.886*cos(theta)**3 - 9595553313.5376*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl22_m8(theta, phi):
    return 4.85166115051776e-11*(1.0 - cos(theta)**2)**4*(6.4679178946855e+15*cos(theta)**14 - 1.36879192654972e+16*cos(theta)**12 + 1.10171057502783e+16*cos(theta)**10 - 4.23734836549164e+15*cos(theta)**8 + 801660501579499.0*cos(theta)**6 - 68713757278242.7*cos(theta)**4 + 2082235069037.66*cos(theta)**2 - 9595553313.5376)*cos(8*phi)

@torch.jit.script
def Yl22_m9(theta, phi):
    return 2.32887187734102e-12*(1.0 - cos(theta)**2)**4.5*(9.0550850525597e+16*cos(theta)**13 - 1.64255031185967e+17*cos(theta)**11 + 1.10171057502783e+17*cos(theta)**9 - 3.38987869239331e+16*cos(theta)**7 + 4.80996300947699e+15*cos(theta)**5 - 274855029112971.0*cos(theta)**3 + 4164470138075.32*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl22_m10(theta, phi):
    return 1.14182337954032e-13*(1.0 - cos(theta)**2)**5*(1.17716105683276e+18*cos(theta)**12 - 1.80680534304563e+18*cos(theta)**10 + 9.91539517525043e+17*cos(theta)**8 - 2.37291508467532e+17*cos(theta)**6 + 2.4049815047385e+16*cos(theta)**4 - 824565087338913.0*cos(theta)**2 + 4164470138075.32)*cos(10*phi)

@torch.jit.script
def Yl22_m11(theta, phi):
    return 5.73787837392547e-15*(1.0 - cos(theta)**2)**5.5*(1.41259326819931e+19*cos(theta)**11 - 1.80680534304563e+19*cos(theta)**9 + 7.93231614020034e+18*cos(theta)**7 - 1.42374905080519e+18*cos(theta)**5 + 9.61992601895398e+16*cos(theta)**3 - 1.64913017467783e+15*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl22_m12(theta, phi):
    return 2.9669862738455e-16*(1.0 - cos(theta)**2)**6*(1.55385259501924e+20*cos(theta)**10 - 1.62612480874107e+20*cos(theta)**8 + 5.55262129814024e+19*cos(theta)**6 - 7.11874525402595e+18*cos(theta)**4 + 2.8859778056862e+17*cos(theta)**2 - 1.64913017467783e+15)*cos(12*phi)

@torch.jit.script
def Yl22_m13(theta, phi):
    return 1.58592087257013e-17*(1.0 - cos(theta)**2)**6.5*(1.55385259501924e+21*cos(theta)**9 - 1.30089984699286e+21*cos(theta)**7 + 3.33157277888414e+20*cos(theta)**5 - 2.84749810161038e+19*cos(theta)**3 + 5.77195561137239e+17*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl22_m14(theta, phi):
    return 8.81067151427848e-19*(1.0 - cos(theta)**2)**7*(1.39846733551732e+22*cos(theta)**8 - 9.10629892894999e+21*cos(theta)**6 + 1.66578638944207e+21*cos(theta)**4 - 8.54249430483114e+19*cos(theta)**2 + 5.77195561137239e+17)*cos(14*phi)

@torch.jit.script
def Yl22_m15(theta, phi):
    return 5.12109879641152e-20*(1.0 - cos(theta)**2)**7.5*(1.11877386841386e+23*cos(theta)**7 - 5.46377935737e+22*cos(theta)**5 + 6.66314555776829e+21*cos(theta)**3 - 1.70849886096623e+20*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl22_m16(theta, phi):
    return 3.13994713346901e-21*(1.0 - cos(theta)**2)**8*(7.83141707889699e+23*cos(theta)**6 - 2.731889678685e+23*cos(theta)**4 + 1.99894366733049e+22*cos(theta)**2 - 1.70849886096623e+20)*cos(16*phi)

@torch.jit.script
def Yl22_m17(theta, phi):
    return 2.05264765451388e-22*(1.0 - cos(theta)**2)**8.5*(4.6988502473382e+24*cos(theta)**5 - 1.092755871474e+24*cos(theta)**3 + 3.99788733466097e+22*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl22_m18(theta, phi):
    return 1.45144107589342e-23*(1.0 - cos(theta)**2)**9*(2.3494251236691e+25*cos(theta)**4 - 3.278267614422e+24*cos(theta)**2 + 3.99788733466097e+22)*cos(18*phi)

@torch.jit.script
def Yl22_m19(theta, phi):
    return 1.13338506490961e-24*(1.0 - cos(theta)**2)**9.5*(9.39770049467639e+25*cos(theta)**3 - 6.55653522884399e+24*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl22_m20(theta, phi):
    return 1.00969966670912e-25*(1.0 - cos(theta)**2)**10*(2.81931014840292e+26*cos(theta)**2 - 6.55653522884399e+24)*cos(20*phi)

@torch.jit.script
def Yl22_m21(theta, phi):
    return 6.13925733212923*(1.0 - cos(theta)**2)**10.5*cos(21*phi)*cos(theta)

@torch.jit.script
def Yl22_m22(theta, phi):
    return 0.925527866459589*(1.0 - cos(theta)**2)**11*cos(22*phi)

@torch.jit.script
def Yl23_m_minus_23(theta, phi):
    return 0.935533863919911*(1.0 - cos(theta)**2)**11.5*sin(23*phi)

@torch.jit.script
def Yl23_m_minus_22(theta, phi):
    return 6.34509937549305*(1.0 - cos(theta)**2)**11*sin(22*phi)*cos(theta)

@torch.jit.script
def Yl23_m_minus_21(theta, phi):
    return 2.37232572869364e-27*(1.0 - cos(theta)**2)**10.5*(1.26868956678131e+28*cos(theta)**2 - 2.81931014840292e+26)*sin(21*phi)

@torch.jit.script
def Yl23_m_minus_20(theta, phi):
    return 2.72559475329492e-26*(1.0 - cos(theta)**2)**10*(4.22896522260438e+27*cos(theta)**3 - 2.81931014840292e+26*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl23_m_minus_19(theta, phi):
    return 3.5745840073783e-25*(1.0 - cos(theta)**2)**9.5*(1.05724130565109e+27*cos(theta)**4 - 1.40965507420146e+26*cos(theta)**2 + 1.639133807211e+24)*sin(19*phi)

@torch.jit.script
def Yl23_m_minus_18(theta, phi):
    return 5.18006435618226e-24*(1.0 - cos(theta)**2)**9*(2.11448261130219e+26*cos(theta)**5 - 4.6988502473382e+25*cos(theta)**3 + 1.639133807211e+24*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl23_m_minus_17(theta, phi):
    return 8.12461347795126e-23*(1.0 - cos(theta)**2)**8.5*(3.52413768550365e+25*cos(theta)**6 - 1.17471256183455e+25*cos(theta)**4 + 8.19566903605499e+23*cos(theta)**2 - 6.66314555776829e+21)*sin(17*phi)

@torch.jit.script
def Yl23_m_minus_16(theta, phi):
    return 1.35950786560836e-21*(1.0 - cos(theta)**2)**8*(5.03448240786235e+24*cos(theta)**7 - 2.3494251236691e+24*cos(theta)**5 + 2.731889678685e+23*cos(theta)**3 - 6.66314555776829e+21*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl23_m_minus_15(theta, phi):
    return 2.40136967298897e-20*(1.0 - cos(theta)**2)**7.5*(6.29310300982794e+23*cos(theta)**8 - 3.9157085394485e+23*cos(theta)**6 + 6.82972419671249e+22*cos(theta)**4 - 3.33157277888414e+21*cos(theta)**2 + 2.13562357620778e+19)*sin(15*phi)

@torch.jit.script
def Yl23_m_minus_14(theta, phi):
    return 4.44091105154346e-19*(1.0 - cos(theta)**2)**7*(6.9923366775866e+22*cos(theta)**9 - 5.59386934206928e+22*cos(theta)**7 + 1.3659448393425e+22*cos(theta)**5 - 1.11052425962805e+21*cos(theta)**3 + 2.13562357620778e+19*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl23_m_minus_13(theta, phi):
    return 8.54226296601593e-18*(1.0 - cos(theta)**2)**6.5*(6.9923366775866e+21*cos(theta)**10 - 6.9923366775866e+21*cos(theta)**8 + 2.2765747322375e+21*cos(theta)**6 - 2.77631064907012e+20*cos(theta)**4 + 1.06781178810389e+19*cos(theta)**2 - 5.77195561137239e+16)*sin(13*phi)

@torch.jit.script
def Yl23_m_minus_12(theta, phi):
    return 1.6998888671294e-16*(1.0 - cos(theta)**2)**6*(6.35666970689691e+20*cos(theta)**11 - 7.76926297509622e+20*cos(theta)**9 + 3.25224961748214e+20*cos(theta)**7 - 5.55262129814024e+19*cos(theta)**5 + 3.55937262701297e+18*cos(theta)**3 - 5.77195561137239e+16*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl23_m_minus_11(theta, phi):
    return 3.48373550581555e-15*(1.0 - cos(theta)**2)**5.5*(5.29722475574742e+19*cos(theta)**12 - 7.76926297509622e+19*cos(theta)**10 + 4.06531202185268e+19*cos(theta)**8 - 9.25436883023373e+18*cos(theta)**6 + 8.89843156753243e+17*cos(theta)**4 - 2.88597780568619e+16*cos(theta)**2 + 137427514556485.0)*sin(11*phi)

@torch.jit.script
def Yl23_m_minus_10(theta, phi):
    return 7.32413447372461e-14*(1.0 - cos(theta)**2)**5*(4.07478827365187e+18*cos(theta)**13 - 7.06296634099657e+18*cos(theta)**11 + 4.51701335761408e+18*cos(theta)**9 - 1.32205269003339e+18*cos(theta)**7 + 1.77968631350649e+17*cos(theta)**5 - 9.61992601895398e+15*cos(theta)**3 + 137427514556485.0*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl23_m_minus_9(theta, phi):
    return 1.57426303248889e-12*(1.0 - cos(theta)**2)**4.5*(2.91056305260848e+17*cos(theta)**14 - 5.88580528416381e+17*cos(theta)**12 + 4.51701335761408e+17*cos(theta)**10 - 1.65256586254174e+17*cos(theta)**8 + 2.96614385584414e+16*cos(theta)**6 - 2.4049815047385e+15*cos(theta)**4 + 68713757278242.7*cos(theta)**2 - 297462152719.666)*sin(9*phi)

@torch.jit.script
def Yl23_m_minus_8(theta, phi):
    return 3.4490374973626e-11*(1.0 - cos(theta)**2)**4*(1.94037536840565e+16*cos(theta)**15 - 4.52754252627985e+16*cos(theta)**13 + 4.10637577964917e+16*cos(theta)**11 - 1.83618429171304e+16*cos(theta)**9 + 4.23734836549164e+15*cos(theta)**7 - 480996300947699.0*cos(theta)**5 + 22904585759414.2*cos(theta)**3 - 297462152719.666*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl23_m_minus_7(theta, phi):
    return 7.68137122555198e-10*(1.0 - cos(theta)**2)**3.5*(1.21273460525353e+15*cos(theta)**16 - 3.23395894734275e+15*cos(theta)**14 + 3.42197981637431e+15*cos(theta)**12 - 1.83618429171304e+15*cos(theta)**10 + 529668545686454.0*cos(theta)**8 - 80166050157949.9*cos(theta)**6 + 5726146439853.56*cos(theta)**4 - 148731076359.833*cos(theta)**2 + 599722082.0961)*sin(7*phi)

@torch.jit.script
def Yl23_m_minus_6(theta, phi):
    return 1.73469785817059e-8*(1.0 - cos(theta)**2)**3*(71337329720796.0*cos(theta)**17 - 215597263156183.0*cos(theta)**15 + 263229216644177.0*cos(theta)**13 - 166925844701186.0*cos(theta)**11 + 58852060631828.3*cos(theta)**9 - 11452292879707.1*cos(theta)**7 + 1145229287970.71*cos(theta)**5 - 49577025453.2776*cos(theta)**3 + 599722082.0961*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl23_m_minus_5(theta, phi):
    return 3.96331958851659e-7*(1.0 - cos(theta)**2)**2.5*(3963184984488.66*cos(theta)**18 - 13474828947261.5*cos(theta)**16 + 18802086903155.5*cos(theta)**14 - 13910487058432.1*cos(theta)**12 + 5885206063182.83*cos(theta)**10 - 1431536609963.39*cos(theta)**8 + 190871547995.119*cos(theta)**6 - 12394256363.3194*cos(theta)**4 + 299861041.04805*cos(theta)**2 - 1148892.87757874)*sin(5*phi)

@torch.jit.script
def Yl23_m_minus_4(theta, phi):
    return 9.1414462474505e-6*(1.0 - cos(theta)**2)**2*(208588683394.14*cos(theta)**19 - 792636996897.733*cos(theta)**17 + 1253472460210.37*cos(theta)**15 - 1070037466033.24*cos(theta)**13 + 535018733016.621*cos(theta)**11 - 159059623329.266*cos(theta)**9 + 27267363999.3027*cos(theta)**7 - 2478851272.66388*cos(theta)**5 + 99953680.34935*cos(theta)**3 - 1148892.87757874*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl23_m_minus_3(theta, phi):
    return 0.000212428014459756*(1.0 - cos(theta)**2)**1.5*(10429434169.707*cos(theta)**20 - 44035388716.5407*cos(theta)**18 + 78342028763.148*cos(theta)**16 - 76431247573.8029*cos(theta)**14 + 44584894418.0517*cos(theta)**12 - 15905962332.9266*cos(theta)**10 + 3408420499.91283*cos(theta)**8 - 413141878.777313*cos(theta)**6 + 24988420.0873375*cos(theta)**4 - 574446.438789368*cos(theta)**2 + 2127.57940292358)*sin(3*phi)

@torch.jit.script
def Yl23_m_minus_2(theta, phi):
    return 0.00496372955394567*(1.0 - cos(theta)**2)*(496639722.367001*cos(theta)**21 - 2317652037.71267*cos(theta)**19 + 4608354633.12635*cos(theta)**17 - 5095416504.9202*cos(theta)**15 + 3429607262.92706*cos(theta)**13 - 1445996575.7206*cos(theta)**11 + 378713388.879204*cos(theta)**9 - 59020268.396759*cos(theta)**7 + 4997684.0174675*cos(theta)**5 - 191482.146263123*cos(theta)**3 + 2127.57940292358*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl23_m_minus_1(theta, phi):
    return 0.116409776636641*(1.0 - cos(theta)**2)**0.5*(22574532.8348637*cos(theta)**22 - 115882601.885633*cos(theta)**20 + 256019701.840353*cos(theta)**18 - 318463531.557512*cos(theta)**16 + 244971947.351933*cos(theta)**14 - 120499714.643383*cos(theta)**12 + 37871338.8879204*cos(theta)**10 - 7377533.54959488*cos(theta)**8 + 832947.336244583*cos(theta)**6 - 47870.5365657806*cos(theta)**4 + 1063.78970146179*cos(theta)**2 - 3.86832618713379)*sin(phi)

@torch.jit.script
def Yl23_m0(theta, phi):
    return 1898169.24542421*cos(theta)**23 - 10671929.3131628*cos(theta)**21 + 26059362.2763277*cos(theta)**19 - 36228869.5061141*cos(theta)**17 + 31584142.6463559*cos(theta)**15 - 17926135.0154993*cos(theta)**13 + 6658278.72004259*cos(theta)**11 - 1585304.457153*cos(theta)**9 + 230124.840554467*cos(theta)**7 - 18515.7917687503*cos(theta)**5 + 685.770065509269*cos(theta)**3 - 7.48112798737384*cos(theta)

@torch.jit.script
def Yl23_m1(theta, phi):
    return 0.116409776636641*(1.0 - cos(theta)**2)**0.5*(22574532.8348637*cos(theta)**22 - 115882601.885633*cos(theta)**20 + 256019701.840353*cos(theta)**18 - 318463531.557512*cos(theta)**16 + 244971947.351933*cos(theta)**14 - 120499714.643383*cos(theta)**12 + 37871338.8879204*cos(theta)**10 - 7377533.54959488*cos(theta)**8 + 832947.336244583*cos(theta)**6 - 47870.5365657806*cos(theta)**4 + 1063.78970146179*cos(theta)**2 - 3.86832618713379)*cos(phi)

@torch.jit.script
def Yl23_m2(theta, phi):
    return 0.00496372955394567*(1.0 - cos(theta)**2)*(496639722.367001*cos(theta)**21 - 2317652037.71267*cos(theta)**19 + 4608354633.12635*cos(theta)**17 - 5095416504.9202*cos(theta)**15 + 3429607262.92706*cos(theta)**13 - 1445996575.7206*cos(theta)**11 + 378713388.879204*cos(theta)**9 - 59020268.396759*cos(theta)**7 + 4997684.0174675*cos(theta)**5 - 191482.146263123*cos(theta)**3 + 2127.57940292358*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl23_m3(theta, phi):
    return 0.000212428014459756*(1.0 - cos(theta)**2)**1.5*(10429434169.707*cos(theta)**20 - 44035388716.5407*cos(theta)**18 + 78342028763.148*cos(theta)**16 - 76431247573.8029*cos(theta)**14 + 44584894418.0517*cos(theta)**12 - 15905962332.9266*cos(theta)**10 + 3408420499.91283*cos(theta)**8 - 413141878.777313*cos(theta)**6 + 24988420.0873375*cos(theta)**4 - 574446.438789368*cos(theta)**2 + 2127.57940292358)*cos(3*phi)

@torch.jit.script
def Yl23_m4(theta, phi):
    return 9.1414462474505e-6*(1.0 - cos(theta)**2)**2*(208588683394.14*cos(theta)**19 - 792636996897.733*cos(theta)**17 + 1253472460210.37*cos(theta)**15 - 1070037466033.24*cos(theta)**13 + 535018733016.621*cos(theta)**11 - 159059623329.266*cos(theta)**9 + 27267363999.3027*cos(theta)**7 - 2478851272.66388*cos(theta)**5 + 99953680.34935*cos(theta)**3 - 1148892.87757874*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl23_m5(theta, phi):
    return 3.96331958851659e-7*(1.0 - cos(theta)**2)**2.5*(3963184984488.66*cos(theta)**18 - 13474828947261.5*cos(theta)**16 + 18802086903155.5*cos(theta)**14 - 13910487058432.1*cos(theta)**12 + 5885206063182.83*cos(theta)**10 - 1431536609963.39*cos(theta)**8 + 190871547995.119*cos(theta)**6 - 12394256363.3194*cos(theta)**4 + 299861041.04805*cos(theta)**2 - 1148892.87757874)*cos(5*phi)

@torch.jit.script
def Yl23_m6(theta, phi):
    return 1.73469785817059e-8*(1.0 - cos(theta)**2)**3*(71337329720796.0*cos(theta)**17 - 215597263156183.0*cos(theta)**15 + 263229216644177.0*cos(theta)**13 - 166925844701186.0*cos(theta)**11 + 58852060631828.3*cos(theta)**9 - 11452292879707.1*cos(theta)**7 + 1145229287970.71*cos(theta)**5 - 49577025453.2776*cos(theta)**3 + 599722082.0961*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl23_m7(theta, phi):
    return 7.68137122555198e-10*(1.0 - cos(theta)**2)**3.5*(1.21273460525353e+15*cos(theta)**16 - 3.23395894734275e+15*cos(theta)**14 + 3.42197981637431e+15*cos(theta)**12 - 1.83618429171304e+15*cos(theta)**10 + 529668545686454.0*cos(theta)**8 - 80166050157949.9*cos(theta)**6 + 5726146439853.56*cos(theta)**4 - 148731076359.833*cos(theta)**2 + 599722082.0961)*cos(7*phi)

@torch.jit.script
def Yl23_m8(theta, phi):
    return 3.4490374973626e-11*(1.0 - cos(theta)**2)**4*(1.94037536840565e+16*cos(theta)**15 - 4.52754252627985e+16*cos(theta)**13 + 4.10637577964917e+16*cos(theta)**11 - 1.83618429171304e+16*cos(theta)**9 + 4.23734836549164e+15*cos(theta)**7 - 480996300947699.0*cos(theta)**5 + 22904585759414.2*cos(theta)**3 - 297462152719.666*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl23_m9(theta, phi):
    return 1.57426303248889e-12*(1.0 - cos(theta)**2)**4.5*(2.91056305260848e+17*cos(theta)**14 - 5.88580528416381e+17*cos(theta)**12 + 4.51701335761408e+17*cos(theta)**10 - 1.65256586254174e+17*cos(theta)**8 + 2.96614385584414e+16*cos(theta)**6 - 2.4049815047385e+15*cos(theta)**4 + 68713757278242.7*cos(theta)**2 - 297462152719.666)*cos(9*phi)

@torch.jit.script
def Yl23_m10(theta, phi):
    return 7.32413447372461e-14*(1.0 - cos(theta)**2)**5*(4.07478827365187e+18*cos(theta)**13 - 7.06296634099657e+18*cos(theta)**11 + 4.51701335761408e+18*cos(theta)**9 - 1.32205269003339e+18*cos(theta)**7 + 1.77968631350649e+17*cos(theta)**5 - 9.61992601895398e+15*cos(theta)**3 + 137427514556485.0*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl23_m11(theta, phi):
    return 3.48373550581555e-15*(1.0 - cos(theta)**2)**5.5*(5.29722475574742e+19*cos(theta)**12 - 7.76926297509622e+19*cos(theta)**10 + 4.06531202185268e+19*cos(theta)**8 - 9.25436883023373e+18*cos(theta)**6 + 8.89843156753243e+17*cos(theta)**4 - 2.88597780568619e+16*cos(theta)**2 + 137427514556485.0)*cos(11*phi)

@torch.jit.script
def Yl23_m12(theta, phi):
    return 1.6998888671294e-16*(1.0 - cos(theta)**2)**6*(6.35666970689691e+20*cos(theta)**11 - 7.76926297509622e+20*cos(theta)**9 + 3.25224961748214e+20*cos(theta)**7 - 5.55262129814024e+19*cos(theta)**5 + 3.55937262701297e+18*cos(theta)**3 - 5.77195561137239e+16*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl23_m13(theta, phi):
    return 8.54226296601593e-18*(1.0 - cos(theta)**2)**6.5*(6.9923366775866e+21*cos(theta)**10 - 6.9923366775866e+21*cos(theta)**8 + 2.2765747322375e+21*cos(theta)**6 - 2.77631064907012e+20*cos(theta)**4 + 1.06781178810389e+19*cos(theta)**2 - 5.77195561137239e+16)*cos(13*phi)

@torch.jit.script
def Yl23_m14(theta, phi):
    return 4.44091105154346e-19*(1.0 - cos(theta)**2)**7*(6.9923366775866e+22*cos(theta)**9 - 5.59386934206928e+22*cos(theta)**7 + 1.3659448393425e+22*cos(theta)**5 - 1.11052425962805e+21*cos(theta)**3 + 2.13562357620778e+19*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl23_m15(theta, phi):
    return 2.40136967298897e-20*(1.0 - cos(theta)**2)**7.5*(6.29310300982794e+23*cos(theta)**8 - 3.9157085394485e+23*cos(theta)**6 + 6.82972419671249e+22*cos(theta)**4 - 3.33157277888414e+21*cos(theta)**2 + 2.13562357620778e+19)*cos(15*phi)

@torch.jit.script
def Yl23_m16(theta, phi):
    return 1.35950786560836e-21*(1.0 - cos(theta)**2)**8*(5.03448240786235e+24*cos(theta)**7 - 2.3494251236691e+24*cos(theta)**5 + 2.731889678685e+23*cos(theta)**3 - 6.66314555776829e+21*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl23_m17(theta, phi):
    return 8.12461347795126e-23*(1.0 - cos(theta)**2)**8.5*(3.52413768550365e+25*cos(theta)**6 - 1.17471256183455e+25*cos(theta)**4 + 8.19566903605499e+23*cos(theta)**2 - 6.66314555776829e+21)*cos(17*phi)

@torch.jit.script
def Yl23_m18(theta, phi):
    return 5.18006435618226e-24*(1.0 - cos(theta)**2)**9*(2.11448261130219e+26*cos(theta)**5 - 4.6988502473382e+25*cos(theta)**3 + 1.639133807211e+24*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl23_m19(theta, phi):
    return 3.5745840073783e-25*(1.0 - cos(theta)**2)**9.5*(1.05724130565109e+27*cos(theta)**4 - 1.40965507420146e+26*cos(theta)**2 + 1.639133807211e+24)*cos(19*phi)

@torch.jit.script
def Yl23_m20(theta, phi):
    return 2.72559475329492e-26*(1.0 - cos(theta)**2)**10*(4.22896522260438e+27*cos(theta)**3 - 2.81931014840292e+26*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl23_m21(theta, phi):
    return 2.37232572869364e-27*(1.0 - cos(theta)**2)**10.5*(1.26868956678131e+28*cos(theta)**2 - 2.81931014840292e+26)*cos(21*phi)

@torch.jit.script
def Yl23_m22(theta, phi):
    return 6.34509937549305*(1.0 - cos(theta)**2)**11*cos(22*phi)*cos(theta)

@torch.jit.script
def Yl23_m23(theta, phi):
    return 0.935533863919911*(1.0 - cos(theta)**2)**11.5*cos(23*phi)

@torch.jit.script
def Yl24_m_minus_24(theta, phi):
    return 0.9452287742978*(1.0 - cos(theta)**2)**12*sin(24*phi)

@torch.jit.script
def Yl24_m_minus_23(theta, phi):
    return 6.54873704743938*(1.0 - cos(theta)**2)**11.5*sin(23*phi)*cos(theta)

@torch.jit.script
def Yl24_m_minus_22(theta, phi):
    return 5.3240025801011e-29*(1.0 - cos(theta)**2)**11*(5.96284096387217e+29*cos(theta)**2 - 1.26868956678131e+28)*sin(22*phi)

@torch.jit.script
def Yl24_m_minus_21(theta, phi):
    return 6.25428691320073e-28*(1.0 - cos(theta)**2)**10.5*(1.98761365462406e+29*cos(theta)**3 - 1.26868956678131e+28*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl24_m_minus_20(theta, phi):
    return 8.39100641322249e-27*(1.0 - cos(theta)**2)**10*(4.96903413656014e+28*cos(theta)**4 - 6.34344783390656e+27*cos(theta)**2 + 7.04827537100729e+25)*sin(20*phi)

@torch.jit.script
def Yl24_m_minus_19(theta, phi):
    return 1.24458738133901e-25*(1.0 - cos(theta)**2)**9.5*(9.93806827312028e+27*cos(theta)**5 - 2.11448261130219e+27*cos(theta)**3 + 7.04827537100729e+25*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl24_m_minus_18(theta, phi):
    return 1.99910334761708e-24*(1.0 - cos(theta)**2)**9*(1.65634471218671e+27*cos(theta)**6 - 5.28620652825547e+26*cos(theta)**4 + 3.52413768550365e+25*cos(theta)**2 - 2.731889678685e+23)*sin(18*phi)

@torch.jit.script
def Yl24_m_minus_17(theta, phi):
    return 3.42774820132609e-23*(1.0 - cos(theta)**2)**8.5*(2.36620673169531e+26*cos(theta)**7 - 1.05724130565109e+26*cos(theta)**5 + 1.17471256183455e+25*cos(theta)**3 - 2.731889678685e+23*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl24_m_minus_16(theta, phi):
    return 6.2079160239131e-22*(1.0 - cos(theta)**2)**8*(2.95775841461913e+25*cos(theta)**8 - 1.76206884275182e+25*cos(theta)**6 + 2.93678140458637e+24*cos(theta)**4 - 1.3659448393425e+23*cos(theta)**2 + 8.32893194721036e+20)*sin(16*phi)

@torch.jit.script
def Yl24_m_minus_15(theta, phi):
    return 1.1778692495173e-20*(1.0 - cos(theta)**2)**7.5*(3.2863982384657e+24*cos(theta)**9 - 2.51724120393118e+24*cos(theta)**7 + 5.87356280917274e+23*cos(theta)**5 - 4.553149464475e+22*cos(theta)**3 + 8.32893194721036e+20*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl24_m_minus_14(theta, phi):
    return 2.32610538861376e-19*(1.0 - cos(theta)**2)**7*(3.2863982384657e+23*cos(theta)**10 - 3.14655150491397e+23*cos(theta)**8 + 9.78927134862124e+22*cos(theta)**6 - 1.13828736611875e+22*cos(theta)**4 + 4.16446597360518e+20*cos(theta)**2 - 2.13562357620778e+18)*sin(14*phi)

@torch.jit.script
def Yl24_m_minus_13(theta, phi):
    return 4.75573370217054e-18*(1.0 - cos(theta)**2)**6.5*(2.98763476224155e+22*cos(theta)**11 - 3.4961683387933e+22*cos(theta)**9 + 1.39846733551732e+22*cos(theta)**7 - 2.2765747322375e+21*cos(theta)**5 + 1.38815532453506e+20*cos(theta)**3 - 2.13562357620778e+18*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl24_m_minus_12(theta, phi):
    return 1.00209527253683e-16*(1.0 - cos(theta)**2)**6*(2.48969563520129e+21*cos(theta)**12 - 3.4961683387933e+21*cos(theta)**10 + 1.74808416939665e+21*cos(theta)**8 - 3.79429122039583e+20*cos(theta)**6 + 3.47038831133765e+19*cos(theta)**4 - 1.06781178810389e+18*cos(theta)**2 + 4.80996300947699e+15)*sin(12*phi)

@torch.jit.script
def Yl24_m_minus_11(theta, phi):
    return 2.16786353281895e-15*(1.0 - cos(theta)**2)**5.5*(1.91515048861638e+20*cos(theta)**13 - 3.17833485344846e+20*cos(theta)**11 + 1.94231574377406e+20*cos(theta)**9 - 5.4204160291369e+19*cos(theta)**7 + 6.9407766226753e+18*cos(theta)**5 - 3.55937262701297e+17*cos(theta)**3 + 4.80996300947699e+15*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl24_m_minus_10(theta, phi):
    return 4.79877049408895e-14*(1.0 - cos(theta)**2)**5*(1.36796463472598e+19*cos(theta)**14 - 2.64861237787371e+19*cos(theta)**12 + 1.94231574377406e+19*cos(theta)**10 - 6.77552003642113e+18*cos(theta)**8 + 1.15679610377922e+18*cos(theta)**6 - 8.89843156753244e+16*cos(theta)**4 + 2.4049815047385e+15*cos(theta)**2 - 9816251039748.96)*sin(10*phi)

@torch.jit.script
def Yl24_m_minus_9(theta, phi):
    return 1.08371495837322e-12*(1.0 - cos(theta)**2)**4.5*(9.11976423150656e+17*cos(theta)**15 - 2.03739413682593e+18*cos(theta)**13 + 1.76574158524914e+18*cos(theta)**11 - 7.52835559602347e+17*cos(theta)**9 + 1.65256586254174e+17*cos(theta)**7 - 1.77968631350649e+16*cos(theta)**5 + 801660501579499.0*cos(theta)**3 - 9816251039748.96*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl24_m_minus_8(theta, phi):
    return 2.49018738774613e-11*(1.0 - cos(theta)**2)**4*(5.6998526446916e+16*cos(theta)**16 - 1.45528152630424e+17*cos(theta)**14 + 1.47145132104095e+17*cos(theta)**12 - 7.52835559602347e+16*cos(theta)**10 + 2.06570732817717e+16*cos(theta)**8 - 2.96614385584415e+15*cos(theta)**6 + 200415125394875.0*cos(theta)**4 - 4908125519874.48*cos(theta)**2 + 18591384544.9791)*sin(8*phi)

@torch.jit.script
def Yl24_m_minus_7(theta, phi):
    return 5.80806514683927e-10*(1.0 - cos(theta)**2)**3.5*(3.35285449687741e+15*cos(theta)**17 - 9.70187684202825e+15*cos(theta)**15 + 1.13188563156996e+16*cos(theta)**13 - 6.84395963274861e+15*cos(theta)**11 + 2.2952303646413e+15*cos(theta)**9 - 423734836549164.0*cos(theta)**7 + 40083025078974.9*cos(theta)**5 - 1636041839958.16*cos(theta)**3 + 18591384544.9791*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl24_m_minus_6(theta, phi):
    return 1.37198252096958e-8*(1.0 - cos(theta)**2)**3*(186269694270967.0*cos(theta)**18 - 606367302626766.0*cos(theta)**16 + 808489736835688.0*cos(theta)**14 - 570329969395718.0*cos(theta)**12 + 229523036464130.0*cos(theta)**10 - 52966854568645.4*cos(theta)**8 + 6680504179829.16*cos(theta)**6 - 409010459989.54*cos(theta)**4 + 9295692272.48955*cos(theta)**2 - 33317893.4497833)*sin(6*phi)

@torch.jit.script
def Yl24_m_minus_5(theta, phi):
    return 3.27556337379121e-7*(1.0 - cos(theta)**2)**2.5*(9803668119524.59*cos(theta)**19 - 35668664860398.0*cos(theta)**17 + 53899315789045.8*cos(theta)**15 - 43871536107362.9*cos(theta)**13 + 20865730587648.2*cos(theta)**11 - 5885206063182.83*cos(theta)**9 + 954357739975.594*cos(theta)**7 - 81802091997.908*cos(theta)**5 + 3098564090.82985*cos(theta)**3 - 33317893.4497833*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl24_m_minus_4(theta, phi):
    return 7.88860123286696e-6*(1.0 - cos(theta)**2)**2*(490183405976.23*cos(theta)**20 - 1981592492244.33*cos(theta)**18 + 3368707236815.36*cos(theta)**16 - 3133681150525.92*cos(theta)**14 + 1738810882304.02*cos(theta)**12 - 588520606318.283*cos(theta)**10 + 119294717496.949*cos(theta)**8 - 13633681999.6513*cos(theta)**6 + 774641022.707462*cos(theta)**4 - 16658946.7248917*cos(theta)**2 + 57444.6438789368)*sin(4*phi)

@torch.jit.script
def Yl24_m_minus_3(theta, phi):
    return 0.000191288413903665*(1.0 - cos(theta)**2)**1.5*(23342066951.249*cos(theta)**21 - 104294341697.07*cos(theta)**19 + 198159249224.433*cos(theta)**17 - 208912076701.728*cos(theta)**15 + 133754683254.155*cos(theta)**13 - 53501873301.6621*cos(theta)**11 + 13254968610.7721*cos(theta)**9 - 1947668857.09305*cos(theta)**7 + 154928204.541492*cos(theta)**5 - 5552982.24163055*cos(theta)**3 + 57444.6438789368*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl24_m_minus_2(theta, phi):
    return 0.00466210326274582*(1.0 - cos(theta)**2)*(1061003043.23859*cos(theta)**22 - 5214717084.85351*cos(theta)**20 + 11008847179.1352*cos(theta)**18 - 13057004793.858*cos(theta)**16 + 9553905946.72537*cos(theta)**14 - 4458489441.80517*cos(theta)**12 + 1325496861.07721*cos(theta)**10 - 243458607.136631*cos(theta)**8 + 25821367.4235821*cos(theta)**6 - 1388245.56040764*cos(theta)**4 + 28722.3219394684*cos(theta)**2 - 96.7081546783447)*sin(2*phi)

@torch.jit.script
def Yl24_m_minus_1(theta, phi):
    return 0.114007252777348*(1.0 - cos(theta)**2)**0.5*(46130567.0973301*cos(theta)**23 - 248319861.1835*cos(theta)**21 + 579413009.428167*cos(theta)**19 - 768059105.521059*cos(theta)**17 + 636927063.115025*cos(theta)**15 - 342960726.292706*cos(theta)**13 + 120499714.643383*cos(theta)**11 - 27050956.3485146*cos(theta)**9 + 3688766.77479744*cos(theta)**7 - 277649.112081528*cos(theta)**5 + 9574.10731315613*cos(theta)**3 - 96.7081546783447*cos(theta))*sin(phi)

@torch.jit.script
def Yl24_m0(theta, phi):
    return 3795514.54325524*cos(theta)**24 - 22288553.488052*cos(theta)**22 + 57207287.2860002*cos(theta)**20 - 84258795.2274422*cos(theta)**18 + 78607290.669504*cos(theta)**16 - 48373717.3350794*cos(theta)**14 + 19828866.1148298*cos(theta)**12 - 5341653.72889294*cos(theta)**10 + 910509.158334023*cos(theta)**8 - 91377.2632019808*cos(theta)**6 + 4726.4101656197*cos(theta)**4 - 95.4830336488828*cos(theta)**2 + 0.318276778829609

@torch.jit.script
def Yl24_m1(theta, phi):
    return 0.114007252777348*(1.0 - cos(theta)**2)**0.5*(46130567.0973301*cos(theta)**23 - 248319861.1835*cos(theta)**21 + 579413009.428167*cos(theta)**19 - 768059105.521059*cos(theta)**17 + 636927063.115025*cos(theta)**15 - 342960726.292706*cos(theta)**13 + 120499714.643383*cos(theta)**11 - 27050956.3485146*cos(theta)**9 + 3688766.77479744*cos(theta)**7 - 277649.112081528*cos(theta)**5 + 9574.10731315613*cos(theta)**3 - 96.7081546783447*cos(theta))*cos(phi)

@torch.jit.script
def Yl24_m2(theta, phi):
    return 0.00466210326274582*(1.0 - cos(theta)**2)*(1061003043.23859*cos(theta)**22 - 5214717084.85351*cos(theta)**20 + 11008847179.1352*cos(theta)**18 - 13057004793.858*cos(theta)**16 + 9553905946.72537*cos(theta)**14 - 4458489441.80517*cos(theta)**12 + 1325496861.07721*cos(theta)**10 - 243458607.136631*cos(theta)**8 + 25821367.4235821*cos(theta)**6 - 1388245.56040764*cos(theta)**4 + 28722.3219394684*cos(theta)**2 - 96.7081546783447)*cos(2*phi)

@torch.jit.script
def Yl24_m3(theta, phi):
    return 0.000191288413903665*(1.0 - cos(theta)**2)**1.5*(23342066951.249*cos(theta)**21 - 104294341697.07*cos(theta)**19 + 198159249224.433*cos(theta)**17 - 208912076701.728*cos(theta)**15 + 133754683254.155*cos(theta)**13 - 53501873301.6621*cos(theta)**11 + 13254968610.7721*cos(theta)**9 - 1947668857.09305*cos(theta)**7 + 154928204.541492*cos(theta)**5 - 5552982.24163055*cos(theta)**3 + 57444.6438789368*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl24_m4(theta, phi):
    return 7.88860123286696e-6*(1.0 - cos(theta)**2)**2*(490183405976.23*cos(theta)**20 - 1981592492244.33*cos(theta)**18 + 3368707236815.36*cos(theta)**16 - 3133681150525.92*cos(theta)**14 + 1738810882304.02*cos(theta)**12 - 588520606318.283*cos(theta)**10 + 119294717496.949*cos(theta)**8 - 13633681999.6513*cos(theta)**6 + 774641022.707462*cos(theta)**4 - 16658946.7248917*cos(theta)**2 + 57444.6438789368)*cos(4*phi)

@torch.jit.script
def Yl24_m5(theta, phi):
    return 3.27556337379121e-7*(1.0 - cos(theta)**2)**2.5*(9803668119524.59*cos(theta)**19 - 35668664860398.0*cos(theta)**17 + 53899315789045.8*cos(theta)**15 - 43871536107362.9*cos(theta)**13 + 20865730587648.2*cos(theta)**11 - 5885206063182.83*cos(theta)**9 + 954357739975.594*cos(theta)**7 - 81802091997.908*cos(theta)**5 + 3098564090.82985*cos(theta)**3 - 33317893.4497833*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl24_m6(theta, phi):
    return 1.37198252096958e-8*(1.0 - cos(theta)**2)**3*(186269694270967.0*cos(theta)**18 - 606367302626766.0*cos(theta)**16 + 808489736835688.0*cos(theta)**14 - 570329969395718.0*cos(theta)**12 + 229523036464130.0*cos(theta)**10 - 52966854568645.4*cos(theta)**8 + 6680504179829.16*cos(theta)**6 - 409010459989.54*cos(theta)**4 + 9295692272.48955*cos(theta)**2 - 33317893.4497833)*cos(6*phi)

@torch.jit.script
def Yl24_m7(theta, phi):
    return 5.80806514683927e-10*(1.0 - cos(theta)**2)**3.5*(3.35285449687741e+15*cos(theta)**17 - 9.70187684202825e+15*cos(theta)**15 + 1.13188563156996e+16*cos(theta)**13 - 6.84395963274861e+15*cos(theta)**11 + 2.2952303646413e+15*cos(theta)**9 - 423734836549164.0*cos(theta)**7 + 40083025078974.9*cos(theta)**5 - 1636041839958.16*cos(theta)**3 + 18591384544.9791*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl24_m8(theta, phi):
    return 2.49018738774613e-11*(1.0 - cos(theta)**2)**4*(5.6998526446916e+16*cos(theta)**16 - 1.45528152630424e+17*cos(theta)**14 + 1.47145132104095e+17*cos(theta)**12 - 7.52835559602347e+16*cos(theta)**10 + 2.06570732817717e+16*cos(theta)**8 - 2.96614385584415e+15*cos(theta)**6 + 200415125394875.0*cos(theta)**4 - 4908125519874.48*cos(theta)**2 + 18591384544.9791)*cos(8*phi)

@torch.jit.script
def Yl24_m9(theta, phi):
    return 1.08371495837322e-12*(1.0 - cos(theta)**2)**4.5*(9.11976423150656e+17*cos(theta)**15 - 2.03739413682593e+18*cos(theta)**13 + 1.76574158524914e+18*cos(theta)**11 - 7.52835559602347e+17*cos(theta)**9 + 1.65256586254174e+17*cos(theta)**7 - 1.77968631350649e+16*cos(theta)**5 + 801660501579499.0*cos(theta)**3 - 9816251039748.96*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl24_m10(theta, phi):
    return 4.79877049408895e-14*(1.0 - cos(theta)**2)**5*(1.36796463472598e+19*cos(theta)**14 - 2.64861237787371e+19*cos(theta)**12 + 1.94231574377406e+19*cos(theta)**10 - 6.77552003642113e+18*cos(theta)**8 + 1.15679610377922e+18*cos(theta)**6 - 8.89843156753244e+16*cos(theta)**4 + 2.4049815047385e+15*cos(theta)**2 - 9816251039748.96)*cos(10*phi)

@torch.jit.script
def Yl24_m11(theta, phi):
    return 2.16786353281895e-15*(1.0 - cos(theta)**2)**5.5*(1.91515048861638e+20*cos(theta)**13 - 3.17833485344846e+20*cos(theta)**11 + 1.94231574377406e+20*cos(theta)**9 - 5.4204160291369e+19*cos(theta)**7 + 6.9407766226753e+18*cos(theta)**5 - 3.55937262701297e+17*cos(theta)**3 + 4.80996300947699e+15*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl24_m12(theta, phi):
    return 1.00209527253683e-16*(1.0 - cos(theta)**2)**6*(2.48969563520129e+21*cos(theta)**12 - 3.4961683387933e+21*cos(theta)**10 + 1.74808416939665e+21*cos(theta)**8 - 3.79429122039583e+20*cos(theta)**6 + 3.47038831133765e+19*cos(theta)**4 - 1.06781178810389e+18*cos(theta)**2 + 4.80996300947699e+15)*cos(12*phi)

@torch.jit.script
def Yl24_m13(theta, phi):
    return 4.75573370217054e-18*(1.0 - cos(theta)**2)**6.5*(2.98763476224155e+22*cos(theta)**11 - 3.4961683387933e+22*cos(theta)**9 + 1.39846733551732e+22*cos(theta)**7 - 2.2765747322375e+21*cos(theta)**5 + 1.38815532453506e+20*cos(theta)**3 - 2.13562357620778e+18*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl24_m14(theta, phi):
    return 2.32610538861376e-19*(1.0 - cos(theta)**2)**7*(3.2863982384657e+23*cos(theta)**10 - 3.14655150491397e+23*cos(theta)**8 + 9.78927134862124e+22*cos(theta)**6 - 1.13828736611875e+22*cos(theta)**4 + 4.16446597360518e+20*cos(theta)**2 - 2.13562357620778e+18)*cos(14*phi)

@torch.jit.script
def Yl24_m15(theta, phi):
    return 1.1778692495173e-20*(1.0 - cos(theta)**2)**7.5*(3.2863982384657e+24*cos(theta)**9 - 2.51724120393118e+24*cos(theta)**7 + 5.87356280917274e+23*cos(theta)**5 - 4.553149464475e+22*cos(theta)**3 + 8.32893194721036e+20*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl24_m16(theta, phi):
    return 6.2079160239131e-22*(1.0 - cos(theta)**2)**8*(2.95775841461913e+25*cos(theta)**8 - 1.76206884275182e+25*cos(theta)**6 + 2.93678140458637e+24*cos(theta)**4 - 1.3659448393425e+23*cos(theta)**2 + 8.32893194721036e+20)*cos(16*phi)

@torch.jit.script
def Yl24_m17(theta, phi):
    return 3.42774820132609e-23*(1.0 - cos(theta)**2)**8.5*(2.36620673169531e+26*cos(theta)**7 - 1.05724130565109e+26*cos(theta)**5 + 1.17471256183455e+25*cos(theta)**3 - 2.731889678685e+23*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl24_m18(theta, phi):
    return 1.99910334761708e-24*(1.0 - cos(theta)**2)**9*(1.65634471218671e+27*cos(theta)**6 - 5.28620652825547e+26*cos(theta)**4 + 3.52413768550365e+25*cos(theta)**2 - 2.731889678685e+23)*cos(18*phi)

@torch.jit.script
def Yl24_m19(theta, phi):
    return 1.24458738133901e-25*(1.0 - cos(theta)**2)**9.5*(9.93806827312028e+27*cos(theta)**5 - 2.11448261130219e+27*cos(theta)**3 + 7.04827537100729e+25*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl24_m20(theta, phi):
    return 8.39100641322249e-27*(1.0 - cos(theta)**2)**10*(4.96903413656014e+28*cos(theta)**4 - 6.34344783390656e+27*cos(theta)**2 + 7.04827537100729e+25)*cos(20*phi)

@torch.jit.script
def Yl24_m21(theta, phi):
    return 6.25428691320073e-28*(1.0 - cos(theta)**2)**10.5*(1.98761365462406e+29*cos(theta)**3 - 1.26868956678131e+28*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl24_m22(theta, phi):
    return 5.3240025801011e-29*(1.0 - cos(theta)**2)**11*(5.96284096387217e+29*cos(theta)**2 - 1.26868956678131e+28)*cos(22*phi)

@torch.jit.script
def Yl24_m23(theta, phi):
    return 6.54873704743938*(1.0 - cos(theta)**2)**11.5*cos(23*phi)*cos(theta)

@torch.jit.script
def Yl24_m24(theta, phi):
    return 0.9452287742978*(1.0 - cos(theta)**2)**12*cos(24*phi)

@torch.jit.script
def Yl25_m_minus_25(theta, phi):
    return 0.954634267390256*(1.0 - cos(theta)**2)**12.5*sin(25*phi)

@torch.jit.script
def Yl25_m_minus_24(theta, phi):
    return 6.75028364024702*(1.0 - cos(theta)**2)**12*sin(24*phi)*cos(theta)

@torch.jit.script
def Yl25_m_minus_23(theta, phi):
    return 1.14355157834306e-30*(1.0 - cos(theta)**2)**11.5*(2.92179207229736e+31*cos(theta)**2 - 5.96284096387217e+29)*sin(23*phi)

@torch.jit.script
def Yl25_m_minus_22(theta, phi):
    return 1.37226189401167e-29*(1.0 - cos(theta)**2)**11*(9.73930690765788e+30*cos(theta)**3 - 5.96284096387217e+29*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl25_m_minus_21(theta, phi):
    return 1.88155071332724e-28*(1.0 - cos(theta)**2)**10.5*(2.43482672691447e+30*cos(theta)**4 - 2.98142048193609e+29*cos(theta)**2 + 3.17172391695328e+27)*sin(21*phi)

@torch.jit.script
def Yl25_m_minus_20(theta, phi):
    return 2.85351294016536e-27*(1.0 - cos(theta)**2)**10*(4.86965345382894e+29*cos(theta)**5 - 9.93806827312028e+28*cos(theta)**3 + 3.17172391695328e+27*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl25_m_minus_19(theta, phi):
    return 4.68880021638437e-26*(1.0 - cos(theta)**2)**9.5*(8.1160890897149e+28*cos(theta)**6 - 2.48451706828007e+28*cos(theta)**4 + 1.58586195847664e+27*cos(theta)**2 - 1.17471256183455e+25)*sin(19*phi)

@torch.jit.script
def Yl25_m_minus_18(theta, phi):
    return 8.22881098367386e-25*(1.0 - cos(theta)**2)**9*(1.1594412985307e+28*cos(theta)**7 - 4.96903413656014e+27*cos(theta)**5 + 5.28620652825547e+26*cos(theta)**3 - 1.17471256183455e+25*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl25_m_minus_17(theta, phi):
    return 1.52621707468272e-23*(1.0 - cos(theta)**2)**8.5*(1.44930162316337e+27*cos(theta)**8 - 8.28172356093357e+26*cos(theta)**6 + 1.32155163206387e+26*cos(theta)**4 - 5.87356280917274e+24*cos(theta)**2 + 3.41486209835625e+22)*sin(17*phi)

@torch.jit.script
def Yl25_m_minus_16(theta, phi):
    return 2.96730513315039e-22*(1.0 - cos(theta)**2)**8*(1.61033513684819e+26*cos(theta)**9 - 1.18310336584765e+26*cos(theta)**7 + 2.64310326412774e+25*cos(theta)**5 - 1.95785426972425e+24*cos(theta)**3 + 3.41486209835625e+22*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl25_m_minus_15(theta, phi):
    return 6.00833495972093e-21*(1.0 - cos(theta)**2)**7.5*(1.61033513684819e+25*cos(theta)**10 - 1.47887920730957e+25*cos(theta)**8 + 4.40517210687956e+24*cos(theta)**6 - 4.89463567431062e+23*cos(theta)**4 + 1.70743104917812e+22*cos(theta)**2 - 8.32893194721036e+19)*sin(15*phi)

@torch.jit.script
def Yl25_m_minus_14(theta, phi):
    return 1.26031897370507e-19*(1.0 - cos(theta)**2)**7*(1.46394103349836e+24*cos(theta)**11 - 1.64319911923285e+24*cos(theta)**9 + 6.29310300982794e+23*cos(theta)**7 - 9.78927134862124e+22*cos(theta)**5 + 5.69143683059375e+21*cos(theta)**3 - 8.32893194721036e+19*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl25_m_minus_13(theta, phi):
    return 2.72648680988027e-18*(1.0 - cos(theta)**2)**6.5*(1.21995086124863e+23*cos(theta)**12 - 1.64319911923285e+23*cos(theta)**10 + 7.86637876228493e+22*cos(theta)**8 - 1.63154522477021e+22*cos(theta)**6 + 1.42285920764844e+21*cos(theta)**4 - 4.16446597360518e+19*cos(theta)**2 + 1.77968631350649e+17)*sin(13*phi)

@torch.jit.script
def Yl25_m_minus_12(theta, phi):
    return 6.05991978517773e-17*(1.0 - cos(theta)**2)**6*(9.38423739422025e+21*cos(theta)**13 - 1.49381738112077e+22*cos(theta)**11 + 8.74042084698325e+21*cos(theta)**9 - 2.33077889252887e+21*cos(theta)**7 + 2.84571841529687e+20*cos(theta)**5 - 1.38815532453506e+19*cos(theta)**3 + 1.77968631350649e+17*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl25_m_minus_11(theta, phi):
    return 1.37921431263761e-15*(1.0 - cos(theta)**2)**5.5*(6.70302671015732e+20*cos(theta)**14 - 1.24484781760064e+21*cos(theta)**12 + 8.74042084698325e+20*cos(theta)**10 - 2.91347361566108e+20*cos(theta)**8 + 4.74286402549479e+19*cos(theta)**6 - 3.47038831133765e+18*cos(theta)**4 + 8.89843156753244e+16*cos(theta)**2 - 343568786391214.0)*sin(11*phi)

@torch.jit.script
def Yl25_m_minus_10(theta, phi):
    return 3.20500443821783e-14*(1.0 - cos(theta)**2)**5*(4.46868447343821e+19*cos(theta)**15 - 9.57575244308188e+19*cos(theta)**13 + 7.94583713362114e+19*cos(theta)**11 - 3.23719290629009e+19*cos(theta)**9 + 6.77552003642113e+18*cos(theta)**7 - 6.9407766226753e+17*cos(theta)**5 + 2.96614385584414e+16*cos(theta)**3 - 343568786391214.0*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl25_m_minus_9(theta, phi):
    return 7.58442478467402e-13*(1.0 - cos(theta)**2)**4.5*(2.79292779589888e+18*cos(theta)**16 - 6.83982317362992e+18*cos(theta)**14 + 6.62153094468428e+18*cos(theta)**12 - 3.23719290629009e+18*cos(theta)**10 + 8.46940004552641e+17*cos(theta)**8 - 1.15679610377922e+17*cos(theta)**6 + 7.41535963961036e+15*cos(theta)**4 - 171784393195607.0*cos(theta)**2 + 613515689984.31)*sin(9*phi)

@torch.jit.script
def Yl25_m_minus_8(theta, phi):
    return 1.82341938685839e-11*(1.0 - cos(theta)**2)**4*(1.64289870346993e+17*cos(theta)**17 - 4.55988211575328e+17*cos(theta)**15 + 5.09348534206483e+17*cos(theta)**13 - 2.9429026420819e+17*cos(theta)**11 + 9.41044449502934e+16*cos(theta)**9 - 1.65256586254174e+16*cos(theta)**7 + 1.48307192792207e+15*cos(theta)**5 - 57261464398535.6*cos(theta)**3 + 613515689984.31*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl25_m_minus_7(theta, phi):
    return 4.44405873797859e-10*(1.0 - cos(theta)**2)**3.5*(9.12721501927739e+15*cos(theta)**18 - 2.8499263223458e+16*cos(theta)**16 + 3.63820381576059e+16*cos(theta)**14 - 2.45241886840159e+16*cos(theta)**12 + 9.41044449502934e+15*cos(theta)**10 - 2.06570732817717e+15*cos(theta)**8 + 247178654653679.0*cos(theta)**6 - 14315366099633.9*cos(theta)**4 + 306757844992.155*cos(theta)**2 - 1032854696.94328)*sin(7*phi)

@torch.jit.script
def Yl25_m_minus_6(theta, phi):
    return 1.09580071657648e-8*(1.0 - cos(theta)**2)**3*(480379737856705.0*cos(theta)**19 - 1.67642724843871e+15*cos(theta)**17 + 2.42546921050706e+15*cos(theta)**15 - 1.8864760526166e+15*cos(theta)**13 + 855494954093576.0*cos(theta)**11 - 229523036464130.0*cos(theta)**9 + 35311236379097.0*cos(theta)**7 - 2863073219926.78*cos(theta)**5 + 102252614997.385*cos(theta)**3 - 1032854696.94328*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl25_m_minus_5(theta, phi):
    return 2.72852178015624e-7*(1.0 - cos(theta)**2)**2.5*(24018986892835.3*cos(theta)**20 - 93134847135483.6*cos(theta)**18 + 151591825656691.0*cos(theta)**16 - 134748289472615.0*cos(theta)**14 + 71291246174464.7*cos(theta)**12 - 22952303646413.0*cos(theta)**10 + 4413904547387.12*cos(theta)**8 - 477178869987.797*cos(theta)**6 + 25563153749.3463*cos(theta)**4 - 516427348.471642*cos(theta)**2 + 1665894.67248917)*sin(5*phi)

@torch.jit.script
def Yl25_m_minus_4(theta, phi):
    return 6.84853531495298e-6*(1.0 - cos(theta)**2)**2*(1143761280611.2*cos(theta)**21 - 4901834059762.3*cos(theta)**19 + 8917166215099.5*cos(theta)**17 - 8983219298174.31*cos(theta)**15 + 5483942013420.36*cos(theta)**13 - 2086573058764.82*cos(theta)**11 + 490433838598.569*cos(theta)**9 - 68168409998.2567*cos(theta)**7 + 5112630749.86925*cos(theta)**5 - 172142449.490547*cos(theta)**3 + 1665894.67248917*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl25_m_minus_3(theta, phi):
    return 0.000172984837897952*(1.0 - cos(theta)**2)**1.5*(51989149118.691*cos(theta)**22 - 245091702988.115*cos(theta)**20 + 495398123061.083*cos(theta)**18 - 561451206135.894*cos(theta)**16 + 391710143815.74*cos(theta)**14 - 173881088230.402*cos(theta)**12 + 49043383859.8569*cos(theta)**10 - 8521051249.78209*cos(theta)**8 + 852105124.978209*cos(theta)**6 - 43035612.3726368*cos(theta)**4 + 832947.336244583*cos(theta)**2 - 2611.12017631531)*sin(3*phi)

@torch.jit.script
def Yl25_m_minus_2(theta, phi):
    return 0.00438986305798052*(1.0 - cos(theta)**2)*(2260397787.76917*cos(theta)**23 - 11671033475.6245*cos(theta)**21 + 26073585424.2675*cos(theta)**19 - 33026541537.4055*cos(theta)**17 + 26114009587.716*cos(theta)**15 - 13375468325.4155*cos(theta)**13 + 4458489441.80517*cos(theta)**11 - 946783472.198009*cos(theta)**9 + 121729303.568316*cos(theta)**7 - 8607122.47452736*cos(theta)**5 + 277649.112081528*cos(theta)**3 - 2611.12017631531*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl25_m_minus_1(theta, phi):
    return 0.11174766972402*(1.0 - cos(theta)**2)**0.5*(94183241.1570489*cos(theta)**24 - 530501521.619296*cos(theta)**22 + 1303679271.21338*cos(theta)**20 - 1834807863.1892*cos(theta)**18 + 1632125599.23225*cos(theta)**16 - 955390594.672537*cos(theta)**14 + 371540786.817098*cos(theta)**12 - 94678347.2198009*cos(theta)**10 + 15216162.9460394*cos(theta)**8 - 1434520.41242123*cos(theta)**6 + 69412.2780203819*cos(theta)**4 - 1305.56008815765*cos(theta)**2 + 4.02950644493103)*sin(phi)

@torch.jit.script
def Yl25_m0(theta, phi):
    return 7589510.72884222*cos(theta)**25 - 46466392.2174014*cos(theta)**23 + 125063800.329814*cos(theta)**21 - 194543689.401933*cos(theta)**19 + 193412621.440294*cos(theta)**17 - 128312763.492098*cos(theta)**15 + 57576240.0285053*cos(theta)**13 - 17339562.6340672*cos(theta)**11 + 3405985.51740607*cos(theta)**9 - 412846.729382553*cos(theta)**7 + 27967.0365065601*cos(theta)**5 - 876.709608356115*cos(theta)**3 + 8.11768155885292*cos(theta)

@torch.jit.script
def Yl25_m1(theta, phi):
    return 0.11174766972402*(1.0 - cos(theta)**2)**0.5*(94183241.1570489*cos(theta)**24 - 530501521.619296*cos(theta)**22 + 1303679271.21338*cos(theta)**20 - 1834807863.1892*cos(theta)**18 + 1632125599.23225*cos(theta)**16 - 955390594.672537*cos(theta)**14 + 371540786.817098*cos(theta)**12 - 94678347.2198009*cos(theta)**10 + 15216162.9460394*cos(theta)**8 - 1434520.41242123*cos(theta)**6 + 69412.2780203819*cos(theta)**4 - 1305.56008815765*cos(theta)**2 + 4.02950644493103)*cos(phi)

@torch.jit.script
def Yl25_m2(theta, phi):
    return 0.00438986305798052*(1.0 - cos(theta)**2)*(2260397787.76917*cos(theta)**23 - 11671033475.6245*cos(theta)**21 + 26073585424.2675*cos(theta)**19 - 33026541537.4055*cos(theta)**17 + 26114009587.716*cos(theta)**15 - 13375468325.4155*cos(theta)**13 + 4458489441.80517*cos(theta)**11 - 946783472.198009*cos(theta)**9 + 121729303.568316*cos(theta)**7 - 8607122.47452736*cos(theta)**5 + 277649.112081528*cos(theta)**3 - 2611.12017631531*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl25_m3(theta, phi):
    return 0.000172984837897952*(1.0 - cos(theta)**2)**1.5*(51989149118.691*cos(theta)**22 - 245091702988.115*cos(theta)**20 + 495398123061.083*cos(theta)**18 - 561451206135.894*cos(theta)**16 + 391710143815.74*cos(theta)**14 - 173881088230.402*cos(theta)**12 + 49043383859.8569*cos(theta)**10 - 8521051249.78209*cos(theta)**8 + 852105124.978209*cos(theta)**6 - 43035612.3726368*cos(theta)**4 + 832947.336244583*cos(theta)**2 - 2611.12017631531)*cos(3*phi)

@torch.jit.script
def Yl25_m4(theta, phi):
    return 6.84853531495298e-6*(1.0 - cos(theta)**2)**2*(1143761280611.2*cos(theta)**21 - 4901834059762.3*cos(theta)**19 + 8917166215099.5*cos(theta)**17 - 8983219298174.31*cos(theta)**15 + 5483942013420.36*cos(theta)**13 - 2086573058764.82*cos(theta)**11 + 490433838598.569*cos(theta)**9 - 68168409998.2567*cos(theta)**7 + 5112630749.86925*cos(theta)**5 - 172142449.490547*cos(theta)**3 + 1665894.67248917*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl25_m5(theta, phi):
    return 2.72852178015624e-7*(1.0 - cos(theta)**2)**2.5*(24018986892835.3*cos(theta)**20 - 93134847135483.6*cos(theta)**18 + 151591825656691.0*cos(theta)**16 - 134748289472615.0*cos(theta)**14 + 71291246174464.7*cos(theta)**12 - 22952303646413.0*cos(theta)**10 + 4413904547387.12*cos(theta)**8 - 477178869987.797*cos(theta)**6 + 25563153749.3463*cos(theta)**4 - 516427348.471642*cos(theta)**2 + 1665894.67248917)*cos(5*phi)

@torch.jit.script
def Yl25_m6(theta, phi):
    return 1.09580071657648e-8*(1.0 - cos(theta)**2)**3*(480379737856705.0*cos(theta)**19 - 1.67642724843871e+15*cos(theta)**17 + 2.42546921050706e+15*cos(theta)**15 - 1.8864760526166e+15*cos(theta)**13 + 855494954093576.0*cos(theta)**11 - 229523036464130.0*cos(theta)**9 + 35311236379097.0*cos(theta)**7 - 2863073219926.78*cos(theta)**5 + 102252614997.385*cos(theta)**3 - 1032854696.94328*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl25_m7(theta, phi):
    return 4.44405873797859e-10*(1.0 - cos(theta)**2)**3.5*(9.12721501927739e+15*cos(theta)**18 - 2.8499263223458e+16*cos(theta)**16 + 3.63820381576059e+16*cos(theta)**14 - 2.45241886840159e+16*cos(theta)**12 + 9.41044449502934e+15*cos(theta)**10 - 2.06570732817717e+15*cos(theta)**8 + 247178654653679.0*cos(theta)**6 - 14315366099633.9*cos(theta)**4 + 306757844992.155*cos(theta)**2 - 1032854696.94328)*cos(7*phi)

@torch.jit.script
def Yl25_m8(theta, phi):
    return 1.82341938685839e-11*(1.0 - cos(theta)**2)**4*(1.64289870346993e+17*cos(theta)**17 - 4.55988211575328e+17*cos(theta)**15 + 5.09348534206483e+17*cos(theta)**13 - 2.9429026420819e+17*cos(theta)**11 + 9.41044449502934e+16*cos(theta)**9 - 1.65256586254174e+16*cos(theta)**7 + 1.48307192792207e+15*cos(theta)**5 - 57261464398535.6*cos(theta)**3 + 613515689984.31*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl25_m9(theta, phi):
    return 7.58442478467402e-13*(1.0 - cos(theta)**2)**4.5*(2.79292779589888e+18*cos(theta)**16 - 6.83982317362992e+18*cos(theta)**14 + 6.62153094468428e+18*cos(theta)**12 - 3.23719290629009e+18*cos(theta)**10 + 8.46940004552641e+17*cos(theta)**8 - 1.15679610377922e+17*cos(theta)**6 + 7.41535963961036e+15*cos(theta)**4 - 171784393195607.0*cos(theta)**2 + 613515689984.31)*cos(9*phi)

@torch.jit.script
def Yl25_m10(theta, phi):
    return 3.20500443821783e-14*(1.0 - cos(theta)**2)**5*(4.46868447343821e+19*cos(theta)**15 - 9.57575244308188e+19*cos(theta)**13 + 7.94583713362114e+19*cos(theta)**11 - 3.23719290629009e+19*cos(theta)**9 + 6.77552003642113e+18*cos(theta)**7 - 6.9407766226753e+17*cos(theta)**5 + 2.96614385584414e+16*cos(theta)**3 - 343568786391214.0*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl25_m11(theta, phi):
    return 1.37921431263761e-15*(1.0 - cos(theta)**2)**5.5*(6.70302671015732e+20*cos(theta)**14 - 1.24484781760064e+21*cos(theta)**12 + 8.74042084698325e+20*cos(theta)**10 - 2.91347361566108e+20*cos(theta)**8 + 4.74286402549479e+19*cos(theta)**6 - 3.47038831133765e+18*cos(theta)**4 + 8.89843156753244e+16*cos(theta)**2 - 343568786391214.0)*cos(11*phi)

@torch.jit.script
def Yl25_m12(theta, phi):
    return 6.05991978517773e-17*(1.0 - cos(theta)**2)**6*(9.38423739422025e+21*cos(theta)**13 - 1.49381738112077e+22*cos(theta)**11 + 8.74042084698325e+21*cos(theta)**9 - 2.33077889252887e+21*cos(theta)**7 + 2.84571841529687e+20*cos(theta)**5 - 1.38815532453506e+19*cos(theta)**3 + 1.77968631350649e+17*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl25_m13(theta, phi):
    return 2.72648680988027e-18*(1.0 - cos(theta)**2)**6.5*(1.21995086124863e+23*cos(theta)**12 - 1.64319911923285e+23*cos(theta)**10 + 7.86637876228493e+22*cos(theta)**8 - 1.63154522477021e+22*cos(theta)**6 + 1.42285920764844e+21*cos(theta)**4 - 4.16446597360518e+19*cos(theta)**2 + 1.77968631350649e+17)*cos(13*phi)

@torch.jit.script
def Yl25_m14(theta, phi):
    return 1.26031897370507e-19*(1.0 - cos(theta)**2)**7*(1.46394103349836e+24*cos(theta)**11 - 1.64319911923285e+24*cos(theta)**9 + 6.29310300982794e+23*cos(theta)**7 - 9.78927134862124e+22*cos(theta)**5 + 5.69143683059375e+21*cos(theta)**3 - 8.32893194721036e+19*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl25_m15(theta, phi):
    return 6.00833495972093e-21*(1.0 - cos(theta)**2)**7.5*(1.61033513684819e+25*cos(theta)**10 - 1.47887920730957e+25*cos(theta)**8 + 4.40517210687956e+24*cos(theta)**6 - 4.89463567431062e+23*cos(theta)**4 + 1.70743104917812e+22*cos(theta)**2 - 8.32893194721036e+19)*cos(15*phi)

@torch.jit.script
def Yl25_m16(theta, phi):
    return 2.96730513315039e-22*(1.0 - cos(theta)**2)**8*(1.61033513684819e+26*cos(theta)**9 - 1.18310336584765e+26*cos(theta)**7 + 2.64310326412774e+25*cos(theta)**5 - 1.95785426972425e+24*cos(theta)**3 + 3.41486209835625e+22*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl25_m17(theta, phi):
    return 1.52621707468272e-23*(1.0 - cos(theta)**2)**8.5*(1.44930162316337e+27*cos(theta)**8 - 8.28172356093357e+26*cos(theta)**6 + 1.32155163206387e+26*cos(theta)**4 - 5.87356280917274e+24*cos(theta)**2 + 3.41486209835625e+22)*cos(17*phi)

@torch.jit.script
def Yl25_m18(theta, phi):
    return 8.22881098367386e-25*(1.0 - cos(theta)**2)**9*(1.1594412985307e+28*cos(theta)**7 - 4.96903413656014e+27*cos(theta)**5 + 5.28620652825547e+26*cos(theta)**3 - 1.17471256183455e+25*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl25_m19(theta, phi):
    return 4.68880021638437e-26*(1.0 - cos(theta)**2)**9.5*(8.1160890897149e+28*cos(theta)**6 - 2.48451706828007e+28*cos(theta)**4 + 1.58586195847664e+27*cos(theta)**2 - 1.17471256183455e+25)*cos(19*phi)

@torch.jit.script
def Yl25_m20(theta, phi):
    return 2.85351294016536e-27*(1.0 - cos(theta)**2)**10*(4.86965345382894e+29*cos(theta)**5 - 9.93806827312028e+28*cos(theta)**3 + 3.17172391695328e+27*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl25_m21(theta, phi):
    return 1.88155071332724e-28*(1.0 - cos(theta)**2)**10.5*(2.43482672691447e+30*cos(theta)**4 - 2.98142048193609e+29*cos(theta)**2 + 3.17172391695328e+27)*cos(21*phi)

@torch.jit.script
def Yl25_m22(theta, phi):
    return 1.37226189401167e-29*(1.0 - cos(theta)**2)**11*(9.73930690765788e+30*cos(theta)**3 - 5.96284096387217e+29*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl25_m23(theta, phi):
    return 1.14355157834306e-30*(1.0 - cos(theta)**2)**11.5*(2.92179207229736e+31*cos(theta)**2 - 5.96284096387217e+29)*cos(23*phi)

@torch.jit.script
def Yl25_m24(theta, phi):
    return 6.75028364024702*(1.0 - cos(theta)**2)**12*cos(24*phi)*cos(theta)

@torch.jit.script
def Yl25_m25(theta, phi):
    return 0.954634267390256*(1.0 - cos(theta)**2)**12.5*cos(25*phi)

@torch.jit.script
def Yl26_m_minus_26(theta, phi):
    return 0.963769731686801*(1.0 - cos(theta)**2)**13*sin(26*phi)

@torch.jit.script
def Yl26_m_minus_25(theta, phi):
    return 6.94984237067387*(1.0 - cos(theta)**2)**12.5*sin(25*phi)*cos(theta)

@torch.jit.script
def Yl26_m_minus_24(theta, phi):
    return 2.35518790424645e-32*(1.0 - cos(theta)**2)**12*(1.49011395687166e+33*cos(theta)**2 - 2.92179207229736e+31)*sin(24*phi)

@torch.jit.script
def Yl26_m_minus_23(theta, phi):
    return 2.88450430688934e-31*(1.0 - cos(theta)**2)**11.5*(4.96704652290552e+32*cos(theta)**3 - 2.92179207229736e+31*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl26_m_minus_22(theta, phi):
    return 4.03830602964508e-30*(1.0 - cos(theta)**2)**11*(1.24176163072638e+32*cos(theta)**4 - 1.46089603614868e+31*cos(theta)**2 + 1.49071024096804e+29)*sin(22*phi)

@torch.jit.script
def Yl26_m_minus_21(theta, phi):
    return 6.25611679988175e-29*(1.0 - cos(theta)**2)**10.5*(2.48352326145276e+31*cos(theta)**5 - 4.86965345382894e+30*cos(theta)**3 + 1.49071024096804e+29*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl26_m_minus_20(theta, phi):
    return 1.0505806618571e-27*(1.0 - cos(theta)**2)**10*(4.1392054357546e+30*cos(theta)**6 - 1.21741336345723e+30*cos(theta)**4 + 7.45355120484021e+28*cos(theta)**2 - 5.28620652825547e+26)*sin(20*phi)

@torch.jit.script
def Yl26_m_minus_19(theta, phi):
    return 1.88519959716718e-26*(1.0 - cos(theta)**2)**9.5*(5.91315062250657e+29*cos(theta)**7 - 2.43482672691447e+29*cos(theta)**5 + 2.48451706828007e+28*cos(theta)**3 - 5.28620652825547e+26*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl26_m_minus_18(theta, phi):
    return 3.57691474264813e-25*(1.0 - cos(theta)**2)**9*(7.39143827813321e+28*cos(theta)**8 - 4.05804454485745e+28*cos(theta)**6 + 6.21129267070018e+27*cos(theta)**4 - 2.64310326412774e+26*cos(theta)**2 + 1.46839070229319e+24)*sin(18*phi)

@torch.jit.script
def Yl26_m_minus_17(theta, phi):
    return 7.11797046507269e-24*(1.0 - cos(theta)**2)**8.5*(8.21270919792579e+27*cos(theta)**9 - 5.7972064926535e+27*cos(theta)**7 + 1.24225853414004e+27*cos(theta)**5 - 8.81034421375912e+25*cos(theta)**3 + 1.46839070229319e+24*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl26_m_minus_16(theta, phi):
    return 1.47601377103699e-22*(1.0 - cos(theta)**2)**8*(8.21270919792579e+26*cos(theta)**10 - 7.24650811581687e+26*cos(theta)**8 + 2.07043089023339e+26*cos(theta)**6 - 2.20258605343978e+25*cos(theta)**4 + 7.34195351146593e+23*cos(theta)**2 - 3.41486209835625e+21)*sin(16*phi)

@torch.jit.script
def Yl26_m_minus_15(theta, phi):
    return 3.17257134412823e-21*(1.0 - cos(theta)**2)**7.5*(7.46609927084163e+25*cos(theta)**11 - 8.05167568424097e+25*cos(theta)**9 + 2.95775841461913e+25*cos(theta)**7 - 4.40517210687956e+24*cos(theta)**5 + 2.44731783715531e+23*cos(theta)**3 - 3.41486209835625e+21*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl26_m_minus_14(theta, phi):
    return 7.03710366224851e-20*(1.0 - cos(theta)**2)**7*(6.22174939236802e+24*cos(theta)**12 - 8.05167568424097e+24*cos(theta)**10 + 3.69719801827392e+24*cos(theta)**8 - 7.34195351146593e+23*cos(theta)**6 + 6.11829459288828e+22*cos(theta)**4 - 1.70743104917812e+21*cos(theta)**2 + 6.9407766226753e+18)*sin(14*phi)

@torch.jit.script
def Yl26_m_minus_13(theta, phi):
    return 1.60470653191418e-18*(1.0 - cos(theta)**2)**6.5*(4.78596107105233e+23*cos(theta)**13 - 7.31970516749179e+23*cos(theta)**11 + 4.10799779808213e+23*cos(theta)**9 - 1.04885050163799e+23*cos(theta)**7 + 1.22365891857766e+22*cos(theta)**5 - 5.69143683059374e+20*cos(theta)**3 + 6.9407766226753e+18*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl26_m_minus_12(theta, phi):
    return 3.74966044762475e-17*(1.0 - cos(theta)**2)**6*(3.41854362218023e+22*cos(theta)**14 - 6.09975430624316e+22*cos(theta)**12 + 4.10799779808213e+22*cos(theta)**10 - 1.31106312704749e+22*cos(theta)**8 + 2.03943153096276e+21*cos(theta)**6 - 1.42285920764844e+20*cos(theta)**4 + 3.47038831133765e+18*cos(theta)**2 - 1.27120450964749e+16)*sin(12*phi)

@torch.jit.script
def Yl26_m_minus_11(theta, phi):
    return 8.95219161955017e-16*(1.0 - cos(theta)**2)**5.5*(2.27902908145349e+21*cos(theta)**15 - 4.69211869711012e+21*cos(theta)**13 + 3.73454345280193e+21*cos(theta)**11 - 1.45673680783054e+21*cos(theta)**9 + 2.91347361566108e+20*cos(theta)**7 - 2.84571841529687e+19*cos(theta)**5 + 1.15679610377922e+18*cos(theta)**3 - 1.27120450964749e+16*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl26_m_minus_10(theta, phi):
    return 2.17816222989798e-14*(1.0 - cos(theta)**2)**5*(1.42439317590843e+20*cos(theta)**16 - 3.35151335507866e+20*cos(theta)**14 + 3.11211954400161e+20*cos(theta)**12 - 1.45673680783054e+20*cos(theta)**10 + 3.64184201957635e+19*cos(theta)**8 - 4.74286402549479e+18*cos(theta)**6 + 2.89199025944804e+17*cos(theta)**4 - 6.35602254823745e+15*cos(theta)**2 + 21473049149450.9)*sin(10*phi)

@torch.jit.script
def Yl26_m_minus_9(theta, phi):
    return 5.38847576616016e-13*(1.0 - cos(theta)**2)**4.5*(8.37878338769665e+18*cos(theta)**17 - 2.23434223671911e+19*cos(theta)**15 + 2.39393811077047e+19*cos(theta)**13 - 1.32430618893686e+19*cos(theta)**11 + 4.04649113286262e+18*cos(theta)**9 - 6.77552003642113e+17*cos(theta)**7 + 5.78398051889608e+16*cos(theta)**5 - 2.11867418274582e+15*cos(theta)**3 + 21473049149450.9*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl26_m_minus_8(theta, phi):
    return 1.35249668324814e-11*(1.0 - cos(theta)**2)**4*(4.65487965983147e+17*cos(theta)**18 - 1.39646389794944e+18*cos(theta)**16 + 1.70995579340748e+18*cos(theta)**14 - 1.10358849078071e+18*cos(theta)**12 + 4.04649113286262e+17*cos(theta)**10 - 8.46940004552641e+16*cos(theta)**8 + 9.63996753149347e+15*cos(theta)**6 - 529668545686454.0*cos(theta)**4 + 10736524574725.4*cos(theta)**2 - 34084204999.1283)*sin(8*phi)

@torch.jit.script
def Yl26_m_minus_7(theta, phi):
    return 3.43757725980871e-10*(1.0 - cos(theta)**2)**3.5*(2.4499366630692e+16*cos(theta)**19 - 8.21449351734965e+16*cos(theta)**17 + 1.13997052893832e+17*cos(theta)**15 - 8.48914223677472e+16*cos(theta)**13 + 3.67862830260238e+16*cos(theta)**11 - 9.41044449502934e+15*cos(theta)**9 + 1.37713821878478e+15*cos(theta)**7 - 105933709137291.0*cos(theta)**5 + 3578841524908.48*cos(theta)**3 - 34084204999.1283*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl26_m_minus_6(theta, phi):
    return 8.83129588187465e-9*(1.0 - cos(theta)**2)**3*(1.2249683315346e+15*cos(theta)**20 - 4.5636075096387e+15*cos(theta)**18 + 7.1248158058645e+15*cos(theta)**16 - 6.06367302626766e+15*cos(theta)**14 + 3.06552358550198e+15*cos(theta)**12 - 941044449502934.0*cos(theta)**10 + 172142277348098.0*cos(theta)**8 - 17655618189548.5*cos(theta)**6 + 894710381227.119*cos(theta)**4 - 17042102499.5642*cos(theta)**2 + 51642734.8471642)*sin(6*phi)

@torch.jit.script
def Yl26_m_minus_5(theta, phi):
    return 2.28933354565387e-7*(1.0 - cos(theta)**2)**2.5*(58331825311171.3*cos(theta)**21 - 240189868928353.0*cos(theta)**19 + 419106812109676.0*cos(theta)**17 - 404244868417844.0*cos(theta)**15 + 235809506577076.0*cos(theta)**13 - 85549495409357.6*cos(theta)**11 + 19126919705344.2*cos(theta)**9 - 2522231169935.5*cos(theta)**7 + 178942076245.424*cos(theta)**5 - 5680700833.18806*cos(theta)**3 + 51642734.8471642*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl26_m_minus_4(theta, phi):
    return 5.97862425042808e-6*(1.0 - cos(theta)**2)**2*(2651446605053.24*cos(theta)**22 - 12009493446417.6*cos(theta)**20 + 23283711783870.9*cos(theta)**18 - 25265304276115.2*cos(theta)**16 + 16843536184076.8*cos(theta)**14 - 7129124617446.47*cos(theta)**12 + 1912691970534.42*cos(theta)**10 - 315278896241.937*cos(theta)**8 + 29823679374.2373*cos(theta)**6 - 1420175208.29701*cos(theta)**4 + 25821367.4235821*cos(theta)**2 - 75722.4851131439)*sin(4*phi)

@torch.jit.script
def Yl26_m_minus_3(theta, phi):
    return 0.000157045611432433*(1.0 - cos(theta)**2)**1.5*(115280287176.228*cos(theta)**23 - 571880640305.601*cos(theta)**21 + 1225458514940.57*cos(theta)**19 - 1486194369183.25*cos(theta)**17 + 1122902412271.79*cos(theta)**15 - 548394201342.036*cos(theta)**13 + 173881088230.402*cos(theta)**11 - 35030988471.3264*cos(theta)**9 + 4260525624.89104*cos(theta)**7 - 284035041.659403*cos(theta)**5 + 8607122.47452736*cos(theta)**3 - 75722.4851131439*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl26_m_minus_2(theta, phi):
    return 0.00414314778312938*(1.0 - cos(theta)**2)*(4803345299.0095*cos(theta)**24 - 25994574559.3455*cos(theta)**22 + 61272925747.0287*cos(theta)**20 - 82566353843.5138*cos(theta)**18 + 70181400766.9868*cos(theta)**16 - 39171014381.574*cos(theta)**14 + 14490090685.8668*cos(theta)**12 - 3503098847.13264*cos(theta)**10 + 532565703.11138*cos(theta)**8 - 47339173.6099005*cos(theta)**6 + 2151780.61863184*cos(theta)**4 - 37861.242556572*cos(theta)**2 + 108.796674013138)*sin(2*phi)

@torch.jit.script
def Yl26_m_minus_1(theta, phi):
    return 0.109617386791489*(1.0 - cos(theta)**2)**0.5*(192133811.96038*cos(theta)**25 - 1130198893.88459*cos(theta)**23 + 2917758368.90613*cos(theta)**21 - 4345597570.71126*cos(theta)**19 + 4128317692.17569*cos(theta)**17 - 2611400958.7716*cos(theta)**15 + 1114622360.45129*cos(theta)**13 - 318463531.557512*cos(theta)**11 + 59173967.0123756*cos(theta)**9 - 6762739.08712864*cos(theta)**7 + 430356.123726368*cos(theta)**5 - 12620.414185524*cos(theta)**3 + 108.796674013138*cos(theta))*sin(phi)

@torch.jit.script
def Yl26_m0(theta, phi):
    return 15176214.4264154*cos(theta)**26 - 96711170.3644117*cos(theta)**24 + 272370234.903853*cos(theta)**22 - 446223576.331845*cos(theta)**20 + 471013775.016947*cos(theta)**18 - 335186546.872525*cos(theta)**16 + 163505632.620744*cos(theta)**14 - 54501877.540248*cos(theta)**12 + 12152445.667758*cos(theta)**10 - 1736063.66682257*cos(theta)**8 + 147302.3717304*cos(theta)**6 - 6479.57646907918*cos(theta)**4 + 111.716835673779*cos(theta)**2 - 0.318281583116179

@torch.jit.script
def Yl26_m1(theta, phi):
    return 0.109617386791489*(1.0 - cos(theta)**2)**0.5*(192133811.96038*cos(theta)**25 - 1130198893.88459*cos(theta)**23 + 2917758368.90613*cos(theta)**21 - 4345597570.71126*cos(theta)**19 + 4128317692.17569*cos(theta)**17 - 2611400958.7716*cos(theta)**15 + 1114622360.45129*cos(theta)**13 - 318463531.557512*cos(theta)**11 + 59173967.0123756*cos(theta)**9 - 6762739.08712864*cos(theta)**7 + 430356.123726368*cos(theta)**5 - 12620.414185524*cos(theta)**3 + 108.796674013138*cos(theta))*cos(phi)

@torch.jit.script
def Yl26_m2(theta, phi):
    return 0.00414314778312938*(1.0 - cos(theta)**2)*(4803345299.0095*cos(theta)**24 - 25994574559.3455*cos(theta)**22 + 61272925747.0287*cos(theta)**20 - 82566353843.5138*cos(theta)**18 + 70181400766.9868*cos(theta)**16 - 39171014381.574*cos(theta)**14 + 14490090685.8668*cos(theta)**12 - 3503098847.13264*cos(theta)**10 + 532565703.11138*cos(theta)**8 - 47339173.6099005*cos(theta)**6 + 2151780.61863184*cos(theta)**4 - 37861.242556572*cos(theta)**2 + 108.796674013138)*cos(2*phi)

@torch.jit.script
def Yl26_m3(theta, phi):
    return 0.000157045611432433*(1.0 - cos(theta)**2)**1.5*(115280287176.228*cos(theta)**23 - 571880640305.601*cos(theta)**21 + 1225458514940.57*cos(theta)**19 - 1486194369183.25*cos(theta)**17 + 1122902412271.79*cos(theta)**15 - 548394201342.036*cos(theta)**13 + 173881088230.402*cos(theta)**11 - 35030988471.3264*cos(theta)**9 + 4260525624.89104*cos(theta)**7 - 284035041.659403*cos(theta)**5 + 8607122.47452736*cos(theta)**3 - 75722.4851131439*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl26_m4(theta, phi):
    return 5.97862425042808e-6*(1.0 - cos(theta)**2)**2*(2651446605053.24*cos(theta)**22 - 12009493446417.6*cos(theta)**20 + 23283711783870.9*cos(theta)**18 - 25265304276115.2*cos(theta)**16 + 16843536184076.8*cos(theta)**14 - 7129124617446.47*cos(theta)**12 + 1912691970534.42*cos(theta)**10 - 315278896241.937*cos(theta)**8 + 29823679374.2373*cos(theta)**6 - 1420175208.29701*cos(theta)**4 + 25821367.4235821*cos(theta)**2 - 75722.4851131439)*cos(4*phi)

@torch.jit.script
def Yl26_m5(theta, phi):
    return 2.28933354565387e-7*(1.0 - cos(theta)**2)**2.5*(58331825311171.3*cos(theta)**21 - 240189868928353.0*cos(theta)**19 + 419106812109676.0*cos(theta)**17 - 404244868417844.0*cos(theta)**15 + 235809506577076.0*cos(theta)**13 - 85549495409357.6*cos(theta)**11 + 19126919705344.2*cos(theta)**9 - 2522231169935.5*cos(theta)**7 + 178942076245.424*cos(theta)**5 - 5680700833.18806*cos(theta)**3 + 51642734.8471642*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl26_m6(theta, phi):
    return 8.83129588187465e-9*(1.0 - cos(theta)**2)**3*(1.2249683315346e+15*cos(theta)**20 - 4.5636075096387e+15*cos(theta)**18 + 7.1248158058645e+15*cos(theta)**16 - 6.06367302626766e+15*cos(theta)**14 + 3.06552358550198e+15*cos(theta)**12 - 941044449502934.0*cos(theta)**10 + 172142277348098.0*cos(theta)**8 - 17655618189548.5*cos(theta)**6 + 894710381227.119*cos(theta)**4 - 17042102499.5642*cos(theta)**2 + 51642734.8471642)*cos(6*phi)

@torch.jit.script
def Yl26_m7(theta, phi):
    return 3.43757725980871e-10*(1.0 - cos(theta)**2)**3.5*(2.4499366630692e+16*cos(theta)**19 - 8.21449351734965e+16*cos(theta)**17 + 1.13997052893832e+17*cos(theta)**15 - 8.48914223677472e+16*cos(theta)**13 + 3.67862830260238e+16*cos(theta)**11 - 9.41044449502934e+15*cos(theta)**9 + 1.37713821878478e+15*cos(theta)**7 - 105933709137291.0*cos(theta)**5 + 3578841524908.48*cos(theta)**3 - 34084204999.1283*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl26_m8(theta, phi):
    return 1.35249668324814e-11*(1.0 - cos(theta)**2)**4*(4.65487965983147e+17*cos(theta)**18 - 1.39646389794944e+18*cos(theta)**16 + 1.70995579340748e+18*cos(theta)**14 - 1.10358849078071e+18*cos(theta)**12 + 4.04649113286262e+17*cos(theta)**10 - 8.46940004552641e+16*cos(theta)**8 + 9.63996753149347e+15*cos(theta)**6 - 529668545686454.0*cos(theta)**4 + 10736524574725.4*cos(theta)**2 - 34084204999.1283)*cos(8*phi)

@torch.jit.script
def Yl26_m9(theta, phi):
    return 5.38847576616016e-13*(1.0 - cos(theta)**2)**4.5*(8.37878338769665e+18*cos(theta)**17 - 2.23434223671911e+19*cos(theta)**15 + 2.39393811077047e+19*cos(theta)**13 - 1.32430618893686e+19*cos(theta)**11 + 4.04649113286262e+18*cos(theta)**9 - 6.77552003642113e+17*cos(theta)**7 + 5.78398051889608e+16*cos(theta)**5 - 2.11867418274582e+15*cos(theta)**3 + 21473049149450.9*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl26_m10(theta, phi):
    return 2.17816222989798e-14*(1.0 - cos(theta)**2)**5*(1.42439317590843e+20*cos(theta)**16 - 3.35151335507866e+20*cos(theta)**14 + 3.11211954400161e+20*cos(theta)**12 - 1.45673680783054e+20*cos(theta)**10 + 3.64184201957635e+19*cos(theta)**8 - 4.74286402549479e+18*cos(theta)**6 + 2.89199025944804e+17*cos(theta)**4 - 6.35602254823745e+15*cos(theta)**2 + 21473049149450.9)*cos(10*phi)

@torch.jit.script
def Yl26_m11(theta, phi):
    return 8.95219161955017e-16*(1.0 - cos(theta)**2)**5.5*(2.27902908145349e+21*cos(theta)**15 - 4.69211869711012e+21*cos(theta)**13 + 3.73454345280193e+21*cos(theta)**11 - 1.45673680783054e+21*cos(theta)**9 + 2.91347361566108e+20*cos(theta)**7 - 2.84571841529687e+19*cos(theta)**5 + 1.15679610377922e+18*cos(theta)**3 - 1.27120450964749e+16*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl26_m12(theta, phi):
    return 3.74966044762475e-17*(1.0 - cos(theta)**2)**6*(3.41854362218023e+22*cos(theta)**14 - 6.09975430624316e+22*cos(theta)**12 + 4.10799779808213e+22*cos(theta)**10 - 1.31106312704749e+22*cos(theta)**8 + 2.03943153096276e+21*cos(theta)**6 - 1.42285920764844e+20*cos(theta)**4 + 3.47038831133765e+18*cos(theta)**2 - 1.27120450964749e+16)*cos(12*phi)

@torch.jit.script
def Yl26_m13(theta, phi):
    return 1.60470653191418e-18*(1.0 - cos(theta)**2)**6.5*(4.78596107105233e+23*cos(theta)**13 - 7.31970516749179e+23*cos(theta)**11 + 4.10799779808213e+23*cos(theta)**9 - 1.04885050163799e+23*cos(theta)**7 + 1.22365891857766e+22*cos(theta)**5 - 5.69143683059374e+20*cos(theta)**3 + 6.9407766226753e+18*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl26_m14(theta, phi):
    return 7.03710366224851e-20*(1.0 - cos(theta)**2)**7*(6.22174939236802e+24*cos(theta)**12 - 8.05167568424097e+24*cos(theta)**10 + 3.69719801827392e+24*cos(theta)**8 - 7.34195351146593e+23*cos(theta)**6 + 6.11829459288828e+22*cos(theta)**4 - 1.70743104917812e+21*cos(theta)**2 + 6.9407766226753e+18)*cos(14*phi)

@torch.jit.script
def Yl26_m15(theta, phi):
    return 3.17257134412823e-21*(1.0 - cos(theta)**2)**7.5*(7.46609927084163e+25*cos(theta)**11 - 8.05167568424097e+25*cos(theta)**9 + 2.95775841461913e+25*cos(theta)**7 - 4.40517210687956e+24*cos(theta)**5 + 2.44731783715531e+23*cos(theta)**3 - 3.41486209835625e+21*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl26_m16(theta, phi):
    return 1.47601377103699e-22*(1.0 - cos(theta)**2)**8*(8.21270919792579e+26*cos(theta)**10 - 7.24650811581687e+26*cos(theta)**8 + 2.07043089023339e+26*cos(theta)**6 - 2.20258605343978e+25*cos(theta)**4 + 7.34195351146593e+23*cos(theta)**2 - 3.41486209835625e+21)*cos(16*phi)

@torch.jit.script
def Yl26_m17(theta, phi):
    return 7.11797046507269e-24*(1.0 - cos(theta)**2)**8.5*(8.21270919792579e+27*cos(theta)**9 - 5.7972064926535e+27*cos(theta)**7 + 1.24225853414004e+27*cos(theta)**5 - 8.81034421375912e+25*cos(theta)**3 + 1.46839070229319e+24*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl26_m18(theta, phi):
    return 3.57691474264813e-25*(1.0 - cos(theta)**2)**9*(7.39143827813321e+28*cos(theta)**8 - 4.05804454485745e+28*cos(theta)**6 + 6.21129267070018e+27*cos(theta)**4 - 2.64310326412774e+26*cos(theta)**2 + 1.46839070229319e+24)*cos(18*phi)

@torch.jit.script
def Yl26_m19(theta, phi):
    return 1.88519959716718e-26*(1.0 - cos(theta)**2)**9.5*(5.91315062250657e+29*cos(theta)**7 - 2.43482672691447e+29*cos(theta)**5 + 2.48451706828007e+28*cos(theta)**3 - 5.28620652825547e+26*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl26_m20(theta, phi):
    return 1.0505806618571e-27*(1.0 - cos(theta)**2)**10*(4.1392054357546e+30*cos(theta)**6 - 1.21741336345723e+30*cos(theta)**4 + 7.45355120484021e+28*cos(theta)**2 - 5.28620652825547e+26)*cos(20*phi)

@torch.jit.script
def Yl26_m21(theta, phi):
    return 6.25611679988175e-29*(1.0 - cos(theta)**2)**10.5*(2.48352326145276e+31*cos(theta)**5 - 4.86965345382894e+30*cos(theta)**3 + 1.49071024096804e+29*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl26_m22(theta, phi):
    return 4.03830602964508e-30*(1.0 - cos(theta)**2)**11*(1.24176163072638e+32*cos(theta)**4 - 1.46089603614868e+31*cos(theta)**2 + 1.49071024096804e+29)*cos(22*phi)

@torch.jit.script
def Yl26_m23(theta, phi):
    return 2.88450430688934e-31*(1.0 - cos(theta)**2)**11.5*(4.96704652290552e+32*cos(theta)**3 - 2.92179207229736e+31*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl26_m24(theta, phi):
    return 2.35518790424645e-32*(1.0 - cos(theta)**2)**12*(1.49011395687166e+33*cos(theta)**2 - 2.92179207229736e+31)*cos(24*phi)

@torch.jit.script
def Yl26_m25(theta, phi):
    return 6.94984237067387*(1.0 - cos(theta)**2)**12.5*cos(25*phi)*cos(theta)

@torch.jit.script
def Yl26_m26(theta, phi):
    return 0.963769731686801*(1.0 - cos(theta)**2)**13*cos(26*phi)

@torch.jit.script
def Yl27_m_minus_27(theta, phi):
    return 0.97265258980333*(1.0 - cos(theta)**2)**13.5*sin(27*phi)

@torch.jit.script
def Yl27_m_minus_26(theta, phi):
    return 7.14750762604425*(1.0 - cos(theta)**2)**13*sin(26*phi)*cos(theta)

@torch.jit.script
def Yl27_m_minus_25(theta, phi):
    return 4.65888737989014e-34*(1.0 - cos(theta)**2)**12.5*(7.89760397141977e+34*cos(theta)**2 - 1.49011395687166e+33)*sin(25*phi)

@torch.jit.script
def Yl27_m_minus_24(theta, phi):
    return 5.81894847243549e-33*(1.0 - cos(theta)**2)**12*(2.63253465713992e+34*cos(theta)**3 - 1.49011395687166e+33*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl27_m_minus_23(theta, phi):
    return 8.31112080905536e-32*(1.0 - cos(theta)**2)**11.5*(6.58133664284981e+33*cos(theta)**4 - 7.45056978435828e+32*cos(theta)**2 + 7.30448018074341e+30)*sin(23*phi)

@torch.jit.script
def Yl27_m_minus_22(theta, phi):
    return 1.31410358327182e-30*(1.0 - cos(theta)**2)**11*(1.31626732856996e+33*cos(theta)**5 - 2.48352326145276e+32*cos(theta)**3 + 7.30448018074341e+30*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl27_m_minus_21(theta, phi):
    return 2.25321827372525e-29*(1.0 - cos(theta)**2)**10.5*(2.19377888094994e+32*cos(theta)**6 - 6.2088081536319e+31*cos(theta)**4 + 3.6522400903717e+30*cos(theta)**2 - 2.48451706828007e+28)*sin(21*phi)

@torch.jit.script
def Yl27_m_minus_20(theta, phi):
    return 4.13021731864148e-28*(1.0 - cos(theta)**2)**10*(3.13396982992848e+31*cos(theta)**7 - 1.24176163072638e+31*cos(theta)**5 + 1.21741336345723e+30*cos(theta)**3 - 2.48451706828007e+28*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl27_m_minus_19(theta, phi):
    return 8.00878852093215e-27*(1.0 - cos(theta)**2)**9.5*(3.9174622874106e+30*cos(theta)**8 - 2.0696027178773e+30*cos(theta)**6 + 3.04353340864309e+29*cos(theta)**4 - 1.24225853414004e+28*cos(theta)**2 + 6.60775816031934e+25)*sin(19*phi)

@torch.jit.script
def Yl27_m_minus_18(theta, phi):
    return 1.62954739542083e-25*(1.0 - cos(theta)**2)**9*(4.35273587490067e+29*cos(theta)**9 - 2.95657531125328e+29*cos(theta)**7 + 6.08706681728617e+28*cos(theta)**5 - 4.14086178046679e+27*cos(theta)**3 + 6.60775816031934e+25*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl27_m_minus_17(theta, phi):
    return 3.45679204070083e-24*(1.0 - cos(theta)**2)**8.5*(4.35273587490067e+28*cos(theta)**10 - 3.69571913906661e+28*cos(theta)**8 + 1.01451113621436e+28*cos(theta)**6 - 1.0352154451167e+27*cos(theta)**4 + 3.30387908015967e+25*cos(theta)**2 - 1.46839070229319e+23)*sin(17*phi)

@torch.jit.script
def Yl27_m_minus_16(theta, phi):
    return 7.60494248954183e-23*(1.0 - cos(theta)**2)**8*(3.95703261354606e+27*cos(theta)**11 - 4.1063545989629e+27*cos(theta)**9 + 1.44930162316337e+27*cos(theta)**7 - 2.07043089023339e+26*cos(theta)**5 + 1.10129302671989e+25*cos(theta)**3 - 1.46839070229319e+23*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl27_m_minus_15(theta, phi):
    return 1.72751085492761e-21*(1.0 - cos(theta)**2)**7.5*(3.29752717795505e+26*cos(theta)**12 - 4.1063545989629e+26*cos(theta)**10 + 1.81162702895422e+26*cos(theta)**8 - 3.45071815038899e+25*cos(theta)**6 + 2.75323256679972e+24*cos(theta)**4 - 7.34195351146593e+22*cos(theta)**2 + 2.84571841529687e+20)*sin(15*phi)

@torch.jit.script
def Yl27_m_minus_14(theta, phi):
    return 4.03661292375851e-20*(1.0 - cos(theta)**2)**7*(2.53655936765773e+25*cos(theta)**13 - 3.73304963542081e+25*cos(theta)**11 + 2.01291892106024e+25*cos(theta)**9 - 4.92959735769855e+24*cos(theta)**7 + 5.50646513359945e+23*cos(theta)**5 - 2.44731783715531e+22*cos(theta)**3 + 2.84571841529687e+20*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl27_m_minus_13(theta, phi):
    return 9.67103717108456e-19*(1.0 - cos(theta)**2)**6.5*(1.81182811975552e+24*cos(theta)**14 - 3.11087469618401e+24*cos(theta)**12 + 2.01291892106024e+24*cos(theta)**10 - 6.16199669712319e+23*cos(theta)**8 + 9.17744188933241e+22*cos(theta)**6 - 6.11829459288828e+21*cos(theta)**4 + 1.42285920764844e+20*cos(theta)**2 - 4.95769758762521e+17)*sin(13*phi)

@torch.jit.script
def Yl27_m_minus_12(theta, phi):
    return 2.36891063526465e-17*(1.0 - cos(theta)**2)**6*(1.20788541317035e+23*cos(theta)**15 - 2.39298053552616e+23*cos(theta)**13 + 1.82992629187295e+23*cos(theta)**11 - 6.84666299680355e+22*cos(theta)**9 + 1.31106312704749e+22*cos(theta)**7 - 1.22365891857766e+21*cos(theta)**5 + 4.74286402549479e+19*cos(theta)**3 - 4.95769758762521e+17*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl27_m_minus_11(theta, phi):
    return 5.91753687024496e-16*(1.0 - cos(theta)**2)**5.5*(7.54928383231468e+21*cos(theta)**16 - 1.70927181109012e+22*cos(theta)**14 + 1.52493857656079e+22*cos(theta)**12 - 6.84666299680355e+21*cos(theta)**10 + 1.63882890880936e+21*cos(theta)**8 - 2.03943153096276e+20*cos(theta)**6 + 1.1857160063737e+19*cos(theta)**4 - 2.47884879381261e+17*cos(theta)**2 + 794502818529682.0)*sin(11*phi)

@torch.jit.script
def Yl27_m_minus_10(theta, phi):
    return 1.50403253709877e-14*(1.0 - cos(theta)**2)**5*(4.44075519547922e+20*cos(theta)**17 - 1.13951454072674e+21*cos(theta)**15 + 1.17302967427753e+21*cos(theta)**13 - 6.22423908800322e+20*cos(theta)**11 + 1.82092100978818e+20*cos(theta)**9 - 2.91347361566108e+19*cos(theta)**7 + 2.37143201274739e+18*cos(theta)**5 - 8.26282931270869e+16*cos(theta)**3 + 794502818529682.0*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl27_m_minus_9(theta, phi):
    return 3.8814531289017e-13*(1.0 - cos(theta)**2)**4.5*(2.46708621971068e+19*cos(theta)**18 - 7.12196587954215e+19*cos(theta)**16 + 8.37878338769665e+19*cos(theta)**14 - 5.18686590666935e+19*cos(theta)**12 + 1.82092100978818e+19*cos(theta)**10 - 3.64184201957635e+18*cos(theta)**8 + 3.95238668791232e+17*cos(theta)**6 - 2.06570732817717e+16*cos(theta)**4 + 397251409264841.0*cos(theta)**2 - 1192947174969.49)*sin(9*phi)

@torch.jit.script
def Yl27_m_minus_8(theta, phi):
    return 1.01513171657834e-11*(1.0 - cos(theta)**2)**4*(1.29846643142667e+18*cos(theta)**19 - 4.18939169384832e+18*cos(theta)**17 + 5.58585559179777e+18*cos(theta)**15 - 3.98989685128412e+18*cos(theta)**13 + 1.65538273617107e+18*cos(theta)**11 - 4.04649113286262e+17*cos(theta)**9 + 5.6462666970176e+16*cos(theta)**7 - 4.13141465635434e+15*cos(theta)**5 + 132417136421614.0*cos(theta)**3 - 1192947174969.49*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl27_m_minus_7(theta, phi):
    return 2.68578607004038e-10*(1.0 - cos(theta)**2)**3.5*(6.49233215713337e+16*cos(theta)**20 - 2.32743982991574e+17*cos(theta)**18 + 3.4911597448736e+17*cos(theta)**16 - 2.8499263223458e+17*cos(theta)**14 + 1.37948561347589e+17*cos(theta)**12 - 4.04649113286262e+16*cos(theta)**10 + 7.05783337127201e+15*cos(theta)**8 - 688569109392391.0*cos(theta)**6 + 33104284105403.4*cos(theta)**4 - 596473587484.746*cos(theta)**2 + 1704210249.95642)*sin(7*phi)

@torch.jit.script
def Yl27_m_minus_6(theta, phi):
    return 7.17662944926961e-9*(1.0 - cos(theta)**2)**3*(3.09158674149208e+15*cos(theta)**21 - 1.2249683315346e+16*cos(theta)**19 + 2.05362337933741e+16*cos(theta)**17 - 1.89995088156387e+16*cos(theta)**15 + 1.06114277959684e+16*cos(theta)**13 - 3.67862830260238e+15*cos(theta)**11 + 784203707919112.0*cos(theta)**9 - 98367015627484.4*cos(theta)**7 + 6620856821080.68*cos(theta)**5 - 198824529161.582*cos(theta)**3 + 1704210249.95642*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl27_m_minus_5(theta, phi):
    return 1.93369882461158e-7*(1.0 - cos(theta)**2)**2.5*(140526670067822.0*cos(theta)**22 - 612484165767299.0*cos(theta)**20 + 1.14090187740967e+15*cos(theta)**18 - 1.18746930097742e+15*cos(theta)**16 + 757959128283457.0*cos(theta)**14 - 306552358550198.0*cos(theta)**12 + 78420370791911.2*cos(theta)**10 - 12295876953435.5*cos(theta)**8 + 1103476136846.78*cos(theta)**6 - 49706132290.3955*cos(theta)**4 + 852105124.978209*cos(theta)**2 - 2347397.03850746)*sin(5*phi)

@torch.jit.script
def Yl27_m_minus_4(theta, phi):
    return 5.24599340659887e-6*(1.0 - cos(theta)**2)**2*(6109855220340.08*cos(theta)**23 - 29165912655585.7*cos(theta)**21 + 60047467232088.1*cos(theta)**19 - 69851135351612.7*cos(theta)**17 + 50530608552230.5*cos(theta)**15 - 23580950657707.6*cos(theta)**13 + 7129124617446.47*cos(theta)**11 - 1366208550381.73*cos(theta)**9 + 157639448120.969*cos(theta)**7 - 9941226458.0791*cos(theta)**5 + 284035041.659403*cos(theta)**3 - 2347397.03850746*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl27_m_minus_3(theta, phi):
    return 0.00014309162252077*(1.0 - cos(theta)**2)**1.5*(254577300847.503*cos(theta)**24 - 1325723302526.62*cos(theta)**22 + 3002373361604.41*cos(theta)**20 - 3880618630645.15*cos(theta)**18 + 3158163034514.4*cos(theta)**16 - 1684353618407.68*cos(theta)**14 + 594093718120.539*cos(theta)**12 - 136620855038.173*cos(theta)**10 + 19704931015.1211*cos(theta)**8 - 1656871076.34652*cos(theta)**6 + 71008760.4148507*cos(theta)**4 - 1173698.51925373*cos(theta)**2 + 3155.103546381)*sin(3*phi)

@torch.jit.script
def Yl27_m_minus_2(theta, phi):
    return 0.00391872547223201*(1.0 - cos(theta)**2)*(10183092033.9001*cos(theta)**25 - 57640143588.114*cos(theta)**23 + 142970160076.4*cos(theta)**21 - 204243085823.429*cos(theta)**19 + 185774296147.906*cos(theta)**17 - 112290241227.179*cos(theta)**15 + 45699516778.503*cos(theta)**13 - 12420077730.743*cos(theta)**11 + 2189436779.4579*cos(theta)**9 - 236695868.049502*cos(theta)**7 + 14201752.0829701*cos(theta)**5 - 391232.839751244*cos(theta)**3 + 3155.103546381*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl27_m_minus_1(theta, phi):
    return 0.107604519572121*(1.0 - cos(theta)**2)**0.5*(391657385.919236*cos(theta)**26 - 2401672649.50475*cos(theta)**24 + 6498643639.83638*cos(theta)**22 - 10212154291.1714*cos(theta)**20 + 10320794230.4392*cos(theta)**18 - 7018140076.69868*cos(theta)**16 + 3264251198.4645*cos(theta)**14 - 1035006477.56191*cos(theta)**12 + 218943677.94579*cos(theta)**10 - 29586983.5061878*cos(theta)**8 + 2366958.68049502*cos(theta)**6 - 97808.2099378109*cos(theta)**4 + 1577.5517731905*cos(theta)**2 - 4.18448746204376)*sin(phi)

@torch.jit.script
def Yl27_m0(theta, phi):
    return 30347223.9434462*cos(theta)**27 - 200978784.983955*cos(theta)**25 + 591114073.482221*cos(theta)**23 - 1017359595.85716*cos(theta)**21 + 1136412314.52129*cos(theta)**19 - 863673359.036181*cos(theta)**17 + 455269677.631475*cos(theta)**15 - 166562077.182247*cos(theta)**13 + 41640519.2955618*cos(theta)**11 - 6877563.24701471*cos(theta)**9 + 707406.505407227*cos(theta)**7 - 40924.3432880214*cos(theta)**5 + 1100.11675505434*cos(theta)**3 - 8.75424473518041*cos(theta)

@torch.jit.script
def Yl27_m1(theta, phi):
    return 0.107604519572121*(1.0 - cos(theta)**2)**0.5*(391657385.919236*cos(theta)**26 - 2401672649.50475*cos(theta)**24 + 6498643639.83638*cos(theta)**22 - 10212154291.1714*cos(theta)**20 + 10320794230.4392*cos(theta)**18 - 7018140076.69868*cos(theta)**16 + 3264251198.4645*cos(theta)**14 - 1035006477.56191*cos(theta)**12 + 218943677.94579*cos(theta)**10 - 29586983.5061878*cos(theta)**8 + 2366958.68049502*cos(theta)**6 - 97808.2099378109*cos(theta)**4 + 1577.5517731905*cos(theta)**2 - 4.18448746204376)*cos(phi)

@torch.jit.script
def Yl27_m2(theta, phi):
    return 0.00391872547223201*(1.0 - cos(theta)**2)*(10183092033.9001*cos(theta)**25 - 57640143588.114*cos(theta)**23 + 142970160076.4*cos(theta)**21 - 204243085823.429*cos(theta)**19 + 185774296147.906*cos(theta)**17 - 112290241227.179*cos(theta)**15 + 45699516778.503*cos(theta)**13 - 12420077730.743*cos(theta)**11 + 2189436779.4579*cos(theta)**9 - 236695868.049502*cos(theta)**7 + 14201752.0829701*cos(theta)**5 - 391232.839751244*cos(theta)**3 + 3155.103546381*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl27_m3(theta, phi):
    return 0.00014309162252077*(1.0 - cos(theta)**2)**1.5*(254577300847.503*cos(theta)**24 - 1325723302526.62*cos(theta)**22 + 3002373361604.41*cos(theta)**20 - 3880618630645.15*cos(theta)**18 + 3158163034514.4*cos(theta)**16 - 1684353618407.68*cos(theta)**14 + 594093718120.539*cos(theta)**12 - 136620855038.173*cos(theta)**10 + 19704931015.1211*cos(theta)**8 - 1656871076.34652*cos(theta)**6 + 71008760.4148507*cos(theta)**4 - 1173698.51925373*cos(theta)**2 + 3155.103546381)*cos(3*phi)

@torch.jit.script
def Yl27_m4(theta, phi):
    return 5.24599340659887e-6*(1.0 - cos(theta)**2)**2*(6109855220340.08*cos(theta)**23 - 29165912655585.7*cos(theta)**21 + 60047467232088.1*cos(theta)**19 - 69851135351612.7*cos(theta)**17 + 50530608552230.5*cos(theta)**15 - 23580950657707.6*cos(theta)**13 + 7129124617446.47*cos(theta)**11 - 1366208550381.73*cos(theta)**9 + 157639448120.969*cos(theta)**7 - 9941226458.0791*cos(theta)**5 + 284035041.659403*cos(theta)**3 - 2347397.03850746*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl27_m5(theta, phi):
    return 1.93369882461158e-7*(1.0 - cos(theta)**2)**2.5*(140526670067822.0*cos(theta)**22 - 612484165767299.0*cos(theta)**20 + 1.14090187740967e+15*cos(theta)**18 - 1.18746930097742e+15*cos(theta)**16 + 757959128283457.0*cos(theta)**14 - 306552358550198.0*cos(theta)**12 + 78420370791911.2*cos(theta)**10 - 12295876953435.5*cos(theta)**8 + 1103476136846.78*cos(theta)**6 - 49706132290.3955*cos(theta)**4 + 852105124.978209*cos(theta)**2 - 2347397.03850746)*cos(5*phi)

@torch.jit.script
def Yl27_m6(theta, phi):
    return 7.17662944926961e-9*(1.0 - cos(theta)**2)**3*(3.09158674149208e+15*cos(theta)**21 - 1.2249683315346e+16*cos(theta)**19 + 2.05362337933741e+16*cos(theta)**17 - 1.89995088156387e+16*cos(theta)**15 + 1.06114277959684e+16*cos(theta)**13 - 3.67862830260238e+15*cos(theta)**11 + 784203707919112.0*cos(theta)**9 - 98367015627484.4*cos(theta)**7 + 6620856821080.68*cos(theta)**5 - 198824529161.582*cos(theta)**3 + 1704210249.95642*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl27_m7(theta, phi):
    return 2.68578607004038e-10*(1.0 - cos(theta)**2)**3.5*(6.49233215713337e+16*cos(theta)**20 - 2.32743982991574e+17*cos(theta)**18 + 3.4911597448736e+17*cos(theta)**16 - 2.8499263223458e+17*cos(theta)**14 + 1.37948561347589e+17*cos(theta)**12 - 4.04649113286262e+16*cos(theta)**10 + 7.05783337127201e+15*cos(theta)**8 - 688569109392391.0*cos(theta)**6 + 33104284105403.4*cos(theta)**4 - 596473587484.746*cos(theta)**2 + 1704210249.95642)*cos(7*phi)

@torch.jit.script
def Yl27_m8(theta, phi):
    return 1.01513171657834e-11*(1.0 - cos(theta)**2)**4*(1.29846643142667e+18*cos(theta)**19 - 4.18939169384832e+18*cos(theta)**17 + 5.58585559179777e+18*cos(theta)**15 - 3.98989685128412e+18*cos(theta)**13 + 1.65538273617107e+18*cos(theta)**11 - 4.04649113286262e+17*cos(theta)**9 + 5.6462666970176e+16*cos(theta)**7 - 4.13141465635434e+15*cos(theta)**5 + 132417136421614.0*cos(theta)**3 - 1192947174969.49*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl27_m9(theta, phi):
    return 3.8814531289017e-13*(1.0 - cos(theta)**2)**4.5*(2.46708621971068e+19*cos(theta)**18 - 7.12196587954215e+19*cos(theta)**16 + 8.37878338769665e+19*cos(theta)**14 - 5.18686590666935e+19*cos(theta)**12 + 1.82092100978818e+19*cos(theta)**10 - 3.64184201957635e+18*cos(theta)**8 + 3.95238668791232e+17*cos(theta)**6 - 2.06570732817717e+16*cos(theta)**4 + 397251409264841.0*cos(theta)**2 - 1192947174969.49)*cos(9*phi)

@torch.jit.script
def Yl27_m10(theta, phi):
    return 1.50403253709877e-14*(1.0 - cos(theta)**2)**5*(4.44075519547922e+20*cos(theta)**17 - 1.13951454072674e+21*cos(theta)**15 + 1.17302967427753e+21*cos(theta)**13 - 6.22423908800322e+20*cos(theta)**11 + 1.82092100978818e+20*cos(theta)**9 - 2.91347361566108e+19*cos(theta)**7 + 2.37143201274739e+18*cos(theta)**5 - 8.26282931270869e+16*cos(theta)**3 + 794502818529682.0*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl27_m11(theta, phi):
    return 5.91753687024496e-16*(1.0 - cos(theta)**2)**5.5*(7.54928383231468e+21*cos(theta)**16 - 1.70927181109012e+22*cos(theta)**14 + 1.52493857656079e+22*cos(theta)**12 - 6.84666299680355e+21*cos(theta)**10 + 1.63882890880936e+21*cos(theta)**8 - 2.03943153096276e+20*cos(theta)**6 + 1.1857160063737e+19*cos(theta)**4 - 2.47884879381261e+17*cos(theta)**2 + 794502818529682.0)*cos(11*phi)

@torch.jit.script
def Yl27_m12(theta, phi):
    return 2.36891063526465e-17*(1.0 - cos(theta)**2)**6*(1.20788541317035e+23*cos(theta)**15 - 2.39298053552616e+23*cos(theta)**13 + 1.82992629187295e+23*cos(theta)**11 - 6.84666299680355e+22*cos(theta)**9 + 1.31106312704749e+22*cos(theta)**7 - 1.22365891857766e+21*cos(theta)**5 + 4.74286402549479e+19*cos(theta)**3 - 4.95769758762521e+17*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl27_m13(theta, phi):
    return 9.67103717108456e-19*(1.0 - cos(theta)**2)**6.5*(1.81182811975552e+24*cos(theta)**14 - 3.11087469618401e+24*cos(theta)**12 + 2.01291892106024e+24*cos(theta)**10 - 6.16199669712319e+23*cos(theta)**8 + 9.17744188933241e+22*cos(theta)**6 - 6.11829459288828e+21*cos(theta)**4 + 1.42285920764844e+20*cos(theta)**2 - 4.95769758762521e+17)*cos(13*phi)

@torch.jit.script
def Yl27_m14(theta, phi):
    return 4.03661292375851e-20*(1.0 - cos(theta)**2)**7*(2.53655936765773e+25*cos(theta)**13 - 3.73304963542081e+25*cos(theta)**11 + 2.01291892106024e+25*cos(theta)**9 - 4.92959735769855e+24*cos(theta)**7 + 5.50646513359945e+23*cos(theta)**5 - 2.44731783715531e+22*cos(theta)**3 + 2.84571841529687e+20*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl27_m15(theta, phi):
    return 1.72751085492761e-21*(1.0 - cos(theta)**2)**7.5*(3.29752717795505e+26*cos(theta)**12 - 4.1063545989629e+26*cos(theta)**10 + 1.81162702895422e+26*cos(theta)**8 - 3.45071815038899e+25*cos(theta)**6 + 2.75323256679972e+24*cos(theta)**4 - 7.34195351146593e+22*cos(theta)**2 + 2.84571841529687e+20)*cos(15*phi)

@torch.jit.script
def Yl27_m16(theta, phi):
    return 7.60494248954183e-23*(1.0 - cos(theta)**2)**8*(3.95703261354606e+27*cos(theta)**11 - 4.1063545989629e+27*cos(theta)**9 + 1.44930162316337e+27*cos(theta)**7 - 2.07043089023339e+26*cos(theta)**5 + 1.10129302671989e+25*cos(theta)**3 - 1.46839070229319e+23*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl27_m17(theta, phi):
    return 3.45679204070083e-24*(1.0 - cos(theta)**2)**8.5*(4.35273587490067e+28*cos(theta)**10 - 3.69571913906661e+28*cos(theta)**8 + 1.01451113621436e+28*cos(theta)**6 - 1.0352154451167e+27*cos(theta)**4 + 3.30387908015967e+25*cos(theta)**2 - 1.46839070229319e+23)*cos(17*phi)

@torch.jit.script
def Yl27_m18(theta, phi):
    return 1.62954739542083e-25*(1.0 - cos(theta)**2)**9*(4.35273587490067e+29*cos(theta)**9 - 2.95657531125328e+29*cos(theta)**7 + 6.08706681728617e+28*cos(theta)**5 - 4.14086178046679e+27*cos(theta)**3 + 6.60775816031934e+25*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl27_m19(theta, phi):
    return 8.00878852093215e-27*(1.0 - cos(theta)**2)**9.5*(3.9174622874106e+30*cos(theta)**8 - 2.0696027178773e+30*cos(theta)**6 + 3.04353340864309e+29*cos(theta)**4 - 1.24225853414004e+28*cos(theta)**2 + 6.60775816031934e+25)*cos(19*phi)

@torch.jit.script
def Yl27_m20(theta, phi):
    return 4.13021731864148e-28*(1.0 - cos(theta)**2)**10*(3.13396982992848e+31*cos(theta)**7 - 1.24176163072638e+31*cos(theta)**5 + 1.21741336345723e+30*cos(theta)**3 - 2.48451706828007e+28*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl27_m21(theta, phi):
    return 2.25321827372525e-29*(1.0 - cos(theta)**2)**10.5*(2.19377888094994e+32*cos(theta)**6 - 6.2088081536319e+31*cos(theta)**4 + 3.6522400903717e+30*cos(theta)**2 - 2.48451706828007e+28)*cos(21*phi)

@torch.jit.script
def Yl27_m22(theta, phi):
    return 1.31410358327182e-30*(1.0 - cos(theta)**2)**11*(1.31626732856996e+33*cos(theta)**5 - 2.48352326145276e+32*cos(theta)**3 + 7.30448018074341e+30*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl27_m23(theta, phi):
    return 8.31112080905536e-32*(1.0 - cos(theta)**2)**11.5*(6.58133664284981e+33*cos(theta)**4 - 7.45056978435828e+32*cos(theta)**2 + 7.30448018074341e+30)*cos(23*phi)

@torch.jit.script
def Yl27_m24(theta, phi):
    return 5.81894847243549e-33*(1.0 - cos(theta)**2)**12*(2.63253465713992e+34*cos(theta)**3 - 1.49011395687166e+33*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl27_m25(theta, phi):
    return 4.65888737989014e-34*(1.0 - cos(theta)**2)**12.5*(7.89760397141977e+34*cos(theta)**2 - 1.49011395687166e+33)*cos(25*phi)

@torch.jit.script
def Yl27_m26(theta, phi):
    return 7.14750762604425*(1.0 - cos(theta)**2)**13*cos(26*phi)*cos(theta)

@torch.jit.script
def Yl27_m27(theta, phi):
    return 0.97265258980333*(1.0 - cos(theta)**2)**13.5*cos(27*phi)

@torch.jit.script
def Yl28_m_minus_28(theta, phi):
    return 0.981298560633835*(1.0 - cos(theta)**2)**14*sin(28*phi)

@torch.jit.script
def Yl28_m_minus_27(theta, phi):
    return 7.34336601605245*(1.0 - cos(theta)**2)**13.5*sin(27*phi)*cos(theta)

@torch.jit.script
def Yl28_m_minus_26(theta, phi):
    return 8.86550503264189e-36*(1.0 - cos(theta)**2)**13*(4.34368218428088e+36*cos(theta)**2 - 7.89760397141977e+34)*sin(26*phi)

@torch.jit.script
def Yl28_m_minus_25(theta, phi):
    return 1.12839457090042e-34*(1.0 - cos(theta)**2)**12.5*(1.44789406142696e+36*cos(theta)**3 - 7.89760397141977e+34*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl28_m_minus_24(theta, phi):
    return 1.64296729492452e-33*(1.0 - cos(theta)**2)**12*(3.6197351535674e+35*cos(theta)**4 - 3.94880198570989e+34*cos(theta)**2 + 3.72528489217914e+32)*sin(24*phi)

@torch.jit.script
def Yl28_m_minus_23(theta, phi):
    return 2.64920516074126e-32*(1.0 - cos(theta)**2)**11.5*(7.23947030713479e+34*cos(theta)**5 - 1.31626732856996e+34*cos(theta)**3 + 3.72528489217914e+32*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl28_m_minus_22(theta, phi):
    return 4.63421635555746e-31*(1.0 - cos(theta)**2)**11*(1.20657838452247e+34*cos(theta)**6 - 3.29066832142491e+33*cos(theta)**4 + 1.86264244608957e+32*cos(theta)**2 - 1.21741336345723e+30)*sin(22*phi)

@torch.jit.script
def Yl28_m_minus_21(theta, phi):
    return 8.66982492934009e-30*(1.0 - cos(theta)**2)**10.5*(1.72368340646067e+33*cos(theta)**7 - 6.58133664284981e+32*cos(theta)**5 + 6.2088081536319e+31*cos(theta)**3 - 1.21741336345723e+30*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl28_m_minus_20(theta, phi):
    return 1.71653775978624e-28*(1.0 - cos(theta)**2)**10*(2.15460425807583e+32*cos(theta)**8 - 1.09688944047497e+32*cos(theta)**6 + 1.55220203840797e+31*cos(theta)**4 - 6.08706681728617e+29*cos(theta)**2 + 3.10564633535009e+27)*sin(20*phi)

@torch.jit.script
def Yl28_m_minus_19(theta, phi):
    return 3.56775673567227e-27*(1.0 - cos(theta)**2)**9.5*(2.39400473119537e+31*cos(theta)**9 - 1.56698491496424e+31*cos(theta)**7 + 3.10440407681595e+30*cos(theta)**5 - 2.02902227242872e+29*cos(theta)**3 + 3.10564633535009e+27*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl28_m_minus_18(theta, phi):
    return 7.73471228858538e-26*(1.0 - cos(theta)**2)**9*(2.39400473119537e+30*cos(theta)**10 - 1.9587311437053e+30*cos(theta)**8 + 5.17400679469325e+29*cos(theta)**6 - 5.07255568107181e+28*cos(theta)**4 + 1.55282316767504e+27*cos(theta)**2 - 6.60775816031934e+24)*sin(18*phi)

@torch.jit.script
def Yl28_m_minus_17(theta, phi):
    return 1.7398805056302e-24*(1.0 - cos(theta)**2)**8.5*(2.17636793745033e+29*cos(theta)**11 - 2.17636793745033e+29*cos(theta)**9 + 7.39143827813321e+28*cos(theta)**7 - 1.01451113621436e+28*cos(theta)**5 + 5.17607722558348e+26*cos(theta)**3 - 6.60775816031934e+24*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl28_m_minus_16(theta, phi):
    return 4.04311693361802e-23*(1.0 - cos(theta)**2)**8*(1.81363994787528e+28*cos(theta)**12 - 2.17636793745033e+28*cos(theta)**10 + 9.23929784766651e+27*cos(theta)**8 - 1.6908518936906e+27*cos(theta)**6 + 1.29401930639587e+26*cos(theta)**4 - 3.30387908015967e+24*cos(theta)**2 + 1.22365891857766e+22)*sin(16*phi)

@torch.jit.script
def Yl28_m_minus_15(theta, phi):
    return 9.66972930141058e-22*(1.0 - cos(theta)**2)**7.5*(1.39510765221175e+27*cos(theta)**13 - 1.97851630677303e+27*cos(theta)**11 + 1.02658864974072e+27*cos(theta)**9 - 2.41550270527229e+26*cos(theta)**7 + 2.58803861279174e+25*cos(theta)**5 - 1.10129302671989e+24*cos(theta)**3 + 1.22365891857766e+22*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl28_m_minus_14(theta, phi):
    return 2.3725346401488e-20*(1.0 - cos(theta)**2)**7*(9.96505465865538e+25*cos(theta)**14 - 1.64876358897753e+26*cos(theta)**12 + 1.02658864974072e+26*cos(theta)**10 - 3.01937838159036e+25*cos(theta)**8 + 4.31339768798623e+24*cos(theta)**6 - 2.75323256679972e+23*cos(theta)**4 + 6.11829459288828e+21*cos(theta)**2 - 2.03265601092634e+19)*sin(14*phi)

@torch.jit.script
def Yl28_m_minus_13(theta, phi):
    return 5.95501468493973e-19*(1.0 - cos(theta)**2)**6.5*(6.64336977243692e+24*cos(theta)**15 - 1.26827968382887e+25*cos(theta)**13 + 9.33262408855204e+24*cos(theta)**11 - 3.35486486843374e+24*cos(theta)**9 + 6.16199669712319e+23*cos(theta)**7 - 5.50646513359945e+22*cos(theta)**5 + 2.03943153096276e+21*cos(theta)**3 - 2.03265601092634e+19*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl28_m_minus_12(theta, phi):
    return 1.52522795453625e-17*(1.0 - cos(theta)**2)**6*(4.15210610777307e+23*cos(theta)**16 - 9.05914059877762e+23*cos(theta)**14 + 7.77718674046003e+23*cos(theta)**12 - 3.35486486843374e+23*cos(theta)**10 + 7.70249587140399e+22*cos(theta)**8 - 9.17744188933241e+21*cos(theta)**6 + 5.0985788274069e+20*cos(theta)**4 - 1.01632800546317e+19*cos(theta)**2 + 3.09856099226576e+16)*sin(12*phi)

@torch.jit.script
def Yl28_m_minus_11(theta, phi):
    return 3.977307899878e-16*(1.0 - cos(theta)**2)**5.5*(2.44241535751357e+22*cos(theta)**17 - 6.03942706585174e+22*cos(theta)**15 + 5.98245133881541e+22*cos(theta)**13 - 3.04987715312158e+22*cos(theta)**11 + 8.55832874600443e+21*cos(theta)**9 - 1.31106312704749e+21*cos(theta)**7 + 1.01971576548138e+20*cos(theta)**5 - 3.38776001821056e+18*cos(theta)**3 + 3.09856099226576e+16*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl28_m_minus_10(theta, phi):
    return 1.05379896790437e-14*(1.0 - cos(theta)**2)**5*(1.35689742084087e+21*cos(theta)**18 - 3.77464191615734e+21*cos(theta)**16 + 4.27317952772529e+21*cos(theta)**14 - 2.54156429426798e+21*cos(theta)**12 + 8.55832874600443e+20*cos(theta)**10 - 1.63882890880936e+20*cos(theta)**8 + 1.6995262758023e+19*cos(theta)**6 - 8.46940004552641e+17*cos(theta)**4 + 1.54928049613288e+16*cos(theta)**2 - 44139045473871.2)*sin(10*phi)

@torch.jit.script
def Yl28_m_minus_9(theta, phi):
    return 2.83156390560776e-13*(1.0 - cos(theta)**2)**4.5*(7.1415653728467e+19*cos(theta)**19 - 2.22037759773961e+20*cos(theta)**17 + 2.84878635181686e+20*cos(theta)**15 - 1.95504945712922e+20*cos(theta)**13 + 7.78029886000403e+19*cos(theta)**11 - 1.82092100978818e+19*cos(theta)**9 + 2.42789467971757e+18*cos(theta)**7 - 1.69388000910528e+17*cos(theta)**5 + 5.16426832044293e+15*cos(theta)**3 - 44139045473871.2*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl28_m_minus_8(theta, phi):
    return 7.70268659114473e-12*(1.0 - cos(theta)**2)**4*(3.57078268642335e+18*cos(theta)**20 - 1.23354310985534e+19*cos(theta)**18 + 1.78049146988554e+19*cos(theta)**16 - 1.39646389794944e+19*cos(theta)**14 + 6.48358238333669e+18*cos(theta)**12 - 1.82092100978818e+18*cos(theta)**10 + 3.03486834964696e+17*cos(theta)**8 - 2.8231333485088e+16*cos(theta)**6 + 1.29106708011073e+15*cos(theta)**4 - 22069522736935.6*cos(theta)**2 + 59647358748.4746)*sin(8*phi)

@torch.jit.script
def Yl28_m_minus_7(theta, phi):
    return 2.11788866150653e-10*(1.0 - cos(theta)**2)**3.5*(1.70037270782064e+17*cos(theta)**21 - 6.49233215713337e+17*cos(theta)**19 + 1.04734792346208e+18*cos(theta)**17 - 9.30975931966294e+17*cos(theta)**15 + 4.98737106410515e+17*cos(theta)**13 - 1.65538273617107e+17*cos(theta)**11 + 3.37207594405218e+16*cos(theta)**9 - 4.03304764072686e+15*cos(theta)**7 + 258213416022147.0*cos(theta)**5 - 7356507578978.53*cos(theta)**3 + 59647358748.4746*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl28_m_minus_6(theta, phi):
    return 5.8769025298657e-9*(1.0 - cos(theta)**2)**3*(7.7289668537302e+15*cos(theta)**22 - 3.24616607856668e+16*cos(theta)**20 + 5.81859957478934e+16*cos(theta)**18 - 5.81859957478934e+16*cos(theta)**16 + 3.56240790293225e+16*cos(theta)**14 - 1.37948561347589e+16*cos(theta)**12 + 3.37207594405218e+15*cos(theta)**10 - 504130955090858.0*cos(theta)**8 + 43035569337024.4*cos(theta)**6 - 1839126894744.63*cos(theta)**4 + 29823679374.2373*cos(theta)**2 - 77464102.2707462)*sin(6*phi)

@torch.jit.script
def Yl28_m_minus_5(theta, phi):
    return 1.64343247431143e-7*(1.0 - cos(theta)**2)**2.5*(336042037118704.0*cos(theta)**23 - 1.54579337074604e+15*cos(theta)**21 + 3.06242082883649e+15*cos(theta)**19 - 3.42270563222902e+15*cos(theta)**17 + 2.37493860195483e+15*cos(theta)**15 - 1.06114277959684e+15*cos(theta)**13 + 306552358550198.0*cos(theta)**11 - 56014550565650.8*cos(theta)**9 + 6147938476717.77*cos(theta)**7 - 367825378948.927*cos(theta)**5 + 9941226458.0791*cos(theta)**3 - 77464102.2707462*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl28_m_minus_4(theta, phi):
    return 4.62502894662956e-6*(1.0 - cos(theta)**2)**2*(14001751546612.7*cos(theta)**24 - 70263335033910.9*cos(theta)**22 + 153121041441825.0*cos(theta)**20 - 190150312901612.0*cos(theta)**18 + 148433662622177.0*cos(theta)**16 - 75795912828345.7*cos(theta)**14 + 25546029879183.2*cos(theta)**12 - 5601455056565.08*cos(theta)**10 + 768492309589.722*cos(theta)**8 - 61304229824.8211*cos(theta)**6 + 2485306614.51977*cos(theta)**4 - 38732051.1353731*cos(theta)**2 + 97808.2099378109)*sin(4*phi)

@torch.jit.script
def Yl28_m_minus_3(theta, phi):
    return 0.000130815573253833*(1.0 - cos(theta)**2)**1.5*(560070061864.507*cos(theta)**25 - 3054927610170.04*cos(theta)**23 + 7291478163896.42*cos(theta)**21 - 10007911205348.0*cos(theta)**19 + 8731391918951.59*cos(theta)**17 - 5053060855223.05*cos(theta)**15 + 1965079221475.63*cos(theta)**13 - 509223186960.462*cos(theta)**11 + 85388034398.858*cos(theta)**9 - 8757747117.83159*cos(theta)**7 + 497061322.903955*cos(theta)**5 - 12910683.711791*cos(theta)**3 + 97808.2099378109*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl28_m_minus_2(theta, phi):
    return 0.00371387232545999*(1.0 - cos(theta)**2)*(21541156225.558*cos(theta)**26 - 127288650423.752*cos(theta)**24 + 331430825631.655*cos(theta)**22 - 500395560267.401*cos(theta)**20 + 485077328830.644*cos(theta)**18 - 315816303451.44*cos(theta)**16 + 140362801533.974*cos(theta)**14 - 42435265580.0385*cos(theta)**12 + 8538803439.8858*cos(theta)**10 - 1094718389.72895*cos(theta)**8 + 82843553.8173258*cos(theta)**6 - 3227670.92794776*cos(theta)**4 + 48904.1049689054*cos(theta)**2 - 121.350136399269)*sin(2*phi)

@torch.jit.script
def Yl28_m_minus_1(theta, phi):
    return 0.105698659387677*(1.0 - cos(theta)**2)**0.5*(797820600.946591*cos(theta)**27 - 5091546016.95007*cos(theta)**25 + 14410035897.0285*cos(theta)**23 - 23828360012.7334*cos(theta)**21 + 25530385727.9286*cos(theta)**19 - 18577429614.7906*cos(theta)**17 + 9357520102.2649*cos(theta)**15 - 3264251198.4645*cos(theta)**13 + 776254858.171436*cos(theta)**11 - 121635376.63655*cos(theta)**9 + 11834793.4024751*cos(theta)**7 - 645534.185589552*cos(theta)**5 + 16301.3683229685*cos(theta)**3 - 121.350136399269*cos(theta))*sin(phi)

@torch.jit.script
def Yl28_m0(theta, phi):
    return 60684770.0668697*cos(theta)**28 - 417069874.277759*cos(theta)**26 + 1278751973.02143*cos(theta)**24 - 2306768265.05827*cos(theta)**22 + 2718691169.53296*cos(theta)**20 - 2198090732.81388*cos(theta)**18 + 1245584748.59453*cos(theta)**16 - 496578637.313435*cos(theta)**14 + 137770292.669276*cos(theta)**12 - 25905525.1172998*cos(theta)**10 + 3150671.97372565*cos(theta)**8 - 229139.77990732*cos(theta)**6 + 8679.53711770151*cos(theta)**4 - 129.223877682901*cos(theta)**2 + 0.318285413012071

@torch.jit.script
def Yl28_m1(theta, phi):
    return 0.105698659387677*(1.0 - cos(theta)**2)**0.5*(797820600.946591*cos(theta)**27 - 5091546016.95007*cos(theta)**25 + 14410035897.0285*cos(theta)**23 - 23828360012.7334*cos(theta)**21 + 25530385727.9286*cos(theta)**19 - 18577429614.7906*cos(theta)**17 + 9357520102.2649*cos(theta)**15 - 3264251198.4645*cos(theta)**13 + 776254858.171436*cos(theta)**11 - 121635376.63655*cos(theta)**9 + 11834793.4024751*cos(theta)**7 - 645534.185589552*cos(theta)**5 + 16301.3683229685*cos(theta)**3 - 121.350136399269*cos(theta))*cos(phi)

@torch.jit.script
def Yl28_m2(theta, phi):
    return 0.00371387232545999*(1.0 - cos(theta)**2)*(21541156225.558*cos(theta)**26 - 127288650423.752*cos(theta)**24 + 331430825631.655*cos(theta)**22 - 500395560267.401*cos(theta)**20 + 485077328830.644*cos(theta)**18 - 315816303451.44*cos(theta)**16 + 140362801533.974*cos(theta)**14 - 42435265580.0385*cos(theta)**12 + 8538803439.8858*cos(theta)**10 - 1094718389.72895*cos(theta)**8 + 82843553.8173258*cos(theta)**6 - 3227670.92794776*cos(theta)**4 + 48904.1049689054*cos(theta)**2 - 121.350136399269)*cos(2*phi)

@torch.jit.script
def Yl28_m3(theta, phi):
    return 0.000130815573253833*(1.0 - cos(theta)**2)**1.5*(560070061864.507*cos(theta)**25 - 3054927610170.04*cos(theta)**23 + 7291478163896.42*cos(theta)**21 - 10007911205348.0*cos(theta)**19 + 8731391918951.59*cos(theta)**17 - 5053060855223.05*cos(theta)**15 + 1965079221475.63*cos(theta)**13 - 509223186960.462*cos(theta)**11 + 85388034398.858*cos(theta)**9 - 8757747117.83159*cos(theta)**7 + 497061322.903955*cos(theta)**5 - 12910683.711791*cos(theta)**3 + 97808.2099378109*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl28_m4(theta, phi):
    return 4.62502894662956e-6*(1.0 - cos(theta)**2)**2*(14001751546612.7*cos(theta)**24 - 70263335033910.9*cos(theta)**22 + 153121041441825.0*cos(theta)**20 - 190150312901612.0*cos(theta)**18 + 148433662622177.0*cos(theta)**16 - 75795912828345.7*cos(theta)**14 + 25546029879183.2*cos(theta)**12 - 5601455056565.08*cos(theta)**10 + 768492309589.722*cos(theta)**8 - 61304229824.8211*cos(theta)**6 + 2485306614.51977*cos(theta)**4 - 38732051.1353731*cos(theta)**2 + 97808.2099378109)*cos(4*phi)

@torch.jit.script
def Yl28_m5(theta, phi):
    return 1.64343247431143e-7*(1.0 - cos(theta)**2)**2.5*(336042037118704.0*cos(theta)**23 - 1.54579337074604e+15*cos(theta)**21 + 3.06242082883649e+15*cos(theta)**19 - 3.42270563222902e+15*cos(theta)**17 + 2.37493860195483e+15*cos(theta)**15 - 1.06114277959684e+15*cos(theta)**13 + 306552358550198.0*cos(theta)**11 - 56014550565650.8*cos(theta)**9 + 6147938476717.77*cos(theta)**7 - 367825378948.927*cos(theta)**5 + 9941226458.0791*cos(theta)**3 - 77464102.2707462*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl28_m6(theta, phi):
    return 5.8769025298657e-9*(1.0 - cos(theta)**2)**3*(7.7289668537302e+15*cos(theta)**22 - 3.24616607856668e+16*cos(theta)**20 + 5.81859957478934e+16*cos(theta)**18 - 5.81859957478934e+16*cos(theta)**16 + 3.56240790293225e+16*cos(theta)**14 - 1.37948561347589e+16*cos(theta)**12 + 3.37207594405218e+15*cos(theta)**10 - 504130955090858.0*cos(theta)**8 + 43035569337024.4*cos(theta)**6 - 1839126894744.63*cos(theta)**4 + 29823679374.2373*cos(theta)**2 - 77464102.2707462)*cos(6*phi)

@torch.jit.script
def Yl28_m7(theta, phi):
    return 2.11788866150653e-10*(1.0 - cos(theta)**2)**3.5*(1.70037270782064e+17*cos(theta)**21 - 6.49233215713337e+17*cos(theta)**19 + 1.04734792346208e+18*cos(theta)**17 - 9.30975931966294e+17*cos(theta)**15 + 4.98737106410515e+17*cos(theta)**13 - 1.65538273617107e+17*cos(theta)**11 + 3.37207594405218e+16*cos(theta)**9 - 4.03304764072686e+15*cos(theta)**7 + 258213416022147.0*cos(theta)**5 - 7356507578978.53*cos(theta)**3 + 59647358748.4746*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl28_m8(theta, phi):
    return 7.70268659114473e-12*(1.0 - cos(theta)**2)**4*(3.57078268642335e+18*cos(theta)**20 - 1.23354310985534e+19*cos(theta)**18 + 1.78049146988554e+19*cos(theta)**16 - 1.39646389794944e+19*cos(theta)**14 + 6.48358238333669e+18*cos(theta)**12 - 1.82092100978818e+18*cos(theta)**10 + 3.03486834964696e+17*cos(theta)**8 - 2.8231333485088e+16*cos(theta)**6 + 1.29106708011073e+15*cos(theta)**4 - 22069522736935.6*cos(theta)**2 + 59647358748.4746)*cos(8*phi)

@torch.jit.script
def Yl28_m9(theta, phi):
    return 2.83156390560776e-13*(1.0 - cos(theta)**2)**4.5*(7.1415653728467e+19*cos(theta)**19 - 2.22037759773961e+20*cos(theta)**17 + 2.84878635181686e+20*cos(theta)**15 - 1.95504945712922e+20*cos(theta)**13 + 7.78029886000403e+19*cos(theta)**11 - 1.82092100978818e+19*cos(theta)**9 + 2.42789467971757e+18*cos(theta)**7 - 1.69388000910528e+17*cos(theta)**5 + 5.16426832044293e+15*cos(theta)**3 - 44139045473871.2*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl28_m10(theta, phi):
    return 1.05379896790437e-14*(1.0 - cos(theta)**2)**5*(1.35689742084087e+21*cos(theta)**18 - 3.77464191615734e+21*cos(theta)**16 + 4.27317952772529e+21*cos(theta)**14 - 2.54156429426798e+21*cos(theta)**12 + 8.55832874600443e+20*cos(theta)**10 - 1.63882890880936e+20*cos(theta)**8 + 1.6995262758023e+19*cos(theta)**6 - 8.46940004552641e+17*cos(theta)**4 + 1.54928049613288e+16*cos(theta)**2 - 44139045473871.2)*cos(10*phi)

@torch.jit.script
def Yl28_m11(theta, phi):
    return 3.977307899878e-16*(1.0 - cos(theta)**2)**5.5*(2.44241535751357e+22*cos(theta)**17 - 6.03942706585174e+22*cos(theta)**15 + 5.98245133881541e+22*cos(theta)**13 - 3.04987715312158e+22*cos(theta)**11 + 8.55832874600443e+21*cos(theta)**9 - 1.31106312704749e+21*cos(theta)**7 + 1.01971576548138e+20*cos(theta)**5 - 3.38776001821056e+18*cos(theta)**3 + 3.09856099226576e+16*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl28_m12(theta, phi):
    return 1.52522795453625e-17*(1.0 - cos(theta)**2)**6*(4.15210610777307e+23*cos(theta)**16 - 9.05914059877762e+23*cos(theta)**14 + 7.77718674046003e+23*cos(theta)**12 - 3.35486486843374e+23*cos(theta)**10 + 7.70249587140399e+22*cos(theta)**8 - 9.17744188933241e+21*cos(theta)**6 + 5.0985788274069e+20*cos(theta)**4 - 1.01632800546317e+19*cos(theta)**2 + 3.09856099226576e+16)*cos(12*phi)

@torch.jit.script
def Yl28_m13(theta, phi):
    return 5.95501468493973e-19*(1.0 - cos(theta)**2)**6.5*(6.64336977243692e+24*cos(theta)**15 - 1.26827968382887e+25*cos(theta)**13 + 9.33262408855204e+24*cos(theta)**11 - 3.35486486843374e+24*cos(theta)**9 + 6.16199669712319e+23*cos(theta)**7 - 5.50646513359945e+22*cos(theta)**5 + 2.03943153096276e+21*cos(theta)**3 - 2.03265601092634e+19*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl28_m14(theta, phi):
    return 2.3725346401488e-20*(1.0 - cos(theta)**2)**7*(9.96505465865538e+25*cos(theta)**14 - 1.64876358897753e+26*cos(theta)**12 + 1.02658864974072e+26*cos(theta)**10 - 3.01937838159036e+25*cos(theta)**8 + 4.31339768798623e+24*cos(theta)**6 - 2.75323256679972e+23*cos(theta)**4 + 6.11829459288828e+21*cos(theta)**2 - 2.03265601092634e+19)*cos(14*phi)

@torch.jit.script
def Yl28_m15(theta, phi):
    return 9.66972930141058e-22*(1.0 - cos(theta)**2)**7.5*(1.39510765221175e+27*cos(theta)**13 - 1.97851630677303e+27*cos(theta)**11 + 1.02658864974072e+27*cos(theta)**9 - 2.41550270527229e+26*cos(theta)**7 + 2.58803861279174e+25*cos(theta)**5 - 1.10129302671989e+24*cos(theta)**3 + 1.22365891857766e+22*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl28_m16(theta, phi):
    return 4.04311693361802e-23*(1.0 - cos(theta)**2)**8*(1.81363994787528e+28*cos(theta)**12 - 2.17636793745033e+28*cos(theta)**10 + 9.23929784766651e+27*cos(theta)**8 - 1.6908518936906e+27*cos(theta)**6 + 1.29401930639587e+26*cos(theta)**4 - 3.30387908015967e+24*cos(theta)**2 + 1.22365891857766e+22)*cos(16*phi)

@torch.jit.script
def Yl28_m17(theta, phi):
    return 1.7398805056302e-24*(1.0 - cos(theta)**2)**8.5*(2.17636793745033e+29*cos(theta)**11 - 2.17636793745033e+29*cos(theta)**9 + 7.39143827813321e+28*cos(theta)**7 - 1.01451113621436e+28*cos(theta)**5 + 5.17607722558348e+26*cos(theta)**3 - 6.60775816031934e+24*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl28_m18(theta, phi):
    return 7.73471228858538e-26*(1.0 - cos(theta)**2)**9*(2.39400473119537e+30*cos(theta)**10 - 1.9587311437053e+30*cos(theta)**8 + 5.17400679469325e+29*cos(theta)**6 - 5.07255568107181e+28*cos(theta)**4 + 1.55282316767504e+27*cos(theta)**2 - 6.60775816031934e+24)*cos(18*phi)

@torch.jit.script
def Yl28_m19(theta, phi):
    return 3.56775673567227e-27*(1.0 - cos(theta)**2)**9.5*(2.39400473119537e+31*cos(theta)**9 - 1.56698491496424e+31*cos(theta)**7 + 3.10440407681595e+30*cos(theta)**5 - 2.02902227242872e+29*cos(theta)**3 + 3.10564633535009e+27*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl28_m20(theta, phi):
    return 1.71653775978624e-28*(1.0 - cos(theta)**2)**10*(2.15460425807583e+32*cos(theta)**8 - 1.09688944047497e+32*cos(theta)**6 + 1.55220203840797e+31*cos(theta)**4 - 6.08706681728617e+29*cos(theta)**2 + 3.10564633535009e+27)*cos(20*phi)

@torch.jit.script
def Yl28_m21(theta, phi):
    return 8.66982492934009e-30*(1.0 - cos(theta)**2)**10.5*(1.72368340646067e+33*cos(theta)**7 - 6.58133664284981e+32*cos(theta)**5 + 6.2088081536319e+31*cos(theta)**3 - 1.21741336345723e+30*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl28_m22(theta, phi):
    return 4.63421635555746e-31*(1.0 - cos(theta)**2)**11*(1.20657838452247e+34*cos(theta)**6 - 3.29066832142491e+33*cos(theta)**4 + 1.86264244608957e+32*cos(theta)**2 - 1.21741336345723e+30)*cos(22*phi)

@torch.jit.script
def Yl28_m23(theta, phi):
    return 2.64920516074126e-32*(1.0 - cos(theta)**2)**11.5*(7.23947030713479e+34*cos(theta)**5 - 1.31626732856996e+34*cos(theta)**3 + 3.72528489217914e+32*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl28_m24(theta, phi):
    return 1.64296729492452e-33*(1.0 - cos(theta)**2)**12*(3.6197351535674e+35*cos(theta)**4 - 3.94880198570989e+34*cos(theta)**2 + 3.72528489217914e+32)*cos(24*phi)

@torch.jit.script
def Yl28_m25(theta, phi):
    return 1.12839457090042e-34*(1.0 - cos(theta)**2)**12.5*(1.44789406142696e+36*cos(theta)**3 - 7.89760397141977e+34*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl28_m26(theta, phi):
    return 8.86550503264189e-36*(1.0 - cos(theta)**2)**13*(4.34368218428088e+36*cos(theta)**2 - 7.89760397141977e+34)*cos(26*phi)

@torch.jit.script
def Yl28_m27(theta, phi):
    return 7.34336601605245*(1.0 - cos(theta)**2)**13.5*cos(27*phi)*cos(theta)

@torch.jit.script
def Yl28_m28(theta, phi):
    return 0.981298560633835*(1.0 - cos(theta)**2)**14*cos(28*phi)

@torch.jit.script
def Yl29_m_minus_29(theta, phi):
    return 0.989721878741179*(1.0 - cos(theta)**2)**14.5*sin(29*phi)

@torch.jit.script
def Yl29_m_minus_28(theta, phi):
    return 7.53749726640217*(1.0 - cos(theta)**2)**14*sin(28*phi)*cos(theta)

@torch.jit.script
def Yl29_m_minus_27(theta, phi):
    return 1.62523699825355e-37*(1.0 - cos(theta)**2)**13.5*(2.4758988450401e+38*cos(theta)**2 - 4.34368218428088e+36)*sin(27*phi)

@torch.jit.script
def Yl29_m_minus_26(theta, phi):
    return 2.106547911828e-36*(1.0 - cos(theta)**2)**13*(8.25299615013366e+37*cos(theta)**3 - 4.34368218428088e+36*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl29_m_minus_25(theta, phi):
    return 3.12451548733867e-35*(1.0 - cos(theta)**2)**12.5*(2.06324903753342e+37*cos(theta)**4 - 2.17184109214044e+36*cos(theta)**2 + 1.97440099285494e+34)*sin(25*phi)

@torch.jit.script
def Yl29_m_minus_24(theta, phi):
    return 5.13410284106891e-34*(1.0 - cos(theta)**2)**12*(4.12649807506683e+36*cos(theta)**5 - 7.23947030713479e+35*cos(theta)**3 + 1.97440099285494e+34*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl29_m_minus_23(theta, phi):
    return 9.15541687226183e-33*(1.0 - cos(theta)**2)**11.5*(6.87749679177805e+35*cos(theta)**6 - 1.8098675767837e+35*cos(theta)**4 + 9.87200496427472e+33*cos(theta)**2 - 6.2088081536319e+31)*sin(23*phi)

@torch.jit.script
def Yl29_m_minus_22(theta, phi):
    return 1.74674221195294e-31*(1.0 - cos(theta)**2)**11*(9.82499541682579e+34*cos(theta)**7 - 3.6197351535674e+34*cos(theta)**5 + 3.29066832142491e+33*cos(theta)**3 - 6.2088081536319e+31*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl29_m_minus_21(theta, phi):
    return 3.52824631913283e-30*(1.0 - cos(theta)**2)**10.5*(1.22812442710322e+34*cos(theta)**8 - 6.03289192261233e+33*cos(theta)**6 + 8.22667080356226e+32*cos(theta)**4 - 3.10440407681595e+31*cos(theta)**2 + 1.52176670432154e+29)*sin(21*phi)

@torch.jit.script
def Yl29_m_minus_20(theta, phi):
    return 7.48454069386591e-29*(1.0 - cos(theta)**2)**10*(1.36458269678136e+33*cos(theta)**9 - 8.61841703230333e+32*cos(theta)**7 + 1.64533416071245e+32*cos(theta)**5 - 1.03480135893865e+31*cos(theta)**3 + 1.52176670432154e+29*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl29_m_minus_19(theta, phi):
    return 1.65677370829833e-27*(1.0 - cos(theta)**2)**9.5*(1.36458269678136e+32*cos(theta)**10 - 1.07730212903792e+32*cos(theta)**8 + 2.74222360118742e+31*cos(theta)**6 - 2.58700339734662e+30*cos(theta)**4 + 7.60883352160772e+28*cos(theta)**2 - 3.10564633535009e+26)*sin(19*phi)

@torch.jit.script
def Yl29_m_minus_18(theta, phi):
    return 3.80697614338276e-26*(1.0 - cos(theta)**2)**9*(1.24052972434669e+31*cos(theta)**11 - 1.19700236559768e+31*cos(theta)**9 + 3.9174622874106e+30*cos(theta)**7 - 5.17400679469325e+29*cos(theta)**5 + 2.53627784053591e+28*cos(theta)**3 - 3.10564633535009e+26*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl29_m_minus_17(theta, phi):
    return 9.04106740874383e-25*(1.0 - cos(theta)**2)**8.5*(1.03377477028891e+30*cos(theta)**12 - 1.19700236559768e+30*cos(theta)**10 + 4.89682785926325e+29*cos(theta)**8 - 8.62334465782208e+28*cos(theta)**6 + 6.34069460133976e+27*cos(theta)**4 - 1.55282316767504e+26*cos(theta)**2 + 5.50646513359945e+23)*sin(17*phi)

@torch.jit.script
def Yl29_m_minus_16(theta, phi):
    return 2.21090610686865e-23*(1.0 - cos(theta)**2)**8*(7.95211361760699e+28*cos(theta)**13 - 1.08818396872517e+29*cos(theta)**11 + 5.44091984362584e+28*cos(theta)**9 - 1.23190637968887e+28*cos(theta)**7 + 1.26813892026795e+27*cos(theta)**5 - 5.17607722558348e+25*cos(theta)**3 + 5.50646513359945e+23*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl29_m_minus_15(theta, phi):
    return 5.54933028611123e-22*(1.0 - cos(theta)**2)**7.5*(5.68008115543357e+27*cos(theta)**14 - 9.06819973937639e+27*cos(theta)**12 + 5.44091984362584e+27*cos(theta)**10 - 1.53988297461109e+27*cos(theta)**8 + 2.11356486711325e+26*cos(theta)**6 - 1.29401930639587e+25*cos(theta)**4 + 2.75323256679972e+23*cos(theta)**2 - 8.74042084698325e+20)*sin(15*phi)

@torch.jit.script
def Yl29_m_minus_14(theta, phi):
    return 1.42564876361858e-20*(1.0 - cos(theta)**2)**7*(3.78672077028904e+26*cos(theta)**15 - 6.97553826105876e+26*cos(theta)**13 + 4.94629076693258e+26*cos(theta)**11 - 1.71098108290121e+26*cos(theta)**9 + 3.01937838159036e+25*cos(theta)**7 - 2.58803861279174e+24*cos(theta)**5 + 9.17744188933241e+22*cos(theta)**3 - 8.74042084698325e+20*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl29_m_minus_13(theta, phi):
    return 3.7394416498704e-19*(1.0 - cos(theta)**2)**6.5*(2.36670048143065e+25*cos(theta)**16 - 4.98252732932769e+25*cos(theta)**14 + 4.12190897244381e+25*cos(theta)**12 - 1.71098108290121e+25*cos(theta)**10 + 3.77422297698796e+24*cos(theta)**8 - 4.31339768798623e+23*cos(theta)**6 + 2.2943604723331e+22*cos(theta)**4 - 4.37021042349163e+20*cos(theta)**2 + 1.27041000682896e+18)*sin(13*phi)

@torch.jit.script
def Yl29_m_minus_12(theta, phi):
    return 9.99207917847372e-18*(1.0 - cos(theta)**2)**6*(1.39217675378274e+24*cos(theta)**17 - 3.32168488621846e+24*cos(theta)**15 + 3.17069920957217e+24*cos(theta)**13 - 1.55543734809201e+24*cos(theta)**11 + 4.19358108554217e+23*cos(theta)**9 - 6.16199669712319e+22*cos(theta)**7 + 4.58872094466621e+21*cos(theta)**5 - 1.45673680783054e+20*cos(theta)**3 + 1.27041000682896e+18*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl29_m_minus_11(theta, phi):
    return 2.7144637587553e-16*(1.0 - cos(theta)**2)**5.5*(7.73431529879298e+22*cos(theta)**18 - 2.07605305388654e+23*cos(theta)**16 + 2.2647851496944e+23*cos(theta)**14 - 1.29619779007667e+23*cos(theta)**12 + 4.19358108554217e+22*cos(theta)**10 - 7.70249587140399e+21*cos(theta)**8 + 7.64786824111034e+20*cos(theta)**6 - 3.64184201957635e+19*cos(theta)**4 + 6.35205003414481e+17*cos(theta)**2 - 1.72142277348098e+15)*sin(11*phi)

@torch.jit.script
def Yl29_m_minus_10(theta, phi):
    return 7.48326015729302e-15*(1.0 - cos(theta)**2)**5*(4.07069226252262e+21*cos(theta)**19 - 1.22120767875679e+22*cos(theta)**17 + 1.50985676646294e+22*cos(theta)**15 - 9.97075223135901e+21*cos(theta)**13 + 3.81234644140198e+21*cos(theta)**11 - 8.55832874600443e+20*cos(theta)**9 + 1.09255260587291e+20*cos(theta)**7 - 7.28368403915271e+18*cos(theta)**5 + 2.1173500113816e+17*cos(theta)**3 - 1.72142277348098e+15*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl29_m_minus_9(theta, phi):
    return 2.08996082292824e-13*(1.0 - cos(theta)**2)**4.5*(2.03534613126131e+20*cos(theta)**20 - 6.78448710420437e+20*cos(theta)**18 + 9.43660479039335e+20*cos(theta)**16 - 7.12196587954215e+20*cos(theta)**14 + 3.17695536783498e+20*cos(theta)**12 - 8.55832874600443e+19*cos(theta)**10 + 1.36569075734113e+19*cos(theta)**8 - 1.21394733985879e+18*cos(theta)**6 + 5.293375028454e+16*cos(theta)**4 - 860711386740489.0*cos(theta)**2 + 2206952273693.56)*sin(9*phi)

@torch.jit.script
def Yl29_m_minus_8(theta, phi):
    return 5.90390812988918e-12*(1.0 - cos(theta)**2)**4*(9.69212443457767e+18*cos(theta)**21 - 3.57078268642335e+19*cos(theta)**19 + 5.55094399434903e+19*cos(theta)**17 - 4.7479772530281e+19*cos(theta)**15 + 2.44381182141152e+19*cos(theta)**13 - 7.78029886000403e+18*cos(theta)**11 + 1.51743417482348e+18*cos(theta)**9 - 1.73421048551255e+17*cos(theta)**7 + 1.0586750056908e+16*cos(theta)**5 - 286903795580163.0*cos(theta)**3 + 2206952273693.56*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl29_m_minus_7(theta, phi):
    return 1.68442544512435e-10*(1.0 - cos(theta)**2)**3.5*(4.40551110662621e+17*cos(theta)**22 - 1.78539134321168e+18*cos(theta)**20 + 3.08385777463835e+18*cos(theta)**18 - 2.96748578314256e+18*cos(theta)**16 + 1.7455798724368e+18*cos(theta)**14 - 6.48358238333669e+17*cos(theta)**12 + 1.51743417482348e+17*cos(theta)**10 - 2.16776310689069e+16*cos(theta)**8 + 1.764458342818e+15*cos(theta)**6 - 71725948895040.7*cos(theta)**4 + 1103476136846.78*cos(theta)**2 - 2711243579.47612)*sin(7*phi)

@torch.jit.script
def Yl29_m_minus_6(theta, phi):
    return 4.84693238903845e-9*(1.0 - cos(theta)**2)**3*(1.91543961157661e+16*cos(theta)**23 - 8.50186353910322e+16*cos(theta)**21 + 1.62308303928334e+17*cos(theta)**19 - 1.7455798724368e+17*cos(theta)**17 + 1.16371991495787e+17*cos(theta)**15 - 4.98737106410515e+16*cos(theta)**13 + 1.37948561347589e+16*cos(theta)**11 - 2.40862567432299e+15*cos(theta)**9 + 252065477545429.0*cos(theta)**7 - 14345189779008.1*cos(theta)**5 + 367825378948.927*cos(theta)**3 - 2711243579.47612*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl29_m_minus_5(theta, phi):
    return 1.40477446625728e-7*(1.0 - cos(theta)**2)**2.5*(798099838156923.0*cos(theta)**24 - 3.8644834268651e+15*cos(theta)**22 + 8.11541519641671e+15*cos(theta)**20 - 9.69766595798223e+15*cos(theta)**18 + 7.27324946848667e+15*cos(theta)**16 - 3.56240790293225e+15*cos(theta)**14 + 1.14957134456324e+15*cos(theta)**12 - 240862567432299.0*cos(theta)**10 + 31508184693178.6*cos(theta)**8 - 2390864963168.02*cos(theta)**6 + 91956344737.2317*cos(theta)**4 - 1355621789.73806*cos(theta)**2 + 3227670.92794776)*sin(5*phi)

@torch.jit.script
def Yl29_m_minus_4(theta, phi):
    return 4.0955861679266e-6*(1.0 - cos(theta)**2)**2*(31923993526276.9*cos(theta)**25 - 168021018559352.0*cos(theta)**23 + 386448342686510.0*cos(theta)**21 - 510403471472749.0*cos(theta)**19 + 427838204028628.0*cos(theta)**17 - 237493860195483.0*cos(theta)**15 + 88428564966403.3*cos(theta)**13 - 21896597039299.9*cos(theta)**11 + 3500909410353.18*cos(theta)**9 - 341552137595.432*cos(theta)**7 + 18391268947.4463*cos(theta)**5 - 451873929.912686*cos(theta)**3 + 3227670.92794776*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl29_m_minus_3(theta, phi):
    return 0.000119966423463177*(1.0 - cos(theta)**2)**1.5*(1227845904856.8*cos(theta)**26 - 7000875773306.34*cos(theta)**24 + 17565833758477.7*cos(theta)**22 - 25520173573637.5*cos(theta)**20 + 23768789112701.5*cos(theta)**18 - 14843366262217.7*cos(theta)**16 + 6316326069028.81*cos(theta)**14 - 1824716419941.66*cos(theta)**12 + 350090941035.318*cos(theta)**10 - 42694017199.429*cos(theta)**8 + 3065211491.24106*cos(theta)**6 - 112968482.478172*cos(theta)**4 + 1613835.46397388*cos(theta)**2 - 3761.85422837734)*sin(3*phi)

@torch.jit.script
def Yl29_m_minus_2(theta, phi):
    return 0.00352627828501722*(1.0 - cos(theta)**2)*(45475774253.9557*cos(theta)**27 - 280035030932.254*cos(theta)**25 + 763731902542.51*cos(theta)**23 - 1215246360649.4*cos(theta)**21 + 1250988900668.5*cos(theta)**19 - 873139191895.159*cos(theta)**17 + 421088404601.921*cos(theta)**15 - 140362801533.974*cos(theta)**13 + 31826449185.0289*cos(theta)**11 - 4743779688.82544*cos(theta)**9 + 437887355.891579*cos(theta)**7 - 22593696.4956343*cos(theta)**5 + 537945.15465796*cos(theta)**3 - 3761.85422837734*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl29_m_minus_1(theta, phi):
    return 0.103890645660027*(1.0 - cos(theta)**2)**0.5*(1624134794.78413*cos(theta)**28 - 10770578112.779*cos(theta)**26 + 31822162605.9379*cos(theta)**24 - 55238470938.6092*cos(theta)**22 + 62549445033.4251*cos(theta)**20 - 48507732883.0644*cos(theta)**18 + 26318025287.62*cos(theta)**16 - 10025914395.2838*cos(theta)**14 + 2652204098.75241*cos(theta)**12 - 474377968.882544*cos(theta)**10 + 54735919.4864474*cos(theta)**8 - 3765616.08260572*cos(theta)**6 + 134486.28866449*cos(theta)**4 - 1880.92711418867*cos(theta)**2 + 4.33393344283104)*sin(phi)

@torch.jit.script
def Yl29_m0(theta, phi):
    return 121351499.324998*cos(theta)**29 - 864363310.981568*cos(theta)**27 + 2758104746.85937*cos(theta)**25 - 5203971220.48937*cos(theta)**23 + 6453944699.92064*cos(theta)**21 - 5531952599.93198*cos(theta)**19 + 3354481895.70343*cos(theta)**17 - 1448284247.03386*cos(theta)**15 + 442063505.635336*cos(theta)**13 - 93444318.26438*cos(theta)**11 + 13178044.8834382*cos(theta)**9 - 1165625.59165547*cos(theta)**7 + 58281.2795827734*cos(theta)**5 - 1358.53798561243*cos(theta)**3 + 9.39081556874954*cos(theta)

@torch.jit.script
def Yl29_m1(theta, phi):
    return 0.103890645660027*(1.0 - cos(theta)**2)**0.5*(1624134794.78413*cos(theta)**28 - 10770578112.779*cos(theta)**26 + 31822162605.9379*cos(theta)**24 - 55238470938.6092*cos(theta)**22 + 62549445033.4251*cos(theta)**20 - 48507732883.0644*cos(theta)**18 + 26318025287.62*cos(theta)**16 - 10025914395.2838*cos(theta)**14 + 2652204098.75241*cos(theta)**12 - 474377968.882544*cos(theta)**10 + 54735919.4864474*cos(theta)**8 - 3765616.08260572*cos(theta)**6 + 134486.28866449*cos(theta)**4 - 1880.92711418867*cos(theta)**2 + 4.33393344283104)*cos(phi)

@torch.jit.script
def Yl29_m2(theta, phi):
    return 0.00352627828501722*(1.0 - cos(theta)**2)*(45475774253.9557*cos(theta)**27 - 280035030932.254*cos(theta)**25 + 763731902542.51*cos(theta)**23 - 1215246360649.4*cos(theta)**21 + 1250988900668.5*cos(theta)**19 - 873139191895.159*cos(theta)**17 + 421088404601.921*cos(theta)**15 - 140362801533.974*cos(theta)**13 + 31826449185.0289*cos(theta)**11 - 4743779688.82544*cos(theta)**9 + 437887355.891579*cos(theta)**7 - 22593696.4956343*cos(theta)**5 + 537945.15465796*cos(theta)**3 - 3761.85422837734*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl29_m3(theta, phi):
    return 0.000119966423463177*(1.0 - cos(theta)**2)**1.5*(1227845904856.8*cos(theta)**26 - 7000875773306.34*cos(theta)**24 + 17565833758477.7*cos(theta)**22 - 25520173573637.5*cos(theta)**20 + 23768789112701.5*cos(theta)**18 - 14843366262217.7*cos(theta)**16 + 6316326069028.81*cos(theta)**14 - 1824716419941.66*cos(theta)**12 + 350090941035.318*cos(theta)**10 - 42694017199.429*cos(theta)**8 + 3065211491.24106*cos(theta)**6 - 112968482.478172*cos(theta)**4 + 1613835.46397388*cos(theta)**2 - 3761.85422837734)*cos(3*phi)

@torch.jit.script
def Yl29_m4(theta, phi):
    return 4.0955861679266e-6*(1.0 - cos(theta)**2)**2*(31923993526276.9*cos(theta)**25 - 168021018559352.0*cos(theta)**23 + 386448342686510.0*cos(theta)**21 - 510403471472749.0*cos(theta)**19 + 427838204028628.0*cos(theta)**17 - 237493860195483.0*cos(theta)**15 + 88428564966403.3*cos(theta)**13 - 21896597039299.9*cos(theta)**11 + 3500909410353.18*cos(theta)**9 - 341552137595.432*cos(theta)**7 + 18391268947.4463*cos(theta)**5 - 451873929.912686*cos(theta)**3 + 3227670.92794776*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl29_m5(theta, phi):
    return 1.40477446625728e-7*(1.0 - cos(theta)**2)**2.5*(798099838156923.0*cos(theta)**24 - 3.8644834268651e+15*cos(theta)**22 + 8.11541519641671e+15*cos(theta)**20 - 9.69766595798223e+15*cos(theta)**18 + 7.27324946848667e+15*cos(theta)**16 - 3.56240790293225e+15*cos(theta)**14 + 1.14957134456324e+15*cos(theta)**12 - 240862567432299.0*cos(theta)**10 + 31508184693178.6*cos(theta)**8 - 2390864963168.02*cos(theta)**6 + 91956344737.2317*cos(theta)**4 - 1355621789.73806*cos(theta)**2 + 3227670.92794776)*cos(5*phi)

@torch.jit.script
def Yl29_m6(theta, phi):
    return 4.84693238903845e-9*(1.0 - cos(theta)**2)**3*(1.91543961157661e+16*cos(theta)**23 - 8.50186353910322e+16*cos(theta)**21 + 1.62308303928334e+17*cos(theta)**19 - 1.7455798724368e+17*cos(theta)**17 + 1.16371991495787e+17*cos(theta)**15 - 4.98737106410515e+16*cos(theta)**13 + 1.37948561347589e+16*cos(theta)**11 - 2.40862567432299e+15*cos(theta)**9 + 252065477545429.0*cos(theta)**7 - 14345189779008.1*cos(theta)**5 + 367825378948.927*cos(theta)**3 - 2711243579.47612*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl29_m7(theta, phi):
    return 1.68442544512435e-10*(1.0 - cos(theta)**2)**3.5*(4.40551110662621e+17*cos(theta)**22 - 1.78539134321168e+18*cos(theta)**20 + 3.08385777463835e+18*cos(theta)**18 - 2.96748578314256e+18*cos(theta)**16 + 1.7455798724368e+18*cos(theta)**14 - 6.48358238333669e+17*cos(theta)**12 + 1.51743417482348e+17*cos(theta)**10 - 2.16776310689069e+16*cos(theta)**8 + 1.764458342818e+15*cos(theta)**6 - 71725948895040.7*cos(theta)**4 + 1103476136846.78*cos(theta)**2 - 2711243579.47612)*cos(7*phi)

@torch.jit.script
def Yl29_m8(theta, phi):
    return 5.90390812988918e-12*(1.0 - cos(theta)**2)**4*(9.69212443457767e+18*cos(theta)**21 - 3.57078268642335e+19*cos(theta)**19 + 5.55094399434903e+19*cos(theta)**17 - 4.7479772530281e+19*cos(theta)**15 + 2.44381182141152e+19*cos(theta)**13 - 7.78029886000403e+18*cos(theta)**11 + 1.51743417482348e+18*cos(theta)**9 - 1.73421048551255e+17*cos(theta)**7 + 1.0586750056908e+16*cos(theta)**5 - 286903795580163.0*cos(theta)**3 + 2206952273693.56*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl29_m9(theta, phi):
    return 2.08996082292824e-13*(1.0 - cos(theta)**2)**4.5*(2.03534613126131e+20*cos(theta)**20 - 6.78448710420437e+20*cos(theta)**18 + 9.43660479039335e+20*cos(theta)**16 - 7.12196587954215e+20*cos(theta)**14 + 3.17695536783498e+20*cos(theta)**12 - 8.55832874600443e+19*cos(theta)**10 + 1.36569075734113e+19*cos(theta)**8 - 1.21394733985879e+18*cos(theta)**6 + 5.293375028454e+16*cos(theta)**4 - 860711386740489.0*cos(theta)**2 + 2206952273693.56)*cos(9*phi)

@torch.jit.script
def Yl29_m10(theta, phi):
    return 7.48326015729302e-15*(1.0 - cos(theta)**2)**5*(4.07069226252262e+21*cos(theta)**19 - 1.22120767875679e+22*cos(theta)**17 + 1.50985676646294e+22*cos(theta)**15 - 9.97075223135901e+21*cos(theta)**13 + 3.81234644140198e+21*cos(theta)**11 - 8.55832874600443e+20*cos(theta)**9 + 1.09255260587291e+20*cos(theta)**7 - 7.28368403915271e+18*cos(theta)**5 + 2.1173500113816e+17*cos(theta)**3 - 1.72142277348098e+15*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl29_m11(theta, phi):
    return 2.7144637587553e-16*(1.0 - cos(theta)**2)**5.5*(7.73431529879298e+22*cos(theta)**18 - 2.07605305388654e+23*cos(theta)**16 + 2.2647851496944e+23*cos(theta)**14 - 1.29619779007667e+23*cos(theta)**12 + 4.19358108554217e+22*cos(theta)**10 - 7.70249587140399e+21*cos(theta)**8 + 7.64786824111034e+20*cos(theta)**6 - 3.64184201957635e+19*cos(theta)**4 + 6.35205003414481e+17*cos(theta)**2 - 1.72142277348098e+15)*cos(11*phi)

@torch.jit.script
def Yl29_m12(theta, phi):
    return 9.99207917847372e-18*(1.0 - cos(theta)**2)**6*(1.39217675378274e+24*cos(theta)**17 - 3.32168488621846e+24*cos(theta)**15 + 3.17069920957217e+24*cos(theta)**13 - 1.55543734809201e+24*cos(theta)**11 + 4.19358108554217e+23*cos(theta)**9 - 6.16199669712319e+22*cos(theta)**7 + 4.58872094466621e+21*cos(theta)**5 - 1.45673680783054e+20*cos(theta)**3 + 1.27041000682896e+18*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl29_m13(theta, phi):
    return 3.7394416498704e-19*(1.0 - cos(theta)**2)**6.5*(2.36670048143065e+25*cos(theta)**16 - 4.98252732932769e+25*cos(theta)**14 + 4.12190897244381e+25*cos(theta)**12 - 1.71098108290121e+25*cos(theta)**10 + 3.77422297698796e+24*cos(theta)**8 - 4.31339768798623e+23*cos(theta)**6 + 2.2943604723331e+22*cos(theta)**4 - 4.37021042349163e+20*cos(theta)**2 + 1.27041000682896e+18)*cos(13*phi)

@torch.jit.script
def Yl29_m14(theta, phi):
    return 1.42564876361858e-20*(1.0 - cos(theta)**2)**7*(3.78672077028904e+26*cos(theta)**15 - 6.97553826105876e+26*cos(theta)**13 + 4.94629076693258e+26*cos(theta)**11 - 1.71098108290121e+26*cos(theta)**9 + 3.01937838159036e+25*cos(theta)**7 - 2.58803861279174e+24*cos(theta)**5 + 9.17744188933241e+22*cos(theta)**3 - 8.74042084698325e+20*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl29_m15(theta, phi):
    return 5.54933028611123e-22*(1.0 - cos(theta)**2)**7.5*(5.68008115543357e+27*cos(theta)**14 - 9.06819973937639e+27*cos(theta)**12 + 5.44091984362584e+27*cos(theta)**10 - 1.53988297461109e+27*cos(theta)**8 + 2.11356486711325e+26*cos(theta)**6 - 1.29401930639587e+25*cos(theta)**4 + 2.75323256679972e+23*cos(theta)**2 - 8.74042084698325e+20)*cos(15*phi)

@torch.jit.script
def Yl29_m16(theta, phi):
    return 2.21090610686865e-23*(1.0 - cos(theta)**2)**8*(7.95211361760699e+28*cos(theta)**13 - 1.08818396872517e+29*cos(theta)**11 + 5.44091984362584e+28*cos(theta)**9 - 1.23190637968887e+28*cos(theta)**7 + 1.26813892026795e+27*cos(theta)**5 - 5.17607722558348e+25*cos(theta)**3 + 5.50646513359945e+23*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl29_m17(theta, phi):
    return 9.04106740874383e-25*(1.0 - cos(theta)**2)**8.5*(1.03377477028891e+30*cos(theta)**12 - 1.19700236559768e+30*cos(theta)**10 + 4.89682785926325e+29*cos(theta)**8 - 8.62334465782208e+28*cos(theta)**6 + 6.34069460133976e+27*cos(theta)**4 - 1.55282316767504e+26*cos(theta)**2 + 5.50646513359945e+23)*cos(17*phi)

@torch.jit.script
def Yl29_m18(theta, phi):
    return 3.80697614338276e-26*(1.0 - cos(theta)**2)**9*(1.24052972434669e+31*cos(theta)**11 - 1.19700236559768e+31*cos(theta)**9 + 3.9174622874106e+30*cos(theta)**7 - 5.17400679469325e+29*cos(theta)**5 + 2.53627784053591e+28*cos(theta)**3 - 3.10564633535009e+26*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl29_m19(theta, phi):
    return 1.65677370829833e-27*(1.0 - cos(theta)**2)**9.5*(1.36458269678136e+32*cos(theta)**10 - 1.07730212903792e+32*cos(theta)**8 + 2.74222360118742e+31*cos(theta)**6 - 2.58700339734662e+30*cos(theta)**4 + 7.60883352160772e+28*cos(theta)**2 - 3.10564633535009e+26)*cos(19*phi)

@torch.jit.script
def Yl29_m20(theta, phi):
    return 7.48454069386591e-29*(1.0 - cos(theta)**2)**10*(1.36458269678136e+33*cos(theta)**9 - 8.61841703230333e+32*cos(theta)**7 + 1.64533416071245e+32*cos(theta)**5 - 1.03480135893865e+31*cos(theta)**3 + 1.52176670432154e+29*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl29_m21(theta, phi):
    return 3.52824631913283e-30*(1.0 - cos(theta)**2)**10.5*(1.22812442710322e+34*cos(theta)**8 - 6.03289192261233e+33*cos(theta)**6 + 8.22667080356226e+32*cos(theta)**4 - 3.10440407681595e+31*cos(theta)**2 + 1.52176670432154e+29)*cos(21*phi)

@torch.jit.script
def Yl29_m22(theta, phi):
    return 1.74674221195294e-31*(1.0 - cos(theta)**2)**11*(9.82499541682579e+34*cos(theta)**7 - 3.6197351535674e+34*cos(theta)**5 + 3.29066832142491e+33*cos(theta)**3 - 6.2088081536319e+31*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl29_m23(theta, phi):
    return 9.15541687226183e-33*(1.0 - cos(theta)**2)**11.5*(6.87749679177805e+35*cos(theta)**6 - 1.8098675767837e+35*cos(theta)**4 + 9.87200496427472e+33*cos(theta)**2 - 6.2088081536319e+31)*cos(23*phi)

@torch.jit.script
def Yl29_m24(theta, phi):
    return 5.13410284106891e-34*(1.0 - cos(theta)**2)**12*(4.12649807506683e+36*cos(theta)**5 - 7.23947030713479e+35*cos(theta)**3 + 1.97440099285494e+34*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl29_m25(theta, phi):
    return 3.12451548733867e-35*(1.0 - cos(theta)**2)**12.5*(2.06324903753342e+37*cos(theta)**4 - 2.17184109214044e+36*cos(theta)**2 + 1.97440099285494e+34)*cos(25*phi)

@torch.jit.script
def Yl29_m26(theta, phi):
    return 2.106547911828e-36*(1.0 - cos(theta)**2)**13*(8.25299615013366e+37*cos(theta)**3 - 4.34368218428088e+36*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl29_m27(theta, phi):
    return 1.62523699825355e-37*(1.0 - cos(theta)**2)**13.5*(2.4758988450401e+38*cos(theta)**2 - 4.34368218428088e+36)*cos(27*phi)

@torch.jit.script
def Yl29_m28(theta, phi):
    return 7.53749726640217*(1.0 - cos(theta)**2)**14*cos(28*phi)*cos(theta)

@torch.jit.script
def Yl29_m29(theta, phi):
    return 0.989721878741179*(1.0 - cos(theta)**2)**14.5*cos(29*phi)

@torch.jit.script
def Yl30_m_minus_30(theta, phi):
    return 0.997935479150139*(1.0 - cos(theta)**2)**15*sin(30*phi)

@torch.jit.script
def Yl30_m_minus_29(theta, phi):
    return 7.72997498267602*(1.0 - cos(theta)**2)**14.5*sin(29*phi)*cos(theta)

@torch.jit.script
def Yl30_m_minus_28(theta, phi):
    return 2.87411530575892e-39*(1.0 - cos(theta)**2)**14*(1.46078031857366e+40*cos(theta)**2 - 2.4758988450401e+38)*sin(28*phi)

@torch.jit.script
def Yl30_m_minus_27(theta, phi):
    return 3.79121847114987e-38*(1.0 - cos(theta)**2)**13.5*(4.86926772857886e+39*cos(theta)**3 - 2.4758988450401e+38*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl30_m_minus_26(theta, phi):
    return 5.72461435302436e-37*(1.0 - cos(theta)**2)**13*(1.21731693214472e+39*cos(theta)**4 - 1.23794942252005e+38*cos(theta)**2 + 1.08592054607022e+36)*sin(26*phi)

@torch.jit.script
def Yl30_m_minus_25(theta, phi):
    return 9.57911199299742e-36*(1.0 - cos(theta)**2)**12.5*(2.43463386428943e+38*cos(theta)**5 - 4.12649807506683e+37*cos(theta)**3 + 1.08592054607022e+36*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl30_m_minus_24(theta, phi):
    return 1.74013210905229e-34*(1.0 - cos(theta)**2)**12*(4.05772310714905e+37*cos(theta)**6 - 1.03162451876671e+37*cos(theta)**4 + 5.42960273035109e+35*cos(theta)**2 - 3.29066832142491e+33)*sin(24*phi)

@torch.jit.script
def Yl30_m_minus_23(theta, phi):
    return 3.38320349392245e-33*(1.0 - cos(theta)**2)**11.5*(5.79674729592722e+36*cos(theta)**7 - 2.06324903753342e+36*cos(theta)**5 + 1.8098675767837e+35*cos(theta)**3 - 3.29066832142491e+33*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl30_m_minus_22(theta, phi):
    return 6.96644237302409e-32*(1.0 - cos(theta)**2)**11*(7.24593411990902e+35*cos(theta)**8 - 3.43874839588903e+35*cos(theta)**6 + 4.52466894195925e+34*cos(theta)**4 - 1.64533416071245e+33*cos(theta)**2 + 7.76101019203987e+30)*sin(22*phi)

@torch.jit.script
def Yl30_m_minus_21(theta, phi):
    return 1.5070719110102e-30*(1.0 - cos(theta)**2)**10.5*(8.05103791101002e+34*cos(theta)**9 - 4.9124977084129e+34*cos(theta)**7 + 9.04933788391849e+33*cos(theta)**5 - 5.48444720237484e+32*cos(theta)**3 + 7.76101019203987e+30*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl30_m_minus_20(theta, phi):
    return 3.40344756082348e-29*(1.0 - cos(theta)**2)**10*(8.05103791101002e+33*cos(theta)**10 - 6.14062213551612e+33*cos(theta)**8 + 1.50822298065308e+33*cos(theta)**6 - 1.37111180059371e+32*cos(theta)**4 + 3.88050509601994e+30*cos(theta)**2 - 1.52176670432154e+28)*sin(20*phi)

@torch.jit.script
def Yl30_m_minus_19(theta, phi):
    return 7.98179203850954e-28*(1.0 - cos(theta)**2)**9.5*(7.31912537364547e+32*cos(theta)**11 - 6.8229134839068e+32*cos(theta)**9 + 2.15460425807583e+32*cos(theta)**7 - 2.74222360118742e+31*cos(theta)**5 + 1.29350169867331e+30*cos(theta)**3 - 1.52176670432154e+28*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl30_m_minus_18(theta, phi):
    return 1.93548170846062e-26*(1.0 - cos(theta)**2)**9*(6.09927114470456e+31*cos(theta)**12 - 6.8229134839068e+31*cos(theta)**10 + 2.69325532259479e+31*cos(theta)**8 - 4.5703726686457e+30*cos(theta)**6 + 3.23375424668328e+29*cos(theta)**4 - 7.60883352160772e+27*cos(theta)**2 + 2.58803861279174e+25)*sin(18*phi)

@torch.jit.script
def Yl30_m_minus_17(theta, phi):
    return 4.83483175810931e-25*(1.0 - cos(theta)**2)**8.5*(4.69174703438813e+30*cos(theta)**13 - 6.20264862173345e+30*cos(theta)**11 + 2.99250591399421e+30*cos(theta)**9 - 6.529103812351e+29*cos(theta)**7 + 6.46750849336656e+28*cos(theta)**5 - 2.53627784053591e+27*cos(theta)**3 + 2.58803861279174e+25*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl30_m_minus_16(theta, phi):
    return 1.24020738463486e-23*(1.0 - cos(theta)**2)**8*(3.3512478817058e+29*cos(theta)**14 - 5.16887385144454e+29*cos(theta)**12 + 2.99250591399421e+29*cos(theta)**10 - 8.16137976543875e+28*cos(theta)**8 + 1.07791808222776e+28*cos(theta)**6 - 6.34069460133976e+26*cos(theta)**4 + 1.29401930639587e+25*cos(theta)**2 - 3.93318938114246e+22)*sin(16*phi)

@torch.jit.script
def Yl30_m_minus_15(theta, phi):
    return 3.25775828793813e-22*(1.0 - cos(theta)**2)**7.5*(2.23416525447054e+28*cos(theta)**15 - 3.9760568088035e+28*cos(theta)**13 + 2.72045992181292e+28*cos(theta)**11 - 9.06819973937639e+27*cos(theta)**9 + 1.53988297461109e+27*cos(theta)**7 - 1.26813892026795e+26*cos(theta)**5 + 4.31339768798623e+24*cos(theta)**3 - 3.93318938114246e+22*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl30_m_minus_14(theta, phi):
    return 8.74148278331158e-21*(1.0 - cos(theta)**2)**7*(1.39635328404408e+27*cos(theta)**16 - 2.84004057771678e+27*cos(theta)**14 + 2.2670499348441e+27*cos(theta)**12 - 9.06819973937639e+26*cos(theta)**10 + 1.92485371826386e+26*cos(theta)**8 - 2.11356486711326e+25*cos(theta)**6 + 1.07834942199656e+24*cos(theta)**4 - 1.96659469057123e+22*cos(theta)**2 + 5.46276302936453e+19)*sin(14*phi)

@torch.jit.script
def Yl30_m_minus_13(theta, phi):
    return 2.39075958422627e-19*(1.0 - cos(theta)**2)**6.5*(8.21384284731815e+25*cos(theta)**17 - 1.89336038514452e+26*cos(theta)**15 + 1.74388456526469e+26*cos(theta)**13 - 8.24381794488763e+25*cos(theta)**11 + 2.13872635362651e+25*cos(theta)**9 - 3.01937838159036e+24*cos(theta)**7 + 2.15669884399312e+23*cos(theta)**5 - 6.55531563523744e+21*cos(theta)**3 + 5.46276302936453e+19*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl30_m_minus_12(theta, phi):
    return 6.65129768956931e-18*(1.0 - cos(theta)**2)**6*(4.56324602628786e+24*cos(theta)**18 - 1.18335024071533e+25*cos(theta)**16 + 1.24563183233192e+25*cos(theta)**14 - 6.86984828740636e+24*cos(theta)**12 + 2.13872635362651e+24*cos(theta)**10 - 3.77422297698795e+23*cos(theta)**8 + 3.59449807332186e+22*cos(theta)**6 - 1.63882890880936e+21*cos(theta)**4 + 2.73138151468227e+19*cos(theta)**2 - 7.05783337127201e+16)*sin(12*phi)

@torch.jit.script
def Yl30_m_minus_11(theta, phi):
    return 1.87891801956087e-16*(1.0 - cos(theta)**2)**5.5*(2.40170843488835e+23*cos(theta)**19 - 6.96088376891368e+23*cos(theta)**17 + 8.30421221554615e+23*cos(theta)**15 - 5.28449868262028e+23*cos(theta)**13 + 1.94429668511501e+23*cos(theta)**11 - 4.19358108554217e+22*cos(theta)**9 + 5.13499724760266e+21*cos(theta)**7 - 3.27765781761872e+20*cos(theta)**5 + 9.10460504894089e+18*cos(theta)**3 - 7.05783337127201e+16*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl30_m_minus_10(theta, phi):
    return 5.38040239932763e-15*(1.0 - cos(theta)**2)**5*(1.20085421744417e+22*cos(theta)**20 - 3.86715764939649e+22*cos(theta)**18 + 5.19013263471634e+22*cos(theta)**16 - 3.77464191615734e+22*cos(theta)**14 + 1.62024723759584e+22*cos(theta)**12 - 4.19358108554217e+21*cos(theta)**10 + 6.41874655950332e+20*cos(theta)**8 - 5.46276302936453e+19*cos(theta)**6 + 2.27615126223522e+18*cos(theta)**4 - 3.528916685636e+16*cos(theta)**2 + 86071138674048.8)*sin(10*phi)

@torch.jit.script
def Yl30_m_minus_9(theta, phi):
    return 1.55938876429517e-13*(1.0 - cos(theta)**2)**4.5*(5.71835341640083e+20*cos(theta)**21 - 2.03534613126131e+21*cos(theta)**19 + 3.05301919689197e+21*cos(theta)**17 - 2.51642794410489e+21*cos(theta)**15 + 1.24634402891988e+21*cos(theta)**13 - 3.81234644140197e+20*cos(theta)**11 + 7.13194062167036e+19*cos(theta)**9 - 7.80394718480647e+18*cos(theta)**7 + 4.55230252447044e+17*cos(theta)**5 - 1.17630556187867e+16*cos(theta)**3 + 86071138674048.8*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl30_m_minus_8(theta, phi):
    return 4.56770496751288e-12*(1.0 - cos(theta)**2)**4*(2.59925155290947e+19*cos(theta)**22 - 1.01767306563066e+20*cos(theta)**20 + 1.69612177605109e+20*cos(theta)**18 - 1.57276746506556e+20*cos(theta)**16 + 8.90245734942769e+19*cos(theta)**14 - 3.17695536783498e+19*cos(theta)**12 + 7.13194062167036e+18*cos(theta)**10 - 9.75493398100809e+17*cos(theta)**8 + 7.58717087411741e+16*cos(theta)**6 - 2.94076390469667e+15*cos(theta)**4 + 43035569337024.4*cos(theta)**2 - 100316012440.616)*sin(8*phi)

@torch.jit.script
def Yl30_m_minus_7(theta, phi):
    return 1.3503730468945e-10*(1.0 - cos(theta)**2)**3.5*(1.1301093708302e+18*cos(theta)**23 - 4.84606221728884e+18*cos(theta)**21 + 8.92695671605838e+18*cos(theta)**19 - 9.25157332391505e+18*cos(theta)**17 + 5.93497156628513e+18*cos(theta)**15 - 2.44381182141152e+18*cos(theta)**13 + 6.48358238333669e+17*cos(theta)**11 - 1.08388155344534e+17*cos(theta)**9 + 1.08388155344534e+16*cos(theta)**7 - 588152780939334.0*cos(theta)**5 + 14345189779008.1*cos(theta)**3 - 100316012440.616*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl30_m_minus_6(theta, phi):
    return 4.02402104966148e-9*(1.0 - cos(theta)**2)**3*(4.70878904512584e+16*cos(theta)**24 - 2.20275555331311e+17*cos(theta)**22 + 4.46347835802919e+17*cos(theta)**20 - 5.13976295773058e+17*cos(theta)**18 + 3.7093572289282e+17*cos(theta)**16 - 1.7455798724368e+17*cos(theta)**14 + 5.40298531944724e+16*cos(theta)**12 - 1.08388155344534e+16*cos(theta)**10 + 1.35485194180668e+15*cos(theta)**8 - 98025463489889.0*cos(theta)**6 + 3586297444752.04*cos(theta)**4 - 50158006220.3082*cos(theta)**2 + 112968482.478172)*sin(6*phi)

@torch.jit.script
def Yl30_m_minus_5(theta, phi):
    return 1.20720631489845e-7*(1.0 - cos(theta)**2)**2.5*(1.88351561805034e+15*cos(theta)**25 - 9.57719805788307e+15*cos(theta)**23 + 2.1254658847758e+16*cos(theta)**21 - 2.70513839880557e+16*cos(theta)**19 + 2.181974840546e+16*cos(theta)**17 - 1.16371991495787e+16*cos(theta)**15 + 4.15614255342096e+15*cos(theta)**13 - 985346866768494.0*cos(theta)**11 + 150539104645187.0*cos(theta)**9 - 14003637641412.7*cos(theta)**7 + 717259488950.407*cos(theta)**5 - 16719335406.7694*cos(theta)**3 + 112968482.478172*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl30_m_minus_4(theta, phi):
    return 3.64168346911826e-6*(1.0 - cos(theta)**2)**2*(72442908386551.5*cos(theta)**26 - 399049919078461.0*cos(theta)**24 + 966120856716275.0*cos(theta)**22 - 1.35256919940279e+15*cos(theta)**20 + 1.21220824474778e+15*cos(theta)**18 - 727324946848667.0*cos(theta)**16 + 296867325244354.0*cos(theta)**14 - 82112238897374.5*cos(theta)**12 + 15053910464518.7*cos(theta)**10 - 1750454705176.59*cos(theta)**8 + 119543248158.401*cos(theta)**6 - 4179833851.69235*cos(theta)**4 + 56484241.2390858*cos(theta)**2 - 124141.189536452)*sin(4*phi)

@torch.jit.script
def Yl30_m_minus_3(theta, phi):
    return 0.000110337600540934*(1.0 - cos(theta)**2)**1.5*(2683070680983.39*cos(theta)**27 - 15961996763138.5*cos(theta)**25 + 42005254639838.0*cos(theta)**23 - 64408057114418.3*cos(theta)**21 + 63800433934093.6*cos(theta)**19 - 42783820402862.8*cos(theta)**17 + 19791155016290.3*cos(theta)**15 - 6316326069028.81*cos(theta)**13 + 1368537314956.24*cos(theta)**11 - 194494967241.843*cos(theta)**9 + 17077606879.7716*cos(theta)**7 - 835966770.33847*cos(theta)**5 + 18828080.4130286*cos(theta)**3 - 124141.189536452*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl30_m_minus_2(theta, phi):
    return 0.00335397268176902*(1.0 - cos(theta)**2)*(95823952892.2638*cos(theta)**28 - 613922952428.402*cos(theta)**26 + 1750218943326.59*cos(theta)**24 - 2927638959746.29*cos(theta)**22 + 3190021696704.68*cos(theta)**20 - 2376878911270.15*cos(theta)**18 + 1236947188518.14*cos(theta)**16 - 451166147787.772*cos(theta)**14 + 114044776246.354*cos(theta)**12 - 19449496724.1843*cos(theta)**10 + 2134700859.97145*cos(theta)**8 - 139327795.056412*cos(theta)**6 + 4707020.10325715*cos(theta)**4 - 62070.5947682261*cos(theta)**2 + 134.351936727762)*sin(2*phi)

@torch.jit.script
def Yl30_m_minus_1(theta, phi):
    return 0.102172379790475*(1.0 - cos(theta)**2)**0.5*(3304274237.66427*cos(theta)**29 - 22737887126.9779*cos(theta)**27 + 70008757733.0634*cos(theta)**25 - 127288650423.752*cos(theta)**23 + 151905795081.175*cos(theta)**21 - 125098890066.85*cos(theta)**19 + 72761599324.5966*cos(theta)**17 - 30077743185.8515*cos(theta)**15 + 8772675095.87335*cos(theta)**13 - 1768136065.83494*cos(theta)**11 + 237188984.441272*cos(theta)**9 - 19903970.7223445*cos(theta)**7 + 941404.02065143*cos(theta)**5 - 20690.1982560754*cos(theta)**3 + 134.351936727762*cos(theta))*sin(phi)

@torch.jit.script
def Yl30_m0(theta, phi):
    return 242669287.558974*cos(theta)**30 - 1789171865.90091*cos(theta)**28 + 5932517239.56617*cos(theta)**26 - 11685261229.4485*cos(theta)**24 + 15212887260.9801*cos(theta)**22 - 13781086107.0055*cos(theta)**20 + 8906144082.75869*cos(theta)**18 - 4141763053.68413*cos(theta)**16 + 1380587684.56138*cos(theta)**14 - 324634313.423993*cos(theta)**12 + 52258206.5511794*cos(theta)**10 - 5481630.05781602*cos(theta)**8 + 345688.382024433*cos(theta)**6 - 11396.3202865198*cos(theta)**4 + 148.004159565192*cos(theta)**2 - 0.318288515193961

@torch.jit.script
def Yl30_m1(theta, phi):
    return 0.102172379790475*(1.0 - cos(theta)**2)**0.5*(3304274237.66427*cos(theta)**29 - 22737887126.9779*cos(theta)**27 + 70008757733.0634*cos(theta)**25 - 127288650423.752*cos(theta)**23 + 151905795081.175*cos(theta)**21 - 125098890066.85*cos(theta)**19 + 72761599324.5966*cos(theta)**17 - 30077743185.8515*cos(theta)**15 + 8772675095.87335*cos(theta)**13 - 1768136065.83494*cos(theta)**11 + 237188984.441272*cos(theta)**9 - 19903970.7223445*cos(theta)**7 + 941404.02065143*cos(theta)**5 - 20690.1982560754*cos(theta)**3 + 134.351936727762*cos(theta))*cos(phi)

@torch.jit.script
def Yl30_m2(theta, phi):
    return 0.00335397268176902*(1.0 - cos(theta)**2)*(95823952892.2638*cos(theta)**28 - 613922952428.402*cos(theta)**26 + 1750218943326.59*cos(theta)**24 - 2927638959746.29*cos(theta)**22 + 3190021696704.68*cos(theta)**20 - 2376878911270.15*cos(theta)**18 + 1236947188518.14*cos(theta)**16 - 451166147787.772*cos(theta)**14 + 114044776246.354*cos(theta)**12 - 19449496724.1843*cos(theta)**10 + 2134700859.97145*cos(theta)**8 - 139327795.056412*cos(theta)**6 + 4707020.10325715*cos(theta)**4 - 62070.5947682261*cos(theta)**2 + 134.351936727762)*cos(2*phi)

@torch.jit.script
def Yl30_m3(theta, phi):
    return 0.000110337600540934*(1.0 - cos(theta)**2)**1.5*(2683070680983.39*cos(theta)**27 - 15961996763138.5*cos(theta)**25 + 42005254639838.0*cos(theta)**23 - 64408057114418.3*cos(theta)**21 + 63800433934093.6*cos(theta)**19 - 42783820402862.8*cos(theta)**17 + 19791155016290.3*cos(theta)**15 - 6316326069028.81*cos(theta)**13 + 1368537314956.24*cos(theta)**11 - 194494967241.843*cos(theta)**9 + 17077606879.7716*cos(theta)**7 - 835966770.33847*cos(theta)**5 + 18828080.4130286*cos(theta)**3 - 124141.189536452*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl30_m4(theta, phi):
    return 3.64168346911826e-6*(1.0 - cos(theta)**2)**2*(72442908386551.5*cos(theta)**26 - 399049919078461.0*cos(theta)**24 + 966120856716275.0*cos(theta)**22 - 1.35256919940279e+15*cos(theta)**20 + 1.21220824474778e+15*cos(theta)**18 - 727324946848667.0*cos(theta)**16 + 296867325244354.0*cos(theta)**14 - 82112238897374.5*cos(theta)**12 + 15053910464518.7*cos(theta)**10 - 1750454705176.59*cos(theta)**8 + 119543248158.401*cos(theta)**6 - 4179833851.69235*cos(theta)**4 + 56484241.2390858*cos(theta)**2 - 124141.189536452)*cos(4*phi)

@torch.jit.script
def Yl30_m5(theta, phi):
    return 1.20720631489845e-7*(1.0 - cos(theta)**2)**2.5*(1.88351561805034e+15*cos(theta)**25 - 9.57719805788307e+15*cos(theta)**23 + 2.1254658847758e+16*cos(theta)**21 - 2.70513839880557e+16*cos(theta)**19 + 2.181974840546e+16*cos(theta)**17 - 1.16371991495787e+16*cos(theta)**15 + 4.15614255342096e+15*cos(theta)**13 - 985346866768494.0*cos(theta)**11 + 150539104645187.0*cos(theta)**9 - 14003637641412.7*cos(theta)**7 + 717259488950.407*cos(theta)**5 - 16719335406.7694*cos(theta)**3 + 112968482.478172*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl30_m6(theta, phi):
    return 4.02402104966148e-9*(1.0 - cos(theta)**2)**3*(4.70878904512584e+16*cos(theta)**24 - 2.20275555331311e+17*cos(theta)**22 + 4.46347835802919e+17*cos(theta)**20 - 5.13976295773058e+17*cos(theta)**18 + 3.7093572289282e+17*cos(theta)**16 - 1.7455798724368e+17*cos(theta)**14 + 5.40298531944724e+16*cos(theta)**12 - 1.08388155344534e+16*cos(theta)**10 + 1.35485194180668e+15*cos(theta)**8 - 98025463489889.0*cos(theta)**6 + 3586297444752.04*cos(theta)**4 - 50158006220.3082*cos(theta)**2 + 112968482.478172)*cos(6*phi)

@torch.jit.script
def Yl30_m7(theta, phi):
    return 1.3503730468945e-10*(1.0 - cos(theta)**2)**3.5*(1.1301093708302e+18*cos(theta)**23 - 4.84606221728884e+18*cos(theta)**21 + 8.92695671605838e+18*cos(theta)**19 - 9.25157332391505e+18*cos(theta)**17 + 5.93497156628513e+18*cos(theta)**15 - 2.44381182141152e+18*cos(theta)**13 + 6.48358238333669e+17*cos(theta)**11 - 1.08388155344534e+17*cos(theta)**9 + 1.08388155344534e+16*cos(theta)**7 - 588152780939334.0*cos(theta)**5 + 14345189779008.1*cos(theta)**3 - 100316012440.616*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl30_m8(theta, phi):
    return 4.56770496751288e-12*(1.0 - cos(theta)**2)**4*(2.59925155290947e+19*cos(theta)**22 - 1.01767306563066e+20*cos(theta)**20 + 1.69612177605109e+20*cos(theta)**18 - 1.57276746506556e+20*cos(theta)**16 + 8.90245734942769e+19*cos(theta)**14 - 3.17695536783498e+19*cos(theta)**12 + 7.13194062167036e+18*cos(theta)**10 - 9.75493398100809e+17*cos(theta)**8 + 7.58717087411741e+16*cos(theta)**6 - 2.94076390469667e+15*cos(theta)**4 + 43035569337024.4*cos(theta)**2 - 100316012440.616)*cos(8*phi)

@torch.jit.script
def Yl30_m9(theta, phi):
    return 1.55938876429517e-13*(1.0 - cos(theta)**2)**4.5*(5.71835341640083e+20*cos(theta)**21 - 2.03534613126131e+21*cos(theta)**19 + 3.05301919689197e+21*cos(theta)**17 - 2.51642794410489e+21*cos(theta)**15 + 1.24634402891988e+21*cos(theta)**13 - 3.81234644140197e+20*cos(theta)**11 + 7.13194062167036e+19*cos(theta)**9 - 7.80394718480647e+18*cos(theta)**7 + 4.55230252447044e+17*cos(theta)**5 - 1.17630556187867e+16*cos(theta)**3 + 86071138674048.8*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl30_m10(theta, phi):
    return 5.38040239932763e-15*(1.0 - cos(theta)**2)**5*(1.20085421744417e+22*cos(theta)**20 - 3.86715764939649e+22*cos(theta)**18 + 5.19013263471634e+22*cos(theta)**16 - 3.77464191615734e+22*cos(theta)**14 + 1.62024723759584e+22*cos(theta)**12 - 4.19358108554217e+21*cos(theta)**10 + 6.41874655950332e+20*cos(theta)**8 - 5.46276302936453e+19*cos(theta)**6 + 2.27615126223522e+18*cos(theta)**4 - 3.528916685636e+16*cos(theta)**2 + 86071138674048.8)*cos(10*phi)

@torch.jit.script
def Yl30_m11(theta, phi):
    return 1.87891801956087e-16*(1.0 - cos(theta)**2)**5.5*(2.40170843488835e+23*cos(theta)**19 - 6.96088376891368e+23*cos(theta)**17 + 8.30421221554615e+23*cos(theta)**15 - 5.28449868262028e+23*cos(theta)**13 + 1.94429668511501e+23*cos(theta)**11 - 4.19358108554217e+22*cos(theta)**9 + 5.13499724760266e+21*cos(theta)**7 - 3.27765781761872e+20*cos(theta)**5 + 9.10460504894089e+18*cos(theta)**3 - 7.05783337127201e+16*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl30_m12(theta, phi):
    return 6.65129768956931e-18*(1.0 - cos(theta)**2)**6*(4.56324602628786e+24*cos(theta)**18 - 1.18335024071533e+25*cos(theta)**16 + 1.24563183233192e+25*cos(theta)**14 - 6.86984828740636e+24*cos(theta)**12 + 2.13872635362651e+24*cos(theta)**10 - 3.77422297698795e+23*cos(theta)**8 + 3.59449807332186e+22*cos(theta)**6 - 1.63882890880936e+21*cos(theta)**4 + 2.73138151468227e+19*cos(theta)**2 - 7.05783337127201e+16)*cos(12*phi)

@torch.jit.script
def Yl30_m13(theta, phi):
    return 2.39075958422627e-19*(1.0 - cos(theta)**2)**6.5*(8.21384284731815e+25*cos(theta)**17 - 1.89336038514452e+26*cos(theta)**15 + 1.74388456526469e+26*cos(theta)**13 - 8.24381794488763e+25*cos(theta)**11 + 2.13872635362651e+25*cos(theta)**9 - 3.01937838159036e+24*cos(theta)**7 + 2.15669884399312e+23*cos(theta)**5 - 6.55531563523744e+21*cos(theta)**3 + 5.46276302936453e+19*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl30_m14(theta, phi):
    return 8.74148278331158e-21*(1.0 - cos(theta)**2)**7*(1.39635328404408e+27*cos(theta)**16 - 2.84004057771678e+27*cos(theta)**14 + 2.2670499348441e+27*cos(theta)**12 - 9.06819973937639e+26*cos(theta)**10 + 1.92485371826386e+26*cos(theta)**8 - 2.11356486711326e+25*cos(theta)**6 + 1.07834942199656e+24*cos(theta)**4 - 1.96659469057123e+22*cos(theta)**2 + 5.46276302936453e+19)*cos(14*phi)

@torch.jit.script
def Yl30_m15(theta, phi):
    return 3.25775828793813e-22*(1.0 - cos(theta)**2)**7.5*(2.23416525447054e+28*cos(theta)**15 - 3.9760568088035e+28*cos(theta)**13 + 2.72045992181292e+28*cos(theta)**11 - 9.06819973937639e+27*cos(theta)**9 + 1.53988297461109e+27*cos(theta)**7 - 1.26813892026795e+26*cos(theta)**5 + 4.31339768798623e+24*cos(theta)**3 - 3.93318938114246e+22*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl30_m16(theta, phi):
    return 1.24020738463486e-23*(1.0 - cos(theta)**2)**8*(3.3512478817058e+29*cos(theta)**14 - 5.16887385144454e+29*cos(theta)**12 + 2.99250591399421e+29*cos(theta)**10 - 8.16137976543875e+28*cos(theta)**8 + 1.07791808222776e+28*cos(theta)**6 - 6.34069460133976e+26*cos(theta)**4 + 1.29401930639587e+25*cos(theta)**2 - 3.93318938114246e+22)*cos(16*phi)

@torch.jit.script
def Yl30_m17(theta, phi):
    return 4.83483175810931e-25*(1.0 - cos(theta)**2)**8.5*(4.69174703438813e+30*cos(theta)**13 - 6.20264862173345e+30*cos(theta)**11 + 2.99250591399421e+30*cos(theta)**9 - 6.529103812351e+29*cos(theta)**7 + 6.46750849336656e+28*cos(theta)**5 - 2.53627784053591e+27*cos(theta)**3 + 2.58803861279174e+25*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl30_m18(theta, phi):
    return 1.93548170846062e-26*(1.0 - cos(theta)**2)**9*(6.09927114470456e+31*cos(theta)**12 - 6.8229134839068e+31*cos(theta)**10 + 2.69325532259479e+31*cos(theta)**8 - 4.5703726686457e+30*cos(theta)**6 + 3.23375424668328e+29*cos(theta)**4 - 7.60883352160772e+27*cos(theta)**2 + 2.58803861279174e+25)*cos(18*phi)

@torch.jit.script
def Yl30_m19(theta, phi):
    return 7.98179203850954e-28*(1.0 - cos(theta)**2)**9.5*(7.31912537364547e+32*cos(theta)**11 - 6.8229134839068e+32*cos(theta)**9 + 2.15460425807583e+32*cos(theta)**7 - 2.74222360118742e+31*cos(theta)**5 + 1.29350169867331e+30*cos(theta)**3 - 1.52176670432154e+28*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl30_m20(theta, phi):
    return 3.40344756082348e-29*(1.0 - cos(theta)**2)**10*(8.05103791101002e+33*cos(theta)**10 - 6.14062213551612e+33*cos(theta)**8 + 1.50822298065308e+33*cos(theta)**6 - 1.37111180059371e+32*cos(theta)**4 + 3.88050509601994e+30*cos(theta)**2 - 1.52176670432154e+28)*cos(20*phi)

@torch.jit.script
def Yl30_m21(theta, phi):
    return 1.5070719110102e-30*(1.0 - cos(theta)**2)**10.5*(8.05103791101002e+34*cos(theta)**9 - 4.9124977084129e+34*cos(theta)**7 + 9.04933788391849e+33*cos(theta)**5 - 5.48444720237484e+32*cos(theta)**3 + 7.76101019203987e+30*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl30_m22(theta, phi):
    return 6.96644237302409e-32*(1.0 - cos(theta)**2)**11*(7.24593411990902e+35*cos(theta)**8 - 3.43874839588903e+35*cos(theta)**6 + 4.52466894195925e+34*cos(theta)**4 - 1.64533416071245e+33*cos(theta)**2 + 7.76101019203987e+30)*cos(22*phi)

@torch.jit.script
def Yl30_m23(theta, phi):
    return 3.38320349392245e-33*(1.0 - cos(theta)**2)**11.5*(5.79674729592722e+36*cos(theta)**7 - 2.06324903753342e+36*cos(theta)**5 + 1.8098675767837e+35*cos(theta)**3 - 3.29066832142491e+33*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl30_m24(theta, phi):
    return 1.74013210905229e-34*(1.0 - cos(theta)**2)**12*(4.05772310714905e+37*cos(theta)**6 - 1.03162451876671e+37*cos(theta)**4 + 5.42960273035109e+35*cos(theta)**2 - 3.29066832142491e+33)*cos(24*phi)

@torch.jit.script
def Yl30_m25(theta, phi):
    return 9.57911199299742e-36*(1.0 - cos(theta)**2)**12.5*(2.43463386428943e+38*cos(theta)**5 - 4.12649807506683e+37*cos(theta)**3 + 1.08592054607022e+36*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl30_m26(theta, phi):
    return 5.72461435302436e-37*(1.0 - cos(theta)**2)**13*(1.21731693214472e+39*cos(theta)**4 - 1.23794942252005e+38*cos(theta)**2 + 1.08592054607022e+36)*cos(26*phi)

@torch.jit.script
def Yl30_m27(theta, phi):
    return 3.79121847114987e-38*(1.0 - cos(theta)**2)**13.5*(4.86926772857886e+39*cos(theta)**3 - 2.4758988450401e+38*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl30_m28(theta, phi):
    return 2.87411530575892e-39*(1.0 - cos(theta)**2)**14*(1.46078031857366e+40*cos(theta)**2 - 2.4758988450401e+38)*cos(28*phi)

@torch.jit.script
def Yl30_m29(theta, phi):
    return 7.72997498267602*(1.0 - cos(theta)**2)**14.5*cos(29*phi)*cos(theta)

@torch.jit.script
def Yl30_m30(theta, phi):
    return 0.997935479150139*(1.0 - cos(theta)**2)**15*cos(30*phi)

@torch.jit.script
def Yl31_m_minus_31(theta, phi):
    return 1.00595115393533*(1.0 - cos(theta)**2)**15.5*sin(31*phi)

@torch.jit.script
def Yl31_m_minus_30(theta, phi):
    return 7.92086730695805*(1.0 - cos(theta)**2)**15*sin(30*phi)*cos(theta)

@torch.jit.script
def Yl31_m_minus_29(theta, phi):
    return 4.90916821524168e-41*(1.0 - cos(theta)**2)**14.5*(8.91075994329932e+41*cos(theta)**2 - 1.46078031857366e+40)*sin(29*phi)

@torch.jit.script
def Yl31_m_minus_28(theta, phi):
    return 6.58634030535703e-40*(1.0 - cos(theta)**2)**14*(2.97025331443311e+41*cos(theta)**3 - 1.46078031857366e+40*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl31_m_minus_27(theta, phi):
    return 1.01181279661018e-38*(1.0 - cos(theta)**2)**13.5*(7.42563328608276e+40*cos(theta)**4 - 7.30390159286829e+39*cos(theta)**2 + 6.18974711260025e+37)*sin(27*phi)

@torch.jit.script
def Yl31_m_minus_26(theta, phi):
    return 1.72305510434632e-37*(1.0 - cos(theta)**2)**13*(1.48512665721655e+40*cos(theta)**5 - 2.43463386428943e+39*cos(theta)**3 + 6.18974711260025e+37*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl31_m_minus_25(theta, phi):
    return 3.18648750393588e-36*(1.0 - cos(theta)**2)**12.5*(2.47521109536092e+39*cos(theta)**6 - 6.08658466072358e+38*cos(theta)**4 + 3.09487355630012e+37*cos(theta)**2 - 1.8098675767837e+35)*sin(25*phi)

@torch.jit.script
def Yl31_m_minus_24(theta, phi):
    return 6.30892338215793e-35*(1.0 - cos(theta)**2)**12*(3.5360158505156e+38*cos(theta)**7 - 1.21731693214472e+38*cos(theta)**5 + 1.03162451876671e+37*cos(theta)**3 - 1.8098675767837e+35*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl31_m_minus_23(theta, phi):
    return 1.32337093312696e-33*(1.0 - cos(theta)**2)**11.5*(4.4200198131445e+37*cos(theta)**8 - 2.02886155357453e+37*cos(theta)**6 + 2.57906129691677e+36*cos(theta)**4 - 9.04933788391849e+34*cos(theta)**2 + 4.11333540178113e+32)*sin(23*phi)

@torch.jit.script
def Yl31_m_minus_22(theta, phi):
    return 2.9174251739327e-32*(1.0 - cos(theta)**2)**11*(4.91113312571611e+36*cos(theta)**9 - 2.89837364796361e+36*cos(theta)**7 + 5.15812259383354e+35*cos(theta)**5 - 3.01644596130616e+34*cos(theta)**3 + 4.11333540178113e+32*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl31_m_minus_21(theta, phi):
    return 6.7164171342413e-31*(1.0 - cos(theta)**2)**10.5*(4.91113312571611e+35*cos(theta)**10 - 3.62296705995451e+35*cos(theta)**8 + 8.59687098972257e+34*cos(theta)**6 - 7.54111490326541e+33*cos(theta)**4 + 2.05666770089057e+32*cos(theta)**2 - 7.76101019203987e+29)*sin(21*phi)

@torch.jit.script
def Yl31_m_minus_20(theta, phi):
    return 1.60633334701383e-29*(1.0 - cos(theta)**2)**10*(4.46466647792374e+34*cos(theta)**11 - 4.02551895550501e+34*cos(theta)**9 + 1.22812442710322e+34*cos(theta)**7 - 1.50822298065308e+33*cos(theta)**5 + 6.85555900296855e+31*cos(theta)**3 - 7.76101019203987e+29*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl31_m_minus_19(theta, phi):
    return 3.97384923581397e-28*(1.0 - cos(theta)**2)**9.5*(3.72055539826978e+33*cos(theta)**12 - 4.02551895550501e+33*cos(theta)**10 + 1.53515553387903e+33*cos(theta)**8 - 2.51370496775514e+32*cos(theta)**6 + 1.71388975074214e+31*cos(theta)**4 - 3.88050509601994e+29*cos(theta)**2 + 1.26813892026795e+27)*sin(19*phi)

@torch.jit.script
def Yl31_m_minus_18(theta, phi):
    return 1.01313673987456e-26*(1.0 - cos(theta)**2)**9*(2.86196569097676e+32*cos(theta)**13 - 3.65956268682274e+32*cos(theta)**11 + 1.7057283709767e+32*cos(theta)**9 - 3.59100709679305e+31*cos(theta)**7 + 3.42777950148428e+30*cos(theta)**5 - 1.29350169867331e+29*cos(theta)**3 + 1.26813892026795e+27*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl31_m_minus_17(theta, phi):
    return 2.6535673965946e-25*(1.0 - cos(theta)**2)**8.5*(2.04426120784054e+31*cos(theta)**14 - 3.04963557235228e+31*cos(theta)**12 + 1.7057283709767e+31*cos(theta)**10 - 4.48875887099132e+30*cos(theta)**8 + 5.71296583580713e+29*cos(theta)**6 - 3.23375424668328e+28*cos(theta)**4 + 6.34069460133976e+26*cos(theta)**2 - 1.84859900913696e+24)*sin(17*phi)

@torch.jit.script
def Yl31_m_minus_16(theta, phi):
    return 7.12026849799521e-24*(1.0 - cos(theta)**2)**8*(1.36284080522703e+30*cos(theta)**15 - 2.34587351719406e+30*cos(theta)**13 + 1.55066215543336e+30*cos(theta)**11 - 4.98750985665702e+29*cos(theta)**9 + 8.16137976543875e+28*cos(theta)**7 - 6.46750849336656e+27*cos(theta)**5 + 2.11356486711325e+26*cos(theta)**3 - 1.84859900913696e+24*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl31_m_minus_15(theta, phi):
    return 1.95256405937486e-22*(1.0 - cos(theta)**2)**7.5*(8.51775503266892e+28*cos(theta)**16 - 1.6756239408529e+29*cos(theta)**14 + 1.29221846286114e+29*cos(theta)**12 - 4.98750985665702e+28*cos(theta)**10 + 1.02017247067984e+28*cos(theta)**8 - 1.07791808222776e+27*cos(theta)**6 + 5.28391216778314e+25*cos(theta)**4 - 9.24299504568479e+23*cos(theta)**2 + 2.45824336321404e+21)*sin(15*phi)

@torch.jit.script
def Yl31_m_minus_14(theta, phi):
    return 5.46020147014982e-21*(1.0 - cos(theta)**2)**7*(5.01044413686407e+27*cos(theta)**17 - 1.11708262723527e+28*cos(theta)**15 + 9.94014202200874e+27*cos(theta)**13 - 4.5340998696882e+27*cos(theta)**11 + 1.13352496742205e+27*cos(theta)**9 - 1.53988297461109e+26*cos(theta)**7 + 1.05678243355663e+25*cos(theta)**5 - 3.0809983485616e+23*cos(theta)**3 + 2.45824336321404e+21*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl31_m_minus_13(theta, phi):
    return 1.5540005816166e-19*(1.0 - cos(theta)**2)**6.5*(2.78358007603559e+26*cos(theta)**18 - 6.98176642022042e+26*cos(theta)**16 + 7.10010144429196e+26*cos(theta)**14 - 3.7784165580735e+26*cos(theta)**12 + 1.13352496742205e+26*cos(theta)**10 - 1.92485371826386e+25*cos(theta)**8 + 1.76130405592771e+24*cos(theta)**6 - 7.70249587140399e+22*cos(theta)**4 + 1.22912168160702e+21*cos(theta)**2 - 3.03486834964696e+18)*sin(13*phi)

@torch.jit.script
def Yl31_m_minus_12(theta, phi):
    return 4.49318515889086e-18*(1.0 - cos(theta)**2)**6*(1.46504214528189e+25*cos(theta)**19 - 4.10692142365907e+25*cos(theta)**17 + 4.7334009628613e+25*cos(theta)**15 - 2.90647427544115e+25*cos(theta)**13 + 1.03047724311095e+25*cos(theta)**11 - 2.13872635362651e+24*cos(theta)**9 + 2.5161486513253e+23*cos(theta)**7 - 1.5404991742808e+22*cos(theta)**5 + 4.0970722720234e+20*cos(theta)**3 - 3.03486834964696e+18*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl31_m_minus_11(theta, phi):
    return 1.31766054315921e-16*(1.0 - cos(theta)**2)**5.5*(7.32521072640946e+23*cos(theta)**20 - 2.28162301314393e+24*cos(theta)**18 + 2.95837560178832e+24*cos(theta)**16 - 2.07605305388654e+24*cos(theta)**14 + 8.58731035925795e+23*cos(theta)**12 - 2.13872635362651e+23*cos(theta)**10 + 3.14518581415663e+22*cos(theta)**8 - 2.56749862380133e+21*cos(theta)**6 + 1.02426806800585e+20*cos(theta)**4 - 1.51743417482348e+18*cos(theta)**2 + 3.528916685636e+15)*sin(11*phi)

@torch.jit.script
def Yl31_m_minus_10(theta, phi):
    return 3.91325216255328e-15*(1.0 - cos(theta)**2)**5*(3.4881955840045e+22*cos(theta)**21 - 1.20085421744417e+23*cos(theta)**19 + 1.74022094222842e+23*cos(theta)**17 - 1.38403536925769e+23*cos(theta)**15 + 6.60562335327535e+22*cos(theta)**13 - 1.94429668511501e+22*cos(theta)**11 + 3.49465090461848e+21*cos(theta)**9 - 3.66785517685904e+20*cos(theta)**7 + 2.0485361360117e+19*cos(theta)**5 - 5.05811391607827e+17*cos(theta)**3 + 3.528916685636e+15*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl31_m_minus_9(theta, phi):
    return 1.17527934228125e-13*(1.0 - cos(theta)**2)**4.5*(1.58554344727477e+21*cos(theta)**22 - 6.00427108722087e+21*cos(theta)**20 + 9.66789412349123e+21*cos(theta)**18 - 8.65022105786057e+21*cos(theta)**16 + 4.71830239519667e+21*cos(theta)**14 - 1.62024723759584e+21*cos(theta)**12 + 3.49465090461848e+20*cos(theta)**10 - 4.5848189710738e+19*cos(theta)**8 + 3.41422689335283e+18*cos(theta)**6 - 1.26452847901957e+17*cos(theta)**4 + 1.764458342818e+15*cos(theta)**2 - 3912324485184.04)*sin(9*phi)

@torch.jit.script
def Yl31_m_minus_8(theta, phi):
    return 3.56479874579423e-12*(1.0 - cos(theta)**2)**4*(6.89366716206424e+19*cos(theta)**23 - 2.85917670820041e+20*cos(theta)**21 + 5.08836532815328e+20*cos(theta)**19 - 5.08836532815328e+20*cos(theta)**17 + 3.14553493013112e+20*cos(theta)**15 - 1.24634402891988e+20*cos(theta)**13 + 3.17695536783498e+19*cos(theta)**11 - 5.09424330119312e+18*cos(theta)**9 + 4.87746699050405e+17*cos(theta)**7 - 2.52905695803914e+16*cos(theta)**5 + 588152780939334.0*cos(theta)**3 - 3912324485184.04*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl31_m_minus_7(theta, phi):
    return 1.09061870201015e-10*(1.0 - cos(theta)**2)**3.5*(2.87236131752677e+18*cos(theta)**24 - 1.29962577645473e+19*cos(theta)**22 + 2.54418266407664e+19*cos(theta)**20 - 2.82686962675182e+19*cos(theta)**18 + 1.96595933133195e+19*cos(theta)**16 - 8.90245734942769e+18*cos(theta)**14 + 2.64746280652915e+18*cos(theta)**12 - 5.09424330119312e+17*cos(theta)**10 + 6.09683373813006e+16*cos(theta)**8 - 4.21509493006523e+15*cos(theta)**6 + 147038195234833.0*cos(theta)**4 - 1956162242592.02*cos(theta)**2 + 4179833851.69235)*sin(7*phi)

@torch.jit.script
def Yl31_m_minus_6(theta, phi):
    return 3.36151259928562e-9*(1.0 - cos(theta)**2)**3*(1.14894452701071e+17*cos(theta)**25 - 5.65054685415101e+17*cos(theta)**23 + 1.21151555432221e+18*cos(theta)**21 - 1.48782611934306e+18*cos(theta)**19 + 1.15644666548938e+18*cos(theta)**17 - 5.93497156628513e+17*cos(theta)**15 + 2.03650985117627e+17*cos(theta)**13 - 4.63113027381192e+16*cos(theta)**11 + 6.7742597090334e+15*cos(theta)**9 - 602156418580747.0*cos(theta)**7 + 29407639046966.7*cos(theta)**5 - 652054080864.006*cos(theta)**3 + 4179833851.69235*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl31_m_minus_5(theta, phi):
    return 1.04261094425773e-7*(1.0 - cos(theta)**2)**2.5*(4.41901741157964e+15*cos(theta)**26 - 2.35439452256292e+16*cos(theta)**24 + 5.50688888328277e+16*cos(theta)**22 - 7.43913059671532e+16*cos(theta)**20 + 6.42470369716323e+16*cos(theta)**18 - 3.7093572289282e+16*cos(theta)**16 + 1.45464989369733e+16*cos(theta)**14 - 3.8592752281766e+15*cos(theta)**12 + 677425970903340.0*cos(theta)**10 - 75269552322593.3*cos(theta)**8 + 4901273174494.45*cos(theta)**6 - 163013520216.002*cos(theta)**4 + 2089916925.84617*cos(theta)**2 - 4344941.63377583)*sin(5*phi)

@torch.jit.script
def Yl31_m_minus_4(theta, phi):
    return 3.25053923036716e-6*(1.0 - cos(theta)**2)**2*(163667311539987.0*cos(theta)**27 - 941757809025169.0*cos(theta)**25 + 2.39429951447077e+15*cos(theta)**23 - 3.54244314129301e+15*cos(theta)**21 + 3.38142299850696e+15*cos(theta)**19 - 2.181974840546e+15*cos(theta)**17 + 969766595798223.0*cos(theta)**15 - 296867325244354.0*cos(theta)**13 + 61584179173030.9*cos(theta)**11 - 8363283591399.26*cos(theta)**9 + 700181882070.635*cos(theta)**7 - 32602704043.2003*cos(theta)**5 + 696638975.282058*cos(theta)**3 - 4344941.63377583*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl31_m_minus_3(theta, phi):
    return 0.000101757973556832*(1.0 - cos(theta)**2)**1.5*(5845261126428.09*cos(theta)**28 - 36221454193275.7*cos(theta)**26 + 99762479769615.3*cos(theta)**24 - 161020142786046.0*cos(theta)**22 + 169071149925348.0*cos(theta)**20 - 121220824474778.0*cos(theta)**18 + 60610412237388.9*cos(theta)**16 - 21204808946025.3*cos(theta)**14 + 5132014931085.91*cos(theta)**12 - 836328359139.926*cos(theta)**10 + 87522735258.8294*cos(theta)**8 - 5433784007.20005*cos(theta)**6 + 174159743.820515*cos(theta)**4 - 2172470.81688792*cos(theta)**2 + 4433.61391201615)*sin(3*phi)

@torch.jit.script
def Yl31_m_minus_2(theta, phi):
    return 0.00319526518302305*(1.0 - cos(theta)**2)*(201560728497.52*cos(theta)**29 - 1341535340491.69*cos(theta)**27 + 3990499190784.61*cos(theta)**25 - 7000875773306.34*cos(theta)**23 + 8051007139302.29*cos(theta)**21 - 6380043393409.36*cos(theta)**19 + 3565318366905.23*cos(theta)**17 - 1413653929735.02*cos(theta)**15 + 394770379314.301*cos(theta)**13 - 76029850830.9023*cos(theta)**11 + 9724748362.09216*cos(theta)**9 - 776254858.171436*cos(theta)**7 + 34831948.7641029*cos(theta)**5 - 724156.938962638*cos(theta)**3 + 4433.61391201615*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl31_m_minus_1(theta, phi):
    return 0.100536671886138*(1.0 - cos(theta)**2)**0.5*(6718690949.91735*cos(theta)**30 - 47911976446.1319*cos(theta)**28 + 153480738107.101*cos(theta)**26 - 291703157221.098*cos(theta)**24 + 365954869968.286*cos(theta)**22 - 319002169670.468*cos(theta)**20 + 198073242605.846*cos(theta)**18 - 88353370608.4387*cos(theta)**16 + 28197884236.7358*cos(theta)**14 - 6335820902.57519*cos(theta)**12 + 972474836.209216*cos(theta)**10 - 97031857.2714295*cos(theta)**8 + 5805324.79401715*cos(theta)**6 - 181039.23474066*cos(theta)**4 + 2216.80695600808*cos(theta)**2 - 4.47839789092541)*sin(phi)

@torch.jit.script
def Yl31_m0(theta, phi):
    return 485275441.644494*cos(theta)**31 - 3699230825.65065*cos(theta)**29 + 12727861993.3404*cos(theta)**27 - 26125611460.0145*cos(theta)**25 + 35625833809.1107*cos(theta)**23 - 34012588504.5472*cos(theta)**21 + 23341972503.1206*cos(theta)**19 - 11636960052.5762*cos(theta)**17 + 4209113210.50627*cos(theta)**15 - 1091251573.09422*cos(theta)**13 + 197947959.770579*cos(theta)**11 - 24139995.0939731*cos(theta)**9 + 1856922.69953639*cos(theta)**7 - 81071.4692105284*cos(theta)**5 + 1654.5197798067*cos(theta)**3 - 10.0273926048891*cos(theta)

@torch.jit.script
def Yl31_m1(theta, phi):
    return 0.100536671886138*(1.0 - cos(theta)**2)**0.5*(6718690949.91735*cos(theta)**30 - 47911976446.1319*cos(theta)**28 + 153480738107.101*cos(theta)**26 - 291703157221.098*cos(theta)**24 + 365954869968.286*cos(theta)**22 - 319002169670.468*cos(theta)**20 + 198073242605.846*cos(theta)**18 - 88353370608.4387*cos(theta)**16 + 28197884236.7358*cos(theta)**14 - 6335820902.57519*cos(theta)**12 + 972474836.209216*cos(theta)**10 - 97031857.2714295*cos(theta)**8 + 5805324.79401715*cos(theta)**6 - 181039.23474066*cos(theta)**4 + 2216.80695600808*cos(theta)**2 - 4.47839789092541)*cos(phi)

@torch.jit.script
def Yl31_m2(theta, phi):
    return 0.00319526518302305*(1.0 - cos(theta)**2)*(201560728497.52*cos(theta)**29 - 1341535340491.69*cos(theta)**27 + 3990499190784.61*cos(theta)**25 - 7000875773306.34*cos(theta)**23 + 8051007139302.29*cos(theta)**21 - 6380043393409.36*cos(theta)**19 + 3565318366905.23*cos(theta)**17 - 1413653929735.02*cos(theta)**15 + 394770379314.301*cos(theta)**13 - 76029850830.9023*cos(theta)**11 + 9724748362.09216*cos(theta)**9 - 776254858.171436*cos(theta)**7 + 34831948.7641029*cos(theta)**5 - 724156.938962638*cos(theta)**3 + 4433.61391201615*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl31_m3(theta, phi):
    return 0.000101757973556832*(1.0 - cos(theta)**2)**1.5*(5845261126428.09*cos(theta)**28 - 36221454193275.7*cos(theta)**26 + 99762479769615.3*cos(theta)**24 - 161020142786046.0*cos(theta)**22 + 169071149925348.0*cos(theta)**20 - 121220824474778.0*cos(theta)**18 + 60610412237388.9*cos(theta)**16 - 21204808946025.3*cos(theta)**14 + 5132014931085.91*cos(theta)**12 - 836328359139.926*cos(theta)**10 + 87522735258.8294*cos(theta)**8 - 5433784007.20005*cos(theta)**6 + 174159743.820515*cos(theta)**4 - 2172470.81688792*cos(theta)**2 + 4433.61391201615)*cos(3*phi)

@torch.jit.script
def Yl31_m4(theta, phi):
    return 3.25053923036716e-6*(1.0 - cos(theta)**2)**2*(163667311539987.0*cos(theta)**27 - 941757809025169.0*cos(theta)**25 + 2.39429951447077e+15*cos(theta)**23 - 3.54244314129301e+15*cos(theta)**21 + 3.38142299850696e+15*cos(theta)**19 - 2.181974840546e+15*cos(theta)**17 + 969766595798223.0*cos(theta)**15 - 296867325244354.0*cos(theta)**13 + 61584179173030.9*cos(theta)**11 - 8363283591399.26*cos(theta)**9 + 700181882070.635*cos(theta)**7 - 32602704043.2003*cos(theta)**5 + 696638975.282058*cos(theta)**3 - 4344941.63377583*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl31_m5(theta, phi):
    return 1.04261094425773e-7*(1.0 - cos(theta)**2)**2.5*(4.41901741157964e+15*cos(theta)**26 - 2.35439452256292e+16*cos(theta)**24 + 5.50688888328277e+16*cos(theta)**22 - 7.43913059671532e+16*cos(theta)**20 + 6.42470369716323e+16*cos(theta)**18 - 3.7093572289282e+16*cos(theta)**16 + 1.45464989369733e+16*cos(theta)**14 - 3.8592752281766e+15*cos(theta)**12 + 677425970903340.0*cos(theta)**10 - 75269552322593.3*cos(theta)**8 + 4901273174494.45*cos(theta)**6 - 163013520216.002*cos(theta)**4 + 2089916925.84617*cos(theta)**2 - 4344941.63377583)*cos(5*phi)

@torch.jit.script
def Yl31_m6(theta, phi):
    return 3.36151259928562e-9*(1.0 - cos(theta)**2)**3*(1.14894452701071e+17*cos(theta)**25 - 5.65054685415101e+17*cos(theta)**23 + 1.21151555432221e+18*cos(theta)**21 - 1.48782611934306e+18*cos(theta)**19 + 1.15644666548938e+18*cos(theta)**17 - 5.93497156628513e+17*cos(theta)**15 + 2.03650985117627e+17*cos(theta)**13 - 4.63113027381192e+16*cos(theta)**11 + 6.7742597090334e+15*cos(theta)**9 - 602156418580747.0*cos(theta)**7 + 29407639046966.7*cos(theta)**5 - 652054080864.006*cos(theta)**3 + 4179833851.69235*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl31_m7(theta, phi):
    return 1.09061870201015e-10*(1.0 - cos(theta)**2)**3.5*(2.87236131752677e+18*cos(theta)**24 - 1.29962577645473e+19*cos(theta)**22 + 2.54418266407664e+19*cos(theta)**20 - 2.82686962675182e+19*cos(theta)**18 + 1.96595933133195e+19*cos(theta)**16 - 8.90245734942769e+18*cos(theta)**14 + 2.64746280652915e+18*cos(theta)**12 - 5.09424330119312e+17*cos(theta)**10 + 6.09683373813006e+16*cos(theta)**8 - 4.21509493006523e+15*cos(theta)**6 + 147038195234833.0*cos(theta)**4 - 1956162242592.02*cos(theta)**2 + 4179833851.69235)*cos(7*phi)

@torch.jit.script
def Yl31_m8(theta, phi):
    return 3.56479874579423e-12*(1.0 - cos(theta)**2)**4*(6.89366716206424e+19*cos(theta)**23 - 2.85917670820041e+20*cos(theta)**21 + 5.08836532815328e+20*cos(theta)**19 - 5.08836532815328e+20*cos(theta)**17 + 3.14553493013112e+20*cos(theta)**15 - 1.24634402891988e+20*cos(theta)**13 + 3.17695536783498e+19*cos(theta)**11 - 5.09424330119312e+18*cos(theta)**9 + 4.87746699050405e+17*cos(theta)**7 - 2.52905695803914e+16*cos(theta)**5 + 588152780939334.0*cos(theta)**3 - 3912324485184.04*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl31_m9(theta, phi):
    return 1.17527934228125e-13*(1.0 - cos(theta)**2)**4.5*(1.58554344727477e+21*cos(theta)**22 - 6.00427108722087e+21*cos(theta)**20 + 9.66789412349123e+21*cos(theta)**18 - 8.65022105786057e+21*cos(theta)**16 + 4.71830239519667e+21*cos(theta)**14 - 1.62024723759584e+21*cos(theta)**12 + 3.49465090461848e+20*cos(theta)**10 - 4.5848189710738e+19*cos(theta)**8 + 3.41422689335283e+18*cos(theta)**6 - 1.26452847901957e+17*cos(theta)**4 + 1.764458342818e+15*cos(theta)**2 - 3912324485184.04)*cos(9*phi)

@torch.jit.script
def Yl31_m10(theta, phi):
    return 3.91325216255328e-15*(1.0 - cos(theta)**2)**5*(3.4881955840045e+22*cos(theta)**21 - 1.20085421744417e+23*cos(theta)**19 + 1.74022094222842e+23*cos(theta)**17 - 1.38403536925769e+23*cos(theta)**15 + 6.60562335327535e+22*cos(theta)**13 - 1.94429668511501e+22*cos(theta)**11 + 3.49465090461848e+21*cos(theta)**9 - 3.66785517685904e+20*cos(theta)**7 + 2.0485361360117e+19*cos(theta)**5 - 5.05811391607827e+17*cos(theta)**3 + 3.528916685636e+15*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl31_m11(theta, phi):
    return 1.31766054315921e-16*(1.0 - cos(theta)**2)**5.5*(7.32521072640946e+23*cos(theta)**20 - 2.28162301314393e+24*cos(theta)**18 + 2.95837560178832e+24*cos(theta)**16 - 2.07605305388654e+24*cos(theta)**14 + 8.58731035925795e+23*cos(theta)**12 - 2.13872635362651e+23*cos(theta)**10 + 3.14518581415663e+22*cos(theta)**8 - 2.56749862380133e+21*cos(theta)**6 + 1.02426806800585e+20*cos(theta)**4 - 1.51743417482348e+18*cos(theta)**2 + 3.528916685636e+15)*cos(11*phi)

@torch.jit.script
def Yl31_m12(theta, phi):
    return 4.49318515889086e-18*(1.0 - cos(theta)**2)**6*(1.46504214528189e+25*cos(theta)**19 - 4.10692142365907e+25*cos(theta)**17 + 4.7334009628613e+25*cos(theta)**15 - 2.90647427544115e+25*cos(theta)**13 + 1.03047724311095e+25*cos(theta)**11 - 2.13872635362651e+24*cos(theta)**9 + 2.5161486513253e+23*cos(theta)**7 - 1.5404991742808e+22*cos(theta)**5 + 4.0970722720234e+20*cos(theta)**3 - 3.03486834964696e+18*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl31_m13(theta, phi):
    return 1.5540005816166e-19*(1.0 - cos(theta)**2)**6.5*(2.78358007603559e+26*cos(theta)**18 - 6.98176642022042e+26*cos(theta)**16 + 7.10010144429196e+26*cos(theta)**14 - 3.7784165580735e+26*cos(theta)**12 + 1.13352496742205e+26*cos(theta)**10 - 1.92485371826386e+25*cos(theta)**8 + 1.76130405592771e+24*cos(theta)**6 - 7.70249587140399e+22*cos(theta)**4 + 1.22912168160702e+21*cos(theta)**2 - 3.03486834964696e+18)*cos(13*phi)

@torch.jit.script
def Yl31_m14(theta, phi):
    return 5.46020147014982e-21*(1.0 - cos(theta)**2)**7*(5.01044413686407e+27*cos(theta)**17 - 1.11708262723527e+28*cos(theta)**15 + 9.94014202200874e+27*cos(theta)**13 - 4.5340998696882e+27*cos(theta)**11 + 1.13352496742205e+27*cos(theta)**9 - 1.53988297461109e+26*cos(theta)**7 + 1.05678243355663e+25*cos(theta)**5 - 3.0809983485616e+23*cos(theta)**3 + 2.45824336321404e+21*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl31_m15(theta, phi):
    return 1.95256405937486e-22*(1.0 - cos(theta)**2)**7.5*(8.51775503266892e+28*cos(theta)**16 - 1.6756239408529e+29*cos(theta)**14 + 1.29221846286114e+29*cos(theta)**12 - 4.98750985665702e+28*cos(theta)**10 + 1.02017247067984e+28*cos(theta)**8 - 1.07791808222776e+27*cos(theta)**6 + 5.28391216778314e+25*cos(theta)**4 - 9.24299504568479e+23*cos(theta)**2 + 2.45824336321404e+21)*cos(15*phi)

@torch.jit.script
def Yl31_m16(theta, phi):
    return 7.12026849799521e-24*(1.0 - cos(theta)**2)**8*(1.36284080522703e+30*cos(theta)**15 - 2.34587351719406e+30*cos(theta)**13 + 1.55066215543336e+30*cos(theta)**11 - 4.98750985665702e+29*cos(theta)**9 + 8.16137976543875e+28*cos(theta)**7 - 6.46750849336656e+27*cos(theta)**5 + 2.11356486711325e+26*cos(theta)**3 - 1.84859900913696e+24*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl31_m17(theta, phi):
    return 2.6535673965946e-25*(1.0 - cos(theta)**2)**8.5*(2.04426120784054e+31*cos(theta)**14 - 3.04963557235228e+31*cos(theta)**12 + 1.7057283709767e+31*cos(theta)**10 - 4.48875887099132e+30*cos(theta)**8 + 5.71296583580713e+29*cos(theta)**6 - 3.23375424668328e+28*cos(theta)**4 + 6.34069460133976e+26*cos(theta)**2 - 1.84859900913696e+24)*cos(17*phi)

@torch.jit.script
def Yl31_m18(theta, phi):
    return 1.01313673987456e-26*(1.0 - cos(theta)**2)**9*(2.86196569097676e+32*cos(theta)**13 - 3.65956268682274e+32*cos(theta)**11 + 1.7057283709767e+32*cos(theta)**9 - 3.59100709679305e+31*cos(theta)**7 + 3.42777950148428e+30*cos(theta)**5 - 1.29350169867331e+29*cos(theta)**3 + 1.26813892026795e+27*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl31_m19(theta, phi):
    return 3.97384923581397e-28*(1.0 - cos(theta)**2)**9.5*(3.72055539826978e+33*cos(theta)**12 - 4.02551895550501e+33*cos(theta)**10 + 1.53515553387903e+33*cos(theta)**8 - 2.51370496775514e+32*cos(theta)**6 + 1.71388975074214e+31*cos(theta)**4 - 3.88050509601994e+29*cos(theta)**2 + 1.26813892026795e+27)*cos(19*phi)

@torch.jit.script
def Yl31_m20(theta, phi):
    return 1.60633334701383e-29*(1.0 - cos(theta)**2)**10*(4.46466647792374e+34*cos(theta)**11 - 4.02551895550501e+34*cos(theta)**9 + 1.22812442710322e+34*cos(theta)**7 - 1.50822298065308e+33*cos(theta)**5 + 6.85555900296855e+31*cos(theta)**3 - 7.76101019203987e+29*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl31_m21(theta, phi):
    return 6.7164171342413e-31*(1.0 - cos(theta)**2)**10.5*(4.91113312571611e+35*cos(theta)**10 - 3.62296705995451e+35*cos(theta)**8 + 8.59687098972257e+34*cos(theta)**6 - 7.54111490326541e+33*cos(theta)**4 + 2.05666770089057e+32*cos(theta)**2 - 7.76101019203987e+29)*cos(21*phi)

@torch.jit.script
def Yl31_m22(theta, phi):
    return 2.9174251739327e-32*(1.0 - cos(theta)**2)**11*(4.91113312571611e+36*cos(theta)**9 - 2.89837364796361e+36*cos(theta)**7 + 5.15812259383354e+35*cos(theta)**5 - 3.01644596130616e+34*cos(theta)**3 + 4.11333540178113e+32*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl31_m23(theta, phi):
    return 1.32337093312696e-33*(1.0 - cos(theta)**2)**11.5*(4.4200198131445e+37*cos(theta)**8 - 2.02886155357453e+37*cos(theta)**6 + 2.57906129691677e+36*cos(theta)**4 - 9.04933788391849e+34*cos(theta)**2 + 4.11333540178113e+32)*cos(23*phi)

@torch.jit.script
def Yl31_m24(theta, phi):
    return 6.30892338215793e-35*(1.0 - cos(theta)**2)**12*(3.5360158505156e+38*cos(theta)**7 - 1.21731693214472e+38*cos(theta)**5 + 1.03162451876671e+37*cos(theta)**3 - 1.8098675767837e+35*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl31_m25(theta, phi):
    return 3.18648750393588e-36*(1.0 - cos(theta)**2)**12.5*(2.47521109536092e+39*cos(theta)**6 - 6.08658466072358e+38*cos(theta)**4 + 3.09487355630012e+37*cos(theta)**2 - 1.8098675767837e+35)*cos(25*phi)

@torch.jit.script
def Yl31_m26(theta, phi):
    return 1.72305510434632e-37*(1.0 - cos(theta)**2)**13*(1.48512665721655e+40*cos(theta)**5 - 2.43463386428943e+39*cos(theta)**3 + 6.18974711260025e+37*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl31_m27(theta, phi):
    return 1.01181279661018e-38*(1.0 - cos(theta)**2)**13.5*(7.42563328608276e+40*cos(theta)**4 - 7.30390159286829e+39*cos(theta)**2 + 6.18974711260025e+37)*cos(27*phi)

@torch.jit.script
def Yl31_m28(theta, phi):
    return 6.58634030535703e-40*(1.0 - cos(theta)**2)**14*(2.97025331443311e+41*cos(theta)**3 - 1.46078031857366e+40*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl31_m29(theta, phi):
    return 4.90916821524168e-41*(1.0 - cos(theta)**2)**14.5*(8.91075994329932e+41*cos(theta)**2 - 1.46078031857366e+40)*cos(29*phi)

@torch.jit.script
def Yl31_m30(theta, phi):
    return 7.92086730695805*(1.0 - cos(theta)**2)**15*cos(30*phi)*cos(theta)

@torch.jit.script
def Yl31_m31(theta, phi):
    return 1.00595115393533*(1.0 - cos(theta)**2)**15.5*cos(31*phi)

@torch.jit.script
def Yl32_m_minus_32(theta, phi):
    return 1.01377968565312*(1.0 - cos(theta)**2)**16*sin(32*phi)

@torch.jit.script
def Yl32_m_minus_31(theta, phi):
    return 8.11023748522498*(1.0 - cos(theta)**2)**15.5*sin(31*phi)*cos(theta)

@torch.jit.script
def Yl32_m_minus_30(theta, phi):
    return 8.10836994187712e-43*(1.0 - cos(theta)**2)**15*(5.61377876427857e+43*cos(theta)**2 - 8.91075994329932e+41)*sin(30*phi)

@torch.jit.script
def Yl32_m_minus_29(theta, phi):
    return 1.10583422533699e-41*(1.0 - cos(theta)**2)**14.5*(1.87125958809286e+43*cos(theta)**3 - 8.91075994329932e+41*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl32_m_minus_28(theta, phi):
    return 1.72736828000894e-40*(1.0 - cos(theta)**2)**14*(4.67814897023214e+42*cos(theta)**4 - 4.45537997164966e+41*cos(theta)**2 + 3.65195079643415e+39)*sin(28*phi)

@torch.jit.script
def Yl32_m_minus_27(theta, phi):
    return 2.99188962435835e-39*(1.0 - cos(theta)**2)**13.5*(9.35629794046428e+41*cos(theta)**5 - 1.48512665721655e+41*cos(theta)**3 + 3.65195079643415e+39*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl32_m_minus_26(theta, phi):
    return 5.62920673595975e-38*(1.0 - cos(theta)**2)**13*(1.55938299007738e+41*cos(theta)**6 - 3.71281664304138e+40*cos(theta)**4 + 1.82597539821707e+39*cos(theta)**2 - 1.03162451876671e+37)*sin(26*phi)

@torch.jit.script
def Yl32_m_minus_25(theta, phi):
    return 1.13425372828688e-36*(1.0 - cos(theta)**2)**12.5*(2.22768998582483e+40*cos(theta)**7 - 7.42563328608276e+39*cos(theta)**5 + 6.08658466072358e+38*cos(theta)**3 - 1.03162451876671e+37*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl32_m_minus_24(theta, phi):
    return 2.42210316291546e-35*(1.0 - cos(theta)**2)**12*(2.78461248228104e+39*cos(theta)**8 - 1.23760554768046e+39*cos(theta)**6 + 1.52164616518089e+38*cos(theta)**4 - 5.15812259383354e+36*cos(theta)**2 + 2.26233447097962e+34)*sin(24*phi)

@torch.jit.script
def Yl32_m_minus_23(theta, phi):
    return 5.43760811463069e-34*(1.0 - cos(theta)**2)**11.5*(3.09401386920115e+38*cos(theta)**9 - 1.7680079252578e+38*cos(theta)**7 + 3.04329233036179e+37*cos(theta)**5 - 1.71937419794451e+36*cos(theta)**3 + 2.26233447097962e+34*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl32_m_minus_22(theta, phi):
    return 1.27523213983038e-32*(1.0 - cos(theta)**2)**11*(3.09401386920115e+37*cos(theta)**10 - 2.21000990657225e+37*cos(theta)**8 + 5.07215388393631e+36*cos(theta)**6 - 4.29843549486128e+35*cos(theta)**4 + 1.13116723548981e+34*cos(theta)**2 - 4.11333540178113e+31)*sin(22*phi)

@torch.jit.script
def Yl32_m_minus_21(theta, phi):
    return 3.10801046364243e-31*(1.0 - cos(theta)**2)**10.5*(2.81273988109196e+36*cos(theta)**11 - 2.45556656285806e+36*cos(theta)**9 + 7.24593411990902e+35*cos(theta)**7 - 8.59687098972257e+34*cos(theta)**5 + 3.7705574516327e+33*cos(theta)**3 - 4.11333540178113e+31*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl32_m_minus_20(theta, phi):
    return 7.83810415265227e-30*(1.0 - cos(theta)**2)**10*(2.34394990090996e+35*cos(theta)**12 - 2.45556656285806e+35*cos(theta)**10 + 9.05741764988628e+34*cos(theta)**8 - 1.43281183162043e+34*cos(theta)**6 + 9.42639362908176e+32*cos(theta)**4 - 2.05666770089057e+31*cos(theta)**2 + 6.46750849336656e+28)*sin(20*phi)

@torch.jit.script
def Yl32_m_minus_19(theta, phi):
    return 2.03790707968959e-28*(1.0 - cos(theta)**2)**9.5*(1.80303838531536e+34*cos(theta)**13 - 2.23233323896187e+34*cos(theta)**11 + 1.00637973887625e+34*cos(theta)**9 - 2.04687404517204e+33*cos(theta)**7 + 1.88527872581635e+32*cos(theta)**5 - 6.85555900296855e+30*cos(theta)**3 + 6.46750849336656e+28*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl32_m_minus_18(theta, phi):
    return 5.44544635409307e-27*(1.0 - cos(theta)**2)**9*(1.28788456093954e+33*cos(theta)**14 - 1.86027769913489e+33*cos(theta)**12 + 1.00637973887625e+33*cos(theta)**10 - 2.55859255646505e+32*cos(theta)**8 + 3.14213120969392e+31*cos(theta)**6 - 1.71388975074214e+30*cos(theta)**4 + 3.23375424668328e+28*cos(theta)**2 - 9.05813514477109e+25)*sin(18*phi)

@torch.jit.script
def Yl32_m_minus_17(theta, phi):
    return 1.49129690191052e-25*(1.0 - cos(theta)**2)**8.5*(8.58589707293027e+31*cos(theta)**15 - 1.43098284548838e+32*cos(theta)**13 + 9.14890671705684e+31*cos(theta)**11 - 2.8428806182945e+31*cos(theta)**9 + 4.48875887099132e+30*cos(theta)**7 - 3.42777950148428e+29*cos(theta)**5 + 1.07791808222776e+28*cos(theta)**3 - 9.05813514477109e+25*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl32_m_minus_16(theta, phi):
    return 4.17563132534946e-24*(1.0 - cos(theta)**2)**8*(5.36618567058142e+30*cos(theta)**16 - 1.02213060392027e+31*cos(theta)**14 + 7.6240889308807e+30*cos(theta)**12 - 2.8428806182945e+30*cos(theta)**10 + 5.61094858873914e+29*cos(theta)**8 - 5.71296583580713e+28*cos(theta)**6 + 2.6947952055694e+27*cos(theta)**4 - 4.52906757238555e+25*cos(theta)**2 + 1.1553743807106e+23)*sin(16*phi)

@torch.jit.script
def Yl32_m_minus_15(theta, phi):
    return 1.19279889015859e-22*(1.0 - cos(theta)**2)**7.5*(3.15657980622436e+29*cos(theta)**17 - 6.81420402613513e+29*cos(theta)**15 + 5.86468379298516e+29*cos(theta)**13 - 2.58443692572227e+29*cos(theta)**11 + 6.23438732082127e+28*cos(theta)**9 - 8.16137976543875e+27*cos(theta)**7 + 5.3895904111388e+26*cos(theta)**5 - 1.50968919079518e+25*cos(theta)**3 + 1.1553743807106e+23*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl32_m_minus_14(theta, phi):
    return 3.4693842922622e-21*(1.0 - cos(theta)**2)**7*(1.75365544790242e+28*cos(theta)**18 - 4.25887751633446e+28*cos(theta)**16 + 4.18905985213225e+28*cos(theta)**14 - 2.15369743810189e+28*cos(theta)**12 + 6.23438732082127e+27*cos(theta)**10 - 1.02017247067984e+27*cos(theta)**8 + 8.98265068523133e+25*cos(theta)**6 - 3.77422297698796e+24*cos(theta)**4 + 5.77687190355299e+22*cos(theta)**2 - 1.36569075734113e+20)*sin(14*phi)

@torch.jit.script
def Yl32_m_minus_13(theta, phi):
    return 1.02567111293552e-19*(1.0 - cos(theta)**2)**6.5*(9.22976551527592e+26*cos(theta)**19 - 2.50522206843203e+27*cos(theta)**17 + 2.79270656808817e+27*cos(theta)**15 - 1.65669033700146e+27*cos(theta)**13 + 5.66762483711025e+26*cos(theta)**11 - 1.13352496742205e+26*cos(theta)**9 + 1.2832358121759e+25*cos(theta)**7 - 7.54844595397591e+23*cos(theta)**5 + 1.925623967851e+22*cos(theta)**3 - 1.36569075734113e+20*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl32_m_minus_12(theta, phi):
    return 3.07701333880655e-18*(1.0 - cos(theta)**2)**6*(4.61488275763796e+25*cos(theta)**20 - 1.3917900380178e+26*cos(theta)**18 + 1.74544160505511e+26*cos(theta)**16 - 1.18335024071533e+26*cos(theta)**14 + 4.72302069759187e+25*cos(theta)**12 - 1.13352496742205e+25*cos(theta)**10 + 1.60404476521988e+24*cos(theta)**8 - 1.25807432566265e+23*cos(theta)**6 + 4.81405991962749e+21*cos(theta)**4 - 6.82845378670567e+19*cos(theta)**2 + 1.51743417482348e+17)*sin(12*phi)

@torch.jit.script
def Yl32_m_minus_11(theta, phi):
    return 9.35331077456894e-17*(1.0 - cos(theta)**2)**5.5*(2.19756321792284e+24*cos(theta)**21 - 7.32521072640946e+24*cos(theta)**19 + 1.02673035591477e+25*cos(theta)**17 - 7.88900160476884e+24*cos(theta)**15 + 3.63309284430144e+24*cos(theta)**13 - 1.03047724311095e+24*cos(theta)**11 + 1.78227196135542e+23*cos(theta)**9 - 1.79724903666093e+22*cos(theta)**7 + 9.62811983925499e+20*cos(theta)**5 - 2.27615126223522e+19*cos(theta)**3 + 1.51743417482348e+17*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl32_m_minus_10(theta, phi):
    return 2.87680836403125e-15*(1.0 - cos(theta)**2)**5*(9.98892371783108e+22*cos(theta)**22 - 3.66260536320473e+23*cos(theta)**20 + 5.70405753285982e+23*cos(theta)**18 - 4.93062600298053e+23*cos(theta)**16 + 2.59506631735817e+23*cos(theta)**14 - 8.58731035925795e+22*cos(theta)**12 + 1.78227196135542e+22*cos(theta)**10 - 2.24656129582616e+21*cos(theta)**8 + 1.60468663987583e+20*cos(theta)**6 - 5.69037815558805e+18*cos(theta)**4 + 7.58717087411741e+16*cos(theta)**2 - 160405303892546.0)*sin(10*phi)

@torch.jit.script
def Yl32_m_minus_9(theta, phi):
    return 8.9412758972117e-14*(1.0 - cos(theta)**2)**4.5*(4.34301031210047e+21*cos(theta)**23 - 1.74409779200225e+22*cos(theta)**21 + 3.00213554361043e+22*cos(theta)**19 - 2.90036823704737e+22*cos(theta)**17 + 1.73004421157211e+22*cos(theta)**15 - 6.60562335327535e+21*cos(theta)**13 + 1.62024723759584e+21*cos(theta)**11 - 2.49617921758463e+20*cos(theta)**9 + 2.2924094855369e+19*cos(theta)**7 - 1.13807563111761e+18*cos(theta)**5 + 2.52905695803914e+16*cos(theta)**3 - 160405303892546.0*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl32_m_minus_8(theta, phi):
    return 2.80476865419125e-12*(1.0 - cos(theta)**2)**4*(1.80958763004186e+20*cos(theta)**24 - 7.92771723637387e+20*cos(theta)**22 + 1.50106777180522e+21*cos(theta)**20 - 1.61131568724854e+21*cos(theta)**18 + 1.08127763223257e+21*cos(theta)**16 - 4.71830239519668e+20*cos(theta)**14 + 1.35020603132987e+20*cos(theta)**12 - 2.49617921758463e+19*cos(theta)**10 + 2.86551185692113e+18*cos(theta)**8 - 1.89679271852935e+17*cos(theta)**6 + 6.32264239509784e+15*cos(theta)**4 - 80202651946272.8*cos(theta)**2 + 163013520216.002)*sin(8*phi)

@torch.jit.script
def Yl32_m_minus_7(theta, phi):
    return 8.86945725708952e-11*(1.0 - cos(theta)**2)**3.5*(7.23835052016745e+18*cos(theta)**25 - 3.44683358103212e+19*cos(theta)**23 + 7.14794177050103e+19*cos(theta)**21 - 8.48060888025546e+19*cos(theta)**19 + 6.3604566601916e+19*cos(theta)**17 - 3.14553493013112e+19*cos(theta)**15 + 1.0386200240999e+19*cos(theta)**13 - 2.26925383416784e+18*cos(theta)**11 + 3.1839020632457e+17*cos(theta)**9 - 2.70970388361336e+16*cos(theta)**7 + 1.26452847901957e+15*cos(theta)**5 - 26734217315424.3*cos(theta)**3 + 163013520216.002*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl32_m_minus_6(theta, phi):
    return 2.8243337947883e-9*(1.0 - cos(theta)**2)**3*(2.78398096929517e+17*cos(theta)**26 - 1.43618065876338e+18*cos(theta)**24 + 3.24906444113683e+18*cos(theta)**22 - 4.24030444012773e+18*cos(theta)**20 + 3.53358703343978e+18*cos(theta)**18 - 1.96595933133195e+18*cos(theta)**16 + 7.41871445785641e+17*cos(theta)**14 - 1.89104486180654e+17*cos(theta)**12 + 3.1839020632457e+16*cos(theta)**10 - 3.3871298545167e+15*cos(theta)**8 + 210754746503261.0*cos(theta)**6 - 6683554328856.07*cos(theta)**4 + 81506760108.0008*cos(theta)**2 - 160762840.449706)*sin(6*phi)

@torch.jit.script
def Yl32_m_minus_5(theta, phi):
    return 9.04668988104336e-8*(1.0 - cos(theta)**2)**2.5*(1.03110406270192e+16*cos(theta)**27 - 5.74472263505353e+16*cos(theta)**25 + 1.41263671353775e+17*cos(theta)**23 - 2.01919259053701e+17*cos(theta)**21 + 1.85978264917883e+17*cos(theta)**19 - 1.15644666548938e+17*cos(theta)**17 + 4.94580963857094e+16*cos(theta)**15 - 1.45464989369733e+16*cos(theta)**13 + 2.89445642113245e+15*cos(theta)**11 - 376347761612967.0*cos(theta)**9 + 30107820929037.3*cos(theta)**7 - 1336710865771.21*cos(theta)**5 + 27168920036.0003*cos(theta)**3 - 160762840.449706*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl32_m_minus_4(theta, phi):
    return 2.91185389957512e-6*(1.0 - cos(theta)**2)**2*(368251450964970.0*cos(theta)**28 - 2.20950870578982e+15*cos(theta)**26 + 5.88598630640731e+15*cos(theta)**24 - 9.17814813880461e+15*cos(theta)**22 + 9.29891324589415e+15*cos(theta)**20 - 6.42470369716323e+15*cos(theta)**18 + 3.09113102410684e+15*cos(theta)**16 - 1.03903563835524e+15*cos(theta)**14 + 241204701761038.0*cos(theta)**12 - 37634776161296.7*cos(theta)**10 + 3763477616129.67*cos(theta)**8 - 222785144295.202*cos(theta)**6 + 6792230009.00007*cos(theta)**4 - 80381420.2248529*cos(theta)**2 + 155176.486920565)*sin(4*phi)

@torch.jit.script
def Yl32_m_minus_3(theta, phi):
    return 9.40848788610558e-5*(1.0 - cos(theta)**2)**1.5*(12698325895343.8*cos(theta)**29 - 81833655769993.3*cos(theta)**27 + 235439452256292.0*cos(theta)**25 - 399049919078461.0*cos(theta)**23 + 442805392661626.0*cos(theta)**21 - 338142299850696.0*cos(theta)**19 + 181831236712167.0*cos(theta)**17 - 69269042557015.9*cos(theta)**15 + 18554207827772.1*cos(theta)**13 - 3421343287390.6*cos(theta)**11 + 418164179569.963*cos(theta)**9 - 31826449185.0289*cos(theta)**7 + 1358446001.80001*cos(theta)**5 - 26793806.7416176*cos(theta)**3 + 155176.486920565*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl32_m_minus_2(theta, phi):
    return 0.00304869851769809*(1.0 - cos(theta)**2)*(423277529844.793*cos(theta)**30 - 2922630563214.05*cos(theta)**28 + 9055363548318.93*cos(theta)**26 - 16627079961602.6*cos(theta)**24 + 20127517848255.7*cos(theta)**22 - 16907114992534.8*cos(theta)**20 + 10101735372898.2*cos(theta)**18 - 4329315159813.5*cos(theta)**16 + 1325300559126.58*cos(theta)**14 - 285111940615.884*cos(theta)**12 + 41816417956.9963*cos(theta)**10 - 3978306148.12861*cos(theta)**8 + 226407666.966669*cos(theta)**6 - 6698451.6854044*cos(theta)**4 + 77588.2434602827*cos(theta)**2 - 147.787130400538)*sin(2*phi)

@torch.jit.script
def Yl32_m_minus_1(theta, phi):
    return 0.0989771136930781*(1.0 - cos(theta)**2)**0.5*(13654113865.9611*cos(theta)**31 - 100780364248.76*cos(theta)**29 + 335383835122.923*cos(theta)**27 - 665083198464.102*cos(theta)**25 + 875109471663.293*cos(theta)**23 - 805100713930.229*cos(theta)**21 + 531670282784.114*cos(theta)**19 - 254665597636.088*cos(theta)**17 + 88353370608.4387*cos(theta)**15 - 21931687739.6834*cos(theta)**13 + 3801492541.54512*cos(theta)**11 - 442034016.458735*cos(theta)**9 + 32343952.4238098*cos(theta)**7 - 1339690.33708088*cos(theta)**5 + 25862.7478200942*cos(theta)**3 - 147.787130400538*cos(theta))*sin(phi)

@torch.jit.script
def Yl32_m0(theta, phi):
    return 970432400.607318*cos(theta)**32 - 7640229693.67032*cos(theta)**30 + 27241802596.2835*cos(theta)**28 - 58177408934.436*cos(theta)**26 + 82928324138.9986*cos(theta)**24 - 83229881681.3223*cos(theta)**22 + 60459442353.4133*cos(theta)**20 - 32177294249.7158*cos(theta)**18 + 12558994949.5064*cos(theta)**16 - 3562835446.66849*cos(theta)**14 + 720484501.437405*cos(theta)**12 - 100532721.130801*cos(theta)**10 + 9195065.95708543*cos(theta)**8 - 507814.293487953*cos(theta)**6 + 14705.0471087245*cos(theta)**4 - 168.057681242566*cos(theta)**2 + 0.318291062959405

@torch.jit.script
def Yl32_m1(theta, phi):
    return 0.0989771136930781*(1.0 - cos(theta)**2)**0.5*(13654113865.9611*cos(theta)**31 - 100780364248.76*cos(theta)**29 + 335383835122.923*cos(theta)**27 - 665083198464.102*cos(theta)**25 + 875109471663.293*cos(theta)**23 - 805100713930.229*cos(theta)**21 + 531670282784.114*cos(theta)**19 - 254665597636.088*cos(theta)**17 + 88353370608.4387*cos(theta)**15 - 21931687739.6834*cos(theta)**13 + 3801492541.54512*cos(theta)**11 - 442034016.458735*cos(theta)**9 + 32343952.4238098*cos(theta)**7 - 1339690.33708088*cos(theta)**5 + 25862.7478200942*cos(theta)**3 - 147.787130400538*cos(theta))*cos(phi)

@torch.jit.script
def Yl32_m2(theta, phi):
    return 0.00304869851769809*(1.0 - cos(theta)**2)*(423277529844.793*cos(theta)**30 - 2922630563214.05*cos(theta)**28 + 9055363548318.93*cos(theta)**26 - 16627079961602.6*cos(theta)**24 + 20127517848255.7*cos(theta)**22 - 16907114992534.8*cos(theta)**20 + 10101735372898.2*cos(theta)**18 - 4329315159813.5*cos(theta)**16 + 1325300559126.58*cos(theta)**14 - 285111940615.884*cos(theta)**12 + 41816417956.9963*cos(theta)**10 - 3978306148.12861*cos(theta)**8 + 226407666.966669*cos(theta)**6 - 6698451.6854044*cos(theta)**4 + 77588.2434602827*cos(theta)**2 - 147.787130400538)*cos(2*phi)

@torch.jit.script
def Yl32_m3(theta, phi):
    return 9.40848788610558e-5*(1.0 - cos(theta)**2)**1.5*(12698325895343.8*cos(theta)**29 - 81833655769993.3*cos(theta)**27 + 235439452256292.0*cos(theta)**25 - 399049919078461.0*cos(theta)**23 + 442805392661626.0*cos(theta)**21 - 338142299850696.0*cos(theta)**19 + 181831236712167.0*cos(theta)**17 - 69269042557015.9*cos(theta)**15 + 18554207827772.1*cos(theta)**13 - 3421343287390.6*cos(theta)**11 + 418164179569.963*cos(theta)**9 - 31826449185.0289*cos(theta)**7 + 1358446001.80001*cos(theta)**5 - 26793806.7416176*cos(theta)**3 + 155176.486920565*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl32_m4(theta, phi):
    return 2.91185389957512e-6*(1.0 - cos(theta)**2)**2*(368251450964970.0*cos(theta)**28 - 2.20950870578982e+15*cos(theta)**26 + 5.88598630640731e+15*cos(theta)**24 - 9.17814813880461e+15*cos(theta)**22 + 9.29891324589415e+15*cos(theta)**20 - 6.42470369716323e+15*cos(theta)**18 + 3.09113102410684e+15*cos(theta)**16 - 1.03903563835524e+15*cos(theta)**14 + 241204701761038.0*cos(theta)**12 - 37634776161296.7*cos(theta)**10 + 3763477616129.67*cos(theta)**8 - 222785144295.202*cos(theta)**6 + 6792230009.00007*cos(theta)**4 - 80381420.2248529*cos(theta)**2 + 155176.486920565)*cos(4*phi)

@torch.jit.script
def Yl32_m5(theta, phi):
    return 9.04668988104336e-8*(1.0 - cos(theta)**2)**2.5*(1.03110406270192e+16*cos(theta)**27 - 5.74472263505353e+16*cos(theta)**25 + 1.41263671353775e+17*cos(theta)**23 - 2.01919259053701e+17*cos(theta)**21 + 1.85978264917883e+17*cos(theta)**19 - 1.15644666548938e+17*cos(theta)**17 + 4.94580963857094e+16*cos(theta)**15 - 1.45464989369733e+16*cos(theta)**13 + 2.89445642113245e+15*cos(theta)**11 - 376347761612967.0*cos(theta)**9 + 30107820929037.3*cos(theta)**7 - 1336710865771.21*cos(theta)**5 + 27168920036.0003*cos(theta)**3 - 160762840.449706*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl32_m6(theta, phi):
    return 2.8243337947883e-9*(1.0 - cos(theta)**2)**3*(2.78398096929517e+17*cos(theta)**26 - 1.43618065876338e+18*cos(theta)**24 + 3.24906444113683e+18*cos(theta)**22 - 4.24030444012773e+18*cos(theta)**20 + 3.53358703343978e+18*cos(theta)**18 - 1.96595933133195e+18*cos(theta)**16 + 7.41871445785641e+17*cos(theta)**14 - 1.89104486180654e+17*cos(theta)**12 + 3.1839020632457e+16*cos(theta)**10 - 3.3871298545167e+15*cos(theta)**8 + 210754746503261.0*cos(theta)**6 - 6683554328856.07*cos(theta)**4 + 81506760108.0008*cos(theta)**2 - 160762840.449706)*cos(6*phi)

@torch.jit.script
def Yl32_m7(theta, phi):
    return 8.86945725708952e-11*(1.0 - cos(theta)**2)**3.5*(7.23835052016745e+18*cos(theta)**25 - 3.44683358103212e+19*cos(theta)**23 + 7.14794177050103e+19*cos(theta)**21 - 8.48060888025546e+19*cos(theta)**19 + 6.3604566601916e+19*cos(theta)**17 - 3.14553493013112e+19*cos(theta)**15 + 1.0386200240999e+19*cos(theta)**13 - 2.26925383416784e+18*cos(theta)**11 + 3.1839020632457e+17*cos(theta)**9 - 2.70970388361336e+16*cos(theta)**7 + 1.26452847901957e+15*cos(theta)**5 - 26734217315424.3*cos(theta)**3 + 163013520216.002*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl32_m8(theta, phi):
    return 2.80476865419125e-12*(1.0 - cos(theta)**2)**4*(1.80958763004186e+20*cos(theta)**24 - 7.92771723637387e+20*cos(theta)**22 + 1.50106777180522e+21*cos(theta)**20 - 1.61131568724854e+21*cos(theta)**18 + 1.08127763223257e+21*cos(theta)**16 - 4.71830239519668e+20*cos(theta)**14 + 1.35020603132987e+20*cos(theta)**12 - 2.49617921758463e+19*cos(theta)**10 + 2.86551185692113e+18*cos(theta)**8 - 1.89679271852935e+17*cos(theta)**6 + 6.32264239509784e+15*cos(theta)**4 - 80202651946272.8*cos(theta)**2 + 163013520216.002)*cos(8*phi)

@torch.jit.script
def Yl32_m9(theta, phi):
    return 8.9412758972117e-14*(1.0 - cos(theta)**2)**4.5*(4.34301031210047e+21*cos(theta)**23 - 1.74409779200225e+22*cos(theta)**21 + 3.00213554361043e+22*cos(theta)**19 - 2.90036823704737e+22*cos(theta)**17 + 1.73004421157211e+22*cos(theta)**15 - 6.60562335327535e+21*cos(theta)**13 + 1.62024723759584e+21*cos(theta)**11 - 2.49617921758463e+20*cos(theta)**9 + 2.2924094855369e+19*cos(theta)**7 - 1.13807563111761e+18*cos(theta)**5 + 2.52905695803914e+16*cos(theta)**3 - 160405303892546.0*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl32_m10(theta, phi):
    return 2.87680836403125e-15*(1.0 - cos(theta)**2)**5*(9.98892371783108e+22*cos(theta)**22 - 3.66260536320473e+23*cos(theta)**20 + 5.70405753285982e+23*cos(theta)**18 - 4.93062600298053e+23*cos(theta)**16 + 2.59506631735817e+23*cos(theta)**14 - 8.58731035925795e+22*cos(theta)**12 + 1.78227196135542e+22*cos(theta)**10 - 2.24656129582616e+21*cos(theta)**8 + 1.60468663987583e+20*cos(theta)**6 - 5.69037815558805e+18*cos(theta)**4 + 7.58717087411741e+16*cos(theta)**2 - 160405303892546.0)*cos(10*phi)

@torch.jit.script
def Yl32_m11(theta, phi):
    return 9.35331077456894e-17*(1.0 - cos(theta)**2)**5.5*(2.19756321792284e+24*cos(theta)**21 - 7.32521072640946e+24*cos(theta)**19 + 1.02673035591477e+25*cos(theta)**17 - 7.88900160476884e+24*cos(theta)**15 + 3.63309284430144e+24*cos(theta)**13 - 1.03047724311095e+24*cos(theta)**11 + 1.78227196135542e+23*cos(theta)**9 - 1.79724903666093e+22*cos(theta)**7 + 9.62811983925499e+20*cos(theta)**5 - 2.27615126223522e+19*cos(theta)**3 + 1.51743417482348e+17*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl32_m12(theta, phi):
    return 3.07701333880655e-18*(1.0 - cos(theta)**2)**6*(4.61488275763796e+25*cos(theta)**20 - 1.3917900380178e+26*cos(theta)**18 + 1.74544160505511e+26*cos(theta)**16 - 1.18335024071533e+26*cos(theta)**14 + 4.72302069759187e+25*cos(theta)**12 - 1.13352496742205e+25*cos(theta)**10 + 1.60404476521988e+24*cos(theta)**8 - 1.25807432566265e+23*cos(theta)**6 + 4.81405991962749e+21*cos(theta)**4 - 6.82845378670567e+19*cos(theta)**2 + 1.51743417482348e+17)*cos(12*phi)

@torch.jit.script
def Yl32_m13(theta, phi):
    return 1.02567111293552e-19*(1.0 - cos(theta)**2)**6.5*(9.22976551527592e+26*cos(theta)**19 - 2.50522206843203e+27*cos(theta)**17 + 2.79270656808817e+27*cos(theta)**15 - 1.65669033700146e+27*cos(theta)**13 + 5.66762483711025e+26*cos(theta)**11 - 1.13352496742205e+26*cos(theta)**9 + 1.2832358121759e+25*cos(theta)**7 - 7.54844595397591e+23*cos(theta)**5 + 1.925623967851e+22*cos(theta)**3 - 1.36569075734113e+20*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl32_m14(theta, phi):
    return 3.4693842922622e-21*(1.0 - cos(theta)**2)**7*(1.75365544790242e+28*cos(theta)**18 - 4.25887751633446e+28*cos(theta)**16 + 4.18905985213225e+28*cos(theta)**14 - 2.15369743810189e+28*cos(theta)**12 + 6.23438732082127e+27*cos(theta)**10 - 1.02017247067984e+27*cos(theta)**8 + 8.98265068523133e+25*cos(theta)**6 - 3.77422297698796e+24*cos(theta)**4 + 5.77687190355299e+22*cos(theta)**2 - 1.36569075734113e+20)*cos(14*phi)

@torch.jit.script
def Yl32_m15(theta, phi):
    return 1.19279889015859e-22*(1.0 - cos(theta)**2)**7.5*(3.15657980622436e+29*cos(theta)**17 - 6.81420402613513e+29*cos(theta)**15 + 5.86468379298516e+29*cos(theta)**13 - 2.58443692572227e+29*cos(theta)**11 + 6.23438732082127e+28*cos(theta)**9 - 8.16137976543875e+27*cos(theta)**7 + 5.3895904111388e+26*cos(theta)**5 - 1.50968919079518e+25*cos(theta)**3 + 1.1553743807106e+23*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl32_m16(theta, phi):
    return 4.17563132534946e-24*(1.0 - cos(theta)**2)**8*(5.36618567058142e+30*cos(theta)**16 - 1.02213060392027e+31*cos(theta)**14 + 7.6240889308807e+30*cos(theta)**12 - 2.8428806182945e+30*cos(theta)**10 + 5.61094858873914e+29*cos(theta)**8 - 5.71296583580713e+28*cos(theta)**6 + 2.6947952055694e+27*cos(theta)**4 - 4.52906757238555e+25*cos(theta)**2 + 1.1553743807106e+23)*cos(16*phi)

@torch.jit.script
def Yl32_m17(theta, phi):
    return 1.49129690191052e-25*(1.0 - cos(theta)**2)**8.5*(8.58589707293027e+31*cos(theta)**15 - 1.43098284548838e+32*cos(theta)**13 + 9.14890671705684e+31*cos(theta)**11 - 2.8428806182945e+31*cos(theta)**9 + 4.48875887099132e+30*cos(theta)**7 - 3.42777950148428e+29*cos(theta)**5 + 1.07791808222776e+28*cos(theta)**3 - 9.05813514477109e+25*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl32_m18(theta, phi):
    return 5.44544635409307e-27*(1.0 - cos(theta)**2)**9*(1.28788456093954e+33*cos(theta)**14 - 1.86027769913489e+33*cos(theta)**12 + 1.00637973887625e+33*cos(theta)**10 - 2.55859255646505e+32*cos(theta)**8 + 3.14213120969392e+31*cos(theta)**6 - 1.71388975074214e+30*cos(theta)**4 + 3.23375424668328e+28*cos(theta)**2 - 9.05813514477109e+25)*cos(18*phi)

@torch.jit.script
def Yl32_m19(theta, phi):
    return 2.03790707968959e-28*(1.0 - cos(theta)**2)**9.5*(1.80303838531536e+34*cos(theta)**13 - 2.23233323896187e+34*cos(theta)**11 + 1.00637973887625e+34*cos(theta)**9 - 2.04687404517204e+33*cos(theta)**7 + 1.88527872581635e+32*cos(theta)**5 - 6.85555900296855e+30*cos(theta)**3 + 6.46750849336656e+28*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl32_m20(theta, phi):
    return 7.83810415265227e-30*(1.0 - cos(theta)**2)**10*(2.34394990090996e+35*cos(theta)**12 - 2.45556656285806e+35*cos(theta)**10 + 9.05741764988628e+34*cos(theta)**8 - 1.43281183162043e+34*cos(theta)**6 + 9.42639362908176e+32*cos(theta)**4 - 2.05666770089057e+31*cos(theta)**2 + 6.46750849336656e+28)*cos(20*phi)

@torch.jit.script
def Yl32_m21(theta, phi):
    return 3.10801046364243e-31*(1.0 - cos(theta)**2)**10.5*(2.81273988109196e+36*cos(theta)**11 - 2.45556656285806e+36*cos(theta)**9 + 7.24593411990902e+35*cos(theta)**7 - 8.59687098972257e+34*cos(theta)**5 + 3.7705574516327e+33*cos(theta)**3 - 4.11333540178113e+31*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl32_m22(theta, phi):
    return 1.27523213983038e-32*(1.0 - cos(theta)**2)**11*(3.09401386920115e+37*cos(theta)**10 - 2.21000990657225e+37*cos(theta)**8 + 5.07215388393631e+36*cos(theta)**6 - 4.29843549486128e+35*cos(theta)**4 + 1.13116723548981e+34*cos(theta)**2 - 4.11333540178113e+31)*cos(22*phi)

@torch.jit.script
def Yl32_m23(theta, phi):
    return 5.43760811463069e-34*(1.0 - cos(theta)**2)**11.5*(3.09401386920115e+38*cos(theta)**9 - 1.7680079252578e+38*cos(theta)**7 + 3.04329233036179e+37*cos(theta)**5 - 1.71937419794451e+36*cos(theta)**3 + 2.26233447097962e+34*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl32_m24(theta, phi):
    return 2.42210316291546e-35*(1.0 - cos(theta)**2)**12*(2.78461248228104e+39*cos(theta)**8 - 1.23760554768046e+39*cos(theta)**6 + 1.52164616518089e+38*cos(theta)**4 - 5.15812259383354e+36*cos(theta)**2 + 2.26233447097962e+34)*cos(24*phi)

@torch.jit.script
def Yl32_m25(theta, phi):
    return 1.13425372828688e-36*(1.0 - cos(theta)**2)**12.5*(2.22768998582483e+40*cos(theta)**7 - 7.42563328608276e+39*cos(theta)**5 + 6.08658466072358e+38*cos(theta)**3 - 1.03162451876671e+37*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl32_m26(theta, phi):
    return 5.62920673595975e-38*(1.0 - cos(theta)**2)**13*(1.55938299007738e+41*cos(theta)**6 - 3.71281664304138e+40*cos(theta)**4 + 1.82597539821707e+39*cos(theta)**2 - 1.03162451876671e+37)*cos(26*phi)

@torch.jit.script
def Yl32_m27(theta, phi):
    return 2.99188962435835e-39*(1.0 - cos(theta)**2)**13.5*(9.35629794046428e+41*cos(theta)**5 - 1.48512665721655e+41*cos(theta)**3 + 3.65195079643415e+39*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl32_m28(theta, phi):
    return 1.72736828000894e-40*(1.0 - cos(theta)**2)**14*(4.67814897023214e+42*cos(theta)**4 - 4.45537997164966e+41*cos(theta)**2 + 3.65195079643415e+39)*cos(28*phi)

@torch.jit.script
def Yl32_m29(theta, phi):
    return 1.10583422533699e-41*(1.0 - cos(theta)**2)**14.5*(1.87125958809286e+43*cos(theta)**3 - 8.91075994329932e+41*cos(theta))*cos(29*phi)

@torch.jit.script
def Yl32_m30(theta, phi):
    return 8.10836994187712e-43*(1.0 - cos(theta)**2)**15*(5.61377876427857e+43*cos(theta)**2 - 8.91075994329932e+41)*cos(30*phi)

@torch.jit.script
def Yl32_m31(theta, phi):
    return 8.11023748522498*(1.0 - cos(theta)**2)**15.5*cos(31*phi)*cos(theta)

@torch.jit.script
def Yl32_m32(theta, phi):
    return 1.01377968565312*(1.0 - cos(theta)**2)**16*cos(32*phi)

@torch.jit.script
def Yl33_m_minus_33(theta, phi):
    return 1.02143096163768*(1.0 - cos(theta)**2)**16.5*sin(33*phi)

@torch.jit.script
def Yl33_m_minus_32(theta, phi):
    return 8.29814436002877*(1.0 - cos(theta)**2)**16*sin(32*phi)*cos(theta)

@torch.jit.script
def Yl33_m_minus_31(theta, phi):
    return 1.29644475885681e-44*(1.0 - cos(theta)**2)**15.5*(3.64895619678107e+45*cos(theta)**2 - 5.61377876427857e+43)*sin(31*phi)

@torch.jit.script
def Yl33_m_minus_30(theta, phi):
    return 1.7964065532371e-43*(1.0 - cos(theta)**2)**15*(1.21631873226036e+45*cos(theta)**3 - 5.61377876427857e+43*cos(theta))*sin(30*phi)

@torch.jit.script
def Yl33_m_minus_29(theta, phi):
    return 2.85170699605925e-42*(1.0 - cos(theta)**2)**14.5*(3.04079683065089e+44*cos(theta)**4 - 2.80688938213928e+43*cos(theta)**2 + 2.22768998582483e+41)*sin(29*phi)

@torch.jit.script
def Yl33_m_minus_28(theta, phi):
    return 5.02094828227271e-41*(1.0 - cos(theta)**2)**14*(6.08159366130178e+43*cos(theta)**5 - 9.35629794046428e+42*cos(theta)**3 + 2.22768998582483e+41*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl33_m_minus_27(theta, phi):
    return 9.60563965860272e-40*(1.0 - cos(theta)**2)**13.5*(1.0135989435503e+43*cos(theta)**6 - 2.33907448511607e+42*cos(theta)**4 + 1.11384499291241e+41*cos(theta)**2 - 6.08658466072358e+38)*sin(27*phi)

@torch.jit.script
def Yl33_m_minus_26(theta, phi):
    return 1.96857033314502e-38*(1.0 - cos(theta)**2)**13*(1.44799849078614e+42*cos(theta)**7 - 4.67814897023214e+41*cos(theta)**5 + 3.71281664304138e+40*cos(theta)**3 - 6.08658466072358e+38*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl33_m_minus_25(theta, phi):
    return 4.27682948208865e-37*(1.0 - cos(theta)**2)**12.5*(1.80999811348267e+41*cos(theta)**8 - 7.7969149503869e+40*cos(theta)**6 + 9.28204160760346e+39*cos(theta)**4 - 3.04329233036179e+38*cos(theta)**2 + 1.28953064845838e+36)*sin(25*phi)

@torch.jit.script
def Yl33_m_minus_24(theta, phi):
    return 9.77140888441698e-36*(1.0 - cos(theta)**2)**12*(2.01110901498075e+40*cos(theta)**9 - 1.11384499291241e+40*cos(theta)**7 + 1.85640832152069e+39*cos(theta)**5 - 1.01443077678726e+38*cos(theta)**3 + 1.28953064845838e+36*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl33_m_minus_23(theta, phi):
    return 2.33289189642992e-34*(1.0 - cos(theta)**2)**11.5*(2.01110901498075e+39*cos(theta)**10 - 1.39230624114052e+39*cos(theta)**8 + 3.09401386920115e+38*cos(theta)**6 - 2.53607694196816e+37*cos(theta)**4 + 6.44765324229192e+35*cos(theta)**2 - 2.26233447097962e+33)*sin(23*phi)

@torch.jit.script
def Yl33_m_minus_22(theta, phi):
    return 5.79008541721441e-33*(1.0 - cos(theta)**2)**11*(1.82828092270977e+38*cos(theta)**11 - 1.54700693460058e+38*cos(theta)**9 + 4.4200198131445e+37*cos(theta)**7 - 5.07215388393631e+36*cos(theta)**5 + 2.14921774743064e+35*cos(theta)**3 - 2.26233447097962e+33*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl33_m_minus_21(theta, phi):
    return 1.48749987668913e-31*(1.0 - cos(theta)**2)**10.5*(1.52356743559148e+37*cos(theta)**12 - 1.54700693460058e+37*cos(theta)**10 + 5.52502476643063e+36*cos(theta)**8 - 8.45358980656052e+35*cos(theta)**6 + 5.3730443685766e+34*cos(theta)**4 - 1.13116723548981e+33*cos(theta)**2 + 3.42777950148428e+30)*sin(21*phi)

@torch.jit.script
def Yl33_m_minus_20(theta, phi):
    return 3.94117295988316e-30*(1.0 - cos(theta)**2)**10*(1.17197495045498e+36*cos(theta)**13 - 1.40636994054598e+36*cos(theta)**11 + 6.13891640714514e+35*cos(theta)**9 - 1.2076556866515e+35*cos(theta)**7 + 1.07460887371532e+34*cos(theta)**5 - 3.7705574516327e+32*cos(theta)**3 + 3.42777950148428e+30*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl33_m_minus_19(theta, phi):
    return 1.0735627820667e-28*(1.0 - cos(theta)**2)**9.5*(8.37124964610701e+34*cos(theta)**14 - 1.17197495045498e+35*cos(theta)**12 + 6.13891640714514e+34*cos(theta)**10 - 1.50956960831438e+34*cos(theta)**8 + 1.79101478952553e+33*cos(theta)**6 - 9.42639362908176e+31*cos(theta)**4 + 1.71388975074214e+30*cos(theta)**2 - 4.61964892383326e+27)*sin(19*phi)

@torch.jit.script
def Yl33_m_minus_18(theta, phi):
    return 2.99829767816716e-27*(1.0 - cos(theta)**2)**9*(5.58083309740467e+33*cos(theta)**15 - 9.01519192657678e+33*cos(theta)**13 + 5.58083309740467e+33*cos(theta)**11 - 1.67729956479375e+33*cos(theta)**9 + 2.55859255646505e+32*cos(theta)**7 - 1.88527872581635e+31*cos(theta)**5 + 5.71296583580713e+29*cos(theta)**3 - 4.61964892383326e+27*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl33_m_minus_17(theta, phi):
    return 8.56485131043879e-26*(1.0 - cos(theta)**2)**8.5*(3.48802068587792e+32*cos(theta)**16 - 6.4394228046977e+32*cos(theta)**14 + 4.65069424783723e+32*cos(theta)**12 - 1.67729956479375e+32*cos(theta)**10 + 3.19824069558131e+31*cos(theta)**8 - 3.14213120969392e+30*cos(theta)**6 + 1.42824145895178e+29*cos(theta)**4 - 2.30982446191663e+27*cos(theta)**2 + 5.66133446548193e+24)*sin(17*phi)

@torch.jit.script
def Yl33_m_minus_16(theta, phi):
    return 2.49706179888357e-24*(1.0 - cos(theta)**2)**8*(2.05177687404584e+31*cos(theta)**17 - 4.29294853646513e+31*cos(theta)**15 + 3.57745711372095e+31*cos(theta)**13 - 1.52481778617614e+31*cos(theta)**11 + 3.55360077286812e+30*cos(theta)**9 - 4.48875887099131e+29*cos(theta)**7 + 2.85648291790356e+28*cos(theta)**5 - 7.69941487305543e+26*cos(theta)**3 + 5.66133446548193e+24*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl33_m_minus_15(theta, phi):
    return 7.41589519033628e-23*(1.0 - cos(theta)**2)**7.5*(1.13987604113658e+30*cos(theta)**18 - 2.68309283529071e+30*cos(theta)**16 + 2.55532650980068e+30*cos(theta)**14 - 1.27068148848012e+30*cos(theta)**12 + 3.55360077286812e+29*cos(theta)**10 - 5.61094858873914e+28*cos(theta)**8 + 4.76080486317261e+27*cos(theta)**6 - 1.92485371826386e+26*cos(theta)**4 + 2.83066723274097e+24*cos(theta)**2 - 6.41874655950333e+21)*sin(15*phi)

@torch.jit.script
def Yl33_m_minus_14(theta, phi):
    return 2.23955123505438e-21*(1.0 - cos(theta)**2)**7*(5.99934758492935e+28*cos(theta)**19 - 1.57828990311218e+29*cos(theta)**17 + 1.70355100653378e+29*cos(theta)**15 - 9.77447298830859e+28*cos(theta)**13 + 3.23054615715284e+28*cos(theta)**11 - 6.23438732082127e+27*cos(theta)**9 + 6.80114980453229e+26*cos(theta)**7 - 3.84970743652771e+25*cos(theta)**5 + 9.43555744246989e+23*cos(theta)**3 - 6.41874655950333e+21*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl33_m_minus_13(theta, phi):
    return 6.86633406583717e-20*(1.0 - cos(theta)**2)**6.5*(2.99967379246467e+27*cos(theta)**20 - 8.76827723951212e+27*cos(theta)**18 + 1.06471937908361e+28*cos(theta)**16 - 6.98176642022042e+27*cos(theta)**14 + 2.69212179762737e+27*cos(theta)**12 - 6.23438732082127e+26*cos(theta)**10 + 8.50143725566537e+25*cos(theta)**8 - 6.41617906087952e+24*cos(theta)**6 + 2.35888936061747e+23*cos(theta)**4 - 3.20937327975166e+21*cos(theta)**2 + 6.82845378670567e+18)*sin(13*phi)

@torch.jit.script
def Yl33_m_minus_12(theta, phi):
    return 2.13409374265872e-18*(1.0 - cos(theta)**2)**6*(1.42841609164984e+26*cos(theta)**21 - 4.61488275763796e+26*cos(theta)**19 + 6.26305517108009e+26*cos(theta)**17 - 4.65451094681362e+26*cos(theta)**15 + 2.07086292125182e+26*cos(theta)**13 - 5.66762483711025e+25*cos(theta)**11 + 9.44604139518374e+24*cos(theta)**9 - 9.16597008697075e+23*cos(theta)**7 + 4.71777872123494e+22*cos(theta)**5 - 1.06979109325055e+21*cos(theta)**3 + 6.82845378670567e+18*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl33_m_minus_11(theta, phi):
    return 6.71476920037506e-17*(1.0 - cos(theta)**2)**5.5*(6.4928004165902e+24*cos(theta)**22 - 2.30744137881898e+25*cos(theta)**20 + 3.47947509504449e+25*cos(theta)**18 - 2.90906934175851e+25*cos(theta)**16 + 1.47918780089416e+25*cos(theta)**14 - 4.72302069759187e+24*cos(theta)**12 + 9.44604139518374e+23*cos(theta)**10 - 1.14574626087134e+23*cos(theta)**8 + 7.86296453539157e+21*cos(theta)**6 - 2.67447773312639e+20*cos(theta)**4 + 3.41422689335283e+18*cos(theta)**2 - 6.89742806737946e+15)*sin(11*phi)

@torch.jit.script
def Yl33_m_minus_10(theta, phi):
    return 2.13609884881944e-15*(1.0 - cos(theta)**2)**5*(2.8229567028653e+23*cos(theta)**23 - 1.09878160896142e+24*cos(theta)**21 + 1.83130268160236e+24*cos(theta)**19 - 1.71121725985795e+24*cos(theta)**17 + 9.86125200596105e+23*cos(theta)**15 - 3.63309284430144e+23*cos(theta)**13 + 8.58731035925795e+22*cos(theta)**11 - 1.27305140096816e+22*cos(theta)**9 + 1.12328064791308e+21*cos(theta)**7 - 5.34895546625277e+19*cos(theta)**5 + 1.13807563111761e+18*cos(theta)**3 - 6.89742806737946e+15*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl33_m_minus_9(theta, phi):
    return 6.86216560370661e-14*(1.0 - cos(theta)**2)**4.5*(1.17623195952721e+22*cos(theta)**24 - 4.99446185891554e+22*cos(theta)**22 + 9.15651340801182e+22*cos(theta)**20 - 9.50676255476637e+22*cos(theta)**18 + 6.16328250372566e+22*cos(theta)**16 - 2.59506631735817e+22*cos(theta)**14 + 7.15609196604829e+21*cos(theta)**12 - 1.27305140096816e+21*cos(theta)**10 + 1.40410080989135e+20*cos(theta)**8 - 8.91492577708795e+18*cos(theta)**6 + 2.84518907779403e+17*cos(theta)**4 - 3.44871403368973e+15*cos(theta)**2 + 6683554328856.07)*sin(9*phi)

@torch.jit.script
def Yl33_m_minus_8(theta, phi):
    return 2.2235957953578e-12*(1.0 - cos(theta)**2)**4*(4.70492783810884e+20*cos(theta)**25 - 2.17150515605023e+21*cos(theta)**23 + 4.36024448000563e+21*cos(theta)**21 - 5.00355923935072e+21*cos(theta)**19 + 3.62546029630921e+21*cos(theta)**17 - 1.73004421157211e+21*cos(theta)**15 + 5.50468612772945e+20*cos(theta)**13 - 1.1573194554256e+20*cos(theta)**11 + 1.56011201099039e+19*cos(theta)**9 - 1.27356082529828e+18*cos(theta)**7 + 5.69037815558805e+16*cos(theta)**5 - 1.14957134456324e+15*cos(theta)**3 + 6683554328856.07*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl33_m_minus_7(theta, phi):
    return 7.25996365443219e-11*(1.0 - cos(theta)**2)**3.5*(1.80958763004186e+19*cos(theta)**26 - 9.04793815020931e+19*cos(theta)**24 + 1.98192930909347e+20*cos(theta)**22 - 2.50177961967536e+20*cos(theta)**20 + 2.01414460906067e+20*cos(theta)**18 - 1.08127763223257e+20*cos(theta)**16 + 3.9319186626639e+19*cos(theta)**14 - 9.64432879521333e+18*cos(theta)**12 + 1.56011201099039e+18*cos(theta)**10 - 1.59195103162285e+17*cos(theta)**8 + 9.48396359264676e+15*cos(theta)**6 - 287392836140811.0*cos(theta)**4 + 3341777164428.03*cos(theta)**2 - 6269750777.53852)*sin(7*phi)

@torch.jit.script
def Yl33_m_minus_6(theta, phi):
    return 2.38586751612009e-9*(1.0 - cos(theta)**2)**3*(6.70217640756245e+17*cos(theta)**27 - 3.61917526008372e+18*cos(theta)**25 + 8.6170839525803e+18*cos(theta)**23 - 1.19132362841684e+19*cos(theta)**21 + 1.06007611003193e+19*cos(theta)**19 - 6.3604566601916e+18*cos(theta)**17 + 2.6212791084426e+18*cos(theta)**15 - 7.41871445785641e+17*cos(theta)**13 + 1.4182836463549e+17*cos(theta)**11 - 1.76883447958094e+16*cos(theta)**9 + 1.35485194180668e+15*cos(theta)**7 - 57478567228162.2*cos(theta)**5 + 1113925721476.01*cos(theta)**3 - 6269750777.53852*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl33_m_minus_5(theta, phi):
    return 7.8842001969058e-8*(1.0 - cos(theta)**2)**2.5*(2.3936344312723e+16*cos(theta)**28 - 1.39199048464759e+17*cos(theta)**26 + 3.59045164690846e+17*cos(theta)**24 - 5.41510740189472e+17*cos(theta)**22 + 5.30038055015966e+17*cos(theta)**20 - 3.53358703343978e+17*cos(theta)**18 + 1.63829944277662e+17*cos(theta)**16 - 5.29908175561172e+16*cos(theta)**14 + 1.18190303862908e+16*cos(theta)**12 - 1.76883447958094e+15*cos(theta)**10 + 169356492725835.0*cos(theta)**8 - 9579761204693.69*cos(theta)**6 + 278481430369.003*cos(theta)**4 - 3134875388.76926*cos(theta)**2 + 5741530.01606092)*sin(5*phi)

@torch.jit.script
def Yl33_m_minus_4(theta, phi):
    return 2.61726947876729e-6*(1.0 - cos(theta)**2)**2*(825391183197346.0*cos(theta)**29 - 5.15552031350958e+15*cos(theta)**27 + 1.43618065876338e+16*cos(theta)**25 - 2.35439452256292e+16*cos(theta)**23 + 2.52399073817127e+16*cos(theta)**21 - 1.85978264917883e+16*cos(theta)**19 + 9.63705554574484e+15*cos(theta)**17 - 3.53272117040781e+15*cos(theta)**15 + 909156183560834.0*cos(theta)**13 - 160803134507358.0*cos(theta)**11 + 18817388080648.3*cos(theta)**9 - 1368537314956.24*cos(theta)**7 + 55696286073.8005*cos(theta)**5 - 1044958462.92309*cos(theta)**3 + 5741530.01606092*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl33_m_minus_3(theta, phi):
    return 8.71986838901848e-5*(1.0 - cos(theta)**2)**1.5*(27513039439911.5*cos(theta)**30 - 184125725482485.0*cos(theta)**28 + 552377176447455.0*cos(theta)**26 - 980997717734551.0*cos(theta)**24 + 1.14726851735058e+15*cos(theta)**22 - 929891324589415.0*cos(theta)**20 + 535391974763602.0*cos(theta)**18 - 220795073150488.0*cos(theta)**16 + 64939727397202.4*cos(theta)**14 - 13400261208946.5*cos(theta)**12 + 1881738808064.83*cos(theta)**10 - 171067164369.53*cos(theta)**8 + 9282714345.63342*cos(theta)**6 - 261239615.730772*cos(theta)**4 + 2870765.00803046*cos(theta)**2 - 5172.54956401885)*sin(3*phi)

@torch.jit.script
def Yl33_m_minus_2(theta, phi):
    return 0.00291301034789671*(1.0 - cos(theta)**2)*(887517401287.469*cos(theta)**31 - 6349162947671.89*cos(theta)**29 + 20458413942498.3*cos(theta)**27 - 39239908709382.0*cos(theta)**25 + 49881239884807.7*cos(theta)**23 - 44280539266162.6*cos(theta)**21 + 28178524987558.0*cos(theta)**19 - 12987945479440.5*cos(theta)**17 + 4329315159813.5*cos(theta)**15 - 1030789323765.12*cos(theta)**13 + 171067164369.53*cos(theta)**11 - 19007462707.7256*cos(theta)**9 + 1326102049.3762*cos(theta)**7 - 52247923.1461544*cos(theta)**5 + 956921.669343486*cos(theta)**3 - 5172.54956401885*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl33_m_minus_1(theta, phi):
    return 0.0974879725986118*(1.0 - cos(theta)**2)**0.5*(27734918790.2334*cos(theta)**32 - 211638764922.396*cos(theta)**30 + 730657640803.512*cos(theta)**28 - 1509227258053.16*cos(theta)**26 + 2078384995200.32*cos(theta)**24 - 2012751784825.57*cos(theta)**22 + 1408926249377.9*cos(theta)**20 - 721552526635.583*cos(theta)**18 + 270582197488.344*cos(theta)**16 - 73627808840.3656*cos(theta)**14 + 14255597030.7942*cos(theta)**12 - 1900746270.77256*cos(theta)**10 + 165762756.172025*cos(theta)**8 - 8707987.19102573*cos(theta)**6 + 239230.417335872*cos(theta)**4 - 2586.27478200942*cos(theta)**2 + 4.61834782501683)*sin(phi)

@torch.jit.script
def Yl33_m0(theta, phi):
    return 1940642007.80275*cos(theta)**33 - 15763984309.5362*cos(theta)**31 + 58176608761.3837*cos(theta)**29 - 129069416159.135*cos(theta)**27 + 191963411321.426*cos(theta)**25 - 202066748759.396*cos(theta)**23 + 154917840715.537*cos(theta)**21 - 87689343801.2472*cos(theta)**19 + 36752151446.111*cos(theta)**17 - 11333996817.8483*cos(theta)**15 + 2532063118.881*cos(theta)**13 - 398991764.187309*cos(theta)**11 + 42528191.9191899*cos(theta)**9 - 2872448.234692*cos(theta)**7 + 110478.778257385*cos(theta)**5 - 1990.60861725017*cos(theta)**3 + 10.6639747352688*cos(theta)

@torch.jit.script
def Yl33_m1(theta, phi):
    return 0.0974879725986118*(1.0 - cos(theta)**2)**0.5*(27734918790.2334*cos(theta)**32 - 211638764922.396*cos(theta)**30 + 730657640803.512*cos(theta)**28 - 1509227258053.16*cos(theta)**26 + 2078384995200.32*cos(theta)**24 - 2012751784825.57*cos(theta)**22 + 1408926249377.9*cos(theta)**20 - 721552526635.583*cos(theta)**18 + 270582197488.344*cos(theta)**16 - 73627808840.3656*cos(theta)**14 + 14255597030.7942*cos(theta)**12 - 1900746270.77256*cos(theta)**10 + 165762756.172025*cos(theta)**8 - 8707987.19102573*cos(theta)**6 + 239230.417335872*cos(theta)**4 - 2586.27478200942*cos(theta)**2 + 4.61834782501683)*cos(phi)

@torch.jit.script
def Yl33_m2(theta, phi):
    return 0.00291301034789671*(1.0 - cos(theta)**2)*(887517401287.469*cos(theta)**31 - 6349162947671.89*cos(theta)**29 + 20458413942498.3*cos(theta)**27 - 39239908709382.0*cos(theta)**25 + 49881239884807.7*cos(theta)**23 - 44280539266162.6*cos(theta)**21 + 28178524987558.0*cos(theta)**19 - 12987945479440.5*cos(theta)**17 + 4329315159813.5*cos(theta)**15 - 1030789323765.12*cos(theta)**13 + 171067164369.53*cos(theta)**11 - 19007462707.7256*cos(theta)**9 + 1326102049.3762*cos(theta)**7 - 52247923.1461544*cos(theta)**5 + 956921.669343486*cos(theta)**3 - 5172.54956401885*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl33_m3(theta, phi):
    return 8.71986838901848e-5*(1.0 - cos(theta)**2)**1.5*(27513039439911.5*cos(theta)**30 - 184125725482485.0*cos(theta)**28 + 552377176447455.0*cos(theta)**26 - 980997717734551.0*cos(theta)**24 + 1.14726851735058e+15*cos(theta)**22 - 929891324589415.0*cos(theta)**20 + 535391974763602.0*cos(theta)**18 - 220795073150488.0*cos(theta)**16 + 64939727397202.4*cos(theta)**14 - 13400261208946.5*cos(theta)**12 + 1881738808064.83*cos(theta)**10 - 171067164369.53*cos(theta)**8 + 9282714345.63342*cos(theta)**6 - 261239615.730772*cos(theta)**4 + 2870765.00803046*cos(theta)**2 - 5172.54956401885)*cos(3*phi)

@torch.jit.script
def Yl33_m4(theta, phi):
    return 2.61726947876729e-6*(1.0 - cos(theta)**2)**2*(825391183197346.0*cos(theta)**29 - 5.15552031350958e+15*cos(theta)**27 + 1.43618065876338e+16*cos(theta)**25 - 2.35439452256292e+16*cos(theta)**23 + 2.52399073817127e+16*cos(theta)**21 - 1.85978264917883e+16*cos(theta)**19 + 9.63705554574484e+15*cos(theta)**17 - 3.53272117040781e+15*cos(theta)**15 + 909156183560834.0*cos(theta)**13 - 160803134507358.0*cos(theta)**11 + 18817388080648.3*cos(theta)**9 - 1368537314956.24*cos(theta)**7 + 55696286073.8005*cos(theta)**5 - 1044958462.92309*cos(theta)**3 + 5741530.01606092*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl33_m5(theta, phi):
    return 7.8842001969058e-8*(1.0 - cos(theta)**2)**2.5*(2.3936344312723e+16*cos(theta)**28 - 1.39199048464759e+17*cos(theta)**26 + 3.59045164690846e+17*cos(theta)**24 - 5.41510740189472e+17*cos(theta)**22 + 5.30038055015966e+17*cos(theta)**20 - 3.53358703343978e+17*cos(theta)**18 + 1.63829944277662e+17*cos(theta)**16 - 5.29908175561172e+16*cos(theta)**14 + 1.18190303862908e+16*cos(theta)**12 - 1.76883447958094e+15*cos(theta)**10 + 169356492725835.0*cos(theta)**8 - 9579761204693.69*cos(theta)**6 + 278481430369.003*cos(theta)**4 - 3134875388.76926*cos(theta)**2 + 5741530.01606092)*cos(5*phi)

@torch.jit.script
def Yl33_m6(theta, phi):
    return 2.38586751612009e-9*(1.0 - cos(theta)**2)**3*(6.70217640756245e+17*cos(theta)**27 - 3.61917526008372e+18*cos(theta)**25 + 8.6170839525803e+18*cos(theta)**23 - 1.19132362841684e+19*cos(theta)**21 + 1.06007611003193e+19*cos(theta)**19 - 6.3604566601916e+18*cos(theta)**17 + 2.6212791084426e+18*cos(theta)**15 - 7.41871445785641e+17*cos(theta)**13 + 1.4182836463549e+17*cos(theta)**11 - 1.76883447958094e+16*cos(theta)**9 + 1.35485194180668e+15*cos(theta)**7 - 57478567228162.2*cos(theta)**5 + 1113925721476.01*cos(theta)**3 - 6269750777.53852*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl33_m7(theta, phi):
    return 7.25996365443219e-11*(1.0 - cos(theta)**2)**3.5*(1.80958763004186e+19*cos(theta)**26 - 9.04793815020931e+19*cos(theta)**24 + 1.98192930909347e+20*cos(theta)**22 - 2.50177961967536e+20*cos(theta)**20 + 2.01414460906067e+20*cos(theta)**18 - 1.08127763223257e+20*cos(theta)**16 + 3.9319186626639e+19*cos(theta)**14 - 9.64432879521333e+18*cos(theta)**12 + 1.56011201099039e+18*cos(theta)**10 - 1.59195103162285e+17*cos(theta)**8 + 9.48396359264676e+15*cos(theta)**6 - 287392836140811.0*cos(theta)**4 + 3341777164428.03*cos(theta)**2 - 6269750777.53852)*cos(7*phi)

@torch.jit.script
def Yl33_m8(theta, phi):
    return 2.2235957953578e-12*(1.0 - cos(theta)**2)**4*(4.70492783810884e+20*cos(theta)**25 - 2.17150515605023e+21*cos(theta)**23 + 4.36024448000563e+21*cos(theta)**21 - 5.00355923935072e+21*cos(theta)**19 + 3.62546029630921e+21*cos(theta)**17 - 1.73004421157211e+21*cos(theta)**15 + 5.50468612772945e+20*cos(theta)**13 - 1.1573194554256e+20*cos(theta)**11 + 1.56011201099039e+19*cos(theta)**9 - 1.27356082529828e+18*cos(theta)**7 + 5.69037815558805e+16*cos(theta)**5 - 1.14957134456324e+15*cos(theta)**3 + 6683554328856.07*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl33_m9(theta, phi):
    return 6.86216560370661e-14*(1.0 - cos(theta)**2)**4.5*(1.17623195952721e+22*cos(theta)**24 - 4.99446185891554e+22*cos(theta)**22 + 9.15651340801182e+22*cos(theta)**20 - 9.50676255476637e+22*cos(theta)**18 + 6.16328250372566e+22*cos(theta)**16 - 2.59506631735817e+22*cos(theta)**14 + 7.15609196604829e+21*cos(theta)**12 - 1.27305140096816e+21*cos(theta)**10 + 1.40410080989135e+20*cos(theta)**8 - 8.91492577708795e+18*cos(theta)**6 + 2.84518907779403e+17*cos(theta)**4 - 3.44871403368973e+15*cos(theta)**2 + 6683554328856.07)*cos(9*phi)

@torch.jit.script
def Yl33_m10(theta, phi):
    return 2.13609884881944e-15*(1.0 - cos(theta)**2)**5*(2.8229567028653e+23*cos(theta)**23 - 1.09878160896142e+24*cos(theta)**21 + 1.83130268160236e+24*cos(theta)**19 - 1.71121725985795e+24*cos(theta)**17 + 9.86125200596105e+23*cos(theta)**15 - 3.63309284430144e+23*cos(theta)**13 + 8.58731035925795e+22*cos(theta)**11 - 1.27305140096816e+22*cos(theta)**9 + 1.12328064791308e+21*cos(theta)**7 - 5.34895546625277e+19*cos(theta)**5 + 1.13807563111761e+18*cos(theta)**3 - 6.89742806737946e+15*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl33_m11(theta, phi):
    return 6.71476920037506e-17*(1.0 - cos(theta)**2)**5.5*(6.4928004165902e+24*cos(theta)**22 - 2.30744137881898e+25*cos(theta)**20 + 3.47947509504449e+25*cos(theta)**18 - 2.90906934175851e+25*cos(theta)**16 + 1.47918780089416e+25*cos(theta)**14 - 4.72302069759187e+24*cos(theta)**12 + 9.44604139518374e+23*cos(theta)**10 - 1.14574626087134e+23*cos(theta)**8 + 7.86296453539157e+21*cos(theta)**6 - 2.67447773312639e+20*cos(theta)**4 + 3.41422689335283e+18*cos(theta)**2 - 6.89742806737946e+15)*cos(11*phi)

@torch.jit.script
def Yl33_m12(theta, phi):
    return 2.13409374265872e-18*(1.0 - cos(theta)**2)**6*(1.42841609164984e+26*cos(theta)**21 - 4.61488275763796e+26*cos(theta)**19 + 6.26305517108009e+26*cos(theta)**17 - 4.65451094681362e+26*cos(theta)**15 + 2.07086292125182e+26*cos(theta)**13 - 5.66762483711025e+25*cos(theta)**11 + 9.44604139518374e+24*cos(theta)**9 - 9.16597008697075e+23*cos(theta)**7 + 4.71777872123494e+22*cos(theta)**5 - 1.06979109325055e+21*cos(theta)**3 + 6.82845378670567e+18*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl33_m13(theta, phi):
    return 6.86633406583717e-20*(1.0 - cos(theta)**2)**6.5*(2.99967379246467e+27*cos(theta)**20 - 8.76827723951212e+27*cos(theta)**18 + 1.06471937908361e+28*cos(theta)**16 - 6.98176642022042e+27*cos(theta)**14 + 2.69212179762737e+27*cos(theta)**12 - 6.23438732082127e+26*cos(theta)**10 + 8.50143725566537e+25*cos(theta)**8 - 6.41617906087952e+24*cos(theta)**6 + 2.35888936061747e+23*cos(theta)**4 - 3.20937327975166e+21*cos(theta)**2 + 6.82845378670567e+18)*cos(13*phi)

@torch.jit.script
def Yl33_m14(theta, phi):
    return 2.23955123505438e-21*(1.0 - cos(theta)**2)**7*(5.99934758492935e+28*cos(theta)**19 - 1.57828990311218e+29*cos(theta)**17 + 1.70355100653378e+29*cos(theta)**15 - 9.77447298830859e+28*cos(theta)**13 + 3.23054615715284e+28*cos(theta)**11 - 6.23438732082127e+27*cos(theta)**9 + 6.80114980453229e+26*cos(theta)**7 - 3.84970743652771e+25*cos(theta)**5 + 9.43555744246989e+23*cos(theta)**3 - 6.41874655950333e+21*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl33_m15(theta, phi):
    return 7.41589519033628e-23*(1.0 - cos(theta)**2)**7.5*(1.13987604113658e+30*cos(theta)**18 - 2.68309283529071e+30*cos(theta)**16 + 2.55532650980068e+30*cos(theta)**14 - 1.27068148848012e+30*cos(theta)**12 + 3.55360077286812e+29*cos(theta)**10 - 5.61094858873914e+28*cos(theta)**8 + 4.76080486317261e+27*cos(theta)**6 - 1.92485371826386e+26*cos(theta)**4 + 2.83066723274097e+24*cos(theta)**2 - 6.41874655950333e+21)*cos(15*phi)

@torch.jit.script
def Yl33_m16(theta, phi):
    return 2.49706179888357e-24*(1.0 - cos(theta)**2)**8*(2.05177687404584e+31*cos(theta)**17 - 4.29294853646513e+31*cos(theta)**15 + 3.57745711372095e+31*cos(theta)**13 - 1.52481778617614e+31*cos(theta)**11 + 3.55360077286812e+30*cos(theta)**9 - 4.48875887099131e+29*cos(theta)**7 + 2.85648291790356e+28*cos(theta)**5 - 7.69941487305543e+26*cos(theta)**3 + 5.66133446548193e+24*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl33_m17(theta, phi):
    return 8.56485131043879e-26*(1.0 - cos(theta)**2)**8.5*(3.48802068587792e+32*cos(theta)**16 - 6.4394228046977e+32*cos(theta)**14 + 4.65069424783723e+32*cos(theta)**12 - 1.67729956479375e+32*cos(theta)**10 + 3.19824069558131e+31*cos(theta)**8 - 3.14213120969392e+30*cos(theta)**6 + 1.42824145895178e+29*cos(theta)**4 - 2.30982446191663e+27*cos(theta)**2 + 5.66133446548193e+24)*cos(17*phi)

@torch.jit.script
def Yl33_m18(theta, phi):
    return 2.99829767816716e-27*(1.0 - cos(theta)**2)**9*(5.58083309740467e+33*cos(theta)**15 - 9.01519192657678e+33*cos(theta)**13 + 5.58083309740467e+33*cos(theta)**11 - 1.67729956479375e+33*cos(theta)**9 + 2.55859255646505e+32*cos(theta)**7 - 1.88527872581635e+31*cos(theta)**5 + 5.71296583580713e+29*cos(theta)**3 - 4.61964892383326e+27*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl33_m19(theta, phi):
    return 1.0735627820667e-28*(1.0 - cos(theta)**2)**9.5*(8.37124964610701e+34*cos(theta)**14 - 1.17197495045498e+35*cos(theta)**12 + 6.13891640714514e+34*cos(theta)**10 - 1.50956960831438e+34*cos(theta)**8 + 1.79101478952553e+33*cos(theta)**6 - 9.42639362908176e+31*cos(theta)**4 + 1.71388975074214e+30*cos(theta)**2 - 4.61964892383326e+27)*cos(19*phi)

@torch.jit.script
def Yl33_m20(theta, phi):
    return 3.94117295988316e-30*(1.0 - cos(theta)**2)**10*(1.17197495045498e+36*cos(theta)**13 - 1.40636994054598e+36*cos(theta)**11 + 6.13891640714514e+35*cos(theta)**9 - 1.2076556866515e+35*cos(theta)**7 + 1.07460887371532e+34*cos(theta)**5 - 3.7705574516327e+32*cos(theta)**3 + 3.42777950148428e+30*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl33_m21(theta, phi):
    return 1.48749987668913e-31*(1.0 - cos(theta)**2)**10.5*(1.52356743559148e+37*cos(theta)**12 - 1.54700693460058e+37*cos(theta)**10 + 5.52502476643063e+36*cos(theta)**8 - 8.45358980656052e+35*cos(theta)**6 + 5.3730443685766e+34*cos(theta)**4 - 1.13116723548981e+33*cos(theta)**2 + 3.42777950148428e+30)*cos(21*phi)

@torch.jit.script
def Yl33_m22(theta, phi):
    return 5.79008541721441e-33*(1.0 - cos(theta)**2)**11*(1.82828092270977e+38*cos(theta)**11 - 1.54700693460058e+38*cos(theta)**9 + 4.4200198131445e+37*cos(theta)**7 - 5.07215388393631e+36*cos(theta)**5 + 2.14921774743064e+35*cos(theta)**3 - 2.26233447097962e+33*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl33_m23(theta, phi):
    return 2.33289189642992e-34*(1.0 - cos(theta)**2)**11.5*(2.01110901498075e+39*cos(theta)**10 - 1.39230624114052e+39*cos(theta)**8 + 3.09401386920115e+38*cos(theta)**6 - 2.53607694196816e+37*cos(theta)**4 + 6.44765324229192e+35*cos(theta)**2 - 2.26233447097962e+33)*cos(23*phi)

@torch.jit.script
def Yl33_m24(theta, phi):
    return 9.77140888441698e-36*(1.0 - cos(theta)**2)**12*(2.01110901498075e+40*cos(theta)**9 - 1.11384499291241e+40*cos(theta)**7 + 1.85640832152069e+39*cos(theta)**5 - 1.01443077678726e+38*cos(theta)**3 + 1.28953064845838e+36*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl33_m25(theta, phi):
    return 4.27682948208865e-37*(1.0 - cos(theta)**2)**12.5*(1.80999811348267e+41*cos(theta)**8 - 7.7969149503869e+40*cos(theta)**6 + 9.28204160760346e+39*cos(theta)**4 - 3.04329233036179e+38*cos(theta)**2 + 1.28953064845838e+36)*cos(25*phi)

@torch.jit.script
def Yl33_m26(theta, phi):
    return 1.96857033314502e-38*(1.0 - cos(theta)**2)**13*(1.44799849078614e+42*cos(theta)**7 - 4.67814897023214e+41*cos(theta)**5 + 3.71281664304138e+40*cos(theta)**3 - 6.08658466072358e+38*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl33_m27(theta, phi):
    return 9.60563965860272e-40*(1.0 - cos(theta)**2)**13.5*(1.0135989435503e+43*cos(theta)**6 - 2.33907448511607e+42*cos(theta)**4 + 1.11384499291241e+41*cos(theta)**2 - 6.08658466072358e+38)*cos(27*phi)

@torch.jit.script
def Yl33_m28(theta, phi):
    return 5.02094828227271e-41*(1.0 - cos(theta)**2)**14*(6.08159366130178e+43*cos(theta)**5 - 9.35629794046428e+42*cos(theta)**3 + 2.22768998582483e+41*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl33_m29(theta, phi):
    return 2.85170699605925e-42*(1.0 - cos(theta)**2)**14.5*(3.04079683065089e+44*cos(theta)**4 - 2.80688938213928e+43*cos(theta)**2 + 2.22768998582483e+41)*cos(29*phi)

@torch.jit.script
def Yl33_m30(theta, phi):
    return 1.7964065532371e-43*(1.0 - cos(theta)**2)**15*(1.21631873226036e+45*cos(theta)**3 - 5.61377876427857e+43*cos(theta))*cos(30*phi)

@torch.jit.script
def Yl33_m31(theta, phi):
    return 1.29644475885681e-44*(1.0 - cos(theta)**2)**15.5*(3.64895619678107e+45*cos(theta)**2 - 5.61377876427857e+43)*cos(31*phi)

@torch.jit.script
def Yl33_m32(theta, phi):
    return 8.29814436002877*(1.0 - cos(theta)**2)**16*cos(32*phi)*cos(theta)

@torch.jit.script
def Yl33_m33(theta, phi):
    return 1.02143096163768*(1.0 - cos(theta)**2)**16.5*cos(33*phi)

@torch.jit.script
def Yl34_m_minus_34(theta, phi):
    return 1.0289140723859*(1.0 - cos(theta)**2)**17*sin(34*phi)

@torch.jit.script
def Yl34_m_minus_33(theta, phi):
    return 8.48464280026292*(1.0 - cos(theta)**2)**16.5*sin(33*phi)*cos(theta)

@torch.jit.script
def Yl34_m_minus_32(theta, phi):
    return 2.0086881349656e-46*(1.0 - cos(theta)**2)**16*(2.44480065184332e+47*cos(theta)**2 - 3.64895619678107e+45)*sin(32*phi)

@torch.jit.script
def Yl34_m_minus_31(theta, phi):
    return 2.8264747454439e-45*(1.0 - cos(theta)**2)**15.5*(8.14933550614439e+46*cos(theta)**3 - 3.64895619678107e+45*cos(theta))*sin(31*phi)

@torch.jit.script
def Yl34_m_minus_30(theta, phi):
    return 4.55755358336505e-44*(1.0 - cos(theta)**2)**15*(2.0373338765361e+46*cos(theta)**4 - 1.82447809839054e+45*cos(theta)**2 + 1.40344469106964e+43)*sin(30*phi)

@torch.jit.script
def Yl34_m_minus_29(theta, phi):
    return 8.15279969880161e-43*(1.0 - cos(theta)**2)**14.5*(4.0746677530722e+45*cos(theta)**5 - 6.08159366130178e+44*cos(theta)**3 + 1.40344469106964e+43*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl34_m_minus_28(theta, phi):
    return 1.58508542441973e-41*(1.0 - cos(theta)**2)**14*(6.79111292178699e+44*cos(theta)**6 - 1.52039841532545e+44*cos(theta)**4 + 7.01722345534821e+42*cos(theta)**2 - 3.71281664304138e+40)*sin(28*phi)

@torch.jit.script
def Yl34_m_minus_27(theta, phi):
    return 3.30215562682199e-40*(1.0 - cos(theta)**2)**13.5*(9.70158988826713e+43*cos(theta)**7 - 3.04079683065089e+43*cos(theta)**5 + 2.33907448511607e+42*cos(theta)**3 - 3.71281664304138e+40*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl34_m_minus_26(theta, phi):
    return 7.29470020663704e-39*(1.0 - cos(theta)**2)**13*(1.21269873603339e+43*cos(theta)**8 - 5.06799471775149e+42*cos(theta)**6 + 5.84768621279018e+41*cos(theta)**4 - 1.85640832152069e+40*cos(theta)**2 + 7.60823082590447e+37)*sin(26*phi)

@torch.jit.script
def Yl34_m_minus_25(theta, phi):
    return 1.69513514495286e-37*(1.0 - cos(theta)**2)**12.5*(1.3474430400371e+42*cos(theta)**9 - 7.23999245393069e+41*cos(theta)**7 + 1.16953724255804e+41*cos(theta)**5 - 6.1880277384023e+39*cos(theta)**3 + 7.60823082590447e+37*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl34_m_minus_24(theta, phi):
    return 4.11746896065541e-36*(1.0 - cos(theta)**2)**12*(1.3474430400371e+41*cos(theta)**10 - 9.04999056741337e+40*cos(theta)**8 + 1.94922873759673e+40*cos(theta)**6 - 1.54700693460058e+39*cos(theta)**4 + 3.80411541295224e+37*cos(theta)**2 - 1.28953064845838e+35)*sin(24*phi)

@torch.jit.script
def Yl34_m_minus_23(theta, phi):
    return 1.04001756281185e-34*(1.0 - cos(theta)**2)**11.5*(1.22494821821555e+40*cos(theta)**11 - 1.00555450749037e+40*cos(theta)**9 + 2.78461248228104e+39*cos(theta)**7 - 3.09401386920115e+38*cos(theta)**5 + 1.26803847098408e+37*cos(theta)**3 - 1.28953064845838e+35*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl34_m_minus_22(theta, phi):
    return 2.71999887348259e-33*(1.0 - cos(theta)**2)**11*(1.02079018184629e+39*cos(theta)**12 - 1.00555450749037e+39*cos(theta)**10 + 3.4807656028513e+38*cos(theta)**8 - 5.15668978200192e+37*cos(theta)**6 + 3.1700961774602e+36*cos(theta)**4 - 6.44765324229192e+34*cos(theta)**2 + 1.88527872581635e+32)*sin(22*phi)

@torch.jit.script
def Yl34_m_minus_21(theta, phi):
    return 7.33895819488808e-32*(1.0 - cos(theta)**2)**10.5*(7.85223216804838e+37*cos(theta)**13 - 9.14140461354886e+37*cos(theta)**11 + 3.86751733650144e+37*cos(theta)**9 - 7.36669968857417e+36*cos(theta)**7 + 6.34019235492039e+35*cos(theta)**5 - 2.14921774743064e+34*cos(theta)**3 + 1.88527872581635e+32*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl34_m_minus_20(theta, phi):
    return 2.03647825147882e-30*(1.0 - cos(theta)**2)**10*(5.6087372628917e+36*cos(theta)**14 - 7.61783717795738e+36*cos(theta)**12 + 3.86751733650144e+36*cos(theta)**10 - 9.20837461071771e+35*cos(theta)**8 + 1.05669872582007e+35*cos(theta)**6 - 5.3730443685766e+33*cos(theta)**4 + 9.42639362908176e+31*cos(theta)**2 - 2.44841392963163e+29)*sin(20*phi)

@torch.jit.script
def Yl34_m_minus_19(theta, phi):
    return 5.79591871206322e-29*(1.0 - cos(theta)**2)**9.5*(3.73915817526113e+35*cos(theta)**15 - 5.85987475227491e+35*cos(theta)**13 + 3.51592485136495e+35*cos(theta)**11 - 1.02315273452419e+35*cos(theta)**9 + 1.50956960831438e+34*cos(theta)**7 - 1.07460887371532e+33*cos(theta)**5 + 3.14213120969392e+31*cos(theta)**3 - 2.44841392963163e+29*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl34_m_minus_18(theta, phi):
    return 1.6877970053263e-27*(1.0 - cos(theta)**2)**9*(2.33697385953821e+34*cos(theta)**16 - 4.18562482305351e+34*cos(theta)**14 + 2.92993737613745e+34*cos(theta)**12 - 1.02315273452419e+34*cos(theta)**10 + 1.88696201039297e+33*cos(theta)**8 - 1.79101478952553e+32*cos(theta)**6 + 7.8553280242348e+30*cos(theta)**4 - 1.22420696481581e+29*cos(theta)**2 + 2.88728057739579e+26)*sin(18*phi)

@torch.jit.script
def Yl34_m_minus_17(theta, phi):
    return 5.01818126253981e-26*(1.0 - cos(theta)**2)**8.5*(1.37469050561071e+33*cos(theta)**17 - 2.79041654870234e+33*cos(theta)**15 + 2.2537979816442e+33*cos(theta)**13 - 9.30138849567446e+32*cos(theta)**11 + 2.09662445599219e+32*cos(theta)**9 - 2.55859255646505e+31*cos(theta)**7 + 1.57106560484696e+30*cos(theta)**5 - 4.08068988271938e+28*cos(theta)**3 + 2.88728057739579e+26*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl34_m_minus_16(theta, phi):
    return 1.52043439327851e-24*(1.0 - cos(theta)**2)**8*(7.63716947561506e+31*cos(theta)**18 - 1.74401034293896e+32*cos(theta)**16 + 1.60985570117443e+32*cos(theta)**14 - 7.75115707972871e+31*cos(theta)**12 + 2.09662445599219e+31*cos(theta)**10 - 3.19824069558131e+30*cos(theta)**8 + 2.61844267474493e+29*cos(theta)**6 - 1.02017247067984e+28*cos(theta)**4 + 1.44364028869789e+26*cos(theta)**2 - 3.14518581415663e+23)*sin(16*phi)

@torch.jit.script
def Yl34_m_minus_15(theta, phi):
    return 4.68629353226083e-23*(1.0 - cos(theta)**2)**7.5*(4.01956288190266e+30*cos(theta)**19 - 1.02588843702292e+31*cos(theta)**17 + 1.07323713411628e+31*cos(theta)**15 - 5.96242852286824e+30*cos(theta)**13 + 1.90602223272018e+30*cos(theta)**11 - 3.55360077286812e+29*cos(theta)**9 + 3.74063239249276e+28*cos(theta)**7 - 2.04034494135969e+27*cos(theta)**5 + 4.81213429565964e+25*cos(theta)**3 - 3.14518581415663e+23*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl34_m_minus_14(theta, phi):
    return 1.46704192609139e-21*(1.0 - cos(theta)**2)**7*(2.00978144095133e+29*cos(theta)**20 - 5.69938020568288e+29*cos(theta)**18 + 6.70773208822677e+29*cos(theta)**16 - 4.25887751633446e+29*cos(theta)**14 + 1.58835186060015e+29*cos(theta)**12 - 3.55360077286812e+28*cos(theta)**10 + 4.67579049061595e+27*cos(theta)**8 - 3.40057490226615e+26*cos(theta)**6 + 1.20303357391491e+25*cos(theta)**4 - 1.57259290707831e+23*cos(theta)**2 + 3.20937327975166e+20)*sin(14*phi)

@torch.jit.script
def Yl34_m_minus_13(theta, phi):
    return 4.65771371921163e-20*(1.0 - cos(theta)**2)**6.5*(9.57038781405396e+27*cos(theta)**21 - 2.99967379246467e+28*cos(theta)**19 + 3.94572475778045e+28*cos(theta)**17 - 2.83925167755631e+28*cos(theta)**15 + 1.22180912353857e+28*cos(theta)**13 - 3.23054615715284e+27*cos(theta)**11 + 5.19532276735106e+26*cos(theta)**9 - 4.8579641460945e+25*cos(theta)**7 + 2.40606714782982e+24*cos(theta)**5 - 5.24197635692772e+22*cos(theta)**3 + 3.20937327975166e+20*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl34_m_minus_12(theta, phi):
    return 1.49772838629695e-18*(1.0 - cos(theta)**2)**6*(4.35017627911543e+26*cos(theta)**22 - 1.49983689623234e+27*cos(theta)**20 + 2.19206930987803e+27*cos(theta)**18 - 1.77453229847269e+27*cos(theta)**16 + 8.72720802527553e+26*cos(theta)**14 - 2.69212179762737e+26*cos(theta)**12 + 5.19532276735106e+25*cos(theta)**10 - 6.07245518261812e+24*cos(theta)**8 + 4.0101119130497e+23*cos(theta)**6 - 1.31049408923193e+22*cos(theta)**4 + 1.60468663987583e+20*cos(theta)**2 - 3.10384263032076e+17)*sin(12*phi)

@torch.jit.script
def Yl34_m_minus_11(theta, phi):
    return 4.87164793230034e-17*(1.0 - cos(theta)**2)**5.5*(1.89138099091975e+25*cos(theta)**23 - 7.14208045824922e+25*cos(theta)**21 + 1.15372068940949e+26*cos(theta)**19 - 1.04384252851335e+26*cos(theta)**17 + 5.81813868351702e+25*cos(theta)**15 - 2.07086292125182e+25*cos(theta)**13 + 4.72302069759187e+24*cos(theta)**11 - 6.74717242513125e+23*cos(theta)**9 + 5.72873130435672e+22*cos(theta)**7 - 2.62098817846386e+21*cos(theta)**5 + 5.34895546625277e+19*cos(theta)**3 - 3.10384263032076e+17*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl34_m_minus_10(theta, phi):
    return 1.60098687884658e-15*(1.0 - cos(theta)**2)**5*(7.88075412883231e+23*cos(theta)**24 - 3.2464002082951e+24*cos(theta)**22 + 5.76860344704745e+24*cos(theta)**20 - 5.79912515840749e+24*cos(theta)**18 + 3.63633667719814e+24*cos(theta)**16 - 1.47918780089416e+24*cos(theta)**14 + 3.93585058132656e+23*cos(theta)**12 - 6.74717242513125e+22*cos(theta)**10 + 7.1609141304459e+21*cos(theta)**8 - 4.3683136307731e+20*cos(theta)**6 + 1.33723886656319e+19*cos(theta)**4 - 1.55192131516038e+17*cos(theta)**2 + 287392836140811.0)*sin(10*phi)

@torch.jit.script
def Yl34_m_minus_9(theta, phi):
    return 5.30987277141628e-14*(1.0 - cos(theta)**2)**4.5*(3.15230165153292e+22*cos(theta)**25 - 1.41147835143265e+23*cos(theta)**23 + 2.74695402240355e+23*cos(theta)**21 - 3.05217113600394e+23*cos(theta)**19 + 2.13902157482243e+23*cos(theta)**17 - 9.86125200596105e+22*cos(theta)**15 + 3.0275773702512e+22*cos(theta)**13 - 6.13379311375568e+21*cos(theta)**11 + 7.956571256051e+20*cos(theta)**9 - 6.24044804396157e+19*cos(theta)**7 + 2.67447773312639e+18*cos(theta)**5 - 5.17307105053459e+16*cos(theta)**3 + 287392836140811.0*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl34_m_minus_8(theta, phi):
    return 1.77543598061902e-12*(1.0 - cos(theta)**2)**4*(1.21242371212805e+21*cos(theta)**26 - 5.88115979763605e+21*cos(theta)**24 + 1.24861546472888e+22*cos(theta)**22 - 1.52608556800197e+22*cos(theta)**20 + 1.1883453193458e+22*cos(theta)**18 - 6.16328250372566e+21*cos(theta)**16 + 2.16255526446514e+21*cos(theta)**14 - 5.11149426146306e+20*cos(theta)**12 + 7.956571256051e+19*cos(theta)**10 - 7.80056005495196e+18*cos(theta)**8 + 4.45746288854398e+17*cos(theta)**6 - 1.29326776263365e+16*cos(theta)**4 + 143696418070405.0*cos(theta)**2 - 257059781879.079)*sin(8*phi)

@torch.jit.script
def Yl34_m_minus_7(theta, phi):
    return 5.97876583646464e-11*(1.0 - cos(theta)**2)**3.5*(4.49045819306684e+19*cos(theta)**27 - 2.35246391905442e+20*cos(theta)**25 + 5.42876289012559e+20*cos(theta)**23 - 7.26707413334272e+20*cos(theta)**21 + 6.2544490491884e+20*cos(theta)**19 - 3.62546029630921e+20*cos(theta)**17 + 1.44170350964343e+20*cos(theta)**15 - 3.9319186626639e+19*cos(theta)**13 + 7.23324659641e+18*cos(theta)**11 - 8.66728894994662e+17*cos(theta)**9 + 6.36780412649139e+16*cos(theta)**7 - 2.5865355252673e+15*cos(theta)**5 + 47898806023468.5*cos(theta)**3 - 257059781879.079*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl34_m_minus_6(theta, phi):
    return 2.0257343306691e-9*(1.0 - cos(theta)**2)**3*(1.60373506895244e+18*cos(theta)**28 - 9.04793815020931e+18*cos(theta)**26 + 2.26198453755233e+19*cos(theta)**24 - 3.30321551515578e+19*cos(theta)**22 + 3.1272245245942e+19*cos(theta)**20 - 2.01414460906067e+19*cos(theta)**18 + 9.01064693527143e+18*cos(theta)**16 - 2.80851333047421e+18*cos(theta)**14 + 6.02770549700833e+17*cos(theta)**12 - 8.66728894994662e+16*cos(theta)**10 + 7.95975515811424e+15*cos(theta)**8 - 431089254211216.0*cos(theta)**6 + 11974701505867.1*cos(theta)**4 - 128529890939.54*cos(theta)**2 + 223919670.626376)*sin(6*phi)

@torch.jit.script
def Yl34_m_minus_5(theta, phi):
    return 6.89940251833707e-8*(1.0 - cos(theta)**2)**2.5*(5.53012092742222e+16*cos(theta)**29 - 3.35108820378123e+17*cos(theta)**27 + 9.04793815020931e+17*cos(theta)**25 - 1.43618065876338e+18*cos(theta)**23 + 1.48915453552105e+18*cos(theta)**21 - 1.06007611003193e+18*cos(theta)**19 + 5.30038055015966e+17*cos(theta)**17 - 1.87234222031614e+17*cos(theta)**15 + 4.63669653616025e+16*cos(theta)**13 - 7.87935359086056e+15*cos(theta)**11 + 884417239790471.0*cos(theta)**9 - 61584179173030.9*cos(theta)**7 + 2394940301173.42*cos(theta)**5 - 42843296979.8466*cos(theta)**3 + 223919670.626376*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl34_m_minus_4(theta, phi):
    return 2.35995875978251e-6*(1.0 - cos(theta)**2)**2*(1.84337364247407e+15*cos(theta)**30 - 1.19681721563615e+16*cos(theta)**28 + 3.47997621161897e+16*cos(theta)**26 - 5.98408607818076e+16*cos(theta)**24 + 6.7688842523684e+16*cos(theta)**22 - 5.30038055015966e+16*cos(theta)**20 + 2.94465586119981e+16*cos(theta)**18 - 1.17021388769759e+16*cos(theta)**16 + 3.31192609725732e+15*cos(theta)**14 - 656612799238380.0*cos(theta)**12 + 88441723979047.1*cos(theta)**10 - 7698022396628.86*cos(theta)**8 + 399156716862.237*cos(theta)**6 - 10710824244.9616*cos(theta)**4 + 111959835.313188*cos(theta)**2 - 191384.333868697)*sin(4*phi)

@torch.jit.script
def Yl34_m_minus_3(theta, phi):
    return 8.09985154172335e-5*(1.0 - cos(theta)**2)**1.5*(59463665886260.4*cos(theta)**31 - 412695591598673.0*cos(theta)**29 + 1.28888007837739e+15*cos(theta)**27 - 2.3936344312723e+15*cos(theta)**25 + 2.94299315320365e+15*cos(theta)**23 - 2.52399073817127e+15*cos(theta)**21 + 1.54981887431569e+15*cos(theta)**19 - 688361110410346.0*cos(theta)**17 + 220795073150488.0*cos(theta)**15 - 50508676864490.8*cos(theta)**13 + 8040156725367.92*cos(theta)**11 - 855335821847.651*cos(theta)**9 + 57022388123.1768*cos(theta)**7 - 2142164848.99233*cos(theta)**5 + 37319945.104396*cos(theta)**3 - 191384.333868697*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl34_m_minus_2(theta, phi):
    return 0.00278710230306644*(1.0 - cos(theta)**2)*(1858239558945.64*cos(theta)**32 - 13756519719955.8*cos(theta)**30 + 46031431370621.2*cos(theta)**28 - 92062862741242.5*cos(theta)**26 + 122624714716819.0*cos(theta)**24 - 114726851735058.0*cos(theta)**22 + 77490943715784.6*cos(theta)**20 - 38242283911685.9*cos(theta)**18 + 13799692071905.5*cos(theta)**16 - 3607762633177.91*cos(theta)**14 + 670013060447.327*cos(theta)**12 - 85533582184.7651*cos(theta)**10 + 7127798515.39709*cos(theta)**8 - 357027474.832055*cos(theta)**6 + 9329986.27609899*cos(theta)**4 - 95692.1669343486*cos(theta)**2 + 161.642173875589)*sin(2*phi)

@torch.jit.script
def Yl34_m_minus_1(theta, phi):
    return 0.0960641026936534*(1.0 - cos(theta)**2)**0.5*(56310289665.0193*cos(theta)**33 - 443758700643.735*cos(theta)**31 + 1587290736917.97*cos(theta)**29 - 3409735657083.05*cos(theta)**27 + 4904988588672.75*cos(theta)**25 - 4988123988480.77*cos(theta)**23 + 3690044938846.88*cos(theta)**21 - 2012751784825.57*cos(theta)**19 + 811746592465.031*cos(theta)**17 - 240517508878.528*cos(theta)**15 + 51539466188.2559*cos(theta)**13 - 7775780198.61501*cos(theta)**11 + 791977612.821899*cos(theta)**9 - 51003924.9760078*cos(theta)**7 + 1865997.2552198*cos(theta)**5 - 31897.3889781162*cos(theta)**3 + 161.642173875589*cos(theta))*sin(phi)

@torch.jit.script
def Yl34_m0(theta, phi):
    return 3880864303.89673*cos(theta)**34 - 32494998126.6577*cos(theta)**32 + 123980915929.402*cos(theta)**30 - 285352901742.274*cos(theta)**28 + 442063101879.424*cos(theta)**26 - 487018671562.077*cos(theta)**24 + 393032612137.817*cos(theta)**22 - 235819567282.69*cos(theta)**20 + 105673862697.432*cos(theta)**18 - 35224620899.1439*cos(theta)**16 + 8626437771.21892*cos(theta)**14 - 1518386532.26484*cos(theta)**12 + 185580576.165703*cos(theta)**10 - 14939402.3746988*cos(theta)**8 + 728751.33535116*cos(theta)**6 - 18685.9316756708*cos(theta)**4 + 189.384442658825*cos(theta)**2 - 0.318293180939202

@torch.jit.script
def Yl34_m1(theta, phi):
    return 0.0960641026936534*(1.0 - cos(theta)**2)**0.5*(56310289665.0193*cos(theta)**33 - 443758700643.735*cos(theta)**31 + 1587290736917.97*cos(theta)**29 - 3409735657083.05*cos(theta)**27 + 4904988588672.75*cos(theta)**25 - 4988123988480.77*cos(theta)**23 + 3690044938846.88*cos(theta)**21 - 2012751784825.57*cos(theta)**19 + 811746592465.031*cos(theta)**17 - 240517508878.528*cos(theta)**15 + 51539466188.2559*cos(theta)**13 - 7775780198.61501*cos(theta)**11 + 791977612.821899*cos(theta)**9 - 51003924.9760078*cos(theta)**7 + 1865997.2552198*cos(theta)**5 - 31897.3889781162*cos(theta)**3 + 161.642173875589*cos(theta))*cos(phi)

@torch.jit.script
def Yl34_m2(theta, phi):
    return 0.00278710230306644*(1.0 - cos(theta)**2)*(1858239558945.64*cos(theta)**32 - 13756519719955.8*cos(theta)**30 + 46031431370621.2*cos(theta)**28 - 92062862741242.5*cos(theta)**26 + 122624714716819.0*cos(theta)**24 - 114726851735058.0*cos(theta)**22 + 77490943715784.6*cos(theta)**20 - 38242283911685.9*cos(theta)**18 + 13799692071905.5*cos(theta)**16 - 3607762633177.91*cos(theta)**14 + 670013060447.327*cos(theta)**12 - 85533582184.7651*cos(theta)**10 + 7127798515.39709*cos(theta)**8 - 357027474.832055*cos(theta)**6 + 9329986.27609899*cos(theta)**4 - 95692.1669343486*cos(theta)**2 + 161.642173875589)*cos(2*phi)

@torch.jit.script
def Yl34_m3(theta, phi):
    return 8.09985154172335e-5*(1.0 - cos(theta)**2)**1.5*(59463665886260.4*cos(theta)**31 - 412695591598673.0*cos(theta)**29 + 1.28888007837739e+15*cos(theta)**27 - 2.3936344312723e+15*cos(theta)**25 + 2.94299315320365e+15*cos(theta)**23 - 2.52399073817127e+15*cos(theta)**21 + 1.54981887431569e+15*cos(theta)**19 - 688361110410346.0*cos(theta)**17 + 220795073150488.0*cos(theta)**15 - 50508676864490.8*cos(theta)**13 + 8040156725367.92*cos(theta)**11 - 855335821847.651*cos(theta)**9 + 57022388123.1768*cos(theta)**7 - 2142164848.99233*cos(theta)**5 + 37319945.104396*cos(theta)**3 - 191384.333868697*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl34_m4(theta, phi):
    return 2.35995875978251e-6*(1.0 - cos(theta)**2)**2*(1.84337364247407e+15*cos(theta)**30 - 1.19681721563615e+16*cos(theta)**28 + 3.47997621161897e+16*cos(theta)**26 - 5.98408607818076e+16*cos(theta)**24 + 6.7688842523684e+16*cos(theta)**22 - 5.30038055015966e+16*cos(theta)**20 + 2.94465586119981e+16*cos(theta)**18 - 1.17021388769759e+16*cos(theta)**16 + 3.31192609725732e+15*cos(theta)**14 - 656612799238380.0*cos(theta)**12 + 88441723979047.1*cos(theta)**10 - 7698022396628.86*cos(theta)**8 + 399156716862.237*cos(theta)**6 - 10710824244.9616*cos(theta)**4 + 111959835.313188*cos(theta)**2 - 191384.333868697)*cos(4*phi)

@torch.jit.script
def Yl34_m5(theta, phi):
    return 6.89940251833707e-8*(1.0 - cos(theta)**2)**2.5*(5.53012092742222e+16*cos(theta)**29 - 3.35108820378123e+17*cos(theta)**27 + 9.04793815020931e+17*cos(theta)**25 - 1.43618065876338e+18*cos(theta)**23 + 1.48915453552105e+18*cos(theta)**21 - 1.06007611003193e+18*cos(theta)**19 + 5.30038055015966e+17*cos(theta)**17 - 1.87234222031614e+17*cos(theta)**15 + 4.63669653616025e+16*cos(theta)**13 - 7.87935359086056e+15*cos(theta)**11 + 884417239790471.0*cos(theta)**9 - 61584179173030.9*cos(theta)**7 + 2394940301173.42*cos(theta)**5 - 42843296979.8466*cos(theta)**3 + 223919670.626376*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl34_m6(theta, phi):
    return 2.0257343306691e-9*(1.0 - cos(theta)**2)**3*(1.60373506895244e+18*cos(theta)**28 - 9.04793815020931e+18*cos(theta)**26 + 2.26198453755233e+19*cos(theta)**24 - 3.30321551515578e+19*cos(theta)**22 + 3.1272245245942e+19*cos(theta)**20 - 2.01414460906067e+19*cos(theta)**18 + 9.01064693527143e+18*cos(theta)**16 - 2.80851333047421e+18*cos(theta)**14 + 6.02770549700833e+17*cos(theta)**12 - 8.66728894994662e+16*cos(theta)**10 + 7.95975515811424e+15*cos(theta)**8 - 431089254211216.0*cos(theta)**6 + 11974701505867.1*cos(theta)**4 - 128529890939.54*cos(theta)**2 + 223919670.626376)*cos(6*phi)

@torch.jit.script
def Yl34_m7(theta, phi):
    return 5.97876583646464e-11*(1.0 - cos(theta)**2)**3.5*(4.49045819306684e+19*cos(theta)**27 - 2.35246391905442e+20*cos(theta)**25 + 5.42876289012559e+20*cos(theta)**23 - 7.26707413334272e+20*cos(theta)**21 + 6.2544490491884e+20*cos(theta)**19 - 3.62546029630921e+20*cos(theta)**17 + 1.44170350964343e+20*cos(theta)**15 - 3.9319186626639e+19*cos(theta)**13 + 7.23324659641e+18*cos(theta)**11 - 8.66728894994662e+17*cos(theta)**9 + 6.36780412649139e+16*cos(theta)**7 - 2.5865355252673e+15*cos(theta)**5 + 47898806023468.5*cos(theta)**3 - 257059781879.079*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl34_m8(theta, phi):
    return 1.77543598061902e-12*(1.0 - cos(theta)**2)**4*(1.21242371212805e+21*cos(theta)**26 - 5.88115979763605e+21*cos(theta)**24 + 1.24861546472888e+22*cos(theta)**22 - 1.52608556800197e+22*cos(theta)**20 + 1.1883453193458e+22*cos(theta)**18 - 6.16328250372566e+21*cos(theta)**16 + 2.16255526446514e+21*cos(theta)**14 - 5.11149426146306e+20*cos(theta)**12 + 7.956571256051e+19*cos(theta)**10 - 7.80056005495196e+18*cos(theta)**8 + 4.45746288854398e+17*cos(theta)**6 - 1.29326776263365e+16*cos(theta)**4 + 143696418070405.0*cos(theta)**2 - 257059781879.079)*cos(8*phi)

@torch.jit.script
def Yl34_m9(theta, phi):
    return 5.30987277141628e-14*(1.0 - cos(theta)**2)**4.5*(3.15230165153292e+22*cos(theta)**25 - 1.41147835143265e+23*cos(theta)**23 + 2.74695402240355e+23*cos(theta)**21 - 3.05217113600394e+23*cos(theta)**19 + 2.13902157482243e+23*cos(theta)**17 - 9.86125200596105e+22*cos(theta)**15 + 3.0275773702512e+22*cos(theta)**13 - 6.13379311375568e+21*cos(theta)**11 + 7.956571256051e+20*cos(theta)**9 - 6.24044804396157e+19*cos(theta)**7 + 2.67447773312639e+18*cos(theta)**5 - 5.17307105053459e+16*cos(theta)**3 + 287392836140811.0*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl34_m10(theta, phi):
    return 1.60098687884658e-15*(1.0 - cos(theta)**2)**5*(7.88075412883231e+23*cos(theta)**24 - 3.2464002082951e+24*cos(theta)**22 + 5.76860344704745e+24*cos(theta)**20 - 5.79912515840749e+24*cos(theta)**18 + 3.63633667719814e+24*cos(theta)**16 - 1.47918780089416e+24*cos(theta)**14 + 3.93585058132656e+23*cos(theta)**12 - 6.74717242513125e+22*cos(theta)**10 + 7.1609141304459e+21*cos(theta)**8 - 4.3683136307731e+20*cos(theta)**6 + 1.33723886656319e+19*cos(theta)**4 - 1.55192131516038e+17*cos(theta)**2 + 287392836140811.0)*cos(10*phi)

@torch.jit.script
def Yl34_m11(theta, phi):
    return 4.87164793230034e-17*(1.0 - cos(theta)**2)**5.5*(1.89138099091975e+25*cos(theta)**23 - 7.14208045824922e+25*cos(theta)**21 + 1.15372068940949e+26*cos(theta)**19 - 1.04384252851335e+26*cos(theta)**17 + 5.81813868351702e+25*cos(theta)**15 - 2.07086292125182e+25*cos(theta)**13 + 4.72302069759187e+24*cos(theta)**11 - 6.74717242513125e+23*cos(theta)**9 + 5.72873130435672e+22*cos(theta)**7 - 2.62098817846386e+21*cos(theta)**5 + 5.34895546625277e+19*cos(theta)**3 - 3.10384263032076e+17*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl34_m12(theta, phi):
    return 1.49772838629695e-18*(1.0 - cos(theta)**2)**6*(4.35017627911543e+26*cos(theta)**22 - 1.49983689623234e+27*cos(theta)**20 + 2.19206930987803e+27*cos(theta)**18 - 1.77453229847269e+27*cos(theta)**16 + 8.72720802527553e+26*cos(theta)**14 - 2.69212179762737e+26*cos(theta)**12 + 5.19532276735106e+25*cos(theta)**10 - 6.07245518261812e+24*cos(theta)**8 + 4.0101119130497e+23*cos(theta)**6 - 1.31049408923193e+22*cos(theta)**4 + 1.60468663987583e+20*cos(theta)**2 - 3.10384263032076e+17)*cos(12*phi)

@torch.jit.script
def Yl34_m13(theta, phi):
    return 4.65771371921163e-20*(1.0 - cos(theta)**2)**6.5*(9.57038781405396e+27*cos(theta)**21 - 2.99967379246467e+28*cos(theta)**19 + 3.94572475778045e+28*cos(theta)**17 - 2.83925167755631e+28*cos(theta)**15 + 1.22180912353857e+28*cos(theta)**13 - 3.23054615715284e+27*cos(theta)**11 + 5.19532276735106e+26*cos(theta)**9 - 4.8579641460945e+25*cos(theta)**7 + 2.40606714782982e+24*cos(theta)**5 - 5.24197635692772e+22*cos(theta)**3 + 3.20937327975166e+20*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl34_m14(theta, phi):
    return 1.46704192609139e-21*(1.0 - cos(theta)**2)**7*(2.00978144095133e+29*cos(theta)**20 - 5.69938020568288e+29*cos(theta)**18 + 6.70773208822677e+29*cos(theta)**16 - 4.25887751633446e+29*cos(theta)**14 + 1.58835186060015e+29*cos(theta)**12 - 3.55360077286812e+28*cos(theta)**10 + 4.67579049061595e+27*cos(theta)**8 - 3.40057490226615e+26*cos(theta)**6 + 1.20303357391491e+25*cos(theta)**4 - 1.57259290707831e+23*cos(theta)**2 + 3.20937327975166e+20)*cos(14*phi)

@torch.jit.script
def Yl34_m15(theta, phi):
    return 4.68629353226083e-23*(1.0 - cos(theta)**2)**7.5*(4.01956288190266e+30*cos(theta)**19 - 1.02588843702292e+31*cos(theta)**17 + 1.07323713411628e+31*cos(theta)**15 - 5.96242852286824e+30*cos(theta)**13 + 1.90602223272018e+30*cos(theta)**11 - 3.55360077286812e+29*cos(theta)**9 + 3.74063239249276e+28*cos(theta)**7 - 2.04034494135969e+27*cos(theta)**5 + 4.81213429565964e+25*cos(theta)**3 - 3.14518581415663e+23*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl34_m16(theta, phi):
    return 1.52043439327851e-24*(1.0 - cos(theta)**2)**8*(7.63716947561506e+31*cos(theta)**18 - 1.74401034293896e+32*cos(theta)**16 + 1.60985570117443e+32*cos(theta)**14 - 7.75115707972871e+31*cos(theta)**12 + 2.09662445599219e+31*cos(theta)**10 - 3.19824069558131e+30*cos(theta)**8 + 2.61844267474493e+29*cos(theta)**6 - 1.02017247067984e+28*cos(theta)**4 + 1.44364028869789e+26*cos(theta)**2 - 3.14518581415663e+23)*cos(16*phi)

@torch.jit.script
def Yl34_m17(theta, phi):
    return 5.01818126253981e-26*(1.0 - cos(theta)**2)**8.5*(1.37469050561071e+33*cos(theta)**17 - 2.79041654870234e+33*cos(theta)**15 + 2.2537979816442e+33*cos(theta)**13 - 9.30138849567446e+32*cos(theta)**11 + 2.09662445599219e+32*cos(theta)**9 - 2.55859255646505e+31*cos(theta)**7 + 1.57106560484696e+30*cos(theta)**5 - 4.08068988271938e+28*cos(theta)**3 + 2.88728057739579e+26*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl34_m18(theta, phi):
    return 1.6877970053263e-27*(1.0 - cos(theta)**2)**9*(2.33697385953821e+34*cos(theta)**16 - 4.18562482305351e+34*cos(theta)**14 + 2.92993737613745e+34*cos(theta)**12 - 1.02315273452419e+34*cos(theta)**10 + 1.88696201039297e+33*cos(theta)**8 - 1.79101478952553e+32*cos(theta)**6 + 7.8553280242348e+30*cos(theta)**4 - 1.22420696481581e+29*cos(theta)**2 + 2.88728057739579e+26)*cos(18*phi)

@torch.jit.script
def Yl34_m19(theta, phi):
    return 5.79591871206322e-29*(1.0 - cos(theta)**2)**9.5*(3.73915817526113e+35*cos(theta)**15 - 5.85987475227491e+35*cos(theta)**13 + 3.51592485136495e+35*cos(theta)**11 - 1.02315273452419e+35*cos(theta)**9 + 1.50956960831438e+34*cos(theta)**7 - 1.07460887371532e+33*cos(theta)**5 + 3.14213120969392e+31*cos(theta)**3 - 2.44841392963163e+29*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl34_m20(theta, phi):
    return 2.03647825147882e-30*(1.0 - cos(theta)**2)**10*(5.6087372628917e+36*cos(theta)**14 - 7.61783717795738e+36*cos(theta)**12 + 3.86751733650144e+36*cos(theta)**10 - 9.20837461071771e+35*cos(theta)**8 + 1.05669872582007e+35*cos(theta)**6 - 5.3730443685766e+33*cos(theta)**4 + 9.42639362908176e+31*cos(theta)**2 - 2.44841392963163e+29)*cos(20*phi)

@torch.jit.script
def Yl34_m21(theta, phi):
    return 7.33895819488808e-32*(1.0 - cos(theta)**2)**10.5*(7.85223216804838e+37*cos(theta)**13 - 9.14140461354886e+37*cos(theta)**11 + 3.86751733650144e+37*cos(theta)**9 - 7.36669968857417e+36*cos(theta)**7 + 6.34019235492039e+35*cos(theta)**5 - 2.14921774743064e+34*cos(theta)**3 + 1.88527872581635e+32*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl34_m22(theta, phi):
    return 2.71999887348259e-33*(1.0 - cos(theta)**2)**11*(1.02079018184629e+39*cos(theta)**12 - 1.00555450749037e+39*cos(theta)**10 + 3.4807656028513e+38*cos(theta)**8 - 5.15668978200192e+37*cos(theta)**6 + 3.1700961774602e+36*cos(theta)**4 - 6.44765324229192e+34*cos(theta)**2 + 1.88527872581635e+32)*cos(22*phi)

@torch.jit.script
def Yl34_m23(theta, phi):
    return 1.04001756281185e-34*(1.0 - cos(theta)**2)**11.5*(1.22494821821555e+40*cos(theta)**11 - 1.00555450749037e+40*cos(theta)**9 + 2.78461248228104e+39*cos(theta)**7 - 3.09401386920115e+38*cos(theta)**5 + 1.26803847098408e+37*cos(theta)**3 - 1.28953064845838e+35*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl34_m24(theta, phi):
    return 4.11746896065541e-36*(1.0 - cos(theta)**2)**12*(1.3474430400371e+41*cos(theta)**10 - 9.04999056741337e+40*cos(theta)**8 + 1.94922873759673e+40*cos(theta)**6 - 1.54700693460058e+39*cos(theta)**4 + 3.80411541295224e+37*cos(theta)**2 - 1.28953064845838e+35)*cos(24*phi)

@torch.jit.script
def Yl34_m25(theta, phi):
    return 1.69513514495286e-37*(1.0 - cos(theta)**2)**12.5*(1.3474430400371e+42*cos(theta)**9 - 7.23999245393069e+41*cos(theta)**7 + 1.16953724255804e+41*cos(theta)**5 - 6.1880277384023e+39*cos(theta)**3 + 7.60823082590447e+37*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl34_m26(theta, phi):
    return 7.29470020663704e-39*(1.0 - cos(theta)**2)**13*(1.21269873603339e+43*cos(theta)**8 - 5.06799471775149e+42*cos(theta)**6 + 5.84768621279018e+41*cos(theta)**4 - 1.85640832152069e+40*cos(theta)**2 + 7.60823082590447e+37)*cos(26*phi)

@torch.jit.script
def Yl34_m27(theta, phi):
    return 3.30215562682199e-40*(1.0 - cos(theta)**2)**13.5*(9.70158988826713e+43*cos(theta)**7 - 3.04079683065089e+43*cos(theta)**5 + 2.33907448511607e+42*cos(theta)**3 - 3.71281664304138e+40*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl34_m28(theta, phi):
    return 1.58508542441973e-41*(1.0 - cos(theta)**2)**14*(6.79111292178699e+44*cos(theta)**6 - 1.52039841532545e+44*cos(theta)**4 + 7.01722345534821e+42*cos(theta)**2 - 3.71281664304138e+40)*cos(28*phi)

@torch.jit.script
def Yl34_m29(theta, phi):
    return 8.15279969880161e-43*(1.0 - cos(theta)**2)**14.5*(4.0746677530722e+45*cos(theta)**5 - 6.08159366130178e+44*cos(theta)**3 + 1.40344469106964e+43*cos(theta))*cos(29*phi)

@torch.jit.script
def Yl34_m30(theta, phi):
    return 4.55755358336505e-44*(1.0 - cos(theta)**2)**15*(2.0373338765361e+46*cos(theta)**4 - 1.82447809839054e+45*cos(theta)**2 + 1.40344469106964e+43)*cos(30*phi)

@torch.jit.script
def Yl34_m31(theta, phi):
    return 2.8264747454439e-45*(1.0 - cos(theta)**2)**15.5*(8.14933550614439e+46*cos(theta)**3 - 3.64895619678107e+45*cos(theta))*cos(31*phi)

@torch.jit.script
def Yl34_m32(theta, phi):
    return 2.0086881349656e-46*(1.0 - cos(theta)**2)**16*(2.44480065184332e+47*cos(theta)**2 - 3.64895619678107e+45)*cos(32*phi)

@torch.jit.script
def Yl34_m33(theta, phi):
    return 8.48464280026292*(1.0 - cos(theta)**2)**16.5*cos(33*phi)*cos(theta)

@torch.jit.script
def Yl34_m34(theta, phi):
    return 1.0289140723859*(1.0 - cos(theta)**2)**17*cos(34*phi)

@torch.jit.script
def Yl35_m_minus_35(theta, phi):
    return 1.03623739663619*(1.0 - cos(theta)**2)**17.5*sin(35*phi)

@torch.jit.script
def Yl35_m_minus_34(theta, phi):
    return 8.66978407765238*(1.0 - cos(theta)**2)**17*sin(34*phi)*cos(theta)

@torch.jit.script
def Yl35_m_minus_33(theta, phi):
    return 3.01873705359384e-48*(1.0 - cos(theta)**2)**16.5*(1.68691244977189e+49*cos(theta)**2 - 2.44480065184332e+47)*sin(33*phi)

@torch.jit.script
def Yl35_m_minus_32(theta, phi):
    return 4.31161892256615e-47*(1.0 - cos(theta)**2)**16*(5.62304149923963e+48*cos(theta)**3 - 2.44480065184332e+47*cos(theta))*sin(32*phi)

@torch.jit.script
def Yl35_m_minus_31(theta, phi):
    return 7.05842437981691e-46*(1.0 - cos(theta)**2)**15.5*(1.40576037480991e+48*cos(theta)**4 - 1.22240032592166e+47*cos(theta)**2 + 9.12239049195268e+44)*sin(31*phi)

@torch.jit.script
def Yl35_m_minus_30(theta, phi):
    return 1.28222646437538e-44*(1.0 - cos(theta)**2)**15*(2.81152074961981e+47*cos(theta)**5 - 4.0746677530722e+46*cos(theta)**3 + 9.12239049195268e+44*cos(theta))*sin(30*phi)

@torch.jit.script
def Yl35_m_minus_29(theta, phi):
    return 2.53219437507943e-43*(1.0 - cos(theta)**2)**14.5*(4.68586791603302e+46*cos(theta)**6 - 1.01866693826805e+46*cos(theta)**4 + 4.56119524597634e+44*cos(theta)**2 - 2.33907448511607e+42)*sin(29*phi)

@torch.jit.script
def Yl35_m_minus_28(theta, phi):
    return 5.35964527018943e-42*(1.0 - cos(theta)**2)**14*(6.69409702290432e+45*cos(theta)**7 - 2.0373338765361e+45*cos(theta)**5 + 1.52039841532545e+44*cos(theta)**3 - 2.33907448511607e+42*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl35_m_minus_27(theta, phi):
    return 1.20323737894154e-40*(1.0 - cos(theta)**2)**13.5*(8.3676212786304e+44*cos(theta)**8 - 3.3955564608935e+44*cos(theta)**6 + 3.80099603831361e+43*cos(theta)**4 - 1.16953724255804e+42*cos(theta)**2 + 4.64102080380173e+39)*sin(27*phi)

@torch.jit.script
def Yl35_m_minus_26(theta, phi):
    return 2.8422901788273e-39*(1.0 - cos(theta)**2)**13*(9.297356976256e+43*cos(theta)**9 - 4.85079494413357e+43*cos(theta)**7 + 7.60199207662723e+42*cos(theta)**5 - 3.89845747519345e+41*cos(theta)**3 + 4.64102080380173e+39*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl35_m_minus_25(theta, phi):
    return 7.01993889645875e-38*(1.0 - cos(theta)**2)**12.5*(9.297356976256e+42*cos(theta)**10 - 6.06349368016696e+42*cos(theta)**8 + 1.26699867943787e+42*cos(theta)**6 - 9.74614368798363e+40*cos(theta)**4 + 2.32051040190086e+39*cos(theta)**2 - 7.60823082590447e+36)*sin(25*phi)

@torch.jit.script
def Yl35_m_minus_24(theta, phi):
    return 1.80345495626061e-36*(1.0 - cos(theta)**2)**12*(8.45214270568727e+41*cos(theta)**11 - 6.73721520018551e+41*cos(theta)**9 + 1.80999811348267e+41*cos(theta)**7 - 1.94922873759673e+40*cos(theta)**5 + 7.73503467300288e+38*cos(theta)**3 - 7.60823082590447e+36*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl35_m_minus_23(theta, phi):
    return 4.79868153112577e-35*(1.0 - cos(theta)**2)**11.5*(7.04345225473939e+40*cos(theta)**12 - 6.73721520018551e+40*cos(theta)**10 + 2.26249764185334e+40*cos(theta)**8 - 3.24871456266121e+39*cos(theta)**6 + 1.93375866825072e+38*cos(theta)**4 - 3.80411541295224e+36*cos(theta)**2 + 1.07460887371532e+34)*sin(23*phi)

@torch.jit.script
def Yl35_m_minus_22(theta, phi):
    return 1.31767286173862e-33*(1.0 - cos(theta)**2)**11*(5.41804019595338e+39*cos(theta)**13 - 6.12474109107773e+39*cos(theta)**11 + 2.51388626872594e+39*cos(theta)**9 - 4.64102080380173e+38*cos(theta)**7 + 3.86751733650144e+37*cos(theta)**5 - 1.26803847098408e+36*cos(theta)**3 + 1.07460887371532e+34*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl35_m_minus_21(theta, phi):
    return 3.72228007128537e-32*(1.0 - cos(theta)**2)**10.5*(3.87002871139527e+38*cos(theta)**14 - 5.10395090923145e+38*cos(theta)**12 + 2.51388626872594e+38*cos(theta)**10 - 5.80127600475216e+37*cos(theta)**8 + 6.4458622275024e+36*cos(theta)**6 - 3.1700961774602e+35*cos(theta)**4 + 5.3730443685766e+33*cos(theta)**2 - 1.34662766129739e+31)*sin(21*phi)

@torch.jit.script
def Yl35_m_minus_20(theta, phi):
    return 1.07881925735658e-30*(1.0 - cos(theta)**2)**10*(2.58001914093018e+37*cos(theta)**15 - 3.92611608402419e+37*cos(theta)**13 + 2.28535115338721e+37*cos(theta)**11 - 6.4458622275024e+36*cos(theta)**9 + 9.20837461071771e+35*cos(theta)**7 - 6.34019235492039e+34*cos(theta)**5 + 1.79101478952553e+33*cos(theta)**3 - 1.34662766129739e+31*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl35_m_minus_19(theta, phi):
    return 3.20029509770303e-29*(1.0 - cos(theta)**2)**9.5*(1.61251196308136e+36*cos(theta)**16 - 2.80436863144585e+36*cos(theta)**14 + 1.90445929448935e+36*cos(theta)**12 - 6.4458622275024e+35*cos(theta)**10 + 1.15104682633971e+35*cos(theta)**8 - 1.05669872582007e+34*cos(theta)**6 + 4.47753697381384e+32*cos(theta)**4 - 6.73313830648697e+30*cos(theta)**2 + 1.53025870601977e+28)*sin(19*phi)

@torch.jit.script
def Yl35_m_minus_18(theta, phi):
    return 9.6964188430403e-28*(1.0 - cos(theta)**2)**9*(9.4853644887139e+34*cos(theta)**17 - 1.86957908763057e+35*cos(theta)**15 + 1.46496868806873e+35*cos(theta)**13 - 5.85987475227491e+34*cos(theta)**11 + 1.27894091815524e+34*cos(theta)**9 - 1.50956960831438e+33*cos(theta)**7 + 8.95507394762767e+31*cos(theta)**5 - 2.24437943549566e+30*cos(theta)**3 + 1.53025870601977e+28*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl35_m_minus_17(theta, phi):
    return 2.9949222630012e-26*(1.0 - cos(theta)**2)**8.5*(5.26964693817439e+33*cos(theta)**18 - 1.1684869297691e+34*cos(theta)**16 + 1.04640620576338e+34*cos(theta)**14 - 4.88322896022909e+33*cos(theta)**12 + 1.27894091815524e+33*cos(theta)**10 - 1.88696201039297e+32*cos(theta)**8 + 1.49251232460461e+31*cos(theta)**6 - 5.61094858873914e+29*cos(theta)**4 + 7.65129353009883e+27*cos(theta)**2 - 1.60404476521988e+25)*sin(17*phi)

@torch.jit.script
def Yl35_m_minus_16(theta, phi):
    return 9.41377960708832e-25*(1.0 - cos(theta)**2)**8*(2.77349838851284e+32*cos(theta)**19 - 6.87345252805355e+32*cos(theta)**17 + 6.97604137175584e+32*cos(theta)**15 - 3.75632996940699e+32*cos(theta)**13 + 1.16267356195931e+32*cos(theta)**11 - 2.09662445599219e+31*cos(theta)**9 + 2.13216046372087e+30*cos(theta)**7 - 1.12218971774783e+29*cos(theta)**5 + 2.55043117669961e+27*cos(theta)**3 - 1.60404476521988e+25*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl35_m_minus_15(theta, phi):
    return 3.00652010504917e-23*(1.0 - cos(theta)**2)**7.5*(1.38674919425642e+31*cos(theta)**20 - 3.81858473780753e+31*cos(theta)**18 + 4.3600258573474e+31*cos(theta)**16 - 2.68309283529071e+31*cos(theta)**14 + 9.68894634966089e+30*cos(theta)**12 - 2.09662445599219e+30*cos(theta)**10 + 2.66520057965109e+29*cos(theta)**8 - 1.87031619624638e+28*cos(theta)**6 + 6.37607794174903e+26*cos(theta)**4 - 8.02022382609941e+24*cos(theta)**2 + 1.57259290707831e+22)*sin(15*phi)

@torch.jit.script
def Yl35_m_minus_14(theta, phi):
    return 9.74223860268681e-22*(1.0 - cos(theta)**2)**7*(6.60356759169723e+29*cos(theta)**21 - 2.00978144095133e+30*cos(theta)**19 + 2.5647210925573e+30*cos(theta)**17 - 1.78872855686047e+30*cos(theta)**15 + 7.4530356535853e+29*cos(theta)**13 - 1.90602223272018e+29*cos(theta)**11 + 2.9613339773901e+28*cos(theta)**9 - 2.67188028035197e+27*cos(theta)**7 + 1.27521558834981e+26*cos(theta)**5 - 2.67340794203313e+24*cos(theta)**3 + 1.57259290707831e+22*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl35_m_minus_13(theta, phi):
    return 3.19866046346017e-20*(1.0 - cos(theta)**2)**6.5*(3.00162163258965e+28*cos(theta)**22 - 1.00489072047567e+29*cos(theta)**20 + 1.42484505142072e+29*cos(theta)**18 - 1.1179553480378e+29*cos(theta)**16 + 5.32359689541807e+28*cos(theta)**14 - 1.58835186060015e+28*cos(theta)**12 + 2.9613339773901e+27*cos(theta)**10 - 3.33985035043997e+26*cos(theta)**8 + 2.12535931391634e+25*cos(theta)**6 - 6.68351985508284e+23*cos(theta)**4 + 7.86296453539157e+21*cos(theta)**2 - 1.45880603625076e+19)*sin(13*phi)

@torch.jit.script
def Yl35_m_minus_12(theta, phi):
    return 1.06280277340603e-18*(1.0 - cos(theta)**2)**6*(1.30505288373463e+27*cos(theta)**23 - 4.78519390702698e+27*cos(theta)**21 + 7.49918448116168e+27*cos(theta)**19 - 6.57620792963409e+27*cos(theta)**17 + 3.54906459694538e+27*cos(theta)**15 - 1.22180912353857e+27*cos(theta)**13 + 2.69212179762737e+26*cos(theta)**11 - 3.71094483382218e+25*cos(theta)**9 + 3.03622759130906e+24*cos(theta)**7 - 1.33670397101657e+23*cos(theta)**5 + 2.62098817846386e+21*cos(theta)**3 - 1.45880603625076e+19*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl35_m_minus_11(theta, phi):
    return 3.56949870606501e-17*(1.0 - cos(theta)**2)**5.5*(5.43772034889429e+25*cos(theta)**24 - 2.17508813955772e+26*cos(theta)**22 + 3.74959224058084e+26*cos(theta)**20 - 3.65344884979672e+26*cos(theta)**18 + 2.21816537309086e+26*cos(theta)**16 - 8.72720802527553e+25*cos(theta)**14 + 2.24343483135614e+25*cos(theta)**12 - 3.71094483382219e+24*cos(theta)**10 + 3.79528448913633e+23*cos(theta)**8 - 2.22783995169428e+22*cos(theta)**6 + 6.55247044615964e+20*cos(theta)**4 - 7.29403018125378e+18*cos(theta)**2 + 1.29326776263365e+16)*sin(11*phi)

@torch.jit.script
def Yl35_m_minus_10(theta, phi):
    return 1.21047590494358e-15*(1.0 - cos(theta)**2)**5*(2.17508813955772e+24*cos(theta)**25 - 9.45690495459877e+24*cos(theta)**23 + 1.78552011456231e+25*cos(theta)**21 - 1.92286781568248e+25*cos(theta)**19 + 1.30480316064168e+25*cos(theta)**17 - 5.81813868351702e+24*cos(theta)**15 + 1.72571910104318e+24*cos(theta)**13 - 3.37358621256562e+23*cos(theta)**11 + 4.21698276570703e+22*cos(theta)**9 - 3.1826285024204e+21*cos(theta)**7 + 1.31049408923193e+20*cos(theta)**5 - 2.43134339375126e+18*cos(theta)**3 + 1.29326776263365e+16*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl35_m_minus_9(theta, phi):
    return 4.14046463847392e-14*(1.0 - cos(theta)**2)**4.5*(8.36572361368353e+22*cos(theta)**26 - 3.94037706441615e+23*cos(theta)**24 + 8.11600052073775e+23*cos(theta)**22 - 9.61433907841241e+23*cos(theta)**20 + 7.24890644800936e+23*cos(theta)**18 - 3.63633667719814e+23*cos(theta)**16 + 1.23265650074513e+23*cos(theta)**14 - 2.81132184380469e+22*cos(theta)**12 + 4.21698276570703e+21*cos(theta)**10 - 3.9782856280255e+20*cos(theta)**8 + 2.18415681538655e+19*cos(theta)**6 - 6.07835848437815e+17*cos(theta)**4 + 6.46633881316824e+15*cos(theta)**2 - 11053570620800.4)*sin(9*phi)

@torch.jit.script
def Yl35_m_minus_8(theta, phi):
    return 1.42710951008933e-12*(1.0 - cos(theta)**2)**4*(3.09841615321612e+21*cos(theta)**27 - 1.57615082576646e+22*cos(theta)**25 + 3.52869587858163e+22*cos(theta)**23 - 4.57825670400591e+22*cos(theta)**21 + 3.81521392000493e+22*cos(theta)**19 - 2.13902157482243e+22*cos(theta)**17 + 8.21771000496754e+21*cos(theta)**15 - 2.16255526446514e+21*cos(theta)**13 + 3.8336206960973e+20*cos(theta)**11 - 4.42031736447278e+19*cos(theta)**9 + 3.12022402198078e+18*cos(theta)**7 - 1.21567169687563e+17*cos(theta)**5 + 2.15544627105608e+15*cos(theta)**3 - 11053570620800.4*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl35_m_minus_7(theta, phi):
    return 4.95188492471306e-11*(1.0 - cos(theta)**2)**3.5*(1.10657719757719e+20*cos(theta)**28 - 6.06211856064024e+20*cos(theta)**26 + 1.47028994940901e+21*cos(theta)**24 - 2.08102577454814e+21*cos(theta)**22 + 1.90760696000246e+21*cos(theta)**20 - 1.1883453193458e+21*cos(theta)**18 + 5.13606875310471e+20*cos(theta)**16 - 1.54468233176082e+20*cos(theta)**14 + 3.19468391341442e+19*cos(theta)**12 - 4.42031736447278e+18*cos(theta)**10 + 3.90028002747598e+17*cos(theta)**8 - 2.02611949479272e+16*cos(theta)**6 + 538861567764020.0*cos(theta)**4 - 5526785310400.21*cos(theta)**2 + 9180706495.68141)*sin(7*phi)

@torch.jit.script
def Yl35_m_minus_6(theta, phi):
    return 1.72820074431929e-9*(1.0 - cos(theta)**2)**3*(3.81578343992133e+18*cos(theta)**29 - 2.24522909653342e+19*cos(theta)**27 + 5.88115979763605e+19*cos(theta)**25 - 9.04793815020931e+19*cos(theta)**23 + 9.08384266667839e+19*cos(theta)**21 - 6.2544490491884e+19*cos(theta)**19 + 3.02121691359101e+19*cos(theta)**17 - 1.02978822117388e+19*cos(theta)**15 + 2.45744916416494e+18*cos(theta)**13 - 4.01847033133889e+17*cos(theta)**11 + 4.33364447497331e+16*cos(theta)**9 - 2.89445642113245e+15*cos(theta)**7 + 107772313552804.0*cos(theta)**5 - 1842261770133.4*cos(theta)**3 + 9180706495.68141*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl35_m_minus_5(theta, phi):
    return 6.06103432557419e-8*(1.0 - cos(theta)**2)**2.5*(1.27192781330711e+17*cos(theta)**30 - 8.01867534476222e+17*cos(theta)**28 + 2.26198453755233e+18*cos(theta)**26 - 3.76997422925388e+18*cos(theta)**24 + 4.12901939394472e+18*cos(theta)**22 - 3.1272245245942e+18*cos(theta)**20 + 1.67845384088389e+18*cos(theta)**18 - 6.43617638233673e+17*cos(theta)**16 + 1.75532083154638e+17*cos(theta)**14 - 3.34872527611574e+16*cos(theta)**12 + 4.33364447497331e+15*cos(theta)**10 - 361807052641557.0*cos(theta)**8 + 17962052258800.7*cos(theta)**6 - 460565442533.351*cos(theta)**4 + 4590353247.8407*cos(theta)**2 - 7463989.02087919)*sin(5*phi)

@torch.jit.script
def Yl35_m_minus_4(theta, phi):
    return 2.13431042725227e-6*(1.0 - cos(theta)**2)**2*(4.10299294615197e+15*cos(theta)**31 - 2.76506046371111e+16*cos(theta)**29 + 8.37772050945307e+16*cos(theta)**27 - 1.50798969170155e+17*cos(theta)**25 + 1.79522582345423e+17*cos(theta)**23 - 1.48915453552105e+17*cos(theta)**21 + 8.83396758359944e+16*cos(theta)**19 - 3.7859861072569e+16*cos(theta)**17 + 1.17021388769759e+16*cos(theta)**15 - 2.57594252008903e+15*cos(theta)**13 + 393967679543028.0*cos(theta)**11 - 40200783626839.6*cos(theta)**9 + 2566007465542.95*cos(theta)**7 - 92113088506.6701*cos(theta)**5 + 1530117749.28023*cos(theta)**3 - 7463989.02087919*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl35_m_minus_3(theta, phi):
    return 7.53988772320084e-5*(1.0 - cos(theta)**2)**1.5*(128218529567249.0*cos(theta)**32 - 921686821237037.0*cos(theta)**30 + 2.99204303909038e+15*cos(theta)**28 - 5.79996035269828e+15*cos(theta)**26 + 7.48010759772595e+15*cos(theta)**24 - 6.7688842523684e+15*cos(theta)**22 + 4.41698379179972e+15*cos(theta)**20 - 2.10332561514272e+15*cos(theta)**18 + 731383679810993.0*cos(theta)**16 - 183995894292074.0*cos(theta)**14 + 32830639961919.0*cos(theta)**12 - 4020078362683.96*cos(theta)**10 + 320750933192.869*cos(theta)**8 - 15352181417.7784*cos(theta)**6 + 382529437.320059*cos(theta)**4 - 3731994.5104396*cos(theta)**2 + 5980.76043339679)*sin(3*phi)

@torch.jit.script
def Yl35_m_minus_2(theta, phi):
    return 0.00267001466710592*(1.0 - cos(theta)**2)*(3885409986886.33*cos(theta)**33 - 29731832943130.2*cos(theta)**31 + 103173897899668.0*cos(theta)**29 - 214813346396232.0*cos(theta)**27 + 299204303909038.0*cos(theta)**25 - 294299315320365.0*cos(theta)**23 + 210332561514272.0*cos(theta)**21 - 110701348165407.0*cos(theta)**19 + 43022569400646.6*cos(theta)**17 - 12266392952804.9*cos(theta)**15 + 2525433843224.54*cos(theta)**13 - 365461669334.906*cos(theta)**11 + 35638992576.9855*cos(theta)**9 - 2193168773.96834*cos(theta)**7 + 76505887.4640117*cos(theta)**5 - 1243998.17014653*cos(theta)**3 + 5980.76043339679*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl35_m_minus_1(theta, phi):
    return 0.09470086974142*(1.0 - cos(theta)**2)**0.5*(114276764320.186*cos(theta)**34 - 929119779472.819*cos(theta)**32 + 3439129929988.94*cos(theta)**30 - 7671905228436.87*cos(theta)**28 + 11507857842655.3*cos(theta)**26 - 12262471471681.9*cos(theta)**24 + 9560570977921.47*cos(theta)**22 - 5535067408270.33*cos(theta)**20 + 2390142744480.37*cos(theta)**18 - 766649559550.307*cos(theta)**16 + 180388131658.896*cos(theta)**14 - 30455139111.2421*cos(theta)**12 + 3563899257.69855*cos(theta)**10 - 274146096.746042*cos(theta)**8 + 12750981.244002*cos(theta)**6 - 310999.542536633*cos(theta)**4 + 2990.3802166984*cos(theta)**2 - 4.75418158457614)*sin(phi)

@torch.jit.script
def Yl35_m0(theta, phi):
    return 7760936554.25726*cos(theta)**35 - 66924018112.7981*cos(theta)**33 + 263700608683.264*cos(theta)**31 - 628824528398.553*cos(theta)**29 + 1013106184642.11*cos(theta)**27 - 1165902527243.87*cos(theta)**25 + 988052989189.724*cos(theta)**23 - 626509790137.845*cos(theta)**21 + 299016036202.153*cos(theta)**19 - 107194428072.47*cos(theta)**17 + 28585180819.3253*cos(theta)**15 - 5568541718.05039*cos(theta)**13 + 770117471.645267*cos(theta)**11 - 72404206.7358798*cos(theta)**9 + 4329819.67191308*cos(theta)**7 - 147847.500992154*cos(theta)**5 + 2369.35097743836*cos(theta)**3 - 11.3005611006599*cos(theta)

@torch.jit.script
def Yl35_m1(theta, phi):
    return 0.09470086974142*(1.0 - cos(theta)**2)**0.5*(114276764320.186*cos(theta)**34 - 929119779472.819*cos(theta)**32 + 3439129929988.94*cos(theta)**30 - 7671905228436.87*cos(theta)**28 + 11507857842655.3*cos(theta)**26 - 12262471471681.9*cos(theta)**24 + 9560570977921.47*cos(theta)**22 - 5535067408270.33*cos(theta)**20 + 2390142744480.37*cos(theta)**18 - 766649559550.307*cos(theta)**16 + 180388131658.896*cos(theta)**14 - 30455139111.2421*cos(theta)**12 + 3563899257.69855*cos(theta)**10 - 274146096.746042*cos(theta)**8 + 12750981.244002*cos(theta)**6 - 310999.542536633*cos(theta)**4 + 2990.3802166984*cos(theta)**2 - 4.75418158457614)*cos(phi)

@torch.jit.script
def Yl35_m2(theta, phi):
    return 0.00267001466710592*(1.0 - cos(theta)**2)*(3885409986886.33*cos(theta)**33 - 29731832943130.2*cos(theta)**31 + 103173897899668.0*cos(theta)**29 - 214813346396232.0*cos(theta)**27 + 299204303909038.0*cos(theta)**25 - 294299315320365.0*cos(theta)**23 + 210332561514272.0*cos(theta)**21 - 110701348165407.0*cos(theta)**19 + 43022569400646.6*cos(theta)**17 - 12266392952804.9*cos(theta)**15 + 2525433843224.54*cos(theta)**13 - 365461669334.906*cos(theta)**11 + 35638992576.9855*cos(theta)**9 - 2193168773.96834*cos(theta)**7 + 76505887.4640117*cos(theta)**5 - 1243998.17014653*cos(theta)**3 + 5980.76043339679*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl35_m3(theta, phi):
    return 7.53988772320084e-5*(1.0 - cos(theta)**2)**1.5*(128218529567249.0*cos(theta)**32 - 921686821237037.0*cos(theta)**30 + 2.99204303909038e+15*cos(theta)**28 - 5.79996035269828e+15*cos(theta)**26 + 7.48010759772595e+15*cos(theta)**24 - 6.7688842523684e+15*cos(theta)**22 + 4.41698379179972e+15*cos(theta)**20 - 2.10332561514272e+15*cos(theta)**18 + 731383679810993.0*cos(theta)**16 - 183995894292074.0*cos(theta)**14 + 32830639961919.0*cos(theta)**12 - 4020078362683.96*cos(theta)**10 + 320750933192.869*cos(theta)**8 - 15352181417.7784*cos(theta)**6 + 382529437.320059*cos(theta)**4 - 3731994.5104396*cos(theta)**2 + 5980.76043339679)*cos(3*phi)

@torch.jit.script
def Yl35_m4(theta, phi):
    return 2.13431042725227e-6*(1.0 - cos(theta)**2)**2*(4.10299294615197e+15*cos(theta)**31 - 2.76506046371111e+16*cos(theta)**29 + 8.37772050945307e+16*cos(theta)**27 - 1.50798969170155e+17*cos(theta)**25 + 1.79522582345423e+17*cos(theta)**23 - 1.48915453552105e+17*cos(theta)**21 + 8.83396758359944e+16*cos(theta)**19 - 3.7859861072569e+16*cos(theta)**17 + 1.17021388769759e+16*cos(theta)**15 - 2.57594252008903e+15*cos(theta)**13 + 393967679543028.0*cos(theta)**11 - 40200783626839.6*cos(theta)**9 + 2566007465542.95*cos(theta)**7 - 92113088506.6701*cos(theta)**5 + 1530117749.28023*cos(theta)**3 - 7463989.02087919*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl35_m5(theta, phi):
    return 6.06103432557419e-8*(1.0 - cos(theta)**2)**2.5*(1.27192781330711e+17*cos(theta)**30 - 8.01867534476222e+17*cos(theta)**28 + 2.26198453755233e+18*cos(theta)**26 - 3.76997422925388e+18*cos(theta)**24 + 4.12901939394472e+18*cos(theta)**22 - 3.1272245245942e+18*cos(theta)**20 + 1.67845384088389e+18*cos(theta)**18 - 6.43617638233673e+17*cos(theta)**16 + 1.75532083154638e+17*cos(theta)**14 - 3.34872527611574e+16*cos(theta)**12 + 4.33364447497331e+15*cos(theta)**10 - 361807052641557.0*cos(theta)**8 + 17962052258800.7*cos(theta)**6 - 460565442533.351*cos(theta)**4 + 4590353247.8407*cos(theta)**2 - 7463989.02087919)*cos(5*phi)

@torch.jit.script
def Yl35_m6(theta, phi):
    return 1.72820074431929e-9*(1.0 - cos(theta)**2)**3*(3.81578343992133e+18*cos(theta)**29 - 2.24522909653342e+19*cos(theta)**27 + 5.88115979763605e+19*cos(theta)**25 - 9.04793815020931e+19*cos(theta)**23 + 9.08384266667839e+19*cos(theta)**21 - 6.2544490491884e+19*cos(theta)**19 + 3.02121691359101e+19*cos(theta)**17 - 1.02978822117388e+19*cos(theta)**15 + 2.45744916416494e+18*cos(theta)**13 - 4.01847033133889e+17*cos(theta)**11 + 4.33364447497331e+16*cos(theta)**9 - 2.89445642113245e+15*cos(theta)**7 + 107772313552804.0*cos(theta)**5 - 1842261770133.4*cos(theta)**3 + 9180706495.68141*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl35_m7(theta, phi):
    return 4.95188492471306e-11*(1.0 - cos(theta)**2)**3.5*(1.10657719757719e+20*cos(theta)**28 - 6.06211856064024e+20*cos(theta)**26 + 1.47028994940901e+21*cos(theta)**24 - 2.08102577454814e+21*cos(theta)**22 + 1.90760696000246e+21*cos(theta)**20 - 1.1883453193458e+21*cos(theta)**18 + 5.13606875310471e+20*cos(theta)**16 - 1.54468233176082e+20*cos(theta)**14 + 3.19468391341442e+19*cos(theta)**12 - 4.42031736447278e+18*cos(theta)**10 + 3.90028002747598e+17*cos(theta)**8 - 2.02611949479272e+16*cos(theta)**6 + 538861567764020.0*cos(theta)**4 - 5526785310400.21*cos(theta)**2 + 9180706495.68141)*cos(7*phi)

@torch.jit.script
def Yl35_m8(theta, phi):
    return 1.42710951008933e-12*(1.0 - cos(theta)**2)**4*(3.09841615321612e+21*cos(theta)**27 - 1.57615082576646e+22*cos(theta)**25 + 3.52869587858163e+22*cos(theta)**23 - 4.57825670400591e+22*cos(theta)**21 + 3.81521392000493e+22*cos(theta)**19 - 2.13902157482243e+22*cos(theta)**17 + 8.21771000496754e+21*cos(theta)**15 - 2.16255526446514e+21*cos(theta)**13 + 3.8336206960973e+20*cos(theta)**11 - 4.42031736447278e+19*cos(theta)**9 + 3.12022402198078e+18*cos(theta)**7 - 1.21567169687563e+17*cos(theta)**5 + 2.15544627105608e+15*cos(theta)**3 - 11053570620800.4*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl35_m9(theta, phi):
    return 4.14046463847392e-14*(1.0 - cos(theta)**2)**4.5*(8.36572361368353e+22*cos(theta)**26 - 3.94037706441615e+23*cos(theta)**24 + 8.11600052073775e+23*cos(theta)**22 - 9.61433907841241e+23*cos(theta)**20 + 7.24890644800936e+23*cos(theta)**18 - 3.63633667719814e+23*cos(theta)**16 + 1.23265650074513e+23*cos(theta)**14 - 2.81132184380469e+22*cos(theta)**12 + 4.21698276570703e+21*cos(theta)**10 - 3.9782856280255e+20*cos(theta)**8 + 2.18415681538655e+19*cos(theta)**6 - 6.07835848437815e+17*cos(theta)**4 + 6.46633881316824e+15*cos(theta)**2 - 11053570620800.4)*cos(9*phi)

@torch.jit.script
def Yl35_m10(theta, phi):
    return 1.21047590494358e-15*(1.0 - cos(theta)**2)**5*(2.17508813955772e+24*cos(theta)**25 - 9.45690495459877e+24*cos(theta)**23 + 1.78552011456231e+25*cos(theta)**21 - 1.92286781568248e+25*cos(theta)**19 + 1.30480316064168e+25*cos(theta)**17 - 5.81813868351702e+24*cos(theta)**15 + 1.72571910104318e+24*cos(theta)**13 - 3.37358621256562e+23*cos(theta)**11 + 4.21698276570703e+22*cos(theta)**9 - 3.1826285024204e+21*cos(theta)**7 + 1.31049408923193e+20*cos(theta)**5 - 2.43134339375126e+18*cos(theta)**3 + 1.29326776263365e+16*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl35_m11(theta, phi):
    return 3.56949870606501e-17*(1.0 - cos(theta)**2)**5.5*(5.43772034889429e+25*cos(theta)**24 - 2.17508813955772e+26*cos(theta)**22 + 3.74959224058084e+26*cos(theta)**20 - 3.65344884979672e+26*cos(theta)**18 + 2.21816537309086e+26*cos(theta)**16 - 8.72720802527553e+25*cos(theta)**14 + 2.24343483135614e+25*cos(theta)**12 - 3.71094483382219e+24*cos(theta)**10 + 3.79528448913633e+23*cos(theta)**8 - 2.22783995169428e+22*cos(theta)**6 + 6.55247044615964e+20*cos(theta)**4 - 7.29403018125378e+18*cos(theta)**2 + 1.29326776263365e+16)*cos(11*phi)

@torch.jit.script
def Yl35_m12(theta, phi):
    return 1.06280277340603e-18*(1.0 - cos(theta)**2)**6*(1.30505288373463e+27*cos(theta)**23 - 4.78519390702698e+27*cos(theta)**21 + 7.49918448116168e+27*cos(theta)**19 - 6.57620792963409e+27*cos(theta)**17 + 3.54906459694538e+27*cos(theta)**15 - 1.22180912353857e+27*cos(theta)**13 + 2.69212179762737e+26*cos(theta)**11 - 3.71094483382218e+25*cos(theta)**9 + 3.03622759130906e+24*cos(theta)**7 - 1.33670397101657e+23*cos(theta)**5 + 2.62098817846386e+21*cos(theta)**3 - 1.45880603625076e+19*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl35_m13(theta, phi):
    return 3.19866046346017e-20*(1.0 - cos(theta)**2)**6.5*(3.00162163258965e+28*cos(theta)**22 - 1.00489072047567e+29*cos(theta)**20 + 1.42484505142072e+29*cos(theta)**18 - 1.1179553480378e+29*cos(theta)**16 + 5.32359689541807e+28*cos(theta)**14 - 1.58835186060015e+28*cos(theta)**12 + 2.9613339773901e+27*cos(theta)**10 - 3.33985035043997e+26*cos(theta)**8 + 2.12535931391634e+25*cos(theta)**6 - 6.68351985508284e+23*cos(theta)**4 + 7.86296453539157e+21*cos(theta)**2 - 1.45880603625076e+19)*cos(13*phi)

@torch.jit.script
def Yl35_m14(theta, phi):
    return 9.74223860268681e-22*(1.0 - cos(theta)**2)**7*(6.60356759169723e+29*cos(theta)**21 - 2.00978144095133e+30*cos(theta)**19 + 2.5647210925573e+30*cos(theta)**17 - 1.78872855686047e+30*cos(theta)**15 + 7.4530356535853e+29*cos(theta)**13 - 1.90602223272018e+29*cos(theta)**11 + 2.9613339773901e+28*cos(theta)**9 - 2.67188028035197e+27*cos(theta)**7 + 1.27521558834981e+26*cos(theta)**5 - 2.67340794203313e+24*cos(theta)**3 + 1.57259290707831e+22*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl35_m15(theta, phi):
    return 3.00652010504917e-23*(1.0 - cos(theta)**2)**7.5*(1.38674919425642e+31*cos(theta)**20 - 3.81858473780753e+31*cos(theta)**18 + 4.3600258573474e+31*cos(theta)**16 - 2.68309283529071e+31*cos(theta)**14 + 9.68894634966089e+30*cos(theta)**12 - 2.09662445599219e+30*cos(theta)**10 + 2.66520057965109e+29*cos(theta)**8 - 1.87031619624638e+28*cos(theta)**6 + 6.37607794174903e+26*cos(theta)**4 - 8.02022382609941e+24*cos(theta)**2 + 1.57259290707831e+22)*cos(15*phi)

@torch.jit.script
def Yl35_m16(theta, phi):
    return 9.41377960708832e-25*(1.0 - cos(theta)**2)**8*(2.77349838851284e+32*cos(theta)**19 - 6.87345252805355e+32*cos(theta)**17 + 6.97604137175584e+32*cos(theta)**15 - 3.75632996940699e+32*cos(theta)**13 + 1.16267356195931e+32*cos(theta)**11 - 2.09662445599219e+31*cos(theta)**9 + 2.13216046372087e+30*cos(theta)**7 - 1.12218971774783e+29*cos(theta)**5 + 2.55043117669961e+27*cos(theta)**3 - 1.60404476521988e+25*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl35_m17(theta, phi):
    return 2.9949222630012e-26*(1.0 - cos(theta)**2)**8.5*(5.26964693817439e+33*cos(theta)**18 - 1.1684869297691e+34*cos(theta)**16 + 1.04640620576338e+34*cos(theta)**14 - 4.88322896022909e+33*cos(theta)**12 + 1.27894091815524e+33*cos(theta)**10 - 1.88696201039297e+32*cos(theta)**8 + 1.49251232460461e+31*cos(theta)**6 - 5.61094858873914e+29*cos(theta)**4 + 7.65129353009883e+27*cos(theta)**2 - 1.60404476521988e+25)*cos(17*phi)

@torch.jit.script
def Yl35_m18(theta, phi):
    return 9.6964188430403e-28*(1.0 - cos(theta)**2)**9*(9.4853644887139e+34*cos(theta)**17 - 1.86957908763057e+35*cos(theta)**15 + 1.46496868806873e+35*cos(theta)**13 - 5.85987475227491e+34*cos(theta)**11 + 1.27894091815524e+34*cos(theta)**9 - 1.50956960831438e+33*cos(theta)**7 + 8.95507394762767e+31*cos(theta)**5 - 2.24437943549566e+30*cos(theta)**3 + 1.53025870601977e+28*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl35_m19(theta, phi):
    return 3.20029509770303e-29*(1.0 - cos(theta)**2)**9.5*(1.61251196308136e+36*cos(theta)**16 - 2.80436863144585e+36*cos(theta)**14 + 1.90445929448935e+36*cos(theta)**12 - 6.4458622275024e+35*cos(theta)**10 + 1.15104682633971e+35*cos(theta)**8 - 1.05669872582007e+34*cos(theta)**6 + 4.47753697381384e+32*cos(theta)**4 - 6.73313830648697e+30*cos(theta)**2 + 1.53025870601977e+28)*cos(19*phi)

@torch.jit.script
def Yl35_m20(theta, phi):
    return 1.07881925735658e-30*(1.0 - cos(theta)**2)**10*(2.58001914093018e+37*cos(theta)**15 - 3.92611608402419e+37*cos(theta)**13 + 2.28535115338721e+37*cos(theta)**11 - 6.4458622275024e+36*cos(theta)**9 + 9.20837461071771e+35*cos(theta)**7 - 6.34019235492039e+34*cos(theta)**5 + 1.79101478952553e+33*cos(theta)**3 - 1.34662766129739e+31*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl35_m21(theta, phi):
    return 3.72228007128537e-32*(1.0 - cos(theta)**2)**10.5*(3.87002871139527e+38*cos(theta)**14 - 5.10395090923145e+38*cos(theta)**12 + 2.51388626872594e+38*cos(theta)**10 - 5.80127600475216e+37*cos(theta)**8 + 6.4458622275024e+36*cos(theta)**6 - 3.1700961774602e+35*cos(theta)**4 + 5.3730443685766e+33*cos(theta)**2 - 1.34662766129739e+31)*cos(21*phi)

@torch.jit.script
def Yl35_m22(theta, phi):
    return 1.31767286173862e-33*(1.0 - cos(theta)**2)**11*(5.41804019595338e+39*cos(theta)**13 - 6.12474109107773e+39*cos(theta)**11 + 2.51388626872594e+39*cos(theta)**9 - 4.64102080380173e+38*cos(theta)**7 + 3.86751733650144e+37*cos(theta)**5 - 1.26803847098408e+36*cos(theta)**3 + 1.07460887371532e+34*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl35_m23(theta, phi):
    return 4.79868153112577e-35*(1.0 - cos(theta)**2)**11.5*(7.04345225473939e+40*cos(theta)**12 - 6.73721520018551e+40*cos(theta)**10 + 2.26249764185334e+40*cos(theta)**8 - 3.24871456266121e+39*cos(theta)**6 + 1.93375866825072e+38*cos(theta)**4 - 3.80411541295224e+36*cos(theta)**2 + 1.07460887371532e+34)*cos(23*phi)

@torch.jit.script
def Yl35_m24(theta, phi):
    return 1.80345495626061e-36*(1.0 - cos(theta)**2)**12*(8.45214270568727e+41*cos(theta)**11 - 6.73721520018551e+41*cos(theta)**9 + 1.80999811348267e+41*cos(theta)**7 - 1.94922873759673e+40*cos(theta)**5 + 7.73503467300288e+38*cos(theta)**3 - 7.60823082590447e+36*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl35_m25(theta, phi):
    return 7.01993889645875e-38*(1.0 - cos(theta)**2)**12.5*(9.297356976256e+42*cos(theta)**10 - 6.06349368016696e+42*cos(theta)**8 + 1.26699867943787e+42*cos(theta)**6 - 9.74614368798363e+40*cos(theta)**4 + 2.32051040190086e+39*cos(theta)**2 - 7.60823082590447e+36)*cos(25*phi)

@torch.jit.script
def Yl35_m26(theta, phi):
    return 2.8422901788273e-39*(1.0 - cos(theta)**2)**13*(9.297356976256e+43*cos(theta)**9 - 4.85079494413357e+43*cos(theta)**7 + 7.60199207662723e+42*cos(theta)**5 - 3.89845747519345e+41*cos(theta)**3 + 4.64102080380173e+39*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl35_m27(theta, phi):
    return 1.20323737894154e-40*(1.0 - cos(theta)**2)**13.5*(8.3676212786304e+44*cos(theta)**8 - 3.3955564608935e+44*cos(theta)**6 + 3.80099603831361e+43*cos(theta)**4 - 1.16953724255804e+42*cos(theta)**2 + 4.64102080380173e+39)*cos(27*phi)

@torch.jit.script
def Yl35_m28(theta, phi):
    return 5.35964527018943e-42*(1.0 - cos(theta)**2)**14*(6.69409702290432e+45*cos(theta)**7 - 2.0373338765361e+45*cos(theta)**5 + 1.52039841532545e+44*cos(theta)**3 - 2.33907448511607e+42*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl35_m29(theta, phi):
    return 2.53219437507943e-43*(1.0 - cos(theta)**2)**14.5*(4.68586791603302e+46*cos(theta)**6 - 1.01866693826805e+46*cos(theta)**4 + 4.56119524597634e+44*cos(theta)**2 - 2.33907448511607e+42)*cos(29*phi)

@torch.jit.script
def Yl35_m30(theta, phi):
    return 1.28222646437538e-44*(1.0 - cos(theta)**2)**15*(2.81152074961981e+47*cos(theta)**5 - 4.0746677530722e+46*cos(theta)**3 + 9.12239049195268e+44*cos(theta))*cos(30*phi)

@torch.jit.script
def Yl35_m31(theta, phi):
    return 7.05842437981691e-46*(1.0 - cos(theta)**2)**15.5*(1.40576037480991e+48*cos(theta)**4 - 1.22240032592166e+47*cos(theta)**2 + 9.12239049195268e+44)*cos(31*phi)

@torch.jit.script
def Yl35_m32(theta, phi):
    return 4.31161892256615e-47*(1.0 - cos(theta)**2)**16*(5.62304149923963e+48*cos(theta)**3 - 2.44480065184332e+47*cos(theta))*cos(32*phi)

@torch.jit.script
def Yl35_m33(theta, phi):
    return 3.01873705359384e-48*(1.0 - cos(theta)**2)**16.5*(1.68691244977189e+49*cos(theta)**2 - 2.44480065184332e+47)*cos(33*phi)

@torch.jit.script
def Yl35_m34(theta, phi):
    return 8.66978407765238*(1.0 - cos(theta)**2)**17*cos(34*phi)*cos(theta)

@torch.jit.script
def Yl35_m35(theta, phi):
    return 1.03623739663619*(1.0 - cos(theta)**2)**17.5*cos(35*phi)

@torch.jit.script
def Yl36_m_minus_36(theta, phi):
    return 1.04340867525942*(1.0 - cos(theta)**2)**18*sin(36*phi)

@torch.jit.script
def Yl36_m_minus_35(theta, phi):
    return 8.85361619789771*(1.0 - cos(theta)**2)**17.5*sin(35*phi)*cos(theta)

@torch.jit.script
def Yl36_m_minus_34(theta, phi):
    return 4.40437182605064e-50*(1.0 - cos(theta)**2)**17*(1.19770783933804e+51*cos(theta)**2 - 1.68691244977189e+49)*sin(34*phi)

@torch.jit.script
def Yl36_m_minus_33(theta, phi):
    return 6.38254114616021e-49*(1.0 - cos(theta)**2)**16.5*(3.99235946446014e+50*cos(theta)**3 - 1.68691244977189e+49*cos(theta))*sin(33*phi)

@torch.jit.script
def Yl36_m_minus_32(theta, phi):
    return 1.06034737181502e-47*(1.0 - cos(theta)**2)**16*(9.98089866115034e+49*cos(theta)**4 - 8.43456224885944e+48*cos(theta)**2 + 6.11200162960829e+46)*sin(32*phi)

@torch.jit.script
def Yl36_m_minus_31(theta, phi):
    return 1.95518394692445e-46*(1.0 - cos(theta)**2)**15.5*(1.99617973223007e+49*cos(theta)**5 - 2.81152074961981e+48*cos(theta)**3 + 6.11200162960829e+46*cos(theta))*sin(31*phi)

@torch.jit.script
def Yl36_m_minus_30(theta, phi):
    return 3.92013162413846e-45*(1.0 - cos(theta)**2)**15*(3.32696622038345e+48*cos(theta)**6 - 7.02880187404954e+47*cos(theta)**4 + 3.05600081480415e+46*cos(theta)**2 - 1.52039841532545e+44)*sin(30*phi)

@torch.jit.script
def Yl36_m_minus_29(theta, phi):
    return 8.42600353736191e-44*(1.0 - cos(theta)**2)**14.5*(4.75280888626207e+47*cos(theta)**7 - 1.40576037480991e+47*cos(theta)**5 + 1.01866693826805e+46*cos(theta)**3 - 1.52039841532545e+44*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl36_m_minus_28(theta, phi):
    return 1.92142443301969e-42*(1.0 - cos(theta)**2)**14*(5.94101110782758e+46*cos(theta)**8 - 2.34293395801651e+46*cos(theta)**6 + 2.54666734567012e+45*cos(theta)**4 - 7.60199207662723e+43*cos(theta)**2 + 2.92384310639509e+41)*sin(28*phi)

@torch.jit.script
def Yl36_m_minus_27(theta, phi):
    return 4.61141863924726e-41*(1.0 - cos(theta)**2)**13.5*(6.60112345314176e+45*cos(theta)**9 - 3.34704851145216e+45*cos(theta)**7 + 5.09333469134024e+44*cos(theta)**5 - 2.53399735887574e+43*cos(theta)**3 + 2.92384310639509e+41*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl36_m_minus_26(theta, phi):
    return 1.1574568923217e-39*(1.0 - cos(theta)**2)**13*(6.60112345314176e+44*cos(theta)**10 - 4.1838106393152e+44*cos(theta)**8 + 8.48889115223374e+43*cos(theta)**6 - 6.33499339718936e+42*cos(theta)**4 + 1.46192155319754e+41*cos(theta)**2 - 4.64102080380173e+38)*sin(26*phi)

@torch.jit.script
def Yl36_m_minus_25(theta, phi):
    return 3.0227136881809e-38*(1.0 - cos(theta)**2)**12.5*(6.00102132103796e+43*cos(theta)**11 - 4.648678488128e+43*cos(theta)**9 + 1.21269873603339e+43*cos(theta)**7 - 1.26699867943787e+42*cos(theta)**5 + 4.87307184399181e+40*cos(theta)**3 - 4.64102080380173e+38*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl36_m_minus_24(theta, phi):
    return 8.17810257077045e-37*(1.0 - cos(theta)**2)**12*(5.00085110086497e+42*cos(theta)**12 - 4.648678488128e+42*cos(theta)**10 + 1.51587342004174e+42*cos(theta)**8 - 2.11166446572979e+41*cos(theta)**6 + 1.21826796099795e+40*cos(theta)**4 - 2.32051040190086e+38*cos(theta)**2 + 6.34019235492039e+35)*sin(24*phi)

@torch.jit.script
def Yl36_m_minus_23(theta, phi):
    return 2.28401974801605e-35*(1.0 - cos(theta)**2)**11.5*(3.8468085391269e+41*cos(theta)**13 - 4.22607135284364e+41*cos(theta)**11 + 1.68430380004638e+41*cos(theta)**9 - 3.01666352247112e+40*cos(theta)**7 + 2.43653592199591e+39*cos(theta)**5 - 7.73503467300288e+37*cos(theta)**3 + 6.34019235492039e+35*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl36_m_minus_22(theta, phi):
    return 6.56432202813386e-34*(1.0 - cos(theta)**2)**11*(2.74772038509064e+40*cos(theta)**14 - 3.5217261273697e+40*cos(theta)**12 + 1.68430380004638e+40*cos(theta)**10 - 3.7708294030889e+39*cos(theta)**8 + 4.06089320332651e+38*cos(theta)**6 - 1.93375866825072e+37*cos(theta)**4 + 3.1700961774602e+35*cos(theta)**2 - 7.67577766939515e+32)*sin(22*phi)

@torch.jit.script
def Yl36_m_minus_21(theta, phi):
    return 1.93619682908189e-32*(1.0 - cos(theta)**2)**10.5*(1.83181359006043e+39*cos(theta)**15 - 2.70902009797669e+39*cos(theta)**13 + 1.53118527276943e+39*cos(theta)**11 - 4.18981044787656e+38*cos(theta)**9 + 5.80127600475216e+37*cos(theta)**7 - 3.86751733650144e+36*cos(theta)**5 + 1.05669872582007e+35*cos(theta)**3 - 7.67577766939515e+32*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl36_m_minus_20(theta, phi):
    return 5.84718619746581e-31*(1.0 - cos(theta)**2)**10*(1.14488349378777e+38*cos(theta)**16 - 1.93501435569764e+38*cos(theta)**14 + 1.27598772730786e+38*cos(theta)**12 - 4.18981044787656e+37*cos(theta)**10 + 7.2515950059402e+36*cos(theta)**8 - 6.4458622275024e+35*cos(theta)**6 + 2.64174681455016e+34*cos(theta)**4 - 3.83788883469757e+32*cos(theta)**2 + 8.41642288310872e+29)*sin(20*phi)

@torch.jit.script
def Yl36_m_minus_19(theta, phi):
    return 1.80411990397808e-29*(1.0 - cos(theta)**2)**9.5*(6.73460878698687e+36*cos(theta)**17 - 1.29000957046509e+37*cos(theta)**15 + 9.81529021006047e+36*cos(theta)**13 - 3.80891858897869e+36*cos(theta)**11 + 8.057327784378e+35*cos(theta)**9 - 9.20837461071771e+34*cos(theta)**7 + 5.28349362910033e+33*cos(theta)**5 - 1.27929627823252e+32*cos(theta)**3 + 8.41642288310872e+29*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl36_m_minus_18(theta, phi):
    return 5.67653075535627e-28*(1.0 - cos(theta)**2)**9*(3.74144932610382e+35*cos(theta)**18 - 8.06255981540682e+35*cos(theta)**16 + 7.01092157861462e+35*cos(theta)**14 - 3.17409882414891e+35*cos(theta)**12 + 8.057327784378e+34*cos(theta)**10 - 1.15104682633971e+34*cos(theta)**8 + 8.80582271516721e+32*cos(theta)**6 - 3.19824069558131e+31*cos(theta)**4 + 4.20821144155436e+29*cos(theta)**2 - 8.50143725566537e+26)*sin(18*phi)

@torch.jit.script
def Yl36_m_minus_17(theta, phi):
    return 1.81826289225004e-26*(1.0 - cos(theta)**2)**8.5*(1.96918385584411e+34*cos(theta)**19 - 4.74268224435695e+34*cos(theta)**17 + 4.67394771907641e+34*cos(theta)**15 - 2.44161448011455e+34*cos(theta)**13 + 7.32484344034364e+33*cos(theta)**11 - 1.27894091815524e+33*cos(theta)**9 + 1.25797467359532e+32*cos(theta)**7 - 6.39648139116262e+30*cos(theta)**5 + 1.40273714718479e+29*cos(theta)**3 - 8.50143725566537e+26*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl36_m_minus_16(theta, phi):
    return 5.91983508389675e-25*(1.0 - cos(theta)**2)**8*(9.84591927922057e+32*cos(theta)**20 - 2.63482346908719e+33*cos(theta)**18 + 2.92121732442276e+33*cos(theta)**16 - 1.74401034293896e+33*cos(theta)**14 + 6.10403620028636e+32*cos(theta)**12 - 1.27894091815524e+32*cos(theta)**10 + 1.57246834199415e+31*cos(theta)**8 - 1.06608023186044e+30*cos(theta)**6 + 3.50684286796196e+28*cos(theta)**4 - 4.25071862783268e+26*cos(theta)**2 + 8.0202238260994e+23)*sin(16*phi)

@torch.jit.script
def Yl36_m_minus_15(theta, phi):
    return 1.95623456117164e-23*(1.0 - cos(theta)**2)**7.5*(4.68853299010503e+31*cos(theta)**21 - 1.38674919425642e+32*cos(theta)**19 + 1.71836313201339e+32*cos(theta)**17 - 1.16267356195931e+32*cos(theta)**15 + 4.69541246175874e+31*cos(theta)**13 - 1.16267356195931e+31*cos(theta)**11 + 1.74718704666016e+30*cos(theta)**9 - 1.52297175980062e+29*cos(theta)**7 + 7.01368573592393e+27*cos(theta)**5 - 1.41690620927756e+26*cos(theta)**3 + 8.0202238260994e+23*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl36_m_minus_14(theta, phi):
    return 6.55265580099988e-22*(1.0 - cos(theta)**2)**7*(2.13115135913865e+30*cos(theta)**22 - 6.93374597128209e+30*cos(theta)**20 + 9.54646184451882e+30*cos(theta)**18 - 7.26670976224567e+30*cos(theta)**16 + 3.35386604411339e+30*cos(theta)**14 - 9.68894634966089e+29*cos(theta)**12 + 1.74718704666016e+29*cos(theta)**10 - 1.90371469975078e+28*cos(theta)**8 + 1.16894762265399e+27*cos(theta)**6 - 3.5422655231939e+25*cos(theta)**4 + 4.0101119130497e+23*cos(theta)**2 - 7.1481495776287e+20)*sin(14*phi)

@torch.jit.script
def Yl36_m_minus_13(theta, phi):
    return 2.22211369541106e-20*(1.0 - cos(theta)**2)**6.5*(9.26587547451588e+28*cos(theta)**23 - 3.30178379584861e+29*cos(theta)**21 + 5.02445360237833e+29*cos(theta)**19 - 4.27453515426216e+29*cos(theta)**17 + 2.23591069607559e+29*cos(theta)**15 - 7.4530356535853e+28*cos(theta)**13 + 1.58835186060015e+28*cos(theta)**11 - 2.11523855527865e+27*cos(theta)**9 + 1.66992517521998e+26*cos(theta)**7 - 7.08453104638781e+24*cos(theta)**5 + 1.33670397101657e+23*cos(theta)**3 - 7.1481495776287e+20*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl36_m_minus_12(theta, phi):
    return 7.62026258589038e-19*(1.0 - cos(theta)**2)**6*(3.86078144771495e+27*cos(theta)**24 - 1.50081081629482e+28*cos(theta)**22 + 2.51222680118916e+28*cos(theta)**20 - 2.37474175236787e+28*cos(theta)**18 + 1.39744418504724e+28*cos(theta)**16 - 5.32359689541807e+27*cos(theta)**14 + 1.32362655050012e+27*cos(theta)**12 - 2.11523855527865e+26*cos(theta)**10 + 2.08740646902498e+25*cos(theta)**8 - 1.18075517439797e+24*cos(theta)**6 + 3.34175992754142e+22*cos(theta)**4 - 3.57407478881435e+20*cos(theta)**2 + 6.07835848437815e+17)*sin(12*phi)

@torch.jit.script
def Yl36_m_minus_11(theta, phi):
    return 2.63973639315567e-17*(1.0 - cos(theta)**2)**5.5*(1.54431257908598e+26*cos(theta)**25 - 6.52526441867315e+26*cos(theta)**23 + 1.19629847675674e+27*cos(theta)**21 - 1.24986408019361e+27*cos(theta)**19 + 8.22025991204261e+26*cos(theta)**17 - 3.54906459694538e+26*cos(theta)**15 + 1.01817426961548e+26*cos(theta)**13 - 1.92294414116241e+25*cos(theta)**11 + 2.31934052113887e+24*cos(theta)**9 - 1.68679310628281e+23*cos(theta)**7 + 6.68351985508284e+21*cos(theta)**5 - 1.19135826293812e+20*cos(theta)**3 + 6.07835848437815e+17*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl36_m_minus_10(theta, phi):
    return 9.22775728515781e-16*(1.0 - cos(theta)**2)**5*(5.9396637657153e+24*cos(theta)**26 - 2.71886017444715e+25*cos(theta)**24 + 5.43772034889429e+25*cos(theta)**22 - 6.24932040096807e+25*cos(theta)**20 + 4.5668110622459e+25*cos(theta)**18 - 2.21816537309086e+25*cos(theta)**16 + 7.27267335439627e+24*cos(theta)**14 - 1.60245345096867e+24*cos(theta)**12 + 2.31934052113887e+23*cos(theta)**10 - 2.10849138285351e+22*cos(theta)**8 + 1.11391997584714e+21*cos(theta)**6 - 2.97839565734529e+19*cos(theta)**4 + 3.03917924218907e+17*cos(theta)**2 - 497410677936019.0)*sin(10*phi)

@torch.jit.script
def Yl36_m_minus_9(theta, phi):
    return 3.25204810244434e-14*(1.0 - cos(theta)**2)**4.5*(2.19987546878345e+23*cos(theta)**27 - 1.08754406977886e+24*cos(theta)**25 + 2.36422623864969e+24*cos(theta)**23 - 2.97586685760384e+24*cos(theta)**21 + 2.4035847696031e+24*cos(theta)**19 - 1.30480316064168e+24*cos(theta)**17 + 4.84844890293085e+23*cos(theta)**15 - 1.23265650074513e+23*cos(theta)**13 + 2.10849138285351e+22*cos(theta)**11 - 2.34276820317057e+21*cos(theta)**9 + 1.5913142512102e+20*cos(theta)**7 - 5.95679131469059e+18*cos(theta)**5 + 1.01305974739636e+17*cos(theta)**3 - 497410677936019.0*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl36_m_minus_8(theta, phi):
    return 1.15436256195231e-12*(1.0 - cos(theta)**2)**4*(7.85669810279802e+21*cos(theta)**28 - 4.18286180684176e+22*cos(theta)**26 + 9.85094266104039e+22*cos(theta)**24 - 1.35266675345629e+23*cos(theta)**22 + 1.20179238480155e+23*cos(theta)**20 - 7.24890644800936e+22*cos(theta)**18 + 3.03028056433178e+22*cos(theta)**16 - 8.80468929103665e+21*cos(theta)**14 + 1.75707615237793e+21*cos(theta)**12 - 2.34276820317057e+20*cos(theta)**10 + 1.98914281401275e+19*cos(theta)**8 - 9.92798552448431e+17*cos(theta)**6 + 2.5326493684909e+16*cos(theta)**4 - 248705338968009.0*cos(theta)**2 + 394770379314.301)*sin(8*phi)

@torch.jit.script
def Yl36_m_minus_7(theta, phi):
    return 4.12351492246812e-11*(1.0 - cos(theta)**2)**3.5*(2.70920624234415e+20*cos(theta)**29 - 1.54920807660806e+21*cos(theta)**27 + 3.94037706441615e+21*cos(theta)**25 - 5.88115979763605e+21*cos(theta)**23 + 5.72282088000739e+21*cos(theta)**21 - 3.81521392000493e+21*cos(theta)**19 + 1.78251797901869e+21*cos(theta)**17 - 5.8697928606911e+20*cos(theta)**15 + 1.35159704029071e+20*cos(theta)**13 - 2.12978927560961e+19*cos(theta)**11 + 2.21015868223639e+18*cos(theta)**9 - 1.4182836463549e+17*cos(theta)**7 + 5.06529873698179e+15*cos(theta)**5 - 82901779656003.1*cos(theta)**3 + 394770379314.301*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl36_m_minus_6(theta, phi):
    return 1.48102512326443e-9*(1.0 - cos(theta)**2)**3*(9.03068747448049e+18*cos(theta)**30 - 5.53288598788593e+19*cos(theta)**28 + 1.51552964016006e+20*cos(theta)**26 - 2.45048324901502e+20*cos(theta)**24 + 2.60128221818518e+20*cos(theta)**22 - 1.90760696000246e+20*cos(theta)**20 + 9.90287766121497e+19*cos(theta)**18 - 3.66862053793194e+19*cos(theta)**16 + 9.6542645735051e+18*cos(theta)**14 - 1.77482439634134e+18*cos(theta)**12 + 2.21015868223639e+17*cos(theta)**10 - 1.77285455794363e+16*cos(theta)**8 + 844216456163632.0*cos(theta)**6 - 20725444914000.8*cos(theta)**4 + 197385189657.15*cos(theta)**2 - 306023549.856047)*sin(6*phi)

@torch.jit.script
def Yl36_m_minus_5(theta, phi):
    return 5.34401806817122e-8*(1.0 - cos(theta)**2)**2.5*(2.9131249917679e+17*cos(theta)**31 - 1.90789171996067e+18*cos(theta)**29 + 5.61307274133355e+18*cos(theta)**27 - 9.80193299606009e+18*cos(theta)**25 + 1.13099226877616e+19*cos(theta)**23 - 9.08384266667839e+18*cos(theta)**21 + 5.21204087432367e+18*cos(theta)**19 - 2.15801208113643e+18*cos(theta)**17 + 6.43617638233673e+17*cos(theta)**15 - 1.36524953564719e+17*cos(theta)**13 + 2.00923516566944e+16*cos(theta)**11 - 1.96983839771514e+15*cos(theta)**9 + 120602350880519.0*cos(theta)**7 - 4145088982800.16*cos(theta)**5 + 65795063219.0501*cos(theta)**3 - 306023549.856047*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl36_m_minus_4(theta, phi):
    return 1.93568567169822e-6*(1.0 - cos(theta)**2)**2*(9.10351559927468e+15*cos(theta)**32 - 6.35963906653555e+16*cos(theta)**30 + 2.00466883619055e+17*cos(theta)**28 - 3.76997422925388e+17*cos(theta)**26 + 4.71246778656735e+17*cos(theta)**24 - 4.12901939394473e+17*cos(theta)**22 + 2.60602043716183e+17*cos(theta)**20 - 1.19889560063135e+17*cos(theta)**18 + 4.02261023896046e+16*cos(theta)**16 - 9.7517823974799e+15*cos(theta)**14 + 1.67436263805787e+15*cos(theta)**12 - 196983839771514.0*cos(theta)**10 + 15075293860064.9*cos(theta)**8 - 690848163800.026*cos(theta)**6 + 16448765804.7625*cos(theta)**4 - 153011774.928023*cos(theta)**2 + 233249.656902475)*sin(4*phi)

@torch.jit.script
def Yl36_m_minus_3(theta, phi):
    return 7.03269529120626e-5*(1.0 - cos(theta)**2)**1.5*(275864109068930.0*cos(theta)**33 - 2.05149647307599e+15*cos(theta)**31 + 6.91265115927778e+15*cos(theta)**29 - 1.39628675157551e+16*cos(theta)**27 + 1.88498711462694e+16*cos(theta)**25 - 1.79522582345423e+16*cos(theta)**23 + 1.24096211293421e+16*cos(theta)**21 - 6.30997684542817e+15*cos(theta)**19 + 2.36624131703556e+15*cos(theta)**17 - 650118826498660.0*cos(theta)**15 + 128797126004452.0*cos(theta)**13 - 17907621797410.4*cos(theta)**11 + 1675032651118.32*cos(theta)**9 - 98692594828.5751*cos(theta)**7 + 3289753160.9525*cos(theta)**5 - 51003924.9760078*cos(theta)**3 + 233249.656902475*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl36_m_minus_2(theta, phi):
    return 0.00256090555968341*(1.0 - cos(theta)**2)*(8113650266733.23*cos(theta)**34 - 64109264783624.5*cos(theta)**32 + 230421705309259.0*cos(theta)**30 - 498673839848397.0*cos(theta)**28 + 724995044087285.0*cos(theta)**26 - 748010759772595.0*cos(theta)**24 + 564073687697367.0*cos(theta)**22 - 315498842271409.0*cos(theta)**20 + 131457850946420.0*cos(theta)**18 - 40632426656166.3*cos(theta)**16 + 9199794714603.68*cos(theta)**14 - 1492301816450.86*cos(theta)**12 + 167503265111.832*cos(theta)**10 - 12336574353.5719*cos(theta)**8 + 548292193.492084*cos(theta)**6 - 12750981.244002*cos(theta)**4 + 116624.828451237*cos(theta)**2 - 175.904718629317)*sin(2*phi)

@torch.jit.script
def Yl36_m_minus_1(theta, phi):
    return 0.0933940875530734*(1.0 - cos(theta)**2)**0.5*(231818579049.521*cos(theta)**35 - 1942704993443.17*cos(theta)**33 + 7432958235782.55*cos(theta)**31 - 17195649649944.7*cos(theta)**29 + 26851668299529.1*cos(theta)**27 - 29920430390903.8*cos(theta)**25 + 24524942943363.8*cos(theta)**23 - 15023754393876.6*cos(theta)**21 + 6918834260337.91*cos(theta)**19 - 2390142744480.37*cos(theta)**17 + 613319647640.245*cos(theta)**15 - 114792447419.297*cos(theta)**13 + 15227569555.6211*cos(theta)**11 - 1370730483.73021*cos(theta)**9 + 78327456.2131549*cos(theta)**7 - 2550196.24880039*cos(theta)**5 + 38874.9428170791*cos(theta)**3 - 175.904718629317*cos(theta))*sin(phi)

@torch.jit.script
def Yl36_m0(theta, phi):
    return 15520375942.067*cos(theta)**36 - 137716011880.313*cos(theta)**34 + 559845526556.924*cos(theta)**32 - 1381509359065.84*cos(theta)**30 + 2311371427667.85*cos(theta)**28 - 2773645713201.42*cos(theta)**26 + 2462936767187.05*cos(theta)**24 - 1645933529645.59*cos(theta)**22 + 833795274886.25*cos(theta)**20 - 320042630764.419*cos(theta)**18 + 92389665107.4645*cos(theta)**16 - 19762495210.1528*cos(theta)**14 + 3058481401.57127*cos(theta)**12 - 330376059.744196*cos(theta)**10 + 23598289.9817283*cos(theta)**8 - 1024421.89067968*cos(theta)**6 + 23424.2810368829*cos(theta)**4 - 211.984443772696*cos(theta)**2 + 0.318294960619663

@torch.jit.script
def Yl36_m1(theta, phi):
    return 0.0933940875530734*(1.0 - cos(theta)**2)**0.5*(231818579049.521*cos(theta)**35 - 1942704993443.17*cos(theta)**33 + 7432958235782.55*cos(theta)**31 - 17195649649944.7*cos(theta)**29 + 26851668299529.1*cos(theta)**27 - 29920430390903.8*cos(theta)**25 + 24524942943363.8*cos(theta)**23 - 15023754393876.6*cos(theta)**21 + 6918834260337.91*cos(theta)**19 - 2390142744480.37*cos(theta)**17 + 613319647640.245*cos(theta)**15 - 114792447419.297*cos(theta)**13 + 15227569555.6211*cos(theta)**11 - 1370730483.73021*cos(theta)**9 + 78327456.2131549*cos(theta)**7 - 2550196.24880039*cos(theta)**5 + 38874.9428170791*cos(theta)**3 - 175.904718629317*cos(theta))*cos(phi)

@torch.jit.script
def Yl36_m2(theta, phi):
    return 0.00256090555968341*(1.0 - cos(theta)**2)*(8113650266733.23*cos(theta)**34 - 64109264783624.5*cos(theta)**32 + 230421705309259.0*cos(theta)**30 - 498673839848397.0*cos(theta)**28 + 724995044087285.0*cos(theta)**26 - 748010759772595.0*cos(theta)**24 + 564073687697367.0*cos(theta)**22 - 315498842271409.0*cos(theta)**20 + 131457850946420.0*cos(theta)**18 - 40632426656166.3*cos(theta)**16 + 9199794714603.68*cos(theta)**14 - 1492301816450.86*cos(theta)**12 + 167503265111.832*cos(theta)**10 - 12336574353.5719*cos(theta)**8 + 548292193.492084*cos(theta)**6 - 12750981.244002*cos(theta)**4 + 116624.828451237*cos(theta)**2 - 175.904718629317)*cos(2*phi)

@torch.jit.script
def Yl36_m3(theta, phi):
    return 7.03269529120626e-5*(1.0 - cos(theta)**2)**1.5*(275864109068930.0*cos(theta)**33 - 2.05149647307599e+15*cos(theta)**31 + 6.91265115927778e+15*cos(theta)**29 - 1.39628675157551e+16*cos(theta)**27 + 1.88498711462694e+16*cos(theta)**25 - 1.79522582345423e+16*cos(theta)**23 + 1.24096211293421e+16*cos(theta)**21 - 6.30997684542817e+15*cos(theta)**19 + 2.36624131703556e+15*cos(theta)**17 - 650118826498660.0*cos(theta)**15 + 128797126004452.0*cos(theta)**13 - 17907621797410.4*cos(theta)**11 + 1675032651118.32*cos(theta)**9 - 98692594828.5751*cos(theta)**7 + 3289753160.9525*cos(theta)**5 - 51003924.9760078*cos(theta)**3 + 233249.656902475*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl36_m4(theta, phi):
    return 1.93568567169822e-6*(1.0 - cos(theta)**2)**2*(9.10351559927468e+15*cos(theta)**32 - 6.35963906653555e+16*cos(theta)**30 + 2.00466883619055e+17*cos(theta)**28 - 3.76997422925388e+17*cos(theta)**26 + 4.71246778656735e+17*cos(theta)**24 - 4.12901939394473e+17*cos(theta)**22 + 2.60602043716183e+17*cos(theta)**20 - 1.19889560063135e+17*cos(theta)**18 + 4.02261023896046e+16*cos(theta)**16 - 9.7517823974799e+15*cos(theta)**14 + 1.67436263805787e+15*cos(theta)**12 - 196983839771514.0*cos(theta)**10 + 15075293860064.9*cos(theta)**8 - 690848163800.026*cos(theta)**6 + 16448765804.7625*cos(theta)**4 - 153011774.928023*cos(theta)**2 + 233249.656902475)*cos(4*phi)

@torch.jit.script
def Yl36_m5(theta, phi):
    return 5.34401806817122e-8*(1.0 - cos(theta)**2)**2.5*(2.9131249917679e+17*cos(theta)**31 - 1.90789171996067e+18*cos(theta)**29 + 5.61307274133355e+18*cos(theta)**27 - 9.80193299606009e+18*cos(theta)**25 + 1.13099226877616e+19*cos(theta)**23 - 9.08384266667839e+18*cos(theta)**21 + 5.21204087432367e+18*cos(theta)**19 - 2.15801208113643e+18*cos(theta)**17 + 6.43617638233673e+17*cos(theta)**15 - 1.36524953564719e+17*cos(theta)**13 + 2.00923516566944e+16*cos(theta)**11 - 1.96983839771514e+15*cos(theta)**9 + 120602350880519.0*cos(theta)**7 - 4145088982800.16*cos(theta)**5 + 65795063219.0501*cos(theta)**3 - 306023549.856047*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl36_m6(theta, phi):
    return 1.48102512326443e-9*(1.0 - cos(theta)**2)**3*(9.03068747448049e+18*cos(theta)**30 - 5.53288598788593e+19*cos(theta)**28 + 1.51552964016006e+20*cos(theta)**26 - 2.45048324901502e+20*cos(theta)**24 + 2.60128221818518e+20*cos(theta)**22 - 1.90760696000246e+20*cos(theta)**20 + 9.90287766121497e+19*cos(theta)**18 - 3.66862053793194e+19*cos(theta)**16 + 9.6542645735051e+18*cos(theta)**14 - 1.77482439634134e+18*cos(theta)**12 + 2.21015868223639e+17*cos(theta)**10 - 1.77285455794363e+16*cos(theta)**8 + 844216456163632.0*cos(theta)**6 - 20725444914000.8*cos(theta)**4 + 197385189657.15*cos(theta)**2 - 306023549.856047)*cos(6*phi)

@torch.jit.script
def Yl36_m7(theta, phi):
    return 4.12351492246812e-11*(1.0 - cos(theta)**2)**3.5*(2.70920624234415e+20*cos(theta)**29 - 1.54920807660806e+21*cos(theta)**27 + 3.94037706441615e+21*cos(theta)**25 - 5.88115979763605e+21*cos(theta)**23 + 5.72282088000739e+21*cos(theta)**21 - 3.81521392000493e+21*cos(theta)**19 + 1.78251797901869e+21*cos(theta)**17 - 5.8697928606911e+20*cos(theta)**15 + 1.35159704029071e+20*cos(theta)**13 - 2.12978927560961e+19*cos(theta)**11 + 2.21015868223639e+18*cos(theta)**9 - 1.4182836463549e+17*cos(theta)**7 + 5.06529873698179e+15*cos(theta)**5 - 82901779656003.1*cos(theta)**3 + 394770379314.301*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl36_m8(theta, phi):
    return 1.15436256195231e-12*(1.0 - cos(theta)**2)**4*(7.85669810279802e+21*cos(theta)**28 - 4.18286180684176e+22*cos(theta)**26 + 9.85094266104039e+22*cos(theta)**24 - 1.35266675345629e+23*cos(theta)**22 + 1.20179238480155e+23*cos(theta)**20 - 7.24890644800936e+22*cos(theta)**18 + 3.03028056433178e+22*cos(theta)**16 - 8.80468929103665e+21*cos(theta)**14 + 1.75707615237793e+21*cos(theta)**12 - 2.34276820317057e+20*cos(theta)**10 + 1.98914281401275e+19*cos(theta)**8 - 9.92798552448431e+17*cos(theta)**6 + 2.5326493684909e+16*cos(theta)**4 - 248705338968009.0*cos(theta)**2 + 394770379314.301)*cos(8*phi)

@torch.jit.script
def Yl36_m9(theta, phi):
    return 3.25204810244434e-14*(1.0 - cos(theta)**2)**4.5*(2.19987546878345e+23*cos(theta)**27 - 1.08754406977886e+24*cos(theta)**25 + 2.36422623864969e+24*cos(theta)**23 - 2.97586685760384e+24*cos(theta)**21 + 2.4035847696031e+24*cos(theta)**19 - 1.30480316064168e+24*cos(theta)**17 + 4.84844890293085e+23*cos(theta)**15 - 1.23265650074513e+23*cos(theta)**13 + 2.10849138285351e+22*cos(theta)**11 - 2.34276820317057e+21*cos(theta)**9 + 1.5913142512102e+20*cos(theta)**7 - 5.95679131469059e+18*cos(theta)**5 + 1.01305974739636e+17*cos(theta)**3 - 497410677936019.0*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl36_m10(theta, phi):
    return 9.22775728515781e-16*(1.0 - cos(theta)**2)**5*(5.9396637657153e+24*cos(theta)**26 - 2.71886017444715e+25*cos(theta)**24 + 5.43772034889429e+25*cos(theta)**22 - 6.24932040096807e+25*cos(theta)**20 + 4.5668110622459e+25*cos(theta)**18 - 2.21816537309086e+25*cos(theta)**16 + 7.27267335439627e+24*cos(theta)**14 - 1.60245345096867e+24*cos(theta)**12 + 2.31934052113887e+23*cos(theta)**10 - 2.10849138285351e+22*cos(theta)**8 + 1.11391997584714e+21*cos(theta)**6 - 2.97839565734529e+19*cos(theta)**4 + 3.03917924218907e+17*cos(theta)**2 - 497410677936019.0)*cos(10*phi)

@torch.jit.script
def Yl36_m11(theta, phi):
    return 2.63973639315567e-17*(1.0 - cos(theta)**2)**5.5*(1.54431257908598e+26*cos(theta)**25 - 6.52526441867315e+26*cos(theta)**23 + 1.19629847675674e+27*cos(theta)**21 - 1.24986408019361e+27*cos(theta)**19 + 8.22025991204261e+26*cos(theta)**17 - 3.54906459694538e+26*cos(theta)**15 + 1.01817426961548e+26*cos(theta)**13 - 1.92294414116241e+25*cos(theta)**11 + 2.31934052113887e+24*cos(theta)**9 - 1.68679310628281e+23*cos(theta)**7 + 6.68351985508284e+21*cos(theta)**5 - 1.19135826293812e+20*cos(theta)**3 + 6.07835848437815e+17*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl36_m12(theta, phi):
    return 7.62026258589038e-19*(1.0 - cos(theta)**2)**6*(3.86078144771495e+27*cos(theta)**24 - 1.50081081629482e+28*cos(theta)**22 + 2.51222680118916e+28*cos(theta)**20 - 2.37474175236787e+28*cos(theta)**18 + 1.39744418504724e+28*cos(theta)**16 - 5.32359689541807e+27*cos(theta)**14 + 1.32362655050012e+27*cos(theta)**12 - 2.11523855527865e+26*cos(theta)**10 + 2.08740646902498e+25*cos(theta)**8 - 1.18075517439797e+24*cos(theta)**6 + 3.34175992754142e+22*cos(theta)**4 - 3.57407478881435e+20*cos(theta)**2 + 6.07835848437815e+17)*cos(12*phi)

@torch.jit.script
def Yl36_m13(theta, phi):
    return 2.22211369541106e-20*(1.0 - cos(theta)**2)**6.5*(9.26587547451588e+28*cos(theta)**23 - 3.30178379584861e+29*cos(theta)**21 + 5.02445360237833e+29*cos(theta)**19 - 4.27453515426216e+29*cos(theta)**17 + 2.23591069607559e+29*cos(theta)**15 - 7.4530356535853e+28*cos(theta)**13 + 1.58835186060015e+28*cos(theta)**11 - 2.11523855527865e+27*cos(theta)**9 + 1.66992517521998e+26*cos(theta)**7 - 7.08453104638781e+24*cos(theta)**5 + 1.33670397101657e+23*cos(theta)**3 - 7.1481495776287e+20*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl36_m14(theta, phi):
    return 6.55265580099988e-22*(1.0 - cos(theta)**2)**7*(2.13115135913865e+30*cos(theta)**22 - 6.93374597128209e+30*cos(theta)**20 + 9.54646184451882e+30*cos(theta)**18 - 7.26670976224567e+30*cos(theta)**16 + 3.35386604411339e+30*cos(theta)**14 - 9.68894634966089e+29*cos(theta)**12 + 1.74718704666016e+29*cos(theta)**10 - 1.90371469975078e+28*cos(theta)**8 + 1.16894762265399e+27*cos(theta)**6 - 3.5422655231939e+25*cos(theta)**4 + 4.0101119130497e+23*cos(theta)**2 - 7.1481495776287e+20)*cos(14*phi)

@torch.jit.script
def Yl36_m15(theta, phi):
    return 1.95623456117164e-23*(1.0 - cos(theta)**2)**7.5*(4.68853299010503e+31*cos(theta)**21 - 1.38674919425642e+32*cos(theta)**19 + 1.71836313201339e+32*cos(theta)**17 - 1.16267356195931e+32*cos(theta)**15 + 4.69541246175874e+31*cos(theta)**13 - 1.16267356195931e+31*cos(theta)**11 + 1.74718704666016e+30*cos(theta)**9 - 1.52297175980062e+29*cos(theta)**7 + 7.01368573592393e+27*cos(theta)**5 - 1.41690620927756e+26*cos(theta)**3 + 8.0202238260994e+23*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl36_m16(theta, phi):
    return 5.91983508389675e-25*(1.0 - cos(theta)**2)**8*(9.84591927922057e+32*cos(theta)**20 - 2.63482346908719e+33*cos(theta)**18 + 2.92121732442276e+33*cos(theta)**16 - 1.74401034293896e+33*cos(theta)**14 + 6.10403620028636e+32*cos(theta)**12 - 1.27894091815524e+32*cos(theta)**10 + 1.57246834199415e+31*cos(theta)**8 - 1.06608023186044e+30*cos(theta)**6 + 3.50684286796196e+28*cos(theta)**4 - 4.25071862783268e+26*cos(theta)**2 + 8.0202238260994e+23)*cos(16*phi)

@torch.jit.script
def Yl36_m17(theta, phi):
    return 1.81826289225004e-26*(1.0 - cos(theta)**2)**8.5*(1.96918385584411e+34*cos(theta)**19 - 4.74268224435695e+34*cos(theta)**17 + 4.67394771907641e+34*cos(theta)**15 - 2.44161448011455e+34*cos(theta)**13 + 7.32484344034364e+33*cos(theta)**11 - 1.27894091815524e+33*cos(theta)**9 + 1.25797467359532e+32*cos(theta)**7 - 6.39648139116262e+30*cos(theta)**5 + 1.40273714718479e+29*cos(theta)**3 - 8.50143725566537e+26*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl36_m18(theta, phi):
    return 5.67653075535627e-28*(1.0 - cos(theta)**2)**9*(3.74144932610382e+35*cos(theta)**18 - 8.06255981540682e+35*cos(theta)**16 + 7.01092157861462e+35*cos(theta)**14 - 3.17409882414891e+35*cos(theta)**12 + 8.057327784378e+34*cos(theta)**10 - 1.15104682633971e+34*cos(theta)**8 + 8.80582271516721e+32*cos(theta)**6 - 3.19824069558131e+31*cos(theta)**4 + 4.20821144155436e+29*cos(theta)**2 - 8.50143725566537e+26)*cos(18*phi)

@torch.jit.script
def Yl36_m19(theta, phi):
    return 1.80411990397808e-29*(1.0 - cos(theta)**2)**9.5*(6.73460878698687e+36*cos(theta)**17 - 1.29000957046509e+37*cos(theta)**15 + 9.81529021006047e+36*cos(theta)**13 - 3.80891858897869e+36*cos(theta)**11 + 8.057327784378e+35*cos(theta)**9 - 9.20837461071771e+34*cos(theta)**7 + 5.28349362910033e+33*cos(theta)**5 - 1.27929627823252e+32*cos(theta)**3 + 8.41642288310872e+29*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl36_m20(theta, phi):
    return 5.84718619746581e-31*(1.0 - cos(theta)**2)**10*(1.14488349378777e+38*cos(theta)**16 - 1.93501435569764e+38*cos(theta)**14 + 1.27598772730786e+38*cos(theta)**12 - 4.18981044787656e+37*cos(theta)**10 + 7.2515950059402e+36*cos(theta)**8 - 6.4458622275024e+35*cos(theta)**6 + 2.64174681455016e+34*cos(theta)**4 - 3.83788883469757e+32*cos(theta)**2 + 8.41642288310872e+29)*cos(20*phi)

@torch.jit.script
def Yl36_m21(theta, phi):
    return 1.93619682908189e-32*(1.0 - cos(theta)**2)**10.5*(1.83181359006043e+39*cos(theta)**15 - 2.70902009797669e+39*cos(theta)**13 + 1.53118527276943e+39*cos(theta)**11 - 4.18981044787656e+38*cos(theta)**9 + 5.80127600475216e+37*cos(theta)**7 - 3.86751733650144e+36*cos(theta)**5 + 1.05669872582007e+35*cos(theta)**3 - 7.67577766939515e+32*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl36_m22(theta, phi):
    return 6.56432202813386e-34*(1.0 - cos(theta)**2)**11*(2.74772038509064e+40*cos(theta)**14 - 3.5217261273697e+40*cos(theta)**12 + 1.68430380004638e+40*cos(theta)**10 - 3.7708294030889e+39*cos(theta)**8 + 4.06089320332651e+38*cos(theta)**6 - 1.93375866825072e+37*cos(theta)**4 + 3.1700961774602e+35*cos(theta)**2 - 7.67577766939515e+32)*cos(22*phi)

@torch.jit.script
def Yl36_m23(theta, phi):
    return 2.28401974801605e-35*(1.0 - cos(theta)**2)**11.5*(3.8468085391269e+41*cos(theta)**13 - 4.22607135284364e+41*cos(theta)**11 + 1.68430380004638e+41*cos(theta)**9 - 3.01666352247112e+40*cos(theta)**7 + 2.43653592199591e+39*cos(theta)**5 - 7.73503467300288e+37*cos(theta)**3 + 6.34019235492039e+35*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl36_m24(theta, phi):
    return 8.17810257077045e-37*(1.0 - cos(theta)**2)**12*(5.00085110086497e+42*cos(theta)**12 - 4.648678488128e+42*cos(theta)**10 + 1.51587342004174e+42*cos(theta)**8 - 2.11166446572979e+41*cos(theta)**6 + 1.21826796099795e+40*cos(theta)**4 - 2.32051040190086e+38*cos(theta)**2 + 6.34019235492039e+35)*cos(24*phi)

@torch.jit.script
def Yl36_m25(theta, phi):
    return 3.0227136881809e-38*(1.0 - cos(theta)**2)**12.5*(6.00102132103796e+43*cos(theta)**11 - 4.648678488128e+43*cos(theta)**9 + 1.21269873603339e+43*cos(theta)**7 - 1.26699867943787e+42*cos(theta)**5 + 4.87307184399181e+40*cos(theta)**3 - 4.64102080380173e+38*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl36_m26(theta, phi):
    return 1.1574568923217e-39*(1.0 - cos(theta)**2)**13*(6.60112345314176e+44*cos(theta)**10 - 4.1838106393152e+44*cos(theta)**8 + 8.48889115223374e+43*cos(theta)**6 - 6.33499339718936e+42*cos(theta)**4 + 1.46192155319754e+41*cos(theta)**2 - 4.64102080380173e+38)*cos(26*phi)

@torch.jit.script
def Yl36_m27(theta, phi):
    return 4.61141863924726e-41*(1.0 - cos(theta)**2)**13.5*(6.60112345314176e+45*cos(theta)**9 - 3.34704851145216e+45*cos(theta)**7 + 5.09333469134024e+44*cos(theta)**5 - 2.53399735887574e+43*cos(theta)**3 + 2.92384310639509e+41*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl36_m28(theta, phi):
    return 1.92142443301969e-42*(1.0 - cos(theta)**2)**14*(5.94101110782758e+46*cos(theta)**8 - 2.34293395801651e+46*cos(theta)**6 + 2.54666734567012e+45*cos(theta)**4 - 7.60199207662723e+43*cos(theta)**2 + 2.92384310639509e+41)*cos(28*phi)

@torch.jit.script
def Yl36_m29(theta, phi):
    return 8.42600353736191e-44*(1.0 - cos(theta)**2)**14.5*(4.75280888626207e+47*cos(theta)**7 - 1.40576037480991e+47*cos(theta)**5 + 1.01866693826805e+46*cos(theta)**3 - 1.52039841532545e+44*cos(theta))*cos(29*phi)

@torch.jit.script
def Yl36_m30(theta, phi):
    return 3.92013162413846e-45*(1.0 - cos(theta)**2)**15*(3.32696622038345e+48*cos(theta)**6 - 7.02880187404954e+47*cos(theta)**4 + 3.05600081480415e+46*cos(theta)**2 - 1.52039841532545e+44)*cos(30*phi)

@torch.jit.script
def Yl36_m31(theta, phi):
    return 1.95518394692445e-46*(1.0 - cos(theta)**2)**15.5*(1.99617973223007e+49*cos(theta)**5 - 2.81152074961981e+48*cos(theta)**3 + 6.11200162960829e+46*cos(theta))*cos(31*phi)

@torch.jit.script
def Yl36_m32(theta, phi):
    return 1.06034737181502e-47*(1.0 - cos(theta)**2)**16*(9.98089866115034e+49*cos(theta)**4 - 8.43456224885944e+48*cos(theta)**2 + 6.11200162960829e+46)*cos(32*phi)

@torch.jit.script
def Yl36_m33(theta, phi):
    return 6.38254114616021e-49*(1.0 - cos(theta)**2)**16.5*(3.99235946446014e+50*cos(theta)**3 - 1.68691244977189e+49*cos(theta))*cos(33*phi)

@torch.jit.script
def Yl36_m34(theta, phi):
    return 4.40437182605064e-50*(1.0 - cos(theta)**2)**17*(1.19770783933804e+51*cos(theta)**2 - 1.68691244977189e+49)*cos(34*phi)

@torch.jit.script
def Yl36_m35(theta, phi):
    return 8.85361619789771*(1.0 - cos(theta)**2)**17.5*cos(35*phi)*cos(theta)

@torch.jit.script
def Yl36_m36(theta, phi):
    return 1.04340867525942*(1.0 - cos(theta)**2)**18*cos(36*phi)

@torch.jit.script
def Yl37_m_minus_37(theta, phi):
    return 1.05043507569481*(1.0 - cos(theta)**2)**18.5*sin(37*phi)

@torch.jit.script
def Yl37_m_minus_36(theta, phi):
    return 9.03618419303727*(1.0 - cos(theta)**2)**18*sin(36*phi)*cos(theta)

@torch.jit.script
def Yl37_m_minus_35(theta, phi):
    return 6.24392610871321e-52*(1.0 - cos(theta)**2)**17.5*(8.7432672271677e+52*cos(theta)**2 - 1.19770783933804e+51)*sin(35*phi)

@torch.jit.script
def Yl37_m_minus_34(theta, phi):
    return 9.17665977479345e-51*(1.0 - cos(theta)**2)**17*(2.9144224090559e+52*cos(theta)**3 - 1.19770783933804e+51*cos(theta))*sin(34*phi)

@torch.jit.script
def Yl37_m_minus_33(theta, phi):
    return 1.54647819359785e-49*(1.0 - cos(theta)**2)**16.5*(7.28605602263975e+51*cos(theta)**4 - 5.98853919669021e+50*cos(theta)**2 + 4.21728112442972e+48)*sin(33*phi)

@torch.jit.script
def Yl37_m_minus_32(theta, phi):
    return 2.89319577828011e-48*(1.0 - cos(theta)**2)**16*(1.45721120452795e+51*cos(theta)**5 - 1.99617973223007e+50*cos(theta)**3 + 4.21728112442972e+48*cos(theta))*sin(32*phi)

@torch.jit.script
def Yl37_m_minus_31(theta, phi):
    return 5.88678254222418e-47*(1.0 - cos(theta)**2)**15.5*(2.42868534087992e+50*cos(theta)**6 - 4.99044933057517e+49*cos(theta)**4 + 2.10864056221486e+48*cos(theta)**2 - 1.01866693826805e+46)*sin(31*phi)

@torch.jit.script
def Yl37_m_minus_30(theta, phi):
    return 1.28434432069174e-45*(1.0 - cos(theta)**2)**15*(3.46955048697131e+49*cos(theta)**7 - 9.98089866115034e+48*cos(theta)**5 + 7.02880187404954e+47*cos(theta)**3 - 1.01866693826805e+46*cos(theta))*sin(30*phi)

@torch.jit.script
def Yl37_m_minus_29(theta, phi):
    return 2.9734720766705e-44*(1.0 - cos(theta)**2)**14.5*(4.33693810871414e+48*cos(theta)**8 - 1.66348311019172e+48*cos(theta)**6 + 1.75720046851238e+47*cos(theta)**4 - 5.09333469134024e+45*cos(theta)**2 + 1.90049801915681e+43)*sin(29*phi)

@torch.jit.script
def Yl37_m_minus_28(theta, phi):
    return 7.24698040379513e-43*(1.0 - cos(theta)**2)**14*(4.81882012079349e+47*cos(theta)**9 - 2.37640444313103e+47*cos(theta)**7 + 3.51440093702477e+46*cos(theta)**5 - 1.69777823044675e+45*cos(theta)**3 + 1.90049801915681e+43*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl37_m_minus_27(theta, phi):
    return 1.84762472467879e-41*(1.0 - cos(theta)**2)**13.5*(4.81882012079349e+46*cos(theta)**10 - 2.97050555391379e+46*cos(theta)**8 + 5.85733489504128e+45*cos(theta)**6 - 4.24444557611687e+44*cos(theta)**4 + 9.50249009578404e+42*cos(theta)**2 - 2.92384310639509e+40)*sin(27*phi)

@torch.jit.script
def Yl37_m_minus_26(theta, phi):
    return 4.90230237211461e-40*(1.0 - cos(theta)**2)**13*(4.38074556435771e+45*cos(theta)**11 - 3.30056172657088e+45*cos(theta)**9 + 8.3676212786304e+44*cos(theta)**7 - 8.48889115223374e+43*cos(theta)**5 + 3.16749669859468e+42*cos(theta)**3 - 2.92384310639509e+40*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl37_m_minus_25(theta, phi):
    return 1.34791030198661e-38*(1.0 - cos(theta)**2)**12.5*(3.65062130363143e+44*cos(theta)**12 - 3.30056172657088e+44*cos(theta)**10 + 1.0459526598288e+44*cos(theta)**8 - 1.41481519203896e+43*cos(theta)**6 + 7.9187417464867e+41*cos(theta)**4 - 1.46192155319754e+40*cos(theta)**2 + 3.86751733650144e+37)*sin(25*phi)

@torch.jit.script
def Yl37_m_minus_24(theta, phi):
    return 3.82673610124151e-37*(1.0 - cos(theta)**2)**12*(2.80817023356264e+43*cos(theta)**13 - 3.00051066051898e+43*cos(theta)**11 + 1.162169622032e+43*cos(theta)**9 - 2.02116456005565e+42*cos(theta)**7 + 1.58374834929734e+41*cos(theta)**5 - 4.87307184399181e+39*cos(theta)**3 + 3.86751733650144e+37*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl37_m_minus_23(theta, phi):
    return 1.11829774420847e-35*(1.0 - cos(theta)**2)**11.5*(2.00583588111617e+42*cos(theta)**14 - 2.50042555043248e+42*cos(theta)**12 + 1.162169622032e+42*cos(theta)**10 - 2.52645570006957e+41*cos(theta)**8 + 2.63958058216223e+40*cos(theta)**6 - 1.21826796099795e+39*cos(theta)**4 + 1.93375866825072e+37*cos(theta)**2 - 4.52870882494314e+34)*sin(23*phi)

@torch.jit.script
def Yl37_m_minus_22(theta, phi):
    return 3.3548932326254e-34*(1.0 - cos(theta)**2)**11*(1.33722392074411e+41*cos(theta)**15 - 1.92340426956345e+41*cos(theta)**13 + 1.05651783821091e+41*cos(theta)**11 - 2.80717300007729e+40*cos(theta)**9 + 3.7708294030889e+39*cos(theta)**7 - 2.43653592199591e+38*cos(theta)**5 + 6.4458622275024e+36*cos(theta)**3 - 4.52870882494314e+34*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl37_m_minus_21(theta, phi):
    return 1.03077695553335e-32*(1.0 - cos(theta)**2)**10.5*(8.35764950465071e+39*cos(theta)**16 - 1.37386019254532e+40*cos(theta)**14 + 8.80431531842424e+39*cos(theta)**12 - 2.80717300007729e+39*cos(theta)**10 + 4.71353675386113e+38*cos(theta)**8 - 4.06089320332651e+37*cos(theta)**6 + 1.6114655568756e+36*cos(theta)**4 - 2.26435441247157e+34*cos(theta)**2 + 4.79736104337197e+31)*sin(21*phi)

@torch.jit.script
def Yl37_m_minus_20(theta, phi):
    return 3.236705294292e-31*(1.0 - cos(theta)**2)**10*(4.91626441450041e+38*cos(theta)**17 - 9.15906795030214e+38*cos(theta)**15 + 6.77255024494173e+38*cos(theta)**13 - 2.55197545461572e+38*cos(theta)**11 + 5.2372630598457e+37*cos(theta)**9 - 5.80127600475216e+36*cos(theta)**7 + 3.2229311137512e+35*cos(theta)**5 - 7.5478480415719e+33*cos(theta)**3 + 4.79736104337197e+31*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl37_m_minus_19(theta, phi):
    return 1.03675667117759e-29*(1.0 - cos(theta)**2)**9.5*(2.73125800805579e+37*cos(theta)**18 - 5.72441746893884e+37*cos(theta)**16 + 4.83753588924409e+37*cos(theta)**14 - 2.12664621217977e+37*cos(theta)**12 + 5.2372630598457e+36*cos(theta)**10 - 7.2515950059402e+35*cos(theta)**8 + 5.371551856252e+34*cos(theta)**6 - 1.88696201039297e+33*cos(theta)**4 + 2.39868052168598e+31*cos(theta)**2 - 4.67579049061595e+28)*sin(19*phi)

@torch.jit.script
def Yl37_m_minus_18(theta, phi):
    return 3.38179791904549e-28*(1.0 - cos(theta)**2)**9*(1.4375042147662e+36*cos(theta)**19 - 3.36730439349343e+36*cos(theta)**17 + 3.22502392616273e+36*cos(theta)**15 - 1.63588170167675e+36*cos(theta)**13 + 4.76114823622336e+35*cos(theta)**11 - 8.057327784378e+34*cos(theta)**9 + 7.67364550893143e+33*cos(theta)**7 - 3.77392402078595e+32*cos(theta)**5 + 7.99560173895328e+30*cos(theta)**3 - 4.67579049061595e+28*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl37_m_minus_17(theta, phi):
    return 1.12161548142786e-26*(1.0 - cos(theta)**2)**8.5*(7.18752107383102e+34*cos(theta)**20 - 1.87072466305191e+35*cos(theta)**18 + 2.0156399538517e+35*cos(theta)**16 - 1.1684869297691e+35*cos(theta)**14 + 3.96762353018614e+34*cos(theta)**12 - 8.057327784378e+33*cos(theta)**10 + 9.59205688616428e+32*cos(theta)**8 - 6.28987336797658e+31*cos(theta)**6 + 1.99890043473832e+30*cos(theta)**4 - 2.33789524530798e+28*cos(theta)**2 + 4.25071862783268e+25)*sin(17*phi)

@torch.jit.script
def Yl37_m_minus_16(theta, phi):
    return 3.7770307660841e-25*(1.0 - cos(theta)**2)**8*(3.42262908277667e+33*cos(theta)**21 - 9.84591927922057e+33*cos(theta)**19 + 1.18567056108924e+34*cos(theta)**17 - 7.78991286512736e+33*cos(theta)**15 + 3.05201810014318e+33*cos(theta)**13 - 7.32484344034364e+32*cos(theta)**11 + 1.0657840984627e+32*cos(theta)**9 - 8.98553338282369e+30*cos(theta)**7 + 3.99780086947664e+29*cos(theta)**5 - 7.79298415102659e+27*cos(theta)**3 + 4.25071862783268e+25*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl37_m_minus_15(theta, phi):
    return 1.28973295692034e-23*(1.0 - cos(theta)**2)**7.5*(1.55574049217122e+32*cos(theta)**22 - 4.92295963961028e+32*cos(theta)**20 + 6.58705867271799e+32*cos(theta)**18 - 4.8686955407046e+32*cos(theta)**16 + 2.1800129286737e+32*cos(theta)**14 - 6.10403620028636e+31*cos(theta)**12 + 1.0657840984627e+31*cos(theta)**10 - 1.12319167285296e+30*cos(theta)**8 + 6.66300144912773e+28*cos(theta)**6 - 1.94824603775665e+27*cos(theta)**4 + 2.12535931391634e+25*cos(theta)**2 - 3.64555628459064e+22)*sin(15*phi)

@torch.jit.script
def Yl37_m_minus_14(theta, phi):
    return 4.4603135268713e-22*(1.0 - cos(theta)**2)**7*(6.76408909639659e+30*cos(theta)**23 - 2.34426649505252e+31*cos(theta)**21 + 3.46687298564105e+31*cos(theta)**19 - 2.86393855335565e+31*cos(theta)**17 + 1.45334195244913e+31*cos(theta)**15 - 4.69541246175874e+30*cos(theta)**13 + 9.68894634966089e+29*cos(theta)**11 - 1.2479907476144e+29*cos(theta)**9 + 9.5185734987539e+27*cos(theta)**7 - 3.89649207551329e+26*cos(theta)**5 + 7.08453104638781e+24*cos(theta)**3 - 3.64555628459064e+22*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl37_m_minus_13(theta, phi):
    return 1.56047241666686e-20*(1.0 - cos(theta)**2)**6.5*(2.81837045683191e+29*cos(theta)**24 - 1.06557567956933e+30*cos(theta)**22 + 1.73343649282052e+30*cos(theta)**20 - 1.59107697408647e+30*cos(theta)**18 + 9.08338720280709e+29*cos(theta)**16 - 3.35386604411339e+29*cos(theta)**14 + 8.07412195805074e+28*cos(theta)**12 - 1.2479907476144e+28*cos(theta)**10 + 1.18982168734424e+27*cos(theta)**8 - 6.49415345918882e+25*cos(theta)**6 + 1.77113276159695e+24*cos(theta)**4 - 1.82277814229532e+22*cos(theta)**2 + 2.97839565734529e+19)*sin(13*phi)

@torch.jit.script
def Yl37_m_minus_12(theta, phi):
    return 5.51710313839849e-19*(1.0 - cos(theta)**2)**6*(1.12734818273276e+28*cos(theta)**25 - 4.63293773725794e+28*cos(theta)**23 + 8.25445948962154e+28*cos(theta)**21 - 8.37408933729721e+28*cos(theta)**19 + 5.3431689428277e+28*cos(theta)**17 - 2.23591069607559e+28*cos(theta)**15 + 6.21086304465442e+27*cos(theta)**13 - 1.13453704328582e+27*cos(theta)**11 + 1.32202409704915e+26*cos(theta)**9 - 9.27736208455546e+24*cos(theta)**7 + 3.5422655231939e+23*cos(theta)**5 - 6.0759271409844e+21*cos(theta)**3 + 2.97839565734529e+19*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl37_m_minus_11(theta, phi):
    return 1.96922715928385e-17*(1.0 - cos(theta)**2)**5.5*(4.33595454897217e+26*cos(theta)**26 - 1.93039072385747e+27*cos(theta)**24 + 3.75202704073706e+27*cos(theta)**22 - 4.18704466864861e+27*cos(theta)**20 + 2.96842719045983e+27*cos(theta)**18 - 1.39744418504724e+27*cos(theta)**16 + 4.43633074618173e+26*cos(theta)**14 - 9.45447536071516e+25*cos(theta)**12 + 1.32202409704915e+25*cos(theta)**10 - 1.15967026056943e+24*cos(theta)**8 + 5.90377587198984e+22*cos(theta)**6 - 1.5189817852461e+21*cos(theta)**4 + 1.48919782867265e+19*cos(theta)**2 - 2.33783018629929e+16)*sin(11*phi)

@torch.jit.script
def Yl37_m_minus_10(theta, phi):
    return 7.08921777342186e-16*(1.0 - cos(theta)**2)**5*(1.60590909221192e+25*cos(theta)**27 - 7.7215628954299e+25*cos(theta)**25 + 1.63131610466829e+26*cos(theta)**23 - 1.99383079459457e+26*cos(theta)**21 + 1.56233010024202e+26*cos(theta)**19 - 8.22025991204261e+25*cos(theta)**17 + 2.95755383078782e+25*cos(theta)**15 - 7.27267335439627e+24*cos(theta)**13 + 1.2018400882265e+24*cos(theta)**11 - 1.28852251174381e+23*cos(theta)**9 + 8.43396553141406e+21*cos(theta)**7 - 3.0379635704922e+20*cos(theta)**5 + 4.96399276224215e+18*cos(theta)**3 - 2.33783018629929e+16*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl37_m_minus_9(theta, phi):
    return 2.57173527737449e-14*(1.0 - cos(theta)**2)**4.5*(5.73538961504256e+23*cos(theta)**28 - 2.96983188285765e+24*cos(theta)**26 + 6.79715043611787e+24*cos(theta)**24 - 9.06286724815716e+24*cos(theta)**22 + 7.81165050121009e+24*cos(theta)**20 - 4.5668110622459e+24*cos(theta)**18 + 1.84847114424239e+24*cos(theta)**16 - 5.19476668171163e+23*cos(theta)**14 + 1.00153340685542e+23*cos(theta)**12 - 1.28852251174381e+22*cos(theta)**10 + 1.05424569142676e+21*cos(theta)**8 - 5.063272617487e+19*cos(theta)**6 + 1.24099819056054e+18*cos(theta)**4 - 1.16891509314964e+16*cos(theta)**2 + 17764667069143.5)*sin(9*phi)

@torch.jit.script
def Yl37_m_minus_8(theta, phi):
    return 9.39299685798656e-13*(1.0 - cos(theta)**2)**4*(1.97772055691123e+22*cos(theta)**29 - 1.09993773439172e+23*cos(theta)**27 + 2.71886017444715e+23*cos(theta)**25 - 3.94037706441615e+23*cos(theta)**23 + 3.7198335720048e+23*cos(theta)**21 - 2.4035847696031e+23*cos(theta)**19 + 1.0873359672014e+23*cos(theta)**17 - 3.46317778780775e+22*cos(theta)**15 + 7.70410312965707e+21*cos(theta)**13 - 1.17138410158529e+21*cos(theta)**11 + 1.17138410158529e+20*cos(theta)**9 - 7.23324659641e+18*cos(theta)**7 + 2.48199638112108e+17*cos(theta)**5 - 3.89638364383215e+15*cos(theta)**3 + 17764667069143.5*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl37_m_minus_7(theta, phi):
    return 3.45120741864491e-11*(1.0 - cos(theta)**2)**3.5*(6.59240185637075e+20*cos(theta)**30 - 3.92834905139901e+21*cos(theta)**28 + 1.04571545171044e+22*cos(theta)**26 - 1.64182377684006e+22*cos(theta)**24 + 1.69083344182036e+22*cos(theta)**22 - 1.20179238480155e+22*cos(theta)**20 + 6.04075537334113e+21*cos(theta)**18 - 2.16448611737984e+21*cos(theta)**16 + 5.50293080689791e+20*cos(theta)**14 - 9.76153417987738e+19*cos(theta)**12 + 1.17138410158529e+19*cos(theta)**10 - 9.0415582455125e+17*cos(theta)**8 + 4.1366606352018e+16*cos(theta)**6 - 974095910958037.0*cos(theta)**4 + 8882333534571.76*cos(theta)**2 - 13159012643.81)*sin(7*phi)

@torch.jit.script
def Yl37_m_minus_6(theta, phi):
    return 1.27461271489967e-9*(1.0 - cos(theta)**2)**3*(2.12658124399057e+19*cos(theta)**31 - 1.35460312117207e+20*cos(theta)**29 + 3.87302019152015e+20*cos(theta)**27 - 6.56729510736026e+20*cos(theta)**25 + 7.35144974704506e+20*cos(theta)**23 - 5.72282088000739e+20*cos(theta)**21 + 3.17934493333744e+20*cos(theta)**19 - 1.2732271278705e+20*cos(theta)**17 + 3.66862053793194e+19*cos(theta)**15 - 7.50887244605952e+18*cos(theta)**13 + 1.06489463780481e+18*cos(theta)**11 - 1.00461758283472e+17*cos(theta)**9 + 5.90951519314542e+15*cos(theta)**7 - 194819182191607.0*cos(theta)**5 + 2960777844857.25*cos(theta)**3 - 13159012643.81*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl37_m_minus_5(theta, phi):
    return 4.72810881899504e-8*(1.0 - cos(theta)**2)**2.5*(6.64556638747052e+17*cos(theta)**32 - 4.51534373724024e+18*cos(theta)**30 + 1.38322149697148e+19*cos(theta)**28 - 2.5258827336001e+19*cos(theta)**26 + 3.06310406126878e+19*cos(theta)**24 - 2.60128221818518e+19*cos(theta)**22 + 1.58967246666872e+19*cos(theta)**20 - 7.07348404372498e+18*cos(theta)**18 + 2.29288783620746e+18*cos(theta)**16 - 5.36348031861394e+17*cos(theta)**14 + 8.87412198170671e+16*cos(theta)**12 - 1.00461758283472e+16*cos(theta)**10 + 738689399143178.0*cos(theta)**8 - 32469863698601.2*cos(theta)**6 + 740194461214.314*cos(theta)**4 - 6579506321.90501*cos(theta)**2 + 9563235.93300147)*sin(5*phi)

@torch.jit.script
def Yl37_m_minus_4(theta, phi):
    return 1.76022862219379e-6*(1.0 - cos(theta)**2)**2*(2.01380799620319e+16*cos(theta)**33 - 1.45656249588395e+17*cos(theta)**31 + 4.76972929990167e+17*cos(theta)**29 - 9.35512123555592e+17*cos(theta)**27 + 1.22524162450751e+18*cos(theta)**25 - 1.13099226877616e+18*cos(theta)**23 + 7.56986888889866e+17*cos(theta)**21 - 3.72288633880262e+17*cos(theta)**19 + 1.34875755071027e+17*cos(theta)**17 - 3.57565354574263e+16*cos(theta)**15 + 6.82624767823593e+15*cos(theta)**13 - 913288711667929.0*cos(theta)**11 + 82076599904797.5*cos(theta)**9 - 4638551956943.03*cos(theta)**7 + 148038892242.863*cos(theta)**5 - 2193168773.96834*cos(theta)**3 + 9563235.93300147*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl37_m_minus_3(theta, phi):
    return 6.57204404620968e-5*(1.0 - cos(theta)**2)**1.5*(592296469471526.0*cos(theta)**34 - 4.55175779963734e+15*cos(theta)**32 + 1.58990976663389e+16*cos(theta)**30 - 3.34111472698426e+16*cos(theta)**28 + 4.71246778656735e+16*cos(theta)**26 - 4.71246778656735e+16*cos(theta)**24 + 3.44084949495394e+16*cos(theta)**22 - 1.86144316940131e+16*cos(theta)**20 + 7.49309750394595e+15*cos(theta)**18 - 2.23478346608914e+15*cos(theta)**16 + 487589119873995.0*cos(theta)**14 - 76107392638994.1*cos(theta)**12 + 8207659990479.75*cos(theta)**10 - 579818994617.879*cos(theta)**8 + 24673148707.1438*cos(theta)**6 - 548292193.492084*cos(theta)**4 + 4781617.96650073*cos(theta)**2 - 6860.28402654338)*sin(3*phi)

@torch.jit.script
def Yl37_m_minus_2(theta, phi):
    return 0.00245903371517041*(1.0 - cos(theta)**2)*(16922756270615.0*cos(theta)**35 - 137932054534465.0*cos(theta)**33 + 512874118268996.0*cos(theta)**31 - 1.1521085265463e+15*cos(theta)**29 + 1.74535843946939e+15*cos(theta)**27 - 1.88498711462694e+15*cos(theta)**25 + 1.49602151954519e+15*cos(theta)**23 - 886401509238719.0*cos(theta)**21 + 394373552839261.0*cos(theta)**19 - 131457850946420.0*cos(theta)**17 + 32505941324933.0*cos(theta)**15 - 5854414818384.16*cos(theta)**13 + 746150908225.432*cos(theta)**11 - 64424332735.3199*cos(theta)**9 + 3524735529.59197*cos(theta)**7 - 109658438.698417*cos(theta)**5 + 1593872.65550024*cos(theta)**3 - 6860.28402654338*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl37_m_minus_1(theta, phi):
    return 0.0921399637754005*(1.0 - cos(theta)**2)**0.5*(470076563072.639*cos(theta)**36 - 4056825133366.61*cos(theta)**34 + 16027316195906.1*cos(theta)**32 - 38403617551543.2*cos(theta)**30 + 62334229981049.6*cos(theta)**28 - 72499504408728.5*cos(theta)**26 + 62334229981049.6*cos(theta)**24 - 40290977692669.1*cos(theta)**22 + 19718677641963.0*cos(theta)**20 - 7303213941467.79*cos(theta)**18 + 2031621332808.31*cos(theta)**16 - 418172487027.44*cos(theta)**14 + 62179242352.1193*cos(theta)**12 - 6442433273.53199*cos(theta)**10 + 440591941.198996*cos(theta)**8 - 18276406.4497361*cos(theta)**6 + 398468.163875061*cos(theta)**4 - 3430.14201327169*cos(theta)**2 + 4.8862421841477)*sin(phi)

@torch.jit.script
def Yl37_m0(theta, phi):
    return 31037917500.5382*cos(theta)**37 - 283167850073.404*cos(theta)**35 + 1186513174603.35*cos(theta)**33 - 3026468387394.04*cos(theta)**31 + 5251148507978.47*cos(theta)**29 - 6559896289966.95*cos(theta)**27 + 6091332269255.03*cos(theta)**25 - 4279624545144.05*cos(theta)**23 + 2293951292206.45*cos(theta)**21 - 939044388622.523*cos(theta)**19 + 291957437189.912*cos(theta)**17 - 68106709190.0995*cos(theta)**15 + 11684974615.9484*cos(theta)**13 - 1430813218.2794*cos(theta)**11 + 119596849.55223*cos(theta)**9 - 6378498.64278557*cos(theta)**7 + 194692.545782699*cos(theta)**5 - 2793.29333978048*cos(theta)**3 + 11.9371510247029*cos(theta)

@torch.jit.script
def Yl37_m1(theta, phi):
    return 0.0921399637754005*(1.0 - cos(theta)**2)**0.5*(470076563072.639*cos(theta)**36 - 4056825133366.61*cos(theta)**34 + 16027316195906.1*cos(theta)**32 - 38403617551543.2*cos(theta)**30 + 62334229981049.6*cos(theta)**28 - 72499504408728.5*cos(theta)**26 + 62334229981049.6*cos(theta)**24 - 40290977692669.1*cos(theta)**22 + 19718677641963.0*cos(theta)**20 - 7303213941467.79*cos(theta)**18 + 2031621332808.31*cos(theta)**16 - 418172487027.44*cos(theta)**14 + 62179242352.1193*cos(theta)**12 - 6442433273.53199*cos(theta)**10 + 440591941.198996*cos(theta)**8 - 18276406.4497361*cos(theta)**6 + 398468.163875061*cos(theta)**4 - 3430.14201327169*cos(theta)**2 + 4.8862421841477)*cos(phi)

@torch.jit.script
def Yl37_m2(theta, phi):
    return 0.00245903371517041*(1.0 - cos(theta)**2)*(16922756270615.0*cos(theta)**35 - 137932054534465.0*cos(theta)**33 + 512874118268996.0*cos(theta)**31 - 1.1521085265463e+15*cos(theta)**29 + 1.74535843946939e+15*cos(theta)**27 - 1.88498711462694e+15*cos(theta)**25 + 1.49602151954519e+15*cos(theta)**23 - 886401509238719.0*cos(theta)**21 + 394373552839261.0*cos(theta)**19 - 131457850946420.0*cos(theta)**17 + 32505941324933.0*cos(theta)**15 - 5854414818384.16*cos(theta)**13 + 746150908225.432*cos(theta)**11 - 64424332735.3199*cos(theta)**9 + 3524735529.59197*cos(theta)**7 - 109658438.698417*cos(theta)**5 + 1593872.65550024*cos(theta)**3 - 6860.28402654338*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl37_m3(theta, phi):
    return 6.57204404620968e-5*(1.0 - cos(theta)**2)**1.5*(592296469471526.0*cos(theta)**34 - 4.55175779963734e+15*cos(theta)**32 + 1.58990976663389e+16*cos(theta)**30 - 3.34111472698426e+16*cos(theta)**28 + 4.71246778656735e+16*cos(theta)**26 - 4.71246778656735e+16*cos(theta)**24 + 3.44084949495394e+16*cos(theta)**22 - 1.86144316940131e+16*cos(theta)**20 + 7.49309750394595e+15*cos(theta)**18 - 2.23478346608914e+15*cos(theta)**16 + 487589119873995.0*cos(theta)**14 - 76107392638994.1*cos(theta)**12 + 8207659990479.75*cos(theta)**10 - 579818994617.879*cos(theta)**8 + 24673148707.1438*cos(theta)**6 - 548292193.492084*cos(theta)**4 + 4781617.96650073*cos(theta)**2 - 6860.28402654338)*cos(3*phi)

@torch.jit.script
def Yl37_m4(theta, phi):
    return 1.76022862219379e-6*(1.0 - cos(theta)**2)**2*(2.01380799620319e+16*cos(theta)**33 - 1.45656249588395e+17*cos(theta)**31 + 4.76972929990167e+17*cos(theta)**29 - 9.35512123555592e+17*cos(theta)**27 + 1.22524162450751e+18*cos(theta)**25 - 1.13099226877616e+18*cos(theta)**23 + 7.56986888889866e+17*cos(theta)**21 - 3.72288633880262e+17*cos(theta)**19 + 1.34875755071027e+17*cos(theta)**17 - 3.57565354574263e+16*cos(theta)**15 + 6.82624767823593e+15*cos(theta)**13 - 913288711667929.0*cos(theta)**11 + 82076599904797.5*cos(theta)**9 - 4638551956943.03*cos(theta)**7 + 148038892242.863*cos(theta)**5 - 2193168773.96834*cos(theta)**3 + 9563235.93300147*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl37_m5(theta, phi):
    return 4.72810881899504e-8*(1.0 - cos(theta)**2)**2.5*(6.64556638747052e+17*cos(theta)**32 - 4.51534373724024e+18*cos(theta)**30 + 1.38322149697148e+19*cos(theta)**28 - 2.5258827336001e+19*cos(theta)**26 + 3.06310406126878e+19*cos(theta)**24 - 2.60128221818518e+19*cos(theta)**22 + 1.58967246666872e+19*cos(theta)**20 - 7.07348404372498e+18*cos(theta)**18 + 2.29288783620746e+18*cos(theta)**16 - 5.36348031861394e+17*cos(theta)**14 + 8.87412198170671e+16*cos(theta)**12 - 1.00461758283472e+16*cos(theta)**10 + 738689399143178.0*cos(theta)**8 - 32469863698601.2*cos(theta)**6 + 740194461214.314*cos(theta)**4 - 6579506321.90501*cos(theta)**2 + 9563235.93300147)*cos(5*phi)

@torch.jit.script
def Yl37_m6(theta, phi):
    return 1.27461271489967e-9*(1.0 - cos(theta)**2)**3*(2.12658124399057e+19*cos(theta)**31 - 1.35460312117207e+20*cos(theta)**29 + 3.87302019152015e+20*cos(theta)**27 - 6.56729510736026e+20*cos(theta)**25 + 7.35144974704506e+20*cos(theta)**23 - 5.72282088000739e+20*cos(theta)**21 + 3.17934493333744e+20*cos(theta)**19 - 1.2732271278705e+20*cos(theta)**17 + 3.66862053793194e+19*cos(theta)**15 - 7.50887244605952e+18*cos(theta)**13 + 1.06489463780481e+18*cos(theta)**11 - 1.00461758283472e+17*cos(theta)**9 + 5.90951519314542e+15*cos(theta)**7 - 194819182191607.0*cos(theta)**5 + 2960777844857.25*cos(theta)**3 - 13159012643.81*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl37_m7(theta, phi):
    return 3.45120741864491e-11*(1.0 - cos(theta)**2)**3.5*(6.59240185637075e+20*cos(theta)**30 - 3.92834905139901e+21*cos(theta)**28 + 1.04571545171044e+22*cos(theta)**26 - 1.64182377684006e+22*cos(theta)**24 + 1.69083344182036e+22*cos(theta)**22 - 1.20179238480155e+22*cos(theta)**20 + 6.04075537334113e+21*cos(theta)**18 - 2.16448611737984e+21*cos(theta)**16 + 5.50293080689791e+20*cos(theta)**14 - 9.76153417987738e+19*cos(theta)**12 + 1.17138410158529e+19*cos(theta)**10 - 9.0415582455125e+17*cos(theta)**8 + 4.1366606352018e+16*cos(theta)**6 - 974095910958037.0*cos(theta)**4 + 8882333534571.76*cos(theta)**2 - 13159012643.81)*cos(7*phi)

@torch.jit.script
def Yl37_m8(theta, phi):
    return 9.39299685798656e-13*(1.0 - cos(theta)**2)**4*(1.97772055691123e+22*cos(theta)**29 - 1.09993773439172e+23*cos(theta)**27 + 2.71886017444715e+23*cos(theta)**25 - 3.94037706441615e+23*cos(theta)**23 + 3.7198335720048e+23*cos(theta)**21 - 2.4035847696031e+23*cos(theta)**19 + 1.0873359672014e+23*cos(theta)**17 - 3.46317778780775e+22*cos(theta)**15 + 7.70410312965707e+21*cos(theta)**13 - 1.17138410158529e+21*cos(theta)**11 + 1.17138410158529e+20*cos(theta)**9 - 7.23324659641e+18*cos(theta)**7 + 2.48199638112108e+17*cos(theta)**5 - 3.89638364383215e+15*cos(theta)**3 + 17764667069143.5*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl37_m9(theta, phi):
    return 2.57173527737449e-14*(1.0 - cos(theta)**2)**4.5*(5.73538961504256e+23*cos(theta)**28 - 2.96983188285765e+24*cos(theta)**26 + 6.79715043611787e+24*cos(theta)**24 - 9.06286724815716e+24*cos(theta)**22 + 7.81165050121009e+24*cos(theta)**20 - 4.5668110622459e+24*cos(theta)**18 + 1.84847114424239e+24*cos(theta)**16 - 5.19476668171163e+23*cos(theta)**14 + 1.00153340685542e+23*cos(theta)**12 - 1.28852251174381e+22*cos(theta)**10 + 1.05424569142676e+21*cos(theta)**8 - 5.063272617487e+19*cos(theta)**6 + 1.24099819056054e+18*cos(theta)**4 - 1.16891509314964e+16*cos(theta)**2 + 17764667069143.5)*cos(9*phi)

@torch.jit.script
def Yl37_m10(theta, phi):
    return 7.08921777342186e-16*(1.0 - cos(theta)**2)**5*(1.60590909221192e+25*cos(theta)**27 - 7.7215628954299e+25*cos(theta)**25 + 1.63131610466829e+26*cos(theta)**23 - 1.99383079459457e+26*cos(theta)**21 + 1.56233010024202e+26*cos(theta)**19 - 8.22025991204261e+25*cos(theta)**17 + 2.95755383078782e+25*cos(theta)**15 - 7.27267335439627e+24*cos(theta)**13 + 1.2018400882265e+24*cos(theta)**11 - 1.28852251174381e+23*cos(theta)**9 + 8.43396553141406e+21*cos(theta)**7 - 3.0379635704922e+20*cos(theta)**5 + 4.96399276224215e+18*cos(theta)**3 - 2.33783018629929e+16*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl37_m11(theta, phi):
    return 1.96922715928385e-17*(1.0 - cos(theta)**2)**5.5*(4.33595454897217e+26*cos(theta)**26 - 1.93039072385747e+27*cos(theta)**24 + 3.75202704073706e+27*cos(theta)**22 - 4.18704466864861e+27*cos(theta)**20 + 2.96842719045983e+27*cos(theta)**18 - 1.39744418504724e+27*cos(theta)**16 + 4.43633074618173e+26*cos(theta)**14 - 9.45447536071516e+25*cos(theta)**12 + 1.32202409704915e+25*cos(theta)**10 - 1.15967026056943e+24*cos(theta)**8 + 5.90377587198984e+22*cos(theta)**6 - 1.5189817852461e+21*cos(theta)**4 + 1.48919782867265e+19*cos(theta)**2 - 2.33783018629929e+16)*cos(11*phi)

@torch.jit.script
def Yl37_m12(theta, phi):
    return 5.51710313839849e-19*(1.0 - cos(theta)**2)**6*(1.12734818273276e+28*cos(theta)**25 - 4.63293773725794e+28*cos(theta)**23 + 8.25445948962154e+28*cos(theta)**21 - 8.37408933729721e+28*cos(theta)**19 + 5.3431689428277e+28*cos(theta)**17 - 2.23591069607559e+28*cos(theta)**15 + 6.21086304465442e+27*cos(theta)**13 - 1.13453704328582e+27*cos(theta)**11 + 1.32202409704915e+26*cos(theta)**9 - 9.27736208455546e+24*cos(theta)**7 + 3.5422655231939e+23*cos(theta)**5 - 6.0759271409844e+21*cos(theta)**3 + 2.97839565734529e+19*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl37_m13(theta, phi):
    return 1.56047241666686e-20*(1.0 - cos(theta)**2)**6.5*(2.81837045683191e+29*cos(theta)**24 - 1.06557567956933e+30*cos(theta)**22 + 1.73343649282052e+30*cos(theta)**20 - 1.59107697408647e+30*cos(theta)**18 + 9.08338720280709e+29*cos(theta)**16 - 3.35386604411339e+29*cos(theta)**14 + 8.07412195805074e+28*cos(theta)**12 - 1.2479907476144e+28*cos(theta)**10 + 1.18982168734424e+27*cos(theta)**8 - 6.49415345918882e+25*cos(theta)**6 + 1.77113276159695e+24*cos(theta)**4 - 1.82277814229532e+22*cos(theta)**2 + 2.97839565734529e+19)*cos(13*phi)

@torch.jit.script
def Yl37_m14(theta, phi):
    return 4.4603135268713e-22*(1.0 - cos(theta)**2)**7*(6.76408909639659e+30*cos(theta)**23 - 2.34426649505252e+31*cos(theta)**21 + 3.46687298564105e+31*cos(theta)**19 - 2.86393855335565e+31*cos(theta)**17 + 1.45334195244913e+31*cos(theta)**15 - 4.69541246175874e+30*cos(theta)**13 + 9.68894634966089e+29*cos(theta)**11 - 1.2479907476144e+29*cos(theta)**9 + 9.5185734987539e+27*cos(theta)**7 - 3.89649207551329e+26*cos(theta)**5 + 7.08453104638781e+24*cos(theta)**3 - 3.64555628459064e+22*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl37_m15(theta, phi):
    return 1.28973295692034e-23*(1.0 - cos(theta)**2)**7.5*(1.55574049217122e+32*cos(theta)**22 - 4.92295963961028e+32*cos(theta)**20 + 6.58705867271799e+32*cos(theta)**18 - 4.8686955407046e+32*cos(theta)**16 + 2.1800129286737e+32*cos(theta)**14 - 6.10403620028636e+31*cos(theta)**12 + 1.0657840984627e+31*cos(theta)**10 - 1.12319167285296e+30*cos(theta)**8 + 6.66300144912773e+28*cos(theta)**6 - 1.94824603775665e+27*cos(theta)**4 + 2.12535931391634e+25*cos(theta)**2 - 3.64555628459064e+22)*cos(15*phi)

@torch.jit.script
def Yl37_m16(theta, phi):
    return 3.7770307660841e-25*(1.0 - cos(theta)**2)**8*(3.42262908277667e+33*cos(theta)**21 - 9.84591927922057e+33*cos(theta)**19 + 1.18567056108924e+34*cos(theta)**17 - 7.78991286512736e+33*cos(theta)**15 + 3.05201810014318e+33*cos(theta)**13 - 7.32484344034364e+32*cos(theta)**11 + 1.0657840984627e+32*cos(theta)**9 - 8.98553338282369e+30*cos(theta)**7 + 3.99780086947664e+29*cos(theta)**5 - 7.79298415102659e+27*cos(theta)**3 + 4.25071862783268e+25*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl37_m17(theta, phi):
    return 1.12161548142786e-26*(1.0 - cos(theta)**2)**8.5*(7.18752107383102e+34*cos(theta)**20 - 1.87072466305191e+35*cos(theta)**18 + 2.0156399538517e+35*cos(theta)**16 - 1.1684869297691e+35*cos(theta)**14 + 3.96762353018614e+34*cos(theta)**12 - 8.057327784378e+33*cos(theta)**10 + 9.59205688616428e+32*cos(theta)**8 - 6.28987336797658e+31*cos(theta)**6 + 1.99890043473832e+30*cos(theta)**4 - 2.33789524530798e+28*cos(theta)**2 + 4.25071862783268e+25)*cos(17*phi)

@torch.jit.script
def Yl37_m18(theta, phi):
    return 3.38179791904549e-28*(1.0 - cos(theta)**2)**9*(1.4375042147662e+36*cos(theta)**19 - 3.36730439349343e+36*cos(theta)**17 + 3.22502392616273e+36*cos(theta)**15 - 1.63588170167675e+36*cos(theta)**13 + 4.76114823622336e+35*cos(theta)**11 - 8.057327784378e+34*cos(theta)**9 + 7.67364550893143e+33*cos(theta)**7 - 3.77392402078595e+32*cos(theta)**5 + 7.99560173895328e+30*cos(theta)**3 - 4.67579049061595e+28*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl37_m19(theta, phi):
    return 1.03675667117759e-29*(1.0 - cos(theta)**2)**9.5*(2.73125800805579e+37*cos(theta)**18 - 5.72441746893884e+37*cos(theta)**16 + 4.83753588924409e+37*cos(theta)**14 - 2.12664621217977e+37*cos(theta)**12 + 5.2372630598457e+36*cos(theta)**10 - 7.2515950059402e+35*cos(theta)**8 + 5.371551856252e+34*cos(theta)**6 - 1.88696201039297e+33*cos(theta)**4 + 2.39868052168598e+31*cos(theta)**2 - 4.67579049061595e+28)*cos(19*phi)

@torch.jit.script
def Yl37_m20(theta, phi):
    return 3.236705294292e-31*(1.0 - cos(theta)**2)**10*(4.91626441450041e+38*cos(theta)**17 - 9.15906795030214e+38*cos(theta)**15 + 6.77255024494173e+38*cos(theta)**13 - 2.55197545461572e+38*cos(theta)**11 + 5.2372630598457e+37*cos(theta)**9 - 5.80127600475216e+36*cos(theta)**7 + 3.2229311137512e+35*cos(theta)**5 - 7.5478480415719e+33*cos(theta)**3 + 4.79736104337197e+31*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl37_m21(theta, phi):
    return 1.03077695553335e-32*(1.0 - cos(theta)**2)**10.5*(8.35764950465071e+39*cos(theta)**16 - 1.37386019254532e+40*cos(theta)**14 + 8.80431531842424e+39*cos(theta)**12 - 2.80717300007729e+39*cos(theta)**10 + 4.71353675386113e+38*cos(theta)**8 - 4.06089320332651e+37*cos(theta)**6 + 1.6114655568756e+36*cos(theta)**4 - 2.26435441247157e+34*cos(theta)**2 + 4.79736104337197e+31)*cos(21*phi)

@torch.jit.script
def Yl37_m22(theta, phi):
    return 3.3548932326254e-34*(1.0 - cos(theta)**2)**11*(1.33722392074411e+41*cos(theta)**15 - 1.92340426956345e+41*cos(theta)**13 + 1.05651783821091e+41*cos(theta)**11 - 2.80717300007729e+40*cos(theta)**9 + 3.7708294030889e+39*cos(theta)**7 - 2.43653592199591e+38*cos(theta)**5 + 6.4458622275024e+36*cos(theta)**3 - 4.52870882494314e+34*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl37_m23(theta, phi):
    return 1.11829774420847e-35*(1.0 - cos(theta)**2)**11.5*(2.00583588111617e+42*cos(theta)**14 - 2.50042555043248e+42*cos(theta)**12 + 1.162169622032e+42*cos(theta)**10 - 2.52645570006957e+41*cos(theta)**8 + 2.63958058216223e+40*cos(theta)**6 - 1.21826796099795e+39*cos(theta)**4 + 1.93375866825072e+37*cos(theta)**2 - 4.52870882494314e+34)*cos(23*phi)

@torch.jit.script
def Yl37_m24(theta, phi):
    return 3.82673610124151e-37*(1.0 - cos(theta)**2)**12*(2.80817023356264e+43*cos(theta)**13 - 3.00051066051898e+43*cos(theta)**11 + 1.162169622032e+43*cos(theta)**9 - 2.02116456005565e+42*cos(theta)**7 + 1.58374834929734e+41*cos(theta)**5 - 4.87307184399181e+39*cos(theta)**3 + 3.86751733650144e+37*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl37_m25(theta, phi):
    return 1.34791030198661e-38*(1.0 - cos(theta)**2)**12.5*(3.65062130363143e+44*cos(theta)**12 - 3.30056172657088e+44*cos(theta)**10 + 1.0459526598288e+44*cos(theta)**8 - 1.41481519203896e+43*cos(theta)**6 + 7.9187417464867e+41*cos(theta)**4 - 1.46192155319754e+40*cos(theta)**2 + 3.86751733650144e+37)*cos(25*phi)

@torch.jit.script
def Yl37_m26(theta, phi):
    return 4.90230237211461e-40*(1.0 - cos(theta)**2)**13*(4.38074556435771e+45*cos(theta)**11 - 3.30056172657088e+45*cos(theta)**9 + 8.3676212786304e+44*cos(theta)**7 - 8.48889115223374e+43*cos(theta)**5 + 3.16749669859468e+42*cos(theta)**3 - 2.92384310639509e+40*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl37_m27(theta, phi):
    return 1.84762472467879e-41*(1.0 - cos(theta)**2)**13.5*(4.81882012079349e+46*cos(theta)**10 - 2.97050555391379e+46*cos(theta)**8 + 5.85733489504128e+45*cos(theta)**6 - 4.24444557611687e+44*cos(theta)**4 + 9.50249009578404e+42*cos(theta)**2 - 2.92384310639509e+40)*cos(27*phi)

@torch.jit.script
def Yl37_m28(theta, phi):
    return 7.24698040379513e-43*(1.0 - cos(theta)**2)**14*(4.81882012079349e+47*cos(theta)**9 - 2.37640444313103e+47*cos(theta)**7 + 3.51440093702477e+46*cos(theta)**5 - 1.69777823044675e+45*cos(theta)**3 + 1.90049801915681e+43*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl37_m29(theta, phi):
    return 2.9734720766705e-44*(1.0 - cos(theta)**2)**14.5*(4.33693810871414e+48*cos(theta)**8 - 1.66348311019172e+48*cos(theta)**6 + 1.75720046851238e+47*cos(theta)**4 - 5.09333469134024e+45*cos(theta)**2 + 1.90049801915681e+43)*cos(29*phi)

@torch.jit.script
def Yl37_m30(theta, phi):
    return 1.28434432069174e-45*(1.0 - cos(theta)**2)**15*(3.46955048697131e+49*cos(theta)**7 - 9.98089866115034e+48*cos(theta)**5 + 7.02880187404954e+47*cos(theta)**3 - 1.01866693826805e+46*cos(theta))*cos(30*phi)

@torch.jit.script
def Yl37_m31(theta, phi):
    return 5.88678254222418e-47*(1.0 - cos(theta)**2)**15.5*(2.42868534087992e+50*cos(theta)**6 - 4.99044933057517e+49*cos(theta)**4 + 2.10864056221486e+48*cos(theta)**2 - 1.01866693826805e+46)*cos(31*phi)

@torch.jit.script
def Yl37_m32(theta, phi):
    return 2.89319577828011e-48*(1.0 - cos(theta)**2)**16*(1.45721120452795e+51*cos(theta)**5 - 1.99617973223007e+50*cos(theta)**3 + 4.21728112442972e+48*cos(theta))*cos(32*phi)

@torch.jit.script
def Yl37_m33(theta, phi):
    return 1.54647819359785e-49*(1.0 - cos(theta)**2)**16.5*(7.28605602263975e+51*cos(theta)**4 - 5.98853919669021e+50*cos(theta)**2 + 4.21728112442972e+48)*cos(33*phi)

@torch.jit.script
def Yl37_m34(theta, phi):
    return 9.17665977479345e-51*(1.0 - cos(theta)**2)**17*(2.9144224090559e+52*cos(theta)**3 - 1.19770783933804e+51*cos(theta))*cos(34*phi)

@torch.jit.script
def Yl37_m35(theta, phi):
    return 6.24392610871321e-52*(1.0 - cos(theta)**2)**17.5*(8.7432672271677e+52*cos(theta)**2 - 1.19770783933804e+51)*cos(35*phi)

@torch.jit.script
def Yl37_m36(theta, phi):
    return 9.03618419303727*(1.0 - cos(theta)**2)**18*cos(36*phi)*cos(theta)

@torch.jit.script
def Yl37_m37(theta, phi):
    return 1.05043507569481*(1.0 - cos(theta)**2)**18.5*cos(37*phi)

@torch.jit.script
def Yl38_m_minus_38(theta, phi):
    return 1.0573232483571*(1.0 - cos(theta)**2)**19*sin(38*phi)

@torch.jit.script
def Yl38_m_minus_37(theta, phi):
    return 9.21753038048947*(1.0 - cos(theta)**2)**18.5*sin(37*phi)*cos(theta)

@torch.jit.script
def Yl38_m_minus_36(theta, phi):
    return 8.60786001928606e-54*(1.0 - cos(theta)**2)**18*(6.55745042037577e+54*cos(theta)**2 - 8.7432672271677e+52)*sin(36*phi)

@torch.jit.script
def Yl38_m_minus_35(theta, phi):
    return 1.28254225711204e-52*(1.0 - cos(theta)**2)**17.5*(2.18581680679192e+54*cos(theta)**3 - 8.7432672271677e+52*cos(theta))*sin(35*phi)

@torch.jit.script
def Yl38_m_minus_34(theta, phi):
    return 2.19160916965865e-51*(1.0 - cos(theta)**2)**17*(5.46454201697981e+53*cos(theta)**4 - 4.37163361358385e+52*cos(theta)**2 + 2.9942695983451e+50)*sin(34*phi)

@torch.jit.script
def Yl38_m_minus_33(theta, phi):
    return 4.15828603021903e-50*(1.0 - cos(theta)**2)**16.5*(1.09290840339596e+53*cos(theta)**5 - 1.45721120452795e+52*cos(theta)**3 + 2.9942695983451e+50*cos(theta))*sin(33*phi)

@torch.jit.script
def Yl38_m_minus_32(theta, phi):
    return 8.58260566150099e-49*(1.0 - cos(theta)**2)**16*(1.82151400565994e+52*cos(theta)**6 - 3.64302801131987e+51*cos(theta)**4 + 1.49713479917255e+50*cos(theta)**2 - 7.02880187404954e+47)*sin(32*phi)

@torch.jit.script
def Yl38_m_minus_31(theta, phi):
    return 1.89984075045795e-47*(1.0 - cos(theta)**2)**15.5*(2.60216286522848e+51*cos(theta)**7 - 7.28605602263975e+50*cos(theta)**5 + 4.99044933057517e+49*cos(theta)**3 - 7.02880187404954e+47*cos(theta))*sin(31*phi)

@torch.jit.script
def Yl38_m_minus_30(theta, phi):
    return 4.46361509559185e-46*(1.0 - cos(theta)**2)**15*(3.2527035815356e+50*cos(theta)**8 - 1.21434267043996e+50*cos(theta)**6 + 1.24761233264379e+49*cos(theta)**4 - 3.51440093702477e+47*cos(theta)**2 + 1.27333367283506e+45)*sin(30*phi)

@torch.jit.script
def Yl38_m_minus_29(theta, phi):
    return 1.1042373906736e-44*(1.0 - cos(theta)**2)**14.5*(3.61411509059511e+49*cos(theta)**9 - 1.73477524348565e+49*cos(theta)**7 + 2.49522466528759e+48*cos(theta)**5 - 1.17146697900826e+47*cos(theta)**3 + 1.27333367283506e+45*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl38_m_minus_28(theta, phi):
    return 2.85824761702743e-43*(1.0 - cos(theta)**2)**14*(3.61411509059511e+48*cos(theta)**10 - 2.16846905435707e+48*cos(theta)**8 + 4.15870777547931e+47*cos(theta)**6 - 2.92866744752064e+46*cos(theta)**4 + 6.3666683641753e+44*cos(theta)**2 - 1.90049801915681e+42)*sin(28*phi)

@torch.jit.script
def Yl38_m_minus_27(theta, phi):
    return 7.70137304226747e-42*(1.0 - cos(theta)**2)**13.5*(3.28555917326829e+47*cos(theta)**11 - 2.40941006039674e+47*cos(theta)**9 + 5.94101110782758e+46*cos(theta)**7 - 5.85733489504128e+45*cos(theta)**5 + 2.12222278805844e+44*cos(theta)**3 - 1.90049801915681e+42*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl38_m_minus_26(theta, phi):
    return 2.15087643657668e-40*(1.0 - cos(theta)**2)**13*(2.73796597772357e+46*cos(theta)**12 - 2.40941006039674e+46*cos(theta)**10 + 7.42626388478448e+45*cos(theta)**8 - 9.7622248250688e+44*cos(theta)**6 + 5.30555697014609e+43*cos(theta)**4 - 9.50249009578404e+41*cos(theta)**2 + 2.43653592199591e+39)*sin(26*phi)

@torch.jit.script
def Yl38_m_minus_25(theta, phi):
    return 6.20407622341159e-39*(1.0 - cos(theta)**2)**12.5*(2.10612767517198e+45*cos(theta)**13 - 2.19037278217886e+45*cos(theta)**11 + 8.2514043164272e+44*cos(theta)**9 - 1.3946035464384e+44*cos(theta)**7 + 1.06111139402922e+43*cos(theta)**5 - 3.16749669859468e+41*cos(theta)**3 + 2.43653592199591e+39*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl38_m_minus_24(theta, phi):
    return 1.84251663480048e-37*(1.0 - cos(theta)**2)**12*(1.50437691083713e+44*cos(theta)**14 - 1.82531065181571e+44*cos(theta)**12 + 8.2514043164272e+43*cos(theta)**10 - 1.743254433048e+43*cos(theta)**8 + 1.7685189900487e+42*cos(theta)**6 - 7.9187417464867e+40*cos(theta)**4 + 1.21826796099795e+39*cos(theta)**2 - 2.76251238321531e+36)*sin(24*phi)

@torch.jit.script
def Yl38_m_minus_23(theta, phi):
    return 5.61892055563194e-36*(1.0 - cos(theta)**2)**11.5*(1.00291794055808e+43*cos(theta)**15 - 1.40408511678132e+43*cos(theta)**13 + 7.50127665129745e+42*cos(theta)**11 - 1.93694937005333e+42*cos(theta)**9 + 2.52645570006957e+41*cos(theta)**7 - 1.58374834929734e+40*cos(theta)**5 + 4.06089320332651e+38*cos(theta)**3 - 2.76251238321531e+36*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl38_m_minus_22(theta, phi):
    return 1.75540689794278e-34*(1.0 - cos(theta)**2)**11*(6.26823712848803e+41*cos(theta)**16 - 1.00291794055808e+42*cos(theta)**14 + 6.25106387608121e+41*cos(theta)**12 - 1.93694937005333e+41*cos(theta)**10 + 3.15806962508696e+40*cos(theta)**8 - 2.63958058216223e+39*cos(theta)**6 + 1.01522330083163e+38*cos(theta)**4 - 1.38125619160766e+36*cos(theta)**2 + 2.83044301558946e+33)*sin(22*phi)

@torch.jit.script
def Yl38_m_minus_21(theta, phi):
    return 5.60632004517403e-33*(1.0 - cos(theta)**2)**10.5*(3.68719831087531e+40*cos(theta)**17 - 6.68611960372056e+40*cos(theta)**15 + 4.80851067390862e+40*cos(theta)**13 - 1.76086306368485e+40*cos(theta)**11 + 3.50896625009662e+39*cos(theta)**9 - 3.7708294030889e+38*cos(theta)**7 + 2.03044660166326e+37*cos(theta)**5 - 4.60418730535886e+35*cos(theta)**3 + 2.83044301558946e+33*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl38_m_minus_20(theta, phi):
    return 1.82700672042423e-31*(1.0 - cos(theta)**2)**10*(2.04844350604184e+39*cos(theta)**18 - 4.17882475232535e+39*cos(theta)**16 + 3.4346504813633e+39*cos(theta)**14 - 1.46738588640404e+39*cos(theta)**12 + 3.50896625009662e+38*cos(theta)**10 - 4.71353675386113e+37*cos(theta)**8 + 3.38407766943876e+36*cos(theta)**6 - 1.15104682633971e+35*cos(theta)**4 + 1.41522150779473e+33*cos(theta)**2 - 2.66520057965109e+30)*sin(20*phi)

@torch.jit.script
def Yl38_m_minus_19(theta, phi):
    return 6.06500191198304e-30*(1.0 - cos(theta)**2)**9.5*(1.07812816107465e+38*cos(theta)**19 - 2.45813220725021e+38*cos(theta)**17 + 2.28976698757554e+38*cos(theta)**15 - 1.12875837415695e+38*cos(theta)**13 + 3.18996931826965e+37*cos(theta)**11 - 5.2372630598457e+36*cos(theta)**9 + 4.8343966706268e+35*cos(theta)**7 - 2.30209365267943e+34*cos(theta)**5 + 4.71740502598244e+32*cos(theta)**3 - 2.66520057965109e+30*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl38_m_minus_18(theta, phi):
    return 2.04778033341685e-28*(1.0 - cos(theta)**2)**9*(5.39064080537326e+36*cos(theta)**20 - 1.36562900402789e+37*cos(theta)**18 + 1.43110436723471e+37*cos(theta)**16 - 8.06255981540682e+36*cos(theta)**14 + 2.65830776522471e+36*cos(theta)**12 - 5.2372630598457e+35*cos(theta)**10 + 6.0429958382835e+34*cos(theta)**8 - 3.83682275446571e+33*cos(theta)**6 + 1.17935125649561e+32*cos(theta)**4 - 1.33260028982555e+30*cos(theta)**2 + 2.33789524530798e+27)*sin(18*phi)

@torch.jit.script
def Yl38_m_minus_17(theta, phi):
    return 7.02242369104875e-27*(1.0 - cos(theta)**2)**8.5*(2.56697181208251e+35*cos(theta)**21 - 7.18752107383102e+35*cos(theta)**19 + 8.41826098373359e+35*cos(theta)**17 - 5.37503987693788e+35*cos(theta)**15 + 2.04485212709593e+35*cos(theta)**13 - 4.76114823622336e+34*cos(theta)**11 + 6.714439820315e+33*cos(theta)**9 - 5.48117536352245e+32*cos(theta)**7 + 2.35870251299122e+31*cos(theta)**5 - 4.44200096608516e+29*cos(theta)**3 + 2.33789524530798e+27*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl38_m_minus_16(theta, phi):
    return 2.44275389142847e-25*(1.0 - cos(theta)**2)**8*(1.16680536912841e+34*cos(theta)**22 - 3.59376053691551e+34*cos(theta)**20 + 4.67681165762977e+34*cos(theta)**18 - 3.35939992308617e+34*cos(theta)**16 + 1.46060866221138e+34*cos(theta)**14 - 3.96762353018614e+33*cos(theta)**12 + 6.714439820315e+32*cos(theta)**10 - 6.85146920440306e+31*cos(theta)**8 + 3.93117085498536e+30*cos(theta)**6 - 1.11050024152129e+29*cos(theta)**4 + 1.16894762265399e+27*cos(theta)**2 - 1.93214483083304e+24)*sin(16*phi)

@torch.jit.script
def Yl38_m_minus_15(theta, phi):
    return 8.60875824089541e-24*(1.0 - cos(theta)**2)**7.5*(5.07306682229744e+32*cos(theta)**23 - 1.71131454138834e+33*cos(theta)**21 + 2.46147981980514e+33*cos(theta)**19 - 1.9761176018154e+33*cos(theta)**17 + 9.7373910814092e+32*cos(theta)**15 - 3.05201810014318e+32*cos(theta)**13 + 6.10403620028636e+31*cos(theta)**11 - 7.61274356044785e+30*cos(theta)**9 + 5.6159583642648e+29*cos(theta)**7 - 2.22100048304258e+28*cos(theta)**5 + 3.89649207551329e+26*cos(theta)**3 - 1.93214483083304e+24*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl38_m_minus_14(theta, phi):
    return 3.0703230101837e-22*(1.0 - cos(theta)**2)**7*(2.11377784262393e+31*cos(theta)**24 - 7.77870246085608e+31*cos(theta)**22 + 1.23073990990257e+32*cos(theta)**20 - 1.09784311211966e+32*cos(theta)**18 + 6.08586942588075e+31*cos(theta)**16 - 2.1800129286737e+31*cos(theta)**14 + 5.08669683357197e+30*cos(theta)**12 - 7.61274356044784e+29*cos(theta)**10 + 7.019947955331e+28*cos(theta)**8 - 3.70166747173763e+27*cos(theta)**6 + 9.74123018878324e+25*cos(theta)**4 - 9.66072415416519e+23*cos(theta)**2 + 1.5189817852461e+21)*sin(14*phi)

@torch.jit.script
def Yl38_m_minus_13(theta, phi):
    return 1.10702070454543e-20*(1.0 - cos(theta)**2)**6.5*(8.45511137049574e+29*cos(theta)**25 - 3.38204454819829e+30*cos(theta)**23 + 5.86066623763129e+30*cos(theta)**21 - 5.77812164273508e+30*cos(theta)**19 + 3.57992319169456e+30*cos(theta)**17 - 1.45334195244913e+30*cos(theta)**15 + 3.91284371813228e+29*cos(theta)**13 - 6.9206759640435e+28*cos(theta)**11 + 7.79994217259001e+27*cos(theta)**9 - 5.28809638819661e+26*cos(theta)**7 + 1.94824603775665e+25*cos(theta)**5 - 3.22024138472173e+23*cos(theta)**3 + 1.5189817852461e+21*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl38_m_minus_12(theta, phi):
    return 4.03113651248321e-19*(1.0 - cos(theta)**2)**6*(3.25196591172913e+28*cos(theta)**26 - 1.40918522841596e+29*cos(theta)**24 + 2.66393919892331e+29*cos(theta)**22 - 2.88906082136754e+29*cos(theta)**20 + 1.98884621760809e+29*cos(theta)**18 - 9.08338720280709e+28*cos(theta)**16 + 2.79488837009449e+28*cos(theta)**14 - 5.76722997003625e+27*cos(theta)**12 + 7.79994217259e+26*cos(theta)**10 - 6.61012048524577e+25*cos(theta)**8 + 3.24707672959441e+24*cos(theta)**6 - 8.05060346180433e+22*cos(theta)**4 + 7.5949089262305e+20*cos(theta)**2 - 1.14553679128665e+18)*sin(12*phi)

@torch.jit.script
def Yl38_m_minus_11(theta, phi):
    return 1.48113413086296e-17*(1.0 - cos(theta)**2)**5.5*(1.20443181915894e+27*cos(theta)**27 - 5.63674091366382e+27*cos(theta)**25 + 1.15823443431448e+28*cos(theta)**23 - 1.37574324827026e+28*cos(theta)**21 + 1.04676116716215e+28*cos(theta)**19 - 5.3431689428277e+27*cos(theta)**17 + 1.86325891339633e+27*cos(theta)**15 - 4.43633074618173e+26*cos(theta)**13 + 7.09085652053637e+25*cos(theta)**11 - 7.34457831693974e+24*cos(theta)**9 + 4.63868104227773e+23*cos(theta)**7 - 1.61012069236087e+22*cos(theta)**5 + 2.5316363087435e+20*cos(theta)**3 - 1.14553679128665e+18*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl38_m_minus_10(theta, phi):
    return 5.48619759603045e-16*(1.0 - cos(theta)**2)**5*(4.30154221128192e+25*cos(theta)**28 - 2.16797727448609e+26*cos(theta)**26 + 4.82597680964369e+26*cos(theta)**24 - 6.25337840122844e+26*cos(theta)**22 + 5.23380583581076e+26*cos(theta)**20 - 2.96842719045983e+26*cos(theta)**18 + 1.1645368208727e+26*cos(theta)**16 - 3.16880767584409e+25*cos(theta)**14 + 5.90904710044697e+24*cos(theta)**12 - 7.34457831693974e+23*cos(theta)**10 + 5.79835130284716e+22*cos(theta)**8 - 2.68353448726811e+21*cos(theta)**6 + 6.32909077185875e+19*cos(theta)**4 - 5.72768395643326e+17*cos(theta)**2 + 834939352249746.0)*sin(10*phi)

@torch.jit.script
def Yl38_m_minus_9(theta, phi):
    return 2.04687378153282e-14*(1.0 - cos(theta)**2)**4.5*(1.48329041768342e+24*cos(theta)**29 - 8.02954546105958e+24*cos(theta)**27 + 1.93039072385747e+25*cos(theta)**25 - 2.71886017444715e+25*cos(theta)**23 + 2.49228849324322e+25*cos(theta)**21 - 1.56233010024202e+25*cos(theta)**19 + 6.85021659336884e+24*cos(theta)**17 - 2.11253845056273e+24*cos(theta)**15 + 4.54542084649767e+23*cos(theta)**13 - 6.67688937903613e+22*cos(theta)**11 + 6.44261255871907e+21*cos(theta)**9 - 3.8336206960973e+20*cos(theta)**7 + 1.26581815437175e+19*cos(theta)**5 - 1.90922798547775e+17*cos(theta)**3 + 834939352249746.0*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl38_m_minus_8(theta, phi):
    return 7.68600423582523e-13*(1.0 - cos(theta)**2)**4*(4.94430139227807e+22*cos(theta)**30 - 2.86769480752128e+23*cos(theta)**28 + 7.42457970714413e+23*cos(theta)**26 - 1.13285840601964e+24*cos(theta)**24 + 1.13285840601964e+24*cos(theta)**22 - 7.81165050121009e+23*cos(theta)**20 + 3.80567588520491e+23*cos(theta)**18 - 1.3203365316017e+23*cos(theta)**16 + 3.24672917606977e+22*cos(theta)**14 - 5.56407448253011e+21*cos(theta)**12 + 6.44261255871907e+20*cos(theta)**10 - 4.79202587012162e+19*cos(theta)**8 + 2.10969692395292e+18*cos(theta)**6 - 4.77306996369438e+16*cos(theta)**4 + 417469676124873.0*cos(theta)**2 - 592155568971.451)*sin(8*phi)

@torch.jit.script
def Yl38_m_minus_7(theta, phi):
    return 2.90242083005401e-11*(1.0 - cos(theta)**2)**3.5*(1.59493593299292e+21*cos(theta)**31 - 9.88860278455613e+21*cos(theta)**29 + 2.74984433597931e+22*cos(theta)**27 - 4.53143362407858e+22*cos(theta)**25 + 4.92547133052019e+22*cos(theta)**23 - 3.7198335720048e+22*cos(theta)**21 + 2.00298730800259e+22*cos(theta)**19 - 7.76668548001003e+21*cos(theta)**17 + 2.16448611737984e+21*cos(theta)**15 - 4.28005729425393e+20*cos(theta)**13 + 5.85692050792643e+19*cos(theta)**11 - 5.32447318902403e+18*cos(theta)**9 + 3.01385274850417e+17*cos(theta)**7 - 9.54613992738876e+15*cos(theta)**5 + 139156558708291.0*cos(theta)**3 - 592155568971.451*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl38_m_minus_6(theta, phi):
    return 1.10139126615446e-9*(1.0 - cos(theta)**2)**3*(4.98417479060289e+19*cos(theta)**32 - 3.29620092818538e+20*cos(theta)**30 + 9.82087262849753e+20*cos(theta)**28 - 1.74285908618407e+21*cos(theta)**26 + 2.05227972105008e+21*cos(theta)**24 - 1.69083344182036e+21*cos(theta)**22 + 1.00149365400129e+21*cos(theta)**20 - 4.31482526667224e+20*cos(theta)**18 + 1.3528038233624e+20*cos(theta)**16 - 3.05718378160995e+19*cos(theta)**14 + 4.88076708993869e+18*cos(theta)**12 - 5.32447318902403e+17*cos(theta)**10 + 3.76731593563021e+16*cos(theta)**8 - 1.59102332123146e+15*cos(theta)**6 + 34789139677072.7*cos(theta)**4 - 296077784485.725*cos(theta)**2 + 411219145.119063)*sin(6*phi)

@torch.jit.script
def Yl38_m_minus_5(theta, phi):
    return 4.1968643903827e-8*(1.0 - cos(theta)**2)**2.5*(1.51035599715239e+18*cos(theta)**33 - 1.06329062199528e+19*cos(theta)**31 + 3.38650780293018e+19*cos(theta)**29 - 6.45503365253359e+19*cos(theta)**27 + 8.20911888420032e+19*cos(theta)**25 - 7.35144974704506e+19*cos(theta)**23 + 4.76901740000616e+19*cos(theta)**21 - 2.2709606666696e+19*cos(theta)**19 + 7.9576695491906e+18*cos(theta)**17 - 2.0381225210733e+18*cos(theta)**15 + 3.75443622302976e+17*cos(theta)**13 - 4.84043017184002e+16*cos(theta)**11 + 4.18590659514467e+15*cos(theta)**9 - 227289045890209.0*cos(theta)**7 + 6957827935414.55*cos(theta)**5 - 98692594828.5751*cos(theta)**3 + 411219145.119063*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl38_m_minus_4(theta, phi):
    return 1.60471762562345e-6*(1.0 - cos(theta)**2)**2*(4.44222352103644e+16*cos(theta)**34 - 3.32278319373526e+17*cos(theta)**32 + 1.12883593431006e+18*cos(theta)**30 - 2.30536916161914e+18*cos(theta)**28 + 3.15735341700012e+18*cos(theta)**26 - 3.06310406126878e+18*cos(theta)**24 + 2.16773518182098e+18*cos(theta)**22 - 1.1354803333348e+18*cos(theta)**20 + 4.42092752732811e+17*cos(theta)**18 - 1.27382657567081e+17*cos(theta)**16 + 2.68174015930697e+16*cos(theta)**14 - 4.03369180986669e+15*cos(theta)**12 + 418590659514467.0*cos(theta)**10 - 28411130736276.1*cos(theta)**8 + 1159637989235.76*cos(theta)**6 - 24673148707.1438*cos(theta)**4 + 205609572.559532*cos(theta)**2 - 281271.645088278)*sin(4*phi)

@torch.jit.script
def Yl38_m_minus_3(theta, phi):
    return 6.15258029386065e-5*(1.0 - cos(theta)**2)**1.5*(1.26920672029613e+15*cos(theta)**35 - 1.00690399810159e+16*cos(theta)**33 + 3.64140623970987e+16*cos(theta)**31 - 7.94954883316944e+16*cos(theta)**29 + 1.16939015444449e+17*cos(theta)**27 - 1.22524162450751e+17*cos(theta)**25 + 9.4249355731347e+16*cos(theta)**23 - 5.40704920635619e+16*cos(theta)**21 + 2.32680396175164e+16*cos(theta)**19 - 7.49309750394595e+15*cos(theta)**17 + 1.78782677287132e+15*cos(theta)**15 - 310283985374361.0*cos(theta)**13 + 38053696319497.0*cos(theta)**11 - 3156792304030.67*cos(theta)**9 + 165662569890.823*cos(theta)**7 - 4934629741.42876*cos(theta)**5 + 68536524.1865105*cos(theta)**3 - 281271.645088278*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl38_m_minus_2(theta, phi):
    return 0.00236374416014225*(1.0 - cos(theta)**2)*(35255742230448.0*cos(theta)**36 - 296148234735763.0*cos(theta)**34 + 1.13793944990934e+15*cos(theta)**32 - 2.64984961105648e+15*cos(theta)**30 + 4.17639340873032e+15*cos(theta)**28 - 4.71246778656735e+15*cos(theta)**26 + 3.92705648880612e+15*cos(theta)**24 - 2.45774963925281e+15*cos(theta)**22 + 1.16340198087582e+15*cos(theta)**20 - 416283194663664.0*cos(theta)**18 + 111739173304457.0*cos(theta)**16 - 22163141812454.3*cos(theta)**14 + 3171141359958.09*cos(theta)**12 - 315679230403.067*cos(theta)**10 + 20707821236.3528*cos(theta)**8 - 822438290.238126*cos(theta)**6 + 17134131.0466276*cos(theta)**4 - 140635.822544139*cos(theta)**2 + 190.56344518176)*sin(2*phi)

@torch.jit.script
def Yl38_m_minus_1(theta, phi):
    return 0.090935053487738*(1.0 - cos(theta)**2)**0.5*(952857898120.215*cos(theta)**37 - 8461378135307.51*cos(theta)**35 + 34483013633616.2*cos(theta)**33 - 85479019711499.4*cos(theta)**31 + 144013565818287.0*cos(theta)**29 - 174535843946939.0*cos(theta)**27 + 157082259552245.0*cos(theta)**25 - 106858679967514.0*cos(theta)**23 + 55400094327420.0*cos(theta)**21 - 21909641824403.4*cos(theta)**19 + 6572892547321.01*cos(theta)**17 - 1477542787496.95*cos(theta)**15 + 243933950766.007*cos(theta)**13 - 28698111854.8243*cos(theta)**11 + 2300869026.26142*cos(theta)**9 - 117491184.319732*cos(theta)**7 + 3426826.20932553*cos(theta)**5 - 46878.6075147131*cos(theta)**3 + 190.56344518176*cos(theta))*sin(phi)

@torch.jit.script
def Yl38_m0(theta, phi):
    return 62070461167.7979*cos(theta)**38 - 581807122679.493*cos(theta)**36 + 2510537584164.93*cos(theta)**34 - 6612260961110.46*cos(theta)**32 + 11882903756198.5*cos(theta)**30 - 15430039205810.0*cos(theta)**28 + 14955268768708.2*cos(theta)**26 - 11021456575578.6*cos(theta)**24 + 6233446751761.65*cos(theta)**22 - 2711725423082.75*cos(theta)**20 + 903908474360.917*cos(theta)**18 - 228591729879.703*cos(theta)**16 + 43130515071.6421*cos(theta)**14 - 5919874617.67636*cos(theta)**12 + 569550619.193353*cos(theta)**10 - 36354294.8421289*cos(theta)**8 + 1413778.13274946*cos(theta)**6 - 29010.4952000573*cos(theta)**4 + 235.857684553311*cos(theta)**2 - 0.318296470382336

@torch.jit.script
def Yl38_m1(theta, phi):
    return 0.090935053487738*(1.0 - cos(theta)**2)**0.5*(952857898120.215*cos(theta)**37 - 8461378135307.51*cos(theta)**35 + 34483013633616.2*cos(theta)**33 - 85479019711499.4*cos(theta)**31 + 144013565818287.0*cos(theta)**29 - 174535843946939.0*cos(theta)**27 + 157082259552245.0*cos(theta)**25 - 106858679967514.0*cos(theta)**23 + 55400094327420.0*cos(theta)**21 - 21909641824403.4*cos(theta)**19 + 6572892547321.01*cos(theta)**17 - 1477542787496.95*cos(theta)**15 + 243933950766.007*cos(theta)**13 - 28698111854.8243*cos(theta)**11 + 2300869026.26142*cos(theta)**9 - 117491184.319732*cos(theta)**7 + 3426826.20932553*cos(theta)**5 - 46878.6075147131*cos(theta)**3 + 190.56344518176*cos(theta))*cos(phi)

@torch.jit.script
def Yl38_m2(theta, phi):
    return 0.00236374416014225*(1.0 - cos(theta)**2)*(35255742230448.0*cos(theta)**36 - 296148234735763.0*cos(theta)**34 + 1.13793944990934e+15*cos(theta)**32 - 2.64984961105648e+15*cos(theta)**30 + 4.17639340873032e+15*cos(theta)**28 - 4.71246778656735e+15*cos(theta)**26 + 3.92705648880612e+15*cos(theta)**24 - 2.45774963925281e+15*cos(theta)**22 + 1.16340198087582e+15*cos(theta)**20 - 416283194663664.0*cos(theta)**18 + 111739173304457.0*cos(theta)**16 - 22163141812454.3*cos(theta)**14 + 3171141359958.09*cos(theta)**12 - 315679230403.067*cos(theta)**10 + 20707821236.3528*cos(theta)**8 - 822438290.238126*cos(theta)**6 + 17134131.0466276*cos(theta)**4 - 140635.822544139*cos(theta)**2 + 190.56344518176)*cos(2*phi)

@torch.jit.script
def Yl38_m3(theta, phi):
    return 6.15258029386065e-5*(1.0 - cos(theta)**2)**1.5*(1.26920672029613e+15*cos(theta)**35 - 1.00690399810159e+16*cos(theta)**33 + 3.64140623970987e+16*cos(theta)**31 - 7.94954883316944e+16*cos(theta)**29 + 1.16939015444449e+17*cos(theta)**27 - 1.22524162450751e+17*cos(theta)**25 + 9.4249355731347e+16*cos(theta)**23 - 5.40704920635619e+16*cos(theta)**21 + 2.32680396175164e+16*cos(theta)**19 - 7.49309750394595e+15*cos(theta)**17 + 1.78782677287132e+15*cos(theta)**15 - 310283985374361.0*cos(theta)**13 + 38053696319497.0*cos(theta)**11 - 3156792304030.67*cos(theta)**9 + 165662569890.823*cos(theta)**7 - 4934629741.42876*cos(theta)**5 + 68536524.1865105*cos(theta)**3 - 281271.645088278*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl38_m4(theta, phi):
    return 1.60471762562345e-6*(1.0 - cos(theta)**2)**2*(4.44222352103644e+16*cos(theta)**34 - 3.32278319373526e+17*cos(theta)**32 + 1.12883593431006e+18*cos(theta)**30 - 2.30536916161914e+18*cos(theta)**28 + 3.15735341700012e+18*cos(theta)**26 - 3.06310406126878e+18*cos(theta)**24 + 2.16773518182098e+18*cos(theta)**22 - 1.1354803333348e+18*cos(theta)**20 + 4.42092752732811e+17*cos(theta)**18 - 1.27382657567081e+17*cos(theta)**16 + 2.68174015930697e+16*cos(theta)**14 - 4.03369180986669e+15*cos(theta)**12 + 418590659514467.0*cos(theta)**10 - 28411130736276.1*cos(theta)**8 + 1159637989235.76*cos(theta)**6 - 24673148707.1438*cos(theta)**4 + 205609572.559532*cos(theta)**2 - 281271.645088278)*cos(4*phi)

@torch.jit.script
def Yl38_m5(theta, phi):
    return 4.1968643903827e-8*(1.0 - cos(theta)**2)**2.5*(1.51035599715239e+18*cos(theta)**33 - 1.06329062199528e+19*cos(theta)**31 + 3.38650780293018e+19*cos(theta)**29 - 6.45503365253359e+19*cos(theta)**27 + 8.20911888420032e+19*cos(theta)**25 - 7.35144974704506e+19*cos(theta)**23 + 4.76901740000616e+19*cos(theta)**21 - 2.2709606666696e+19*cos(theta)**19 + 7.9576695491906e+18*cos(theta)**17 - 2.0381225210733e+18*cos(theta)**15 + 3.75443622302976e+17*cos(theta)**13 - 4.84043017184002e+16*cos(theta)**11 + 4.18590659514467e+15*cos(theta)**9 - 227289045890209.0*cos(theta)**7 + 6957827935414.55*cos(theta)**5 - 98692594828.5751*cos(theta)**3 + 411219145.119063*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl38_m6(theta, phi):
    return 1.10139126615446e-9*(1.0 - cos(theta)**2)**3*(4.98417479060289e+19*cos(theta)**32 - 3.29620092818538e+20*cos(theta)**30 + 9.82087262849753e+20*cos(theta)**28 - 1.74285908618407e+21*cos(theta)**26 + 2.05227972105008e+21*cos(theta)**24 - 1.69083344182036e+21*cos(theta)**22 + 1.00149365400129e+21*cos(theta)**20 - 4.31482526667224e+20*cos(theta)**18 + 1.3528038233624e+20*cos(theta)**16 - 3.05718378160995e+19*cos(theta)**14 + 4.88076708993869e+18*cos(theta)**12 - 5.32447318902403e+17*cos(theta)**10 + 3.76731593563021e+16*cos(theta)**8 - 1.59102332123146e+15*cos(theta)**6 + 34789139677072.7*cos(theta)**4 - 296077784485.725*cos(theta)**2 + 411219145.119063)*cos(6*phi)

@torch.jit.script
def Yl38_m7(theta, phi):
    return 2.90242083005401e-11*(1.0 - cos(theta)**2)**3.5*(1.59493593299292e+21*cos(theta)**31 - 9.88860278455613e+21*cos(theta)**29 + 2.74984433597931e+22*cos(theta)**27 - 4.53143362407858e+22*cos(theta)**25 + 4.92547133052019e+22*cos(theta)**23 - 3.7198335720048e+22*cos(theta)**21 + 2.00298730800259e+22*cos(theta)**19 - 7.76668548001003e+21*cos(theta)**17 + 2.16448611737984e+21*cos(theta)**15 - 4.28005729425393e+20*cos(theta)**13 + 5.85692050792643e+19*cos(theta)**11 - 5.32447318902403e+18*cos(theta)**9 + 3.01385274850417e+17*cos(theta)**7 - 9.54613992738876e+15*cos(theta)**5 + 139156558708291.0*cos(theta)**3 - 592155568971.451*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl38_m8(theta, phi):
    return 7.68600423582523e-13*(1.0 - cos(theta)**2)**4*(4.94430139227807e+22*cos(theta)**30 - 2.86769480752128e+23*cos(theta)**28 + 7.42457970714413e+23*cos(theta)**26 - 1.13285840601964e+24*cos(theta)**24 + 1.13285840601964e+24*cos(theta)**22 - 7.81165050121009e+23*cos(theta)**20 + 3.80567588520491e+23*cos(theta)**18 - 1.3203365316017e+23*cos(theta)**16 + 3.24672917606977e+22*cos(theta)**14 - 5.56407448253011e+21*cos(theta)**12 + 6.44261255871907e+20*cos(theta)**10 - 4.79202587012162e+19*cos(theta)**8 + 2.10969692395292e+18*cos(theta)**6 - 4.77306996369438e+16*cos(theta)**4 + 417469676124873.0*cos(theta)**2 - 592155568971.451)*cos(8*phi)

@torch.jit.script
def Yl38_m9(theta, phi):
    return 2.04687378153282e-14*(1.0 - cos(theta)**2)**4.5*(1.48329041768342e+24*cos(theta)**29 - 8.02954546105958e+24*cos(theta)**27 + 1.93039072385747e+25*cos(theta)**25 - 2.71886017444715e+25*cos(theta)**23 + 2.49228849324322e+25*cos(theta)**21 - 1.56233010024202e+25*cos(theta)**19 + 6.85021659336884e+24*cos(theta)**17 - 2.11253845056273e+24*cos(theta)**15 + 4.54542084649767e+23*cos(theta)**13 - 6.67688937903613e+22*cos(theta)**11 + 6.44261255871907e+21*cos(theta)**9 - 3.8336206960973e+20*cos(theta)**7 + 1.26581815437175e+19*cos(theta)**5 - 1.90922798547775e+17*cos(theta)**3 + 834939352249746.0*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl38_m10(theta, phi):
    return 5.48619759603045e-16*(1.0 - cos(theta)**2)**5*(4.30154221128192e+25*cos(theta)**28 - 2.16797727448609e+26*cos(theta)**26 + 4.82597680964369e+26*cos(theta)**24 - 6.25337840122844e+26*cos(theta)**22 + 5.23380583581076e+26*cos(theta)**20 - 2.96842719045983e+26*cos(theta)**18 + 1.1645368208727e+26*cos(theta)**16 - 3.16880767584409e+25*cos(theta)**14 + 5.90904710044697e+24*cos(theta)**12 - 7.34457831693974e+23*cos(theta)**10 + 5.79835130284716e+22*cos(theta)**8 - 2.68353448726811e+21*cos(theta)**6 + 6.32909077185875e+19*cos(theta)**4 - 5.72768395643326e+17*cos(theta)**2 + 834939352249746.0)*cos(10*phi)

@torch.jit.script
def Yl38_m11(theta, phi):
    return 1.48113413086296e-17*(1.0 - cos(theta)**2)**5.5*(1.20443181915894e+27*cos(theta)**27 - 5.63674091366382e+27*cos(theta)**25 + 1.15823443431448e+28*cos(theta)**23 - 1.37574324827026e+28*cos(theta)**21 + 1.04676116716215e+28*cos(theta)**19 - 5.3431689428277e+27*cos(theta)**17 + 1.86325891339633e+27*cos(theta)**15 - 4.43633074618173e+26*cos(theta)**13 + 7.09085652053637e+25*cos(theta)**11 - 7.34457831693974e+24*cos(theta)**9 + 4.63868104227773e+23*cos(theta)**7 - 1.61012069236087e+22*cos(theta)**5 + 2.5316363087435e+20*cos(theta)**3 - 1.14553679128665e+18*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl38_m12(theta, phi):
    return 4.03113651248321e-19*(1.0 - cos(theta)**2)**6*(3.25196591172913e+28*cos(theta)**26 - 1.40918522841596e+29*cos(theta)**24 + 2.66393919892331e+29*cos(theta)**22 - 2.88906082136754e+29*cos(theta)**20 + 1.98884621760809e+29*cos(theta)**18 - 9.08338720280709e+28*cos(theta)**16 + 2.79488837009449e+28*cos(theta)**14 - 5.76722997003625e+27*cos(theta)**12 + 7.79994217259e+26*cos(theta)**10 - 6.61012048524577e+25*cos(theta)**8 + 3.24707672959441e+24*cos(theta)**6 - 8.05060346180433e+22*cos(theta)**4 + 7.5949089262305e+20*cos(theta)**2 - 1.14553679128665e+18)*cos(12*phi)

@torch.jit.script
def Yl38_m13(theta, phi):
    return 1.10702070454543e-20*(1.0 - cos(theta)**2)**6.5*(8.45511137049574e+29*cos(theta)**25 - 3.38204454819829e+30*cos(theta)**23 + 5.86066623763129e+30*cos(theta)**21 - 5.77812164273508e+30*cos(theta)**19 + 3.57992319169456e+30*cos(theta)**17 - 1.45334195244913e+30*cos(theta)**15 + 3.91284371813228e+29*cos(theta)**13 - 6.9206759640435e+28*cos(theta)**11 + 7.79994217259001e+27*cos(theta)**9 - 5.28809638819661e+26*cos(theta)**7 + 1.94824603775665e+25*cos(theta)**5 - 3.22024138472173e+23*cos(theta)**3 + 1.5189817852461e+21*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl38_m14(theta, phi):
    return 3.0703230101837e-22*(1.0 - cos(theta)**2)**7*(2.11377784262393e+31*cos(theta)**24 - 7.77870246085608e+31*cos(theta)**22 + 1.23073990990257e+32*cos(theta)**20 - 1.09784311211966e+32*cos(theta)**18 + 6.08586942588075e+31*cos(theta)**16 - 2.1800129286737e+31*cos(theta)**14 + 5.08669683357197e+30*cos(theta)**12 - 7.61274356044784e+29*cos(theta)**10 + 7.019947955331e+28*cos(theta)**8 - 3.70166747173763e+27*cos(theta)**6 + 9.74123018878324e+25*cos(theta)**4 - 9.66072415416519e+23*cos(theta)**2 + 1.5189817852461e+21)*cos(14*phi)

@torch.jit.script
def Yl38_m15(theta, phi):
    return 8.60875824089541e-24*(1.0 - cos(theta)**2)**7.5*(5.07306682229744e+32*cos(theta)**23 - 1.71131454138834e+33*cos(theta)**21 + 2.46147981980514e+33*cos(theta)**19 - 1.9761176018154e+33*cos(theta)**17 + 9.7373910814092e+32*cos(theta)**15 - 3.05201810014318e+32*cos(theta)**13 + 6.10403620028636e+31*cos(theta)**11 - 7.61274356044785e+30*cos(theta)**9 + 5.6159583642648e+29*cos(theta)**7 - 2.22100048304258e+28*cos(theta)**5 + 3.89649207551329e+26*cos(theta)**3 - 1.93214483083304e+24*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl38_m16(theta, phi):
    return 2.44275389142847e-25*(1.0 - cos(theta)**2)**8*(1.16680536912841e+34*cos(theta)**22 - 3.59376053691551e+34*cos(theta)**20 + 4.67681165762977e+34*cos(theta)**18 - 3.35939992308617e+34*cos(theta)**16 + 1.46060866221138e+34*cos(theta)**14 - 3.96762353018614e+33*cos(theta)**12 + 6.714439820315e+32*cos(theta)**10 - 6.85146920440306e+31*cos(theta)**8 + 3.93117085498536e+30*cos(theta)**6 - 1.11050024152129e+29*cos(theta)**4 + 1.16894762265399e+27*cos(theta)**2 - 1.93214483083304e+24)*cos(16*phi)

@torch.jit.script
def Yl38_m17(theta, phi):
    return 7.02242369104875e-27*(1.0 - cos(theta)**2)**8.5*(2.56697181208251e+35*cos(theta)**21 - 7.18752107383102e+35*cos(theta)**19 + 8.41826098373359e+35*cos(theta)**17 - 5.37503987693788e+35*cos(theta)**15 + 2.04485212709593e+35*cos(theta)**13 - 4.76114823622336e+34*cos(theta)**11 + 6.714439820315e+33*cos(theta)**9 - 5.48117536352245e+32*cos(theta)**7 + 2.35870251299122e+31*cos(theta)**5 - 4.44200096608516e+29*cos(theta)**3 + 2.33789524530798e+27*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl38_m18(theta, phi):
    return 2.04778033341685e-28*(1.0 - cos(theta)**2)**9*(5.39064080537326e+36*cos(theta)**20 - 1.36562900402789e+37*cos(theta)**18 + 1.43110436723471e+37*cos(theta)**16 - 8.06255981540682e+36*cos(theta)**14 + 2.65830776522471e+36*cos(theta)**12 - 5.2372630598457e+35*cos(theta)**10 + 6.0429958382835e+34*cos(theta)**8 - 3.83682275446571e+33*cos(theta)**6 + 1.17935125649561e+32*cos(theta)**4 - 1.33260028982555e+30*cos(theta)**2 + 2.33789524530798e+27)*cos(18*phi)

@torch.jit.script
def Yl38_m19(theta, phi):
    return 6.06500191198304e-30*(1.0 - cos(theta)**2)**9.5*(1.07812816107465e+38*cos(theta)**19 - 2.45813220725021e+38*cos(theta)**17 + 2.28976698757554e+38*cos(theta)**15 - 1.12875837415695e+38*cos(theta)**13 + 3.18996931826965e+37*cos(theta)**11 - 5.2372630598457e+36*cos(theta)**9 + 4.8343966706268e+35*cos(theta)**7 - 2.30209365267943e+34*cos(theta)**5 + 4.71740502598244e+32*cos(theta)**3 - 2.66520057965109e+30*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl38_m20(theta, phi):
    return 1.82700672042423e-31*(1.0 - cos(theta)**2)**10*(2.04844350604184e+39*cos(theta)**18 - 4.17882475232535e+39*cos(theta)**16 + 3.4346504813633e+39*cos(theta)**14 - 1.46738588640404e+39*cos(theta)**12 + 3.50896625009662e+38*cos(theta)**10 - 4.71353675386113e+37*cos(theta)**8 + 3.38407766943876e+36*cos(theta)**6 - 1.15104682633971e+35*cos(theta)**4 + 1.41522150779473e+33*cos(theta)**2 - 2.66520057965109e+30)*cos(20*phi)

@torch.jit.script
def Yl38_m21(theta, phi):
    return 5.60632004517403e-33*(1.0 - cos(theta)**2)**10.5*(3.68719831087531e+40*cos(theta)**17 - 6.68611960372056e+40*cos(theta)**15 + 4.80851067390862e+40*cos(theta)**13 - 1.76086306368485e+40*cos(theta)**11 + 3.50896625009662e+39*cos(theta)**9 - 3.7708294030889e+38*cos(theta)**7 + 2.03044660166326e+37*cos(theta)**5 - 4.60418730535886e+35*cos(theta)**3 + 2.83044301558946e+33*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl38_m22(theta, phi):
    return 1.75540689794278e-34*(1.0 - cos(theta)**2)**11*(6.26823712848803e+41*cos(theta)**16 - 1.00291794055808e+42*cos(theta)**14 + 6.25106387608121e+41*cos(theta)**12 - 1.93694937005333e+41*cos(theta)**10 + 3.15806962508696e+40*cos(theta)**8 - 2.63958058216223e+39*cos(theta)**6 + 1.01522330083163e+38*cos(theta)**4 - 1.38125619160766e+36*cos(theta)**2 + 2.83044301558946e+33)*cos(22*phi)

@torch.jit.script
def Yl38_m23(theta, phi):
    return 5.61892055563194e-36*(1.0 - cos(theta)**2)**11.5*(1.00291794055808e+43*cos(theta)**15 - 1.40408511678132e+43*cos(theta)**13 + 7.50127665129745e+42*cos(theta)**11 - 1.93694937005333e+42*cos(theta)**9 + 2.52645570006957e+41*cos(theta)**7 - 1.58374834929734e+40*cos(theta)**5 + 4.06089320332651e+38*cos(theta)**3 - 2.76251238321531e+36*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl38_m24(theta, phi):
    return 1.84251663480048e-37*(1.0 - cos(theta)**2)**12*(1.50437691083713e+44*cos(theta)**14 - 1.82531065181571e+44*cos(theta)**12 + 8.2514043164272e+43*cos(theta)**10 - 1.743254433048e+43*cos(theta)**8 + 1.7685189900487e+42*cos(theta)**6 - 7.9187417464867e+40*cos(theta)**4 + 1.21826796099795e+39*cos(theta)**2 - 2.76251238321531e+36)*cos(24*phi)

@torch.jit.script
def Yl38_m25(theta, phi):
    return 6.20407622341159e-39*(1.0 - cos(theta)**2)**12.5*(2.10612767517198e+45*cos(theta)**13 - 2.19037278217886e+45*cos(theta)**11 + 8.2514043164272e+44*cos(theta)**9 - 1.3946035464384e+44*cos(theta)**7 + 1.06111139402922e+43*cos(theta)**5 - 3.16749669859468e+41*cos(theta)**3 + 2.43653592199591e+39*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl38_m26(theta, phi):
    return 2.15087643657668e-40*(1.0 - cos(theta)**2)**13*(2.73796597772357e+46*cos(theta)**12 - 2.40941006039674e+46*cos(theta)**10 + 7.42626388478448e+45*cos(theta)**8 - 9.7622248250688e+44*cos(theta)**6 + 5.30555697014609e+43*cos(theta)**4 - 9.50249009578404e+41*cos(theta)**2 + 2.43653592199591e+39)*cos(26*phi)

@torch.jit.script
def Yl38_m27(theta, phi):
    return 7.70137304226747e-42*(1.0 - cos(theta)**2)**13.5*(3.28555917326829e+47*cos(theta)**11 - 2.40941006039674e+47*cos(theta)**9 + 5.94101110782758e+46*cos(theta)**7 - 5.85733489504128e+45*cos(theta)**5 + 2.12222278805844e+44*cos(theta)**3 - 1.90049801915681e+42*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl38_m28(theta, phi):
    return 2.85824761702743e-43*(1.0 - cos(theta)**2)**14*(3.61411509059511e+48*cos(theta)**10 - 2.16846905435707e+48*cos(theta)**8 + 4.15870777547931e+47*cos(theta)**6 - 2.92866744752064e+46*cos(theta)**4 + 6.3666683641753e+44*cos(theta)**2 - 1.90049801915681e+42)*cos(28*phi)

@torch.jit.script
def Yl38_m29(theta, phi):
    return 1.1042373906736e-44*(1.0 - cos(theta)**2)**14.5*(3.61411509059511e+49*cos(theta)**9 - 1.73477524348565e+49*cos(theta)**7 + 2.49522466528759e+48*cos(theta)**5 - 1.17146697900826e+47*cos(theta)**3 + 1.27333367283506e+45*cos(theta))*cos(29*phi)

@torch.jit.script
def Yl38_m30(theta, phi):
    return 4.46361509559185e-46*(1.0 - cos(theta)**2)**15*(3.2527035815356e+50*cos(theta)**8 - 1.21434267043996e+50*cos(theta)**6 + 1.24761233264379e+49*cos(theta)**4 - 3.51440093702477e+47*cos(theta)**2 + 1.27333367283506e+45)*cos(30*phi)

@torch.jit.script
def Yl38_m31(theta, phi):
    return 1.89984075045795e-47*(1.0 - cos(theta)**2)**15.5*(2.60216286522848e+51*cos(theta)**7 - 7.28605602263975e+50*cos(theta)**5 + 4.99044933057517e+49*cos(theta)**3 - 7.02880187404954e+47*cos(theta))*cos(31*phi)

@torch.jit.script
def Yl38_m32(theta, phi):
    return 8.58260566150099e-49*(1.0 - cos(theta)**2)**16*(1.82151400565994e+52*cos(theta)**6 - 3.64302801131987e+51*cos(theta)**4 + 1.49713479917255e+50*cos(theta)**2 - 7.02880187404954e+47)*cos(32*phi)

@torch.jit.script
def Yl38_m33(theta, phi):
    return 4.15828603021903e-50*(1.0 - cos(theta)**2)**16.5*(1.09290840339596e+53*cos(theta)**5 - 1.45721120452795e+52*cos(theta)**3 + 2.9942695983451e+50*cos(theta))*cos(33*phi)

@torch.jit.script
def Yl38_m34(theta, phi):
    return 2.19160916965865e-51*(1.0 - cos(theta)**2)**17*(5.46454201697981e+53*cos(theta)**4 - 4.37163361358385e+52*cos(theta)**2 + 2.9942695983451e+50)*cos(34*phi)

@torch.jit.script
def Yl38_m35(theta, phi):
    return 1.28254225711204e-52*(1.0 - cos(theta)**2)**17.5*(2.18581680679192e+54*cos(theta)**3 - 8.7432672271677e+52*cos(theta))*cos(35*phi)

@torch.jit.script
def Yl38_m36(theta, phi):
    return 8.60786001928606e-54*(1.0 - cos(theta)**2)**18*(6.55745042037577e+54*cos(theta)**2 - 8.7432672271677e+52)*cos(36*phi)

@torch.jit.script
def Yl38_m37(theta, phi):
    return 9.21753038048947*(1.0 - cos(theta)**2)**18.5*cos(37*phi)*cos(theta)

@torch.jit.script
def Yl38_m38(theta, phi):
    return 1.0573232483571*(1.0 - cos(theta)**2)**19*cos(38*phi)

@torch.jit.script
def Yl39_m_minus_39(theta, phi):
    return 1.064079376195*(1.0 - cos(theta)**2)**19.5*sin(39*phi)

@torch.jit.script
def Yl39_m_minus_38(theta, phi):
    return 9.39769459334552*(1.0 - cos(theta)**2)**19*sin(38*phi)*cos(theta)

@torch.jit.script
def Yl39_m_minus_37(theta, phi):
    return 1.15485099036113e-55*(1.0 - cos(theta)**2)**18.5*(5.04923682368935e+56*cos(theta)**2 - 6.55745042037577e+54)*sin(37*phi)

@torch.jit.script
def Yl39_m_minus_36(theta, phi):
    return 1.743786754927e-54*(1.0 - cos(theta)**2)**18*(1.68307894122978e+56*cos(theta)**3 - 6.55745042037577e+54*cos(theta))*sin(36*phi)

@torch.jit.script
def Yl39_m_minus_35(theta, phi):
    return 3.02032725709922e-53*(1.0 - cos(theta)**2)**17.5*(4.20769735307446e+55*cos(theta)**4 - 3.27872521018789e+54*cos(theta)**2 + 2.18581680679192e+52)*sin(35*phi)

@torch.jit.script
def Yl39_m_minus_34(theta, phi):
    return 5.80971547822379e-52*(1.0 - cos(theta)**2)**17*(8.41539470614891e+54*cos(theta)**5 - 1.09290840339596e+54*cos(theta)**3 + 2.18581680679192e+52*cos(theta))*sin(34*phi)

@torch.jit.script
def Yl39_m_minus_33(theta, phi):
    return 1.21588337207176e-50*(1.0 - cos(theta)**2)**16.5*(1.40256578435815e+54*cos(theta)**6 - 2.73227100848991e+53*cos(theta)**4 + 1.09290840339596e+52*cos(theta)**2 - 4.99044933057517e+49)*sin(33*phi)

@torch.jit.script
def Yl39_m_minus_32(theta, phi):
    return 2.72965140034074e-49*(1.0 - cos(theta)**2)**16*(2.00366540622593e+53*cos(theta)**7 - 5.46454201697981e+52*cos(theta)**5 + 3.64302801131987e+51*cos(theta)**3 - 4.99044933057517e+49*cos(theta))*sin(32*phi)

@torch.jit.script
def Yl39_m_minus_31(theta, phi):
    return 6.50551009827291e-48*(1.0 - cos(theta)**2)**15.5*(2.50458175778241e+52*cos(theta)**8 - 9.10757002829969e+51*cos(theta)**6 + 9.10757002829969e+50*cos(theta)**4 - 2.49522466528759e+49*cos(theta)**2 + 8.78600234256192e+46)*sin(31*phi)

@torch.jit.script
def Yl39_m_minus_30(theta, phi):
    return 1.63287007543161e-46*(1.0 - cos(theta)**2)**15*(2.78286861975824e+51*cos(theta)**9 - 1.30108143261424e+51*cos(theta)**7 + 1.82151400565994e+50*cos(theta)**5 - 8.31741555095862e+48*cos(theta)**3 + 8.78600234256192e+46*cos(theta))*sin(30*phi)

@torch.jit.script
def Yl39_m_minus_29(theta, phi):
    return 4.28919879632039e-45*(1.0 - cos(theta)**2)**14.5*(2.78286861975824e+50*cos(theta)**10 - 1.6263517907678e+50*cos(theta)**8 + 3.0358566760999e+49*cos(theta)**6 - 2.07935388773965e+48*cos(theta)**4 + 4.39300117128096e+46*cos(theta)**2 - 1.27333367283506e+44)*sin(29*phi)

@torch.jit.script
def Yl39_m_minus_28(theta, phi):
    return 1.1730782277043e-43*(1.0 - cos(theta)**2)**14*(2.52988056341658e+49*cos(theta)**11 - 1.80705754529756e+49*cos(theta)**9 + 4.33693810871414e+48*cos(theta)**7 - 4.15870777547931e+47*cos(theta)**5 + 1.46433372376032e+46*cos(theta)**3 - 1.27333367283506e+44*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl39_m_minus_27(theta, phi):
    return 3.326250851581e-42*(1.0 - cos(theta)**2)**13.5*(2.10823380284715e+48*cos(theta)**12 - 1.80705754529756e+48*cos(theta)**10 + 5.42117263589267e+47*cos(theta)**8 - 6.93117962579885e+46*cos(theta)**6 + 3.6608343094008e+45*cos(theta)**4 - 6.3666683641753e+43*cos(theta)**2 + 1.58374834929734e+41)*sin(27*phi)

@torch.jit.script
def Yl39_m_minus_26(theta, phi):
    return 9.74313326210721e-41*(1.0 - cos(theta)**2)**13*(1.62171830988242e+47*cos(theta)**13 - 1.64277958663414e+47*cos(theta)**11 + 6.02352515099186e+46*cos(theta)**9 - 9.90168517971264e+45*cos(theta)**7 + 7.3216686188016e+44*cos(theta)**5 - 2.12222278805844e+43*cos(theta)**3 + 1.58374834929734e+41*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl39_m_minus_25(theta, phi):
    return 2.93913367583875e-39*(1.0 - cos(theta)**2)**12.5*(1.15837022134459e+46*cos(theta)**14 - 1.36898298886179e+46*cos(theta)**12 + 6.02352515099186e+45*cos(theta)**10 - 1.23771064746408e+45*cos(theta)**8 + 1.2202781031336e+44*cos(theta)**6 - 5.30555697014609e+42*cos(theta)**4 + 7.9187417464867e+40*cos(theta)**2 - 1.74038280142565e+38)*sin(25*phi)

@torch.jit.script
def Yl39_m_minus_24(theta, phi):
    return 9.10657262304068e-38*(1.0 - cos(theta)**2)**12*(7.72246814229725e+44*cos(theta)**15 - 1.05306383758599e+45*cos(theta)**13 + 5.47593195544714e+44*cos(theta)**11 - 1.37523405273787e+44*cos(theta)**9 + 1.743254433048e+43*cos(theta)**7 - 1.06111139402922e+42*cos(theta)**5 + 2.63958058216223e+40*cos(theta)**3 - 1.74038280142565e+38*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl39_m_minus_23(theta, phi):
    return 2.89124717480577e-36*(1.0 - cos(theta)**2)**11.5*(4.82654258893578e+43*cos(theta)**16 - 7.52188455418563e+43*cos(theta)**14 + 4.56327662953929e+43*cos(theta)**12 - 1.37523405273787e+43*cos(theta)**10 + 2.17906804131e+42*cos(theta)**8 - 1.7685189900487e+41*cos(theta)**6 + 6.59895145540558e+39*cos(theta)**4 - 8.70191400712824e+37*cos(theta)**2 + 1.72657023950957e+35)*sin(23*phi)

@torch.jit.script
def Yl39_m_minus_22(theta, phi):
    return 9.38653981934599e-35*(1.0 - cos(theta)**2)**11*(2.83914269937399e+42*cos(theta)**17 - 5.01458970279042e+42*cos(theta)**15 + 3.5102127919533e+42*cos(theta)**13 - 1.25021277521624e+42*cos(theta)**11 + 2.42118671256667e+41*cos(theta)**9 - 2.52645570006957e+40*cos(theta)**7 + 1.31979029108112e+39*cos(theta)**5 - 2.90063800237608e+37*cos(theta)**3 + 1.72657023950957e+35*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl39_m_minus_21(theta, phi):
    return 3.1103316302064e-33*(1.0 - cos(theta)**2)**10.5*(1.57730149965222e+41*cos(theta)**18 - 3.13411856424401e+41*cos(theta)**16 + 2.50729485139521e+41*cos(theta)**14 - 1.04184397934687e+41*cos(theta)**12 + 2.42118671256667e+40*cos(theta)**10 - 3.15806962508696e+39*cos(theta)**8 + 2.19965048513519e+38*cos(theta)**6 - 7.2515950059402e+36*cos(theta)**4 + 8.63285119754786e+34*cos(theta)**2 - 1.57246834199415e+32)*sin(21*phi)

@torch.jit.script
def Yl39_m_minus_20(theta, phi):
    return 1.05016882684848e-31*(1.0 - cos(theta)**2)**10*(8.30158684027482e+39*cos(theta)**19 - 1.84359915543766e+40*cos(theta)**17 + 1.67152990093014e+40*cos(theta)**15 - 8.01418445651438e+39*cos(theta)**13 + 2.20107882960606e+39*cos(theta)**11 - 3.50896625009662e+38*cos(theta)**9 + 3.14235783590742e+37*cos(theta)**7 - 1.45031900118804e+36*cos(theta)**5 + 2.87761706584929e+34*cos(theta)**3 - 1.57246834199415e+32*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl39_m_minus_19(theta, phi):
    return 3.60744838710617e-30*(1.0 - cos(theta)**2)**9.5*(4.15079342013741e+38*cos(theta)**20 - 1.02422175302092e+39*cos(theta)**18 + 1.04470618808134e+39*cos(theta)**16 - 5.72441746893884e+38*cos(theta)**14 + 1.83423235800505e+38*cos(theta)**12 - 3.50896625009662e+37*cos(theta)**10 + 3.92794729488427e+36*cos(theta)**8 - 2.4171983353134e+35*cos(theta)**6 + 7.19404266462321e+33*cos(theta)**4 - 7.86234170997073e+31*cos(theta)**2 + 1.33260028982555e+29)*sin(19*phi)

@torch.jit.script
def Yl39_m_minus_18(theta, phi):
    return 1.25899431882528e-28*(1.0 - cos(theta)**2)**9*(1.97656829530353e+37*cos(theta)**21 - 5.39064080537326e+37*cos(theta)**19 + 6.14533051812552e+37*cos(theta)**17 - 3.81627831262589e+37*cos(theta)**15 + 1.41094796769619e+37*cos(theta)**13 - 3.18996931826965e+36*cos(theta)**11 + 4.36438588320475e+35*cos(theta)**9 - 3.45314047901914e+34*cos(theta)**7 + 1.43880853292464e+33*cos(theta)**5 - 2.62078056999024e+31*cos(theta)**3 + 1.33260028982555e+29*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl39_m_minus_17(theta, phi):
    return 4.45833336048602e-27*(1.0 - cos(theta)**2)**8.5*(8.98440134228877e+35*cos(theta)**22 - 2.69532040268663e+36*cos(theta)**20 + 3.41407251006973e+36*cos(theta)**18 - 2.38517394539118e+36*cos(theta)**16 + 1.00781997692585e+36*cos(theta)**14 - 2.65830776522471e+35*cos(theta)**12 + 4.36438588320475e+34*cos(theta)**10 - 4.31642559877393e+33*cos(theta)**8 + 2.39801422154107e+32*cos(theta)**6 - 6.5519514249756e+30*cos(theta)**4 + 6.66300144912773e+28*cos(theta)**2 - 1.06267965695817e+26)*sin(17*phi)

@torch.jit.script
def Yl39_m_minus_16(theta, phi):
    return 1.60003863775068e-25*(1.0 - cos(theta)**2)**8*(3.90626145316903e+34*cos(theta)**23 - 1.28348590604125e+35*cos(theta)**21 + 1.79688026845775e+35*cos(theta)**19 - 1.40304349728893e+35*cos(theta)**17 + 6.71879984617235e+34*cos(theta)**15 - 2.04485212709593e+34*cos(theta)**13 + 3.96762353018614e+33*cos(theta)**11 - 4.79602844308214e+32*cos(theta)**9 + 3.42573460220153e+31*cos(theta)**7 - 1.31039028499512e+30*cos(theta)**5 + 2.22100048304258e+28*cos(theta)**3 - 1.06267965695817e+26*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl39_m_minus_15(theta, phi):
    return 5.81322905778663e-24*(1.0 - cos(theta)**2)**7.5*(1.62760893882043e+33*cos(theta)**24 - 5.83402684564206e+33*cos(theta)**22 + 8.98440134228877e+33*cos(theta)**20 - 7.79468609604962e+33*cos(theta)**18 + 4.19924990385772e+33*cos(theta)**16 - 1.46060866221138e+33*cos(theta)**14 + 3.30635294182178e+32*cos(theta)**12 - 4.79602844308214e+31*cos(theta)**10 + 4.28216825275191e+30*cos(theta)**8 - 2.1839838083252e+29*cos(theta)**6 + 5.55250120760644e+27*cos(theta)**4 - 5.31339828479086e+25*cos(theta)**2 + 8.05060346180433e+22)*sin(15*phi)

@torch.jit.script
def Yl39_m_minus_14(theta, phi):
    return 2.13591674242462e-22*(1.0 - cos(theta)**2)**7*(6.51043575528172e+31*cos(theta)**25 - 2.53653341114872e+32*cos(theta)**23 + 4.27828635347084e+32*cos(theta)**21 - 4.1024663663419e+32*cos(theta)**19 + 2.47014700226925e+32*cos(theta)**17 - 9.7373910814092e+31*cos(theta)**15 + 2.54334841678598e+31*cos(theta)**13 - 4.3600258573474e+30*cos(theta)**11 + 4.7579647252799e+29*cos(theta)**9 - 3.119976869036e+28*cos(theta)**7 + 1.11050024152129e+27*cos(theta)**5 - 1.77113276159695e+25*cos(theta)**3 + 8.05060346180433e+22*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl39_m_minus_13(theta, phi):
    return 7.92882675780294e-21*(1.0 - cos(theta)**2)**6.5*(2.50401375203143e+30*cos(theta)**26 - 1.05688892131197e+31*cos(theta)**24 + 1.94467561521402e+31*cos(theta)**22 - 2.05123318317095e+31*cos(theta)**20 + 1.37230389014958e+31*cos(theta)**18 - 6.08586942588075e+30*cos(theta)**16 + 1.81667744056142e+30*cos(theta)**14 - 3.63335488112284e+29*cos(theta)**12 + 4.7579647252799e+28*cos(theta)**10 - 3.899971086295e+27*cos(theta)**8 + 1.85083373586881e+26*cos(theta)**6 - 4.42783190399238e+24*cos(theta)**4 + 4.02530173090216e+22*cos(theta)**2 - 5.84223763556192e+19)*sin(13*phi)

@torch.jit.script
def Yl39_m_minus_12(theta, phi):
    return 2.97093043392762e-19*(1.0 - cos(theta)**2)**6*(9.27412500752381e+28*cos(theta)**27 - 4.22755568524787e+29*cos(theta)**25 + 8.45511137049574e+29*cos(theta)**23 - 9.76777706271882e+29*cos(theta)**21 + 7.22265205341885e+29*cos(theta)**19 - 3.57992319169456e+29*cos(theta)**17 + 1.21111829370761e+29*cos(theta)**15 - 2.79488837009449e+28*cos(theta)**13 + 4.32542247752718e+27*cos(theta)**11 - 4.33330120699445e+26*cos(theta)**9 + 2.64404819409831e+25*cos(theta)**7 - 8.85566380798476e+23*cos(theta)**5 + 1.34176724363405e+22*cos(theta)**3 - 5.84223763556192e+19*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl39_m_minus_11(theta, phi):
    return 1.12268155211275e-17*(1.0 - cos(theta)**2)**5.5*(3.31218750268708e+27*cos(theta)**28 - 1.62598295586456e+28*cos(theta)**26 + 3.52296307103989e+28*cos(theta)**24 - 4.43989866487219e+28*cos(theta)**22 + 3.61132602670942e+28*cos(theta)**20 - 1.98884621760809e+28*cos(theta)**18 + 7.56948933567257e+27*cos(theta)**16 - 1.99634883578178e+27*cos(theta)**14 + 3.60451873127265e+26*cos(theta)**12 - 4.33330120699445e+25*cos(theta)**10 + 3.30506024262288e+24*cos(theta)**8 - 1.47594396799746e+23*cos(theta)**6 + 3.35441810908514e+21*cos(theta)**4 - 2.92111881778096e+19*cos(theta)**2 + 4.09120282602375e+16)*sin(11*phi)

@torch.jit.script
def Yl39_m_minus_10(theta, phi):
    return 4.27504398551492e-16*(1.0 - cos(theta)**2)**5*(1.14213362161623e+26*cos(theta)**29 - 6.02215909579468e+26*cos(theta)**27 + 1.40918522841596e+27*cos(theta)**25 - 1.93039072385747e+27*cos(theta)**23 + 1.71967906033782e+27*cos(theta)**21 - 1.04676116716215e+27*cos(theta)**19 + 4.45264078568975e+26*cos(theta)**17 - 1.33089922385452e+26*cos(theta)**15 + 2.77270671636358e+25*cos(theta)**13 - 3.93936473363132e+24*cos(theta)**11 + 3.67228915846987e+23*cos(theta)**9 - 2.10849138285351e+22*cos(theta)**7 + 6.70883621817027e+20*cos(theta)**5 - 9.73706272593654e+18*cos(theta)**3 + 4.09120282602375e+16*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl39_m_minus_9(theta, phi):
    return 1.63907661763532e-14*(1.0 - cos(theta)**2)**4.5*(3.80711207205411e+24*cos(theta)**30 - 2.15077110564096e+25*cos(theta)**28 + 5.41994318621522e+25*cos(theta)**26 - 8.04329468273948e+25*cos(theta)**24 + 7.81672300153555e+25*cos(theta)**22 - 5.23380583581076e+25*cos(theta)**20 + 2.47368932538319e+25*cos(theta)**18 - 8.31812014909074e+24*cos(theta)**16 + 1.98050479740256e+24*cos(theta)**14 - 3.28280394469276e+23*cos(theta)**12 + 3.67228915846987e+22*cos(theta)**10 - 2.63561422856689e+21*cos(theta)**8 + 1.11813936969505e+20*cos(theta)**6 - 2.43426568148413e+18*cos(theta)**4 + 2.04560141301188e+16*cos(theta)**2 - 27831311741658.2)*sin(9*phi)

@torch.jit.script
def Yl39_m_minus_8(theta, phi):
    return 6.32267298839384e-13*(1.0 - cos(theta)**2)**4*(1.22810066840455e+23*cos(theta)**31 - 7.4164520884171e+23*cos(theta)**29 + 2.00738636526489e+24*cos(theta)**27 - 3.21731787309579e+24*cos(theta)**25 + 3.39857521805893e+24*cos(theta)**23 - 2.49228849324322e+24*cos(theta)**21 + 1.30194175020168e+24*cos(theta)**19 - 4.89301185240632e+23*cos(theta)**17 + 1.3203365316017e+23*cos(theta)**15 - 2.52523380360982e+22*cos(theta)**13 + 3.33844468951806e+21*cos(theta)**11 - 2.92846025396321e+20*cos(theta)**9 + 1.59734195670721e+19*cos(theta)**7 - 4.86853136296827e+17*cos(theta)**5 + 6.81867137670626e+15*cos(theta)**3 - 27831311741658.2*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl39_m_minus_7(theta, phi):
    return 2.45202355926937e-11*(1.0 - cos(theta)**2)**3.5*(3.83781458876422e+21*cos(theta)**32 - 2.47215069613903e+22*cos(theta)**30 + 7.1692370188032e+22*cos(theta)**28 - 1.23742995119069e+23*cos(theta)**26 + 1.41607300752456e+23*cos(theta)**24 - 1.13285840601964e+23*cos(theta)**22 + 6.5097087510084e+22*cos(theta)**20 - 2.71833991800351e+22*cos(theta)**18 + 8.25210332251065e+21*cos(theta)**16 - 1.80373843114987e+21*cos(theta)**14 + 2.78203724126505e+20*cos(theta)**12 - 2.92846025396321e+19*cos(theta)**10 + 1.99667744588401e+18*cos(theta)**8 - 8.11421893828044e+16*cos(theta)**6 + 1.70466784417656e+15*cos(theta)**4 - 13915655870829.1*cos(theta)**2 + 18504861530.3578)*sin(7*phi)

@torch.jit.script
def Yl39_m_minus_6(theta, phi):
    return 9.55345636639005e-10*(1.0 - cos(theta)**2)**3*(1.16297411780734e+20*cos(theta)**33 - 7.97467966496462e+20*cos(theta)**31 + 2.47215069613903e+21*cos(theta)**29 - 4.58307389329885e+21*cos(theta)**27 + 5.66429203009822e+21*cos(theta)**25 - 4.92547133052019e+21*cos(theta)**23 + 3.099861310004e+21*cos(theta)**21 - 1.43070522000185e+21*cos(theta)**19 + 4.85417842500627e+20*cos(theta)**17 - 1.20249228743325e+20*cos(theta)**15 + 2.14002864712696e+19*cos(theta)**13 - 2.66223659451201e+18*cos(theta)**11 + 2.21853049542668e+17*cos(theta)**9 - 1.15917413404006e+16*cos(theta)**7 + 340933568835313.0*cos(theta)**5 - 4638551956943.03*cos(theta)**3 + 18504861530.3578*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl39_m_minus_5(theta, phi):
    return 3.73685494330611e-8*(1.0 - cos(theta)**2)**2.5*(3.42051211119806e+18*cos(theta)**34 - 2.49208739530144e+19*cos(theta)**32 + 8.24050232046344e+19*cos(theta)**30 - 1.63681210474959e+20*cos(theta)**28 + 2.17857385773009e+20*cos(theta)**26 - 2.05227972105008e+20*cos(theta)**24 + 1.40902786818364e+20*cos(theta)**22 - 7.15352610000924e+19*cos(theta)**20 + 2.69676579167015e+19*cos(theta)**18 - 7.51557679645779e+18*cos(theta)**16 + 1.52859189080497e+18*cos(theta)**14 - 2.21853049542668e+17*cos(theta)**12 + 2.21853049542668e+16*cos(theta)**10 - 1.44896766755008e+15*cos(theta)**8 + 56822261472552.1*cos(theta)**6 - 1159637989235.76*cos(theta)**4 + 9252430765.17892*cos(theta)**2 - 12094680.738796)*sin(5*phi)

@torch.jit.script
def Yl39_m_minus_4(theta, phi):
    return 1.46644777253264e-6*(1.0 - cos(theta)**2)**2*(9.77289174628017e+16*cos(theta)**35 - 7.55177998576195e+17*cos(theta)**33 + 2.65822655498821e+18*cos(theta)**31 - 5.6441796715503e+18*cos(theta)**29 + 8.06879206566698e+18*cos(theta)**27 - 8.20911888420032e+18*cos(theta)**25 + 6.12620812253755e+18*cos(theta)**23 - 3.4064410000044e+18*cos(theta)**21 + 1.4193504166685e+18*cos(theta)**19 - 4.42092752732811e+17*cos(theta)**17 + 1.01906126053665e+17*cos(theta)**15 - 1.70656191955898e+16*cos(theta)**13 + 2.01684590493334e+15*cos(theta)**11 - 160996407505564.0*cos(theta)**9 + 8117465924650.31*cos(theta)**7 - 231927597847.152*cos(theta)**5 + 3084143588.39297*cos(theta)**3 - 12094680.738796*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl39_m_minus_3(theta, phi):
    return 5.76968467048944e-5*(1.0 - cos(theta)**2)**1.5*(2.71469215174449e+15*cos(theta)**36 - 2.22111176051822e+16*cos(theta)**34 + 8.30695798433815e+16*cos(theta)**32 - 1.8813932238501e+17*cos(theta)**30 + 2.88171145202392e+17*cos(theta)**28 - 3.15735341700012e+17*cos(theta)**26 + 2.55258671772398e+17*cos(theta)**24 - 1.54838227272927e+17*cos(theta)**22 + 7.0967520833425e+16*cos(theta)**20 - 2.45607084851562e+16*cos(theta)**18 + 6.36913287835406e+15*cos(theta)**16 - 1.21897279968499e+15*cos(theta)**14 + 168070492077779.0*cos(theta)**12 - 16099640750556.4*cos(theta)**10 + 1014683240581.29*cos(theta)**8 - 38654599641.1919*cos(theta)**6 + 771035897.098243*cos(theta)**4 - 6047340.36939799*cos(theta)**2 + 7813.10125245218)*sin(3*phi)

@torch.jit.script
def Yl39_m_minus_2(theta, phi):
    return 0.00227445624051009*(1.0 - cos(theta)**2)*(73370058155256.6*cos(theta)**37 - 634603360148063.0*cos(theta)**35 + 2.51725999525398e+15*cos(theta)**33 - 6.06901039951646e+15*cos(theta)**31 + 9.9369360414618e+15*cos(theta)**29 - 1.16939015444449e+16*cos(theta)**27 + 1.02103468708959e+16*cos(theta)**25 - 6.73209683795336e+15*cos(theta)**23 + 3.37940575397262e+15*cos(theta)**21 - 1.2926688676398e+15*cos(theta)**19 + 374654875197298.0*cos(theta)**17 - 81264853312332.5*cos(theta)**15 + 12928499390598.4*cos(theta)**13 - 1463603704596.04*cos(theta)**11 + 112742582286.81*cos(theta)**9 - 5522085663.02742*cos(theta)**7 + 154207179.419649*cos(theta)**5 - 2015780.12313266*cos(theta)**3 + 7813.10125245218*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl39_m_minus_1(theta, phi):
    return 0.0897762193123137*(1.0 - cos(theta)**2)**0.5*(1930791004085.7*cos(theta)**38 - 17627871115224.0*cos(theta)**36 + 74037058683940.7*cos(theta)**34 - 189656574984889.0*cos(theta)**32 + 331231201382060.0*cos(theta)**30 - 417639340873032.0*cos(theta)**28 + 392705648880612.0*cos(theta)**26 - 280504034914723.0*cos(theta)**24 + 153609352453301.0*cos(theta)**22 - 64633443381989.9*cos(theta)**20 + 20814159733183.2*cos(theta)**18 - 5079053332020.78*cos(theta)**16 + 923464242185.597*cos(theta)**14 - 121966975383.003*cos(theta)**12 + 11274258228.681*cos(theta)**10 - 690260707.878427*cos(theta)**8 + 25701196.5699414*cos(theta)**6 - 503945.030783166*cos(theta)**4 + 3906.55062622609*cos(theta)**2 - 5.01482750478317)*sin(phi)

@torch.jit.script
def Yl39_m0(theta, phi):
    return 124130719670.912*cos(theta)**39 - 1194556665923.97*cos(theta)**37 + 5303831596702.42*cos(theta)**35 - 14409953424830.8*cos(theta)**33 + 26790335944755.8*cos(theta)**31 - 36108713664670.9*cos(theta)**29 + 36468004347901.4*cos(theta)**27 - 28132460496952.5*cos(theta)**25 + 16745512200567.0*cos(theta)**23 - 7716966460370.57*cos(theta)**21 + 2746716875725.12*cos(theta)**19 - 749104602470.487*cos(theta)**17 + 154360948387.858*cos(theta)**15 - 23523802003.9551*cos(theta)**13 + 2569827109.67577*cos(theta)**11 - 192299987.798867*cos(theta)**9 + 9205850.479733*cos(theta)**7 - 252709.621012278*cos(theta)**5 + 3264.98218362117*cos(theta)**3 - 12.5737439677324*cos(theta)

@torch.jit.script
def Yl39_m1(theta, phi):
    return 0.0897762193123137*(1.0 - cos(theta)**2)**0.5*(1930791004085.7*cos(theta)**38 - 17627871115224.0*cos(theta)**36 + 74037058683940.7*cos(theta)**34 - 189656574984889.0*cos(theta)**32 + 331231201382060.0*cos(theta)**30 - 417639340873032.0*cos(theta)**28 + 392705648880612.0*cos(theta)**26 - 280504034914723.0*cos(theta)**24 + 153609352453301.0*cos(theta)**22 - 64633443381989.9*cos(theta)**20 + 20814159733183.2*cos(theta)**18 - 5079053332020.78*cos(theta)**16 + 923464242185.597*cos(theta)**14 - 121966975383.003*cos(theta)**12 + 11274258228.681*cos(theta)**10 - 690260707.878427*cos(theta)**8 + 25701196.5699414*cos(theta)**6 - 503945.030783166*cos(theta)**4 + 3906.55062622609*cos(theta)**2 - 5.01482750478317)*cos(phi)

@torch.jit.script
def Yl39_m2(theta, phi):
    return 0.00227445624051009*(1.0 - cos(theta)**2)*(73370058155256.6*cos(theta)**37 - 634603360148063.0*cos(theta)**35 + 2.51725999525398e+15*cos(theta)**33 - 6.06901039951646e+15*cos(theta)**31 + 9.9369360414618e+15*cos(theta)**29 - 1.16939015444449e+16*cos(theta)**27 + 1.02103468708959e+16*cos(theta)**25 - 6.73209683795336e+15*cos(theta)**23 + 3.37940575397262e+15*cos(theta)**21 - 1.2926688676398e+15*cos(theta)**19 + 374654875197298.0*cos(theta)**17 - 81264853312332.5*cos(theta)**15 + 12928499390598.4*cos(theta)**13 - 1463603704596.04*cos(theta)**11 + 112742582286.81*cos(theta)**9 - 5522085663.02742*cos(theta)**7 + 154207179.419649*cos(theta)**5 - 2015780.12313266*cos(theta)**3 + 7813.10125245218*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl39_m3(theta, phi):
    return 5.76968467048944e-5*(1.0 - cos(theta)**2)**1.5*(2.71469215174449e+15*cos(theta)**36 - 2.22111176051822e+16*cos(theta)**34 + 8.30695798433815e+16*cos(theta)**32 - 1.8813932238501e+17*cos(theta)**30 + 2.88171145202392e+17*cos(theta)**28 - 3.15735341700012e+17*cos(theta)**26 + 2.55258671772398e+17*cos(theta)**24 - 1.54838227272927e+17*cos(theta)**22 + 7.0967520833425e+16*cos(theta)**20 - 2.45607084851562e+16*cos(theta)**18 + 6.36913287835406e+15*cos(theta)**16 - 1.21897279968499e+15*cos(theta)**14 + 168070492077779.0*cos(theta)**12 - 16099640750556.4*cos(theta)**10 + 1014683240581.29*cos(theta)**8 - 38654599641.1919*cos(theta)**6 + 771035897.098243*cos(theta)**4 - 6047340.36939799*cos(theta)**2 + 7813.10125245218)*cos(3*phi)

@torch.jit.script
def Yl39_m4(theta, phi):
    return 1.46644777253264e-6*(1.0 - cos(theta)**2)**2*(9.77289174628017e+16*cos(theta)**35 - 7.55177998576195e+17*cos(theta)**33 + 2.65822655498821e+18*cos(theta)**31 - 5.6441796715503e+18*cos(theta)**29 + 8.06879206566698e+18*cos(theta)**27 - 8.20911888420032e+18*cos(theta)**25 + 6.12620812253755e+18*cos(theta)**23 - 3.4064410000044e+18*cos(theta)**21 + 1.4193504166685e+18*cos(theta)**19 - 4.42092752732811e+17*cos(theta)**17 + 1.01906126053665e+17*cos(theta)**15 - 1.70656191955898e+16*cos(theta)**13 + 2.01684590493334e+15*cos(theta)**11 - 160996407505564.0*cos(theta)**9 + 8117465924650.31*cos(theta)**7 - 231927597847.152*cos(theta)**5 + 3084143588.39297*cos(theta)**3 - 12094680.738796*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl39_m5(theta, phi):
    return 3.73685494330611e-8*(1.0 - cos(theta)**2)**2.5*(3.42051211119806e+18*cos(theta)**34 - 2.49208739530144e+19*cos(theta)**32 + 8.24050232046344e+19*cos(theta)**30 - 1.63681210474959e+20*cos(theta)**28 + 2.17857385773009e+20*cos(theta)**26 - 2.05227972105008e+20*cos(theta)**24 + 1.40902786818364e+20*cos(theta)**22 - 7.15352610000924e+19*cos(theta)**20 + 2.69676579167015e+19*cos(theta)**18 - 7.51557679645779e+18*cos(theta)**16 + 1.52859189080497e+18*cos(theta)**14 - 2.21853049542668e+17*cos(theta)**12 + 2.21853049542668e+16*cos(theta)**10 - 1.44896766755008e+15*cos(theta)**8 + 56822261472552.1*cos(theta)**6 - 1159637989235.76*cos(theta)**4 + 9252430765.17892*cos(theta)**2 - 12094680.738796)*cos(5*phi)

@torch.jit.script
def Yl39_m6(theta, phi):
    return 9.55345636639005e-10*(1.0 - cos(theta)**2)**3*(1.16297411780734e+20*cos(theta)**33 - 7.97467966496462e+20*cos(theta)**31 + 2.47215069613903e+21*cos(theta)**29 - 4.58307389329885e+21*cos(theta)**27 + 5.66429203009822e+21*cos(theta)**25 - 4.92547133052019e+21*cos(theta)**23 + 3.099861310004e+21*cos(theta)**21 - 1.43070522000185e+21*cos(theta)**19 + 4.85417842500627e+20*cos(theta)**17 - 1.20249228743325e+20*cos(theta)**15 + 2.14002864712696e+19*cos(theta)**13 - 2.66223659451201e+18*cos(theta)**11 + 2.21853049542668e+17*cos(theta)**9 - 1.15917413404006e+16*cos(theta)**7 + 340933568835313.0*cos(theta)**5 - 4638551956943.03*cos(theta)**3 + 18504861530.3578*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl39_m7(theta, phi):
    return 2.45202355926937e-11*(1.0 - cos(theta)**2)**3.5*(3.83781458876422e+21*cos(theta)**32 - 2.47215069613903e+22*cos(theta)**30 + 7.1692370188032e+22*cos(theta)**28 - 1.23742995119069e+23*cos(theta)**26 + 1.41607300752456e+23*cos(theta)**24 - 1.13285840601964e+23*cos(theta)**22 + 6.5097087510084e+22*cos(theta)**20 - 2.71833991800351e+22*cos(theta)**18 + 8.25210332251065e+21*cos(theta)**16 - 1.80373843114987e+21*cos(theta)**14 + 2.78203724126505e+20*cos(theta)**12 - 2.92846025396321e+19*cos(theta)**10 + 1.99667744588401e+18*cos(theta)**8 - 8.11421893828044e+16*cos(theta)**6 + 1.70466784417656e+15*cos(theta)**4 - 13915655870829.1*cos(theta)**2 + 18504861530.3578)*cos(7*phi)

@torch.jit.script
def Yl39_m8(theta, phi):
    return 6.32267298839384e-13*(1.0 - cos(theta)**2)**4*(1.22810066840455e+23*cos(theta)**31 - 7.4164520884171e+23*cos(theta)**29 + 2.00738636526489e+24*cos(theta)**27 - 3.21731787309579e+24*cos(theta)**25 + 3.39857521805893e+24*cos(theta)**23 - 2.49228849324322e+24*cos(theta)**21 + 1.30194175020168e+24*cos(theta)**19 - 4.89301185240632e+23*cos(theta)**17 + 1.3203365316017e+23*cos(theta)**15 - 2.52523380360982e+22*cos(theta)**13 + 3.33844468951806e+21*cos(theta)**11 - 2.92846025396321e+20*cos(theta)**9 + 1.59734195670721e+19*cos(theta)**7 - 4.86853136296827e+17*cos(theta)**5 + 6.81867137670626e+15*cos(theta)**3 - 27831311741658.2*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl39_m9(theta, phi):
    return 1.63907661763532e-14*(1.0 - cos(theta)**2)**4.5*(3.80711207205411e+24*cos(theta)**30 - 2.15077110564096e+25*cos(theta)**28 + 5.41994318621522e+25*cos(theta)**26 - 8.04329468273948e+25*cos(theta)**24 + 7.81672300153555e+25*cos(theta)**22 - 5.23380583581076e+25*cos(theta)**20 + 2.47368932538319e+25*cos(theta)**18 - 8.31812014909074e+24*cos(theta)**16 + 1.98050479740256e+24*cos(theta)**14 - 3.28280394469276e+23*cos(theta)**12 + 3.67228915846987e+22*cos(theta)**10 - 2.63561422856689e+21*cos(theta)**8 + 1.11813936969505e+20*cos(theta)**6 - 2.43426568148413e+18*cos(theta)**4 + 2.04560141301188e+16*cos(theta)**2 - 27831311741658.2)*cos(9*phi)

@torch.jit.script
def Yl39_m10(theta, phi):
    return 4.27504398551492e-16*(1.0 - cos(theta)**2)**5*(1.14213362161623e+26*cos(theta)**29 - 6.02215909579468e+26*cos(theta)**27 + 1.40918522841596e+27*cos(theta)**25 - 1.93039072385747e+27*cos(theta)**23 + 1.71967906033782e+27*cos(theta)**21 - 1.04676116716215e+27*cos(theta)**19 + 4.45264078568975e+26*cos(theta)**17 - 1.33089922385452e+26*cos(theta)**15 + 2.77270671636358e+25*cos(theta)**13 - 3.93936473363132e+24*cos(theta)**11 + 3.67228915846987e+23*cos(theta)**9 - 2.10849138285351e+22*cos(theta)**7 + 6.70883621817027e+20*cos(theta)**5 - 9.73706272593654e+18*cos(theta)**3 + 4.09120282602375e+16*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl39_m11(theta, phi):
    return 1.12268155211275e-17*(1.0 - cos(theta)**2)**5.5*(3.31218750268708e+27*cos(theta)**28 - 1.62598295586456e+28*cos(theta)**26 + 3.52296307103989e+28*cos(theta)**24 - 4.43989866487219e+28*cos(theta)**22 + 3.61132602670942e+28*cos(theta)**20 - 1.98884621760809e+28*cos(theta)**18 + 7.56948933567257e+27*cos(theta)**16 - 1.99634883578178e+27*cos(theta)**14 + 3.60451873127265e+26*cos(theta)**12 - 4.33330120699445e+25*cos(theta)**10 + 3.30506024262288e+24*cos(theta)**8 - 1.47594396799746e+23*cos(theta)**6 + 3.35441810908514e+21*cos(theta)**4 - 2.92111881778096e+19*cos(theta)**2 + 4.09120282602375e+16)*cos(11*phi)

@torch.jit.script
def Yl39_m12(theta, phi):
    return 2.97093043392762e-19*(1.0 - cos(theta)**2)**6*(9.27412500752381e+28*cos(theta)**27 - 4.22755568524787e+29*cos(theta)**25 + 8.45511137049574e+29*cos(theta)**23 - 9.76777706271882e+29*cos(theta)**21 + 7.22265205341885e+29*cos(theta)**19 - 3.57992319169456e+29*cos(theta)**17 + 1.21111829370761e+29*cos(theta)**15 - 2.79488837009449e+28*cos(theta)**13 + 4.32542247752718e+27*cos(theta)**11 - 4.33330120699445e+26*cos(theta)**9 + 2.64404819409831e+25*cos(theta)**7 - 8.85566380798476e+23*cos(theta)**5 + 1.34176724363405e+22*cos(theta)**3 - 5.84223763556192e+19*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl39_m13(theta, phi):
    return 7.92882675780294e-21*(1.0 - cos(theta)**2)**6.5*(2.50401375203143e+30*cos(theta)**26 - 1.05688892131197e+31*cos(theta)**24 + 1.94467561521402e+31*cos(theta)**22 - 2.05123318317095e+31*cos(theta)**20 + 1.37230389014958e+31*cos(theta)**18 - 6.08586942588075e+30*cos(theta)**16 + 1.81667744056142e+30*cos(theta)**14 - 3.63335488112284e+29*cos(theta)**12 + 4.7579647252799e+28*cos(theta)**10 - 3.899971086295e+27*cos(theta)**8 + 1.85083373586881e+26*cos(theta)**6 - 4.42783190399238e+24*cos(theta)**4 + 4.02530173090216e+22*cos(theta)**2 - 5.84223763556192e+19)*cos(13*phi)

@torch.jit.script
def Yl39_m14(theta, phi):
    return 2.13591674242462e-22*(1.0 - cos(theta)**2)**7*(6.51043575528172e+31*cos(theta)**25 - 2.53653341114872e+32*cos(theta)**23 + 4.27828635347084e+32*cos(theta)**21 - 4.1024663663419e+32*cos(theta)**19 + 2.47014700226925e+32*cos(theta)**17 - 9.7373910814092e+31*cos(theta)**15 + 2.54334841678598e+31*cos(theta)**13 - 4.3600258573474e+30*cos(theta)**11 + 4.7579647252799e+29*cos(theta)**9 - 3.119976869036e+28*cos(theta)**7 + 1.11050024152129e+27*cos(theta)**5 - 1.77113276159695e+25*cos(theta)**3 + 8.05060346180433e+22*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl39_m15(theta, phi):
    return 5.81322905778663e-24*(1.0 - cos(theta)**2)**7.5*(1.62760893882043e+33*cos(theta)**24 - 5.83402684564206e+33*cos(theta)**22 + 8.98440134228877e+33*cos(theta)**20 - 7.79468609604962e+33*cos(theta)**18 + 4.19924990385772e+33*cos(theta)**16 - 1.46060866221138e+33*cos(theta)**14 + 3.30635294182178e+32*cos(theta)**12 - 4.79602844308214e+31*cos(theta)**10 + 4.28216825275191e+30*cos(theta)**8 - 2.1839838083252e+29*cos(theta)**6 + 5.55250120760644e+27*cos(theta)**4 - 5.31339828479086e+25*cos(theta)**2 + 8.05060346180433e+22)*cos(15*phi)

@torch.jit.script
def Yl39_m16(theta, phi):
    return 1.60003863775068e-25*(1.0 - cos(theta)**2)**8*(3.90626145316903e+34*cos(theta)**23 - 1.28348590604125e+35*cos(theta)**21 + 1.79688026845775e+35*cos(theta)**19 - 1.40304349728893e+35*cos(theta)**17 + 6.71879984617235e+34*cos(theta)**15 - 2.04485212709593e+34*cos(theta)**13 + 3.96762353018614e+33*cos(theta)**11 - 4.79602844308214e+32*cos(theta)**9 + 3.42573460220153e+31*cos(theta)**7 - 1.31039028499512e+30*cos(theta)**5 + 2.22100048304258e+28*cos(theta)**3 - 1.06267965695817e+26*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl39_m17(theta, phi):
    return 4.45833336048602e-27*(1.0 - cos(theta)**2)**8.5*(8.98440134228877e+35*cos(theta)**22 - 2.69532040268663e+36*cos(theta)**20 + 3.41407251006973e+36*cos(theta)**18 - 2.38517394539118e+36*cos(theta)**16 + 1.00781997692585e+36*cos(theta)**14 - 2.65830776522471e+35*cos(theta)**12 + 4.36438588320475e+34*cos(theta)**10 - 4.31642559877393e+33*cos(theta)**8 + 2.39801422154107e+32*cos(theta)**6 - 6.5519514249756e+30*cos(theta)**4 + 6.66300144912773e+28*cos(theta)**2 - 1.06267965695817e+26)*cos(17*phi)

@torch.jit.script
def Yl39_m18(theta, phi):
    return 1.25899431882528e-28*(1.0 - cos(theta)**2)**9*(1.97656829530353e+37*cos(theta)**21 - 5.39064080537326e+37*cos(theta)**19 + 6.14533051812552e+37*cos(theta)**17 - 3.81627831262589e+37*cos(theta)**15 + 1.41094796769619e+37*cos(theta)**13 - 3.18996931826965e+36*cos(theta)**11 + 4.36438588320475e+35*cos(theta)**9 - 3.45314047901914e+34*cos(theta)**7 + 1.43880853292464e+33*cos(theta)**5 - 2.62078056999024e+31*cos(theta)**3 + 1.33260028982555e+29*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl39_m19(theta, phi):
    return 3.60744838710617e-30*(1.0 - cos(theta)**2)**9.5*(4.15079342013741e+38*cos(theta)**20 - 1.02422175302092e+39*cos(theta)**18 + 1.04470618808134e+39*cos(theta)**16 - 5.72441746893884e+38*cos(theta)**14 + 1.83423235800505e+38*cos(theta)**12 - 3.50896625009662e+37*cos(theta)**10 + 3.92794729488427e+36*cos(theta)**8 - 2.4171983353134e+35*cos(theta)**6 + 7.19404266462321e+33*cos(theta)**4 - 7.86234170997073e+31*cos(theta)**2 + 1.33260028982555e+29)*cos(19*phi)

@torch.jit.script
def Yl39_m20(theta, phi):
    return 1.05016882684848e-31*(1.0 - cos(theta)**2)**10*(8.30158684027482e+39*cos(theta)**19 - 1.84359915543766e+40*cos(theta)**17 + 1.67152990093014e+40*cos(theta)**15 - 8.01418445651438e+39*cos(theta)**13 + 2.20107882960606e+39*cos(theta)**11 - 3.50896625009662e+38*cos(theta)**9 + 3.14235783590742e+37*cos(theta)**7 - 1.45031900118804e+36*cos(theta)**5 + 2.87761706584929e+34*cos(theta)**3 - 1.57246834199415e+32*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl39_m21(theta, phi):
    return 3.1103316302064e-33*(1.0 - cos(theta)**2)**10.5*(1.57730149965222e+41*cos(theta)**18 - 3.13411856424401e+41*cos(theta)**16 + 2.50729485139521e+41*cos(theta)**14 - 1.04184397934687e+41*cos(theta)**12 + 2.42118671256667e+40*cos(theta)**10 - 3.15806962508696e+39*cos(theta)**8 + 2.19965048513519e+38*cos(theta)**6 - 7.2515950059402e+36*cos(theta)**4 + 8.63285119754786e+34*cos(theta)**2 - 1.57246834199415e+32)*cos(21*phi)

@torch.jit.script
def Yl39_m22(theta, phi):
    return 9.38653981934599e-35*(1.0 - cos(theta)**2)**11*(2.83914269937399e+42*cos(theta)**17 - 5.01458970279042e+42*cos(theta)**15 + 3.5102127919533e+42*cos(theta)**13 - 1.25021277521624e+42*cos(theta)**11 + 2.42118671256667e+41*cos(theta)**9 - 2.52645570006957e+40*cos(theta)**7 + 1.31979029108112e+39*cos(theta)**5 - 2.90063800237608e+37*cos(theta)**3 + 1.72657023950957e+35*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl39_m23(theta, phi):
    return 2.89124717480577e-36*(1.0 - cos(theta)**2)**11.5*(4.82654258893578e+43*cos(theta)**16 - 7.52188455418563e+43*cos(theta)**14 + 4.56327662953929e+43*cos(theta)**12 - 1.37523405273787e+43*cos(theta)**10 + 2.17906804131e+42*cos(theta)**8 - 1.7685189900487e+41*cos(theta)**6 + 6.59895145540558e+39*cos(theta)**4 - 8.70191400712824e+37*cos(theta)**2 + 1.72657023950957e+35)*cos(23*phi)

@torch.jit.script
def Yl39_m24(theta, phi):
    return 9.10657262304068e-38*(1.0 - cos(theta)**2)**12*(7.72246814229725e+44*cos(theta)**15 - 1.05306383758599e+45*cos(theta)**13 + 5.47593195544714e+44*cos(theta)**11 - 1.37523405273787e+44*cos(theta)**9 + 1.743254433048e+43*cos(theta)**7 - 1.06111139402922e+42*cos(theta)**5 + 2.63958058216223e+40*cos(theta)**3 - 1.74038280142565e+38*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl39_m25(theta, phi):
    return 2.93913367583875e-39*(1.0 - cos(theta)**2)**12.5*(1.15837022134459e+46*cos(theta)**14 - 1.36898298886179e+46*cos(theta)**12 + 6.02352515099186e+45*cos(theta)**10 - 1.23771064746408e+45*cos(theta)**8 + 1.2202781031336e+44*cos(theta)**6 - 5.30555697014609e+42*cos(theta)**4 + 7.9187417464867e+40*cos(theta)**2 - 1.74038280142565e+38)*cos(25*phi)

@torch.jit.script
def Yl39_m26(theta, phi):
    return 9.74313326210721e-41*(1.0 - cos(theta)**2)**13*(1.62171830988242e+47*cos(theta)**13 - 1.64277958663414e+47*cos(theta)**11 + 6.02352515099186e+46*cos(theta)**9 - 9.90168517971264e+45*cos(theta)**7 + 7.3216686188016e+44*cos(theta)**5 - 2.12222278805844e+43*cos(theta)**3 + 1.58374834929734e+41*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl39_m27(theta, phi):
    return 3.326250851581e-42*(1.0 - cos(theta)**2)**13.5*(2.10823380284715e+48*cos(theta)**12 - 1.80705754529756e+48*cos(theta)**10 + 5.42117263589267e+47*cos(theta)**8 - 6.93117962579885e+46*cos(theta)**6 + 3.6608343094008e+45*cos(theta)**4 - 6.3666683641753e+43*cos(theta)**2 + 1.58374834929734e+41)*cos(27*phi)

@torch.jit.script
def Yl39_m28(theta, phi):
    return 1.1730782277043e-43*(1.0 - cos(theta)**2)**14*(2.52988056341658e+49*cos(theta)**11 - 1.80705754529756e+49*cos(theta)**9 + 4.33693810871414e+48*cos(theta)**7 - 4.15870777547931e+47*cos(theta)**5 + 1.46433372376032e+46*cos(theta)**3 - 1.27333367283506e+44*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl39_m29(theta, phi):
    return 4.28919879632039e-45*(1.0 - cos(theta)**2)**14.5*(2.78286861975824e+50*cos(theta)**10 - 1.6263517907678e+50*cos(theta)**8 + 3.0358566760999e+49*cos(theta)**6 - 2.07935388773965e+48*cos(theta)**4 + 4.39300117128096e+46*cos(theta)**2 - 1.27333367283506e+44)*cos(29*phi)

@torch.jit.script
def Yl39_m30(theta, phi):
    return 1.63287007543161e-46*(1.0 - cos(theta)**2)**15*(2.78286861975824e+51*cos(theta)**9 - 1.30108143261424e+51*cos(theta)**7 + 1.82151400565994e+50*cos(theta)**5 - 8.31741555095862e+48*cos(theta)**3 + 8.78600234256192e+46*cos(theta))*cos(30*phi)

@torch.jit.script
def Yl39_m31(theta, phi):
    return 6.50551009827291e-48*(1.0 - cos(theta)**2)**15.5*(2.50458175778241e+52*cos(theta)**8 - 9.10757002829969e+51*cos(theta)**6 + 9.10757002829969e+50*cos(theta)**4 - 2.49522466528759e+49*cos(theta)**2 + 8.78600234256192e+46)*cos(31*phi)

@torch.jit.script
def Yl39_m32(theta, phi):
    return 2.72965140034074e-49*(1.0 - cos(theta)**2)**16*(2.00366540622593e+53*cos(theta)**7 - 5.46454201697981e+52*cos(theta)**5 + 3.64302801131987e+51*cos(theta)**3 - 4.99044933057517e+49*cos(theta))*cos(32*phi)

@torch.jit.script
def Yl39_m33(theta, phi):
    return 1.21588337207176e-50*(1.0 - cos(theta)**2)**16.5*(1.40256578435815e+54*cos(theta)**6 - 2.73227100848991e+53*cos(theta)**4 + 1.09290840339596e+52*cos(theta)**2 - 4.99044933057517e+49)*cos(33*phi)

@torch.jit.script
def Yl39_m34(theta, phi):
    return 5.80971547822379e-52*(1.0 - cos(theta)**2)**17*(8.41539470614891e+54*cos(theta)**5 - 1.09290840339596e+54*cos(theta)**3 + 2.18581680679192e+52*cos(theta))*cos(34*phi)

@torch.jit.script
def Yl39_m35(theta, phi):
    return 3.02032725709922e-53*(1.0 - cos(theta)**2)**17.5*(4.20769735307446e+55*cos(theta)**4 - 3.27872521018789e+54*cos(theta)**2 + 2.18581680679192e+52)*cos(35*phi)

@torch.jit.script
def Yl39_m36(theta, phi):
    return 1.743786754927e-54*(1.0 - cos(theta)**2)**18*(1.68307894122978e+56*cos(theta)**3 - 6.55745042037577e+54*cos(theta))*cos(36*phi)

@torch.jit.script
def Yl39_m37(theta, phi):
    return 1.15485099036113e-55*(1.0 - cos(theta)**2)**18.5*(5.04923682368935e+56*cos(theta)**2 - 6.55745042037577e+54)*cos(37*phi)

@torch.jit.script
def Yl39_m38(theta, phi):
    return 9.39769459334552*(1.0 - cos(theta)**2)**19*cos(38*phi)*cos(theta)

@torch.jit.script
def Yl39_m39(theta, phi):
    return 1.064079376195*(1.0 - cos(theta)**2)**19.5*cos(39*phi)

@torch.jit.script
def Yl40_m_minus_40(theta, phi):
    return 1.07070921838241*(1.0 - cos(theta)**2)**20*sin(40*phi)

@torch.jit.script
def Yl40_m_minus_39(theta, phi):
    return 9.57671438575497*(1.0 - cos(theta)**2)**19.5*sin(39*phi)*cos(theta)

@torch.jit.script
def Yl40_m_minus_38(theta, phi):
    return 1.50890622763283e-57*(1.0 - cos(theta)**2)**19*(3.98889709071458e+58*cos(theta)**2 - 5.04923682368935e+56)*sin(38*phi)

@torch.jit.script
def Yl40_m_minus_37(theta, phi):
    return 2.30818268966444e-56*(1.0 - cos(theta)**2)**18.5*(1.32963236357153e+58*cos(theta)**3 - 5.04923682368935e+56*cos(theta))*sin(37*phi)

@torch.jit.script
def Yl40_m_minus_36(theta, phi):
    return 4.05084418028009e-55*(1.0 - cos(theta)**2)**18*(3.32408090892882e+57*cos(theta)**4 - 2.52461841184467e+56*cos(theta)**2 + 1.63936260509394e+54)*sin(36*phi)

@torch.jit.script
def Yl40_m_minus_35(theta, phi):
    return 7.89654902961126e-54*(1.0 - cos(theta)**2)**17.5*(6.64816181785764e+56*cos(theta)**5 - 8.41539470614891e+55*cos(theta)**3 + 1.63936260509394e+54*cos(theta))*sin(35*phi)

@torch.jit.script
def Yl40_m_minus_34(theta, phi):
    return 1.67511101004305e-52*(1.0 - cos(theta)**2)**17*(1.10802696964294e+56*cos(theta)**6 - 2.10384867653723e+55*cos(theta)**4 + 8.19681302546972e+53*cos(theta)**2 - 3.64302801131987e+51)*sin(34*phi)

@torch.jit.script
def Yl40_m_minus_33(theta, phi):
    return 3.81248789127407e-51*(1.0 - cos(theta)**2)**16.5*(1.58289567091849e+55*cos(theta)**7 - 4.20769735307446e+54*cos(theta)**5 + 2.73227100848991e+53*cos(theta)**3 - 3.64302801131987e+51*cos(theta))*sin(33*phi)

@torch.jit.script
def Yl40_m_minus_32(theta, phi):
    return 9.21329329280745e-50*(1.0 - cos(theta)**2)**16*(1.97861958864811e+54*cos(theta)**8 - 7.01282892179076e+53*cos(theta)**6 + 6.83067752122477e+52*cos(theta)**4 - 1.82151400565994e+51*cos(theta)**2 + 6.23806166321896e+48)*sin(32*phi)

@torch.jit.script
def Yl40_m_minus_31(theta, phi):
    return 2.34532157918569e-48*(1.0 - cos(theta)**2)**15.5*(2.19846620960901e+53*cos(theta)**9 - 1.00183270311297e+53*cos(theta)**7 + 1.36613550424495e+52*cos(theta)**5 - 6.07171335219979e+50*cos(theta)**3 + 6.23806166321896e+48*cos(theta))*sin(31*phi)

@torch.jit.script
def Yl40_m_minus_30(theta, phi):
    return 6.24930288108503e-47*(1.0 - cos(theta)**2)**15*(2.19846620960901e+52*cos(theta)**10 - 1.25229087889121e+52*cos(theta)**8 + 2.27689250707492e+51*cos(theta)**6 - 1.51792833804995e+50*cos(theta)**4 + 3.11903083160948e+48*cos(theta)**2 - 8.78600234256192e+45)*sin(30*phi)

@torch.jit.script
def Yl40_m_minus_29(theta, phi):
    return 1.73411117304064e-45*(1.0 - cos(theta)**2)**14.5*(1.9986056450991e+51*cos(theta)**11 - 1.39143430987912e+51*cos(theta)**9 + 3.2527035815356e+50*cos(theta)**7 - 3.0358566760999e+49*cos(theta)**5 + 1.03967694386983e+48*cos(theta)**3 - 8.78600234256192e+45*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl40_m_minus_28(theta, phi):
    return 4.98990301715827e-44*(1.0 - cos(theta)**2)**14*(1.66550470424925e+50*cos(theta)**12 - 1.39143430987912e+50*cos(theta)**10 + 4.0658794769195e+49*cos(theta)**8 - 5.05976112683316e+48*cos(theta)**6 + 2.59919235967457e+47*cos(theta)**4 - 4.39300117128096e+45*cos(theta)**2 + 1.06111139402922e+43)*sin(28*phi)

@torch.jit.script
def Yl40_m_minus_27(theta, phi):
    return 1.48360482591054e-42*(1.0 - cos(theta)**2)**13.5*(1.28115746480711e+49*cos(theta)**13 - 1.26494028170829e+49*cos(theta)**11 + 4.51764386324389e+48*cos(theta)**9 - 7.22823018119023e+47*cos(theta)**7 + 5.19838471934914e+46*cos(theta)**5 - 1.46433372376032e+45*cos(theta)**3 + 1.06111139402922e+43*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl40_m_minus_26(theta, phi):
    return 4.54380470106078e-41*(1.0 - cos(theta)**2)**13*(9.15112474862224e+47*cos(theta)**14 - 1.05411690142357e+48*cos(theta)**12 + 4.51764386324389e+47*cos(theta)**10 - 9.03528772648778e+46*cos(theta)**8 + 8.66397453224856e+45*cos(theta)**6 - 3.6608343094008e+44*cos(theta)**4 + 5.30555697014609e+42*cos(theta)**2 - 1.13124882092667e+40)*sin(26*phi)

@torch.jit.script
def Yl40_m_minus_25(theta, phi):
    return 1.4296747724489e-39*(1.0 - cos(theta)**2)**12.5*(6.10074983241483e+46*cos(theta)**15 - 8.10859154941211e+46*cos(theta)**13 + 4.10694896658536e+46*cos(theta)**11 - 1.00392085849864e+46*cos(theta)**9 + 1.23771064746408e+45*cos(theta)**7 - 7.3216686188016e+43*cos(theta)**5 + 1.7685189900487e+42*cos(theta)**3 - 1.13124882092667e+40*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl40_m_minus_24(theta, phi):
    return 4.61056260468926e-38*(1.0 - cos(theta)**2)**12*(3.81296864525927e+45*cos(theta)**16 - 5.79185110672294e+45*cos(theta)**14 + 3.42245747215446e+45*cos(theta)**12 - 1.00392085849864e+45*cos(theta)**10 + 1.5471383093301e+44*cos(theta)**8 - 1.2202781031336e+43*cos(theta)**6 + 4.42129747512174e+41*cos(theta)**4 - 5.65624410463335e+39*cos(theta)**2 + 1.08773925089103e+37)*sin(24*phi)

@torch.jit.script
def Yl40_m_minus_23(theta, phi):
    return 1.52078692901253e-36*(1.0 - cos(theta)**2)**11.5*(2.24292273250545e+44*cos(theta)**17 - 3.86123407114863e+44*cos(theta)**15 + 2.63265959396497e+44*cos(theta)**13 - 9.12655325907857e+43*cos(theta)**11 + 1.71904256592233e+43*cos(theta)**9 - 1.743254433048e+42*cos(theta)**7 + 8.84259495024348e+40*cos(theta)**5 - 1.88541470154445e+39*cos(theta)**3 + 1.08773925089103e+37*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl40_m_minus_22(theta, phi):
    return 5.12123728198411e-35*(1.0 - cos(theta)**2)**11*(1.24606818472525e+43*cos(theta)**18 - 2.41327129446789e+43*cos(theta)**16 + 1.88047113854641e+43*cos(theta)**14 - 7.60546104923214e+42*cos(theta)**12 + 1.71904256592233e+42*cos(theta)**10 - 2.17906804131e+41*cos(theta)**8 + 1.47376582504058e+40*cos(theta)**6 - 4.71353675386113e+38*cos(theta)**4 + 5.43869625445515e+36*cos(theta)**2 - 9.59205688616428e+33)*sin(22*phi)

@torch.jit.script
def Yl40_m_minus_21(theta, phi):
    return 1.75771129567675e-33*(1.0 - cos(theta)**2)**10.5*(6.55825360381711e+41*cos(theta)**19 - 1.41957134968699e+42*cos(theta)**17 + 1.25364742569761e+42*cos(theta)**15 - 5.85035465325549e+41*cos(theta)**13 + 1.5627659690203e+41*cos(theta)**11 - 2.42118671256667e+40*cos(theta)**9 + 2.10537975005797e+39*cos(theta)**7 - 9.42707350772226e+37*cos(theta)**5 + 1.81289875148505e+36*cos(theta)**3 - 9.59205688616428e+33*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl40_m_minus_20(theta, phi):
    return 6.13942161666598e-32*(1.0 - cos(theta)**2)**10*(3.27912680190856e+40*cos(theta)**20 - 7.88650749826108e+40*cos(theta)**18 + 7.83529641061004e+40*cos(theta)**16 - 4.17882475232535e+40*cos(theta)**14 + 1.30230497418359e+40*cos(theta)**12 - 2.42118671256667e+39*cos(theta)**10 + 2.63172468757246e+38*cos(theta)**8 - 1.57117891795371e+37*cos(theta)**6 + 4.53224687871262e+35*cos(theta)**4 - 4.79602844308214e+33*cos(theta)**2 + 7.86234170997073e+30)*sin(20*phi)

@torch.jit.script
def Yl40_m_minus_19(theta, phi):
    return 2.17927848637694e-30*(1.0 - cos(theta)**2)**9.5*(1.56148895328979e+39*cos(theta)**21 - 4.15079342013741e+39*cos(theta)**19 + 4.60899788859414e+39*cos(theta)**17 - 2.7858831682169e+39*cos(theta)**15 + 1.0017730570643e+39*cos(theta)**13 - 2.20107882960606e+38*cos(theta)**11 + 2.92413854174718e+37*cos(theta)**9 - 2.24454131136244e+36*cos(theta)**7 + 9.06449375742525e+34*cos(theta)**5 - 1.59867614769405e+33*cos(theta)**3 + 7.86234170997073e+30*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl40_m_minus_18(theta, phi):
    return 7.85145376863331e-29*(1.0 - cos(theta)**2)**9*(7.09767706040813e+37*cos(theta)**22 - 2.07539671006871e+38*cos(theta)**20 + 2.5605543825523e+38*cos(theta)**18 - 1.74117698013556e+38*cos(theta)**16 + 7.15552183617355e+37*cos(theta)**14 - 1.83423235800505e+37*cos(theta)**12 + 2.92413854174718e+36*cos(theta)**10 - 2.80567663920305e+35*cos(theta)**8 + 1.51074895957087e+34*cos(theta)**6 - 3.99669036923512e+32*cos(theta)**4 + 3.93117085498536e+30*cos(theta)**2 - 6.05727404466158e+27)*sin(18*phi)

@torch.jit.script
def Yl40_m_minus_17(theta, phi):
    return 2.86766220567966e-27*(1.0 - cos(theta)**2)**8.5*(3.08594654800353e+36*cos(theta)**23 - 9.88284147651765e+36*cos(theta)**21 + 1.34766020134332e+37*cos(theta)**19 - 1.02422175302092e+37*cos(theta)**17 + 4.77034789078237e+36*cos(theta)**15 - 1.41094796769619e+36*cos(theta)**13 + 2.65830776522471e+35*cos(theta)**11 - 3.11741848800339e+34*cos(theta)**9 + 2.15821279938696e+33*cos(theta)**7 - 7.99338073847024e+31*cos(theta)**5 + 1.31039028499512e+30*cos(theta)**3 - 6.05727404466158e+27*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl40_m_minus_16(theta, phi):
    return 1.0606474233886e-25*(1.0 - cos(theta)**2)**8*(1.28581106166814e+35*cos(theta)**24 - 4.49220067114438e+35*cos(theta)**22 + 6.73830100671658e+35*cos(theta)**20 - 5.69012085011622e+35*cos(theta)**18 + 2.98146743173898e+35*cos(theta)**16 - 1.00781997692585e+35*cos(theta)**14 + 2.21525647102059e+34*cos(theta)**12 - 3.11741848800339e+33*cos(theta)**10 + 2.6977659992337e+32*cos(theta)**8 - 1.33223012307837e+31*cos(theta)**6 + 3.2759757124878e+29*cos(theta)**4 - 3.02863702233079e+27*cos(theta)**2 + 4.42783190399238e+24)*sin(16*phi)

@torch.jit.script
def Yl40_m_minus_15(theta, phi):
    return 3.96857926648469e-24*(1.0 - cos(theta)**2)**7.5*(5.14324424667256e+33*cos(theta)**25 - 1.95313072658452e+34*cos(theta)**23 + 3.20871476510313e+34*cos(theta)**21 - 2.99480044742959e+34*cos(theta)**19 + 1.75380437161116e+34*cos(theta)**17 - 6.71879984617235e+33*cos(theta)**15 + 1.70404343924661e+33*cos(theta)**13 - 2.83401680727581e+32*cos(theta)**11 + 2.99751777692634e+31*cos(theta)**9 - 1.90318589011196e+30*cos(theta)**7 + 6.5519514249756e+28*cos(theta)**5 - 1.00954567411026e+27*cos(theta)**3 + 4.42783190399238e+24*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl40_m_minus_14(theta, phi):
    return 1.5007317746337e-22*(1.0 - cos(theta)**2)**7*(1.97817086410483e+32*cos(theta)**26 - 8.13804469410215e+32*cos(theta)**24 + 1.45850671141051e+33*cos(theta)**22 - 1.49740022371479e+33*cos(theta)**20 + 9.74335762006202e+32*cos(theta)**18 - 4.19924990385772e+32*cos(theta)**16 + 1.21717388517615e+32*cos(theta)**14 - 2.36168067272984e+31*cos(theta)**12 + 2.99751777692634e+30*cos(theta)**10 - 2.37898236263995e+29*cos(theta)**8 + 1.0919919041626e+28*cos(theta)**6 - 2.52386418527566e+26*cos(theta)**4 + 2.21391595199619e+24*cos(theta)**2 - 3.09638594684782e+21)*sin(14*phi)

@torch.jit.script
def Yl40_m_minus_13(theta, phi):
    return 5.73035911876231e-21*(1.0 - cos(theta)**2)**6.5*(7.32655875594381e+30*cos(theta)**27 - 3.25521787764086e+31*cos(theta)**25 + 6.3413335278718e+31*cos(theta)**23 - 7.13047725578474e+31*cos(theta)**21 + 5.12808295792738e+31*cos(theta)**19 - 2.47014700226924e+31*cos(theta)**17 + 8.114492567841e+30*cos(theta)**15 - 1.81667744056142e+30*cos(theta)**13 + 2.72501616084213e+29*cos(theta)**11 - 2.64331373626661e+28*cos(theta)**9 + 1.559988434518e+27*cos(theta)**7 - 5.04772837055131e+25*cos(theta)**5 + 7.3797198399873e+23*cos(theta)**3 - 3.09638594684782e+21*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl40_m_minus_12(theta, phi):
    return 2.20749023089331e-19*(1.0 - cos(theta)**2)**6*(2.61662812712279e+29*cos(theta)**28 - 1.25200687601571e+30*cos(theta)**26 + 2.64222230327992e+30*cos(theta)**24 - 3.2411260253567e+30*cos(theta)**22 + 2.56404147896369e+30*cos(theta)**20 - 1.37230389014958e+30*cos(theta)**18 + 5.07155785490062e+29*cos(theta)**16 - 1.29762674325816e+29*cos(theta)**14 + 2.27084680070177e+28*cos(theta)**12 - 2.64331373626661e+27*cos(theta)**10 + 1.9499855431475e+26*cos(theta)**8 - 8.41288061758552e+24*cos(theta)**6 + 1.84492995999682e+23*cos(theta)**4 - 1.54819297342391e+21*cos(theta)**2 + 2.08651344127211e+18)*sin(12*phi)

@torch.jit.script
def Yl40_m_minus_11(theta, phi):
    return 8.5723414445471e-18*(1.0 - cos(theta)**2)**5.5*(9.02285561076824e+27*cos(theta)**29 - 4.63706250376191e+28*cos(theta)**27 + 1.05688892131197e+29*cos(theta)**25 - 1.40918522841596e+29*cos(theta)**23 + 1.22097213283985e+29*cos(theta)**21 - 7.22265205341884e+28*cos(theta)**19 + 2.98326932641213e+28*cos(theta)**17 - 8.65084495505437e+27*cos(theta)**15 + 1.74680523130906e+27*cos(theta)**13 - 2.4030124875151e+26*cos(theta)**11 + 2.16665060349722e+25*cos(theta)**9 - 1.2018400882265e+24*cos(theta)**7 + 3.68985991999365e+22*cos(theta)**5 - 5.16064324474636e+20*cos(theta)**3 + 2.08651344127211e+18*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl40_m_minus_10(theta, phi):
    return 3.35308973781059e-16*(1.0 - cos(theta)**2)**5*(3.00761853692275e+26*cos(theta)**30 - 1.65609375134354e+27*cos(theta)**28 + 4.06495738966141e+27*cos(theta)**26 - 5.87160511839982e+27*cos(theta)**24 + 5.54987333109024e+27*cos(theta)**22 - 3.61132602670942e+27*cos(theta)**20 + 1.65737184800674e+27*cos(theta)**18 - 5.40677809690898e+26*cos(theta)**16 + 1.24771802236361e+26*cos(theta)**14 - 2.00251040626259e+25*cos(theta)**12 + 2.16665060349722e+24*cos(theta)**10 - 1.50230011028313e+23*cos(theta)**8 + 6.14976653332275e+21*cos(theta)**6 - 1.29016081118659e+20*cos(theta)**4 + 1.04325672063606e+18*cos(theta)**2 - 1.36373427534125e+15)*sin(10*phi)

@torch.jit.script
def Yl40_m_minus_9(theta, phi):
    return 1.32011274988944e-14*(1.0 - cos(theta)**2)**4.5*(9.70199528039596e+24*cos(theta)**31 - 5.71066810808117e+25*cos(theta)**29 + 1.50553977394867e+26*cos(theta)**27 - 2.34864204735993e+26*cos(theta)**25 + 2.41298840482184e+26*cos(theta)**23 - 1.71967906033782e+26*cos(theta)**21 + 8.72300972635126e+25*cos(theta)**19 - 3.18045770406411e+25*cos(theta)**17 + 8.31812014909074e+24*cos(theta)**15 - 1.54039262020199e+24*cos(theta)**13 + 1.96968236681566e+23*cos(theta)**11 - 1.66922234475903e+22*cos(theta)**9 + 8.78538076188964e+20*cos(theta)**7 - 2.58032162237318e+19*cos(theta)**5 + 3.47752240212019e+17*cos(theta)**3 - 1.36373427534125e+15*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl40_m_minus_8(theta, phi):
    return 5.2273797933148e-13*(1.0 - cos(theta)**2)**4*(3.03187352512374e+23*cos(theta)**32 - 1.90355603602706e+24*cos(theta)**30 + 5.3769277641024e+24*cos(theta)**28 - 9.03323864369203e+24*cos(theta)**26 + 1.00541183534243e+25*cos(theta)**24 - 7.81672300153555e+24*cos(theta)**22 + 4.36150486317563e+24*cos(theta)**20 - 1.76692094670228e+24*cos(theta)**18 + 5.19882509318171e+23*cos(theta)**16 - 1.10028044300142e+23*cos(theta)**14 + 1.64140197234638e+22*cos(theta)**12 - 1.66922234475903e+21*cos(theta)**10 + 1.09817259523621e+20*cos(theta)**8 - 4.30053603728864e+18*cos(theta)**6 + 8.69380600530048e+16*cos(theta)**4 - 681867137670626.0*cos(theta)**2 + 869728491926.818)*sin(8*phi)

@torch.jit.script
def Yl40_m_minus_7(theta, phi):
    return 2.08047088933329e-11*(1.0 - cos(theta)**2)**3.5*(9.18749553067799e+21*cos(theta)**33 - 6.14050334202276e+22*cos(theta)**31 + 1.85411302210427e+23*cos(theta)**29 - 3.34564394210816e+23*cos(theta)**27 + 4.02164734136974e+23*cos(theta)**25 - 3.39857521805893e+23*cos(theta)**23 + 2.07690707770268e+23*cos(theta)**21 - 9.29958393001201e+22*cos(theta)**19 + 3.05813240775395e+22*cos(theta)**17 - 7.3352029533428e+21*cos(theta)**15 + 1.26261690180491e+21*cos(theta)**13 - 1.51747485887185e+20*cos(theta)**11 + 1.22019177248467e+19*cos(theta)**9 - 6.14362291041234e+17*cos(theta)**7 + 1.7387612010601e+16*cos(theta)**5 - 227289045890209.0*cos(theta)**3 + 869728491926.818*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl40_m_minus_6(theta, phi):
    return 8.31668075372529e-10*(1.0 - cos(theta)**2)**3*(2.70220456784647e+20*cos(theta)**34 - 1.91890729438211e+21*cos(theta)**32 + 6.18037674034758e+21*cos(theta)**30 - 1.1948728364672e+22*cos(theta)**28 + 1.54678743898836e+22*cos(theta)**26 - 1.41607300752456e+22*cos(theta)**24 + 9.44048671683037e+21*cos(theta)**22 - 4.649791965006e+21*cos(theta)**20 + 1.69896244875219e+21*cos(theta)**18 - 4.58450184583925e+20*cos(theta)**16 + 9.01869215574935e+19*cos(theta)**14 - 1.26456238239321e+19*cos(theta)**12 + 1.22019177248467e+18*cos(theta)**10 - 7.67952863801542e+16*cos(theta)**8 + 2.89793533510016e+15*cos(theta)**6 - 56822261472552.1*cos(theta)**4 + 434864245963.409*cos(theta)**2 - 544260633.245819)*sin(6*phi)

@torch.jit.script
def Yl40_m_minus_5(theta, phi):
    return 3.33705195947875e-8*(1.0 - cos(theta)**2)**2.5*(7.72058447956134e+18*cos(theta)**35 - 5.8148705890367e+19*cos(theta)**33 + 1.99366991624116e+20*cos(theta)**31 - 4.12025116023172e+20*cos(theta)**29 + 5.72884236662356e+20*cos(theta)**27 - 5.66429203009822e+20*cos(theta)**25 + 4.10455944210016e+20*cos(theta)**23 - 2.21418665000286e+20*cos(theta)**21 + 8.94190762501155e+19*cos(theta)**19 - 2.69676579167015e+19*cos(theta)**17 + 6.01246143716623e+18*cos(theta)**15 - 9.7274029414862e+17*cos(theta)**13 + 1.10926524771334e+17*cos(theta)**11 - 8.53280959779491e+15*cos(theta)**9 + 413990762157166.0*cos(theta)**7 - 11364452294510.4*cos(theta)**5 + 144954748654.47*cos(theta)**3 - 544260633.245819*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl40_m_minus_4(theta, phi):
    return 1.3431375046518e-6*(1.0 - cos(theta)**2)**2*(2.14460679987815e+17*cos(theta)**36 - 1.71025605559903e+18*cos(theta)**34 + 6.23021848825361e+18*cos(theta)**32 - 1.37341705341057e+19*cos(theta)**30 + 2.04601513093699e+19*cos(theta)**28 - 2.17857385773009e+19*cos(theta)**26 + 1.71023310087507e+19*cos(theta)**24 - 1.00644847727403e+19*cos(theta)**22 + 4.47095381250577e+18*cos(theta)**20 - 1.49820321759453e+18*cos(theta)**18 + 3.7577883982289e+17*cos(theta)**16 - 6.94814495820443e+16*cos(theta)**14 + 9.24387706427782e+15*cos(theta)**12 - 853280959779491.0*cos(theta)**10 + 51748845269645.7*cos(theta)**8 - 1894075382418.4*cos(theta)**6 + 36238687163.6174*cos(theta)**4 - 272130316.622909*cos(theta)**2 + 335963.353855444)*sin(4*phi)

@torch.jit.script
def Yl40_m_minus_3(theta, phi):
    return 5.41935594348895e-5*(1.0 - cos(theta)**2)**1.5*(5.79623459426527e+15*cos(theta)**37 - 4.88644587314009e+16*cos(theta)**35 + 1.88794499644049e+17*cos(theta)**33 - 4.43037759164701e+17*cos(theta)**31 + 7.05522458943788e+17*cos(theta)**29 - 8.06879206566698e+17*cos(theta)**27 + 6.84093240350027e+17*cos(theta)**25 - 4.37586294466968e+17*cos(theta)**23 + 2.12902562500275e+17*cos(theta)**21 - 7.88528009260277e+16*cos(theta)**19 + 2.21046376366406e+16*cos(theta)**17 - 4.63209663880295e+15*cos(theta)**15 + 711067466482909.0*cos(theta)**13 - 77570996343590.1*cos(theta)**11 + 5749871696627.3*cos(theta)**9 - 270582197488.344*cos(theta)**7 + 7247737432.72349*cos(theta)**5 - 90710105.5409698*cos(theta)**3 + 335963.353855444*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl40_m_minus_2(theta, phi):
    return 0.00219065356430911*(1.0 - cos(theta)**2)*(152532489322770.0*cos(theta)**38 - 1.35734607587225e+15*cos(theta)**36 + 5.55277940129555e+15*cos(theta)**34 - 1.38449299738969e+16*cos(theta)**32 + 2.35174152981263e+16*cos(theta)**30 - 2.88171145202392e+16*cos(theta)**28 + 2.6311278475001e+16*cos(theta)**26 - 1.8232762269457e+16*cos(theta)**24 + 9.67738920455795e+15*cos(theta)**22 - 3.94264004630139e+15*cos(theta)**20 + 1.22803542425781e+15*cos(theta)**18 - 289506039925185.0*cos(theta)**16 + 50790533320207.8*cos(theta)**14 - 6464249695299.18*cos(theta)**12 + 574987169662.73*cos(theta)**10 - 33822774686.0429*cos(theta)**8 + 1207956238.78725*cos(theta)**6 - 22677526.3852425*cos(theta)**4 + 167981.676927722*cos(theta)**2 - 205.60792769611)*sin(2*phi)

@torch.jit.script
def Yl40_m_minus_1(theta, phi):
    return 0.0886605969841593*(1.0 - cos(theta)**2)**0.5*(3911089469814.62*cos(theta)**39 - 36685029077628.3*cos(theta)**37 + 158650840037016.0*cos(theta)**35 - 419543332542331.0*cos(theta)**33 + 758626299939557.0*cos(theta)**31 - 993693604146180.0*cos(theta)**29 + 974491795370409.0*cos(theta)**27 - 729310490778280.0*cos(theta)**25 + 420756052372085.0*cos(theta)**23 - 187744764109590.0*cos(theta)**21 + 64633443381989.9*cos(theta)**19 - 17029767054422.6*cos(theta)**17 + 3386035554680.52*cos(theta)**15 - 497249976561.475*cos(theta)**13 + 52271560878.43*cos(theta)**11 - 3758086076.22699*cos(theta)**9 + 172565176.969607*cos(theta)**7 - 4535505.27704849*cos(theta)**5 + 55993.8923092406*cos(theta)**3 - 205.60792769611*cos(theta))*sin(phi)

@torch.jit.script
def Yl40_m0(theta, phi):
    return 248242043159.182*cos(theta)**40 - 2450997388153.95*cos(theta)**38 + 11188643921248.2*cos(theta)**36 - 31328202979495.0*cos(theta)**34 + 60188773532522.9*cos(theta)**32 - 84094737104595.4*cos(theta)**30 + 88360412175118.3*cos(theta)**28 - 71215854588901.3*cos(theta)**26 + 44509909118063.3*cos(theta)**24 - 21666199147417.1*cos(theta)**22 + 8204740988612.04*cos(theta)**20 - 2402004295587.5*cos(theta)**18 + 537290434539.309*cos(theta)**16 - 90174618384.2197*cos(theta)**14 + 11059151311.2722*cos(theta)**12 - 954122858.227408*cos(theta)**10 + 54764704.8727466*cos(theta)**8 - 1919163.62507748*cos(theta)**6 + 35540.0671310644*cos(theta)**4 - 261.004164977217*cos(theta)**2 + 0.318297762167338

@torch.jit.script
def Yl40_m1(theta, phi):
    return 0.0886605969841593*(1.0 - cos(theta)**2)**0.5*(3911089469814.62*cos(theta)**39 - 36685029077628.3*cos(theta)**37 + 158650840037016.0*cos(theta)**35 - 419543332542331.0*cos(theta)**33 + 758626299939557.0*cos(theta)**31 - 993693604146180.0*cos(theta)**29 + 974491795370409.0*cos(theta)**27 - 729310490778280.0*cos(theta)**25 + 420756052372085.0*cos(theta)**23 - 187744764109590.0*cos(theta)**21 + 64633443381989.9*cos(theta)**19 - 17029767054422.6*cos(theta)**17 + 3386035554680.52*cos(theta)**15 - 497249976561.475*cos(theta)**13 + 52271560878.43*cos(theta)**11 - 3758086076.22699*cos(theta)**9 + 172565176.969607*cos(theta)**7 - 4535505.27704849*cos(theta)**5 + 55993.8923092406*cos(theta)**3 - 205.60792769611*cos(theta))*cos(phi)

@torch.jit.script
def Yl40_m2(theta, phi):
    return 0.00219065356430911*(1.0 - cos(theta)**2)*(152532489322770.0*cos(theta)**38 - 1.35734607587225e+15*cos(theta)**36 + 5.55277940129555e+15*cos(theta)**34 - 1.38449299738969e+16*cos(theta)**32 + 2.35174152981263e+16*cos(theta)**30 - 2.88171145202392e+16*cos(theta)**28 + 2.6311278475001e+16*cos(theta)**26 - 1.8232762269457e+16*cos(theta)**24 + 9.67738920455795e+15*cos(theta)**22 - 3.94264004630139e+15*cos(theta)**20 + 1.22803542425781e+15*cos(theta)**18 - 289506039925185.0*cos(theta)**16 + 50790533320207.8*cos(theta)**14 - 6464249695299.18*cos(theta)**12 + 574987169662.73*cos(theta)**10 - 33822774686.0429*cos(theta)**8 + 1207956238.78725*cos(theta)**6 - 22677526.3852425*cos(theta)**4 + 167981.676927722*cos(theta)**2 - 205.60792769611)*cos(2*phi)

@torch.jit.script
def Yl40_m3(theta, phi):
    return 5.41935594348895e-5*(1.0 - cos(theta)**2)**1.5*(5.79623459426527e+15*cos(theta)**37 - 4.88644587314009e+16*cos(theta)**35 + 1.88794499644049e+17*cos(theta)**33 - 4.43037759164701e+17*cos(theta)**31 + 7.05522458943788e+17*cos(theta)**29 - 8.06879206566698e+17*cos(theta)**27 + 6.84093240350027e+17*cos(theta)**25 - 4.37586294466968e+17*cos(theta)**23 + 2.12902562500275e+17*cos(theta)**21 - 7.88528009260277e+16*cos(theta)**19 + 2.21046376366406e+16*cos(theta)**17 - 4.63209663880295e+15*cos(theta)**15 + 711067466482909.0*cos(theta)**13 - 77570996343590.1*cos(theta)**11 + 5749871696627.3*cos(theta)**9 - 270582197488.344*cos(theta)**7 + 7247737432.72349*cos(theta)**5 - 90710105.5409698*cos(theta)**3 + 335963.353855444*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl40_m4(theta, phi):
    return 1.3431375046518e-6*(1.0 - cos(theta)**2)**2*(2.14460679987815e+17*cos(theta)**36 - 1.71025605559903e+18*cos(theta)**34 + 6.23021848825361e+18*cos(theta)**32 - 1.37341705341057e+19*cos(theta)**30 + 2.04601513093699e+19*cos(theta)**28 - 2.17857385773009e+19*cos(theta)**26 + 1.71023310087507e+19*cos(theta)**24 - 1.00644847727403e+19*cos(theta)**22 + 4.47095381250577e+18*cos(theta)**20 - 1.49820321759453e+18*cos(theta)**18 + 3.7577883982289e+17*cos(theta)**16 - 6.94814495820443e+16*cos(theta)**14 + 9.24387706427782e+15*cos(theta)**12 - 853280959779491.0*cos(theta)**10 + 51748845269645.7*cos(theta)**8 - 1894075382418.4*cos(theta)**6 + 36238687163.6174*cos(theta)**4 - 272130316.622909*cos(theta)**2 + 335963.353855444)*cos(4*phi)

@torch.jit.script
def Yl40_m5(theta, phi):
    return 3.33705195947875e-8*(1.0 - cos(theta)**2)**2.5*(7.72058447956134e+18*cos(theta)**35 - 5.8148705890367e+19*cos(theta)**33 + 1.99366991624116e+20*cos(theta)**31 - 4.12025116023172e+20*cos(theta)**29 + 5.72884236662356e+20*cos(theta)**27 - 5.66429203009822e+20*cos(theta)**25 + 4.10455944210016e+20*cos(theta)**23 - 2.21418665000286e+20*cos(theta)**21 + 8.94190762501155e+19*cos(theta)**19 - 2.69676579167015e+19*cos(theta)**17 + 6.01246143716623e+18*cos(theta)**15 - 9.7274029414862e+17*cos(theta)**13 + 1.10926524771334e+17*cos(theta)**11 - 8.53280959779491e+15*cos(theta)**9 + 413990762157166.0*cos(theta)**7 - 11364452294510.4*cos(theta)**5 + 144954748654.47*cos(theta)**3 - 544260633.245819*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl40_m6(theta, phi):
    return 8.31668075372529e-10*(1.0 - cos(theta)**2)**3*(2.70220456784647e+20*cos(theta)**34 - 1.91890729438211e+21*cos(theta)**32 + 6.18037674034758e+21*cos(theta)**30 - 1.1948728364672e+22*cos(theta)**28 + 1.54678743898836e+22*cos(theta)**26 - 1.41607300752456e+22*cos(theta)**24 + 9.44048671683037e+21*cos(theta)**22 - 4.649791965006e+21*cos(theta)**20 + 1.69896244875219e+21*cos(theta)**18 - 4.58450184583925e+20*cos(theta)**16 + 9.01869215574935e+19*cos(theta)**14 - 1.26456238239321e+19*cos(theta)**12 + 1.22019177248467e+18*cos(theta)**10 - 7.67952863801542e+16*cos(theta)**8 + 2.89793533510016e+15*cos(theta)**6 - 56822261472552.1*cos(theta)**4 + 434864245963.409*cos(theta)**2 - 544260633.245819)*cos(6*phi)

@torch.jit.script
def Yl40_m7(theta, phi):
    return 2.08047088933329e-11*(1.0 - cos(theta)**2)**3.5*(9.18749553067799e+21*cos(theta)**33 - 6.14050334202276e+22*cos(theta)**31 + 1.85411302210427e+23*cos(theta)**29 - 3.34564394210816e+23*cos(theta)**27 + 4.02164734136974e+23*cos(theta)**25 - 3.39857521805893e+23*cos(theta)**23 + 2.07690707770268e+23*cos(theta)**21 - 9.29958393001201e+22*cos(theta)**19 + 3.05813240775395e+22*cos(theta)**17 - 7.3352029533428e+21*cos(theta)**15 + 1.26261690180491e+21*cos(theta)**13 - 1.51747485887185e+20*cos(theta)**11 + 1.22019177248467e+19*cos(theta)**9 - 6.14362291041234e+17*cos(theta)**7 + 1.7387612010601e+16*cos(theta)**5 - 227289045890209.0*cos(theta)**3 + 869728491926.818*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl40_m8(theta, phi):
    return 5.2273797933148e-13*(1.0 - cos(theta)**2)**4*(3.03187352512374e+23*cos(theta)**32 - 1.90355603602706e+24*cos(theta)**30 + 5.3769277641024e+24*cos(theta)**28 - 9.03323864369203e+24*cos(theta)**26 + 1.00541183534243e+25*cos(theta)**24 - 7.81672300153555e+24*cos(theta)**22 + 4.36150486317563e+24*cos(theta)**20 - 1.76692094670228e+24*cos(theta)**18 + 5.19882509318171e+23*cos(theta)**16 - 1.10028044300142e+23*cos(theta)**14 + 1.64140197234638e+22*cos(theta)**12 - 1.66922234475903e+21*cos(theta)**10 + 1.09817259523621e+20*cos(theta)**8 - 4.30053603728864e+18*cos(theta)**6 + 8.69380600530048e+16*cos(theta)**4 - 681867137670626.0*cos(theta)**2 + 869728491926.818)*cos(8*phi)

@torch.jit.script
def Yl40_m9(theta, phi):
    return 1.32011274988944e-14*(1.0 - cos(theta)**2)**4.5*(9.70199528039596e+24*cos(theta)**31 - 5.71066810808117e+25*cos(theta)**29 + 1.50553977394867e+26*cos(theta)**27 - 2.34864204735993e+26*cos(theta)**25 + 2.41298840482184e+26*cos(theta)**23 - 1.71967906033782e+26*cos(theta)**21 + 8.72300972635126e+25*cos(theta)**19 - 3.18045770406411e+25*cos(theta)**17 + 8.31812014909074e+24*cos(theta)**15 - 1.54039262020199e+24*cos(theta)**13 + 1.96968236681566e+23*cos(theta)**11 - 1.66922234475903e+22*cos(theta)**9 + 8.78538076188964e+20*cos(theta)**7 - 2.58032162237318e+19*cos(theta)**5 + 3.47752240212019e+17*cos(theta)**3 - 1.36373427534125e+15*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl40_m10(theta, phi):
    return 3.35308973781059e-16*(1.0 - cos(theta)**2)**5*(3.00761853692275e+26*cos(theta)**30 - 1.65609375134354e+27*cos(theta)**28 + 4.06495738966141e+27*cos(theta)**26 - 5.87160511839982e+27*cos(theta)**24 + 5.54987333109024e+27*cos(theta)**22 - 3.61132602670942e+27*cos(theta)**20 + 1.65737184800674e+27*cos(theta)**18 - 5.40677809690898e+26*cos(theta)**16 + 1.24771802236361e+26*cos(theta)**14 - 2.00251040626259e+25*cos(theta)**12 + 2.16665060349722e+24*cos(theta)**10 - 1.50230011028313e+23*cos(theta)**8 + 6.14976653332275e+21*cos(theta)**6 - 1.29016081118659e+20*cos(theta)**4 + 1.04325672063606e+18*cos(theta)**2 - 1.36373427534125e+15)*cos(10*phi)

@torch.jit.script
def Yl40_m11(theta, phi):
    return 8.5723414445471e-18*(1.0 - cos(theta)**2)**5.5*(9.02285561076824e+27*cos(theta)**29 - 4.63706250376191e+28*cos(theta)**27 + 1.05688892131197e+29*cos(theta)**25 - 1.40918522841596e+29*cos(theta)**23 + 1.22097213283985e+29*cos(theta)**21 - 7.22265205341884e+28*cos(theta)**19 + 2.98326932641213e+28*cos(theta)**17 - 8.65084495505437e+27*cos(theta)**15 + 1.74680523130906e+27*cos(theta)**13 - 2.4030124875151e+26*cos(theta)**11 + 2.16665060349722e+25*cos(theta)**9 - 1.2018400882265e+24*cos(theta)**7 + 3.68985991999365e+22*cos(theta)**5 - 5.16064324474636e+20*cos(theta)**3 + 2.08651344127211e+18*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl40_m12(theta, phi):
    return 2.20749023089331e-19*(1.0 - cos(theta)**2)**6*(2.61662812712279e+29*cos(theta)**28 - 1.25200687601571e+30*cos(theta)**26 + 2.64222230327992e+30*cos(theta)**24 - 3.2411260253567e+30*cos(theta)**22 + 2.56404147896369e+30*cos(theta)**20 - 1.37230389014958e+30*cos(theta)**18 + 5.07155785490062e+29*cos(theta)**16 - 1.29762674325816e+29*cos(theta)**14 + 2.27084680070177e+28*cos(theta)**12 - 2.64331373626661e+27*cos(theta)**10 + 1.9499855431475e+26*cos(theta)**8 - 8.41288061758552e+24*cos(theta)**6 + 1.84492995999682e+23*cos(theta)**4 - 1.54819297342391e+21*cos(theta)**2 + 2.08651344127211e+18)*cos(12*phi)

@torch.jit.script
def Yl40_m13(theta, phi):
    return 5.73035911876231e-21*(1.0 - cos(theta)**2)**6.5*(7.32655875594381e+30*cos(theta)**27 - 3.25521787764086e+31*cos(theta)**25 + 6.3413335278718e+31*cos(theta)**23 - 7.13047725578474e+31*cos(theta)**21 + 5.12808295792738e+31*cos(theta)**19 - 2.47014700226924e+31*cos(theta)**17 + 8.114492567841e+30*cos(theta)**15 - 1.81667744056142e+30*cos(theta)**13 + 2.72501616084213e+29*cos(theta)**11 - 2.64331373626661e+28*cos(theta)**9 + 1.559988434518e+27*cos(theta)**7 - 5.04772837055131e+25*cos(theta)**5 + 7.3797198399873e+23*cos(theta)**3 - 3.09638594684782e+21*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl40_m14(theta, phi):
    return 1.5007317746337e-22*(1.0 - cos(theta)**2)**7*(1.97817086410483e+32*cos(theta)**26 - 8.13804469410215e+32*cos(theta)**24 + 1.45850671141051e+33*cos(theta)**22 - 1.49740022371479e+33*cos(theta)**20 + 9.74335762006202e+32*cos(theta)**18 - 4.19924990385772e+32*cos(theta)**16 + 1.21717388517615e+32*cos(theta)**14 - 2.36168067272984e+31*cos(theta)**12 + 2.99751777692634e+30*cos(theta)**10 - 2.37898236263995e+29*cos(theta)**8 + 1.0919919041626e+28*cos(theta)**6 - 2.52386418527566e+26*cos(theta)**4 + 2.21391595199619e+24*cos(theta)**2 - 3.09638594684782e+21)*cos(14*phi)

@torch.jit.script
def Yl40_m15(theta, phi):
    return 3.96857926648469e-24*(1.0 - cos(theta)**2)**7.5*(5.14324424667256e+33*cos(theta)**25 - 1.95313072658452e+34*cos(theta)**23 + 3.20871476510313e+34*cos(theta)**21 - 2.99480044742959e+34*cos(theta)**19 + 1.75380437161116e+34*cos(theta)**17 - 6.71879984617235e+33*cos(theta)**15 + 1.70404343924661e+33*cos(theta)**13 - 2.83401680727581e+32*cos(theta)**11 + 2.99751777692634e+31*cos(theta)**9 - 1.90318589011196e+30*cos(theta)**7 + 6.5519514249756e+28*cos(theta)**5 - 1.00954567411026e+27*cos(theta)**3 + 4.42783190399238e+24*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl40_m16(theta, phi):
    return 1.0606474233886e-25*(1.0 - cos(theta)**2)**8*(1.28581106166814e+35*cos(theta)**24 - 4.49220067114438e+35*cos(theta)**22 + 6.73830100671658e+35*cos(theta)**20 - 5.69012085011622e+35*cos(theta)**18 + 2.98146743173898e+35*cos(theta)**16 - 1.00781997692585e+35*cos(theta)**14 + 2.21525647102059e+34*cos(theta)**12 - 3.11741848800339e+33*cos(theta)**10 + 2.6977659992337e+32*cos(theta)**8 - 1.33223012307837e+31*cos(theta)**6 + 3.2759757124878e+29*cos(theta)**4 - 3.02863702233079e+27*cos(theta)**2 + 4.42783190399238e+24)*cos(16*phi)

@torch.jit.script
def Yl40_m17(theta, phi):
    return 2.86766220567966e-27*(1.0 - cos(theta)**2)**8.5*(3.08594654800353e+36*cos(theta)**23 - 9.88284147651765e+36*cos(theta)**21 + 1.34766020134332e+37*cos(theta)**19 - 1.02422175302092e+37*cos(theta)**17 + 4.77034789078237e+36*cos(theta)**15 - 1.41094796769619e+36*cos(theta)**13 + 2.65830776522471e+35*cos(theta)**11 - 3.11741848800339e+34*cos(theta)**9 + 2.15821279938696e+33*cos(theta)**7 - 7.99338073847024e+31*cos(theta)**5 + 1.31039028499512e+30*cos(theta)**3 - 6.05727404466158e+27*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl40_m18(theta, phi):
    return 7.85145376863331e-29*(1.0 - cos(theta)**2)**9*(7.09767706040813e+37*cos(theta)**22 - 2.07539671006871e+38*cos(theta)**20 + 2.5605543825523e+38*cos(theta)**18 - 1.74117698013556e+38*cos(theta)**16 + 7.15552183617355e+37*cos(theta)**14 - 1.83423235800505e+37*cos(theta)**12 + 2.92413854174718e+36*cos(theta)**10 - 2.80567663920305e+35*cos(theta)**8 + 1.51074895957087e+34*cos(theta)**6 - 3.99669036923512e+32*cos(theta)**4 + 3.93117085498536e+30*cos(theta)**2 - 6.05727404466158e+27)*cos(18*phi)

@torch.jit.script
def Yl40_m19(theta, phi):
    return 2.17927848637694e-30*(1.0 - cos(theta)**2)**9.5*(1.56148895328979e+39*cos(theta)**21 - 4.15079342013741e+39*cos(theta)**19 + 4.60899788859414e+39*cos(theta)**17 - 2.7858831682169e+39*cos(theta)**15 + 1.0017730570643e+39*cos(theta)**13 - 2.20107882960606e+38*cos(theta)**11 + 2.92413854174718e+37*cos(theta)**9 - 2.24454131136244e+36*cos(theta)**7 + 9.06449375742525e+34*cos(theta)**5 - 1.59867614769405e+33*cos(theta)**3 + 7.86234170997073e+30*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl40_m20(theta, phi):
    return 6.13942161666598e-32*(1.0 - cos(theta)**2)**10*(3.27912680190856e+40*cos(theta)**20 - 7.88650749826108e+40*cos(theta)**18 + 7.83529641061004e+40*cos(theta)**16 - 4.17882475232535e+40*cos(theta)**14 + 1.30230497418359e+40*cos(theta)**12 - 2.42118671256667e+39*cos(theta)**10 + 2.63172468757246e+38*cos(theta)**8 - 1.57117891795371e+37*cos(theta)**6 + 4.53224687871262e+35*cos(theta)**4 - 4.79602844308214e+33*cos(theta)**2 + 7.86234170997073e+30)*cos(20*phi)

@torch.jit.script
def Yl40_m21(theta, phi):
    return 1.75771129567675e-33*(1.0 - cos(theta)**2)**10.5*(6.55825360381711e+41*cos(theta)**19 - 1.41957134968699e+42*cos(theta)**17 + 1.25364742569761e+42*cos(theta)**15 - 5.85035465325549e+41*cos(theta)**13 + 1.5627659690203e+41*cos(theta)**11 - 2.42118671256667e+40*cos(theta)**9 + 2.10537975005797e+39*cos(theta)**7 - 9.42707350772226e+37*cos(theta)**5 + 1.81289875148505e+36*cos(theta)**3 - 9.59205688616428e+33*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl40_m22(theta, phi):
    return 5.12123728198411e-35*(1.0 - cos(theta)**2)**11*(1.24606818472525e+43*cos(theta)**18 - 2.41327129446789e+43*cos(theta)**16 + 1.88047113854641e+43*cos(theta)**14 - 7.60546104923214e+42*cos(theta)**12 + 1.71904256592233e+42*cos(theta)**10 - 2.17906804131e+41*cos(theta)**8 + 1.47376582504058e+40*cos(theta)**6 - 4.71353675386113e+38*cos(theta)**4 + 5.43869625445515e+36*cos(theta)**2 - 9.59205688616428e+33)*cos(22*phi)

@torch.jit.script
def Yl40_m23(theta, phi):
    return 1.52078692901253e-36*(1.0 - cos(theta)**2)**11.5*(2.24292273250545e+44*cos(theta)**17 - 3.86123407114863e+44*cos(theta)**15 + 2.63265959396497e+44*cos(theta)**13 - 9.12655325907857e+43*cos(theta)**11 + 1.71904256592233e+43*cos(theta)**9 - 1.743254433048e+42*cos(theta)**7 + 8.84259495024348e+40*cos(theta)**5 - 1.88541470154445e+39*cos(theta)**3 + 1.08773925089103e+37*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl40_m24(theta, phi):
    return 4.61056260468926e-38*(1.0 - cos(theta)**2)**12*(3.81296864525927e+45*cos(theta)**16 - 5.79185110672294e+45*cos(theta)**14 + 3.42245747215446e+45*cos(theta)**12 - 1.00392085849864e+45*cos(theta)**10 + 1.5471383093301e+44*cos(theta)**8 - 1.2202781031336e+43*cos(theta)**6 + 4.42129747512174e+41*cos(theta)**4 - 5.65624410463335e+39*cos(theta)**2 + 1.08773925089103e+37)*cos(24*phi)

@torch.jit.script
def Yl40_m25(theta, phi):
    return 1.4296747724489e-39*(1.0 - cos(theta)**2)**12.5*(6.10074983241483e+46*cos(theta)**15 - 8.10859154941211e+46*cos(theta)**13 + 4.10694896658536e+46*cos(theta)**11 - 1.00392085849864e+46*cos(theta)**9 + 1.23771064746408e+45*cos(theta)**7 - 7.3216686188016e+43*cos(theta)**5 + 1.7685189900487e+42*cos(theta)**3 - 1.13124882092667e+40*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl40_m26(theta, phi):
    return 4.54380470106078e-41*(1.0 - cos(theta)**2)**13*(9.15112474862224e+47*cos(theta)**14 - 1.05411690142357e+48*cos(theta)**12 + 4.51764386324389e+47*cos(theta)**10 - 9.03528772648778e+46*cos(theta)**8 + 8.66397453224856e+45*cos(theta)**6 - 3.6608343094008e+44*cos(theta)**4 + 5.30555697014609e+42*cos(theta)**2 - 1.13124882092667e+40)*cos(26*phi)

@torch.jit.script
def Yl40_m27(theta, phi):
    return 1.48360482591054e-42*(1.0 - cos(theta)**2)**13.5*(1.28115746480711e+49*cos(theta)**13 - 1.26494028170829e+49*cos(theta)**11 + 4.51764386324389e+48*cos(theta)**9 - 7.22823018119023e+47*cos(theta)**7 + 5.19838471934914e+46*cos(theta)**5 - 1.46433372376032e+45*cos(theta)**3 + 1.06111139402922e+43*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl40_m28(theta, phi):
    return 4.98990301715827e-44*(1.0 - cos(theta)**2)**14*(1.66550470424925e+50*cos(theta)**12 - 1.39143430987912e+50*cos(theta)**10 + 4.0658794769195e+49*cos(theta)**8 - 5.05976112683316e+48*cos(theta)**6 + 2.59919235967457e+47*cos(theta)**4 - 4.39300117128096e+45*cos(theta)**2 + 1.06111139402922e+43)*cos(28*phi)

@torch.jit.script
def Yl40_m29(theta, phi):
    return 1.73411117304064e-45*(1.0 - cos(theta)**2)**14.5*(1.9986056450991e+51*cos(theta)**11 - 1.39143430987912e+51*cos(theta)**9 + 3.2527035815356e+50*cos(theta)**7 - 3.0358566760999e+49*cos(theta)**5 + 1.03967694386983e+48*cos(theta)**3 - 8.78600234256192e+45*cos(theta))*cos(29*phi)

@torch.jit.script
def Yl40_m30(theta, phi):
    return 6.24930288108503e-47*(1.0 - cos(theta)**2)**15*(2.19846620960901e+52*cos(theta)**10 - 1.25229087889121e+52*cos(theta)**8 + 2.27689250707492e+51*cos(theta)**6 - 1.51792833804995e+50*cos(theta)**4 + 3.11903083160948e+48*cos(theta)**2 - 8.78600234256192e+45)*cos(30*phi)

@torch.jit.script
def Yl40_m31(theta, phi):
    return 2.34532157918569e-48*(1.0 - cos(theta)**2)**15.5*(2.19846620960901e+53*cos(theta)**9 - 1.00183270311297e+53*cos(theta)**7 + 1.36613550424495e+52*cos(theta)**5 - 6.07171335219979e+50*cos(theta)**3 + 6.23806166321896e+48*cos(theta))*cos(31*phi)

@torch.jit.script
def Yl40_m32(theta, phi):
    return 9.21329329280745e-50*(1.0 - cos(theta)**2)**16*(1.97861958864811e+54*cos(theta)**8 - 7.01282892179076e+53*cos(theta)**6 + 6.83067752122477e+52*cos(theta)**4 - 1.82151400565994e+51*cos(theta)**2 + 6.23806166321896e+48)*cos(32*phi)

@torch.jit.script
def Yl40_m33(theta, phi):
    return 3.81248789127407e-51*(1.0 - cos(theta)**2)**16.5*(1.58289567091849e+55*cos(theta)**7 - 4.20769735307446e+54*cos(theta)**5 + 2.73227100848991e+53*cos(theta)**3 - 3.64302801131987e+51*cos(theta))*cos(33*phi)

@torch.jit.script
def Yl40_m34(theta, phi):
    return 1.67511101004305e-52*(1.0 - cos(theta)**2)**17*(1.10802696964294e+56*cos(theta)**6 - 2.10384867653723e+55*cos(theta)**4 + 8.19681302546972e+53*cos(theta)**2 - 3.64302801131987e+51)*cos(34*phi)

@torch.jit.script
def Yl40_m35(theta, phi):
    return 7.89654902961126e-54*(1.0 - cos(theta)**2)**17.5*(6.64816181785764e+56*cos(theta)**5 - 8.41539470614891e+55*cos(theta)**3 + 1.63936260509394e+54*cos(theta))*cos(35*phi)

@torch.jit.script
def Yl40_m36(theta, phi):
    return 4.05084418028009e-55*(1.0 - cos(theta)**2)**18*(3.32408090892882e+57*cos(theta)**4 - 2.52461841184467e+56*cos(theta)**2 + 1.63936260509394e+54)*cos(36*phi)

@torch.jit.script
def Yl40_m37(theta, phi):
    return 2.30818268966444e-56*(1.0 - cos(theta)**2)**18.5*(1.32963236357153e+58*cos(theta)**3 - 5.04923682368935e+56*cos(theta))*cos(37*phi)

@torch.jit.script
def Yl40_m38(theta, phi):
    return 1.50890622763283e-57*(1.0 - cos(theta)**2)**19*(3.98889709071458e+58*cos(theta)**2 - 5.04923682368935e+56)*cos(38*phi)

@torch.jit.script
def Yl40_m39(theta, phi):
    return 9.57671438575497*(1.0 - cos(theta)**2)**19.5*cos(39*phi)*cos(theta)

@torch.jit.script
def Yl40_m40(theta, phi):
    return 1.07070921838241*(1.0 - cos(theta)**2)**20*cos(40*phi)

@torch.jit.script
def Yl41_m_minus_41(theta, phi):
    return 1.07721814896289*(1.0 - cos(theta)**2)**20.5*sin(41*phi)

@torch.jit.script
def Yl41_m_minus_40(theta, phi):
    return 9.75462521665048*(1.0 - cos(theta)**2)**20*sin(40*phi)*cos(theta)

@torch.jit.script
def Yl41_m_minus_39(theta, phi):
    return 1.92132241117284e-59*(1.0 - cos(theta)**2)**19.5*(3.23100664347881e+60*cos(theta)**2 - 3.98889709071458e+58)*sin(39*phi)

@torch.jit.script
def Yl41_m_minus_38(theta, phi):
    return 2.97649988046699e-58*(1.0 - cos(theta)**2)**19*(1.07700221449294e+60*cos(theta)**3 - 3.98889709071458e+58*cos(theta))*sin(38*phi)

@torch.jit.script
def Yl41_m_minus_37(theta, phi):
    return 5.29114192414144e-57*(1.0 - cos(theta)**2)**18.5*(2.69250553623234e+59*cos(theta)**4 - 1.99444854535729e+58*cos(theta)**2 + 1.26230920592234e+56)*sin(37*phi)

@torch.jit.script
def Yl41_m_minus_36(theta, phi):
    return 1.04491680606395e-55*(1.0 - cos(theta)**2)**18*(5.38501107246469e+58*cos(theta)**5 - 6.64816181785764e+57*cos(theta)**3 + 1.26230920592234e+56*cos(theta))*sin(36*phi)

@torch.jit.script
def Yl41_m_minus_35(theta, phi):
    return 2.24596354110399e-54*(1.0 - cos(theta)**2)**17.5*(8.97501845410781e+57*cos(theta)**6 - 1.66204045446441e+57*cos(theta)**4 + 6.31154602961168e+55*cos(theta)**2 - 2.73227100848991e+53)*sin(35*phi)

@torch.jit.script
def Yl41_m_minus_34(theta, phi):
    return 5.18034302462604e-53*(1.0 - cos(theta)**2)**17*(1.28214549344397e+57*cos(theta)**7 - 3.32408090892882e+56*cos(theta)**5 + 2.10384867653723e+55*cos(theta)**3 - 2.73227100848991e+53*cos(theta))*sin(34*phi)

@torch.jit.script
def Yl41_m_minus_33(theta, phi):
    return 1.26891971029199e-51*(1.0 - cos(theta)**2)**16.5*(1.60268186680497e+56*cos(theta)**8 - 5.5401348482147e+55*cos(theta)**6 + 5.25962169134307e+54*cos(theta)**4 - 1.36613550424495e+53*cos(theta)**2 + 4.55378501414984e+50)*sin(33*phi)

@torch.jit.script
def Yl41_m_minus_32(theta, phi):
    return 3.27469802570795e-50*(1.0 - cos(theta)**2)**16*(1.7807576297833e+55*cos(theta)**9 - 7.91447835459243e+54*cos(theta)**7 + 1.05192433826861e+54*cos(theta)**5 - 4.55378501414984e+52*cos(theta)**3 + 4.55378501414984e+50*cos(theta))*sin(32*phi)

@torch.jit.script
def Yl41_m_minus_31(theta, phi):
    return 8.84774684679108e-49*(1.0 - cos(theta)**2)**15.5*(1.7807576297833e+54*cos(theta)**10 - 9.89309794324053e+53*cos(theta)**8 + 1.75320723044769e+53*cos(theta)**6 - 1.13844625353746e+52*cos(theta)**4 + 2.27689250707492e+50*cos(theta)**2 - 6.23806166321896e+47)*sin(31*phi)

@torch.jit.script
def Yl41_m_minus_30(theta, phi):
    return 2.48997667494702e-47*(1.0 - cos(theta)**2)**15*(1.61887057253027e+53*cos(theta)**11 - 1.0992331048045e+53*cos(theta)**9 + 2.50458175778241e+52*cos(theta)**7 - 2.27689250707492e+51*cos(theta)**5 + 7.58964169024974e+49*cos(theta)**3 - 6.23806166321896e+47*cos(theta))*sin(30*phi)

@torch.jit.script
def Yl41_m_minus_29(theta, phi):
    return 7.26800263703634e-46*(1.0 - cos(theta)**2)**14.5*(1.34905881044189e+52*cos(theta)**12 - 1.0992331048045e+52*cos(theta)**10 + 3.13072719722802e+51*cos(theta)**8 - 3.79482084512487e+50*cos(theta)**6 + 1.89741042256243e+49*cos(theta)**4 - 3.11903083160948e+47*cos(theta)**2 + 7.3216686188016e+44)*sin(29*phi)

@torch.jit.script
def Yl41_m_minus_28(theta, phi):
    return 2.19248066632502e-44*(1.0 - cos(theta)**2)**14*(1.03773754649376e+51*cos(theta)**13 - 9.99302822549549e+50*cos(theta)**11 + 3.4785857746978e+50*cos(theta)**9 - 5.42117263589267e+49*cos(theta)**7 + 3.79482084512487e+48*cos(theta)**5 - 1.03967694386983e+47*cos(theta)**3 + 7.3216686188016e+44*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl41_m_minus_27(theta, phi):
    return 6.81434842237606e-43*(1.0 - cos(theta)**2)**13.5*(7.41241104638402e+49*cos(theta)**14 - 8.32752352124624e+49*cos(theta)**12 + 3.4785857746978e+49*cos(theta)**10 - 6.77646579486584e+48*cos(theta)**8 + 6.32470140854145e+47*cos(theta)**6 - 2.59919235967457e+46*cos(theta)**4 + 3.6608343094008e+44*cos(theta)**2 - 7.5793671002087e+41)*sin(27*phi)

@torch.jit.script
def Yl41_m_minus_26(theta, phi):
    return 2.17632836010492e-41*(1.0 - cos(theta)**2)**13*(4.94160736425601e+48*cos(theta)**15 - 6.40578732403557e+48*cos(theta)**13 + 3.16235070427072e+48*cos(theta)**11 - 7.52940643873982e+47*cos(theta)**9 + 9.03528772648778e+46*cos(theta)**7 - 5.19838471934914e+45*cos(theta)**5 + 1.2202781031336e+44*cos(theta)**3 - 7.5793671002087e+41*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl41_m_minus_25(theta, phi):
    return 7.12560614995579e-40*(1.0 - cos(theta)**2)**12.5*(3.08850460266001e+47*cos(theta)**16 - 4.57556237431112e+47*cos(theta)**14 + 2.63529225355894e+47*cos(theta)**12 - 7.52940643873982e+46*cos(theta)**10 + 1.12941096581097e+46*cos(theta)**8 - 8.66397453224856e+44*cos(theta)**6 + 3.050695257834e+43*cos(theta)**4 - 3.78968355010435e+41*cos(theta)**2 + 7.07030513079169e+38)*sin(25*phi)

@torch.jit.script
def Yl41_m_minus_24(theta, phi):
    return 2.3868121645997e-38*(1.0 - cos(theta)**2)**12*(1.81676741332942e+46*cos(theta)**17 - 3.05037491620741e+46*cos(theta)**15 + 2.02714788735303e+46*cos(theta)**13 - 6.84491494430893e+45*cos(theta)**11 + 1.2549010731233e+45*cos(theta)**9 - 1.23771064746408e+44*cos(theta)**7 + 6.101390515668e+42*cos(theta)**5 - 1.26322785003478e+41*cos(theta)**3 + 7.07030513079169e+38*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl41_m_minus_23(theta, phi):
    return 8.16415372321275e-37*(1.0 - cos(theta)**2)**11.5*(1.00931522962745e+45*cos(theta)**18 - 1.90648432262963e+45*cos(theta)**16 + 1.44796277668073e+45*cos(theta)**14 - 5.70409578692411e+44*cos(theta)**12 + 1.2549010731233e+44*cos(theta)**10 - 1.5471383093301e+43*cos(theta)**8 + 1.016898419278e+42*cos(theta)**6 - 3.15806962508696e+40*cos(theta)**4 + 3.53515256539585e+38*cos(theta)**2 - 6.0429958382835e+35)*sin(23*phi)

@torch.jit.script
def Yl41_m_minus_22(theta, phi):
    return 2.84693768312126e-35*(1.0 - cos(theta)**2)**11*(5.31218541909186e+43*cos(theta)**19 - 1.12146136625273e+44*cos(theta)**17 + 9.65308517787156e+43*cos(theta)**15 - 4.38776598994162e+43*cos(theta)**13 + 1.14081915738482e+43*cos(theta)**11 - 1.71904256592233e+42*cos(theta)**9 + 1.45271202754e+41*cos(theta)**7 - 6.31613925017391e+39*cos(theta)**5 + 1.17838418846528e+38*cos(theta)**3 - 6.0429958382835e+35*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl41_m_minus_21(theta, phi):
    return 1.01056262825149e-33*(1.0 - cos(theta)**2)**10.5*(2.65609270954593e+42*cos(theta)**20 - 6.23034092362625e+42*cos(theta)**18 + 6.03317823616973e+42*cos(theta)**16 - 3.13411856424401e+42*cos(theta)**14 + 9.50682631154018e+41*cos(theta)**12 - 1.71904256592233e+41*cos(theta)**10 + 1.815890034425e+40*cos(theta)**8 - 1.05268987502899e+39*cos(theta)**6 + 2.94596047116321e+37*cos(theta)**4 - 3.02149791914175e+35*cos(theta)**2 + 4.79602844308214e+32)*sin(21*phi)

@torch.jit.script
def Yl41_m_minus_20(theta, phi):
    return 3.64643709249914e-32*(1.0 - cos(theta)**2)**10*(1.26480605216473e+41*cos(theta)**21 - 3.27912680190856e+41*cos(theta)**19 + 3.54892837421749e+41*cos(theta)**17 - 2.08941237616268e+41*cos(theta)**15 + 7.31294331656937e+40*cos(theta)**13 - 1.5627659690203e+40*cos(theta)**11 + 2.01765559380556e+39*cos(theta)**9 - 1.50384267861284e+38*cos(theta)**7 + 5.89192094232641e+36*cos(theta)**5 - 1.00716597304725e+35*cos(theta)**3 + 4.79602844308214e+32*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl41_m_minus_19(theta, phi):
    return 1.33581090189222e-30*(1.0 - cos(theta)**2)**9.5*(5.74911841893058e+39*cos(theta)**22 - 1.63956340095428e+40*cos(theta)**20 + 1.97162687456527e+40*cos(theta)**18 - 1.30588273510167e+40*cos(theta)**16 + 5.22353094040669e+39*cos(theta)**14 - 1.30230497418359e+39*cos(theta)**12 + 2.01765559380556e+38*cos(theta)**10 - 1.87980334826605e+37*cos(theta)**8 + 9.81986823721069e+35*cos(theta)**6 - 2.51791493261812e+34*cos(theta)**4 + 2.39801422154107e+32*cos(theta)**2 - 3.57379168635033e+29)*sin(19*phi)

@torch.jit.script
def Yl41_m_minus_18(theta, phi):
    return 4.96231725764027e-29*(1.0 - cos(theta)**2)**9*(2.49961670388286e+38*cos(theta)**23 - 7.80744476644894e+38*cos(theta)**21 + 1.03769835503435e+39*cos(theta)**19 - 7.6816631476569e+38*cos(theta)**17 + 3.48235396027113e+38*cos(theta)**15 - 1.0017730570643e+38*cos(theta)**13 + 1.83423235800505e+37*cos(theta)**11 - 2.08867038696227e+36*cos(theta)**9 + 1.40283831960153e+35*cos(theta)**7 - 5.03582986523625e+33*cos(theta)**5 + 7.99338073847024e+31*cos(theta)**3 - 3.57379168635033e+29*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl41_m_minus_17(theta, phi):
    return 1.8673088408914e-27*(1.0 - cos(theta)**2)**8.5*(1.04150695995119e+37*cos(theta)**24 - 3.54883853020406e+37*cos(theta)**22 + 5.18849177517177e+37*cos(theta)**20 - 4.26759063758717e+37*cos(theta)**18 + 2.17647122516945e+37*cos(theta)**16 - 7.15552183617355e+36*cos(theta)**14 + 1.52852696500421e+36*cos(theta)**12 - 2.08867038696227e+35*cos(theta)**10 + 1.75354789950191e+34*cos(theta)**8 - 8.39304977539375e+32*cos(theta)**6 + 1.99834518461756e+31*cos(theta)**4 - 1.78689584317516e+29*cos(theta)**2 + 2.52386418527566e+26)*sin(17*phi)

@torch.jit.script
def Yl41_m_minus_16(theta, phi):
    return 7.11050022540132e-26*(1.0 - cos(theta)**2)**8*(4.16602783980477e+35*cos(theta)**25 - 1.54297327400177e+36*cos(theta)**23 + 2.47071036912941e+36*cos(theta)**21 - 2.24610033557219e+36*cos(theta)**19 + 1.28027719127615e+36*cos(theta)**17 - 4.77034789078237e+35*cos(theta)**15 + 1.17578997308016e+35*cos(theta)**13 - 1.89879126087479e+34*cos(theta)**11 + 1.94838655500212e+33*cos(theta)**9 - 1.19900711077054e+32*cos(theta)**7 + 3.99669036923512e+30*cos(theta)**5 - 5.95631947725055e+28*cos(theta)**3 + 2.52386418527566e+26*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl41_m_minus_15(theta, phi):
    return 2.73731171664738e-24*(1.0 - cos(theta)**2)**7.5*(1.60231839992491e+34*cos(theta)**26 - 6.4290553083407e+34*cos(theta)**24 + 1.1230501677861e+35*cos(theta)**22 - 1.1230501677861e+35*cos(theta)**20 + 7.11265106264528e+34*cos(theta)**18 - 2.98146743173898e+34*cos(theta)**16 + 8.39849980771543e+33*cos(theta)**14 - 1.58232605072899e+33*cos(theta)**12 + 1.94838655500212e+32*cos(theta)**10 - 1.49875888846317e+31*cos(theta)**8 + 6.66115061539186e+29*cos(theta)**6 - 1.48907986931264e+28*cos(theta)**4 + 1.26193209263783e+26*cos(theta)**2 - 1.7030122707663e+23)*sin(15*phi)

@torch.jit.script
def Yl41_m_minus_14(theta, phi):
    return 1.06438844677832e-22*(1.0 - cos(theta)**2)**7*(5.93451259231449e+32*cos(theta)**27 - 2.57162212333628e+33*cos(theta)**25 + 4.88282681646129e+33*cos(theta)**23 - 5.34785794183855e+33*cos(theta)**21 + 3.74350055928699e+33*cos(theta)**19 - 1.75380437161116e+33*cos(theta)**17 + 5.59899987181029e+32*cos(theta)**15 - 1.21717388517615e+32*cos(theta)**13 + 1.77126050454738e+31*cos(theta)**11 - 1.66528765384797e+30*cos(theta)**9 + 9.51592945055981e+28*cos(theta)**7 - 2.97815973862527e+27*cos(theta)**5 + 4.20644030879276e+25*cos(theta)**3 - 1.7030122707663e+23*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl41_m_minus_13(theta, phi):
    return 4.17696188524406e-21*(1.0 - cos(theta)**2)**6.5*(2.11946878296946e+31*cos(theta)**28 - 9.89085432052415e+31*cos(theta)**26 + 2.03451117352554e+32*cos(theta)**24 - 2.43084451901752e+32*cos(theta)**22 + 1.87175027964349e+32*cos(theta)**20 - 9.74335762006202e+31*cos(theta)**18 + 3.49937491988143e+31*cos(theta)**16 - 8.69409917982964e+30*cos(theta)**14 + 1.47605042045615e+30*cos(theta)**12 - 1.66528765384797e+29*cos(theta)**10 + 1.18949118131998e+28*cos(theta)**8 - 4.96359956437546e+26*cos(theta)**6 + 1.05161007719819e+25*cos(theta)**4 - 8.5150613538315e+22*cos(theta)**2 + 1.10585212387422e+20)*sin(13*phi)

@torch.jit.script
def Yl41_m_minus_12(theta, phi):
    return 1.65293734258634e-19*(1.0 - cos(theta)**2)**6*(7.30851304472228e+29*cos(theta)**29 - 3.66327937797191e+30*cos(theta)**27 + 8.13804469410215e+30*cos(theta)**25 - 1.05688892131197e+31*cos(theta)**23 + 8.91309656973092e+30*cos(theta)**21 - 5.12808295792738e+30*cos(theta)**19 + 2.05845583522437e+30*cos(theta)**17 - 5.79606611988643e+29*cos(theta)**15 + 1.13542340035089e+29*cos(theta)**13 - 1.51389786713451e+28*cos(theta)**11 + 1.32165686813331e+27*cos(theta)**9 - 7.09085652053637e+25*cos(theta)**7 + 2.10322015439638e+24*cos(theta)**5 - 2.8383537846105e+22*cos(theta)**3 + 1.10585212387422e+20*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl41_m_minus_11(theta, phi):
    return 6.59105526834746e-18*(1.0 - cos(theta)**2)**5.5*(2.43617101490743e+28*cos(theta)**30 - 1.3083140635614e+29*cos(theta)**28 + 3.13001719003929e+29*cos(theta)**26 - 4.40370383879986e+29*cos(theta)**24 + 4.05140753169587e+29*cos(theta)**22 - 2.56404147896369e+29*cos(theta)**20 + 1.14358657512465e+29*cos(theta)**18 - 3.62254132492902e+28*cos(theta)**16 + 8.11016714536347e+27*cos(theta)**14 - 1.26158155594543e+27*cos(theta)**12 + 1.32165686813331e+26*cos(theta)**10 - 8.86357065067046e+24*cos(theta)**8 + 3.50536692399397e+23*cos(theta)**6 - 7.09588446152625e+21*cos(theta)**4 + 5.5292606193711e+19*cos(theta)**2 - 6.95504480424038e+16)*sin(11*phi)

@torch.jit.script
def Yl41_m_minus_10(theta, phi):
    return 2.64629022208945e-16*(1.0 - cos(theta)**2)**5*(7.85861617712073e+26*cos(theta)**31 - 4.51142780538412e+27*cos(theta)**29 + 1.15926562594048e+28*cos(theta)**27 - 1.76148153551995e+28*cos(theta)**25 + 1.76148153551995e+28*cos(theta)**23 - 1.22097213283985e+28*cos(theta)**21 + 6.01887671118237e+27*cos(theta)**19 - 2.13090666172295e+27*cos(theta)**17 + 5.40677809690898e+26*cos(theta)**15 - 9.70447350727253e+25*cos(theta)**13 + 1.20150624375755e+25*cos(theta)**11 - 9.84841183407829e+23*cos(theta)**9 + 5.0076670342771e+22*cos(theta)**7 - 1.41917689230525e+21*cos(theta)**5 + 1.8430868731237e+19*cos(theta)**3 - 6.95504480424038e+16*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl41_m_minus_9(theta, phi):
    return 1.06904884665327e-14*(1.0 - cos(theta)**2)**4.5*(2.45581755535023e+25*cos(theta)**32 - 1.50380926846137e+26*cos(theta)**30 + 4.14023437835885e+26*cos(theta)**28 - 6.77492898276902e+26*cos(theta)**26 + 7.33950639799977e+26*cos(theta)**24 - 5.54987333109024e+26*cos(theta)**22 + 3.00943835559119e+26*cos(theta)**20 - 1.18383703429053e+26*cos(theta)**18 + 3.37923631056811e+25*cos(theta)**16 - 6.93176679090895e+24*cos(theta)**14 + 1.00125520313129e+24*cos(theta)**12 - 9.84841183407829e+22*cos(theta)**10 + 6.25958379284637e+21*cos(theta)**8 - 2.36529482050875e+20*cos(theta)**6 + 4.60771718280925e+18*cos(theta)**4 - 3.47752240212019e+16*cos(theta)**2 + 42616696104414.1)*sin(9*phi)

@torch.jit.script
def Yl41_m_minus_8(theta, phi):
    return 4.34249694332146e-13*(1.0 - cos(theta)**2)**4*(7.44187137984917e+23*cos(theta)**33 - 4.85099764019798e+24*cos(theta)**31 + 1.42766702702029e+25*cos(theta)**29 - 2.50923295658112e+25*cos(theta)**27 + 2.93580255919991e+25*cos(theta)**25 - 2.41298840482184e+25*cos(theta)**23 + 1.43306588361485e+25*cos(theta)**21 - 6.23072123310804e+24*cos(theta)**19 + 1.98778606504007e+24*cos(theta)**17 - 4.62117786060597e+23*cos(theta)**15 + 7.70196310100994e+22*cos(theta)**13 - 8.9531016673439e+21*cos(theta)**11 + 6.95509310316263e+20*cos(theta)**9 - 3.37899260072679e+19*cos(theta)**7 + 9.21543436561851e+17*cos(theta)**5 - 1.15917413404006e+16*cos(theta)**3 + 42616696104414.1*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl41_m_minus_7(theta, phi):
    return 1.77246235460141e-11*(1.0 - cos(theta)**2)**3.5*(2.18878569995564e+22*cos(theta)**34 - 1.51593676256187e+23*cos(theta)**32 + 4.75889009006764e+23*cos(theta)**30 - 8.96154627350399e+23*cos(theta)**28 + 1.1291548304615e+24*cos(theta)**26 - 1.00541183534243e+24*cos(theta)**24 + 6.51393583461296e+23*cos(theta)**22 - 3.11536061655402e+23*cos(theta)**20 + 1.10432559168893e+23*cos(theta)**18 - 2.88823616287873e+22*cos(theta)**16 + 5.5014022150071e+21*cos(theta)**14 - 7.46091805611992e+20*cos(theta)**12 + 6.95509310316263e+19*cos(theta)**10 - 4.22374075090848e+18*cos(theta)**8 + 1.53590572760308e+17*cos(theta)**6 - 2.89793533510016e+15*cos(theta)**4 + 21308348052207.1*cos(theta)**2 - 25580249762.5535)*sin(7*phi)

@torch.jit.script
def Yl41_m_minus_6(theta, phi):
    return 7.264933792847e-10*(1.0 - cos(theta)**2)**3*(6.25367342844468e+20*cos(theta)**35 - 4.593747765339e+21*cos(theta)**33 + 1.53512583550569e+22*cos(theta)**31 - 3.09018837017379e+22*cos(theta)**29 + 4.1820549276352e+22*cos(theta)**27 - 4.02164734136974e+22*cos(theta)**25 + 2.83214601504911e+22*cos(theta)**23 - 1.48350505550192e+22*cos(theta)**21 + 5.8122399562575e+21*cos(theta)**19 - 1.69896244875219e+21*cos(theta)**17 + 3.6676014766714e+20*cos(theta)**15 - 5.73916773547686e+19*cos(theta)**13 + 6.32281191196603e+18*cos(theta)**11 - 4.6930452787872e+17*cos(theta)**9 + 2.19415103943298e+16*cos(theta)**7 - 579587067020032.0*cos(theta)**5 + 7102782684069.02*cos(theta)**3 - 25580249762.5535*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl41_m_minus_5(theta, phi):
    return 2.98835260671243e-8*(1.0 - cos(theta)**2)**2.5*(1.7371315079013e+19*cos(theta)**36 - 1.35110228392323e+20*cos(theta)**34 + 4.79726823595528e+20*cos(theta)**32 - 1.03006279005793e+21*cos(theta)**30 + 1.493591045584e+21*cos(theta)**28 - 1.54678743898836e+21*cos(theta)**26 + 1.1800608396038e+21*cos(theta)**24 - 6.74320479773598e+20*cos(theta)**22 + 2.90611997812875e+20*cos(theta)**20 - 9.43868027084552e+19*cos(theta)**18 + 2.29225092291963e+19*cos(theta)**16 - 4.09940552534061e+18*cos(theta)**14 + 5.26900992663836e+17*cos(theta)**12 - 4.6930452787872e+16*cos(theta)**10 + 2.74268879929122e+15*cos(theta)**8 - 96597844503338.6*cos(theta)**6 + 1775695671017.25*cos(theta)**4 - 12790124881.2767*cos(theta)**2 + 15118350.923495)*sin(5*phi)

@torch.jit.script
def Yl41_m_minus_4(theta, phi):
    return 1.23285391332796e-6*(1.0 - cos(theta)**2)**2*(4.69495002135487e+17*cos(theta)**37 - 3.86029223978067e+18*cos(theta)**35 + 1.45371764725918e+19*cos(theta)**33 - 3.32278319373526e+19*cos(theta)**31 + 5.15031395028965e+19*cos(theta)**29 - 5.72884236662356e+19*cos(theta)**27 + 4.72024335841519e+19*cos(theta)**25 - 2.93182817292869e+19*cos(theta)**23 + 1.38386665625179e+19*cos(theta)**21 - 4.96772645833975e+18*cos(theta)**19 + 1.34838289583507e+18*cos(theta)**17 - 2.73293701689374e+17*cos(theta)**15 + 4.05308455895258e+16*cos(theta)**13 - 4.26640479889746e+15*cos(theta)**11 + 304743199921247.0*cos(theta)**9 - 13799692071905.5*cos(theta)**7 + 355139134203.451*cos(theta)**5 - 4263374960.42558*cos(theta)**3 + 15118350.923495*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl41_m_minus_3(theta, phi):
    return 5.09811553365533e-5*(1.0 - cos(theta)**2)**1.5*(1.23551316351444e+16*cos(theta)**38 - 1.07230339993907e+17*cos(theta)**36 + 4.27564013899758e+17*cos(theta)**34 - 1.03836974804227e+18*cos(theta)**32 + 1.71677131676322e+18*cos(theta)**30 - 2.04601513093699e+18*cos(theta)**28 + 1.81547821477507e+18*cos(theta)**26 - 1.22159507205362e+18*cos(theta)**24 + 6.29030298296267e+17*cos(theta)**22 - 2.48386322916987e+17*cos(theta)**20 + 7.49101608797264e+16*cos(theta)**18 - 1.70808563555859e+16*cos(theta)**16 + 2.89506039925185e+15*cos(theta)**14 - 355533733241455.0*cos(theta)**12 + 30474319992124.7*cos(theta)**10 - 1724961508988.19*cos(theta)**8 + 59189855700.5751*cos(theta)**6 - 1065843740.1064*cos(theta)**4 + 7559175.46174748*cos(theta)**2 - 8841.14089093273)*sin(3*phi)

@torch.jit.script
def Yl41_m_minus_2(theta, phi):
    return 0.00211187551485778*(1.0 - cos(theta)**2)*(316798247054984.0*cos(theta)**39 - 2.89811729713263e+15*cos(theta)**37 + 1.22161146828502e+16*cos(theta)**35 - 3.14657499406748e+16*cos(theta)**33 + 5.53797198955877e+16*cos(theta)**31 - 7.05522458943788e+16*cos(theta)**29 + 6.72399338805582e+16*cos(theta)**27 - 4.88638028821448e+16*cos(theta)**25 + 2.73491434041855e+16*cos(theta)**23 - 1.18279201389042e+16*cos(theta)**21 + 3.94264004630139e+15*cos(theta)**19 - 1.00475625621093e+15*cos(theta)**17 + 193004026616790.0*cos(theta)**15 - 27348748710881.1*cos(theta)**13 + 2770392726556.79*cos(theta)**11 - 191662389887.577*cos(theta)**9 + 8455693671.51074*cos(theta)**7 - 213168748.021279*cos(theta)**5 + 2519725.15391583*cos(theta)**3 - 8841.14089093273*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl41_m_minus_1(theta, phi):
    return 0.0875855655187544*(1.0 - cos(theta)**2)**0.5*(7919956176374.61*cos(theta)**40 - 76266244661385.1*cos(theta)**38 + 339336518968062.0*cos(theta)**36 - 925463233549259.0*cos(theta)**34 + 1.73061624673711e+15*cos(theta)**32 - 2.35174152981263e+15*cos(theta)**30 + 2.40142621001994e+15*cos(theta)**28 - 1.87937703392865e+15*cos(theta)**26 + 1.13954764184106e+15*cos(theta)**24 - 537632733586553.0*cos(theta)**22 + 197132002315069.0*cos(theta)**20 - 55819792011718.6*cos(theta)**18 + 12062751663549.4*cos(theta)**16 - 1953482050777.22*cos(theta)**14 + 230866060546.399*cos(theta)**12 - 19166238988.7577*cos(theta)**10 + 1056961708.93884*cos(theta)**8 - 35528124.6702132*cos(theta)**6 + 629931.288478957*cos(theta)**4 - 4420.57044546636*cos(theta)**2 + 5.14019819240275)*sin(phi)

@torch.jit.script
def Yl41_m0(theta, phi):
    return 496447166140.858*cos(theta)**41 - 5025761435006.22*cos(theta)**39 + 23570184957845.6*cos(theta)**37 - 67955598190152.3*cos(theta)**35 + 134778603077135.0*cos(theta)**33 - 194967403903363.0*cos(theta)**31 + 212816532429727.0*cos(theta)**29 - 178889259143829.0*cos(theta)**27 + 117145764849783.0*cos(theta)**25 - 60074751205017.1*cos(theta)**23 + 24125257229951.3*cos(theta)**21 - 7550378566750.78*cos(theta)**19 + 1823608382647.43*cos(theta)**17 - 334697354979.826*cos(theta)**15 + 45640548406.3399*cos(theta)**13 - 4477940598.35788*cos(theta)**11 + 301821976.605004*cos(theta)**9 - 13043926.9601202*cos(theta)**7 + 323785.420995892*cos(theta)**5 - 3786.96398825605*cos(theta)**3 + 13.2103394939164*cos(theta)

@torch.jit.script
def Yl41_m1(theta, phi):
    return 0.0875855655187544*(1.0 - cos(theta)**2)**0.5*(7919956176374.61*cos(theta)**40 - 76266244661385.1*cos(theta)**38 + 339336518968062.0*cos(theta)**36 - 925463233549259.0*cos(theta)**34 + 1.73061624673711e+15*cos(theta)**32 - 2.35174152981263e+15*cos(theta)**30 + 2.40142621001994e+15*cos(theta)**28 - 1.87937703392865e+15*cos(theta)**26 + 1.13954764184106e+15*cos(theta)**24 - 537632733586553.0*cos(theta)**22 + 197132002315069.0*cos(theta)**20 - 55819792011718.6*cos(theta)**18 + 12062751663549.4*cos(theta)**16 - 1953482050777.22*cos(theta)**14 + 230866060546.399*cos(theta)**12 - 19166238988.7577*cos(theta)**10 + 1056961708.93884*cos(theta)**8 - 35528124.6702132*cos(theta)**6 + 629931.288478957*cos(theta)**4 - 4420.57044546636*cos(theta)**2 + 5.14019819240275)*cos(phi)

@torch.jit.script
def Yl41_m2(theta, phi):
    return 0.00211187551485778*(1.0 - cos(theta)**2)*(316798247054984.0*cos(theta)**39 - 2.89811729713263e+15*cos(theta)**37 + 1.22161146828502e+16*cos(theta)**35 - 3.14657499406748e+16*cos(theta)**33 + 5.53797198955877e+16*cos(theta)**31 - 7.05522458943788e+16*cos(theta)**29 + 6.72399338805582e+16*cos(theta)**27 - 4.88638028821448e+16*cos(theta)**25 + 2.73491434041855e+16*cos(theta)**23 - 1.18279201389042e+16*cos(theta)**21 + 3.94264004630139e+15*cos(theta)**19 - 1.00475625621093e+15*cos(theta)**17 + 193004026616790.0*cos(theta)**15 - 27348748710881.1*cos(theta)**13 + 2770392726556.79*cos(theta)**11 - 191662389887.577*cos(theta)**9 + 8455693671.51074*cos(theta)**7 - 213168748.021279*cos(theta)**5 + 2519725.15391583*cos(theta)**3 - 8841.14089093273*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl41_m3(theta, phi):
    return 5.09811553365533e-5*(1.0 - cos(theta)**2)**1.5*(1.23551316351444e+16*cos(theta)**38 - 1.07230339993907e+17*cos(theta)**36 + 4.27564013899758e+17*cos(theta)**34 - 1.03836974804227e+18*cos(theta)**32 + 1.71677131676322e+18*cos(theta)**30 - 2.04601513093699e+18*cos(theta)**28 + 1.81547821477507e+18*cos(theta)**26 - 1.22159507205362e+18*cos(theta)**24 + 6.29030298296267e+17*cos(theta)**22 - 2.48386322916987e+17*cos(theta)**20 + 7.49101608797264e+16*cos(theta)**18 - 1.70808563555859e+16*cos(theta)**16 + 2.89506039925185e+15*cos(theta)**14 - 355533733241455.0*cos(theta)**12 + 30474319992124.7*cos(theta)**10 - 1724961508988.19*cos(theta)**8 + 59189855700.5751*cos(theta)**6 - 1065843740.1064*cos(theta)**4 + 7559175.46174748*cos(theta)**2 - 8841.14089093273)*cos(3*phi)

@torch.jit.script
def Yl41_m4(theta, phi):
    return 1.23285391332796e-6*(1.0 - cos(theta)**2)**2*(4.69495002135487e+17*cos(theta)**37 - 3.86029223978067e+18*cos(theta)**35 + 1.45371764725918e+19*cos(theta)**33 - 3.32278319373526e+19*cos(theta)**31 + 5.15031395028965e+19*cos(theta)**29 - 5.72884236662356e+19*cos(theta)**27 + 4.72024335841519e+19*cos(theta)**25 - 2.93182817292869e+19*cos(theta)**23 + 1.38386665625179e+19*cos(theta)**21 - 4.96772645833975e+18*cos(theta)**19 + 1.34838289583507e+18*cos(theta)**17 - 2.73293701689374e+17*cos(theta)**15 + 4.05308455895258e+16*cos(theta)**13 - 4.26640479889746e+15*cos(theta)**11 + 304743199921247.0*cos(theta)**9 - 13799692071905.5*cos(theta)**7 + 355139134203.451*cos(theta)**5 - 4263374960.42558*cos(theta)**3 + 15118350.923495*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl41_m5(theta, phi):
    return 2.98835260671243e-8*(1.0 - cos(theta)**2)**2.5*(1.7371315079013e+19*cos(theta)**36 - 1.35110228392323e+20*cos(theta)**34 + 4.79726823595528e+20*cos(theta)**32 - 1.03006279005793e+21*cos(theta)**30 + 1.493591045584e+21*cos(theta)**28 - 1.54678743898836e+21*cos(theta)**26 + 1.1800608396038e+21*cos(theta)**24 - 6.74320479773598e+20*cos(theta)**22 + 2.90611997812875e+20*cos(theta)**20 - 9.43868027084552e+19*cos(theta)**18 + 2.29225092291963e+19*cos(theta)**16 - 4.09940552534061e+18*cos(theta)**14 + 5.26900992663836e+17*cos(theta)**12 - 4.6930452787872e+16*cos(theta)**10 + 2.74268879929122e+15*cos(theta)**8 - 96597844503338.6*cos(theta)**6 + 1775695671017.25*cos(theta)**4 - 12790124881.2767*cos(theta)**2 + 15118350.923495)*cos(5*phi)

@torch.jit.script
def Yl41_m6(theta, phi):
    return 7.264933792847e-10*(1.0 - cos(theta)**2)**3*(6.25367342844468e+20*cos(theta)**35 - 4.593747765339e+21*cos(theta)**33 + 1.53512583550569e+22*cos(theta)**31 - 3.09018837017379e+22*cos(theta)**29 + 4.1820549276352e+22*cos(theta)**27 - 4.02164734136974e+22*cos(theta)**25 + 2.83214601504911e+22*cos(theta)**23 - 1.48350505550192e+22*cos(theta)**21 + 5.8122399562575e+21*cos(theta)**19 - 1.69896244875219e+21*cos(theta)**17 + 3.6676014766714e+20*cos(theta)**15 - 5.73916773547686e+19*cos(theta)**13 + 6.32281191196603e+18*cos(theta)**11 - 4.6930452787872e+17*cos(theta)**9 + 2.19415103943298e+16*cos(theta)**7 - 579587067020032.0*cos(theta)**5 + 7102782684069.02*cos(theta)**3 - 25580249762.5535*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl41_m7(theta, phi):
    return 1.77246235460141e-11*(1.0 - cos(theta)**2)**3.5*(2.18878569995564e+22*cos(theta)**34 - 1.51593676256187e+23*cos(theta)**32 + 4.75889009006764e+23*cos(theta)**30 - 8.96154627350399e+23*cos(theta)**28 + 1.1291548304615e+24*cos(theta)**26 - 1.00541183534243e+24*cos(theta)**24 + 6.51393583461296e+23*cos(theta)**22 - 3.11536061655402e+23*cos(theta)**20 + 1.10432559168893e+23*cos(theta)**18 - 2.88823616287873e+22*cos(theta)**16 + 5.5014022150071e+21*cos(theta)**14 - 7.46091805611992e+20*cos(theta)**12 + 6.95509310316263e+19*cos(theta)**10 - 4.22374075090848e+18*cos(theta)**8 + 1.53590572760308e+17*cos(theta)**6 - 2.89793533510016e+15*cos(theta)**4 + 21308348052207.1*cos(theta)**2 - 25580249762.5535)*cos(7*phi)

@torch.jit.script
def Yl41_m8(theta, phi):
    return 4.34249694332146e-13*(1.0 - cos(theta)**2)**4*(7.44187137984917e+23*cos(theta)**33 - 4.85099764019798e+24*cos(theta)**31 + 1.42766702702029e+25*cos(theta)**29 - 2.50923295658112e+25*cos(theta)**27 + 2.93580255919991e+25*cos(theta)**25 - 2.41298840482184e+25*cos(theta)**23 + 1.43306588361485e+25*cos(theta)**21 - 6.23072123310804e+24*cos(theta)**19 + 1.98778606504007e+24*cos(theta)**17 - 4.62117786060597e+23*cos(theta)**15 + 7.70196310100994e+22*cos(theta)**13 - 8.9531016673439e+21*cos(theta)**11 + 6.95509310316263e+20*cos(theta)**9 - 3.37899260072679e+19*cos(theta)**7 + 9.21543436561851e+17*cos(theta)**5 - 1.15917413404006e+16*cos(theta)**3 + 42616696104414.1*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl41_m9(theta, phi):
    return 1.06904884665327e-14*(1.0 - cos(theta)**2)**4.5*(2.45581755535023e+25*cos(theta)**32 - 1.50380926846137e+26*cos(theta)**30 + 4.14023437835885e+26*cos(theta)**28 - 6.77492898276902e+26*cos(theta)**26 + 7.33950639799977e+26*cos(theta)**24 - 5.54987333109024e+26*cos(theta)**22 + 3.00943835559119e+26*cos(theta)**20 - 1.18383703429053e+26*cos(theta)**18 + 3.37923631056811e+25*cos(theta)**16 - 6.93176679090895e+24*cos(theta)**14 + 1.00125520313129e+24*cos(theta)**12 - 9.84841183407829e+22*cos(theta)**10 + 6.25958379284637e+21*cos(theta)**8 - 2.36529482050875e+20*cos(theta)**6 + 4.60771718280925e+18*cos(theta)**4 - 3.47752240212019e+16*cos(theta)**2 + 42616696104414.1)*cos(9*phi)

@torch.jit.script
def Yl41_m10(theta, phi):
    return 2.64629022208945e-16*(1.0 - cos(theta)**2)**5*(7.85861617712073e+26*cos(theta)**31 - 4.51142780538412e+27*cos(theta)**29 + 1.15926562594048e+28*cos(theta)**27 - 1.76148153551995e+28*cos(theta)**25 + 1.76148153551995e+28*cos(theta)**23 - 1.22097213283985e+28*cos(theta)**21 + 6.01887671118237e+27*cos(theta)**19 - 2.13090666172295e+27*cos(theta)**17 + 5.40677809690898e+26*cos(theta)**15 - 9.70447350727253e+25*cos(theta)**13 + 1.20150624375755e+25*cos(theta)**11 - 9.84841183407829e+23*cos(theta)**9 + 5.0076670342771e+22*cos(theta)**7 - 1.41917689230525e+21*cos(theta)**5 + 1.8430868731237e+19*cos(theta)**3 - 6.95504480424038e+16*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl41_m11(theta, phi):
    return 6.59105526834746e-18*(1.0 - cos(theta)**2)**5.5*(2.43617101490743e+28*cos(theta)**30 - 1.3083140635614e+29*cos(theta)**28 + 3.13001719003929e+29*cos(theta)**26 - 4.40370383879986e+29*cos(theta)**24 + 4.05140753169587e+29*cos(theta)**22 - 2.56404147896369e+29*cos(theta)**20 + 1.14358657512465e+29*cos(theta)**18 - 3.62254132492902e+28*cos(theta)**16 + 8.11016714536347e+27*cos(theta)**14 - 1.26158155594543e+27*cos(theta)**12 + 1.32165686813331e+26*cos(theta)**10 - 8.86357065067046e+24*cos(theta)**8 + 3.50536692399397e+23*cos(theta)**6 - 7.09588446152625e+21*cos(theta)**4 + 5.5292606193711e+19*cos(theta)**2 - 6.95504480424038e+16)*cos(11*phi)

@torch.jit.script
def Yl41_m12(theta, phi):
    return 1.65293734258634e-19*(1.0 - cos(theta)**2)**6*(7.30851304472228e+29*cos(theta)**29 - 3.66327937797191e+30*cos(theta)**27 + 8.13804469410215e+30*cos(theta)**25 - 1.05688892131197e+31*cos(theta)**23 + 8.91309656973092e+30*cos(theta)**21 - 5.12808295792738e+30*cos(theta)**19 + 2.05845583522437e+30*cos(theta)**17 - 5.79606611988643e+29*cos(theta)**15 + 1.13542340035089e+29*cos(theta)**13 - 1.51389786713451e+28*cos(theta)**11 + 1.32165686813331e+27*cos(theta)**9 - 7.09085652053637e+25*cos(theta)**7 + 2.10322015439638e+24*cos(theta)**5 - 2.8383537846105e+22*cos(theta)**3 + 1.10585212387422e+20*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl41_m13(theta, phi):
    return 4.17696188524406e-21*(1.0 - cos(theta)**2)**6.5*(2.11946878296946e+31*cos(theta)**28 - 9.89085432052415e+31*cos(theta)**26 + 2.03451117352554e+32*cos(theta)**24 - 2.43084451901752e+32*cos(theta)**22 + 1.87175027964349e+32*cos(theta)**20 - 9.74335762006202e+31*cos(theta)**18 + 3.49937491988143e+31*cos(theta)**16 - 8.69409917982964e+30*cos(theta)**14 + 1.47605042045615e+30*cos(theta)**12 - 1.66528765384797e+29*cos(theta)**10 + 1.18949118131998e+28*cos(theta)**8 - 4.96359956437546e+26*cos(theta)**6 + 1.05161007719819e+25*cos(theta)**4 - 8.5150613538315e+22*cos(theta)**2 + 1.10585212387422e+20)*cos(13*phi)

@torch.jit.script
def Yl41_m14(theta, phi):
    return 1.06438844677832e-22*(1.0 - cos(theta)**2)**7*(5.93451259231449e+32*cos(theta)**27 - 2.57162212333628e+33*cos(theta)**25 + 4.88282681646129e+33*cos(theta)**23 - 5.34785794183855e+33*cos(theta)**21 + 3.74350055928699e+33*cos(theta)**19 - 1.75380437161116e+33*cos(theta)**17 + 5.59899987181029e+32*cos(theta)**15 - 1.21717388517615e+32*cos(theta)**13 + 1.77126050454738e+31*cos(theta)**11 - 1.66528765384797e+30*cos(theta)**9 + 9.51592945055981e+28*cos(theta)**7 - 2.97815973862527e+27*cos(theta)**5 + 4.20644030879276e+25*cos(theta)**3 - 1.7030122707663e+23*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl41_m15(theta, phi):
    return 2.73731171664738e-24*(1.0 - cos(theta)**2)**7.5*(1.60231839992491e+34*cos(theta)**26 - 6.4290553083407e+34*cos(theta)**24 + 1.1230501677861e+35*cos(theta)**22 - 1.1230501677861e+35*cos(theta)**20 + 7.11265106264528e+34*cos(theta)**18 - 2.98146743173898e+34*cos(theta)**16 + 8.39849980771543e+33*cos(theta)**14 - 1.58232605072899e+33*cos(theta)**12 + 1.94838655500212e+32*cos(theta)**10 - 1.49875888846317e+31*cos(theta)**8 + 6.66115061539186e+29*cos(theta)**6 - 1.48907986931264e+28*cos(theta)**4 + 1.26193209263783e+26*cos(theta)**2 - 1.7030122707663e+23)*cos(15*phi)

@torch.jit.script
def Yl41_m16(theta, phi):
    return 7.11050022540132e-26*(1.0 - cos(theta)**2)**8*(4.16602783980477e+35*cos(theta)**25 - 1.54297327400177e+36*cos(theta)**23 + 2.47071036912941e+36*cos(theta)**21 - 2.24610033557219e+36*cos(theta)**19 + 1.28027719127615e+36*cos(theta)**17 - 4.77034789078237e+35*cos(theta)**15 + 1.17578997308016e+35*cos(theta)**13 - 1.89879126087479e+34*cos(theta)**11 + 1.94838655500212e+33*cos(theta)**9 - 1.19900711077054e+32*cos(theta)**7 + 3.99669036923512e+30*cos(theta)**5 - 5.95631947725055e+28*cos(theta)**3 + 2.52386418527566e+26*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl41_m17(theta, phi):
    return 1.8673088408914e-27*(1.0 - cos(theta)**2)**8.5*(1.04150695995119e+37*cos(theta)**24 - 3.54883853020406e+37*cos(theta)**22 + 5.18849177517177e+37*cos(theta)**20 - 4.26759063758717e+37*cos(theta)**18 + 2.17647122516945e+37*cos(theta)**16 - 7.15552183617355e+36*cos(theta)**14 + 1.52852696500421e+36*cos(theta)**12 - 2.08867038696227e+35*cos(theta)**10 + 1.75354789950191e+34*cos(theta)**8 - 8.39304977539375e+32*cos(theta)**6 + 1.99834518461756e+31*cos(theta)**4 - 1.78689584317516e+29*cos(theta)**2 + 2.52386418527566e+26)*cos(17*phi)

@torch.jit.script
def Yl41_m18(theta, phi):
    return 4.96231725764027e-29*(1.0 - cos(theta)**2)**9*(2.49961670388286e+38*cos(theta)**23 - 7.80744476644894e+38*cos(theta)**21 + 1.03769835503435e+39*cos(theta)**19 - 7.6816631476569e+38*cos(theta)**17 + 3.48235396027113e+38*cos(theta)**15 - 1.0017730570643e+38*cos(theta)**13 + 1.83423235800505e+37*cos(theta)**11 - 2.08867038696227e+36*cos(theta)**9 + 1.40283831960153e+35*cos(theta)**7 - 5.03582986523625e+33*cos(theta)**5 + 7.99338073847024e+31*cos(theta)**3 - 3.57379168635033e+29*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl41_m19(theta, phi):
    return 1.33581090189222e-30*(1.0 - cos(theta)**2)**9.5*(5.74911841893058e+39*cos(theta)**22 - 1.63956340095428e+40*cos(theta)**20 + 1.97162687456527e+40*cos(theta)**18 - 1.30588273510167e+40*cos(theta)**16 + 5.22353094040669e+39*cos(theta)**14 - 1.30230497418359e+39*cos(theta)**12 + 2.01765559380556e+38*cos(theta)**10 - 1.87980334826605e+37*cos(theta)**8 + 9.81986823721069e+35*cos(theta)**6 - 2.51791493261812e+34*cos(theta)**4 + 2.39801422154107e+32*cos(theta)**2 - 3.57379168635033e+29)*cos(19*phi)

@torch.jit.script
def Yl41_m20(theta, phi):
    return 3.64643709249914e-32*(1.0 - cos(theta)**2)**10*(1.26480605216473e+41*cos(theta)**21 - 3.27912680190856e+41*cos(theta)**19 + 3.54892837421749e+41*cos(theta)**17 - 2.08941237616268e+41*cos(theta)**15 + 7.31294331656937e+40*cos(theta)**13 - 1.5627659690203e+40*cos(theta)**11 + 2.01765559380556e+39*cos(theta)**9 - 1.50384267861284e+38*cos(theta)**7 + 5.89192094232641e+36*cos(theta)**5 - 1.00716597304725e+35*cos(theta)**3 + 4.79602844308214e+32*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl41_m21(theta, phi):
    return 1.01056262825149e-33*(1.0 - cos(theta)**2)**10.5*(2.65609270954593e+42*cos(theta)**20 - 6.23034092362625e+42*cos(theta)**18 + 6.03317823616973e+42*cos(theta)**16 - 3.13411856424401e+42*cos(theta)**14 + 9.50682631154018e+41*cos(theta)**12 - 1.71904256592233e+41*cos(theta)**10 + 1.815890034425e+40*cos(theta)**8 - 1.05268987502899e+39*cos(theta)**6 + 2.94596047116321e+37*cos(theta)**4 - 3.02149791914175e+35*cos(theta)**2 + 4.79602844308214e+32)*cos(21*phi)

@torch.jit.script
def Yl41_m22(theta, phi):
    return 2.84693768312126e-35*(1.0 - cos(theta)**2)**11*(5.31218541909186e+43*cos(theta)**19 - 1.12146136625273e+44*cos(theta)**17 + 9.65308517787156e+43*cos(theta)**15 - 4.38776598994162e+43*cos(theta)**13 + 1.14081915738482e+43*cos(theta)**11 - 1.71904256592233e+42*cos(theta)**9 + 1.45271202754e+41*cos(theta)**7 - 6.31613925017391e+39*cos(theta)**5 + 1.17838418846528e+38*cos(theta)**3 - 6.0429958382835e+35*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl41_m23(theta, phi):
    return 8.16415372321275e-37*(1.0 - cos(theta)**2)**11.5*(1.00931522962745e+45*cos(theta)**18 - 1.90648432262963e+45*cos(theta)**16 + 1.44796277668073e+45*cos(theta)**14 - 5.70409578692411e+44*cos(theta)**12 + 1.2549010731233e+44*cos(theta)**10 - 1.5471383093301e+43*cos(theta)**8 + 1.016898419278e+42*cos(theta)**6 - 3.15806962508696e+40*cos(theta)**4 + 3.53515256539585e+38*cos(theta)**2 - 6.0429958382835e+35)*cos(23*phi)

@torch.jit.script
def Yl41_m24(theta, phi):
    return 2.3868121645997e-38*(1.0 - cos(theta)**2)**12*(1.81676741332942e+46*cos(theta)**17 - 3.05037491620741e+46*cos(theta)**15 + 2.02714788735303e+46*cos(theta)**13 - 6.84491494430893e+45*cos(theta)**11 + 1.2549010731233e+45*cos(theta)**9 - 1.23771064746408e+44*cos(theta)**7 + 6.101390515668e+42*cos(theta)**5 - 1.26322785003478e+41*cos(theta)**3 + 7.07030513079169e+38*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl41_m25(theta, phi):
    return 7.12560614995579e-40*(1.0 - cos(theta)**2)**12.5*(3.08850460266001e+47*cos(theta)**16 - 4.57556237431112e+47*cos(theta)**14 + 2.63529225355894e+47*cos(theta)**12 - 7.52940643873982e+46*cos(theta)**10 + 1.12941096581097e+46*cos(theta)**8 - 8.66397453224856e+44*cos(theta)**6 + 3.050695257834e+43*cos(theta)**4 - 3.78968355010435e+41*cos(theta)**2 + 7.07030513079169e+38)*cos(25*phi)

@torch.jit.script
def Yl41_m26(theta, phi):
    return 2.17632836010492e-41*(1.0 - cos(theta)**2)**13*(4.94160736425601e+48*cos(theta)**15 - 6.40578732403557e+48*cos(theta)**13 + 3.16235070427072e+48*cos(theta)**11 - 7.52940643873982e+47*cos(theta)**9 + 9.03528772648778e+46*cos(theta)**7 - 5.19838471934914e+45*cos(theta)**5 + 1.2202781031336e+44*cos(theta)**3 - 7.5793671002087e+41*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl41_m27(theta, phi):
    return 6.81434842237606e-43*(1.0 - cos(theta)**2)**13.5*(7.41241104638402e+49*cos(theta)**14 - 8.32752352124624e+49*cos(theta)**12 + 3.4785857746978e+49*cos(theta)**10 - 6.77646579486584e+48*cos(theta)**8 + 6.32470140854145e+47*cos(theta)**6 - 2.59919235967457e+46*cos(theta)**4 + 3.6608343094008e+44*cos(theta)**2 - 7.5793671002087e+41)*cos(27*phi)

@torch.jit.script
def Yl41_m28(theta, phi):
    return 2.19248066632502e-44*(1.0 - cos(theta)**2)**14*(1.03773754649376e+51*cos(theta)**13 - 9.99302822549549e+50*cos(theta)**11 + 3.4785857746978e+50*cos(theta)**9 - 5.42117263589267e+49*cos(theta)**7 + 3.79482084512487e+48*cos(theta)**5 - 1.03967694386983e+47*cos(theta)**3 + 7.3216686188016e+44*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl41_m29(theta, phi):
    return 7.26800263703634e-46*(1.0 - cos(theta)**2)**14.5*(1.34905881044189e+52*cos(theta)**12 - 1.0992331048045e+52*cos(theta)**10 + 3.13072719722802e+51*cos(theta)**8 - 3.79482084512487e+50*cos(theta)**6 + 1.89741042256243e+49*cos(theta)**4 - 3.11903083160948e+47*cos(theta)**2 + 7.3216686188016e+44)*cos(29*phi)

@torch.jit.script
def Yl41_m30(theta, phi):
    return 2.48997667494702e-47*(1.0 - cos(theta)**2)**15*(1.61887057253027e+53*cos(theta)**11 - 1.0992331048045e+53*cos(theta)**9 + 2.50458175778241e+52*cos(theta)**7 - 2.27689250707492e+51*cos(theta)**5 + 7.58964169024974e+49*cos(theta)**3 - 6.23806166321896e+47*cos(theta))*cos(30*phi)

@torch.jit.script
def Yl41_m31(theta, phi):
    return 8.84774684679108e-49*(1.0 - cos(theta)**2)**15.5*(1.7807576297833e+54*cos(theta)**10 - 9.89309794324053e+53*cos(theta)**8 + 1.75320723044769e+53*cos(theta)**6 - 1.13844625353746e+52*cos(theta)**4 + 2.27689250707492e+50*cos(theta)**2 - 6.23806166321896e+47)*cos(31*phi)

@torch.jit.script
def Yl41_m32(theta, phi):
    return 3.27469802570795e-50*(1.0 - cos(theta)**2)**16*(1.7807576297833e+55*cos(theta)**9 - 7.91447835459243e+54*cos(theta)**7 + 1.05192433826861e+54*cos(theta)**5 - 4.55378501414984e+52*cos(theta)**3 + 4.55378501414984e+50*cos(theta))*cos(32*phi)

@torch.jit.script
def Yl41_m33(theta, phi):
    return 1.26891971029199e-51*(1.0 - cos(theta)**2)**16.5*(1.60268186680497e+56*cos(theta)**8 - 5.5401348482147e+55*cos(theta)**6 + 5.25962169134307e+54*cos(theta)**4 - 1.36613550424495e+53*cos(theta)**2 + 4.55378501414984e+50)*cos(33*phi)

@torch.jit.script
def Yl41_m34(theta, phi):
    return 5.18034302462604e-53*(1.0 - cos(theta)**2)**17*(1.28214549344397e+57*cos(theta)**7 - 3.32408090892882e+56*cos(theta)**5 + 2.10384867653723e+55*cos(theta)**3 - 2.73227100848991e+53*cos(theta))*cos(34*phi)

@torch.jit.script
def Yl41_m35(theta, phi):
    return 2.24596354110399e-54*(1.0 - cos(theta)**2)**17.5*(8.97501845410781e+57*cos(theta)**6 - 1.66204045446441e+57*cos(theta)**4 + 6.31154602961168e+55*cos(theta)**2 - 2.73227100848991e+53)*cos(35*phi)

@torch.jit.script
def Yl41_m36(theta, phi):
    return 1.04491680606395e-55*(1.0 - cos(theta)**2)**18*(5.38501107246469e+58*cos(theta)**5 - 6.64816181785764e+57*cos(theta)**3 + 1.26230920592234e+56*cos(theta))*cos(36*phi)

@torch.jit.script
def Yl41_m37(theta, phi):
    return 5.29114192414144e-57*(1.0 - cos(theta)**2)**18.5*(2.69250553623234e+59*cos(theta)**4 - 1.99444854535729e+58*cos(theta)**2 + 1.26230920592234e+56)*cos(37*phi)

@torch.jit.script
def Yl41_m38(theta, phi):
    return 2.97649988046699e-58*(1.0 - cos(theta)**2)**19*(1.07700221449294e+60*cos(theta)**3 - 3.98889709071458e+58*cos(theta))*cos(38*phi)

@torch.jit.script
def Yl41_m39(theta, phi):
    return 1.92132241117284e-59*(1.0 - cos(theta)**2)**19.5*(3.23100664347881e+60*cos(theta)**2 - 3.98889709071458e+58)*cos(39*phi)

@torch.jit.script
def Yl41_m40(theta, phi):
    return 9.75462521665048*(1.0 - cos(theta)**2)**20*cos(40*phi)*cos(theta)

@torch.jit.script
def Yl41_m41(theta, phi):
    return 1.07721814896289*(1.0 - cos(theta)**2)**20.5*cos(41*phi)

@torch.jit.script
def Yl42_m_minus_42(theta, phi):
    return 1.08361119113624*(1.0 - cos(theta)**2)**21*sin(42*phi)

@torch.jit.script
def Yl42_m_minus_41(theta, phi):
    return 9.93146061456615*(1.0 - cos(theta)**2)**20.5*sin(41*phi)*cos(theta)

@torch.jit.script
def Yl42_m_minus_40(theta, phi):
    return 2.38572965876905e-61*(1.0 - cos(theta)**2)**20*(2.68173551408741e+62*cos(theta)**2 - 3.23100664347881e+60)*sin(40*phi)

@torch.jit.script
def Yl42_m_minus_39(theta, phi):
    return 3.74187075827541e-60*(1.0 - cos(theta)**2)**19.5*(8.93911838029138e+61*cos(theta)**3 - 3.23100664347881e+60*cos(theta))*sin(39*phi)

@torch.jit.script
def Yl42_m_minus_38(theta, phi):
    return 6.73536736489573e-59*(1.0 - cos(theta)**2)**19*(2.23477959507285e+61*cos(theta)**4 - 1.61550332173941e+60*cos(theta)**2 + 9.97224272678646e+57)*sin(38*phi)

@torch.jit.script
def Yl42_m_minus_37(theta, phi):
    return 1.34707347297915e-57*(1.0 - cos(theta)**2)**18.5*(4.46955919014569e+60*cos(theta)**5 - 5.38501107246469e+59*cos(theta)**3 + 9.97224272678646e+57*cos(theta))*sin(37*phi)

@torch.jit.script
def Yl42_m_minus_36(theta, phi):
    return 2.93278654238651e-56*(1.0 - cos(theta)**2)**18*(7.44926531690948e+59*cos(theta)**6 - 1.34625276811617e+59*cos(theta)**4 + 4.98612136339323e+57*cos(theta)**2 - 2.10384867653723e+55)*sin(36*phi)

@torch.jit.script
def Yl42_m_minus_35(theta, phi):
    return 6.85293758117573e-55*(1.0 - cos(theta)**2)**17.5*(1.0641807595585e+59*cos(theta)**7 - 2.69250553623234e+58*cos(theta)**5 + 1.66204045446441e+57*cos(theta)**3 - 2.10384867653723e+55*cos(theta))*sin(35*phi)

@torch.jit.script
def Yl42_m_minus_34(theta, phi):
    return 1.70085437797474e-53*(1.0 - cos(theta)**2)**17*(1.33022594944812e+58*cos(theta)**8 - 4.48750922705391e+57*cos(theta)**6 + 4.15510113616102e+56*cos(theta)**4 - 1.05192433826861e+55*cos(theta)**2 + 3.41533876061238e+52)*sin(34*phi)

@torch.jit.script
def Yl42_m_minus_33(theta, phi):
    return 4.44831141076236e-52*(1.0 - cos(theta)**2)**16.5*(1.47802883272014e+57*cos(theta)**9 - 6.41072746721987e+56*cos(theta)**7 + 8.31020227232205e+55*cos(theta)**5 - 3.50641446089538e+54*cos(theta)**3 + 3.41533876061238e+52*cos(theta))*sin(33*phi)

@torch.jit.script
def Yl42_m_minus_32(theta, phi):
    return 1.21822025124109e-50*(1.0 - cos(theta)**2)**16*(1.47802883272014e+56*cos(theta)**10 - 8.01340933402483e+55*cos(theta)**8 + 1.38503371205367e+55*cos(theta)**6 - 8.76603615223845e+53*cos(theta)**4 + 1.70766938030619e+52*cos(theta)**2 - 4.55378501414984e+49)*sin(32*phi)

@torch.jit.script
def Yl42_m_minus_31(theta, phi):
    return 3.4756658535518e-49*(1.0 - cos(theta)**2)**15.5*(1.34366257520012e+55*cos(theta)**11 - 8.90378814891648e+54*cos(theta)**9 + 1.97861958864811e+54*cos(theta)**7 - 1.75320723044769e+53*cos(theta)**5 + 5.6922312676873e+51*cos(theta)**3 - 4.55378501414984e+49*cos(theta))*sin(31*phi)

@torch.jit.script
def Yl42_m_minus_30(theta, phi):
    return 1.02870315144741e-47*(1.0 - cos(theta)**2)**15*(1.11971881266677e+54*cos(theta)**12 - 8.90378814891648e+53*cos(theta)**10 + 2.47327448581013e+53*cos(theta)**8 - 2.92201205074615e+52*cos(theta)**6 + 1.42305781692183e+51*cos(theta)**4 - 2.27689250707492e+49*cos(theta)**2 + 5.19838471934914e+46)*sin(30*phi)

@torch.jit.script
def Yl42_m_minus_29(theta, phi):
    return 3.14722646575483e-46*(1.0 - cos(theta)**2)**14.5*(8.61322163589823e+52*cos(theta)**13 - 8.09435286265135e+52*cos(theta)**11 + 2.74808276201126e+52*cos(theta)**9 - 4.17430292963736e+51*cos(theta)**7 + 2.84611563384365e+50*cos(theta)**5 - 7.58964169024974e+48*cos(theta)**3 + 5.19838471934914e+46*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl42_m_minus_28(theta, phi):
    return 9.92250181163357e-45*(1.0 - cos(theta)**2)**14*(6.15230116849873e+51*cos(theta)**14 - 6.74529405220946e+51*cos(theta)**12 + 2.74808276201126e+51*cos(theta)**10 - 5.2178786620467e+50*cos(theta)**8 + 4.74352605640609e+49*cos(theta)**6 - 1.89741042256243e+48*cos(theta)**4 + 2.59919235967457e+46*cos(theta)**2 - 5.229763299144e+43)*sin(28*phi)

@torch.jit.script
def Yl42_m_minus_27(theta, phi):
    return 3.21525806603397e-43*(1.0 - cos(theta)**2)**13.5*(4.10153411233249e+50*cos(theta)**15 - 5.18868773246881e+50*cos(theta)**13 + 2.49825705637387e+50*cos(theta)**11 - 5.79764295782966e+49*cos(theta)**9 + 6.77646579486584e+48*cos(theta)**7 - 3.79482084512487e+47*cos(theta)**5 + 8.66397453224856e+45*cos(theta)**3 - 5.229763299144e+43*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl42_m_minus_26(theta, phi):
    return 1.0683175750703e-41*(1.0 - cos(theta)**2)**13*(2.56345882020781e+49*cos(theta)**16 - 3.70620552319201e+49*cos(theta)**14 + 2.08188088031156e+49*cos(theta)**12 - 5.79764295782966e+48*cos(theta)**10 + 8.4705822435823e+47*cos(theta)**8 - 6.32470140854145e+46*cos(theta)**6 + 2.16599363306214e+45*cos(theta)**4 - 2.614881649572e+43*cos(theta)**2 + 4.73710443763043e+40)*sin(26*phi)

@torch.jit.script
def Yl42_m_minus_25(theta, phi):
    return 3.63227975523903e-40*(1.0 - cos(theta)**2)**12.5*(1.50791695306342e+48*cos(theta)**17 - 2.47080368212801e+48*cos(theta)**15 + 1.60144683100889e+48*cos(theta)**13 - 5.27058450711787e+47*cos(theta)**11 + 9.41175804842478e+46*cos(theta)**9 - 9.03528772648778e+45*cos(theta)**7 + 4.33198726612428e+44*cos(theta)**5 - 8.71627216524e+42*cos(theta)**3 + 4.73710443763043e+40*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl42_m_minus_24(theta, phi):
    return 1.26140034095862e-38*(1.0 - cos(theta)**2)**12*(8.37731640590786e+46*cos(theta)**18 - 1.54425230133e+47*cos(theta)**16 + 1.14389059357778e+47*cos(theta)**14 - 4.39215375593156e+46*cos(theta)**12 + 9.41175804842478e+45*cos(theta)**10 - 1.12941096581097e+45*cos(theta)**8 + 7.2199787768738e+43*cos(theta)**6 - 2.17906804131e+42*cos(theta)**4 + 2.36855221881522e+40*cos(theta)**2 - 3.92794729488427e+37)*sin(24*phi)

@torch.jit.script
def Yl42_m_minus_23(theta, phi):
    return 4.46685353296235e-37*(1.0 - cos(theta)**2)**11.5*(4.40911389784624e+45*cos(theta)**19 - 9.08383706664708e+45*cos(theta)**17 + 7.62593729051854e+45*cos(theta)**15 - 3.37857981225505e+45*cos(theta)**13 + 8.55614368038616e+44*cos(theta)**11 - 1.2549010731233e+44*cos(theta)**9 + 1.0314255395534e+43*cos(theta)**7 - 4.35813608262e+41*cos(theta)**5 + 7.89517406271739e+39*cos(theta)**3 - 3.92794729488427e+37*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl42_m_minus_22(theta, phi):
    return 1.61054694530832e-35*(1.0 - cos(theta)**2)**11*(2.20455694892312e+44*cos(theta)**20 - 5.04657614813727e+44*cos(theta)**18 + 4.76621080657408e+44*cos(theta)**16 - 2.41327129446789e+44*cos(theta)**14 + 7.13011973365513e+43*cos(theta)**12 - 1.2549010731233e+43*cos(theta)**10 + 1.28928192444175e+42*cos(theta)**8 - 7.2635601377e+40*cos(theta)**6 + 1.97379351567935e+39*cos(theta)**4 - 1.96397364744214e+37*cos(theta)**2 + 3.02149791914175e+34)*sin(22*phi)

@torch.jit.script
def Yl42_m_minus_21(theta, phi):
    return 5.90436262972423e-34*(1.0 - cos(theta)**2)**10.5*(1.04978902329672e+43*cos(theta)**21 - 2.65609270954593e+43*cos(theta)**19 + 2.80365341563181e+43*cos(theta)**17 - 1.60884752964526e+43*cos(theta)**15 + 5.48470748742703e+42*cos(theta)**13 - 1.14081915738482e+42*cos(theta)**11 + 1.43253547160194e+41*cos(theta)**9 - 1.03765144824286e+40*cos(theta)**7 + 3.9475870313587e+38*cos(theta)**5 - 6.54657882480712e+36*cos(theta)**3 + 3.02149791914175e+34*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl42_m_minus_20(theta, phi):
    return 2.19813639967386e-32*(1.0 - cos(theta)**2)**10*(4.77176828771238e+41*cos(theta)**22 - 1.32804635477296e+42*cos(theta)**20 + 1.55758523090656e+42*cos(theta)**18 - 1.00552970602829e+42*cos(theta)**16 + 3.91764820530502e+41*cos(theta)**14 - 9.50682631154018e+40*cos(theta)**12 + 1.43253547160194e+40*cos(theta)**10 - 1.29706431030357e+39*cos(theta)**8 + 6.57931171893116e+37*cos(theta)**6 - 1.63664470620178e+36*cos(theta)**4 + 1.51074895957087e+34*cos(theta)**2 - 2.1800129286737e+31)*sin(20*phi)

@torch.jit.script
def Yl42_m_minus_19(theta, phi):
    return 8.30069393401569e-31*(1.0 - cos(theta)**2)**9.5*(2.07468186422278e+40*cos(theta)**23 - 6.32403026082364e+40*cos(theta)**21 + 8.19781700477139e+40*cos(theta)**19 - 5.91488062369581e+40*cos(theta)**17 + 2.61176547020335e+40*cos(theta)**15 - 7.31294331656937e+39*cos(theta)**13 + 1.30230497418359e+39*cos(theta)**11 - 1.44118256700397e+38*cos(theta)**9 + 9.39901674133023e+36*cos(theta)**7 - 3.27328941240356e+35*cos(theta)**5 + 5.03582986523625e+33*cos(theta)**3 - 2.1800129286737e+31*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl42_m_minus_18(theta, phi):
    return 3.17603250876001e-29*(1.0 - cos(theta)**2)**9*(8.6445077675949e+38*cos(theta)**24 - 2.87455920946529e+39*cos(theta)**22 + 4.09890850238569e+39*cos(theta)**20 - 3.28604479094212e+39*cos(theta)**18 + 1.63235341887709e+39*cos(theta)**16 - 5.22353094040669e+38*cos(theta)**14 + 1.08525414515299e+38*cos(theta)**12 - 1.44118256700397e+37*cos(theta)**10 + 1.17487709266628e+36*cos(theta)**8 - 5.45548235400594e+34*cos(theta)**6 + 1.25895746630906e+33*cos(theta)**4 - 1.09000646433685e+31*cos(theta)**2 + 1.48907986931264e+28)*sin(18*phi)

@torch.jit.script
def Yl42_m_minus_17(theta, phi):
    return 1.23007210134409e-27*(1.0 - cos(theta)**2)**8.5*(3.45780310703796e+37*cos(theta)**25 - 1.24980835194143e+38*cos(theta)**23 + 1.95186119161224e+38*cos(theta)**21 - 1.72949725839059e+38*cos(theta)**19 + 9.60207893457112e+37*cos(theta)**17 - 3.48235396027113e+37*cos(theta)**15 + 8.34810880886914e+36*cos(theta)**13 - 1.31016597000361e+36*cos(theta)**11 + 1.30541899185142e+35*cos(theta)**9 - 7.79354622000848e+33*cos(theta)**7 + 2.51791493261812e+32*cos(theta)**5 - 3.63335488112284e+30*cos(theta)**3 + 1.48907986931264e+28*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl42_m_minus_16(theta, phi):
    return 4.81773877715548e-26*(1.0 - cos(theta)**2)**8*(1.32992427193768e+36*cos(theta)**26 - 5.20753479975596e+36*cos(theta)**24 + 8.87209632551016e+36*cos(theta)**22 - 8.64748629195294e+36*cos(theta)**20 + 5.33448829698396e+36*cos(theta)**18 - 2.17647122516945e+36*cos(theta)**16 + 5.96293486347796e+35*cos(theta)**14 - 1.09180497500301e+35*cos(theta)**12 + 1.30541899185142e+34*cos(theta)**10 - 9.7419327750106e+32*cos(theta)**8 + 4.19652488769687e+31*cos(theta)**6 - 9.08338720280709e+29*cos(theta)**4 + 7.44539934656319e+27*cos(theta)**2 - 9.70716994336791e+24)*sin(16*phi)

@torch.jit.script
def Yl42_m_minus_15(theta, phi):
    return 1.90651017422948e-24*(1.0 - cos(theta)**2)**7.5*(4.92564545162103e+34*cos(theta)**27 - 2.08301391990239e+35*cos(theta)**25 + 3.85743318500442e+35*cos(theta)**23 - 4.11785061521569e+35*cos(theta)**21 + 2.80762541946524e+35*cos(theta)**19 - 1.28027719127615e+35*cos(theta)**17 + 3.97528990898531e+34*cos(theta)**15 - 8.39849980771543e+33*cos(theta)**13 + 1.18674453804675e+33*cos(theta)**11 - 1.08243697500118e+32*cos(theta)**9 + 5.99503555385268e+30*cos(theta)**7 - 1.81667744056142e+29*cos(theta)**5 + 2.48179978218773e+27*cos(theta)**3 - 9.70716994336791e+24*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl42_m_minus_14(theta, phi):
    return 7.61650218074352e-23*(1.0 - cos(theta)**2)**7*(1.75915908986465e+33*cos(theta)**28 - 8.01159199962456e+33*cos(theta)**26 + 1.60726382708517e+34*cos(theta)**24 - 1.87175027964349e+34*cos(theta)**22 + 1.40381270973262e+34*cos(theta)**20 - 7.11265106264528e+33*cos(theta)**18 + 2.48455619311582e+33*cos(theta)**16 - 5.99892843408245e+32*cos(theta)**14 + 9.88953781705622e+31*cos(theta)**12 - 1.08243697500118e+31*cos(theta)**10 + 7.49379444231585e+29*cos(theta)**8 - 3.02779573426903e+28*cos(theta)**6 + 6.20449945546932e+26*cos(theta)**4 - 4.85358497168395e+24*cos(theta)**2 + 6.08218668130821e+21)*sin(14*phi)

@torch.jit.script
def Yl42_m_minus_13(theta, phi):
    return 3.06936532987026e-21*(1.0 - cos(theta)**2)**6.5*(6.06606582711949e+31*cos(theta)**29 - 2.96725629615724e+32*cos(theta)**27 + 6.4290553083407e+32*cos(theta)**25 - 8.13804469410215e+32*cos(theta)**23 + 6.68482242729819e+32*cos(theta)**21 - 3.74350055928699e+32*cos(theta)**19 + 1.4615036430093e+32*cos(theta)**17 - 3.99928562272163e+31*cos(theta)**15 + 7.60733678235094e+30*cos(theta)**13 - 9.84033613637434e+29*cos(theta)**11 + 8.32643826923983e+28*cos(theta)**9 - 4.32542247752718e+27*cos(theta)**7 + 1.24089989109386e+26*cos(theta)**5 - 1.61786165722798e+24*cos(theta)**3 + 6.08218668130821e+21*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl42_m_minus_12(theta, phi):
    return 1.24678209088621e-19*(1.0 - cos(theta)**2)**6*(2.02202194237316e+30*cos(theta)**30 - 1.05973439148473e+31*cos(theta)**28 + 2.47271358013104e+31*cos(theta)**26 - 3.39085195587589e+31*cos(theta)**24 + 3.03855564877191e+31*cos(theta)**22 - 1.87175027964349e+31*cos(theta)**20 + 8.11946468338502e+30*cos(theta)**18 - 2.49955351420102e+30*cos(theta)**16 + 5.43381198739353e+29*cos(theta)**14 - 8.20028011364529e+28*cos(theta)**12 + 8.32643826923983e+27*cos(theta)**10 - 5.40677809690898e+26*cos(theta)**8 + 2.06816648515644e+25*cos(theta)**6 - 4.04465414306996e+23*cos(theta)**4 + 3.04109334065411e+21*cos(theta)**2 - 3.6861737462474e+18)*sin(12*phi)

@torch.jit.script
def Yl42_m_minus_11(theta, phi):
    return 5.10115220761621e-18*(1.0 - cos(theta)**2)**5.5*(6.5226514270102e+28*cos(theta)**31 - 3.65425652236114e+29*cos(theta)**29 + 9.15819844492977e+29*cos(theta)**27 - 1.35634078235036e+30*cos(theta)**25 + 1.32111115163996e+30*cos(theta)**23 - 8.91309656973092e+29*cos(theta)**21 + 4.27340246493948e+29*cos(theta)**19 - 1.47032559658884e+29*cos(theta)**17 + 3.62254132492902e+28*cos(theta)**15 - 6.30790777972714e+27*cos(theta)**13 + 7.56948933567257e+26*cos(theta)**11 - 6.00753121878776e+25*cos(theta)**9 + 2.95452355022349e+24*cos(theta)**7 - 8.08930828613992e+22*cos(theta)**5 + 1.01369778021804e+21*cos(theta)**3 - 3.6861737462474e+18*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl42_m_minus_10(theta, phi):
    return 2.10078305689983e-16*(1.0 - cos(theta)**2)**5*(2.03832857094069e+27*cos(theta)**32 - 1.21808550745371e+28*cos(theta)**30 + 3.27078515890349e+28*cos(theta)**28 - 5.21669531673214e+28*cos(theta)**26 + 5.50462979849983e+28*cos(theta)**24 - 4.05140753169587e+28*cos(theta)**22 + 2.13670123246974e+28*cos(theta)**20 - 8.16847553660465e+27*cos(theta)**18 + 2.26408832808064e+27*cos(theta)**16 - 4.50564841409082e+26*cos(theta)**14 + 6.30790777972714e+25*cos(theta)**12 - 6.00753121878776e+24*cos(theta)**10 + 3.69315443777936e+23*cos(theta)**8 - 1.34821804768999e+22*cos(theta)**6 + 2.53424445054509e+20*cos(theta)**4 - 1.8430868731237e+18*cos(theta)**2 + 2.17345150132512e+15)*sin(10*phi)

@torch.jit.script
def Yl42_m_minus_9(theta, phi):
    return 8.70241615868955e-15*(1.0 - cos(theta)**2)**4.5*(6.17675324527481e+25*cos(theta)**33 - 3.92930808856036e+26*cos(theta)**31 + 1.12785695134603e+27*cos(theta)**29 - 1.93210937656746e+27*cos(theta)**27 + 2.20185191939993e+27*cos(theta)**25 - 1.76148153551995e+27*cos(theta)**23 + 1.01747677736654e+27*cos(theta)**21 - 4.29919765084455e+26*cos(theta)**19 + 1.33181666357684e+26*cos(theta)**17 - 3.00376560939388e+25*cos(theta)**15 + 4.85223675363626e+24*cos(theta)**13 - 5.46139201707978e+23*cos(theta)**11 + 4.10350493086595e+22*cos(theta)**9 - 1.92602578241427e+21*cos(theta)**7 + 5.06848890109018e+19*cos(theta)**5 - 6.14362291041234e+17*cos(theta)**3 + 2.17345150132512e+15*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl42_m_minus_8(theta, phi):
    return 3.62380145008391e-13*(1.0 - cos(theta)**2)**4*(1.81669213096318e+24*cos(theta)**34 - 1.22790877767511e+25*cos(theta)**32 + 3.75952317115343e+25*cos(theta)**30 - 6.90039063059808e+25*cos(theta)**28 + 8.46866122846127e+25*cos(theta)**26 - 7.33950639799977e+25*cos(theta)**24 + 4.6248944425752e+25*cos(theta)**22 - 2.14959882542228e+25*cos(theta)**20 + 7.3989814643158e+24*cos(theta)**18 - 1.87735350587117e+24*cos(theta)**16 + 3.46588339545447e+23*cos(theta)**14 - 4.55116001423315e+22*cos(theta)**12 + 4.10350493086595e+21*cos(theta)**10 - 2.40753222801783e+20*cos(theta)**8 + 8.44748150181696e+18*cos(theta)**6 - 1.53590572760308e+17*cos(theta)**4 + 1.08672575066256e+15*cos(theta)**2 - 1253432238365.12)*sin(8*phi)

@torch.jit.script
def Yl42_m_minus_7(theta, phi):
    return 1.51594490869071e-11*(1.0 - cos(theta)**2)**3.5*(5.19054894560909e+22*cos(theta)**35 - 3.72093568992459e+23*cos(theta)**33 + 1.21274941004949e+24*cos(theta)**31 - 2.37944504503382e+24*cos(theta)**29 + 3.1365411957264e+24*cos(theta)**27 - 2.93580255919991e+24*cos(theta)**25 + 2.01082367068487e+24*cos(theta)**23 - 1.02361848829632e+24*cos(theta)**21 + 3.89420077069253e+23*cos(theta)**19 - 1.10432559168893e+23*cos(theta)**17 + 2.31058893030298e+22*cos(theta)**15 - 3.50089231864088e+21*cos(theta)**13 + 3.73045902805996e+20*cos(theta)**11 - 2.67503580890871e+19*cos(theta)**9 + 1.20678307168814e+18*cos(theta)**7 - 3.07181145520617e+16*cos(theta)**5 + 362241916887520.0*cos(theta)**3 - 1253432238365.12*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl42_m_minus_6(theta, phi):
    return 6.36696861650099e-10*(1.0 - cos(theta)**2)**3*(1.44181915155808e+21*cos(theta)**36 - 1.09439284997782e+22*cos(theta)**34 + 3.78984190640467e+22*cos(theta)**32 - 7.93148348344606e+22*cos(theta)**30 + 1.120193284188e+23*cos(theta)**28 - 1.1291548304615e+23*cos(theta)**26 + 8.37843196118695e+22*cos(theta)**24 - 4.65281131043783e+22*cos(theta)**22 + 1.94710038534626e+22*cos(theta)**20 - 6.13514217604959e+21*cos(theta)**18 + 1.44411808143936e+21*cos(theta)**16 - 2.50063737045777e+20*cos(theta)**14 + 3.10871585671663e+19*cos(theta)**12 - 2.67503580890871e+18*cos(theta)**10 + 1.50847883961017e+17*cos(theta)**8 - 5.11968575867695e+15*cos(theta)**6 + 90560479221880.0*cos(theta)**4 - 626716119182.56*cos(theta)**2 + 710562493.404263)*sin(6*phi)

@torch.jit.script
def Yl42_m_minus_5(theta, phi):
    return 2.68320707194937e-8*(1.0 - cos(theta)**2)**2.5*(3.89680851772454e+19*cos(theta)**37 - 3.12683671422234e+20*cos(theta)**35 + 1.14843694133475e+21*cos(theta)**33 - 2.55854305917615e+21*cos(theta)**31 + 3.86273546271724e+21*cos(theta)**29 - 4.1820549276352e+21*cos(theta)**27 + 3.35137278447478e+21*cos(theta)**25 - 2.02296143932079e+21*cos(theta)**23 + 9.27190659688697e+20*cos(theta)**21 - 3.22902219792084e+20*cos(theta)**19 + 8.49481224376097e+19*cos(theta)**17 - 1.66709158030518e+19*cos(theta)**15 + 2.39131988978202e+18*cos(theta)**13 - 2.43185073537155e+17*cos(theta)**11 + 1.67608759956686e+16*cos(theta)**9 - 731383679810993.0*cos(theta)**7 + 18112095844376.0*cos(theta)**5 - 208905373060.853*cos(theta)**3 + 710562493.404263*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl42_m_minus_4(theta, phi):
    return 1.13395264191469e-6*(1.0 - cos(theta)**2)**2*(1.02547592571698e+18*cos(theta)**38 - 8.6856575395065e+18*cos(theta)**36 + 3.37775570980809e+19*cos(theta)**34 - 7.99544705992547e+19*cos(theta)**32 + 1.28757848757241e+20*cos(theta)**30 - 1.493591045584e+20*cos(theta)**28 + 1.2889895324903e+20*cos(theta)**26 - 8.42900599716997e+19*cos(theta)**24 + 4.21450299858499e+19*cos(theta)**22 - 1.61451109896042e+19*cos(theta)**20 + 4.71934013542276e+18*cos(theta)**18 - 1.04193223769074e+18*cos(theta)**16 + 1.70808563555859e+17*cos(theta)**14 - 2.02654227947629e+16*cos(theta)**12 + 1.67608759956686e+15*cos(theta)**10 - 91422959976374.1*cos(theta)**8 + 3018682640729.33*cos(theta)**6 - 52226343265.2134*cos(theta)**4 + 355281246.702132*cos(theta)**2 - 397851.340091973)*sin(4*phi)

@torch.jit.script
def Yl42_m_minus_3(theta, phi):
    return 4.80292866678749e-5*(1.0 - cos(theta)**2)**1.5*(2.62942545055637e+16*cos(theta)**39 - 2.34747501067743e+17*cos(theta)**37 + 9.65073059945167e+17*cos(theta)**35 - 2.42286274543196e+18*cos(theta)**33 + 4.15347899216907e+18*cos(theta)**31 - 5.15031395028965e+18*cos(theta)**29 + 4.77403530551963e+18*cos(theta)**27 - 3.37160239886799e+18*cos(theta)**25 + 1.83239260808043e+18*cos(theta)**23 - 7.6881480902877e+17*cos(theta)**21 + 2.48386322916987e+17*cos(theta)**19 - 6.1290131628867e+16*cos(theta)**17 + 1.13872375703906e+16*cos(theta)**15 - 1.55887867652022e+15*cos(theta)**13 + 152371599960623.0*cos(theta)**11 - 10158106664041.6*cos(theta)**9 + 431240377247.047*cos(theta)**7 - 10445268653.0427*cos(theta)**5 + 118427082.234044*cos(theta)**3 - 397851.340091973*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl42_m_minus_2(theta, phi):
    return 0.00203771005790442*(1.0 - cos(theta)**2)*(657356362639093.0*cos(theta)**40 - 6.17756581757219e+15*cos(theta)**38 + 2.68075849984769e+16*cos(theta)**36 - 7.12606689832929e+16*cos(theta)**34 + 1.29796218505284e+17*cos(theta)**32 - 1.71677131676322e+17*cos(theta)**30 + 1.70501260911415e+17*cos(theta)**28 - 1.29677015341077e+17*cos(theta)**26 + 7.63496920033512e+16*cos(theta)**24 - 3.49461276831259e+16*cos(theta)**22 + 1.24193161458494e+16*cos(theta)**20 - 3.40500731271483e+15*cos(theta)**18 + 711702348149412.0*cos(theta)**16 - 111348476894302.0*cos(theta)**14 + 12697633330052.0*cos(theta)**12 - 1015810666404.16*cos(theta)**10 + 53905047155.8809*cos(theta)**8 - 1740878108.84045*cos(theta)**6 + 29606770.558511*cos(theta)**4 - 198925.670045986*cos(theta)**2 + 221.028522273318)*sin(2*phi)

@torch.jit.script
def Yl42_m_minus_1(theta, phi):
    return 0.0865487212688497*(1.0 - cos(theta)**2)**0.5*(16033082015587.6*cos(theta)**41 - 158399123527492.0*cos(theta)**39 + 724529324283159.0*cos(theta)**37 - 2.03601911380837e+15*cos(theta)**35 + 3.93321874258435e+15*cos(theta)**33 - 5.53797198955877e+15*cos(theta)**31 + 5.87935382453157e+15*cos(theta)**29 - 4.80285242003987e+15*cos(theta)**27 + 3.05398768013405e+15*cos(theta)**25 - 1.51939685578808e+15*cos(theta)**23 + 591396006945208.0*cos(theta)**21 - 179210911195518.0*cos(theta)**19 + 41864844008788.9*cos(theta)**17 - 7423231792953.45*cos(theta)**15 + 976741025388.612*cos(theta)**13 - 92346424218.5597*cos(theta)**11 + 5989449683.98677*cos(theta)**9 - 248696872.691492*cos(theta)**7 + 5921354.1117022*cos(theta)**5 - 66308.5566819955*cos(theta)**3 + 221.028522273318*cos(theta))*sin(phi)

@torch.jit.script
def Yl42_m0(theta, phi):
    return 992823971630.224*cos(theta)**42 - 10299053488838.8*cos(theta)**40 + 49588035316631.4*cos(theta)**38 - 147090248217687.0*cos(theta)**36 + 300866416808906.0*cos(theta)**34 - 450096159546123.0*cos(theta)**32 + 509697934097893.0*cos(theta)**30 - 446113885981053.0*cos(theta)**28 + 305491030617460.0*cos(theta)**26 - 164651052986193.0*cos(theta)**24 + 69913370191060.5*cos(theta)**22 - 23304456730353.5*cos(theta)**20 + 6048971009244.76*cos(theta)**18 - 1206639588545.57*cos(theta)**16 + 181449562187.303*cos(theta)**14 - 20014436556.4177*cos(theta)**12 + 1557727373.49477*cos(theta)**10 - 80850901.738483*cos(theta)**8 + 2566695.29328517*cos(theta)**6 - 43113.5827539503*cos(theta)**4 + 287.423885026335*cos(theta)**2 - 0.318298875998156

@torch.jit.script
def Yl42_m1(theta, phi):
    return 0.0865487212688497*(1.0 - cos(theta)**2)**0.5*(16033082015587.6*cos(theta)**41 - 158399123527492.0*cos(theta)**39 + 724529324283159.0*cos(theta)**37 - 2.03601911380837e+15*cos(theta)**35 + 3.93321874258435e+15*cos(theta)**33 - 5.53797198955877e+15*cos(theta)**31 + 5.87935382453157e+15*cos(theta)**29 - 4.80285242003987e+15*cos(theta)**27 + 3.05398768013405e+15*cos(theta)**25 - 1.51939685578808e+15*cos(theta)**23 + 591396006945208.0*cos(theta)**21 - 179210911195518.0*cos(theta)**19 + 41864844008788.9*cos(theta)**17 - 7423231792953.45*cos(theta)**15 + 976741025388.612*cos(theta)**13 - 92346424218.5597*cos(theta)**11 + 5989449683.98677*cos(theta)**9 - 248696872.691492*cos(theta)**7 + 5921354.1117022*cos(theta)**5 - 66308.5566819955*cos(theta)**3 + 221.028522273318*cos(theta))*cos(phi)

@torch.jit.script
def Yl42_m2(theta, phi):
    return 0.00203771005790442*(1.0 - cos(theta)**2)*(657356362639093.0*cos(theta)**40 - 6.17756581757219e+15*cos(theta)**38 + 2.68075849984769e+16*cos(theta)**36 - 7.12606689832929e+16*cos(theta)**34 + 1.29796218505284e+17*cos(theta)**32 - 1.71677131676322e+17*cos(theta)**30 + 1.70501260911415e+17*cos(theta)**28 - 1.29677015341077e+17*cos(theta)**26 + 7.63496920033512e+16*cos(theta)**24 - 3.49461276831259e+16*cos(theta)**22 + 1.24193161458494e+16*cos(theta)**20 - 3.40500731271483e+15*cos(theta)**18 + 711702348149412.0*cos(theta)**16 - 111348476894302.0*cos(theta)**14 + 12697633330052.0*cos(theta)**12 - 1015810666404.16*cos(theta)**10 + 53905047155.8809*cos(theta)**8 - 1740878108.84045*cos(theta)**6 + 29606770.558511*cos(theta)**4 - 198925.670045986*cos(theta)**2 + 221.028522273318)*cos(2*phi)

@torch.jit.script
def Yl42_m3(theta, phi):
    return 4.80292866678749e-5*(1.0 - cos(theta)**2)**1.5*(2.62942545055637e+16*cos(theta)**39 - 2.34747501067743e+17*cos(theta)**37 + 9.65073059945167e+17*cos(theta)**35 - 2.42286274543196e+18*cos(theta)**33 + 4.15347899216907e+18*cos(theta)**31 - 5.15031395028965e+18*cos(theta)**29 + 4.77403530551963e+18*cos(theta)**27 - 3.37160239886799e+18*cos(theta)**25 + 1.83239260808043e+18*cos(theta)**23 - 7.6881480902877e+17*cos(theta)**21 + 2.48386322916987e+17*cos(theta)**19 - 6.1290131628867e+16*cos(theta)**17 + 1.13872375703906e+16*cos(theta)**15 - 1.55887867652022e+15*cos(theta)**13 + 152371599960623.0*cos(theta)**11 - 10158106664041.6*cos(theta)**9 + 431240377247.047*cos(theta)**7 - 10445268653.0427*cos(theta)**5 + 118427082.234044*cos(theta)**3 - 397851.340091973*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl42_m4(theta, phi):
    return 1.13395264191469e-6*(1.0 - cos(theta)**2)**2*(1.02547592571698e+18*cos(theta)**38 - 8.6856575395065e+18*cos(theta)**36 + 3.37775570980809e+19*cos(theta)**34 - 7.99544705992547e+19*cos(theta)**32 + 1.28757848757241e+20*cos(theta)**30 - 1.493591045584e+20*cos(theta)**28 + 1.2889895324903e+20*cos(theta)**26 - 8.42900599716997e+19*cos(theta)**24 + 4.21450299858499e+19*cos(theta)**22 - 1.61451109896042e+19*cos(theta)**20 + 4.71934013542276e+18*cos(theta)**18 - 1.04193223769074e+18*cos(theta)**16 + 1.70808563555859e+17*cos(theta)**14 - 2.02654227947629e+16*cos(theta)**12 + 1.67608759956686e+15*cos(theta)**10 - 91422959976374.1*cos(theta)**8 + 3018682640729.33*cos(theta)**6 - 52226343265.2134*cos(theta)**4 + 355281246.702132*cos(theta)**2 - 397851.340091973)*cos(4*phi)

@torch.jit.script
def Yl42_m5(theta, phi):
    return 2.68320707194937e-8*(1.0 - cos(theta)**2)**2.5*(3.89680851772454e+19*cos(theta)**37 - 3.12683671422234e+20*cos(theta)**35 + 1.14843694133475e+21*cos(theta)**33 - 2.55854305917615e+21*cos(theta)**31 + 3.86273546271724e+21*cos(theta)**29 - 4.1820549276352e+21*cos(theta)**27 + 3.35137278447478e+21*cos(theta)**25 - 2.02296143932079e+21*cos(theta)**23 + 9.27190659688697e+20*cos(theta)**21 - 3.22902219792084e+20*cos(theta)**19 + 8.49481224376097e+19*cos(theta)**17 - 1.66709158030518e+19*cos(theta)**15 + 2.39131988978202e+18*cos(theta)**13 - 2.43185073537155e+17*cos(theta)**11 + 1.67608759956686e+16*cos(theta)**9 - 731383679810993.0*cos(theta)**7 + 18112095844376.0*cos(theta)**5 - 208905373060.853*cos(theta)**3 + 710562493.404263*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl42_m6(theta, phi):
    return 6.36696861650099e-10*(1.0 - cos(theta)**2)**3*(1.44181915155808e+21*cos(theta)**36 - 1.09439284997782e+22*cos(theta)**34 + 3.78984190640467e+22*cos(theta)**32 - 7.93148348344606e+22*cos(theta)**30 + 1.120193284188e+23*cos(theta)**28 - 1.1291548304615e+23*cos(theta)**26 + 8.37843196118695e+22*cos(theta)**24 - 4.65281131043783e+22*cos(theta)**22 + 1.94710038534626e+22*cos(theta)**20 - 6.13514217604959e+21*cos(theta)**18 + 1.44411808143936e+21*cos(theta)**16 - 2.50063737045777e+20*cos(theta)**14 + 3.10871585671663e+19*cos(theta)**12 - 2.67503580890871e+18*cos(theta)**10 + 1.50847883961017e+17*cos(theta)**8 - 5.11968575867695e+15*cos(theta)**6 + 90560479221880.0*cos(theta)**4 - 626716119182.56*cos(theta)**2 + 710562493.404263)*cos(6*phi)

@torch.jit.script
def Yl42_m7(theta, phi):
    return 1.51594490869071e-11*(1.0 - cos(theta)**2)**3.5*(5.19054894560909e+22*cos(theta)**35 - 3.72093568992459e+23*cos(theta)**33 + 1.21274941004949e+24*cos(theta)**31 - 2.37944504503382e+24*cos(theta)**29 + 3.1365411957264e+24*cos(theta)**27 - 2.93580255919991e+24*cos(theta)**25 + 2.01082367068487e+24*cos(theta)**23 - 1.02361848829632e+24*cos(theta)**21 + 3.89420077069253e+23*cos(theta)**19 - 1.10432559168893e+23*cos(theta)**17 + 2.31058893030298e+22*cos(theta)**15 - 3.50089231864088e+21*cos(theta)**13 + 3.73045902805996e+20*cos(theta)**11 - 2.67503580890871e+19*cos(theta)**9 + 1.20678307168814e+18*cos(theta)**7 - 3.07181145520617e+16*cos(theta)**5 + 362241916887520.0*cos(theta)**3 - 1253432238365.12*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl42_m8(theta, phi):
    return 3.62380145008391e-13*(1.0 - cos(theta)**2)**4*(1.81669213096318e+24*cos(theta)**34 - 1.22790877767511e+25*cos(theta)**32 + 3.75952317115343e+25*cos(theta)**30 - 6.90039063059808e+25*cos(theta)**28 + 8.46866122846127e+25*cos(theta)**26 - 7.33950639799977e+25*cos(theta)**24 + 4.6248944425752e+25*cos(theta)**22 - 2.14959882542228e+25*cos(theta)**20 + 7.3989814643158e+24*cos(theta)**18 - 1.87735350587117e+24*cos(theta)**16 + 3.46588339545447e+23*cos(theta)**14 - 4.55116001423315e+22*cos(theta)**12 + 4.10350493086595e+21*cos(theta)**10 - 2.40753222801783e+20*cos(theta)**8 + 8.44748150181696e+18*cos(theta)**6 - 1.53590572760308e+17*cos(theta)**4 + 1.08672575066256e+15*cos(theta)**2 - 1253432238365.12)*cos(8*phi)

@torch.jit.script
def Yl42_m9(theta, phi):
    return 8.70241615868955e-15*(1.0 - cos(theta)**2)**4.5*(6.17675324527481e+25*cos(theta)**33 - 3.92930808856036e+26*cos(theta)**31 + 1.12785695134603e+27*cos(theta)**29 - 1.93210937656746e+27*cos(theta)**27 + 2.20185191939993e+27*cos(theta)**25 - 1.76148153551995e+27*cos(theta)**23 + 1.01747677736654e+27*cos(theta)**21 - 4.29919765084455e+26*cos(theta)**19 + 1.33181666357684e+26*cos(theta)**17 - 3.00376560939388e+25*cos(theta)**15 + 4.85223675363626e+24*cos(theta)**13 - 5.46139201707978e+23*cos(theta)**11 + 4.10350493086595e+22*cos(theta)**9 - 1.92602578241427e+21*cos(theta)**7 + 5.06848890109018e+19*cos(theta)**5 - 6.14362291041234e+17*cos(theta)**3 + 2.17345150132512e+15*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl42_m10(theta, phi):
    return 2.10078305689983e-16*(1.0 - cos(theta)**2)**5*(2.03832857094069e+27*cos(theta)**32 - 1.21808550745371e+28*cos(theta)**30 + 3.27078515890349e+28*cos(theta)**28 - 5.21669531673214e+28*cos(theta)**26 + 5.50462979849983e+28*cos(theta)**24 - 4.05140753169587e+28*cos(theta)**22 + 2.13670123246974e+28*cos(theta)**20 - 8.16847553660465e+27*cos(theta)**18 + 2.26408832808064e+27*cos(theta)**16 - 4.50564841409082e+26*cos(theta)**14 + 6.30790777972714e+25*cos(theta)**12 - 6.00753121878776e+24*cos(theta)**10 + 3.69315443777936e+23*cos(theta)**8 - 1.34821804768999e+22*cos(theta)**6 + 2.53424445054509e+20*cos(theta)**4 - 1.8430868731237e+18*cos(theta)**2 + 2.17345150132512e+15)*cos(10*phi)

@torch.jit.script
def Yl42_m11(theta, phi):
    return 5.10115220761621e-18*(1.0 - cos(theta)**2)**5.5*(6.5226514270102e+28*cos(theta)**31 - 3.65425652236114e+29*cos(theta)**29 + 9.15819844492977e+29*cos(theta)**27 - 1.35634078235036e+30*cos(theta)**25 + 1.32111115163996e+30*cos(theta)**23 - 8.91309656973092e+29*cos(theta)**21 + 4.27340246493948e+29*cos(theta)**19 - 1.47032559658884e+29*cos(theta)**17 + 3.62254132492902e+28*cos(theta)**15 - 6.30790777972714e+27*cos(theta)**13 + 7.56948933567257e+26*cos(theta)**11 - 6.00753121878776e+25*cos(theta)**9 + 2.95452355022349e+24*cos(theta)**7 - 8.08930828613992e+22*cos(theta)**5 + 1.01369778021804e+21*cos(theta)**3 - 3.6861737462474e+18*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl42_m12(theta, phi):
    return 1.24678209088621e-19*(1.0 - cos(theta)**2)**6*(2.02202194237316e+30*cos(theta)**30 - 1.05973439148473e+31*cos(theta)**28 + 2.47271358013104e+31*cos(theta)**26 - 3.39085195587589e+31*cos(theta)**24 + 3.03855564877191e+31*cos(theta)**22 - 1.87175027964349e+31*cos(theta)**20 + 8.11946468338502e+30*cos(theta)**18 - 2.49955351420102e+30*cos(theta)**16 + 5.43381198739353e+29*cos(theta)**14 - 8.20028011364529e+28*cos(theta)**12 + 8.32643826923983e+27*cos(theta)**10 - 5.40677809690898e+26*cos(theta)**8 + 2.06816648515644e+25*cos(theta)**6 - 4.04465414306996e+23*cos(theta)**4 + 3.04109334065411e+21*cos(theta)**2 - 3.6861737462474e+18)*cos(12*phi)

@torch.jit.script
def Yl42_m13(theta, phi):
    return 3.06936532987026e-21*(1.0 - cos(theta)**2)**6.5*(6.06606582711949e+31*cos(theta)**29 - 2.96725629615724e+32*cos(theta)**27 + 6.4290553083407e+32*cos(theta)**25 - 8.13804469410215e+32*cos(theta)**23 + 6.68482242729819e+32*cos(theta)**21 - 3.74350055928699e+32*cos(theta)**19 + 1.4615036430093e+32*cos(theta)**17 - 3.99928562272163e+31*cos(theta)**15 + 7.60733678235094e+30*cos(theta)**13 - 9.84033613637434e+29*cos(theta)**11 + 8.32643826923983e+28*cos(theta)**9 - 4.32542247752718e+27*cos(theta)**7 + 1.24089989109386e+26*cos(theta)**5 - 1.61786165722798e+24*cos(theta)**3 + 6.08218668130821e+21*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl42_m14(theta, phi):
    return 7.61650218074352e-23*(1.0 - cos(theta)**2)**7*(1.75915908986465e+33*cos(theta)**28 - 8.01159199962456e+33*cos(theta)**26 + 1.60726382708517e+34*cos(theta)**24 - 1.87175027964349e+34*cos(theta)**22 + 1.40381270973262e+34*cos(theta)**20 - 7.11265106264528e+33*cos(theta)**18 + 2.48455619311582e+33*cos(theta)**16 - 5.99892843408245e+32*cos(theta)**14 + 9.88953781705622e+31*cos(theta)**12 - 1.08243697500118e+31*cos(theta)**10 + 7.49379444231585e+29*cos(theta)**8 - 3.02779573426903e+28*cos(theta)**6 + 6.20449945546932e+26*cos(theta)**4 - 4.85358497168395e+24*cos(theta)**2 + 6.08218668130821e+21)*cos(14*phi)

@torch.jit.script
def Yl42_m15(theta, phi):
    return 1.90651017422948e-24*(1.0 - cos(theta)**2)**7.5*(4.92564545162103e+34*cos(theta)**27 - 2.08301391990239e+35*cos(theta)**25 + 3.85743318500442e+35*cos(theta)**23 - 4.11785061521569e+35*cos(theta)**21 + 2.80762541946524e+35*cos(theta)**19 - 1.28027719127615e+35*cos(theta)**17 + 3.97528990898531e+34*cos(theta)**15 - 8.39849980771543e+33*cos(theta)**13 + 1.18674453804675e+33*cos(theta)**11 - 1.08243697500118e+32*cos(theta)**9 + 5.99503555385268e+30*cos(theta)**7 - 1.81667744056142e+29*cos(theta)**5 + 2.48179978218773e+27*cos(theta)**3 - 9.70716994336791e+24*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl42_m16(theta, phi):
    return 4.81773877715548e-26*(1.0 - cos(theta)**2)**8*(1.32992427193768e+36*cos(theta)**26 - 5.20753479975596e+36*cos(theta)**24 + 8.87209632551016e+36*cos(theta)**22 - 8.64748629195294e+36*cos(theta)**20 + 5.33448829698396e+36*cos(theta)**18 - 2.17647122516945e+36*cos(theta)**16 + 5.96293486347796e+35*cos(theta)**14 - 1.09180497500301e+35*cos(theta)**12 + 1.30541899185142e+34*cos(theta)**10 - 9.7419327750106e+32*cos(theta)**8 + 4.19652488769687e+31*cos(theta)**6 - 9.08338720280709e+29*cos(theta)**4 + 7.44539934656319e+27*cos(theta)**2 - 9.70716994336791e+24)*cos(16*phi)

@torch.jit.script
def Yl42_m17(theta, phi):
    return 1.23007210134409e-27*(1.0 - cos(theta)**2)**8.5*(3.45780310703796e+37*cos(theta)**25 - 1.24980835194143e+38*cos(theta)**23 + 1.95186119161224e+38*cos(theta)**21 - 1.72949725839059e+38*cos(theta)**19 + 9.60207893457112e+37*cos(theta)**17 - 3.48235396027113e+37*cos(theta)**15 + 8.34810880886914e+36*cos(theta)**13 - 1.31016597000361e+36*cos(theta)**11 + 1.30541899185142e+35*cos(theta)**9 - 7.79354622000848e+33*cos(theta)**7 + 2.51791493261812e+32*cos(theta)**5 - 3.63335488112284e+30*cos(theta)**3 + 1.48907986931264e+28*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl42_m18(theta, phi):
    return 3.17603250876001e-29*(1.0 - cos(theta)**2)**9*(8.6445077675949e+38*cos(theta)**24 - 2.87455920946529e+39*cos(theta)**22 + 4.09890850238569e+39*cos(theta)**20 - 3.28604479094212e+39*cos(theta)**18 + 1.63235341887709e+39*cos(theta)**16 - 5.22353094040669e+38*cos(theta)**14 + 1.08525414515299e+38*cos(theta)**12 - 1.44118256700397e+37*cos(theta)**10 + 1.17487709266628e+36*cos(theta)**8 - 5.45548235400594e+34*cos(theta)**6 + 1.25895746630906e+33*cos(theta)**4 - 1.09000646433685e+31*cos(theta)**2 + 1.48907986931264e+28)*cos(18*phi)

@torch.jit.script
def Yl42_m19(theta, phi):
    return 8.30069393401569e-31*(1.0 - cos(theta)**2)**9.5*(2.07468186422278e+40*cos(theta)**23 - 6.32403026082364e+40*cos(theta)**21 + 8.19781700477139e+40*cos(theta)**19 - 5.91488062369581e+40*cos(theta)**17 + 2.61176547020335e+40*cos(theta)**15 - 7.31294331656937e+39*cos(theta)**13 + 1.30230497418359e+39*cos(theta)**11 - 1.44118256700397e+38*cos(theta)**9 + 9.39901674133023e+36*cos(theta)**7 - 3.27328941240356e+35*cos(theta)**5 + 5.03582986523625e+33*cos(theta)**3 - 2.1800129286737e+31*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl42_m20(theta, phi):
    return 2.19813639967386e-32*(1.0 - cos(theta)**2)**10*(4.77176828771238e+41*cos(theta)**22 - 1.32804635477296e+42*cos(theta)**20 + 1.55758523090656e+42*cos(theta)**18 - 1.00552970602829e+42*cos(theta)**16 + 3.91764820530502e+41*cos(theta)**14 - 9.50682631154018e+40*cos(theta)**12 + 1.43253547160194e+40*cos(theta)**10 - 1.29706431030357e+39*cos(theta)**8 + 6.57931171893116e+37*cos(theta)**6 - 1.63664470620178e+36*cos(theta)**4 + 1.51074895957087e+34*cos(theta)**2 - 2.1800129286737e+31)*cos(20*phi)

@torch.jit.script
def Yl42_m21(theta, phi):
    return 5.90436262972423e-34*(1.0 - cos(theta)**2)**10.5*(1.04978902329672e+43*cos(theta)**21 - 2.65609270954593e+43*cos(theta)**19 + 2.80365341563181e+43*cos(theta)**17 - 1.60884752964526e+43*cos(theta)**15 + 5.48470748742703e+42*cos(theta)**13 - 1.14081915738482e+42*cos(theta)**11 + 1.43253547160194e+41*cos(theta)**9 - 1.03765144824286e+40*cos(theta)**7 + 3.9475870313587e+38*cos(theta)**5 - 6.54657882480712e+36*cos(theta)**3 + 3.02149791914175e+34*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl42_m22(theta, phi):
    return 1.61054694530832e-35*(1.0 - cos(theta)**2)**11*(2.20455694892312e+44*cos(theta)**20 - 5.04657614813727e+44*cos(theta)**18 + 4.76621080657408e+44*cos(theta)**16 - 2.41327129446789e+44*cos(theta)**14 + 7.13011973365513e+43*cos(theta)**12 - 1.2549010731233e+43*cos(theta)**10 + 1.28928192444175e+42*cos(theta)**8 - 7.2635601377e+40*cos(theta)**6 + 1.97379351567935e+39*cos(theta)**4 - 1.96397364744214e+37*cos(theta)**2 + 3.02149791914175e+34)*cos(22*phi)

@torch.jit.script
def Yl42_m23(theta, phi):
    return 4.46685353296235e-37*(1.0 - cos(theta)**2)**11.5*(4.40911389784624e+45*cos(theta)**19 - 9.08383706664708e+45*cos(theta)**17 + 7.62593729051854e+45*cos(theta)**15 - 3.37857981225505e+45*cos(theta)**13 + 8.55614368038616e+44*cos(theta)**11 - 1.2549010731233e+44*cos(theta)**9 + 1.0314255395534e+43*cos(theta)**7 - 4.35813608262e+41*cos(theta)**5 + 7.89517406271739e+39*cos(theta)**3 - 3.92794729488427e+37*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl42_m24(theta, phi):
    return 1.26140034095862e-38*(1.0 - cos(theta)**2)**12*(8.37731640590786e+46*cos(theta)**18 - 1.54425230133e+47*cos(theta)**16 + 1.14389059357778e+47*cos(theta)**14 - 4.39215375593156e+46*cos(theta)**12 + 9.41175804842478e+45*cos(theta)**10 - 1.12941096581097e+45*cos(theta)**8 + 7.2199787768738e+43*cos(theta)**6 - 2.17906804131e+42*cos(theta)**4 + 2.36855221881522e+40*cos(theta)**2 - 3.92794729488427e+37)*cos(24*phi)

@torch.jit.script
def Yl42_m25(theta, phi):
    return 3.63227975523903e-40*(1.0 - cos(theta)**2)**12.5*(1.50791695306342e+48*cos(theta)**17 - 2.47080368212801e+48*cos(theta)**15 + 1.60144683100889e+48*cos(theta)**13 - 5.27058450711787e+47*cos(theta)**11 + 9.41175804842478e+46*cos(theta)**9 - 9.03528772648778e+45*cos(theta)**7 + 4.33198726612428e+44*cos(theta)**5 - 8.71627216524e+42*cos(theta)**3 + 4.73710443763043e+40*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl42_m26(theta, phi):
    return 1.0683175750703e-41*(1.0 - cos(theta)**2)**13*(2.56345882020781e+49*cos(theta)**16 - 3.70620552319201e+49*cos(theta)**14 + 2.08188088031156e+49*cos(theta)**12 - 5.79764295782966e+48*cos(theta)**10 + 8.4705822435823e+47*cos(theta)**8 - 6.32470140854145e+46*cos(theta)**6 + 2.16599363306214e+45*cos(theta)**4 - 2.614881649572e+43*cos(theta)**2 + 4.73710443763043e+40)*cos(26*phi)

@torch.jit.script
def Yl42_m27(theta, phi):
    return 3.21525806603397e-43*(1.0 - cos(theta)**2)**13.5*(4.10153411233249e+50*cos(theta)**15 - 5.18868773246881e+50*cos(theta)**13 + 2.49825705637387e+50*cos(theta)**11 - 5.79764295782966e+49*cos(theta)**9 + 6.77646579486584e+48*cos(theta)**7 - 3.79482084512487e+47*cos(theta)**5 + 8.66397453224856e+45*cos(theta)**3 - 5.229763299144e+43*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl42_m28(theta, phi):
    return 9.92250181163357e-45*(1.0 - cos(theta)**2)**14*(6.15230116849873e+51*cos(theta)**14 - 6.74529405220946e+51*cos(theta)**12 + 2.74808276201126e+51*cos(theta)**10 - 5.2178786620467e+50*cos(theta)**8 + 4.74352605640609e+49*cos(theta)**6 - 1.89741042256243e+48*cos(theta)**4 + 2.59919235967457e+46*cos(theta)**2 - 5.229763299144e+43)*cos(28*phi)

@torch.jit.script
def Yl42_m29(theta, phi):
    return 3.14722646575483e-46*(1.0 - cos(theta)**2)**14.5*(8.61322163589823e+52*cos(theta)**13 - 8.09435286265135e+52*cos(theta)**11 + 2.74808276201126e+52*cos(theta)**9 - 4.17430292963736e+51*cos(theta)**7 + 2.84611563384365e+50*cos(theta)**5 - 7.58964169024974e+48*cos(theta)**3 + 5.19838471934914e+46*cos(theta))*cos(29*phi)

@torch.jit.script
def Yl42_m30(theta, phi):
    return 1.02870315144741e-47*(1.0 - cos(theta)**2)**15*(1.11971881266677e+54*cos(theta)**12 - 8.90378814891648e+53*cos(theta)**10 + 2.47327448581013e+53*cos(theta)**8 - 2.92201205074615e+52*cos(theta)**6 + 1.42305781692183e+51*cos(theta)**4 - 2.27689250707492e+49*cos(theta)**2 + 5.19838471934914e+46)*cos(30*phi)

@torch.jit.script
def Yl42_m31(theta, phi):
    return 3.4756658535518e-49*(1.0 - cos(theta)**2)**15.5*(1.34366257520012e+55*cos(theta)**11 - 8.90378814891648e+54*cos(theta)**9 + 1.97861958864811e+54*cos(theta)**7 - 1.75320723044769e+53*cos(theta)**5 + 5.6922312676873e+51*cos(theta)**3 - 4.55378501414984e+49*cos(theta))*cos(31*phi)

@torch.jit.script
def Yl42_m32(theta, phi):
    return 1.21822025124109e-50*(1.0 - cos(theta)**2)**16*(1.47802883272014e+56*cos(theta)**10 - 8.01340933402483e+55*cos(theta)**8 + 1.38503371205367e+55*cos(theta)**6 - 8.76603615223845e+53*cos(theta)**4 + 1.70766938030619e+52*cos(theta)**2 - 4.55378501414984e+49)*cos(32*phi)

@torch.jit.script
def Yl42_m33(theta, phi):
    return 4.44831141076236e-52*(1.0 - cos(theta)**2)**16.5*(1.47802883272014e+57*cos(theta)**9 - 6.41072746721987e+56*cos(theta)**7 + 8.31020227232205e+55*cos(theta)**5 - 3.50641446089538e+54*cos(theta)**3 + 3.41533876061238e+52*cos(theta))*cos(33*phi)

@torch.jit.script
def Yl42_m34(theta, phi):
    return 1.70085437797474e-53*(1.0 - cos(theta)**2)**17*(1.33022594944812e+58*cos(theta)**8 - 4.48750922705391e+57*cos(theta)**6 + 4.15510113616102e+56*cos(theta)**4 - 1.05192433826861e+55*cos(theta)**2 + 3.41533876061238e+52)*cos(34*phi)

@torch.jit.script
def Yl42_m35(theta, phi):
    return 6.85293758117573e-55*(1.0 - cos(theta)**2)**17.5*(1.0641807595585e+59*cos(theta)**7 - 2.69250553623234e+58*cos(theta)**5 + 1.66204045446441e+57*cos(theta)**3 - 2.10384867653723e+55*cos(theta))*cos(35*phi)

@torch.jit.script
def Yl42_m36(theta, phi):
    return 2.93278654238651e-56*(1.0 - cos(theta)**2)**18*(7.44926531690948e+59*cos(theta)**6 - 1.34625276811617e+59*cos(theta)**4 + 4.98612136339323e+57*cos(theta)**2 - 2.10384867653723e+55)*cos(36*phi)

@torch.jit.script
def Yl42_m37(theta, phi):
    return 1.34707347297915e-57*(1.0 - cos(theta)**2)**18.5*(4.46955919014569e+60*cos(theta)**5 - 5.38501107246469e+59*cos(theta)**3 + 9.97224272678646e+57*cos(theta))*cos(37*phi)

@torch.jit.script
def Yl42_m38(theta, phi):
    return 6.73536736489573e-59*(1.0 - cos(theta)**2)**19*(2.23477959507285e+61*cos(theta)**4 - 1.61550332173941e+60*cos(theta)**2 + 9.97224272678646e+57)*cos(38*phi)

@torch.jit.script
def Yl42_m39(theta, phi):
    return 3.74187075827541e-60*(1.0 - cos(theta)**2)**19.5*(8.93911838029138e+61*cos(theta)**3 - 3.23100664347881e+60*cos(theta))*cos(39*phi)

@torch.jit.script
def Yl42_m40(theta, phi):
    return 2.38572965876905e-61*(1.0 - cos(theta)**2)**20*(2.68173551408741e+62*cos(theta)**2 - 3.23100664347881e+60)*cos(40*phi)

@torch.jit.script
def Yl42_m41(theta, phi):
    return 9.93146061456615*(1.0 - cos(theta)**2)**20.5*cos(41*phi)*cos(theta)

@torch.jit.script
def Yl42_m42(theta, phi):
    return 1.08361119113624*(1.0 - cos(theta)**2)**21*cos(42*phi)

@torch.jit.script
def Yl43_m_minus_43(theta, phi):
    return 1.08989304776835*(1.0 - cos(theta)**2)**21.5*sin(43*phi)

@torch.jit.script
def Yl43_m_minus_42(theta, phi):
    return 10.1072523258968*(1.0 - cos(theta)**2)**21*sin(42*phi)*cos(theta)

@torch.jit.script
def Yl43_m_minus_41(theta, phi):
    return 2.89063131941515e-63*(1.0 - cos(theta)**2)**20.5*(2.2794751869743e+64*cos(theta)**2 - 2.68173551408741e+62)*sin(41*phi)

@torch.jit.script
def Yl43_m_minus_40(theta, phi):
    return 4.5887349618882e-62*(1.0 - cos(theta)**2)**20*(7.59825062324767e+63*cos(theta)**3 - 2.68173551408741e+62*cos(theta))*sin(40*phi)

@torch.jit.script
def Yl43_m_minus_39(theta, phi):
    return 8.36107301651595e-61*(1.0 - cos(theta)**2)**19.5*(1.89956265581192e+63*cos(theta)**4 - 1.34086775704371e+62*cos(theta)**2 + 8.07751660869703e+59)*sin(39*phi)

@torch.jit.script
def Yl43_m_minus_38(theta, phi):
    return 1.69298825202302e-59*(1.0 - cos(theta)**2)**19*(3.79912531162384e+62*cos(theta)**5 - 4.46955919014569e+61*cos(theta)**3 + 8.07751660869703e+59*cos(theta))*sin(38*phi)

@torch.jit.script
def Yl43_m_minus_37(theta, phi):
    return 3.73226162218452e-58*(1.0 - cos(theta)**2)**18.5*(6.33187551937306e+61*cos(theta)**6 - 1.11738979753642e+61*cos(theta)**4 + 4.03875830434852e+59*cos(theta)**2 - 1.66204045446441e+57)*sin(37*phi)

@torch.jit.script
def Yl43_m_minus_36(theta, phi):
    return 8.83214301129778e-57*(1.0 - cos(theta)**2)**18*(9.04553645624723e+60*cos(theta)**7 - 2.23477959507285e+60*cos(theta)**5 + 1.34625276811617e+59*cos(theta)**3 - 1.66204045446441e+57*cos(theta))*sin(36*phi)

@torch.jit.script
def Yl43_m_minus_35(theta, phi):
    return 2.22036632357623e-55*(1.0 - cos(theta)**2)**17.5*(1.1306920570309e+60*cos(theta)**8 - 3.72463265845474e+59*cos(theta)**6 + 3.36563192029043e+58*cos(theta)**4 - 8.31020227232205e+56*cos(theta)**2 + 2.62981084567153e+54)*sin(35*phi)

@torch.jit.script
def Yl43_m_minus_34(theta, phi):
    return 5.88292332164183e-54*(1.0 - cos(theta)**2)**17*(1.25632450781212e+59*cos(theta)**9 - 5.32090379779249e+58*cos(theta)**7 + 6.73126384058086e+57*cos(theta)**5 - 2.77006742410735e+56*cos(theta)**3 + 2.62981084567153e+54*cos(theta))*sin(34*phi)

@torch.jit.script
def Yl43_m_minus_33(theta, phi):
    return 1.63244497127482e-52*(1.0 - cos(theta)**2)**16.5*(1.25632450781212e+58*cos(theta)**10 - 6.65112974724061e+57*cos(theta)**8 + 1.12187730676348e+57*cos(theta)**6 - 6.92516856026837e+55*cos(theta)**4 + 1.31490542283577e+54*cos(theta)**2 - 3.41533876061238e+51)*sin(33*phi)

@torch.jit.script
def Yl43_m_minus_32(theta, phi):
    return 4.71999663604224e-51*(1.0 - cos(theta)**2)**16*(1.1421131889201e+57*cos(theta)**11 - 7.39014416360068e+56*cos(theta)**9 + 1.60268186680497e+56*cos(theta)**7 - 1.38503371205367e+55*cos(theta)**5 + 4.38301807611922e+53*cos(theta)**3 - 3.41533876061238e+51*cos(theta))*sin(32*phi)

@torch.jit.script
def Yl43_m_minus_31(theta, phi):
    return 1.41599899081267e-49*(1.0 - cos(theta)**2)**15.5*(9.51760990766754e+55*cos(theta)**12 - 7.39014416360068e+55*cos(theta)**10 + 2.00335233350621e+55*cos(theta)**8 - 2.30838952008946e+54*cos(theta)**6 + 1.09575451902981e+53*cos(theta)**4 - 1.70766938030619e+51*cos(theta)**2 + 3.79482084512487e+48)*sin(31*phi)

@torch.jit.script
def Yl43_m_minus_30(theta, phi):
    return 4.39188014702948e-48*(1.0 - cos(theta)**2)**15*(7.32123839051349e+54*cos(theta)**13 - 6.71831287600062e+54*cos(theta)**11 + 2.22594703722912e+54*cos(theta)**9 - 3.29769931441351e+53*cos(theta)**7 + 2.19150903805961e+52*cos(theta)**5 - 5.6922312676873e+50*cos(theta)**3 + 3.79482084512487e+48*cos(theta))*sin(30*phi)

@torch.jit.script
def Yl43_m_minus_29(theta, phi):
    return 1.40402851370052e-46*(1.0 - cos(theta)**2)**14.5*(5.22945599322392e+53*cos(theta)**14 - 5.59859406333385e+53*cos(theta)**12 + 2.22594703722912e+53*cos(theta)**10 - 4.12212414301689e+52*cos(theta)**8 + 3.65251506343269e+51*cos(theta)**6 - 1.42305781692183e+50*cos(theta)**4 + 1.89741042256243e+48*cos(theta)**2 - 3.71313194239224e+45)*sin(29*phi)

@torch.jit.script
def Yl43_m_minus_28(theta, phi):
    return 4.61410853000535e-45*(1.0 - cos(theta)**2)**14*(3.48630399548262e+52*cos(theta)**15 - 4.30661081794911e+52*cos(theta)**13 + 2.02358821566284e+52*cos(theta)**11 - 4.58013793668543e+51*cos(theta)**9 + 5.2178786620467e+50*cos(theta)**7 - 2.84611563384365e+49*cos(theta)**5 + 6.32470140854145e+47*cos(theta)**3 - 3.71313194239224e+45*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl43_m_minus_27(theta, phi):
    return 1.55516678174063e-43*(1.0 - cos(theta)**2)**13.5*(2.17893999717664e+51*cos(theta)**16 - 3.07615058424937e+51*cos(theta)**14 + 1.68632351305236e+51*cos(theta)**12 - 4.58013793668543e+50*cos(theta)**10 + 6.52234832755837e+49*cos(theta)**8 - 4.74352605640609e+48*cos(theta)**6 + 1.58117535213536e+47*cos(theta)**4 - 1.85656597119612e+45*cos(theta)**2 + 3.268602061965e+42)*sin(27*phi)

@torch.jit.script
def Yl43_m_minus_26(theta, phi):
    return 5.36476190118919e-42*(1.0 - cos(theta)**2)**13*(1.2817294101039e+50*cos(theta)**17 - 2.05076705616624e+50*cos(theta)**15 + 1.2971719331172e+50*cos(theta)**13 - 4.16376176062312e+49*cos(theta)**11 + 7.24705369728708e+48*cos(theta)**9 - 6.77646579486584e+47*cos(theta)**7 + 3.16235070427072e+46*cos(theta)**5 - 6.1885532373204e+44*cos(theta)**3 + 3.268602061965e+42*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl43_m_minus_25(theta, phi):
    return 1.89065048220215e-40*(1.0 - cos(theta)**2)**12.5*(7.12071894502168e+48*cos(theta)**18 - 1.2817294101039e+49*cos(theta)**16 + 9.26551380798002e+48*cos(theta)**14 - 3.46980146718593e+48*cos(theta)**12 + 7.24705369728708e+47*cos(theta)**10 - 8.4705822435823e+46*cos(theta)**8 + 5.27058450711787e+45*cos(theta)**6 - 1.5471383093301e+44*cos(theta)**4 + 1.6343010309825e+42*cos(theta)**2 - 2.63172468757246e+39)*sin(25*phi)

@torch.jit.script
def Yl43_m_minus_24(theta, phi):
    return 6.79583000496612e-39*(1.0 - cos(theta)**2)**12*(3.74774681316931e+47*cos(theta)**19 - 7.53958476531708e+47*cos(theta)**17 + 6.17700920532001e+47*cos(theta)**15 - 2.66907805168149e+47*cos(theta)**13 + 6.58823063389734e+46*cos(theta)**11 - 9.41175804842478e+45*cos(theta)**9 + 7.52940643873982e+44*cos(theta)**7 - 3.0942766186602e+43*cos(theta)**5 + 5.447670103275e+41*cos(theta)**3 - 2.63172468757246e+39*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl43_m_minus_23(theta, phi):
    return 2.48768224079308e-37*(1.0 - cos(theta)**2)**11.5*(1.87387340658465e+46*cos(theta)**20 - 4.18865820295393e+46*cos(theta)**18 + 3.86063075332501e+46*cos(theta)**16 - 1.90648432262963e+46*cos(theta)**14 + 5.49019219491445e+45*cos(theta)**12 - 9.41175804842478e+44*cos(theta)**10 + 9.41175804842478e+43*cos(theta)**8 - 5.157127697767e+42*cos(theta)**6 + 1.36191752581875e+41*cos(theta)**4 - 1.31586234378623e+39*cos(theta)**2 + 1.96397364744214e+36)*sin(23*phi)

@torch.jit.script
def Yl43_m_minus_22(theta, phi):
    return 9.26139742295083e-36*(1.0 - cos(theta)**2)**11*(8.92320669802216e+44*cos(theta)**21 - 2.20455694892312e+45*cos(theta)**19 + 2.27095926666177e+45*cos(theta)**17 - 1.27098954841976e+45*cos(theta)**15 + 4.22322476531881e+44*cos(theta)**13 - 8.55614368038616e+43*cos(theta)**11 + 1.04575089426942e+43*cos(theta)**9 - 7.36732528252429e+41*cos(theta)**7 + 2.7238350516375e+40*cos(theta)**5 - 4.38620781262077e+38*cos(theta)**3 + 1.96397364744214e+36*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl43_m_minus_21(theta, phi):
    return 3.50222899855152e-34*(1.0 - cos(theta)**2)**10.5*(4.05600304455553e+43*cos(theta)**22 - 1.10227847446156e+44*cos(theta)**20 + 1.26164403703432e+44*cos(theta)**18 - 7.94368467762348e+43*cos(theta)**16 + 3.01658911808486e+43*cos(theta)**14 - 7.13011973365513e+42*cos(theta)**12 + 1.04575089426942e+42*cos(theta)**10 - 9.20915660315536e+40*cos(theta)**8 + 4.5397250860625e+39*cos(theta)**6 - 1.09655195315519e+38*cos(theta)**4 + 9.81986823721069e+35*cos(theta)**2 - 1.37340814506443e+33)*sin(21*phi)

@torch.jit.script
def Yl43_m_minus_20(theta, phi):
    return 1.34368801864906e-32*(1.0 - cos(theta)**2)**10*(1.76347958458936e+42*cos(theta)**23 - 5.24894511648362e+42*cos(theta)**21 + 6.64023177386482e+42*cos(theta)**19 - 4.67275569271969e+42*cos(theta)**17 + 2.01105941205658e+42*cos(theta)**15 - 5.48470748742703e+41*cos(theta)**13 + 9.50682631154018e+40*cos(theta)**11 - 1.02323962257282e+40*cos(theta)**9 + 6.48532155151786e+38*cos(theta)**7 - 2.19310390631039e+37*cos(theta)**5 + 3.27328941240356e+35*cos(theta)**3 - 1.37340814506443e+33*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl43_m_minus_19(theta, phi):
    return 5.2248561770532e-31*(1.0 - cos(theta)**2)**9.5*(7.34783160245567e+40*cos(theta)**24 - 2.38588414385619e+41*cos(theta)**22 + 3.32011588693241e+41*cos(theta)**20 - 2.59597538484427e+41*cos(theta)**18 + 1.25691213253536e+41*cos(theta)**16 - 3.91764820530502e+40*cos(theta)**14 + 7.92235525961681e+39*cos(theta)**12 - 1.02323962257282e+39*cos(theta)**10 + 8.10665193939732e+37*cos(theta)**8 - 3.65517317718398e+36*cos(theta)**6 + 8.18322353100891e+34*cos(theta)**4 - 6.86704072532216e+32*cos(theta)**2 + 9.08338720280709e+29)*sin(19*phi)

@torch.jit.script
def Yl43_m_minus_18(theta, phi):
    return 2.05702793393481e-29*(1.0 - cos(theta)**2)**9*(2.93913264098227e+39*cos(theta)**25 - 1.03734093211139e+40*cos(theta)**23 + 1.58100756520591e+40*cos(theta)**21 - 1.36630283412856e+40*cos(theta)**19 + 7.39360077961976e+39*cos(theta)**17 - 2.61176547020335e+39*cos(theta)**15 + 6.09411943047447e+38*cos(theta)**13 - 9.30217838702561e+37*cos(theta)**11 + 9.0073910437748e+36*cos(theta)**9 - 5.22167596740568e+35*cos(theta)**7 + 1.63664470620178e+34*cos(theta)**5 - 2.28901357510739e+32*cos(theta)**3 + 9.08338720280709e+29*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl43_m_minus_17(theta, phi):
    return 8.19203465488711e-28*(1.0 - cos(theta)**2)**8.5*(1.13043563114703e+38*cos(theta)**26 - 4.32225388379745e+38*cos(theta)**24 + 7.18639802366323e+38*cos(theta)**22 - 6.83151417064282e+38*cos(theta)**20 + 4.10755598867765e+38*cos(theta)**18 - 1.63235341887709e+38*cos(theta)**16 + 4.35294245033891e+37*cos(theta)**14 - 7.75181532252134e+36*cos(theta)**12 + 9.0073910437748e+35*cos(theta)**10 - 6.5270949592571e+34*cos(theta)**8 + 2.72774117700297e+33*cos(theta)**6 - 5.72253393776847e+31*cos(theta)**4 + 4.54169360140354e+29*cos(theta)**2 - 5.72723026658707e+26)*sin(17*phi)

@torch.jit.script
def Yl43_m_minus_16(theta, phi):
    return 3.29723034522509e-26*(1.0 - cos(theta)**2)**8*(4.18679863387787e+36*cos(theta)**27 - 1.72890155351898e+37*cos(theta)**25 + 3.12452087985358e+37*cos(theta)**23 - 3.25310198602039e+37*cos(theta)**21 + 2.16187157298824e+37*cos(theta)**19 - 9.60207893457112e+36*cos(theta)**17 + 2.90196163355927e+36*cos(theta)**15 - 5.96293486347796e+35*cos(theta)**13 + 8.18853731252255e+34*cos(theta)**11 - 7.25232773250789e+33*cos(theta)**9 + 3.89677311000424e+32*cos(theta)**7 - 1.14450678755369e+31*cos(theta)**5 + 1.51389786713451e+29*cos(theta)**3 - 5.72723026658707e+26*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl43_m_minus_15(theta, phi):
    return 1.34015277384818e-24*(1.0 - cos(theta)**2)**7.5*(1.49528522638495e+35*cos(theta)**28 - 6.64962135968838e+35*cos(theta)**26 + 1.30188369993899e+36*cos(theta)**24 - 1.47868272091836e+36*cos(theta)**22 + 1.08093578649412e+36*cos(theta)**20 - 5.33448829698396e+35*cos(theta)**18 + 1.81372602097455e+35*cos(theta)**16 - 4.25923918819854e+34*cos(theta)**14 + 6.82378109376879e+33*cos(theta)**12 - 7.25232773250789e+32*cos(theta)**10 + 4.8709663875053e+31*cos(theta)**8 - 1.90751131258949e+30*cos(theta)**6 + 3.78474466783629e+28*cos(theta)**4 - 2.86361513329353e+26*cos(theta)**2 + 3.46684640834568e+23)*sin(15*phi)

@torch.jit.script
def Yl43_m_minus_14(theta, phi):
    return 5.49626046244125e-23*(1.0 - cos(theta)**2)**7*(5.15615595305157e+33*cos(theta)**29 - 2.46282272581051e+34*cos(theta)**27 + 5.20753479975596e+34*cos(theta)**25 - 6.4290553083407e+34*cos(theta)**23 + 5.14731326901961e+34*cos(theta)**21 - 2.80762541946524e+34*cos(theta)**19 + 1.06689765939679e+34*cos(theta)**17 - 2.83949279213236e+33*cos(theta)**15 + 5.24906237982215e+32*cos(theta)**13 - 6.59302521137081e+31*cos(theta)**11 + 5.41218487500589e+30*cos(theta)**9 - 2.72501616084213e+29*cos(theta)**7 + 7.56948933567257e+27*cos(theta)**5 - 9.54538377764511e+25*cos(theta)**3 + 3.46684640834568e+23*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl43_m_minus_13(theta, phi):
    return 2.27282166505428e-21*(1.0 - cos(theta)**2)**6.5*(1.71871865101719e+32*cos(theta)**30 - 8.79579544932326e+32*cos(theta)**28 + 2.00289799990614e+33*cos(theta)**26 - 2.67877304514196e+33*cos(theta)**24 + 2.33968784955437e+33*cos(theta)**22 - 1.40381270973262e+33*cos(theta)**20 + 5.92720921887106e+32*cos(theta)**18 - 1.77468299508273e+32*cos(theta)**16 + 3.74933027130153e+31*cos(theta)**14 - 5.49418767614234e+30*cos(theta)**12 + 5.41218487500589e+29*cos(theta)**10 - 3.40627020105266e+28*cos(theta)**8 + 1.26158155594543e+27*cos(theta)**6 - 2.38634594441128e+25*cos(theta)**4 + 1.73342320417284e+23*cos(theta)**2 - 2.02739556043607e+20)*sin(13*phi)

@torch.jit.script
def Yl43_m_minus_12(theta, phi):
    return 9.469787223322e-20*(1.0 - cos(theta)**2)**6*(5.54425371295867e+30*cos(theta)**31 - 3.03303291355974e+31*cos(theta)**29 + 7.41814074039311e+31*cos(theta)**27 - 1.07150921805678e+32*cos(theta)**25 + 1.01725558676277e+32*cos(theta)**23 - 6.68482242729819e+31*cos(theta)**21 + 3.11958379940582e+31*cos(theta)**19 - 1.04393117357807e+31*cos(theta)**17 + 2.49955351420102e+30*cos(theta)**15 - 4.22629821241719e+29*cos(theta)**13 + 4.92016806818717e+28*cos(theta)**11 - 3.78474466783629e+27*cos(theta)**9 + 1.80225936563633e+26*cos(theta)**7 - 4.77269188882256e+24*cos(theta)**5 + 5.7780773472428e+22*cos(theta)**3 - 2.02739556043607e+20*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl43_m_minus_11(theta, phi):
    return 3.97279865204351e-18*(1.0 - cos(theta)**2)**5.5*(1.73257928529959e+29*cos(theta)**32 - 1.01101097118658e+30*cos(theta)**30 + 2.64933597871183e+30*cos(theta)**28 - 4.12118930021839e+30*cos(theta)**26 + 4.23856494484487e+30*cos(theta)**24 - 3.03855564877191e+30*cos(theta)**22 + 1.55979189970291e+30*cos(theta)**20 - 5.7996176309893e+29*cos(theta)**18 + 1.56222094637564e+29*cos(theta)**16 - 3.01878443744085e+28*cos(theta)**14 + 4.10014005682264e+27*cos(theta)**12 - 3.78474466783629e+26*cos(theta)**10 + 2.25282420704541e+25*cos(theta)**8 - 7.95448648137093e+23*cos(theta)**6 + 1.4445193368107e+22*cos(theta)**4 - 1.01369778021804e+20*cos(theta)**2 + 1.15192929570231e+17)*sin(11*phi)

@torch.jit.script
def Yl43_m_minus_10(theta, phi):
    return 1.67706696673351e-16*(1.0 - cos(theta)**2)**5*(5.25024025848359e+27*cos(theta)**33 - 3.2613257135051e+28*cos(theta)**31 + 9.13564130590285e+28*cos(theta)**29 - 1.52636640748829e+29*cos(theta)**27 + 1.69542597793795e+29*cos(theta)**25 - 1.32111115163996e+29*cos(theta)**23 + 7.42758047477577e+28*cos(theta)**21 - 3.05243033209963e+28*cos(theta)**19 + 9.18953497868023e+27*cos(theta)**17 - 2.0125229582939e+27*cos(theta)**15 + 3.15395388986357e+26*cos(theta)**13 - 3.44067697076026e+25*cos(theta)**11 + 2.50313800782823e+24*cos(theta)**9 - 1.13635521162442e+23*cos(theta)**7 + 2.8890386736214e+21*cos(theta)**5 - 3.37899260072679e+19*cos(theta)**3 + 1.15192929570231e+17*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl43_m_minus_9(theta, phi):
    return 7.11914433542231e-15*(1.0 - cos(theta)**2)**4.5*(1.5441883113187e+26*cos(theta)**34 - 1.01916428547034e+27*cos(theta)**32 + 3.04521376863428e+27*cos(theta)**30 - 5.45130859817248e+27*cos(theta)**28 + 6.52086914591518e+27*cos(theta)**26 - 5.50462979849983e+27*cos(theta)**24 + 3.37617294307989e+27*cos(theta)**22 - 1.52621516604982e+27*cos(theta)**20 + 5.1052972103779e+26*cos(theta)**18 - 1.25782684893369e+26*cos(theta)**16 + 2.25282420704541e+25*cos(theta)**14 - 2.86723080896688e+24*cos(theta)**12 + 2.50313800782823e+23*cos(theta)**10 - 1.42044401453052e+22*cos(theta)**8 + 4.81506445603567e+20*cos(theta)**6 - 8.44748150181696e+18*cos(theta)**4 + 5.75964647851157e+16*cos(theta)**2 - 63925044156621.2)*sin(9*phi)

@torch.jit.script
def Yl43_m_minus_8(theta, phi):
    return 3.03713077171214e-13*(1.0 - cos(theta)**2)**4*(4.41196660376772e+24*cos(theta)**35 - 3.08837662263741e+25*cos(theta)**33 + 9.82327022140091e+25*cos(theta)**31 - 1.87976158557672e+26*cos(theta)**29 + 2.41513672070933e+26*cos(theta)**27 - 2.20185191939993e+26*cos(theta)**25 + 1.46790127959995e+26*cos(theta)**23 - 7.26769126690388e+25*cos(theta)**21 + 2.68699853177784e+25*cos(theta)**19 - 7.3989814643158e+24*cos(theta)**17 + 1.50188280469694e+24*cos(theta)**15 - 2.20556216074376e+23*cos(theta)**13 + 2.27558000711657e+22*cos(theta)**11 - 1.57827112725614e+21*cos(theta)**9 + 6.87866350862239e+19*cos(theta)**7 - 1.68949630036339e+18*cos(theta)**5 + 1.91988215950386e+16*cos(theta)**3 - 63925044156621.2*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl43_m_minus_7(theta, phi):
    return 1.30136712205844e-11*(1.0 - cos(theta)**2)**3.5*(1.22554627882437e+23*cos(theta)**36 - 9.0834606548159e+23*cos(theta)**34 + 3.06977194418778e+24*cos(theta)**32 - 6.26587195192239e+24*cos(theta)**30 + 8.6254882882476e+24*cos(theta)**28 - 8.46866122846128e+24*cos(theta)**26 + 6.11625533166648e+24*cos(theta)**24 - 3.30349603041086e+24*cos(theta)**22 + 1.34349926588892e+24*cos(theta)**20 - 4.11054525795322e+23*cos(theta)**18 + 9.38676752935587e+22*cos(theta)**16 - 1.5754015433884e+22*cos(theta)**14 + 1.89631667259715e+21*cos(theta)**12 - 1.57827112725614e+20*cos(theta)**10 + 8.59832938577798e+18*cos(theta)**8 - 2.81582716727232e+17*cos(theta)**6 + 4.79970539875964e+15*cos(theta)**4 - 31962522078310.6*cos(theta)**2 + 34817562176.8089)*sin(7*phi)

@torch.jit.script
def Yl43_m_minus_6(theta, phi):
    return 5.59739163789093e-10*(1.0 - cos(theta)**2)**3*(3.31228724006586e+21*cos(theta)**37 - 2.59527447280454e+22*cos(theta)**35 + 9.30233922481147e+22*cos(theta)**33 - 2.02124901674916e+23*cos(theta)**31 + 2.97430630629227e+23*cos(theta)**29 - 3.1365411957264e+23*cos(theta)**27 + 2.44650213266659e+23*cos(theta)**25 - 1.43630262191776e+23*cos(theta)**23 + 6.39761555185201e+22*cos(theta)**21 - 2.16344487260696e+22*cos(theta)**19 + 5.52162795844463e+21*cos(theta)**17 - 1.05026769559227e+21*cos(theta)**15 + 1.45870513276703e+20*cos(theta)**13 - 1.43479193386921e+19*cos(theta)**11 + 9.55369931753109e+17*cos(theta)**9 - 4.02261023896046e+16*cos(theta)**7 + 959941079751928.0*cos(theta)**5 - 10654174026103.5*cos(theta)**3 + 34817562176.8089*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl43_m_minus_5(theta, phi):
    return 2.41532475749014e-8*(1.0 - cos(theta)**2)**2.5*(8.71654536859437e+19*cos(theta)**38 - 7.2090957577904e+20*cos(theta)**36 + 2.73598212494455e+21*cos(theta)**34 - 6.31640317734112e+21*cos(theta)**32 + 9.91435435430758e+21*cos(theta)**30 - 1.120193284188e+22*cos(theta)**28 + 9.40962358717919e+21*cos(theta)**26 - 5.98459425799068e+21*cos(theta)**24 + 2.90800706902364e+21*cos(theta)**22 - 1.08172243630348e+21*cos(theta)**20 + 3.06757108802479e+20*cos(theta)**18 - 6.56417309745166e+19*cos(theta)**16 + 1.04193223769074e+19*cos(theta)**14 - 1.19565994489101e+18*cos(theta)**12 + 9.55369931753109e+16*cos(theta)**10 - 5.02826279870057e+15*cos(theta)**8 + 159990179958655.0*cos(theta)**6 - 2663543506525.88*cos(theta)**4 + 17408781088.4045*cos(theta)**2 - 18699012.9843227)*sin(5*phi)

@torch.jit.script
def Yl43_m_minus_4(theta, phi):
    return 1.0450292712034e-6*(1.0 - cos(theta)**2)**2*(2.23501163297291e+18*cos(theta)**39 - 1.94840425886227e+19*cos(theta)**37 + 7.81709178555585e+19*cos(theta)**35 - 1.91406156889125e+20*cos(theta)**33 + 3.19817882397019e+20*cos(theta)**31 - 3.86273546271724e+20*cos(theta)**29 + 3.48504577302933e+20*cos(theta)**27 - 2.39383770319627e+20*cos(theta)**25 + 1.2643508995755e+20*cos(theta)**23 - 5.15105922049276e+19*cos(theta)**21 + 1.61451109896042e+19*cos(theta)**19 - 3.86127829261862e+18*cos(theta)**17 + 6.94621491793826e+17*cos(theta)**15 - 9.19738419146932e+16*cos(theta)**13 + 8.68518119775554e+15*cos(theta)**11 - 558695866522286.0*cos(theta)**9 + 22855739994093.5*cos(theta)**7 - 532708701305.176*cos(theta)**5 + 5802927029.46815*cos(theta)**3 - 18699012.9843227*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl43_m_minus_3(theta, phi):
    return 4.53113894514745e-5*(1.0 - cos(theta)**2)**1.5*(5.58752908243229e+16*cos(theta)**40 - 5.12737962858492e+17*cos(theta)**38 + 2.17141438487663e+18*cos(theta)**36 - 5.62959284968014e+18*cos(theta)**34 + 9.99430882490683e+18*cos(theta)**32 - 1.28757848757241e+19*cos(theta)**30 + 1.24465920465333e+19*cos(theta)**28 - 9.20706808921643e+18*cos(theta)**26 + 5.26812874823123e+18*cos(theta)**24 - 2.34139055476944e+18*cos(theta)**22 + 8.07255549480209e+17*cos(theta)**20 - 2.14515460701035e+17*cos(theta)**18 + 4.34138432371141e+16*cos(theta)**16 - 6.5695601367638e+15*cos(theta)**14 + 723765099812961.0*cos(theta)**12 - 55869586652228.6*cos(theta)**10 + 2856967499261.69*cos(theta)**8 - 88784783550.8627*cos(theta)**6 + 1450731757.36704*cos(theta)**4 - 9349506.49216136*cos(theta)**2 + 9946.28350229932)*sin(3*phi)

@torch.jit.script
def Yl43_m_minus_2(theta, phi):
    return 0.0019677876202598*(1.0 - cos(theta)**2)*(1.36281197132495e+15*cos(theta)**41 - 1.31471272527819e+16*cos(theta)**39 + 5.86868752669358e+16*cos(theta)**37 - 1.60845509990861e+17*cos(theta)**35 + 3.02857843178995e+17*cos(theta)**33 - 4.15347899216907e+17*cos(theta)**31 + 4.29192829190804e+17*cos(theta)**29 - 3.41002521822831e+17*cos(theta)**27 + 2.10725149929249e+17*cos(theta)**25 - 1.01799589337802e+17*cos(theta)**23 + 3.84407404514385e+16*cos(theta)**21 - 1.12902874053176e+16*cos(theta)**19 + 2.55375548453613e+15*cos(theta)**17 - 437970675784254.0*cos(theta)**15 + 55674238447150.9*cos(theta)**13 - 5079053332020.78*cos(theta)**11 + 317440833251.299*cos(theta)**9 - 12683540507.2661*cos(theta)**7 + 290146351.473408*cos(theta)**5 - 3116502.16405379*cos(theta)**3 + 9946.28350229932*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl43_m_minus_1(theta, phi):
    return 0.0855478552850171*(1.0 - cos(theta)**2)**0.5*(32447904079165.4*cos(theta)**42 - 328678181319546.0*cos(theta)**40 + 1.54439145439305e+15*cos(theta)**38 - 4.46793083307948e+15*cos(theta)**36 + 8.90758362291162e+15*cos(theta)**34 - 1.29796218505284e+16*cos(theta)**32 + 1.43064276396935e+16*cos(theta)**30 - 1.21786614936725e+16*cos(theta)**28 + 8.10481345881728e+15*cos(theta)**26 - 4.24164955574173e+15*cos(theta)**24 + 1.7473063841563e+15*cos(theta)**22 - 564514370265880.0*cos(theta)**20 + 141875304696451.0*cos(theta)**18 - 27373167236515.8*cos(theta)**16 + 3976731317653.63*cos(theta)**14 - 423254444335.065*cos(theta)**12 + 31744083325.1299*cos(theta)**10 - 1585442563.40826*cos(theta)**8 + 48357725.2455679*cos(theta)**6 - 779125.541013447*cos(theta)**4 + 4973.14175114966*cos(theta)**2 - 5.26258386365043)*sin(phi)

@torch.jit.script
def Yl43_m0(theta, phi):
    return 1985513700759.99*cos(theta)**43 - 21093163197485.5*cos(theta)**41 + 104195143505651.0*cos(theta)**39 - 317730869702419.0*cos(theta)**37 + 669647972220920.0*cos(theta)**35 - 1.03491050252324e+15*cos(theta)**33 + 1.21429498962727e+15*cos(theta)**31 - 1.10498467744947e+15*cos(theta)**29 + 789830596909305.0*cos(theta)**27 - 446425989557433.0*cos(theta)**25 + 199892234130194.0*cos(theta)**23 - 70731098230684.1*cos(theta)**21 + 19647527286301.1*cos(theta)**19 - 4236730347991.79*cos(theta)**17 + 697573035504.702*cos(theta)**15 - 85666864009.3494*cos(theta)**13 + 7593199309.91961*cos(theta)**11 - 463513831.349144*cos(theta)**9 + 18177012.9940841*cos(theta)**7 - 410007.811896633*cos(theta)**5 + 4361.7852329429*cos(theta)**3 - 13.8469372474378*cos(theta)

@torch.jit.script
def Yl43_m1(theta, phi):
    return 0.0855478552850171*(1.0 - cos(theta)**2)**0.5*(32447904079165.4*cos(theta)**42 - 328678181319546.0*cos(theta)**40 + 1.54439145439305e+15*cos(theta)**38 - 4.46793083307948e+15*cos(theta)**36 + 8.90758362291162e+15*cos(theta)**34 - 1.29796218505284e+16*cos(theta)**32 + 1.43064276396935e+16*cos(theta)**30 - 1.21786614936725e+16*cos(theta)**28 + 8.10481345881728e+15*cos(theta)**26 - 4.24164955574173e+15*cos(theta)**24 + 1.7473063841563e+15*cos(theta)**22 - 564514370265880.0*cos(theta)**20 + 141875304696451.0*cos(theta)**18 - 27373167236515.8*cos(theta)**16 + 3976731317653.63*cos(theta)**14 - 423254444335.065*cos(theta)**12 + 31744083325.1299*cos(theta)**10 - 1585442563.40826*cos(theta)**8 + 48357725.2455679*cos(theta)**6 - 779125.541013447*cos(theta)**4 + 4973.14175114966*cos(theta)**2 - 5.26258386365043)*cos(phi)

@torch.jit.script
def Yl43_m2(theta, phi):
    return 0.0019677876202598*(1.0 - cos(theta)**2)*(1.36281197132495e+15*cos(theta)**41 - 1.31471272527819e+16*cos(theta)**39 + 5.86868752669358e+16*cos(theta)**37 - 1.60845509990861e+17*cos(theta)**35 + 3.02857843178995e+17*cos(theta)**33 - 4.15347899216907e+17*cos(theta)**31 + 4.29192829190804e+17*cos(theta)**29 - 3.41002521822831e+17*cos(theta)**27 + 2.10725149929249e+17*cos(theta)**25 - 1.01799589337802e+17*cos(theta)**23 + 3.84407404514385e+16*cos(theta)**21 - 1.12902874053176e+16*cos(theta)**19 + 2.55375548453613e+15*cos(theta)**17 - 437970675784254.0*cos(theta)**15 + 55674238447150.9*cos(theta)**13 - 5079053332020.78*cos(theta)**11 + 317440833251.299*cos(theta)**9 - 12683540507.2661*cos(theta)**7 + 290146351.473408*cos(theta)**5 - 3116502.16405379*cos(theta)**3 + 9946.28350229932*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl43_m3(theta, phi):
    return 4.53113894514745e-5*(1.0 - cos(theta)**2)**1.5*(5.58752908243229e+16*cos(theta)**40 - 5.12737962858492e+17*cos(theta)**38 + 2.17141438487663e+18*cos(theta)**36 - 5.62959284968014e+18*cos(theta)**34 + 9.99430882490683e+18*cos(theta)**32 - 1.28757848757241e+19*cos(theta)**30 + 1.24465920465333e+19*cos(theta)**28 - 9.20706808921643e+18*cos(theta)**26 + 5.26812874823123e+18*cos(theta)**24 - 2.34139055476944e+18*cos(theta)**22 + 8.07255549480209e+17*cos(theta)**20 - 2.14515460701035e+17*cos(theta)**18 + 4.34138432371141e+16*cos(theta)**16 - 6.5695601367638e+15*cos(theta)**14 + 723765099812961.0*cos(theta)**12 - 55869586652228.6*cos(theta)**10 + 2856967499261.69*cos(theta)**8 - 88784783550.8627*cos(theta)**6 + 1450731757.36704*cos(theta)**4 - 9349506.49216136*cos(theta)**2 + 9946.28350229932)*cos(3*phi)

@torch.jit.script
def Yl43_m4(theta, phi):
    return 1.0450292712034e-6*(1.0 - cos(theta)**2)**2*(2.23501163297291e+18*cos(theta)**39 - 1.94840425886227e+19*cos(theta)**37 + 7.81709178555585e+19*cos(theta)**35 - 1.91406156889125e+20*cos(theta)**33 + 3.19817882397019e+20*cos(theta)**31 - 3.86273546271724e+20*cos(theta)**29 + 3.48504577302933e+20*cos(theta)**27 - 2.39383770319627e+20*cos(theta)**25 + 1.2643508995755e+20*cos(theta)**23 - 5.15105922049276e+19*cos(theta)**21 + 1.61451109896042e+19*cos(theta)**19 - 3.86127829261862e+18*cos(theta)**17 + 6.94621491793826e+17*cos(theta)**15 - 9.19738419146932e+16*cos(theta)**13 + 8.68518119775554e+15*cos(theta)**11 - 558695866522286.0*cos(theta)**9 + 22855739994093.5*cos(theta)**7 - 532708701305.176*cos(theta)**5 + 5802927029.46815*cos(theta)**3 - 18699012.9843227*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl43_m5(theta, phi):
    return 2.41532475749014e-8*(1.0 - cos(theta)**2)**2.5*(8.71654536859437e+19*cos(theta)**38 - 7.2090957577904e+20*cos(theta)**36 + 2.73598212494455e+21*cos(theta)**34 - 6.31640317734112e+21*cos(theta)**32 + 9.91435435430758e+21*cos(theta)**30 - 1.120193284188e+22*cos(theta)**28 + 9.40962358717919e+21*cos(theta)**26 - 5.98459425799068e+21*cos(theta)**24 + 2.90800706902364e+21*cos(theta)**22 - 1.08172243630348e+21*cos(theta)**20 + 3.06757108802479e+20*cos(theta)**18 - 6.56417309745166e+19*cos(theta)**16 + 1.04193223769074e+19*cos(theta)**14 - 1.19565994489101e+18*cos(theta)**12 + 9.55369931753109e+16*cos(theta)**10 - 5.02826279870057e+15*cos(theta)**8 + 159990179958655.0*cos(theta)**6 - 2663543506525.88*cos(theta)**4 + 17408781088.4045*cos(theta)**2 - 18699012.9843227)*cos(5*phi)

@torch.jit.script
def Yl43_m6(theta, phi):
    return 5.59739163789093e-10*(1.0 - cos(theta)**2)**3*(3.31228724006586e+21*cos(theta)**37 - 2.59527447280454e+22*cos(theta)**35 + 9.30233922481147e+22*cos(theta)**33 - 2.02124901674916e+23*cos(theta)**31 + 2.97430630629227e+23*cos(theta)**29 - 3.1365411957264e+23*cos(theta)**27 + 2.44650213266659e+23*cos(theta)**25 - 1.43630262191776e+23*cos(theta)**23 + 6.39761555185201e+22*cos(theta)**21 - 2.16344487260696e+22*cos(theta)**19 + 5.52162795844463e+21*cos(theta)**17 - 1.05026769559227e+21*cos(theta)**15 + 1.45870513276703e+20*cos(theta)**13 - 1.43479193386921e+19*cos(theta)**11 + 9.55369931753109e+17*cos(theta)**9 - 4.02261023896046e+16*cos(theta)**7 + 959941079751928.0*cos(theta)**5 - 10654174026103.5*cos(theta)**3 + 34817562176.8089*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl43_m7(theta, phi):
    return 1.30136712205844e-11*(1.0 - cos(theta)**2)**3.5*(1.22554627882437e+23*cos(theta)**36 - 9.0834606548159e+23*cos(theta)**34 + 3.06977194418778e+24*cos(theta)**32 - 6.26587195192239e+24*cos(theta)**30 + 8.6254882882476e+24*cos(theta)**28 - 8.46866122846128e+24*cos(theta)**26 + 6.11625533166648e+24*cos(theta)**24 - 3.30349603041086e+24*cos(theta)**22 + 1.34349926588892e+24*cos(theta)**20 - 4.11054525795322e+23*cos(theta)**18 + 9.38676752935587e+22*cos(theta)**16 - 1.5754015433884e+22*cos(theta)**14 + 1.89631667259715e+21*cos(theta)**12 - 1.57827112725614e+20*cos(theta)**10 + 8.59832938577798e+18*cos(theta)**8 - 2.81582716727232e+17*cos(theta)**6 + 4.79970539875964e+15*cos(theta)**4 - 31962522078310.6*cos(theta)**2 + 34817562176.8089)*cos(7*phi)

@torch.jit.script
def Yl43_m8(theta, phi):
    return 3.03713077171214e-13*(1.0 - cos(theta)**2)**4*(4.41196660376772e+24*cos(theta)**35 - 3.08837662263741e+25*cos(theta)**33 + 9.82327022140091e+25*cos(theta)**31 - 1.87976158557672e+26*cos(theta)**29 + 2.41513672070933e+26*cos(theta)**27 - 2.20185191939993e+26*cos(theta)**25 + 1.46790127959995e+26*cos(theta)**23 - 7.26769126690388e+25*cos(theta)**21 + 2.68699853177784e+25*cos(theta)**19 - 7.3989814643158e+24*cos(theta)**17 + 1.50188280469694e+24*cos(theta)**15 - 2.20556216074376e+23*cos(theta)**13 + 2.27558000711657e+22*cos(theta)**11 - 1.57827112725614e+21*cos(theta)**9 + 6.87866350862239e+19*cos(theta)**7 - 1.68949630036339e+18*cos(theta)**5 + 1.91988215950386e+16*cos(theta)**3 - 63925044156621.2*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl43_m9(theta, phi):
    return 7.11914433542231e-15*(1.0 - cos(theta)**2)**4.5*(1.5441883113187e+26*cos(theta)**34 - 1.01916428547034e+27*cos(theta)**32 + 3.04521376863428e+27*cos(theta)**30 - 5.45130859817248e+27*cos(theta)**28 + 6.52086914591518e+27*cos(theta)**26 - 5.50462979849983e+27*cos(theta)**24 + 3.37617294307989e+27*cos(theta)**22 - 1.52621516604982e+27*cos(theta)**20 + 5.1052972103779e+26*cos(theta)**18 - 1.25782684893369e+26*cos(theta)**16 + 2.25282420704541e+25*cos(theta)**14 - 2.86723080896688e+24*cos(theta)**12 + 2.50313800782823e+23*cos(theta)**10 - 1.42044401453052e+22*cos(theta)**8 + 4.81506445603567e+20*cos(theta)**6 - 8.44748150181696e+18*cos(theta)**4 + 5.75964647851157e+16*cos(theta)**2 - 63925044156621.2)*cos(9*phi)

@torch.jit.script
def Yl43_m10(theta, phi):
    return 1.67706696673351e-16*(1.0 - cos(theta)**2)**5*(5.25024025848359e+27*cos(theta)**33 - 3.2613257135051e+28*cos(theta)**31 + 9.13564130590285e+28*cos(theta)**29 - 1.52636640748829e+29*cos(theta)**27 + 1.69542597793795e+29*cos(theta)**25 - 1.32111115163996e+29*cos(theta)**23 + 7.42758047477577e+28*cos(theta)**21 - 3.05243033209963e+28*cos(theta)**19 + 9.18953497868023e+27*cos(theta)**17 - 2.0125229582939e+27*cos(theta)**15 + 3.15395388986357e+26*cos(theta)**13 - 3.44067697076026e+25*cos(theta)**11 + 2.50313800782823e+24*cos(theta)**9 - 1.13635521162442e+23*cos(theta)**7 + 2.8890386736214e+21*cos(theta)**5 - 3.37899260072679e+19*cos(theta)**3 + 1.15192929570231e+17*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl43_m11(theta, phi):
    return 3.97279865204351e-18*(1.0 - cos(theta)**2)**5.5*(1.73257928529959e+29*cos(theta)**32 - 1.01101097118658e+30*cos(theta)**30 + 2.64933597871183e+30*cos(theta)**28 - 4.12118930021839e+30*cos(theta)**26 + 4.23856494484487e+30*cos(theta)**24 - 3.03855564877191e+30*cos(theta)**22 + 1.55979189970291e+30*cos(theta)**20 - 5.7996176309893e+29*cos(theta)**18 + 1.56222094637564e+29*cos(theta)**16 - 3.01878443744085e+28*cos(theta)**14 + 4.10014005682264e+27*cos(theta)**12 - 3.78474466783629e+26*cos(theta)**10 + 2.25282420704541e+25*cos(theta)**8 - 7.95448648137093e+23*cos(theta)**6 + 1.4445193368107e+22*cos(theta)**4 - 1.01369778021804e+20*cos(theta)**2 + 1.15192929570231e+17)*cos(11*phi)

@torch.jit.script
def Yl43_m12(theta, phi):
    return 9.469787223322e-20*(1.0 - cos(theta)**2)**6*(5.54425371295867e+30*cos(theta)**31 - 3.03303291355974e+31*cos(theta)**29 + 7.41814074039311e+31*cos(theta)**27 - 1.07150921805678e+32*cos(theta)**25 + 1.01725558676277e+32*cos(theta)**23 - 6.68482242729819e+31*cos(theta)**21 + 3.11958379940582e+31*cos(theta)**19 - 1.04393117357807e+31*cos(theta)**17 + 2.49955351420102e+30*cos(theta)**15 - 4.22629821241719e+29*cos(theta)**13 + 4.92016806818717e+28*cos(theta)**11 - 3.78474466783629e+27*cos(theta)**9 + 1.80225936563633e+26*cos(theta)**7 - 4.77269188882256e+24*cos(theta)**5 + 5.7780773472428e+22*cos(theta)**3 - 2.02739556043607e+20*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl43_m13(theta, phi):
    return 2.27282166505428e-21*(1.0 - cos(theta)**2)**6.5*(1.71871865101719e+32*cos(theta)**30 - 8.79579544932326e+32*cos(theta)**28 + 2.00289799990614e+33*cos(theta)**26 - 2.67877304514196e+33*cos(theta)**24 + 2.33968784955437e+33*cos(theta)**22 - 1.40381270973262e+33*cos(theta)**20 + 5.92720921887106e+32*cos(theta)**18 - 1.77468299508273e+32*cos(theta)**16 + 3.74933027130153e+31*cos(theta)**14 - 5.49418767614234e+30*cos(theta)**12 + 5.41218487500589e+29*cos(theta)**10 - 3.40627020105266e+28*cos(theta)**8 + 1.26158155594543e+27*cos(theta)**6 - 2.38634594441128e+25*cos(theta)**4 + 1.73342320417284e+23*cos(theta)**2 - 2.02739556043607e+20)*cos(13*phi)

@torch.jit.script
def Yl43_m14(theta, phi):
    return 5.49626046244125e-23*(1.0 - cos(theta)**2)**7*(5.15615595305157e+33*cos(theta)**29 - 2.46282272581051e+34*cos(theta)**27 + 5.20753479975596e+34*cos(theta)**25 - 6.4290553083407e+34*cos(theta)**23 + 5.14731326901961e+34*cos(theta)**21 - 2.80762541946524e+34*cos(theta)**19 + 1.06689765939679e+34*cos(theta)**17 - 2.83949279213236e+33*cos(theta)**15 + 5.24906237982215e+32*cos(theta)**13 - 6.59302521137081e+31*cos(theta)**11 + 5.41218487500589e+30*cos(theta)**9 - 2.72501616084213e+29*cos(theta)**7 + 7.56948933567257e+27*cos(theta)**5 - 9.54538377764511e+25*cos(theta)**3 + 3.46684640834568e+23*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl43_m15(theta, phi):
    return 1.34015277384818e-24*(1.0 - cos(theta)**2)**7.5*(1.49528522638495e+35*cos(theta)**28 - 6.64962135968838e+35*cos(theta)**26 + 1.30188369993899e+36*cos(theta)**24 - 1.47868272091836e+36*cos(theta)**22 + 1.08093578649412e+36*cos(theta)**20 - 5.33448829698396e+35*cos(theta)**18 + 1.81372602097455e+35*cos(theta)**16 - 4.25923918819854e+34*cos(theta)**14 + 6.82378109376879e+33*cos(theta)**12 - 7.25232773250789e+32*cos(theta)**10 + 4.8709663875053e+31*cos(theta)**8 - 1.90751131258949e+30*cos(theta)**6 + 3.78474466783629e+28*cos(theta)**4 - 2.86361513329353e+26*cos(theta)**2 + 3.46684640834568e+23)*cos(15*phi)

@torch.jit.script
def Yl43_m16(theta, phi):
    return 3.29723034522509e-26*(1.0 - cos(theta)**2)**8*(4.18679863387787e+36*cos(theta)**27 - 1.72890155351898e+37*cos(theta)**25 + 3.12452087985358e+37*cos(theta)**23 - 3.25310198602039e+37*cos(theta)**21 + 2.16187157298824e+37*cos(theta)**19 - 9.60207893457112e+36*cos(theta)**17 + 2.90196163355927e+36*cos(theta)**15 - 5.96293486347796e+35*cos(theta)**13 + 8.18853731252255e+34*cos(theta)**11 - 7.25232773250789e+33*cos(theta)**9 + 3.89677311000424e+32*cos(theta)**7 - 1.14450678755369e+31*cos(theta)**5 + 1.51389786713451e+29*cos(theta)**3 - 5.72723026658707e+26*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl43_m17(theta, phi):
    return 8.19203465488711e-28*(1.0 - cos(theta)**2)**8.5*(1.13043563114703e+38*cos(theta)**26 - 4.32225388379745e+38*cos(theta)**24 + 7.18639802366323e+38*cos(theta)**22 - 6.83151417064282e+38*cos(theta)**20 + 4.10755598867765e+38*cos(theta)**18 - 1.63235341887709e+38*cos(theta)**16 + 4.35294245033891e+37*cos(theta)**14 - 7.75181532252134e+36*cos(theta)**12 + 9.0073910437748e+35*cos(theta)**10 - 6.5270949592571e+34*cos(theta)**8 + 2.72774117700297e+33*cos(theta)**6 - 5.72253393776847e+31*cos(theta)**4 + 4.54169360140354e+29*cos(theta)**2 - 5.72723026658707e+26)*cos(17*phi)

@torch.jit.script
def Yl43_m18(theta, phi):
    return 2.05702793393481e-29*(1.0 - cos(theta)**2)**9*(2.93913264098227e+39*cos(theta)**25 - 1.03734093211139e+40*cos(theta)**23 + 1.58100756520591e+40*cos(theta)**21 - 1.36630283412856e+40*cos(theta)**19 + 7.39360077961976e+39*cos(theta)**17 - 2.61176547020335e+39*cos(theta)**15 + 6.09411943047447e+38*cos(theta)**13 - 9.30217838702561e+37*cos(theta)**11 + 9.0073910437748e+36*cos(theta)**9 - 5.22167596740568e+35*cos(theta)**7 + 1.63664470620178e+34*cos(theta)**5 - 2.28901357510739e+32*cos(theta)**3 + 9.08338720280709e+29*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl43_m19(theta, phi):
    return 5.2248561770532e-31*(1.0 - cos(theta)**2)**9.5*(7.34783160245567e+40*cos(theta)**24 - 2.38588414385619e+41*cos(theta)**22 + 3.32011588693241e+41*cos(theta)**20 - 2.59597538484427e+41*cos(theta)**18 + 1.25691213253536e+41*cos(theta)**16 - 3.91764820530502e+40*cos(theta)**14 + 7.92235525961681e+39*cos(theta)**12 - 1.02323962257282e+39*cos(theta)**10 + 8.10665193939732e+37*cos(theta)**8 - 3.65517317718398e+36*cos(theta)**6 + 8.18322353100891e+34*cos(theta)**4 - 6.86704072532216e+32*cos(theta)**2 + 9.08338720280709e+29)*cos(19*phi)

@torch.jit.script
def Yl43_m20(theta, phi):
    return 1.34368801864906e-32*(1.0 - cos(theta)**2)**10*(1.76347958458936e+42*cos(theta)**23 - 5.24894511648362e+42*cos(theta)**21 + 6.64023177386482e+42*cos(theta)**19 - 4.67275569271969e+42*cos(theta)**17 + 2.01105941205658e+42*cos(theta)**15 - 5.48470748742703e+41*cos(theta)**13 + 9.50682631154018e+40*cos(theta)**11 - 1.02323962257282e+40*cos(theta)**9 + 6.48532155151786e+38*cos(theta)**7 - 2.19310390631039e+37*cos(theta)**5 + 3.27328941240356e+35*cos(theta)**3 - 1.37340814506443e+33*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl43_m21(theta, phi):
    return 3.50222899855152e-34*(1.0 - cos(theta)**2)**10.5*(4.05600304455553e+43*cos(theta)**22 - 1.10227847446156e+44*cos(theta)**20 + 1.26164403703432e+44*cos(theta)**18 - 7.94368467762348e+43*cos(theta)**16 + 3.01658911808486e+43*cos(theta)**14 - 7.13011973365513e+42*cos(theta)**12 + 1.04575089426942e+42*cos(theta)**10 - 9.20915660315536e+40*cos(theta)**8 + 4.5397250860625e+39*cos(theta)**6 - 1.09655195315519e+38*cos(theta)**4 + 9.81986823721069e+35*cos(theta)**2 - 1.37340814506443e+33)*cos(21*phi)

@torch.jit.script
def Yl43_m22(theta, phi):
    return 9.26139742295083e-36*(1.0 - cos(theta)**2)**11*(8.92320669802216e+44*cos(theta)**21 - 2.20455694892312e+45*cos(theta)**19 + 2.27095926666177e+45*cos(theta)**17 - 1.27098954841976e+45*cos(theta)**15 + 4.22322476531881e+44*cos(theta)**13 - 8.55614368038616e+43*cos(theta)**11 + 1.04575089426942e+43*cos(theta)**9 - 7.36732528252429e+41*cos(theta)**7 + 2.7238350516375e+40*cos(theta)**5 - 4.38620781262077e+38*cos(theta)**3 + 1.96397364744214e+36*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl43_m23(theta, phi):
    return 2.48768224079308e-37*(1.0 - cos(theta)**2)**11.5*(1.87387340658465e+46*cos(theta)**20 - 4.18865820295393e+46*cos(theta)**18 + 3.86063075332501e+46*cos(theta)**16 - 1.90648432262963e+46*cos(theta)**14 + 5.49019219491445e+45*cos(theta)**12 - 9.41175804842478e+44*cos(theta)**10 + 9.41175804842478e+43*cos(theta)**8 - 5.157127697767e+42*cos(theta)**6 + 1.36191752581875e+41*cos(theta)**4 - 1.31586234378623e+39*cos(theta)**2 + 1.96397364744214e+36)*cos(23*phi)

@torch.jit.script
def Yl43_m24(theta, phi):
    return 6.79583000496612e-39*(1.0 - cos(theta)**2)**12*(3.74774681316931e+47*cos(theta)**19 - 7.53958476531708e+47*cos(theta)**17 + 6.17700920532001e+47*cos(theta)**15 - 2.66907805168149e+47*cos(theta)**13 + 6.58823063389734e+46*cos(theta)**11 - 9.41175804842478e+45*cos(theta)**9 + 7.52940643873982e+44*cos(theta)**7 - 3.0942766186602e+43*cos(theta)**5 + 5.447670103275e+41*cos(theta)**3 - 2.63172468757246e+39*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl43_m25(theta, phi):
    return 1.89065048220215e-40*(1.0 - cos(theta)**2)**12.5*(7.12071894502168e+48*cos(theta)**18 - 1.2817294101039e+49*cos(theta)**16 + 9.26551380798002e+48*cos(theta)**14 - 3.46980146718593e+48*cos(theta)**12 + 7.24705369728708e+47*cos(theta)**10 - 8.4705822435823e+46*cos(theta)**8 + 5.27058450711787e+45*cos(theta)**6 - 1.5471383093301e+44*cos(theta)**4 + 1.6343010309825e+42*cos(theta)**2 - 2.63172468757246e+39)*cos(25*phi)

@torch.jit.script
def Yl43_m26(theta, phi):
    return 5.36476190118919e-42*(1.0 - cos(theta)**2)**13*(1.2817294101039e+50*cos(theta)**17 - 2.05076705616624e+50*cos(theta)**15 + 1.2971719331172e+50*cos(theta)**13 - 4.16376176062312e+49*cos(theta)**11 + 7.24705369728708e+48*cos(theta)**9 - 6.77646579486584e+47*cos(theta)**7 + 3.16235070427072e+46*cos(theta)**5 - 6.1885532373204e+44*cos(theta)**3 + 3.268602061965e+42*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl43_m27(theta, phi):
    return 1.55516678174063e-43*(1.0 - cos(theta)**2)**13.5*(2.17893999717664e+51*cos(theta)**16 - 3.07615058424937e+51*cos(theta)**14 + 1.68632351305236e+51*cos(theta)**12 - 4.58013793668543e+50*cos(theta)**10 + 6.52234832755837e+49*cos(theta)**8 - 4.74352605640609e+48*cos(theta)**6 + 1.58117535213536e+47*cos(theta)**4 - 1.85656597119612e+45*cos(theta)**2 + 3.268602061965e+42)*cos(27*phi)

@torch.jit.script
def Yl43_m28(theta, phi):
    return 4.61410853000535e-45*(1.0 - cos(theta)**2)**14*(3.48630399548262e+52*cos(theta)**15 - 4.30661081794911e+52*cos(theta)**13 + 2.02358821566284e+52*cos(theta)**11 - 4.58013793668543e+51*cos(theta)**9 + 5.2178786620467e+50*cos(theta)**7 - 2.84611563384365e+49*cos(theta)**5 + 6.32470140854145e+47*cos(theta)**3 - 3.71313194239224e+45*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl43_m29(theta, phi):
    return 1.40402851370052e-46*(1.0 - cos(theta)**2)**14.5*(5.22945599322392e+53*cos(theta)**14 - 5.59859406333385e+53*cos(theta)**12 + 2.22594703722912e+53*cos(theta)**10 - 4.12212414301689e+52*cos(theta)**8 + 3.65251506343269e+51*cos(theta)**6 - 1.42305781692183e+50*cos(theta)**4 + 1.89741042256243e+48*cos(theta)**2 - 3.71313194239224e+45)*cos(29*phi)

@torch.jit.script
def Yl43_m30(theta, phi):
    return 4.39188014702948e-48*(1.0 - cos(theta)**2)**15*(7.32123839051349e+54*cos(theta)**13 - 6.71831287600062e+54*cos(theta)**11 + 2.22594703722912e+54*cos(theta)**9 - 3.29769931441351e+53*cos(theta)**7 + 2.19150903805961e+52*cos(theta)**5 - 5.6922312676873e+50*cos(theta)**3 + 3.79482084512487e+48*cos(theta))*cos(30*phi)

@torch.jit.script
def Yl43_m31(theta, phi):
    return 1.41599899081267e-49*(1.0 - cos(theta)**2)**15.5*(9.51760990766754e+55*cos(theta)**12 - 7.39014416360068e+55*cos(theta)**10 + 2.00335233350621e+55*cos(theta)**8 - 2.30838952008946e+54*cos(theta)**6 + 1.09575451902981e+53*cos(theta)**4 - 1.70766938030619e+51*cos(theta)**2 + 3.79482084512487e+48)*cos(31*phi)

@torch.jit.script
def Yl43_m32(theta, phi):
    return 4.71999663604224e-51*(1.0 - cos(theta)**2)**16*(1.1421131889201e+57*cos(theta)**11 - 7.39014416360068e+56*cos(theta)**9 + 1.60268186680497e+56*cos(theta)**7 - 1.38503371205367e+55*cos(theta)**5 + 4.38301807611922e+53*cos(theta)**3 - 3.41533876061238e+51*cos(theta))*cos(32*phi)

@torch.jit.script
def Yl43_m33(theta, phi):
    return 1.63244497127482e-52*(1.0 - cos(theta)**2)**16.5*(1.25632450781212e+58*cos(theta)**10 - 6.65112974724061e+57*cos(theta)**8 + 1.12187730676348e+57*cos(theta)**6 - 6.92516856026837e+55*cos(theta)**4 + 1.31490542283577e+54*cos(theta)**2 - 3.41533876061238e+51)*cos(33*phi)

@torch.jit.script
def Yl43_m34(theta, phi):
    return 5.88292332164183e-54*(1.0 - cos(theta)**2)**17*(1.25632450781212e+59*cos(theta)**9 - 5.32090379779249e+58*cos(theta)**7 + 6.73126384058086e+57*cos(theta)**5 - 2.77006742410735e+56*cos(theta)**3 + 2.62981084567153e+54*cos(theta))*cos(34*phi)

@torch.jit.script
def Yl43_m35(theta, phi):
    return 2.22036632357623e-55*(1.0 - cos(theta)**2)**17.5*(1.1306920570309e+60*cos(theta)**8 - 3.72463265845474e+59*cos(theta)**6 + 3.36563192029043e+58*cos(theta)**4 - 8.31020227232205e+56*cos(theta)**2 + 2.62981084567153e+54)*cos(35*phi)

@torch.jit.script
def Yl43_m36(theta, phi):
    return 8.83214301129778e-57*(1.0 - cos(theta)**2)**18*(9.04553645624723e+60*cos(theta)**7 - 2.23477959507285e+60*cos(theta)**5 + 1.34625276811617e+59*cos(theta)**3 - 1.66204045446441e+57*cos(theta))*cos(36*phi)

@torch.jit.script
def Yl43_m37(theta, phi):
    return 3.73226162218452e-58*(1.0 - cos(theta)**2)**18.5*(6.33187551937306e+61*cos(theta)**6 - 1.11738979753642e+61*cos(theta)**4 + 4.03875830434852e+59*cos(theta)**2 - 1.66204045446441e+57)*cos(37*phi)

@torch.jit.script
def Yl43_m38(theta, phi):
    return 1.69298825202302e-59*(1.0 - cos(theta)**2)**19*(3.79912531162384e+62*cos(theta)**5 - 4.46955919014569e+61*cos(theta)**3 + 8.07751660869703e+59*cos(theta))*cos(38*phi)

@torch.jit.script
def Yl43_m39(theta, phi):
    return 8.36107301651595e-61*(1.0 - cos(theta)**2)**19.5*(1.89956265581192e+63*cos(theta)**4 - 1.34086775704371e+62*cos(theta)**2 + 8.07751660869703e+59)*cos(39*phi)

@torch.jit.script
def Yl43_m40(theta, phi):
    return 4.5887349618882e-62*(1.0 - cos(theta)**2)**20*(7.59825062324767e+63*cos(theta)**3 - 2.68173551408741e+62*cos(theta))*cos(40*phi)

@torch.jit.script
def Yl43_m41(theta, phi):
    return 2.89063131941515e-63*(1.0 - cos(theta)**2)**20.5*(2.2794751869743e+64*cos(theta)**2 - 2.68173551408741e+62)*cos(41*phi)

@torch.jit.script
def Yl43_m42(theta, phi):
    return 10.1072523258968*(1.0 - cos(theta)**2)**21*cos(42*phi)*cos(theta)

@torch.jit.script
def Yl43_m43(theta, phi):
    return 1.08989304776835*(1.0 - cos(theta)**2)**21.5*cos(43*phi)

@torch.jit.script
def Yl44_m_minus_44(theta, phi):
    return 1.09606812861653*(1.0 - cos(theta)**2)**22*sin(44*phi)

@torch.jit.script
def Yl44_m_minus_43(theta, phi):
    return 10.2820304486063*(1.0 - cos(theta)**2)**21.5*sin(43*phi)*cos(theta)

@torch.jit.script
def Yl44_m_minus_42(theta, phi):
    return 3.4195534181066e-65*(1.0 - cos(theta)**2)**21*(1.98314341266764e+66*cos(theta)**2 - 2.2794751869743e+64)*sin(42*phi)

@torch.jit.script
def Yl44_m_minus_41(theta, phi):
    return 5.49261609750345e-64*(1.0 - cos(theta)**2)**20.5*(6.61047804222548e+65*cos(theta)**3 - 2.2794751869743e+64*cos(theta))*sin(41*phi)

@torch.jit.script
def Yl44_m_minus_40(theta, phi):
    return 1.01278836595551e-62*(1.0 - cos(theta)**2)**20*(1.65261951055637e+65*cos(theta)**4 - 1.13973759348715e+64*cos(theta)**2 + 6.70433878521854e+61)*sin(40*phi)

@torch.jit.script
def Yl44_m_minus_39(theta, phi):
    return 2.07559850445656e-61*(1.0 - cos(theta)**2)**19.5*(3.30523902111274e+64*cos(theta)**5 - 3.79912531162384e+63*cos(theta)**3 + 6.70433878521854e+61*cos(theta))*sin(39*phi)

@torch.jit.script
def Yl44_m_minus_38(theta, phi):
    return 4.63188769029189e-60*(1.0 - cos(theta)**2)**19*(5.50873170185456e+63*cos(theta)**6 - 9.49781327905959e+62*cos(theta)**4 + 3.35216939260927e+61*cos(theta)**2 - 1.34625276811617e+59)*sin(38*phi)

@torch.jit.script
def Yl44_m_minus_37(theta, phi):
    return 1.10972141424432e-58*(1.0 - cos(theta)**2)**18.5*(7.86961671693509e+62*cos(theta)**7 - 1.89956265581192e+62*cos(theta)**5 + 1.11738979753642e+61*cos(theta)**3 - 1.34625276811617e+59*cos(theta))*sin(37*phi)

@torch.jit.script
def Yl44_m_minus_36(theta, phi):
    return 2.8248895340643e-57*(1.0 - cos(theta)**2)**18*(9.83702089616886e+61*cos(theta)**8 - 3.16593775968653e+61*cos(theta)**6 + 2.79347449384106e+60*cos(theta)**4 - 6.73126384058086e+58*cos(theta)**2 + 2.07755056808051e+56)*sin(36*phi)

@torch.jit.script
def Yl44_m_minus_35(theta, phi):
    return 7.57997403251458e-56*(1.0 - cos(theta)**2)**17.5*(1.09300232179654e+61*cos(theta)**9 - 4.52276822812362e+60*cos(theta)**7 + 5.58694898768211e+59*cos(theta)**5 - 2.24375461352695e+58*cos(theta)**3 + 2.07755056808051e+56*cos(theta))*sin(35*phi)

@torch.jit.script
def Yl44_m_minus_34(theta, phi):
    return 2.13049865063417e-54*(1.0 - cos(theta)**2)**17*(1.09300232179654e+60*cos(theta)**10 - 5.65346028515452e+59*cos(theta)**8 + 9.31158164613686e+58*cos(theta)**6 - 5.60938653381738e+57*cos(theta)**4 + 1.03877528404026e+56*cos(theta)**2 - 2.62981084567153e+53)*sin(34*phi)

@torch.jit.script
def Yl44_m_minus_33(theta, phi):
    return 6.24057931710171e-53*(1.0 - cos(theta)**2)**16.5*(9.93638474360491e+58*cos(theta)**11 - 6.28162253906058e+58*cos(theta)**9 + 1.33022594944812e+58*cos(theta)**7 - 1.12187730676348e+57*cos(theta)**5 + 3.46258428013419e+55*cos(theta)**3 - 2.62981084567153e+53*cos(theta))*sin(33*phi)

@torch.jit.script
def Yl44_m_minus_32(theta, phi):
    return 1.89697187951869e-51*(1.0 - cos(theta)**2)**16*(8.28032061967076e+57*cos(theta)**12 - 6.28162253906058e+57*cos(theta)**10 + 1.66278243681015e+57*cos(theta)**8 - 1.86979551127246e+56*cos(theta)**6 + 8.65646070033547e+54*cos(theta)**4 - 1.31490542283577e+53*cos(theta)**2 + 2.84611563384365e+50)*sin(32*phi)

@torch.jit.script
def Yl44_m_minus_31(theta, phi):
    return 5.96265065549245e-50*(1.0 - cos(theta)**2)**15.5*(6.36947739974674e+56*cos(theta)**13 - 5.71056594460052e+56*cos(theta)**11 + 1.84753604090017e+56*cos(theta)**9 - 2.67113644467494e+55*cos(theta)**7 + 1.73129214006709e+54*cos(theta)**5 - 4.38301807611922e+52*cos(theta)**3 + 2.84611563384365e+50*cos(theta))*sin(31*phi)

@torch.jit.script
def Yl44_m_minus_30(theta, phi):
    return 1.93211963867191e-48*(1.0 - cos(theta)**2)**15*(4.54962671410481e+55*cos(theta)**14 - 4.75880495383377e+55*cos(theta)**12 + 1.84753604090017e+55*cos(theta)**10 - 3.33892055584368e+54*cos(theta)**8 + 2.88548690011182e+53*cos(theta)**6 - 1.09575451902981e+52*cos(theta)**4 + 1.42305781692183e+50*cos(theta)**2 - 2.71058631794634e+47)*sin(30*phi)

@torch.jit.script
def Yl44_m_minus_29(theta, phi):
    return 6.43717779072263e-47*(1.0 - cos(theta)**2)**14.5*(3.03308447606988e+54*cos(theta)**15 - 3.66061919525675e+54*cos(theta)**13 + 1.67957821900015e+54*cos(theta)**11 - 3.7099117287152e+53*cos(theta)**9 + 4.12212414301689e+52*cos(theta)**7 - 2.19150903805961e+51*cos(theta)**5 + 4.74352605640609e+49*cos(theta)**3 - 2.71058631794634e+47*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl44_m_minus_28(theta, phi):
    return 2.19997084612836e-45*(1.0 - cos(theta)**2)**14*(1.89567779754367e+53*cos(theta)**16 - 2.61472799661196e+53*cos(theta)**14 + 1.39964851583346e+53*cos(theta)**12 - 3.7099117287152e+52*cos(theta)**10 + 5.15265517877111e+51*cos(theta)**8 - 3.65251506343269e+50*cos(theta)**6 + 1.18588151410152e+49*cos(theta)**4 - 1.35529315897317e+47*cos(theta)**2 + 2.32070746399515e+44)*sin(28*phi)

@torch.jit.script
def Yl44_m_minus_27(theta, phi):
    return 7.69675450430194e-44*(1.0 - cos(theta)**2)**13.5*(1.1151045867904e+52*cos(theta)**17 - 1.74315199774131e+52*cos(theta)**15 + 1.07665270448728e+52*cos(theta)**13 - 3.37264702610473e+51*cos(theta)**11 + 5.72517242085679e+50*cos(theta)**9 - 5.2178786620467e+49*cos(theta)**7 + 2.37176302820304e+48*cos(theta)**5 - 4.51764386324389e+46*cos(theta)**3 + 2.32070746399515e+44*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl44_m_minus_26(theta, phi):
    return 2.75152245514281e-42*(1.0 - cos(theta)**2)**13*(6.19502548216886e+50*cos(theta)**18 - 1.08946999858832e+51*cos(theta)**16 + 7.69037646062342e+50*cos(theta)**14 - 2.81053918842061e+50*cos(theta)**12 + 5.72517242085679e+49*cos(theta)**10 - 6.52234832755837e+48*cos(theta)**8 + 3.95293838033841e+47*cos(theta)**6 - 1.12941096581097e+46*cos(theta)**4 + 1.16035373199758e+44*cos(theta)**2 - 1.815890034425e+41)*sin(26*phi)

@torch.jit.script
def Yl44_m_minus_25(theta, phi):
    return 1.00345726576353e-40*(1.0 - cos(theta)**2)**12.5*(3.2605397274573e+49*cos(theta)**19 - 6.40864705051951e+49*cos(theta)**17 + 5.12691764041561e+49*cos(theta)**15 - 2.161953221862e+49*cos(theta)**13 + 5.2047022007789e+48*cos(theta)**11 - 7.24705369728708e+47*cos(theta)**9 + 5.64705482905487e+46*cos(theta)**7 - 2.25882193162195e+45*cos(theta)**5 + 3.86784577332525e+43*cos(theta)**3 - 1.815890034425e+41*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl44_m_minus_24(theta, phi):
    return 3.72767829649342e-39*(1.0 - cos(theta)**2)**12*(1.63026986372865e+48*cos(theta)**20 - 3.56035947251084e+48*cos(theta)**18 + 3.20432352525976e+48*cos(theta)**16 - 1.54425230133e+48*cos(theta)**14 + 4.33725183398242e+47*cos(theta)**12 - 7.24705369728708e+46*cos(theta)**10 + 7.05881853631858e+45*cos(theta)**8 - 3.76470321936991e+44*cos(theta)**6 + 9.66961443331313e+42*cos(theta)**4 - 9.079450172125e+40*cos(theta)**2 + 1.31586234378623e+38)*sin(24*phi)

@torch.jit.script
def Yl44_m_minus_23(theta, phi):
    return 1.40864814870526e-37*(1.0 - cos(theta)**2)**11.5*(7.76318982727928e+46*cos(theta)**21 - 1.87387340658465e+47*cos(theta)**19 + 1.88489619132927e+47*cos(theta)**17 - 1.02950153422e+47*cos(theta)**15 + 3.33634756460186e+46*cos(theta)**13 - 6.58823063389734e+45*cos(theta)**11 + 7.84313170702065e+44*cos(theta)**9 - 5.37814745624273e+43*cos(theta)**7 + 1.93392288666262e+42*cos(theta)**5 - 3.02648339070833e+40*cos(theta)**3 + 1.31586234378623e+38*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl44_m_minus_22(theta, phi):
    return 5.40818165421429e-36*(1.0 - cos(theta)**2)**11*(3.52872264876331e+45*cos(theta)**22 - 9.36936703292327e+45*cos(theta)**20 + 1.04716455073848e+46*cos(theta)**18 - 6.43438458887501e+45*cos(theta)**16 + 2.38310540328704e+45*cos(theta)**14 - 5.49019219491445e+44*cos(theta)**12 + 7.84313170702065e+43*cos(theta)**10 - 6.72268432030341e+42*cos(theta)**8 + 3.22320481110438e+41*cos(theta)**6 - 7.56620847677083e+39*cos(theta)**4 + 6.57931171893116e+37*cos(theta)**2 - 8.92715294291881e+34)*sin(22*phi)

@torch.jit.script
def Yl44_m_minus_21(theta, phi):
    return 2.10710974858833e-34*(1.0 - cos(theta)**2)**10.5*(1.53422723859274e+44*cos(theta)**23 - 4.46160334901108e+44*cos(theta)**21 + 5.5113923723078e+44*cos(theta)**19 - 3.78493211110295e+44*cos(theta)**17 + 1.5887369355247e+44*cos(theta)**15 - 4.22322476531881e+43*cos(theta)**13 + 7.13011973365513e+42*cos(theta)**11 - 7.46964924478157e+41*cos(theta)**9 + 4.60457830157768e+40*cos(theta)**7 - 1.51324169535417e+39*cos(theta)**5 + 2.19310390631039e+37*cos(theta)**3 - 8.92715294291881e+34*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl44_m_minus_20(theta, phi):
    return 8.32241667332855e-33*(1.0 - cos(theta)**2)**10*(6.39261349413643e+42*cos(theta)**24 - 2.02800152227776e+43*cos(theta)**22 + 2.7556961861539e+43*cos(theta)**20 - 2.10274006172386e+43*cos(theta)**18 + 9.92960584702934e+42*cos(theta)**16 - 3.01658911808486e+42*cos(theta)**14 + 5.94176644471261e+41*cos(theta)**12 - 7.46964924478157e+40*cos(theta)**10 + 5.7557228769721e+39*cos(theta)**8 - 2.52206949225694e+38*cos(theta)**6 + 5.48275976577597e+36*cos(theta)**4 - 4.4635764714594e+34*cos(theta)**2 + 5.72253393776847e+31)*sin(20*phi)

@torch.jit.script
def Yl44_m_minus_19(theta, phi):
    return 3.32896666933142e-31*(1.0 - cos(theta)**2)**9.5*(2.55704539765457e+41*cos(theta)**25 - 8.8173979229468e+41*cos(theta)**23 + 1.31223627912091e+42*cos(theta)**21 - 1.10670529564414e+42*cos(theta)**19 + 5.84094461589961e+41*cos(theta)**17 - 2.01105941205658e+41*cos(theta)**15 + 4.57058957285585e+40*cos(theta)**13 - 6.7905902225287e+39*cos(theta)**11 + 6.39524764108011e+38*cos(theta)**9 - 3.60295641750992e+37*cos(theta)**7 + 1.09655195315519e+36*cos(theta)**5 - 1.4878588238198e+34*cos(theta)**3 + 5.72253393776847e+31*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl44_m_minus_18(theta, phi):
    return 1.34730647078091e-29*(1.0 - cos(theta)**2)**9*(9.83478999097912e+39*cos(theta)**26 - 3.67391580122783e+40*cos(theta)**24 + 5.96471035964048e+40*cos(theta)**22 - 5.53352647822069e+40*cos(theta)**20 + 3.24496923105534e+40*cos(theta)**18 - 1.25691213253536e+40*cos(theta)**16 + 3.26470683775418e+39*cos(theta)**14 - 5.65882518544058e+38*cos(theta)**12 + 6.39524764108011e+37*cos(theta)**10 - 4.5036955218874e+36*cos(theta)**8 + 1.82758658859199e+35*cos(theta)**6 - 3.7196470595495e+33*cos(theta)**4 + 2.86126696888423e+31*cos(theta)**2 - 3.49361046261811e+28)*sin(18*phi)

@torch.jit.script
def Yl44_m_minus_17(theta, phi):
    return 5.51244313501043e-28*(1.0 - cos(theta)**2)**8.5*(3.64251481147375e+38*cos(theta)**27 - 1.46956632049113e+39*cos(theta)**25 + 2.59335233027847e+39*cos(theta)**23 - 2.63501260867652e+39*cos(theta)**21 + 1.70787854266071e+39*cos(theta)**19 - 7.39360077961976e+38*cos(theta)**17 + 2.17647122516945e+38*cos(theta)**15 - 4.35294245033891e+37*cos(theta)**13 + 5.81386149189101e+36*cos(theta)**11 - 5.00410613543045e+35*cos(theta)**9 + 2.61083798370284e+34*cos(theta)**7 - 7.439294119099e+32*cos(theta)**5 + 9.53755656294744e+30*cos(theta)**3 - 3.49361046261811e+28*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl44_m_minus_16(theta, phi):
    return 2.27818010861661e-26*(1.0 - cos(theta)**2)**8*(1.30089814695491e+37*cos(theta)**28 - 5.65217815573513e+37*cos(theta)**26 + 1.08056347094936e+38*cos(theta)**24 - 1.19773300394387e+38*cos(theta)**22 + 8.53939271330353e+37*cos(theta)**20 - 4.10755598867765e+37*cos(theta)**18 + 1.36029451573091e+37*cos(theta)**16 - 3.10924460738494e+36*cos(theta)**14 + 4.84488457657584e+35*cos(theta)**12 - 5.00410613543045e+34*cos(theta)**10 + 3.26354747962855e+33*cos(theta)**8 - 1.23988235318317e+32*cos(theta)**6 + 2.38438914073686e+30*cos(theta)**4 - 1.74680523130906e+28*cos(theta)**2 + 2.04543938092395e+25)*sin(16*phi)

@torch.jit.script
def Yl44_m_minus_15(theta, phi):
    return 9.50304267942416e-25*(1.0 - cos(theta)**2)**7.5*(4.48585567915486e+35*cos(theta)**29 - 2.09339931693894e+36*cos(theta)**27 + 4.32225388379745e+36*cos(theta)**25 - 5.20753479975596e+36*cos(theta)**23 + 4.06637748252549e+36*cos(theta)**21 - 2.16187157298824e+36*cos(theta)**19 + 8.00173244547594e+35*cos(theta)**17 - 2.07282973825662e+35*cos(theta)**15 + 3.72683428967372e+34*cos(theta)**13 - 4.54918739584586e+33*cos(theta)**11 + 3.62616386625395e+32*cos(theta)**9 - 1.77126050454738e+31*cos(theta)**7 + 4.76877828147372e+29*cos(theta)**5 - 5.82268410436352e+27*cos(theta)**3 + 2.04543938092395e+25*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl44_m_minus_14(theta, phi):
    return 3.99806005076855e-23*(1.0 - cos(theta)**2)**7*(1.49528522638495e+34*cos(theta)**30 - 7.47642613192477e+34*cos(theta)**28 + 1.6624053399221e+35*cos(theta)**26 - 2.16980616656498e+35*cos(theta)**24 + 1.84835340114795e+35*cos(theta)**22 - 1.08093578649412e+35*cos(theta)**20 + 4.4454069141533e+34*cos(theta)**18 - 1.29551858641039e+34*cos(theta)**16 + 2.66202449262409e+33*cos(theta)**14 - 3.79098949653822e+32*cos(theta)**12 + 3.62616386625395e+31*cos(theta)**10 - 2.21407563068423e+30*cos(theta)**8 + 7.9479638024562e+28*cos(theta)**6 - 1.45567102609088e+27*cos(theta)**4 + 1.02271969046198e+25*cos(theta)**2 - 1.15561546944856e+22)*sin(14*phi)

@torch.jit.script
def Yl44_m_minus_13(theta, phi):
    return 1.69529061039261e-21*(1.0 - cos(theta)**2)**6.5*(4.82350073027405e+32*cos(theta)**31 - 2.57807797652578e+33*cos(theta)**29 + 6.15705681452628e+33*cos(theta)**27 - 8.67922466625994e+33*cos(theta)**25 + 8.03631913542587e+33*cos(theta)**23 - 5.14731326901961e+33*cos(theta)**21 + 2.33968784955437e+33*cos(theta)**19 - 7.62069756711994e+32*cos(theta)**17 + 1.77468299508273e+32*cos(theta)**15 - 2.91614576656786e+31*cos(theta)**13 + 3.29651260568541e+30*cos(theta)**11 - 2.46008403409359e+29*cos(theta)**9 + 1.13542340035089e+28*cos(theta)**7 - 2.91134205218176e+26*cos(theta)**5 + 3.40906563487325e+24*cos(theta)**3 - 1.15561546944856e+22*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl44_m_minus_12(theta, phi):
    return 7.24030020283832e-20*(1.0 - cos(theta)**2)**6*(1.50734397821064e+31*cos(theta)**32 - 8.59359325508594e+31*cos(theta)**30 + 2.19894886233082e+32*cos(theta)**28 - 3.3381633331769e+32*cos(theta)**26 + 3.34846630642745e+32*cos(theta)**24 - 2.33968784955437e+32*cos(theta)**22 + 1.16984392477718e+32*cos(theta)**20 - 4.23372087062219e+31*cos(theta)**18 + 1.1091768719267e+31*cos(theta)**16 - 2.08296126183418e+30*cos(theta)**14 + 2.74709383807117e+29*cos(theta)**12 - 2.46008403409359e+28*cos(theta)**10 + 1.41927925043861e+27*cos(theta)**8 - 4.85223675363626e+25*cos(theta)**6 + 8.52266408718313e+23*cos(theta)**4 - 5.7780773472428e+21*cos(theta)**2 + 6.33561112636272e+18)*sin(12*phi)

@torch.jit.script
def Yl44_m_minus_11(theta, phi):
    return 3.11248707798609e-18*(1.0 - cos(theta)**2)**5.5*(4.56770902488073e+29*cos(theta)**33 - 2.77212685647934e+30*cos(theta)**31 + 7.58258228389936e+30*cos(theta)**29 - 1.23635679006552e+31*cos(theta)**27 + 1.33938652257098e+31*cos(theta)**25 - 1.01725558676277e+31*cos(theta)**23 + 5.57068535608183e+30*cos(theta)**21 - 2.22827414243273e+30*cos(theta)**19 + 6.52456983486296e+29*cos(theta)**17 - 1.38864084122279e+29*cos(theta)**15 + 2.11314910620859e+28*cos(theta)**13 - 2.23644003099417e+27*cos(theta)**11 + 1.57697694493179e+26*cos(theta)**9 - 6.93176679090895e+24*cos(theta)**7 + 1.70453281743663e+23*cos(theta)**5 - 1.92602578241427e+21*cos(theta)**3 + 6.33561112636272e+18*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl44_m_minus_10(theta, phi):
    return 1.34594824439422e-16*(1.0 - cos(theta)**2)**5*(1.34344383084727e+28*cos(theta)**34 - 8.66289642649793e+28*cos(theta)**32 + 2.52752742796645e+29*cos(theta)**30 - 4.41555996451971e+29*cos(theta)**28 + 5.15148662527299e+29*cos(theta)**26 - 4.23856494484487e+29*cos(theta)**24 + 2.53212970730992e+29*cos(theta)**22 - 1.11413707121637e+29*cos(theta)**20 + 3.62476101936831e+28*cos(theta)**18 - 8.67900525764244e+27*cos(theta)**16 + 1.50939221872042e+27*cos(theta)**14 - 1.86370002582847e+26*cos(theta)**12 + 1.57697694493179e+25*cos(theta)**10 - 8.66470848863619e+23*cos(theta)**8 + 2.84088802906104e+22*cos(theta)**6 - 4.81506445603567e+20*cos(theta)**4 + 3.16780556318136e+18*cos(theta)**2 - 3.38802734030092e+15)*sin(10*phi)

@torch.jit.script
def Yl44_m_minus_9(theta, phi):
    return 5.85139292711667e-15*(1.0 - cos(theta)**2)**4.5*(3.83841094527792e+26*cos(theta)**35 - 2.6251201292418e+27*cos(theta)**33 + 8.15331428376276e+27*cos(theta)**31 - 1.52260688431714e+28*cos(theta)**29 + 1.90795800936037e+28*cos(theta)**27 - 1.69542597793795e+28*cos(theta)**25 + 1.10092595969997e+28*cos(theta)**23 - 5.30541462483984e+27*cos(theta)**21 + 1.90776895756227e+27*cos(theta)**19 - 5.1052972103779e+26*cos(theta)**17 + 1.00626147914695e+26*cos(theta)**15 - 1.43361540448344e+25*cos(theta)**13 + 1.43361540448344e+24*cos(theta)**11 - 9.62745387626243e+22*cos(theta)**9 + 4.05841147008721e+21*cos(theta)**7 - 9.63012891207134e+19*cos(theta)**5 + 1.05593518772712e+18*cos(theta)**3 - 3.38802734030092e+15*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl44_m_minus_8(theta, phi):
    return 2.55592701088609e-13*(1.0 - cos(theta)**2)**4*(1.0662252625772e+25*cos(theta)**36 - 7.72094155659352e+25*cos(theta)**34 + 2.54791071367586e+26*cos(theta)**32 - 5.07535628105714e+26*cos(theta)**30 + 6.8141357477156e+26*cos(theta)**28 - 6.52086914591518e+26*cos(theta)**26 + 4.58719149874986e+26*cos(theta)**24 - 2.41155210219992e+26*cos(theta)**22 + 9.53884478781135e+25*cos(theta)**20 - 2.83627622798772e+25*cos(theta)**18 + 6.28913424466843e+24*cos(theta)**16 - 1.02401100320246e+24*cos(theta)**14 + 1.1946795037362e+23*cos(theta)**12 - 9.62745387626243e+21*cos(theta)**10 + 5.07301433760901e+20*cos(theta)**8 - 1.60502148534522e+19*cos(theta)**6 + 2.6398379693178e+17*cos(theta)**4 - 1.69401367015046e+15*cos(theta)**2 + 1775695671017.25)*sin(8*phi)

@torch.jit.script
def Yl44_m_minus_7(theta, phi):
    return 1.12111711211166e-11*(1.0 - cos(theta)**2)**3.5*(2.8816898988573e+23*cos(theta)**37 - 2.20598330188386e+24*cos(theta)**35 + 7.72094155659352e+24*cos(theta)**33 - 1.63721170356682e+25*cos(theta)**31 + 2.3497019819709e+25*cos(theta)**29 - 2.41513672070933e+25*cos(theta)**27 + 1.83487659949994e+25*cos(theta)**25 - 1.04850091399997e+25*cos(theta)**23 + 4.54230704181493e+24*cos(theta)**21 - 1.4927769620988e+24*cos(theta)**19 + 3.6994907321579e+23*cos(theta)**17 - 6.82674002134972e+22*cos(theta)**15 + 9.18984233643232e+21*cos(theta)**13 - 8.75223079660221e+20*cos(theta)**11 + 5.63668259734334e+19*cos(theta)**9 - 2.29288783620746e+18*cos(theta)**7 + 5.2796759386356e+16*cos(theta)**5 - 564671223383487.0*cos(theta)**3 + 1775695671017.25*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl44_m_minus_6(theta, phi):
    return 4.93546262901146e-10*(1.0 - cos(theta)**2)**3*(7.5833944706771e+21*cos(theta)**38 - 6.12773139412184e+22*cos(theta)**36 + 2.27086516370398e+23*cos(theta)**34 - 5.11628657364631e+23*cos(theta)**32 + 7.83233993990299e+23*cos(theta)**30 - 8.62548828824759e+23*cos(theta)**28 + 7.0572176903844e+23*cos(theta)**26 - 4.3687538083332e+23*cos(theta)**24 + 2.06468501900678e+23*cos(theta)**22 - 7.46388481049401e+22*cos(theta)**20 + 2.05527262897661e+22*cos(theta)**18 - 4.26671251334358e+21*cos(theta)**16 + 6.56417309745166e+20*cos(theta)**14 - 7.29352566383517e+19*cos(theta)**12 + 5.63668259734334e+18*cos(theta)**10 - 2.86610979525933e+17*cos(theta)**8 + 8.799459897726e+15*cos(theta)**6 - 141167805845872.0*cos(theta)**4 + 887847835508.627*cos(theta)**2 - 916251636.231813)*sin(6*phi)

@torch.jit.script
def Yl44_m_minus_5(theta, phi):
    return 2.17944128520635e-8*(1.0 - cos(theta)**2)**2.5*(1.94446012068644e+20*cos(theta)**39 - 1.65614362003293e+21*cos(theta)**37 + 6.48818618201136e+21*cos(theta)**35 - 1.55038987080191e+22*cos(theta)**33 + 2.52656127093645e+22*cos(theta)**31 - 2.97430630629227e+22*cos(theta)**29 + 2.613784329772e+22*cos(theta)**27 - 1.74750152333328e+22*cos(theta)**25 + 8.97689138698602e+21*cos(theta)**23 - 3.55423086214001e+21*cos(theta)**21 + 1.08172243630348e+21*cos(theta)**19 - 2.5098308902021e+20*cos(theta)**17 + 4.3761153983011e+19*cos(theta)**15 - 5.61040435679629e+18*cos(theta)**13 + 5.12425690667577e+17*cos(theta)**11 - 3.18456643917703e+16*cos(theta)**9 + 1.25706569967514e+15*cos(theta)**7 - 28233561169174.3*cos(theta)**5 + 295949278502.876*cos(theta)**3 - 916251636.231813*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl44_m_minus_4(theta, phi):
    return 9.64879788299937e-7*(1.0 - cos(theta)**2)**2*(4.86115030171609e+18*cos(theta)**40 - 4.35827268429718e+19*cos(theta)**38 + 1.8022739394476e+20*cos(theta)**36 - 4.55997020824091e+20*cos(theta)**34 + 7.8955039716764e+20*cos(theta)**32 - 9.91435435430758e+20*cos(theta)**30 + 9.33494403489999e+20*cos(theta)**28 - 6.721159705128e+20*cos(theta)**26 + 3.74037141124418e+20*cos(theta)**24 - 1.61555948279091e+20*cos(theta)**22 + 5.4086121815174e+19*cos(theta)**20 - 1.39435049455672e+19*cos(theta)**18 + 2.73507212393819e+18*cos(theta)**16 - 4.00743168342592e+17*cos(theta)**14 + 4.27021408889647e+16*cos(theta)**12 - 3.18456643917703e+15*cos(theta)**10 + 157133212459393.0*cos(theta)**8 - 4705593528195.72*cos(theta)**6 + 73987319625.7189*cos(theta)**4 - 458125818.115907*cos(theta)**2 + 467475.324608068)*sin(4*phi)

@torch.jit.script
def Yl44_m_minus_3(theta, phi):
    return 4.28041380657482e-5*(1.0 - cos(theta)**2)**1.5*(1.1856464150527e+17*cos(theta)**41 - 1.11750581648646e+18*cos(theta)**39 + 4.87101064715568e+18*cos(theta)**37 - 1.30284863092598e+19*cos(theta)**35 + 2.39257696111406e+19*cos(theta)**33 - 3.19817882397019e+19*cos(theta)**31 + 3.21894621893103e+19*cos(theta)**29 - 2.48931840930666e+19*cos(theta)**27 + 1.49614856449767e+19*cos(theta)**25 - 7.02417166430831e+18*cos(theta)**23 + 2.57552961024638e+18*cos(theta)**21 - 7.33868681345644e+17*cos(theta)**19 + 1.60886595525776e+17*cos(theta)**17 - 2.67162112228395e+16*cos(theta)**15 + 3.2847800683819e+15*cos(theta)**13 - 289506039925185.0*cos(theta)**11 + 17459245828821.4*cos(theta)**9 - 672227646885.103*cos(theta)**7 + 14797463925.1438*cos(theta)**5 - 152708606.038636*cos(theta)**3 + 467475.324608068*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl44_m_minus_2(theta, phi):
    return 0.00190177585981601*(1.0 - cos(theta)**2)*(2.82296765488739e+15*cos(theta)**42 - 2.79376454121614e+16*cos(theta)**40 + 1.28184490714623e+17*cos(theta)**38 - 3.61902397479438e+17*cos(theta)**36 + 7.03699106210018e+17*cos(theta)**34 - 9.99430882490684e+17*cos(theta)**32 + 1.07298207297701e+18*cos(theta)**30 - 8.89042289038095e+17*cos(theta)**28 + 5.75441755576027e+17*cos(theta)**26 - 2.9267381934618e+17*cos(theta)**24 + 1.17069527738472e+17*cos(theta)**22 - 3.66934340672822e+16*cos(theta)**20 + 8.93814419587644e+15*cos(theta)**18 - 1.66976320142747e+15*cos(theta)**16 + 234627147741564.0*cos(theta)**14 - 24125503327098.7*cos(theta)**12 + 1745924582882.14*cos(theta)**10 - 84028455860.6379*cos(theta)**8 + 2466243987.52396*cos(theta)**6 - 38177151.5096589*cos(theta)**4 + 233737.662304034*cos(theta)**2 - 236.81627386427)*sin(2*phi)

@torch.jit.script
def Yl44_m_minus_1(theta, phi):
    return 0.0845809334938809*(1.0 - cos(theta)**2)**0.5*(65650410578776.6*cos(theta)**43 - 681405985662474.0*cos(theta)**41 + 3.28678181319546e+15*cos(theta)**39 - 9.78114587782264e+15*cos(theta)**37 + 2.01056887488577e+16*cos(theta)**35 - 3.02857843178995e+16*cos(theta)**33 + 3.46123249347423e+16*cos(theta)**31 - 3.0656630656486e+16*cos(theta)**29 + 2.13126576139269e+16*cos(theta)**27 - 1.17069527738472e+16*cos(theta)**25 + 5.08997946689008e+15*cos(theta)**23 - 1.7473063841563e+15*cos(theta)**21 + 470428641888234.0*cos(theta)**19 - 98221364789851.0*cos(theta)**17 + 15641809849437.6*cos(theta)**15 - 1855807948238.36*cos(theta)**13 + 158720416625.649*cos(theta)**11 - 9336495095.62644*cos(theta)**9 + 352320569.646281*cos(theta)**7 - 7635430.30193178*cos(theta)**5 + 77912.5541013447*cos(theta)**3 - 236.81627386427*cos(theta))*sin(phi)

@torch.jit.script
def Yl44_m0(theta, phi):
    return 3970770999427.6*cos(theta)**44 - 43176429488028.9*cos(theta)**42 + 218675916407017.0*cos(theta)**40 - 685008894768969.0*cos(theta)**38 + 1.48630016364995e+15*cos(theta)**36 - 2.37055469139106e+15*cos(theta)**34 + 2.87853069668915e+15*cos(theta)**32 - 2.71952614391965e+15*cos(theta)**30 + 2.02567443939221e+15*cos(theta)**28 - 1.19828628809117e+15*cos(theta)**26 + 564410208158882.0*cos(theta)**24 - 211366645117845.0*cos(theta)**22 + 62597044900284.8*cos(theta)**20 - 14521902968320.0*cos(theta)**18 + 2601699243738.83*cos(theta)**16 - 352772778812.045*cos(theta)**14 + 35199915429.7107*cos(theta)**12 - 2484699912.68546*cos(theta)**10 + 117202826.070069*cos(theta)**8 - 3386665.76879456*cos(theta)**6 + 51836.7209509371*cos(theta)**4 - 315.116844686548*cos(theta)**2 + 0.318299843117725

@torch.jit.script
def Yl44_m1(theta, phi):
    return 0.0845809334938809*(1.0 - cos(theta)**2)**0.5*(65650410578776.6*cos(theta)**43 - 681405985662474.0*cos(theta)**41 + 3.28678181319546e+15*cos(theta)**39 - 9.78114587782264e+15*cos(theta)**37 + 2.01056887488577e+16*cos(theta)**35 - 3.02857843178995e+16*cos(theta)**33 + 3.46123249347423e+16*cos(theta)**31 - 3.0656630656486e+16*cos(theta)**29 + 2.13126576139269e+16*cos(theta)**27 - 1.17069527738472e+16*cos(theta)**25 + 5.08997946689008e+15*cos(theta)**23 - 1.7473063841563e+15*cos(theta)**21 + 470428641888234.0*cos(theta)**19 - 98221364789851.0*cos(theta)**17 + 15641809849437.6*cos(theta)**15 - 1855807948238.36*cos(theta)**13 + 158720416625.649*cos(theta)**11 - 9336495095.62644*cos(theta)**9 + 352320569.646281*cos(theta)**7 - 7635430.30193178*cos(theta)**5 + 77912.5541013447*cos(theta)**3 - 236.81627386427*cos(theta))*cos(phi)

@torch.jit.script
def Yl44_m2(theta, phi):
    return 0.00190177585981601*(1.0 - cos(theta)**2)*(2.82296765488739e+15*cos(theta)**42 - 2.79376454121614e+16*cos(theta)**40 + 1.28184490714623e+17*cos(theta)**38 - 3.61902397479438e+17*cos(theta)**36 + 7.03699106210018e+17*cos(theta)**34 - 9.99430882490684e+17*cos(theta)**32 + 1.07298207297701e+18*cos(theta)**30 - 8.89042289038095e+17*cos(theta)**28 + 5.75441755576027e+17*cos(theta)**26 - 2.9267381934618e+17*cos(theta)**24 + 1.17069527738472e+17*cos(theta)**22 - 3.66934340672822e+16*cos(theta)**20 + 8.93814419587644e+15*cos(theta)**18 - 1.66976320142747e+15*cos(theta)**16 + 234627147741564.0*cos(theta)**14 - 24125503327098.7*cos(theta)**12 + 1745924582882.14*cos(theta)**10 - 84028455860.6379*cos(theta)**8 + 2466243987.52396*cos(theta)**6 - 38177151.5096589*cos(theta)**4 + 233737.662304034*cos(theta)**2 - 236.81627386427)*cos(2*phi)

@torch.jit.script
def Yl44_m3(theta, phi):
    return 4.28041380657482e-5*(1.0 - cos(theta)**2)**1.5*(1.1856464150527e+17*cos(theta)**41 - 1.11750581648646e+18*cos(theta)**39 + 4.87101064715568e+18*cos(theta)**37 - 1.30284863092598e+19*cos(theta)**35 + 2.39257696111406e+19*cos(theta)**33 - 3.19817882397019e+19*cos(theta)**31 + 3.21894621893103e+19*cos(theta)**29 - 2.48931840930666e+19*cos(theta)**27 + 1.49614856449767e+19*cos(theta)**25 - 7.02417166430831e+18*cos(theta)**23 + 2.57552961024638e+18*cos(theta)**21 - 7.33868681345644e+17*cos(theta)**19 + 1.60886595525776e+17*cos(theta)**17 - 2.67162112228395e+16*cos(theta)**15 + 3.2847800683819e+15*cos(theta)**13 - 289506039925185.0*cos(theta)**11 + 17459245828821.4*cos(theta)**9 - 672227646885.103*cos(theta)**7 + 14797463925.1438*cos(theta)**5 - 152708606.038636*cos(theta)**3 + 467475.324608068*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl44_m4(theta, phi):
    return 9.64879788299937e-7*(1.0 - cos(theta)**2)**2*(4.86115030171609e+18*cos(theta)**40 - 4.35827268429718e+19*cos(theta)**38 + 1.8022739394476e+20*cos(theta)**36 - 4.55997020824091e+20*cos(theta)**34 + 7.8955039716764e+20*cos(theta)**32 - 9.91435435430758e+20*cos(theta)**30 + 9.33494403489999e+20*cos(theta)**28 - 6.721159705128e+20*cos(theta)**26 + 3.74037141124418e+20*cos(theta)**24 - 1.61555948279091e+20*cos(theta)**22 + 5.4086121815174e+19*cos(theta)**20 - 1.39435049455672e+19*cos(theta)**18 + 2.73507212393819e+18*cos(theta)**16 - 4.00743168342592e+17*cos(theta)**14 + 4.27021408889647e+16*cos(theta)**12 - 3.18456643917703e+15*cos(theta)**10 + 157133212459393.0*cos(theta)**8 - 4705593528195.72*cos(theta)**6 + 73987319625.7189*cos(theta)**4 - 458125818.115907*cos(theta)**2 + 467475.324608068)*cos(4*phi)

@torch.jit.script
def Yl44_m5(theta, phi):
    return 2.17944128520635e-8*(1.0 - cos(theta)**2)**2.5*(1.94446012068644e+20*cos(theta)**39 - 1.65614362003293e+21*cos(theta)**37 + 6.48818618201136e+21*cos(theta)**35 - 1.55038987080191e+22*cos(theta)**33 + 2.52656127093645e+22*cos(theta)**31 - 2.97430630629227e+22*cos(theta)**29 + 2.613784329772e+22*cos(theta)**27 - 1.74750152333328e+22*cos(theta)**25 + 8.97689138698602e+21*cos(theta)**23 - 3.55423086214001e+21*cos(theta)**21 + 1.08172243630348e+21*cos(theta)**19 - 2.5098308902021e+20*cos(theta)**17 + 4.3761153983011e+19*cos(theta)**15 - 5.61040435679629e+18*cos(theta)**13 + 5.12425690667577e+17*cos(theta)**11 - 3.18456643917703e+16*cos(theta)**9 + 1.25706569967514e+15*cos(theta)**7 - 28233561169174.3*cos(theta)**5 + 295949278502.876*cos(theta)**3 - 916251636.231813*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl44_m6(theta, phi):
    return 4.93546262901146e-10*(1.0 - cos(theta)**2)**3*(7.5833944706771e+21*cos(theta)**38 - 6.12773139412184e+22*cos(theta)**36 + 2.27086516370398e+23*cos(theta)**34 - 5.11628657364631e+23*cos(theta)**32 + 7.83233993990299e+23*cos(theta)**30 - 8.62548828824759e+23*cos(theta)**28 + 7.0572176903844e+23*cos(theta)**26 - 4.3687538083332e+23*cos(theta)**24 + 2.06468501900678e+23*cos(theta)**22 - 7.46388481049401e+22*cos(theta)**20 + 2.05527262897661e+22*cos(theta)**18 - 4.26671251334358e+21*cos(theta)**16 + 6.56417309745166e+20*cos(theta)**14 - 7.29352566383517e+19*cos(theta)**12 + 5.63668259734334e+18*cos(theta)**10 - 2.86610979525933e+17*cos(theta)**8 + 8.799459897726e+15*cos(theta)**6 - 141167805845872.0*cos(theta)**4 + 887847835508.627*cos(theta)**2 - 916251636.231813)*cos(6*phi)

@torch.jit.script
def Yl44_m7(theta, phi):
    return 1.12111711211166e-11*(1.0 - cos(theta)**2)**3.5*(2.8816898988573e+23*cos(theta)**37 - 2.20598330188386e+24*cos(theta)**35 + 7.72094155659352e+24*cos(theta)**33 - 1.63721170356682e+25*cos(theta)**31 + 2.3497019819709e+25*cos(theta)**29 - 2.41513672070933e+25*cos(theta)**27 + 1.83487659949994e+25*cos(theta)**25 - 1.04850091399997e+25*cos(theta)**23 + 4.54230704181493e+24*cos(theta)**21 - 1.4927769620988e+24*cos(theta)**19 + 3.6994907321579e+23*cos(theta)**17 - 6.82674002134972e+22*cos(theta)**15 + 9.18984233643232e+21*cos(theta)**13 - 8.75223079660221e+20*cos(theta)**11 + 5.63668259734334e+19*cos(theta)**9 - 2.29288783620746e+18*cos(theta)**7 + 5.2796759386356e+16*cos(theta)**5 - 564671223383487.0*cos(theta)**3 + 1775695671017.25*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl44_m8(theta, phi):
    return 2.55592701088609e-13*(1.0 - cos(theta)**2)**4*(1.0662252625772e+25*cos(theta)**36 - 7.72094155659352e+25*cos(theta)**34 + 2.54791071367586e+26*cos(theta)**32 - 5.07535628105714e+26*cos(theta)**30 + 6.8141357477156e+26*cos(theta)**28 - 6.52086914591518e+26*cos(theta)**26 + 4.58719149874986e+26*cos(theta)**24 - 2.41155210219992e+26*cos(theta)**22 + 9.53884478781135e+25*cos(theta)**20 - 2.83627622798772e+25*cos(theta)**18 + 6.28913424466843e+24*cos(theta)**16 - 1.02401100320246e+24*cos(theta)**14 + 1.1946795037362e+23*cos(theta)**12 - 9.62745387626243e+21*cos(theta)**10 + 5.07301433760901e+20*cos(theta)**8 - 1.60502148534522e+19*cos(theta)**6 + 2.6398379693178e+17*cos(theta)**4 - 1.69401367015046e+15*cos(theta)**2 + 1775695671017.25)*cos(8*phi)

@torch.jit.script
def Yl44_m9(theta, phi):
    return 5.85139292711667e-15*(1.0 - cos(theta)**2)**4.5*(3.83841094527792e+26*cos(theta)**35 - 2.6251201292418e+27*cos(theta)**33 + 8.15331428376276e+27*cos(theta)**31 - 1.52260688431714e+28*cos(theta)**29 + 1.90795800936037e+28*cos(theta)**27 - 1.69542597793795e+28*cos(theta)**25 + 1.10092595969997e+28*cos(theta)**23 - 5.30541462483984e+27*cos(theta)**21 + 1.90776895756227e+27*cos(theta)**19 - 5.1052972103779e+26*cos(theta)**17 + 1.00626147914695e+26*cos(theta)**15 - 1.43361540448344e+25*cos(theta)**13 + 1.43361540448344e+24*cos(theta)**11 - 9.62745387626243e+22*cos(theta)**9 + 4.05841147008721e+21*cos(theta)**7 - 9.63012891207134e+19*cos(theta)**5 + 1.05593518772712e+18*cos(theta)**3 - 3.38802734030092e+15*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl44_m10(theta, phi):
    return 1.34594824439422e-16*(1.0 - cos(theta)**2)**5*(1.34344383084727e+28*cos(theta)**34 - 8.66289642649793e+28*cos(theta)**32 + 2.52752742796645e+29*cos(theta)**30 - 4.41555996451971e+29*cos(theta)**28 + 5.15148662527299e+29*cos(theta)**26 - 4.23856494484487e+29*cos(theta)**24 + 2.53212970730992e+29*cos(theta)**22 - 1.11413707121637e+29*cos(theta)**20 + 3.62476101936831e+28*cos(theta)**18 - 8.67900525764244e+27*cos(theta)**16 + 1.50939221872042e+27*cos(theta)**14 - 1.86370002582847e+26*cos(theta)**12 + 1.57697694493179e+25*cos(theta)**10 - 8.66470848863619e+23*cos(theta)**8 + 2.84088802906104e+22*cos(theta)**6 - 4.81506445603567e+20*cos(theta)**4 + 3.16780556318136e+18*cos(theta)**2 - 3.38802734030092e+15)*cos(10*phi)

@torch.jit.script
def Yl44_m11(theta, phi):
    return 3.11248707798609e-18*(1.0 - cos(theta)**2)**5.5*(4.56770902488073e+29*cos(theta)**33 - 2.77212685647934e+30*cos(theta)**31 + 7.58258228389936e+30*cos(theta)**29 - 1.23635679006552e+31*cos(theta)**27 + 1.33938652257098e+31*cos(theta)**25 - 1.01725558676277e+31*cos(theta)**23 + 5.57068535608183e+30*cos(theta)**21 - 2.22827414243273e+30*cos(theta)**19 + 6.52456983486296e+29*cos(theta)**17 - 1.38864084122279e+29*cos(theta)**15 + 2.11314910620859e+28*cos(theta)**13 - 2.23644003099417e+27*cos(theta)**11 + 1.57697694493179e+26*cos(theta)**9 - 6.93176679090895e+24*cos(theta)**7 + 1.70453281743663e+23*cos(theta)**5 - 1.92602578241427e+21*cos(theta)**3 + 6.33561112636272e+18*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl44_m12(theta, phi):
    return 7.24030020283832e-20*(1.0 - cos(theta)**2)**6*(1.50734397821064e+31*cos(theta)**32 - 8.59359325508594e+31*cos(theta)**30 + 2.19894886233082e+32*cos(theta)**28 - 3.3381633331769e+32*cos(theta)**26 + 3.34846630642745e+32*cos(theta)**24 - 2.33968784955437e+32*cos(theta)**22 + 1.16984392477718e+32*cos(theta)**20 - 4.23372087062219e+31*cos(theta)**18 + 1.1091768719267e+31*cos(theta)**16 - 2.08296126183418e+30*cos(theta)**14 + 2.74709383807117e+29*cos(theta)**12 - 2.46008403409359e+28*cos(theta)**10 + 1.41927925043861e+27*cos(theta)**8 - 4.85223675363626e+25*cos(theta)**6 + 8.52266408718313e+23*cos(theta)**4 - 5.7780773472428e+21*cos(theta)**2 + 6.33561112636272e+18)*cos(12*phi)

@torch.jit.script
def Yl44_m13(theta, phi):
    return 1.69529061039261e-21*(1.0 - cos(theta)**2)**6.5*(4.82350073027405e+32*cos(theta)**31 - 2.57807797652578e+33*cos(theta)**29 + 6.15705681452628e+33*cos(theta)**27 - 8.67922466625994e+33*cos(theta)**25 + 8.03631913542587e+33*cos(theta)**23 - 5.14731326901961e+33*cos(theta)**21 + 2.33968784955437e+33*cos(theta)**19 - 7.62069756711994e+32*cos(theta)**17 + 1.77468299508273e+32*cos(theta)**15 - 2.91614576656786e+31*cos(theta)**13 + 3.29651260568541e+30*cos(theta)**11 - 2.46008403409359e+29*cos(theta)**9 + 1.13542340035089e+28*cos(theta)**7 - 2.91134205218176e+26*cos(theta)**5 + 3.40906563487325e+24*cos(theta)**3 - 1.15561546944856e+22*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl44_m14(theta, phi):
    return 3.99806005076855e-23*(1.0 - cos(theta)**2)**7*(1.49528522638495e+34*cos(theta)**30 - 7.47642613192477e+34*cos(theta)**28 + 1.6624053399221e+35*cos(theta)**26 - 2.16980616656498e+35*cos(theta)**24 + 1.84835340114795e+35*cos(theta)**22 - 1.08093578649412e+35*cos(theta)**20 + 4.4454069141533e+34*cos(theta)**18 - 1.29551858641039e+34*cos(theta)**16 + 2.66202449262409e+33*cos(theta)**14 - 3.79098949653822e+32*cos(theta)**12 + 3.62616386625395e+31*cos(theta)**10 - 2.21407563068423e+30*cos(theta)**8 + 7.9479638024562e+28*cos(theta)**6 - 1.45567102609088e+27*cos(theta)**4 + 1.02271969046198e+25*cos(theta)**2 - 1.15561546944856e+22)*cos(14*phi)

@torch.jit.script
def Yl44_m15(theta, phi):
    return 9.50304267942416e-25*(1.0 - cos(theta)**2)**7.5*(4.48585567915486e+35*cos(theta)**29 - 2.09339931693894e+36*cos(theta)**27 + 4.32225388379745e+36*cos(theta)**25 - 5.20753479975596e+36*cos(theta)**23 + 4.06637748252549e+36*cos(theta)**21 - 2.16187157298824e+36*cos(theta)**19 + 8.00173244547594e+35*cos(theta)**17 - 2.07282973825662e+35*cos(theta)**15 + 3.72683428967372e+34*cos(theta)**13 - 4.54918739584586e+33*cos(theta)**11 + 3.62616386625395e+32*cos(theta)**9 - 1.77126050454738e+31*cos(theta)**7 + 4.76877828147372e+29*cos(theta)**5 - 5.82268410436352e+27*cos(theta)**3 + 2.04543938092395e+25*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl44_m16(theta, phi):
    return 2.27818010861661e-26*(1.0 - cos(theta)**2)**8*(1.30089814695491e+37*cos(theta)**28 - 5.65217815573513e+37*cos(theta)**26 + 1.08056347094936e+38*cos(theta)**24 - 1.19773300394387e+38*cos(theta)**22 + 8.53939271330353e+37*cos(theta)**20 - 4.10755598867765e+37*cos(theta)**18 + 1.36029451573091e+37*cos(theta)**16 - 3.10924460738494e+36*cos(theta)**14 + 4.84488457657584e+35*cos(theta)**12 - 5.00410613543045e+34*cos(theta)**10 + 3.26354747962855e+33*cos(theta)**8 - 1.23988235318317e+32*cos(theta)**6 + 2.38438914073686e+30*cos(theta)**4 - 1.74680523130906e+28*cos(theta)**2 + 2.04543938092395e+25)*cos(16*phi)

@torch.jit.script
def Yl44_m17(theta, phi):
    return 5.51244313501043e-28*(1.0 - cos(theta)**2)**8.5*(3.64251481147375e+38*cos(theta)**27 - 1.46956632049113e+39*cos(theta)**25 + 2.59335233027847e+39*cos(theta)**23 - 2.63501260867652e+39*cos(theta)**21 + 1.70787854266071e+39*cos(theta)**19 - 7.39360077961976e+38*cos(theta)**17 + 2.17647122516945e+38*cos(theta)**15 - 4.35294245033891e+37*cos(theta)**13 + 5.81386149189101e+36*cos(theta)**11 - 5.00410613543045e+35*cos(theta)**9 + 2.61083798370284e+34*cos(theta)**7 - 7.439294119099e+32*cos(theta)**5 + 9.53755656294744e+30*cos(theta)**3 - 3.49361046261811e+28*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl44_m18(theta, phi):
    return 1.34730647078091e-29*(1.0 - cos(theta)**2)**9*(9.83478999097912e+39*cos(theta)**26 - 3.67391580122783e+40*cos(theta)**24 + 5.96471035964048e+40*cos(theta)**22 - 5.53352647822069e+40*cos(theta)**20 + 3.24496923105534e+40*cos(theta)**18 - 1.25691213253536e+40*cos(theta)**16 + 3.26470683775418e+39*cos(theta)**14 - 5.65882518544058e+38*cos(theta)**12 + 6.39524764108011e+37*cos(theta)**10 - 4.5036955218874e+36*cos(theta)**8 + 1.82758658859199e+35*cos(theta)**6 - 3.7196470595495e+33*cos(theta)**4 + 2.86126696888423e+31*cos(theta)**2 - 3.49361046261811e+28)*cos(18*phi)

@torch.jit.script
def Yl44_m19(theta, phi):
    return 3.32896666933142e-31*(1.0 - cos(theta)**2)**9.5*(2.55704539765457e+41*cos(theta)**25 - 8.8173979229468e+41*cos(theta)**23 + 1.31223627912091e+42*cos(theta)**21 - 1.10670529564414e+42*cos(theta)**19 + 5.84094461589961e+41*cos(theta)**17 - 2.01105941205658e+41*cos(theta)**15 + 4.57058957285585e+40*cos(theta)**13 - 6.7905902225287e+39*cos(theta)**11 + 6.39524764108011e+38*cos(theta)**9 - 3.60295641750992e+37*cos(theta)**7 + 1.09655195315519e+36*cos(theta)**5 - 1.4878588238198e+34*cos(theta)**3 + 5.72253393776847e+31*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl44_m20(theta, phi):
    return 8.32241667332855e-33*(1.0 - cos(theta)**2)**10*(6.39261349413643e+42*cos(theta)**24 - 2.02800152227776e+43*cos(theta)**22 + 2.7556961861539e+43*cos(theta)**20 - 2.10274006172386e+43*cos(theta)**18 + 9.92960584702934e+42*cos(theta)**16 - 3.01658911808486e+42*cos(theta)**14 + 5.94176644471261e+41*cos(theta)**12 - 7.46964924478157e+40*cos(theta)**10 + 5.7557228769721e+39*cos(theta)**8 - 2.52206949225694e+38*cos(theta)**6 + 5.48275976577597e+36*cos(theta)**4 - 4.4635764714594e+34*cos(theta)**2 + 5.72253393776847e+31)*cos(20*phi)

@torch.jit.script
def Yl44_m21(theta, phi):
    return 2.10710974858833e-34*(1.0 - cos(theta)**2)**10.5*(1.53422723859274e+44*cos(theta)**23 - 4.46160334901108e+44*cos(theta)**21 + 5.5113923723078e+44*cos(theta)**19 - 3.78493211110295e+44*cos(theta)**17 + 1.5887369355247e+44*cos(theta)**15 - 4.22322476531881e+43*cos(theta)**13 + 7.13011973365513e+42*cos(theta)**11 - 7.46964924478157e+41*cos(theta)**9 + 4.60457830157768e+40*cos(theta)**7 - 1.51324169535417e+39*cos(theta)**5 + 2.19310390631039e+37*cos(theta)**3 - 8.92715294291881e+34*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl44_m22(theta, phi):
    return 5.40818165421429e-36*(1.0 - cos(theta)**2)**11*(3.52872264876331e+45*cos(theta)**22 - 9.36936703292327e+45*cos(theta)**20 + 1.04716455073848e+46*cos(theta)**18 - 6.43438458887501e+45*cos(theta)**16 + 2.38310540328704e+45*cos(theta)**14 - 5.49019219491445e+44*cos(theta)**12 + 7.84313170702065e+43*cos(theta)**10 - 6.72268432030341e+42*cos(theta)**8 + 3.22320481110438e+41*cos(theta)**6 - 7.56620847677083e+39*cos(theta)**4 + 6.57931171893116e+37*cos(theta)**2 - 8.92715294291881e+34)*cos(22*phi)

@torch.jit.script
def Yl44_m23(theta, phi):
    return 1.40864814870526e-37*(1.0 - cos(theta)**2)**11.5*(7.76318982727928e+46*cos(theta)**21 - 1.87387340658465e+47*cos(theta)**19 + 1.88489619132927e+47*cos(theta)**17 - 1.02950153422e+47*cos(theta)**15 + 3.33634756460186e+46*cos(theta)**13 - 6.58823063389734e+45*cos(theta)**11 + 7.84313170702065e+44*cos(theta)**9 - 5.37814745624273e+43*cos(theta)**7 + 1.93392288666262e+42*cos(theta)**5 - 3.02648339070833e+40*cos(theta)**3 + 1.31586234378623e+38*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl44_m24(theta, phi):
    return 3.72767829649342e-39*(1.0 - cos(theta)**2)**12*(1.63026986372865e+48*cos(theta)**20 - 3.56035947251084e+48*cos(theta)**18 + 3.20432352525976e+48*cos(theta)**16 - 1.54425230133e+48*cos(theta)**14 + 4.33725183398242e+47*cos(theta)**12 - 7.24705369728708e+46*cos(theta)**10 + 7.05881853631858e+45*cos(theta)**8 - 3.76470321936991e+44*cos(theta)**6 + 9.66961443331313e+42*cos(theta)**4 - 9.079450172125e+40*cos(theta)**2 + 1.31586234378623e+38)*cos(24*phi)

@torch.jit.script
def Yl44_m25(theta, phi):
    return 1.00345726576353e-40*(1.0 - cos(theta)**2)**12.5*(3.2605397274573e+49*cos(theta)**19 - 6.40864705051951e+49*cos(theta)**17 + 5.12691764041561e+49*cos(theta)**15 - 2.161953221862e+49*cos(theta)**13 + 5.2047022007789e+48*cos(theta)**11 - 7.24705369728708e+47*cos(theta)**9 + 5.64705482905487e+46*cos(theta)**7 - 2.25882193162195e+45*cos(theta)**5 + 3.86784577332525e+43*cos(theta)**3 - 1.815890034425e+41*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl44_m26(theta, phi):
    return 2.75152245514281e-42*(1.0 - cos(theta)**2)**13*(6.19502548216886e+50*cos(theta)**18 - 1.08946999858832e+51*cos(theta)**16 + 7.69037646062342e+50*cos(theta)**14 - 2.81053918842061e+50*cos(theta)**12 + 5.72517242085679e+49*cos(theta)**10 - 6.52234832755837e+48*cos(theta)**8 + 3.95293838033841e+47*cos(theta)**6 - 1.12941096581097e+46*cos(theta)**4 + 1.16035373199758e+44*cos(theta)**2 - 1.815890034425e+41)*cos(26*phi)

@torch.jit.script
def Yl44_m27(theta, phi):
    return 7.69675450430194e-44*(1.0 - cos(theta)**2)**13.5*(1.1151045867904e+52*cos(theta)**17 - 1.74315199774131e+52*cos(theta)**15 + 1.07665270448728e+52*cos(theta)**13 - 3.37264702610473e+51*cos(theta)**11 + 5.72517242085679e+50*cos(theta)**9 - 5.2178786620467e+49*cos(theta)**7 + 2.37176302820304e+48*cos(theta)**5 - 4.51764386324389e+46*cos(theta)**3 + 2.32070746399515e+44*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl44_m28(theta, phi):
    return 2.19997084612836e-45*(1.0 - cos(theta)**2)**14*(1.89567779754367e+53*cos(theta)**16 - 2.61472799661196e+53*cos(theta)**14 + 1.39964851583346e+53*cos(theta)**12 - 3.7099117287152e+52*cos(theta)**10 + 5.15265517877111e+51*cos(theta)**8 - 3.65251506343269e+50*cos(theta)**6 + 1.18588151410152e+49*cos(theta)**4 - 1.35529315897317e+47*cos(theta)**2 + 2.32070746399515e+44)*cos(28*phi)

@torch.jit.script
def Yl44_m29(theta, phi):
    return 6.43717779072263e-47*(1.0 - cos(theta)**2)**14.5*(3.03308447606988e+54*cos(theta)**15 - 3.66061919525675e+54*cos(theta)**13 + 1.67957821900015e+54*cos(theta)**11 - 3.7099117287152e+53*cos(theta)**9 + 4.12212414301689e+52*cos(theta)**7 - 2.19150903805961e+51*cos(theta)**5 + 4.74352605640609e+49*cos(theta)**3 - 2.71058631794634e+47*cos(theta))*cos(29*phi)

@torch.jit.script
def Yl44_m30(theta, phi):
    return 1.93211963867191e-48*(1.0 - cos(theta)**2)**15*(4.54962671410481e+55*cos(theta)**14 - 4.75880495383377e+55*cos(theta)**12 + 1.84753604090017e+55*cos(theta)**10 - 3.33892055584368e+54*cos(theta)**8 + 2.88548690011182e+53*cos(theta)**6 - 1.09575451902981e+52*cos(theta)**4 + 1.42305781692183e+50*cos(theta)**2 - 2.71058631794634e+47)*cos(30*phi)

@torch.jit.script
def Yl44_m31(theta, phi):
    return 5.96265065549245e-50*(1.0 - cos(theta)**2)**15.5*(6.36947739974674e+56*cos(theta)**13 - 5.71056594460052e+56*cos(theta)**11 + 1.84753604090017e+56*cos(theta)**9 - 2.67113644467494e+55*cos(theta)**7 + 1.73129214006709e+54*cos(theta)**5 - 4.38301807611922e+52*cos(theta)**3 + 2.84611563384365e+50*cos(theta))*cos(31*phi)

@torch.jit.script
def Yl44_m32(theta, phi):
    return 1.89697187951869e-51*(1.0 - cos(theta)**2)**16*(8.28032061967076e+57*cos(theta)**12 - 6.28162253906058e+57*cos(theta)**10 + 1.66278243681015e+57*cos(theta)**8 - 1.86979551127246e+56*cos(theta)**6 + 8.65646070033547e+54*cos(theta)**4 - 1.31490542283577e+53*cos(theta)**2 + 2.84611563384365e+50)*cos(32*phi)

@torch.jit.script
def Yl44_m33(theta, phi):
    return 6.24057931710171e-53*(1.0 - cos(theta)**2)**16.5*(9.93638474360491e+58*cos(theta)**11 - 6.28162253906058e+58*cos(theta)**9 + 1.33022594944812e+58*cos(theta)**7 - 1.12187730676348e+57*cos(theta)**5 + 3.46258428013419e+55*cos(theta)**3 - 2.62981084567153e+53*cos(theta))*cos(33*phi)

@torch.jit.script
def Yl44_m34(theta, phi):
    return 2.13049865063417e-54*(1.0 - cos(theta)**2)**17*(1.09300232179654e+60*cos(theta)**10 - 5.65346028515452e+59*cos(theta)**8 + 9.31158164613686e+58*cos(theta)**6 - 5.60938653381738e+57*cos(theta)**4 + 1.03877528404026e+56*cos(theta)**2 - 2.62981084567153e+53)*cos(34*phi)

@torch.jit.script
def Yl44_m35(theta, phi):
    return 7.57997403251458e-56*(1.0 - cos(theta)**2)**17.5*(1.09300232179654e+61*cos(theta)**9 - 4.52276822812362e+60*cos(theta)**7 + 5.58694898768211e+59*cos(theta)**5 - 2.24375461352695e+58*cos(theta)**3 + 2.07755056808051e+56*cos(theta))*cos(35*phi)

@torch.jit.script
def Yl44_m36(theta, phi):
    return 2.8248895340643e-57*(1.0 - cos(theta)**2)**18*(9.83702089616886e+61*cos(theta)**8 - 3.16593775968653e+61*cos(theta)**6 + 2.79347449384106e+60*cos(theta)**4 - 6.73126384058086e+58*cos(theta)**2 + 2.07755056808051e+56)*cos(36*phi)

@torch.jit.script
def Yl44_m37(theta, phi):
    return 1.10972141424432e-58*(1.0 - cos(theta)**2)**18.5*(7.86961671693509e+62*cos(theta)**7 - 1.89956265581192e+62*cos(theta)**5 + 1.11738979753642e+61*cos(theta)**3 - 1.34625276811617e+59*cos(theta))*cos(37*phi)

@torch.jit.script
def Yl44_m38(theta, phi):
    return 4.63188769029189e-60*(1.0 - cos(theta)**2)**19*(5.50873170185456e+63*cos(theta)**6 - 9.49781327905959e+62*cos(theta)**4 + 3.35216939260927e+61*cos(theta)**2 - 1.34625276811617e+59)*cos(38*phi)

@torch.jit.script
def Yl44_m39(theta, phi):
    return 2.07559850445656e-61*(1.0 - cos(theta)**2)**19.5*(3.30523902111274e+64*cos(theta)**5 - 3.79912531162384e+63*cos(theta)**3 + 6.70433878521854e+61*cos(theta))*cos(39*phi)

@torch.jit.script
def Yl44_m40(theta, phi):
    return 1.01278836595551e-62*(1.0 - cos(theta)**2)**20*(1.65261951055637e+65*cos(theta)**4 - 1.13973759348715e+64*cos(theta)**2 + 6.70433878521854e+61)*cos(40*phi)

@torch.jit.script
def Yl44_m41(theta, phi):
    return 5.49261609750345e-64*(1.0 - cos(theta)**2)**20.5*(6.61047804222548e+65*cos(theta)**3 - 2.2794751869743e+64*cos(theta))*cos(41*phi)

@torch.jit.script
def Yl44_m42(theta, phi):
    return 3.4195534181066e-65*(1.0 - cos(theta)**2)**21*(1.98314341266764e+66*cos(theta)**2 - 2.2794751869743e+64)*cos(42*phi)

@torch.jit.script
def Yl44_m43(theta, phi):
    return 10.2820304486063*(1.0 - cos(theta)**2)**21.5*cos(43*phi)*cos(theta)

@torch.jit.script
def Yl44_m44(theta, phi):
    return 1.09606812861653*(1.0 - cos(theta)**2)**22*cos(44*phi)

@torch.jit.script
def Yl45_m_minus_45(theta, phi):
    return 1.10214057468876*(1.0 - cos(theta)**2)**22.5*sin(45*phi)

@torch.jit.script
def Yl45_m_minus_44(theta, phi):
    return 10.4558235531102*(1.0 - cos(theta)**2)**22*sin(44*phi)*cos(theta)

@torch.jit.script
def Yl45_m_minus_43(theta, phi):
    return 3.95179241074826e-67*(1.0 - cos(theta)**2)**21.5*(1.7649976372742e+68*cos(theta)**2 - 1.98314341266764e+66)*sin(43*phi)

@torch.jit.script
def Yl45_m_minus_42(theta, phi):
    return 6.42090266241355e-66*(1.0 - cos(theta)**2)**21*(5.88332545758067e+67*cos(theta)**3 - 1.98314341266764e+66*cos(theta))*sin(42*phi)

@torch.jit.script
def Yl45_m_minus_41(theta, phi):
    return 1.19780385990637e-64*(1.0 - cos(theta)**2)**20.5*(1.47083136439517e+67*cos(theta)**4 - 9.91571706333822e+65*cos(theta)**2 + 5.69868796743576e+63)*sin(41*phi)

@torch.jit.script
def Yl45_m_minus_40(theta, phi):
    return 2.4838189493738e-63*(1.0 - cos(theta)**2)**20*(2.94166272879034e+66*cos(theta)**5 - 3.30523902111274e+65*cos(theta)**3 + 5.69868796743576e+63*cos(theta))*sin(40*phi)

@torch.jit.script
def Yl45_m_minus_39(theta, phi):
    return 5.60925293810759e-62*(1.0 - cos(theta)**2)**19.5*(4.90277121465056e+65*cos(theta)**6 - 8.26309755278185e+64*cos(theta)**4 + 2.84934398371788e+63*cos(theta)**2 - 1.11738979753642e+61)*sin(39*phi)

@torch.jit.script
def Yl45_m_minus_38(theta, phi):
    return 1.36017155138303e-60*(1.0 - cos(theta)**2)**19*(7.00395887807223e+64*cos(theta)**7 - 1.65261951055637e+64*cos(theta)**5 + 9.49781327905959e+62*cos(theta)**3 - 1.11738979753642e+61*cos(theta))*sin(38*phi)

@torch.jit.script
def Yl45_m_minus_37(theta, phi):
    return 3.50491691066036e-59*(1.0 - cos(theta)**2)**18.5*(8.75494859759029e+63*cos(theta)**8 - 2.75436585092728e+63*cos(theta)**6 + 2.3744533197649e+62*cos(theta)**4 - 5.58694898768211e+60*cos(theta)**2 + 1.68281596014522e+58)*sin(37*phi)

@torch.jit.script
def Yl45_m_minus_36(theta, phi):
    return 9.52151175096011e-58*(1.0 - cos(theta)**2)**18*(9.72772066398921e+62*cos(theta)**9 - 3.93480835846755e+62*cos(theta)**7 + 4.7489066395298e+61*cos(theta)**5 - 1.86231632922737e+60*cos(theta)**3 + 1.68281596014522e+58*cos(theta))*sin(36*phi)

@torch.jit.script
def Yl45_m_minus_35(theta, phi):
    return 2.70986975109827e-56*(1.0 - cos(theta)**2)**17.5*(9.72772066398921e+61*cos(theta)**10 - 4.91851044808443e+61*cos(theta)**8 + 7.91484439921633e+60*cos(theta)**6 - 4.65579082306843e+59*cos(theta)**4 + 8.41407980072608e+57*cos(theta)**2 - 2.07755056808051e+55)*sin(35*phi)

@torch.jit.script
def Yl45_m_minus_34(theta, phi):
    return 8.03877277932851e-55*(1.0 - cos(theta)**2)**17*(8.84338242180837e+60*cos(theta)**11 - 5.4650116089827e+60*cos(theta)**9 + 1.1306920570309e+60*cos(theta)**7 - 9.31158164613686e+58*cos(theta)**5 + 2.80469326690869e+57*cos(theta)**3 - 2.07755056808051e+55*cos(theta))*sin(34*phi)

@torch.jit.script
def Yl45_m_minus_33(theta, phi):
    return 2.47510667794732e-53*(1.0 - cos(theta)**2)**16.5*(7.36948535150698e+59*cos(theta)**12 - 5.4650116089827e+59*cos(theta)**10 + 1.41336507128863e+59*cos(theta)**8 - 1.55193027435614e+58*cos(theta)**6 + 7.01173316727173e+56*cos(theta)**4 - 1.03877528404026e+55*cos(theta)**2 + 2.19150903805961e+52)*sin(33*phi)

@torch.jit.script
def Yl45_m_minus_32(theta, phi):
    return 7.88157294590393e-52*(1.0 - cos(theta)**2)**16*(5.6688348857746e+58*cos(theta)**13 - 4.96819237180246e+58*cos(theta)**11 + 1.57040563476514e+58*cos(theta)**9 - 2.2170432490802e+57*cos(theta)**7 + 1.40234663345435e+56*cos(theta)**5 - 3.46258428013419e+54*cos(theta)**3 + 2.19150903805961e+52*cos(theta))*sin(32*phi)

@torch.jit.script
def Yl45_m_minus_31(theta, phi):
    return 2.5877497770366e-50*(1.0 - cos(theta)**2)**15.5*(4.04916777555328e+57*cos(theta)**14 - 4.14016030983538e+57*cos(theta)**12 + 1.57040563476514e+57*cos(theta)**10 - 2.77130406135025e+56*cos(theta)**8 + 2.33724438909058e+55*cos(theta)**6 - 8.65646070033547e+53*cos(theta)**4 + 1.09575451902981e+52*cos(theta)**2 - 2.03293973845975e+49)*sin(31*phi)

@torch.jit.script
def Yl45_m_minus_30(theta, phi):
    return 8.73724885518915e-49*(1.0 - cos(theta)**2)**15*(2.69944518370219e+56*cos(theta)**15 - 3.18473869987337e+56*cos(theta)**13 + 1.42764148615013e+56*cos(theta)**11 - 3.07922673483362e+55*cos(theta)**9 + 3.33892055584368e+54*cos(theta)**7 - 1.73129214006709e+53*cos(theta)**5 + 3.65251506343269e+51*cos(theta)**3 - 2.03293973845975e+49*cos(theta))*sin(30*phi)

@torch.jit.script
def Yl45_m_minus_29(theta, phi):
    return 3.02667178711212e-47*(1.0 - cos(theta)**2)**14.5*(1.68715323981387e+55*cos(theta)**16 - 2.27481335705241e+55*cos(theta)**14 + 1.18970123845844e+55*cos(theta)**12 - 3.07922673483362e+54*cos(theta)**10 + 4.1736506948046e+53*cos(theta)**8 - 2.88548690011182e+52*cos(theta)**6 + 9.13128765858172e+50*cos(theta)**4 - 1.01646986922988e+49*cos(theta)**2 + 1.69411644871646e+46)*sin(29*phi)

@torch.jit.script
def Yl45_m_minus_28(theta, phi):
    return 1.07350889938001e-45*(1.0 - cos(theta)**2)**14*(9.92443082243452e+53*cos(theta)**17 - 1.51654223803494e+54*cos(theta)**15 + 9.15154798814187e+53*cos(theta)**13 - 2.79929703166692e+53*cos(theta)**11 + 4.637389660894e+52*cos(theta)**9 - 4.12212414301689e+51*cos(theta)**7 + 1.82625753171634e+50*cos(theta)**5 - 3.38823289743292e+48*cos(theta)**3 + 1.69411644871646e+46*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl45_m_minus_27(theta, phi):
    return 3.89137721528147e-44*(1.0 - cos(theta)**2)**13.5*(5.51357267913029e+52*cos(theta)**18 - 9.47838898771836e+52*cos(theta)**16 + 6.5368199915299e+52*cos(theta)**14 - 2.3327475263891e+52*cos(theta)**12 + 4.637389660894e+51*cos(theta)**10 - 5.15265517877111e+50*cos(theta)**8 + 3.04376255286057e+49*cos(theta)**6 - 8.4705822435823e+47*cos(theta)**4 + 8.4705822435823e+45*cos(theta)**2 - 1.28928192444175e+43)*sin(27*phi)

@torch.jit.script
def Yl45_m_minus_26(theta, phi):
    return 1.43928361180293e-42*(1.0 - cos(theta)**2)**13*(2.90188035743699e+51*cos(theta)**19 - 5.57552293395198e+51*cos(theta)**17 + 4.35787999435327e+51*cos(theta)**15 - 1.79442117414546e+51*cos(theta)**13 + 4.21580878263091e+50*cos(theta)**11 - 5.72517242085679e+49*cos(theta)**9 + 4.34823221837225e+48*cos(theta)**7 - 1.69411644871646e+47*cos(theta)**5 + 2.82352741452743e+45*cos(theta)**3 - 1.28928192444175e+43*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl45_m_minus_25(theta, phi):
    return 5.42363622267421e-41*(1.0 - cos(theta)**2)**12.5*(1.4509401787185e+50*cos(theta)**20 - 3.09751274108443e+50*cos(theta)**18 + 2.72367499647079e+50*cos(theta)**16 - 1.2817294101039e+50*cos(theta)**14 + 3.51317398552576e+49*cos(theta)**12 - 5.72517242085679e+48*cos(theta)**10 + 5.43529027296531e+47*cos(theta)**8 - 2.82352741452743e+46*cos(theta)**6 + 7.05881853631858e+44*cos(theta)**4 - 6.44640962220875e+42*cos(theta)**2 + 9.079450172125e+39)*sin(25*phi)

@torch.jit.script
def Yl45_m_minus_24(theta, phi):
    return 2.07945353200254e-39*(1.0 - cos(theta)**2)**12*(6.90923894627856e+48*cos(theta)**21 - 1.63026986372865e+49*cos(theta)**19 + 1.60216176262988e+49*cos(theta)**17 - 8.54486273402602e+48*cos(theta)**15 + 2.70244152732751e+48*cos(theta)**13 - 5.2047022007789e+47*cos(theta)**11 + 6.0392114144059e+46*cos(theta)**9 - 4.03361059218205e+45*cos(theta)**7 + 1.41176370726372e+44*cos(theta)**5 - 2.14880320740292e+42*cos(theta)**3 + 9.079450172125e+39*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl45_m_minus_23(theta, phi):
    return 8.10186692897904e-38*(1.0 - cos(theta)**2)**11.5*(3.14056315739934e+47*cos(theta)**22 - 8.15134931864324e+47*cos(theta)**20 + 8.9008986812771e+47*cos(theta)**18 - 5.34053920876626e+47*cos(theta)**16 + 1.9303153766625e+47*cos(theta)**14 - 4.33725183398242e+46*cos(theta)**12 + 6.0392114144059e+45*cos(theta)**10 - 5.04201324022756e+44*cos(theta)**8 + 2.35293951210619e+43*cos(theta)**6 - 5.37200801850729e+41*cos(theta)**4 + 4.5397250860625e+39*cos(theta)**2 - 5.9811924717556e+36)*sin(23*phi)

@torch.jit.script
def Yl45_m_minus_22(theta, phi):
    return 3.20408095180754e-36*(1.0 - cos(theta)**2)**11*(1.36546224234754e+46*cos(theta)**23 - 3.88159491363964e+46*cos(theta)**21 + 4.68468351646163e+46*cos(theta)**19 - 3.14149365221545e+46*cos(theta)**17 + 1.286876917775e+46*cos(theta)**15 - 3.33634756460186e+45*cos(theta)**13 + 5.49019219491445e+44*cos(theta)**11 - 5.60223693358618e+43*cos(theta)**9 + 3.36134216015171e+42*cos(theta)**7 - 1.07440160370146e+41*cos(theta)**5 + 1.51324169535417e+39*cos(theta)**3 - 5.9811924717556e+36*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl45_m_minus_21(theta, phi):
    return 1.28483246655521e-34*(1.0 - cos(theta)**2)**10.5*(5.68942600978142e+44*cos(theta)**24 - 1.76436132438165e+45*cos(theta)**22 + 2.34234175823082e+45*cos(theta)**20 - 1.7452742512308e+45*cos(theta)**18 + 8.04298073609377e+44*cos(theta)**16 - 2.38310540328704e+44*cos(theta)**14 + 4.57516016242871e+43*cos(theta)**12 - 5.60223693358618e+42*cos(theta)**10 + 4.20167770018963e+41*cos(theta)**8 - 1.79066933950243e+40*cos(theta)**6 + 3.78310423838542e+38*cos(theta)**4 - 2.9905962358778e+36*cos(theta)**2 + 3.7196470595495e+33)*sin(21*phi)

@torch.jit.script
def Yl45_m_minus_20(theta, phi):
    return 5.21901415090882e-33*(1.0 - cos(theta)**2)**10*(2.27577040391257e+43*cos(theta)**25 - 7.67113619296371e+43*cos(theta)**23 + 1.11540083725277e+44*cos(theta)**21 - 9.18565395384634e+43*cos(theta)**19 + 4.73116513887869e+43*cos(theta)**17 - 1.5887369355247e+43*cos(theta)**15 + 3.51935397109901e+42*cos(theta)**13 - 5.09294266689652e+41*cos(theta)**11 + 4.66853077798848e+40*cos(theta)**9 - 2.55809905643204e+39*cos(theta)**7 + 7.56620847677083e+37*cos(theta)**5 - 9.96865411959267e+35*cos(theta)**3 + 3.7196470595495e+33*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl45_m_minus_19(theta, phi):
    return 2.14551634147781e-31*(1.0 - cos(theta)**2)**9.5*(8.75296309197142e+41*cos(theta)**26 - 3.19630674706821e+42*cos(theta)**24 + 5.07000380569441e+42*cos(theta)**22 - 4.59282697692317e+42*cos(theta)**20 + 2.62842507715483e+42*cos(theta)**18 - 9.92960584702934e+41*cos(theta)**16 + 2.51382426507072e+41*cos(theta)**14 - 4.24411888908044e+40*cos(theta)**12 + 4.66853077798848e+39*cos(theta)**10 - 3.19762382054005e+38*cos(theta)**8 + 1.26103474612847e+37*cos(theta)**6 - 2.49216352989817e+35*cos(theta)**4 + 1.85982352977475e+33*cos(theta)**2 - 2.20097459144941e+30)*sin(19*phi)

@torch.jit.script
def Yl45_m_minus_18(theta, phi):
    return 8.91874394858126e-30*(1.0 - cos(theta)**2)**9*(3.24183818221164e+40*cos(theta)**27 - 1.27852269882729e+41*cos(theta)**25 + 2.2043494807367e+41*cos(theta)**23 - 2.18706046520151e+41*cos(theta)**21 + 1.38338161955517e+41*cos(theta)**19 - 5.84094461589961e+40*cos(theta)**17 + 1.67588284338048e+40*cos(theta)**15 - 3.26470683775418e+39*cos(theta)**13 + 4.24411888908044e+38*cos(theta)**11 - 3.55291535615562e+37*cos(theta)**9 + 1.80147820875496e+36*cos(theta)**7 - 4.98432705979633e+34*cos(theta)**5 + 6.19941176591584e+32*cos(theta)**3 - 2.20097459144941e+30*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl45_m_minus_17(theta, phi):
    return 3.74587245840413e-28*(1.0 - cos(theta)**2)**8.5*(1.15779935078987e+39*cos(theta)**28 - 4.91739499548956e+39*cos(theta)**26 + 9.18478950306958e+39*cos(theta)**24 - 9.94118393273413e+39*cos(theta)**22 + 6.91690809777586e+39*cos(theta)**20 - 3.24496923105534e+39*cos(theta)**18 + 1.0474267771128e+39*cos(theta)**16 - 2.3319334555387e+38*cos(theta)**14 + 3.53676574090036e+37*cos(theta)**12 - 3.55291535615562e+36*cos(theta)**10 + 2.2518477609437e+35*cos(theta)**8 - 8.30721176632722e+33*cos(theta)**6 + 1.54985294147896e+32*cos(theta)**4 - 1.1004872957247e+30*cos(theta)**2 + 1.24771802236361e+27)*sin(17*phi)

@torch.jit.script
def Yl45_m_minus_16(theta, phi):
    return 1.5883559340836e-26*(1.0 - cos(theta)**2)**8*(3.99241155444783e+37*cos(theta)**29 - 1.82125740573687e+38*cos(theta)**27 + 3.67391580122783e+38*cos(theta)**25 - 4.32225388379745e+38*cos(theta)**23 + 3.29376576084565e+38*cos(theta)**21 - 1.70787854266071e+38*cos(theta)**19 + 6.16133398301647e+37*cos(theta)**17 - 1.55462230369247e+37*cos(theta)**15 + 2.72058903146182e+36*cos(theta)**13 - 3.22992305105056e+35*cos(theta)**11 + 2.50205306771522e+34*cos(theta)**9 - 1.18674453804675e+33*cos(theta)**7 + 3.09970588295792e+31*cos(theta)**5 - 3.66829098574902e+29*cos(theta)**3 + 1.24771802236361e+27*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl45_m_minus_15(theta, phi):
    return 6.79474831705311e-25*(1.0 - cos(theta)**2)**7.5*(1.33080385148261e+36*cos(theta)**30 - 6.50449073477455e+36*cos(theta)**28 + 1.41304453893378e+37*cos(theta)**26 - 1.80093911824894e+37*cos(theta)**24 + 1.49716625492984e+37*cos(theta)**22 - 8.53939271330353e+36*cos(theta)**20 + 3.42296332389804e+36*cos(theta)**18 - 9.71638939807792e+35*cos(theta)**16 + 1.94327787961558e+35*cos(theta)**14 - 2.69160254254213e+34*cos(theta)**12 + 2.50205306771522e+33*cos(theta)**10 - 1.48343067255843e+32*cos(theta)**8 + 5.16617647159653e+30*cos(theta)**6 - 9.17072746437254e+28*cos(theta)**4 + 6.23859011181806e+26*cos(theta)**2 - 6.81813126974651e+23)*sin(15*phi)

@torch.jit.script
def Yl45_m_minus_14(theta, phi):
    return 2.93041984581218e-23*(1.0 - cos(theta)**2)**7*(4.2929156499439e+34*cos(theta)**31 - 2.24292783957743e+35*cos(theta)**29 + 5.23349829234734e+35*cos(theta)**27 - 7.20375647299575e+35*cos(theta)**25 + 6.50941849969495e+35*cos(theta)**23 - 4.06637748252549e+35*cos(theta)**21 + 1.80155964415686e+35*cos(theta)**19 - 5.71552317533995e+34*cos(theta)**17 + 1.29551858641039e+34*cos(theta)**15 - 2.07046349426318e+33*cos(theta)**13 + 2.27459369792293e+32*cos(theta)**11 - 1.6482563028427e+31*cos(theta)**9 + 7.38025210228076e+29*cos(theta)**7 - 1.83414549287451e+28*cos(theta)**5 + 2.07953003727268e+26*cos(theta)**3 - 6.81813126974651e+23*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl45_m_minus_13(theta, phi):
    return 1.27330030128458e-21*(1.0 - cos(theta)**2)**6.5*(1.34153614060747e+33*cos(theta)**32 - 7.47642613192477e+33*cos(theta)**30 + 1.86910653298119e+34*cos(theta)**28 - 2.77067556653683e+34*cos(theta)**26 + 2.71225770820623e+34*cos(theta)**24 - 1.84835340114795e+34*cos(theta)**22 + 9.00779822078431e+33*cos(theta)**20 - 3.17529065296664e+33*cos(theta)**18 + 8.09699116506493e+32*cos(theta)**16 - 1.47890249590227e+32*cos(theta)**14 + 1.89549474826911e+31*cos(theta)**12 - 1.6482563028427e+30*cos(theta)**10 + 9.22531512785095e+28*cos(theta)**8 - 3.05690915479085e+27*cos(theta)**6 + 5.19882509318171e+25*cos(theta)**4 - 3.40906563487325e+23*cos(theta)**2 + 3.61129834202675e+20)*sin(13*phi)

@torch.jit.script
def Yl45_m_minus_12(theta, phi):
    return 5.57059786735605e-20*(1.0 - cos(theta)**2)**6*(4.06526103214385e+31*cos(theta)**33 - 2.41175036513702e+32*cos(theta)**31 + 6.44519494131446e+32*cos(theta)**29 - 1.02617613575438e+33*cos(theta)**27 + 1.08490308328249e+33*cos(theta)**25 - 8.03631913542587e+32*cos(theta)**23 + 4.28942772418301e+32*cos(theta)**21 - 1.67120560682455e+32*cos(theta)**19 + 4.76293597944996e+31*cos(theta)**17 - 9.85934997268181e+30*cos(theta)**15 + 1.45807288328393e+30*cos(theta)**13 - 1.49841482076609e+29*cos(theta)**11 + 1.02503501420566e+28*cos(theta)**9 - 4.36701307827264e+26*cos(theta)**7 + 1.03976501863634e+25*cos(theta)**5 - 1.13635521162442e+23*cos(theta)**3 + 3.61129834202675e+20*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl45_m_minus_11(theta, phi):
    return 2.45232877980087e-18*(1.0 - cos(theta)**2)**5.5*(1.19566500945407e+30*cos(theta)**34 - 7.5367198910532e+30*cos(theta)**32 + 2.14839831377149e+31*cos(theta)**30 - 3.66491477055136e+31*cos(theta)**28 + 4.17270416647112e+31*cos(theta)**26 - 3.34846630642745e+31*cos(theta)**24 + 1.94973987462864e+31*cos(theta)**22 - 8.35602803412274e+30*cos(theta)**20 + 2.64607554413887e+30*cos(theta)**18 - 6.16209373292613e+29*cos(theta)**16 + 1.04148063091709e+29*cos(theta)**14 - 1.24867901730508e+28*cos(theta)**12 + 1.02503501420566e+27*cos(theta)**10 - 5.4587663478408e+25*cos(theta)**8 + 1.73294169772724e+24*cos(theta)**6 - 2.84088802906104e+22*cos(theta)**4 + 1.80564917101338e+20*cos(theta)**2 - 1.86341503716551e+17)*sin(11*phi)

@torch.jit.script
def Yl45_m_minus_10(theta, phi):
    return 1.08569223220532e-16*(1.0 - cos(theta)**2)**5*(3.41618574129735e+28*cos(theta)**35 - 2.28385451244036e+29*cos(theta)**33 + 6.93031714119834e+29*cos(theta)**31 - 1.26376371398323e+30*cos(theta)**29 + 1.5454459875819e+30*cos(theta)**27 - 1.33938652257098e+30*cos(theta)**25 + 8.47712988968974e+29*cos(theta)**23 - 3.97906096862988e+29*cos(theta)**21 + 1.39267133902046e+29*cos(theta)**19 - 3.62476101936831e+28*cos(theta)**17 + 6.94320420611395e+27*cos(theta)**15 - 9.60522321003906e+26*cos(theta)**13 + 9.31850012914237e+25*cos(theta)**11 - 6.06529594204533e+24*cos(theta)**9 + 2.4756309967532e+23*cos(theta)**7 - 5.68177605812209e+21*cos(theta)**5 + 6.01883057004459e+19*cos(theta)**3 - 1.86341503716551e+17*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl45_m_minus_9(theta, phi):
    return 4.83102545395957e-15*(1.0 - cos(theta)**2)**4.5*(9.48940483693708e+26*cos(theta)**36 - 6.71721915423636e+27*cos(theta)**34 + 2.16572410662448e+28*cos(theta)**32 - 4.21254571327742e+28*cos(theta)**30 + 5.51944995564964e+28*cos(theta)**28 - 5.15148662527299e+28*cos(theta)**26 + 3.53213745403739e+28*cos(theta)**24 - 1.80866407664994e+28*cos(theta)**22 + 6.96335669510228e+27*cos(theta)**20 - 2.01375612187128e+27*cos(theta)**18 + 4.33950262882122e+26*cos(theta)**16 - 6.86087372145647e+25*cos(theta)**14 + 7.76541677428531e+24*cos(theta)**12 - 6.06529594204533e+23*cos(theta)**10 + 3.0945387459415e+22*cos(theta)**8 - 9.46962676353682e+20*cos(theta)**6 + 1.50470764251115e+19*cos(theta)**4 - 9.31707518582753e+16*cos(theta)**2 + 94111870563914.5)*sin(9*phi)

@torch.jit.script
def Yl45_m_minus_8(theta, phi):
    return 2.15941974288782e-13*(1.0 - cos(theta)**2)**4*(2.56470400998299e+25*cos(theta)**37 - 1.91920547263896e+26*cos(theta)**35 + 6.56280032310449e+26*cos(theta)**33 - 1.35888571396046e+27*cos(theta)**31 + 1.90325860539643e+27*cos(theta)**29 - 1.90795800936037e+27*cos(theta)**27 + 1.41285498161496e+27*cos(theta)**25 - 7.86375685499976e+26*cos(theta)**23 + 3.3158841405249e+26*cos(theta)**21 - 1.05987164309015e+26*cos(theta)**19 + 2.55264860518895e+25*cos(theta)**17 - 4.57391581430431e+24*cos(theta)**15 + 5.97339751868101e+23*cos(theta)**13 - 5.51390540185939e+22*cos(theta)**11 + 3.43837638437944e+21*cos(theta)**9 - 1.3528038233624e+20*cos(theta)**7 + 3.00941528502229e+18*cos(theta)**5 - 3.10569172860918e+16*cos(theta)**3 + 94111870563914.5*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl45_m_minus_7(theta, phi):
    return 9.69095999512484e-12*(1.0 - cos(theta)**2)**3.5*(6.74922107890262e+23*cos(theta)**38 - 5.331126312886e+24*cos(theta)**36 + 1.93023538914838e+25*cos(theta)**34 - 4.24651785612643e+25*cos(theta)**32 + 6.34419535132142e+25*cos(theta)**30 - 6.8141357477156e+25*cos(theta)**28 + 5.43405762159598e+25*cos(theta)**26 - 3.2765653562499e+25*cos(theta)**24 + 1.50722006387495e+25*cos(theta)**22 - 5.29935821545075e+24*cos(theta)**20 + 1.41813811399386e+24*cos(theta)**18 - 2.8586973839402e+23*cos(theta)**16 + 4.26671251334358e+22*cos(theta)**14 - 4.59492116821616e+21*cos(theta)**12 + 3.43837638437944e+20*cos(theta)**10 - 1.691004779203e+19*cos(theta)**8 + 5.01569214170382e+17*cos(theta)**6 - 7.76422932152295e+15*cos(theta)**4 + 47055935281957.2*cos(theta)**2 - 46728833447.8225)*sin(7*phi)

@torch.jit.script
def Yl45_m_minus_6(theta, phi):
    return 4.36416112227515e-10*(1.0 - cos(theta)**2)**3*(1.73056950741093e+22*cos(theta)**39 - 1.44084494942865e+23*cos(theta)**37 + 5.51495825470966e+23*cos(theta)**35 - 1.28682359276559e+24*cos(theta)**33 + 2.04651462945852e+24*cos(theta)**31 - 2.3497019819709e+24*cos(theta)**29 + 2.01261393392444e+24*cos(theta)**27 - 1.31062614249996e+24*cos(theta)**25 + 6.5531307124998e+23*cos(theta)**23 - 2.5235039121194e+23*cos(theta)**21 + 7.46388481049401e+22*cos(theta)**19 - 1.68158669643541e+22*cos(theta)**17 + 2.84447500889572e+21*cos(theta)**15 - 3.53455474478166e+20*cos(theta)**13 + 3.12579671307222e+19*cos(theta)**11 - 1.87889419911445e+18*cos(theta)**9 + 7.16527448814832e+16*cos(theta)**7 - 1.55284586430459e+15*cos(theta)**5 + 15685311760652.4*cos(theta)**3 - 46728833447.8225*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl45_m_minus_5(theta, phi):
    return 1.97113268691894e-8*(1.0 - cos(theta)**2)**2.5*(4.32642376852732e+20*cos(theta)**40 - 3.79169723533855e+21*cos(theta)**38 + 1.53193284853046e+22*cos(theta)**36 - 3.78477527283996e+22*cos(theta)**34 + 6.39535821705788e+22*cos(theta)**32 - 7.83233993990299e+22*cos(theta)**30 + 7.187906906873e+22*cos(theta)**28 - 5.040869778846e+22*cos(theta)**26 + 2.73047113020825e+22*cos(theta)**24 - 1.14704723278155e+22*cos(theta)**22 + 3.73194240524701e+21*cos(theta)**20 - 9.34214831353005e+20*cos(theta)**18 + 1.77779688055982e+20*cos(theta)**16 - 2.52468196055833e+19*cos(theta)**14 + 2.60483059422685e+18*cos(theta)**12 - 1.87889419911445e+17*cos(theta)**10 + 8.9565931101854e+15*cos(theta)**8 - 258807644050765.0*cos(theta)**6 + 3921327940163.1*cos(theta)**4 - 23364416723.9112*cos(theta)**2 + 22906290.9057953)*sin(5*phi)

@torch.jit.script
def Yl45_m_minus_4(theta, phi):
    return 8.92468281921133e-7*(1.0 - cos(theta)**2)**2*(1.05522530939691e+19*cos(theta)**41 - 9.72230060343218e+19*cos(theta)**39 + 4.14035905008232e+20*cos(theta)**37 - 1.08136436366856e+21*cos(theta)**35 + 1.93798733850239e+21*cos(theta)**33 - 2.52656127093645e+21*cos(theta)**31 + 2.4785885885769e+21*cos(theta)**29 - 1.86698880698e+21*cos(theta)**27 + 1.0921884520833e+21*cos(theta)**25 - 4.9871618816589e+20*cos(theta)**23 + 1.77711543107e+20*cos(theta)**21 - 4.91692016501582e+19*cos(theta)**19 + 1.04576287091754e+19*cos(theta)**17 - 1.68312130703889e+18*cos(theta)**15 + 2.00371584171296e+17*cos(theta)**13 - 1.70808563555859e+16*cos(theta)**11 + 995177012242822.0*cos(theta)**9 - 36972520578680.7*cos(theta)**7 + 784265588032.621*cos(theta)**5 - 7788138907.97041*cos(theta)**3 + 22906290.9057953*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl45_m_minus_3(theta, phi):
    return 4.0486988616791e-5*(1.0 - cos(theta)**2)**1.5*(2.51244121284978e+17*cos(theta)**42 - 2.43057515085804e+18*cos(theta)**40 + 1.0895681710743e+19*cos(theta)**38 - 3.00378989907933e+19*cos(theta)**36 + 5.69996276030114e+19*cos(theta)**34 - 7.8955039716764e+19*cos(theta)**32 + 8.26196196192298e+19*cos(theta)**30 - 6.66781716778571e+19*cos(theta)**28 + 4.200724815705e+19*cos(theta)**26 - 2.07798411735788e+19*cos(theta)**24 + 8.07779741395456e+18*cos(theta)**22 - 2.45846008250791e+18*cos(theta)**20 + 5.80979372731969e+17*cos(theta)**18 - 1.0519508168993e+17*cos(theta)**16 + 1.43122560122354e+16*cos(theta)**14 - 1.42340469629882e+15*cos(theta)**12 + 99517701224282.2*cos(theta)**10 - 4621565072335.09*cos(theta)**8 + 130710931338.77*cos(theta)**6 - 1947034726.9926*cos(theta)**4 + 11453145.4528977*cos(theta)**2 - 11130.3648716207)*sin(3*phi)

@torch.jit.script
def Yl45_m_minus_2(theta, phi):
    return 0.00183937518041772*(1.0 - cos(theta)**2)*(5.84288654151111e+15*cos(theta)**43 - 5.92823207526352e+16*cos(theta)**41 + 2.79376454121614e+17*cos(theta)**39 - 8.11835107859279e+17*cos(theta)**37 + 1.62856078865747e+18*cos(theta)**35 - 2.39257696111406e+18*cos(theta)**33 + 2.66514901997516e+18*cos(theta)**31 - 2.29924729923645e+18*cos(theta)**29 + 1.55582400581667e+18*cos(theta)**27 - 8.3119364694315e+17*cos(theta)**25 + 3.51208583215416e+17*cos(theta)**23 - 1.17069527738472e+17*cos(theta)**21 + 3.05778617227352e+16*cos(theta)**19 - 6.18794598176061e+15*cos(theta)**17 + 954150400815695.0*cos(theta)**15 - 109492668946063.0*cos(theta)**13 + 9047063747662.02*cos(theta)**11 - 513507230259.454*cos(theta)**9 + 18672990191.2529*cos(theta)**7 - 389406945.398521*cos(theta)**5 + 3817715.15096589*cos(theta)**3 - 11130.3648716207*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl45_m_minus_1(theta, phi):
    return 0.0836460792886812*(1.0 - cos(theta)**2)**0.5*(132792875943434.0*cos(theta)**44 - 1.4114838274437e+15*cos(theta)**42 + 6.98441135304036e+15*cos(theta)**40 - 2.13640817857705e+16*cos(theta)**38 + 4.52377996849297e+16*cos(theta)**36 - 7.03699106210018e+16*cos(theta)**34 + 8.32859068742236e+16*cos(theta)**32 - 7.66415766412151e+16*cos(theta)**30 + 5.55651430648809e+16*cos(theta)**28 - 3.19689864208904e+16*cos(theta)**26 + 1.4633690967309e+16*cos(theta)**24 - 5.32134216993054e+15*cos(theta)**22 + 1.52889308613676e+15*cos(theta)**20 - 343774776764478.0*cos(theta)**18 + 59634400050981.0*cos(theta)**16 - 7820904924718.81*cos(theta)**14 + 753921978971.835*cos(theta)**12 - 51350723025.9454*cos(theta)**10 + 2334123773.90661*cos(theta)**8 - 64901157.5664201*cos(theta)**6 + 954428.787741472*cos(theta)**4 - 5565.18243581033*cos(theta)**2 + 5.38218804236976)*sin(phi)

@torch.jit.script
def Yl45_m0(theta, phi):
    return 7941051765082.16*cos(theta)**45 - 88333047723947.7*cos(theta)**43 + 458418058015659.0*cos(theta)**41 - 1.4741286571484e+15*cos(theta)**39 + 3.29014859923783e+15*cos(theta)**37 - 5.41046658541333e+15*cos(theta)**35 + 6.79161944793445e+15*cos(theta)**33 - 6.65301496940517e+15*cos(theta)**31 + 5.15608660128901e+15*cos(theta)**29 - 3.1862574735515e+15*cos(theta)**27 + 1.57517799044588e+15*cos(theta)**25 - 622599996223670.0*cos(theta)**23 + 195917660503219.0*cos(theta)**21 - 48689596101391.8*cos(theta)**19 + 9439819652310.66*cos(theta)**17 - 1403077019359.84*cos(theta)**15 + 156062592195.744*cos(theta)**13 - 12562313922.8773*cos(theta)**11 + 697906329.048737*cos(theta)**9 - 24949977.9997562*cos(theta)**7 + 513676.01764204*cos(theta)**5 - 4991.99239691001*cos(theta)**3 + 14.483536934942*cos(theta)

@torch.jit.script
def Yl45_m1(theta, phi):
    return 0.0836460792886812*(1.0 - cos(theta)**2)**0.5*(132792875943434.0*cos(theta)**44 - 1.4114838274437e+15*cos(theta)**42 + 6.98441135304036e+15*cos(theta)**40 - 2.13640817857705e+16*cos(theta)**38 + 4.52377996849297e+16*cos(theta)**36 - 7.03699106210018e+16*cos(theta)**34 + 8.32859068742236e+16*cos(theta)**32 - 7.66415766412151e+16*cos(theta)**30 + 5.55651430648809e+16*cos(theta)**28 - 3.19689864208904e+16*cos(theta)**26 + 1.4633690967309e+16*cos(theta)**24 - 5.32134216993054e+15*cos(theta)**22 + 1.52889308613676e+15*cos(theta)**20 - 343774776764478.0*cos(theta)**18 + 59634400050981.0*cos(theta)**16 - 7820904924718.81*cos(theta)**14 + 753921978971.835*cos(theta)**12 - 51350723025.9454*cos(theta)**10 + 2334123773.90661*cos(theta)**8 - 64901157.5664201*cos(theta)**6 + 954428.787741472*cos(theta)**4 - 5565.18243581033*cos(theta)**2 + 5.38218804236976)*cos(phi)

@torch.jit.script
def Yl45_m2(theta, phi):
    return 0.00183937518041772*(1.0 - cos(theta)**2)*(5.84288654151111e+15*cos(theta)**43 - 5.92823207526352e+16*cos(theta)**41 + 2.79376454121614e+17*cos(theta)**39 - 8.11835107859279e+17*cos(theta)**37 + 1.62856078865747e+18*cos(theta)**35 - 2.39257696111406e+18*cos(theta)**33 + 2.66514901997516e+18*cos(theta)**31 - 2.29924729923645e+18*cos(theta)**29 + 1.55582400581667e+18*cos(theta)**27 - 8.3119364694315e+17*cos(theta)**25 + 3.51208583215416e+17*cos(theta)**23 - 1.17069527738472e+17*cos(theta)**21 + 3.05778617227352e+16*cos(theta)**19 - 6.18794598176061e+15*cos(theta)**17 + 954150400815695.0*cos(theta)**15 - 109492668946063.0*cos(theta)**13 + 9047063747662.02*cos(theta)**11 - 513507230259.454*cos(theta)**9 + 18672990191.2529*cos(theta)**7 - 389406945.398521*cos(theta)**5 + 3817715.15096589*cos(theta)**3 - 11130.3648716207*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl45_m3(theta, phi):
    return 4.0486988616791e-5*(1.0 - cos(theta)**2)**1.5*(2.51244121284978e+17*cos(theta)**42 - 2.43057515085804e+18*cos(theta)**40 + 1.0895681710743e+19*cos(theta)**38 - 3.00378989907933e+19*cos(theta)**36 + 5.69996276030114e+19*cos(theta)**34 - 7.8955039716764e+19*cos(theta)**32 + 8.26196196192298e+19*cos(theta)**30 - 6.66781716778571e+19*cos(theta)**28 + 4.200724815705e+19*cos(theta)**26 - 2.07798411735788e+19*cos(theta)**24 + 8.07779741395456e+18*cos(theta)**22 - 2.45846008250791e+18*cos(theta)**20 + 5.80979372731969e+17*cos(theta)**18 - 1.0519508168993e+17*cos(theta)**16 + 1.43122560122354e+16*cos(theta)**14 - 1.42340469629882e+15*cos(theta)**12 + 99517701224282.2*cos(theta)**10 - 4621565072335.09*cos(theta)**8 + 130710931338.77*cos(theta)**6 - 1947034726.9926*cos(theta)**4 + 11453145.4528977*cos(theta)**2 - 11130.3648716207)*cos(3*phi)

@torch.jit.script
def Yl45_m4(theta, phi):
    return 8.92468281921133e-7*(1.0 - cos(theta)**2)**2*(1.05522530939691e+19*cos(theta)**41 - 9.72230060343218e+19*cos(theta)**39 + 4.14035905008232e+20*cos(theta)**37 - 1.08136436366856e+21*cos(theta)**35 + 1.93798733850239e+21*cos(theta)**33 - 2.52656127093645e+21*cos(theta)**31 + 2.4785885885769e+21*cos(theta)**29 - 1.86698880698e+21*cos(theta)**27 + 1.0921884520833e+21*cos(theta)**25 - 4.9871618816589e+20*cos(theta)**23 + 1.77711543107e+20*cos(theta)**21 - 4.91692016501582e+19*cos(theta)**19 + 1.04576287091754e+19*cos(theta)**17 - 1.68312130703889e+18*cos(theta)**15 + 2.00371584171296e+17*cos(theta)**13 - 1.70808563555859e+16*cos(theta)**11 + 995177012242822.0*cos(theta)**9 - 36972520578680.7*cos(theta)**7 + 784265588032.621*cos(theta)**5 - 7788138907.97041*cos(theta)**3 + 22906290.9057953*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl45_m5(theta, phi):
    return 1.97113268691894e-8*(1.0 - cos(theta)**2)**2.5*(4.32642376852732e+20*cos(theta)**40 - 3.79169723533855e+21*cos(theta)**38 + 1.53193284853046e+22*cos(theta)**36 - 3.78477527283996e+22*cos(theta)**34 + 6.39535821705788e+22*cos(theta)**32 - 7.83233993990299e+22*cos(theta)**30 + 7.187906906873e+22*cos(theta)**28 - 5.040869778846e+22*cos(theta)**26 + 2.73047113020825e+22*cos(theta)**24 - 1.14704723278155e+22*cos(theta)**22 + 3.73194240524701e+21*cos(theta)**20 - 9.34214831353005e+20*cos(theta)**18 + 1.77779688055982e+20*cos(theta)**16 - 2.52468196055833e+19*cos(theta)**14 + 2.60483059422685e+18*cos(theta)**12 - 1.87889419911445e+17*cos(theta)**10 + 8.9565931101854e+15*cos(theta)**8 - 258807644050765.0*cos(theta)**6 + 3921327940163.1*cos(theta)**4 - 23364416723.9112*cos(theta)**2 + 22906290.9057953)*cos(5*phi)

@torch.jit.script
def Yl45_m6(theta, phi):
    return 4.36416112227515e-10*(1.0 - cos(theta)**2)**3*(1.73056950741093e+22*cos(theta)**39 - 1.44084494942865e+23*cos(theta)**37 + 5.51495825470966e+23*cos(theta)**35 - 1.28682359276559e+24*cos(theta)**33 + 2.04651462945852e+24*cos(theta)**31 - 2.3497019819709e+24*cos(theta)**29 + 2.01261393392444e+24*cos(theta)**27 - 1.31062614249996e+24*cos(theta)**25 + 6.5531307124998e+23*cos(theta)**23 - 2.5235039121194e+23*cos(theta)**21 + 7.46388481049401e+22*cos(theta)**19 - 1.68158669643541e+22*cos(theta)**17 + 2.84447500889572e+21*cos(theta)**15 - 3.53455474478166e+20*cos(theta)**13 + 3.12579671307222e+19*cos(theta)**11 - 1.87889419911445e+18*cos(theta)**9 + 7.16527448814832e+16*cos(theta)**7 - 1.55284586430459e+15*cos(theta)**5 + 15685311760652.4*cos(theta)**3 - 46728833447.8225*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl45_m7(theta, phi):
    return 9.69095999512484e-12*(1.0 - cos(theta)**2)**3.5*(6.74922107890262e+23*cos(theta)**38 - 5.331126312886e+24*cos(theta)**36 + 1.93023538914838e+25*cos(theta)**34 - 4.24651785612643e+25*cos(theta)**32 + 6.34419535132142e+25*cos(theta)**30 - 6.8141357477156e+25*cos(theta)**28 + 5.43405762159598e+25*cos(theta)**26 - 3.2765653562499e+25*cos(theta)**24 + 1.50722006387495e+25*cos(theta)**22 - 5.29935821545075e+24*cos(theta)**20 + 1.41813811399386e+24*cos(theta)**18 - 2.8586973839402e+23*cos(theta)**16 + 4.26671251334358e+22*cos(theta)**14 - 4.59492116821616e+21*cos(theta)**12 + 3.43837638437944e+20*cos(theta)**10 - 1.691004779203e+19*cos(theta)**8 + 5.01569214170382e+17*cos(theta)**6 - 7.76422932152295e+15*cos(theta)**4 + 47055935281957.2*cos(theta)**2 - 46728833447.8225)*cos(7*phi)

@torch.jit.script
def Yl45_m8(theta, phi):
    return 2.15941974288782e-13*(1.0 - cos(theta)**2)**4*(2.56470400998299e+25*cos(theta)**37 - 1.91920547263896e+26*cos(theta)**35 + 6.56280032310449e+26*cos(theta)**33 - 1.35888571396046e+27*cos(theta)**31 + 1.90325860539643e+27*cos(theta)**29 - 1.90795800936037e+27*cos(theta)**27 + 1.41285498161496e+27*cos(theta)**25 - 7.86375685499976e+26*cos(theta)**23 + 3.3158841405249e+26*cos(theta)**21 - 1.05987164309015e+26*cos(theta)**19 + 2.55264860518895e+25*cos(theta)**17 - 4.57391581430431e+24*cos(theta)**15 + 5.97339751868101e+23*cos(theta)**13 - 5.51390540185939e+22*cos(theta)**11 + 3.43837638437944e+21*cos(theta)**9 - 1.3528038233624e+20*cos(theta)**7 + 3.00941528502229e+18*cos(theta)**5 - 3.10569172860918e+16*cos(theta)**3 + 94111870563914.5*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl45_m9(theta, phi):
    return 4.83102545395957e-15*(1.0 - cos(theta)**2)**4.5*(9.48940483693708e+26*cos(theta)**36 - 6.71721915423636e+27*cos(theta)**34 + 2.16572410662448e+28*cos(theta)**32 - 4.21254571327742e+28*cos(theta)**30 + 5.51944995564964e+28*cos(theta)**28 - 5.15148662527299e+28*cos(theta)**26 + 3.53213745403739e+28*cos(theta)**24 - 1.80866407664994e+28*cos(theta)**22 + 6.96335669510228e+27*cos(theta)**20 - 2.01375612187128e+27*cos(theta)**18 + 4.33950262882122e+26*cos(theta)**16 - 6.86087372145647e+25*cos(theta)**14 + 7.76541677428531e+24*cos(theta)**12 - 6.06529594204533e+23*cos(theta)**10 + 3.0945387459415e+22*cos(theta)**8 - 9.46962676353682e+20*cos(theta)**6 + 1.50470764251115e+19*cos(theta)**4 - 9.31707518582753e+16*cos(theta)**2 + 94111870563914.5)*cos(9*phi)

@torch.jit.script
def Yl45_m10(theta, phi):
    return 1.08569223220532e-16*(1.0 - cos(theta)**2)**5*(3.41618574129735e+28*cos(theta)**35 - 2.28385451244036e+29*cos(theta)**33 + 6.93031714119834e+29*cos(theta)**31 - 1.26376371398323e+30*cos(theta)**29 + 1.5454459875819e+30*cos(theta)**27 - 1.33938652257098e+30*cos(theta)**25 + 8.47712988968974e+29*cos(theta)**23 - 3.97906096862988e+29*cos(theta)**21 + 1.39267133902046e+29*cos(theta)**19 - 3.62476101936831e+28*cos(theta)**17 + 6.94320420611395e+27*cos(theta)**15 - 9.60522321003906e+26*cos(theta)**13 + 9.31850012914237e+25*cos(theta)**11 - 6.06529594204533e+24*cos(theta)**9 + 2.4756309967532e+23*cos(theta)**7 - 5.68177605812209e+21*cos(theta)**5 + 6.01883057004459e+19*cos(theta)**3 - 1.86341503716551e+17*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl45_m11(theta, phi):
    return 2.45232877980087e-18*(1.0 - cos(theta)**2)**5.5*(1.19566500945407e+30*cos(theta)**34 - 7.5367198910532e+30*cos(theta)**32 + 2.14839831377149e+31*cos(theta)**30 - 3.66491477055136e+31*cos(theta)**28 + 4.17270416647112e+31*cos(theta)**26 - 3.34846630642745e+31*cos(theta)**24 + 1.94973987462864e+31*cos(theta)**22 - 8.35602803412274e+30*cos(theta)**20 + 2.64607554413887e+30*cos(theta)**18 - 6.16209373292613e+29*cos(theta)**16 + 1.04148063091709e+29*cos(theta)**14 - 1.24867901730508e+28*cos(theta)**12 + 1.02503501420566e+27*cos(theta)**10 - 5.4587663478408e+25*cos(theta)**8 + 1.73294169772724e+24*cos(theta)**6 - 2.84088802906104e+22*cos(theta)**4 + 1.80564917101338e+20*cos(theta)**2 - 1.86341503716551e+17)*cos(11*phi)

@torch.jit.script
def Yl45_m12(theta, phi):
    return 5.57059786735605e-20*(1.0 - cos(theta)**2)**6*(4.06526103214385e+31*cos(theta)**33 - 2.41175036513702e+32*cos(theta)**31 + 6.44519494131446e+32*cos(theta)**29 - 1.02617613575438e+33*cos(theta)**27 + 1.08490308328249e+33*cos(theta)**25 - 8.03631913542587e+32*cos(theta)**23 + 4.28942772418301e+32*cos(theta)**21 - 1.67120560682455e+32*cos(theta)**19 + 4.76293597944996e+31*cos(theta)**17 - 9.85934997268181e+30*cos(theta)**15 + 1.45807288328393e+30*cos(theta)**13 - 1.49841482076609e+29*cos(theta)**11 + 1.02503501420566e+28*cos(theta)**9 - 4.36701307827264e+26*cos(theta)**7 + 1.03976501863634e+25*cos(theta)**5 - 1.13635521162442e+23*cos(theta)**3 + 3.61129834202675e+20*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl45_m13(theta, phi):
    return 1.27330030128458e-21*(1.0 - cos(theta)**2)**6.5*(1.34153614060747e+33*cos(theta)**32 - 7.47642613192477e+33*cos(theta)**30 + 1.86910653298119e+34*cos(theta)**28 - 2.77067556653683e+34*cos(theta)**26 + 2.71225770820623e+34*cos(theta)**24 - 1.84835340114795e+34*cos(theta)**22 + 9.00779822078431e+33*cos(theta)**20 - 3.17529065296664e+33*cos(theta)**18 + 8.09699116506493e+32*cos(theta)**16 - 1.47890249590227e+32*cos(theta)**14 + 1.89549474826911e+31*cos(theta)**12 - 1.6482563028427e+30*cos(theta)**10 + 9.22531512785095e+28*cos(theta)**8 - 3.05690915479085e+27*cos(theta)**6 + 5.19882509318171e+25*cos(theta)**4 - 3.40906563487325e+23*cos(theta)**2 + 3.61129834202675e+20)*cos(13*phi)

@torch.jit.script
def Yl45_m14(theta, phi):
    return 2.93041984581218e-23*(1.0 - cos(theta)**2)**7*(4.2929156499439e+34*cos(theta)**31 - 2.24292783957743e+35*cos(theta)**29 + 5.23349829234734e+35*cos(theta)**27 - 7.20375647299575e+35*cos(theta)**25 + 6.50941849969495e+35*cos(theta)**23 - 4.06637748252549e+35*cos(theta)**21 + 1.80155964415686e+35*cos(theta)**19 - 5.71552317533995e+34*cos(theta)**17 + 1.29551858641039e+34*cos(theta)**15 - 2.07046349426318e+33*cos(theta)**13 + 2.27459369792293e+32*cos(theta)**11 - 1.6482563028427e+31*cos(theta)**9 + 7.38025210228076e+29*cos(theta)**7 - 1.83414549287451e+28*cos(theta)**5 + 2.07953003727268e+26*cos(theta)**3 - 6.81813126974651e+23*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl45_m15(theta, phi):
    return 6.79474831705311e-25*(1.0 - cos(theta)**2)**7.5*(1.33080385148261e+36*cos(theta)**30 - 6.50449073477455e+36*cos(theta)**28 + 1.41304453893378e+37*cos(theta)**26 - 1.80093911824894e+37*cos(theta)**24 + 1.49716625492984e+37*cos(theta)**22 - 8.53939271330353e+36*cos(theta)**20 + 3.42296332389804e+36*cos(theta)**18 - 9.71638939807792e+35*cos(theta)**16 + 1.94327787961558e+35*cos(theta)**14 - 2.69160254254213e+34*cos(theta)**12 + 2.50205306771522e+33*cos(theta)**10 - 1.48343067255843e+32*cos(theta)**8 + 5.16617647159653e+30*cos(theta)**6 - 9.17072746437254e+28*cos(theta)**4 + 6.23859011181806e+26*cos(theta)**2 - 6.81813126974651e+23)*cos(15*phi)

@torch.jit.script
def Yl45_m16(theta, phi):
    return 1.5883559340836e-26*(1.0 - cos(theta)**2)**8*(3.99241155444783e+37*cos(theta)**29 - 1.82125740573687e+38*cos(theta)**27 + 3.67391580122783e+38*cos(theta)**25 - 4.32225388379745e+38*cos(theta)**23 + 3.29376576084565e+38*cos(theta)**21 - 1.70787854266071e+38*cos(theta)**19 + 6.16133398301647e+37*cos(theta)**17 - 1.55462230369247e+37*cos(theta)**15 + 2.72058903146182e+36*cos(theta)**13 - 3.22992305105056e+35*cos(theta)**11 + 2.50205306771522e+34*cos(theta)**9 - 1.18674453804675e+33*cos(theta)**7 + 3.09970588295792e+31*cos(theta)**5 - 3.66829098574902e+29*cos(theta)**3 + 1.24771802236361e+27*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl45_m17(theta, phi):
    return 3.74587245840413e-28*(1.0 - cos(theta)**2)**8.5*(1.15779935078987e+39*cos(theta)**28 - 4.91739499548956e+39*cos(theta)**26 + 9.18478950306958e+39*cos(theta)**24 - 9.94118393273413e+39*cos(theta)**22 + 6.91690809777586e+39*cos(theta)**20 - 3.24496923105534e+39*cos(theta)**18 + 1.0474267771128e+39*cos(theta)**16 - 2.3319334555387e+38*cos(theta)**14 + 3.53676574090036e+37*cos(theta)**12 - 3.55291535615562e+36*cos(theta)**10 + 2.2518477609437e+35*cos(theta)**8 - 8.30721176632722e+33*cos(theta)**6 + 1.54985294147896e+32*cos(theta)**4 - 1.1004872957247e+30*cos(theta)**2 + 1.24771802236361e+27)*cos(17*phi)

@torch.jit.script
def Yl45_m18(theta, phi):
    return 8.91874394858126e-30*(1.0 - cos(theta)**2)**9*(3.24183818221164e+40*cos(theta)**27 - 1.27852269882729e+41*cos(theta)**25 + 2.2043494807367e+41*cos(theta)**23 - 2.18706046520151e+41*cos(theta)**21 + 1.38338161955517e+41*cos(theta)**19 - 5.84094461589961e+40*cos(theta)**17 + 1.67588284338048e+40*cos(theta)**15 - 3.26470683775418e+39*cos(theta)**13 + 4.24411888908044e+38*cos(theta)**11 - 3.55291535615562e+37*cos(theta)**9 + 1.80147820875496e+36*cos(theta)**7 - 4.98432705979633e+34*cos(theta)**5 + 6.19941176591584e+32*cos(theta)**3 - 2.20097459144941e+30*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl45_m19(theta, phi):
    return 2.14551634147781e-31*(1.0 - cos(theta)**2)**9.5*(8.75296309197142e+41*cos(theta)**26 - 3.19630674706821e+42*cos(theta)**24 + 5.07000380569441e+42*cos(theta)**22 - 4.59282697692317e+42*cos(theta)**20 + 2.62842507715483e+42*cos(theta)**18 - 9.92960584702934e+41*cos(theta)**16 + 2.51382426507072e+41*cos(theta)**14 - 4.24411888908044e+40*cos(theta)**12 + 4.66853077798848e+39*cos(theta)**10 - 3.19762382054005e+38*cos(theta)**8 + 1.26103474612847e+37*cos(theta)**6 - 2.49216352989817e+35*cos(theta)**4 + 1.85982352977475e+33*cos(theta)**2 - 2.20097459144941e+30)*cos(19*phi)

@torch.jit.script
def Yl45_m20(theta, phi):
    return 5.21901415090882e-33*(1.0 - cos(theta)**2)**10*(2.27577040391257e+43*cos(theta)**25 - 7.67113619296371e+43*cos(theta)**23 + 1.11540083725277e+44*cos(theta)**21 - 9.18565395384634e+43*cos(theta)**19 + 4.73116513887869e+43*cos(theta)**17 - 1.5887369355247e+43*cos(theta)**15 + 3.51935397109901e+42*cos(theta)**13 - 5.09294266689652e+41*cos(theta)**11 + 4.66853077798848e+40*cos(theta)**9 - 2.55809905643204e+39*cos(theta)**7 + 7.56620847677083e+37*cos(theta)**5 - 9.96865411959267e+35*cos(theta)**3 + 3.7196470595495e+33*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl45_m21(theta, phi):
    return 1.28483246655521e-34*(1.0 - cos(theta)**2)**10.5*(5.68942600978142e+44*cos(theta)**24 - 1.76436132438165e+45*cos(theta)**22 + 2.34234175823082e+45*cos(theta)**20 - 1.7452742512308e+45*cos(theta)**18 + 8.04298073609377e+44*cos(theta)**16 - 2.38310540328704e+44*cos(theta)**14 + 4.57516016242871e+43*cos(theta)**12 - 5.60223693358618e+42*cos(theta)**10 + 4.20167770018963e+41*cos(theta)**8 - 1.79066933950243e+40*cos(theta)**6 + 3.78310423838542e+38*cos(theta)**4 - 2.9905962358778e+36*cos(theta)**2 + 3.7196470595495e+33)*cos(21*phi)

@torch.jit.script
def Yl45_m22(theta, phi):
    return 3.20408095180754e-36*(1.0 - cos(theta)**2)**11*(1.36546224234754e+46*cos(theta)**23 - 3.88159491363964e+46*cos(theta)**21 + 4.68468351646163e+46*cos(theta)**19 - 3.14149365221545e+46*cos(theta)**17 + 1.286876917775e+46*cos(theta)**15 - 3.33634756460186e+45*cos(theta)**13 + 5.49019219491445e+44*cos(theta)**11 - 5.60223693358618e+43*cos(theta)**9 + 3.36134216015171e+42*cos(theta)**7 - 1.07440160370146e+41*cos(theta)**5 + 1.51324169535417e+39*cos(theta)**3 - 5.9811924717556e+36*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl45_m23(theta, phi):
    return 8.10186692897904e-38*(1.0 - cos(theta)**2)**11.5*(3.14056315739934e+47*cos(theta)**22 - 8.15134931864324e+47*cos(theta)**20 + 8.9008986812771e+47*cos(theta)**18 - 5.34053920876626e+47*cos(theta)**16 + 1.9303153766625e+47*cos(theta)**14 - 4.33725183398242e+46*cos(theta)**12 + 6.0392114144059e+45*cos(theta)**10 - 5.04201324022756e+44*cos(theta)**8 + 2.35293951210619e+43*cos(theta)**6 - 5.37200801850729e+41*cos(theta)**4 + 4.5397250860625e+39*cos(theta)**2 - 5.9811924717556e+36)*cos(23*phi)

@torch.jit.script
def Yl45_m24(theta, phi):
    return 2.07945353200254e-39*(1.0 - cos(theta)**2)**12*(6.90923894627856e+48*cos(theta)**21 - 1.63026986372865e+49*cos(theta)**19 + 1.60216176262988e+49*cos(theta)**17 - 8.54486273402602e+48*cos(theta)**15 + 2.70244152732751e+48*cos(theta)**13 - 5.2047022007789e+47*cos(theta)**11 + 6.0392114144059e+46*cos(theta)**9 - 4.03361059218205e+45*cos(theta)**7 + 1.41176370726372e+44*cos(theta)**5 - 2.14880320740292e+42*cos(theta)**3 + 9.079450172125e+39*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl45_m25(theta, phi):
    return 5.42363622267421e-41*(1.0 - cos(theta)**2)**12.5*(1.4509401787185e+50*cos(theta)**20 - 3.09751274108443e+50*cos(theta)**18 + 2.72367499647079e+50*cos(theta)**16 - 1.2817294101039e+50*cos(theta)**14 + 3.51317398552576e+49*cos(theta)**12 - 5.72517242085679e+48*cos(theta)**10 + 5.43529027296531e+47*cos(theta)**8 - 2.82352741452743e+46*cos(theta)**6 + 7.05881853631858e+44*cos(theta)**4 - 6.44640962220875e+42*cos(theta)**2 + 9.079450172125e+39)*cos(25*phi)

@torch.jit.script
def Yl45_m26(theta, phi):
    return 1.43928361180293e-42*(1.0 - cos(theta)**2)**13*(2.90188035743699e+51*cos(theta)**19 - 5.57552293395198e+51*cos(theta)**17 + 4.35787999435327e+51*cos(theta)**15 - 1.79442117414546e+51*cos(theta)**13 + 4.21580878263091e+50*cos(theta)**11 - 5.72517242085679e+49*cos(theta)**9 + 4.34823221837225e+48*cos(theta)**7 - 1.69411644871646e+47*cos(theta)**5 + 2.82352741452743e+45*cos(theta)**3 - 1.28928192444175e+43*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl45_m27(theta, phi):
    return 3.89137721528147e-44*(1.0 - cos(theta)**2)**13.5*(5.51357267913029e+52*cos(theta)**18 - 9.47838898771836e+52*cos(theta)**16 + 6.5368199915299e+52*cos(theta)**14 - 2.3327475263891e+52*cos(theta)**12 + 4.637389660894e+51*cos(theta)**10 - 5.15265517877111e+50*cos(theta)**8 + 3.04376255286057e+49*cos(theta)**6 - 8.4705822435823e+47*cos(theta)**4 + 8.4705822435823e+45*cos(theta)**2 - 1.28928192444175e+43)*cos(27*phi)

@torch.jit.script
def Yl45_m28(theta, phi):
    return 1.07350889938001e-45*(1.0 - cos(theta)**2)**14*(9.92443082243452e+53*cos(theta)**17 - 1.51654223803494e+54*cos(theta)**15 + 9.15154798814187e+53*cos(theta)**13 - 2.79929703166692e+53*cos(theta)**11 + 4.637389660894e+52*cos(theta)**9 - 4.12212414301689e+51*cos(theta)**7 + 1.82625753171634e+50*cos(theta)**5 - 3.38823289743292e+48*cos(theta)**3 + 1.69411644871646e+46*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl45_m29(theta, phi):
    return 3.02667178711212e-47*(1.0 - cos(theta)**2)**14.5*(1.68715323981387e+55*cos(theta)**16 - 2.27481335705241e+55*cos(theta)**14 + 1.18970123845844e+55*cos(theta)**12 - 3.07922673483362e+54*cos(theta)**10 + 4.1736506948046e+53*cos(theta)**8 - 2.88548690011182e+52*cos(theta)**6 + 9.13128765858172e+50*cos(theta)**4 - 1.01646986922988e+49*cos(theta)**2 + 1.69411644871646e+46)*cos(29*phi)

@torch.jit.script
def Yl45_m30(theta, phi):
    return 8.73724885518915e-49*(1.0 - cos(theta)**2)**15*(2.69944518370219e+56*cos(theta)**15 - 3.18473869987337e+56*cos(theta)**13 + 1.42764148615013e+56*cos(theta)**11 - 3.07922673483362e+55*cos(theta)**9 + 3.33892055584368e+54*cos(theta)**7 - 1.73129214006709e+53*cos(theta)**5 + 3.65251506343269e+51*cos(theta)**3 - 2.03293973845975e+49*cos(theta))*cos(30*phi)

@torch.jit.script
def Yl45_m31(theta, phi):
    return 2.5877497770366e-50*(1.0 - cos(theta)**2)**15.5*(4.04916777555328e+57*cos(theta)**14 - 4.14016030983538e+57*cos(theta)**12 + 1.57040563476514e+57*cos(theta)**10 - 2.77130406135025e+56*cos(theta)**8 + 2.33724438909058e+55*cos(theta)**6 - 8.65646070033547e+53*cos(theta)**4 + 1.09575451902981e+52*cos(theta)**2 - 2.03293973845975e+49)*cos(31*phi)

@torch.jit.script
def Yl45_m32(theta, phi):
    return 7.88157294590393e-52*(1.0 - cos(theta)**2)**16*(5.6688348857746e+58*cos(theta)**13 - 4.96819237180246e+58*cos(theta)**11 + 1.57040563476514e+58*cos(theta)**9 - 2.2170432490802e+57*cos(theta)**7 + 1.40234663345435e+56*cos(theta)**5 - 3.46258428013419e+54*cos(theta)**3 + 2.19150903805961e+52*cos(theta))*cos(32*phi)

@torch.jit.script
def Yl45_m33(theta, phi):
    return 2.47510667794732e-53*(1.0 - cos(theta)**2)**16.5*(7.36948535150698e+59*cos(theta)**12 - 5.4650116089827e+59*cos(theta)**10 + 1.41336507128863e+59*cos(theta)**8 - 1.55193027435614e+58*cos(theta)**6 + 7.01173316727173e+56*cos(theta)**4 - 1.03877528404026e+55*cos(theta)**2 + 2.19150903805961e+52)*cos(33*phi)

@torch.jit.script
def Yl45_m34(theta, phi):
    return 8.03877277932851e-55*(1.0 - cos(theta)**2)**17*(8.84338242180837e+60*cos(theta)**11 - 5.4650116089827e+60*cos(theta)**9 + 1.1306920570309e+60*cos(theta)**7 - 9.31158164613686e+58*cos(theta)**5 + 2.80469326690869e+57*cos(theta)**3 - 2.07755056808051e+55*cos(theta))*cos(34*phi)

@torch.jit.script
def Yl45_m35(theta, phi):
    return 2.70986975109827e-56*(1.0 - cos(theta)**2)**17.5*(9.72772066398921e+61*cos(theta)**10 - 4.91851044808443e+61*cos(theta)**8 + 7.91484439921633e+60*cos(theta)**6 - 4.65579082306843e+59*cos(theta)**4 + 8.41407980072608e+57*cos(theta)**2 - 2.07755056808051e+55)*cos(35*phi)

@torch.jit.script
def Yl45_m36(theta, phi):
    return 9.52151175096011e-58*(1.0 - cos(theta)**2)**18*(9.72772066398921e+62*cos(theta)**9 - 3.93480835846755e+62*cos(theta)**7 + 4.7489066395298e+61*cos(theta)**5 - 1.86231632922737e+60*cos(theta)**3 + 1.68281596014522e+58*cos(theta))*cos(36*phi)

@torch.jit.script
def Yl45_m37(theta, phi):
    return 3.50491691066036e-59*(1.0 - cos(theta)**2)**18.5*(8.75494859759029e+63*cos(theta)**8 - 2.75436585092728e+63*cos(theta)**6 + 2.3744533197649e+62*cos(theta)**4 - 5.58694898768211e+60*cos(theta)**2 + 1.68281596014522e+58)*cos(37*phi)

@torch.jit.script
def Yl45_m38(theta, phi):
    return 1.36017155138303e-60*(1.0 - cos(theta)**2)**19*(7.00395887807223e+64*cos(theta)**7 - 1.65261951055637e+64*cos(theta)**5 + 9.49781327905959e+62*cos(theta)**3 - 1.11738979753642e+61*cos(theta))*cos(38*phi)

@torch.jit.script
def Yl45_m39(theta, phi):
    return 5.60925293810759e-62*(1.0 - cos(theta)**2)**19.5*(4.90277121465056e+65*cos(theta)**6 - 8.26309755278185e+64*cos(theta)**4 + 2.84934398371788e+63*cos(theta)**2 - 1.11738979753642e+61)*cos(39*phi)

@torch.jit.script
def Yl45_m40(theta, phi):
    return 2.4838189493738e-63*(1.0 - cos(theta)**2)**20*(2.94166272879034e+66*cos(theta)**5 - 3.30523902111274e+65*cos(theta)**3 + 5.69868796743576e+63*cos(theta))*cos(40*phi)

@torch.jit.script
def Yl45_m41(theta, phi):
    return 1.19780385990637e-64*(1.0 - cos(theta)**2)**20.5*(1.47083136439517e+67*cos(theta)**4 - 9.91571706333822e+65*cos(theta)**2 + 5.69868796743576e+63)*cos(41*phi)

@torch.jit.script
def Yl45_m42(theta, phi):
    return 6.42090266241355e-66*(1.0 - cos(theta)**2)**21*(5.88332545758067e+67*cos(theta)**3 - 1.98314341266764e+66*cos(theta))*cos(42*phi)

@torch.jit.script
def Yl45_m43(theta, phi):
    return 3.95179241074826e-67*(1.0 - cos(theta)**2)**21.5*(1.7649976372742e+68*cos(theta)**2 - 1.98314341266764e+66)*cos(43*phi)

@torch.jit.script
def Yl45_m44(theta, phi):
    return 10.4558235531102*(1.0 - cos(theta)**2)**22*cos(44*phi)*cos(theta)

@torch.jit.script
def Yl45_m45(theta, phi):
    return 1.10214057468876*(1.0 - cos(theta)**2)**22.5*cos(45*phi)

@torch.jit.script
def Yl46_m_minus_46(theta, phi):
    return 1.1081142800943*(1.0 - cos(theta)**2)**23*sin(46*phi)

@torch.jit.script
def Yl46_m_minus_45(theta, phi):
    return 10.6286587918185*(1.0 - cos(theta)**2)**22.5*sin(45*phi)*cos(theta)

@torch.jit.script
def Yl46_m_minus_44(theta, phi):
    return 4.46373745781704e-69*(1.0 - cos(theta)**2)**22*(1.60614784991952e+70*cos(theta)**2 - 1.7649976372742e+68)*sin(44*phi)

@torch.jit.script
def Yl46_m_minus_43(theta, phi):
    return 7.33466908928147e-68*(1.0 - cos(theta)**2)**21.5*(5.35382616639841e+69*cos(theta)**3 - 1.7649976372742e+68*cos(theta))*sin(43*phi)

@torch.jit.script
def Yl46_m_minus_42(theta, phi):
    return 1.3839025959632e-66*(1.0 - cos(theta)**2)**21*(1.3384565415996e+69*cos(theta)**4 - 8.82498818637101e+67*cos(theta)**2 + 4.95785853166911e+65)*sin(42*phi)

@torch.jit.script
def Yl46_m_minus_41(theta, phi):
    return 2.9028985753037e-65*(1.0 - cos(theta)**2)**20.5*(2.67691308319921e+68*cos(theta)**5 - 2.94166272879034e+67*cos(theta)**3 + 4.95785853166911e+65*cos(theta))*sin(41*phi)

@torch.jit.script
def Yl46_m_minus_40(theta, phi):
    return 6.63234506965458e-64*(1.0 - cos(theta)**2)**20*(4.46152180533201e+67*cos(theta)**6 - 7.35415682197584e+66*cos(theta)**4 + 2.47892926583455e+65*cos(theta)**2 - 9.49781327905959e+62)*sin(40*phi)

@torch.jit.script
def Yl46_m_minus_39(theta, phi):
    return 1.62729151279139e-62*(1.0 - cos(theta)**2)**19.5*(6.37360257904573e+66*cos(theta)**7 - 1.47083136439517e+66*cos(theta)**5 + 8.26309755278185e+64*cos(theta)**3 - 9.49781327905959e+62*cos(theta))*sin(39*phi)

@torch.jit.script
def Yl46_m_minus_38(theta, phi):
    return 4.24345709766218e-61*(1.0 - cos(theta)**2)**19*(7.96700322380716e+65*cos(theta)**8 - 2.45138560732528e+65*cos(theta)**6 + 2.06577438819546e+64*cos(theta)**4 - 4.7489066395298e+62*cos(theta)**2 + 1.39673724692053e+60)*sin(38*phi)

@torch.jit.script
def Yl46_m_minus_37(theta, phi):
    return 1.16675780150007e-59*(1.0 - cos(theta)**2)**18.5*(8.85222580423018e+64*cos(theta)**9 - 3.50197943903612e+64*cos(theta)**7 + 4.13154877639092e+63*cos(theta)**5 - 1.58296887984327e+62*cos(theta)**3 + 1.39673724692053e+60*cos(theta))*sin(37*phi)

@torch.jit.script
def Yl46_m_minus_36(theta, phi):
    return 3.36139662478243e-58*(1.0 - cos(theta)**2)**18*(8.85222580423018e+63*cos(theta)**10 - 4.37747429879514e+63*cos(theta)**8 + 6.88591462731821e+62*cos(theta)**6 - 3.95742219960816e+61*cos(theta)**4 + 6.98368623460264e+59*cos(theta)**2 - 1.68281596014521e+57)*sin(36*phi)

@torch.jit.script
def Yl46_m_minus_35(theta, phi):
    return 1.00953883118615e-56*(1.0 - cos(theta)**2)**17.5*(8.04747800384562e+62*cos(theta)**11 - 4.8638603319946e+62*cos(theta)**9 + 9.83702089616886e+61*cos(theta)**7 - 7.91484439921633e+60*cos(theta)**5 + 2.32789541153421e+59*cos(theta)**3 - 1.68281596014521e+57*cos(theta))*sin(35*phi)

@torch.jit.script
def Yl46_m_minus_34(theta, phi):
    return 3.14743058609061e-55*(1.0 - cos(theta)**2)**17*(6.70623166987135e+61*cos(theta)**12 - 4.86386033199461e+61*cos(theta)**10 + 1.22962761202111e+61*cos(theta)**8 - 1.31914073320272e+60*cos(theta)**6 + 5.81973852883553e+58*cos(theta)**4 - 8.41407980072607e+56*cos(theta)**2 + 1.73129214006709e+54)*sin(34*phi)

@torch.jit.script
def Yl46_m_minus_33(theta, phi):
    return 1.01501586519763e-53*(1.0 - cos(theta)**2)**16.5*(5.15863974605488e+60*cos(theta)**13 - 4.42169121090419e+60*cos(theta)**11 + 1.36625290224568e+60*cos(theta)**9 - 1.88448676171817e+59*cos(theta)**7 + 1.16394770576711e+58*cos(theta)**5 - 2.80469326690869e+56*cos(theta)**3 + 1.73129214006709e+54*cos(theta))*sin(33*phi)

@torch.jit.script
def Yl46_m_minus_32(theta, phi):
    return 3.37559545932685e-52*(1.0 - cos(theta)**2)**16*(3.68474267575349e+59*cos(theta)**14 - 3.68474267575349e+59*cos(theta)**12 + 1.36625290224568e+59*cos(theta)**10 - 2.35560845214772e+58*cos(theta)**8 + 1.93991284294518e+57*cos(theta)**6 - 7.01173316727173e+55*cos(theta)**4 + 8.65646070033547e+53*cos(theta)**2 - 1.56536359861401e+51)*sin(32*phi)

@torch.jit.script
def Yl46_m_minus_31(theta, phi):
    return 1.15463129634021e-50*(1.0 - cos(theta)**2)**15.5*(2.45649511716899e+58*cos(theta)**15 - 2.8344174428873e+58*cos(theta)**13 + 1.24204809295061e+58*cos(theta)**11 - 2.61734272460857e+57*cos(theta)**9 + 2.77130406135025e+56*cos(theta)**7 - 1.40234663345435e+55*cos(theta)**5 + 2.88548690011182e+53*cos(theta)**3 - 1.56536359861401e+51*cos(theta))*sin(31*phi)

@torch.jit.script
def Yl46_m_minus_30(theta, phi):
    return 4.05273940238151e-49*(1.0 - cos(theta)**2)**15*(1.53530944823062e+57*cos(theta)**16 - 2.02458388777664e+57*cos(theta)**14 + 1.03504007745885e+57*cos(theta)**12 - 2.61734272460857e+56*cos(theta)**10 + 3.46413007668782e+55*cos(theta)**8 - 2.33724438909058e+54*cos(theta)**6 + 7.21371725027956e+52*cos(theta)**4 - 7.82681799307004e+50*cos(theta)**2 + 1.27058733653734e+48)*sin(30*phi)

@torch.jit.script
def Yl46_m_minus_29(theta, phi):
    return 1.45673292299555e-47*(1.0 - cos(theta)**2)**14.5*(9.03123204841541e+55*cos(theta)**17 - 1.34972259185109e+56*cos(theta)**15 + 7.96184674968342e+55*cos(theta)**13 - 2.37940247691689e+55*cos(theta)**11 + 3.84903341854202e+54*cos(theta)**9 - 3.33892055584368e+53*cos(theta)**7 + 1.44274345005591e+52*cos(theta)**5 - 2.60893933102335e+50*cos(theta)**3 + 1.27058733653734e+48*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl46_m_minus_28(theta, phi):
    return 5.35237852927822e-46*(1.0 - cos(theta)**2)**14*(5.01735113800856e+54*cos(theta)**18 - 8.43576619906934e+54*cos(theta)**16 + 5.68703339263102e+54*cos(theta)**14 - 1.98283539743074e+54*cos(theta)**12 + 3.84903341854202e+53*cos(theta)**10 - 4.1736506948046e+52*cos(theta)**8 + 2.40457241675985e+51*cos(theta)**6 - 6.52234832755837e+49*cos(theta)**4 + 6.35293668268672e+47*cos(theta)**2 - 9.41175804842478e+44)*sin(28*phi)

@torch.jit.script
def Yl46_m_minus_27(theta, phi):
    return 2.00696352793153e-44*(1.0 - cos(theta)**2)**13.5*(2.64071112526766e+53*cos(theta)**19 - 4.96221541121726e+53*cos(theta)**17 + 3.79135559508734e+53*cos(theta)**15 - 1.52525799802364e+53*cos(theta)**13 + 3.49912128958366e+52*cos(theta)**11 - 4.637389660894e+51*cos(theta)**9 + 3.43510345251407e+50*cos(theta)**7 - 1.30446966551167e+49*cos(theta)**5 + 2.11764556089557e+47*cos(theta)**3 - 9.41175804842478e+44*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl46_m_minus_26(theta, phi):
    return 7.66859687268355e-43*(1.0 - cos(theta)**2)**13*(1.32035556263383e+52*cos(theta)**20 - 2.75678633956514e+52*cos(theta)**18 + 2.36959724692959e+52*cos(theta)**16 - 1.08946999858832e+52*cos(theta)**14 + 2.91593440798638e+51*cos(theta)**12 - 4.637389660894e+50*cos(theta)**10 + 4.29387931564259e+49*cos(theta)**8 - 2.17411610918612e+48*cos(theta)**6 + 5.29411390223894e+46*cos(theta)**4 - 4.70587902421239e+44*cos(theta)**2 + 6.44640962220875e+41)*sin(26*phi)

@torch.jit.script
def Yl46_m_minus_25(theta, phi):
    return 2.98189127114901e-41*(1.0 - cos(theta)**2)**12.5*(6.28740744111349e+50*cos(theta)**21 - 1.4509401787185e+51*cos(theta)**19 + 1.39388073348799e+51*cos(theta)**17 - 7.26313332392212e+50*cos(theta)**15 + 2.24302646768183e+50*cos(theta)**13 - 4.21580878263091e+49*cos(theta)**11 + 4.77097701738066e+48*cos(theta)**9 - 3.10588015598018e+47*cos(theta)**7 + 1.05882278044779e+46*cos(theta)**5 - 1.56862634140413e+44*cos(theta)**3 + 6.44640962220875e+41*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl46_m_minus_24(theta, phi):
    return 1.17850741252294e-39*(1.0 - cos(theta)**2)**12*(2.8579124732334e+49*cos(theta)**22 - 7.25470089359249e+49*cos(theta)**20 + 7.74378185271108e+49*cos(theta)**18 - 4.53945832745132e+49*cos(theta)**16 + 1.60216176262988e+49*cos(theta)**14 - 3.51317398552576e+48*cos(theta)**12 + 4.77097701738066e+47*cos(theta)**10 - 3.88235019497522e+46*cos(theta)**8 + 1.76470463407965e+45*cos(theta)**6 - 3.92156585351032e+43*cos(theta)**4 + 3.22320481110438e+41*cos(theta)**2 - 4.12702280551136e+38)*sin(24*phi)

@torch.jit.script
def Yl46_m_minus_23(theta, phi):
    return 4.72873804667603e-38*(1.0 - cos(theta)**2)**11.5*(1.24257064053626e+48*cos(theta)**23 - 3.45461947313928e+48*cos(theta)**21 + 4.07567465932162e+48*cos(theta)**19 - 2.67026960438313e+48*cos(theta)**17 + 1.06810784175325e+48*cos(theta)**15 - 2.70244152732751e+47*cos(theta)**13 + 4.33725183398242e+46*cos(theta)**11 - 4.31372243886136e+45*cos(theta)**9 + 2.52100662011378e+44*cos(theta)**7 - 7.84313170702065e+42*cos(theta)**5 + 1.07440160370146e+41*cos(theta)**3 - 4.12702280551136e+38*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl46_m_minus_22(theta, phi):
    return 1.92431171017896e-36*(1.0 - cos(theta)**2)**11*(5.17737766890109e+46*cos(theta)**24 - 1.57028157869967e+47*cos(theta)**22 + 2.03783732966081e+47*cos(theta)**20 - 1.48348311354618e+47*cos(theta)**18 + 6.67567401095783e+46*cos(theta)**16 - 1.9303153766625e+46*cos(theta)**14 + 3.61437652831868e+45*cos(theta)**12 - 4.31372243886136e+44*cos(theta)**10 + 3.15125827514222e+43*cos(theta)**8 - 1.30718861783677e+42*cos(theta)**6 + 2.68600400925365e+40*cos(theta)**4 - 2.06351140275568e+38*cos(theta)**2 + 2.49216352989817e+35)*sin(22*phi)

@torch.jit.script
def Yl46_m_minus_21(theta, phi):
    return 7.93414043768083e-35*(1.0 - cos(theta)**2)**10.5*(2.07095106756044e+45*cos(theta)**25 - 6.82731121173771e+45*cos(theta)**23 + 9.7039872840991e+45*cos(theta)**21 - 7.80780586076939e+45*cos(theta)**19 + 3.92686706526931e+45*cos(theta)**17 - 1.286876917775e+45*cos(theta)**15 + 2.78028963716822e+44*cos(theta)**13 - 3.92156585351032e+43*cos(theta)**11 + 3.50139808349136e+42*cos(theta)**9 - 1.86741231119539e+41*cos(theta)**7 + 5.37200801850729e+39*cos(theta)**5 - 6.87837134251894e+37*cos(theta)**3 + 2.49216352989817e+35*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl46_m_minus_20(theta, phi):
    return 3.31149389509621e-33*(1.0 - cos(theta)**2)**10*(7.96519641369399e+43*cos(theta)**26 - 2.84471300489071e+44*cos(theta)**24 + 4.41090331095414e+44*cos(theta)**22 - 3.90390293038469e+44*cos(theta)**20 + 2.18159281403851e+44*cos(theta)**18 - 8.04298073609377e+43*cos(theta)**16 + 1.98592116940587e+43*cos(theta)**14 - 3.26797154459194e+42*cos(theta)**12 + 3.50139808349136e+41*cos(theta)**10 - 2.33426538899424e+40*cos(theta)**8 + 8.95334669751215e+38*cos(theta)**6 - 1.71959283562973e+37*cos(theta)**4 + 1.24608176494908e+35*cos(theta)**2 - 1.43063348444212e+32)*sin(20*phi)

@torch.jit.script
def Yl46_m_minus_19(theta, phi):
    return 1.39790548387065e-31*(1.0 - cos(theta)**2)**9.5*(2.95007274581259e+42*cos(theta)**27 - 1.13788520195628e+43*cos(theta)**25 + 1.91778404824093e+43*cos(theta)**23 - 1.85900139542128e+43*cos(theta)**21 + 1.14820674423079e+43*cos(theta)**19 - 4.73116513887869e+42*cos(theta)**17 + 1.32394744627058e+42*cos(theta)**15 - 2.51382426507072e+41*cos(theta)**13 + 3.18308916681033e+40*cos(theta)**11 - 2.5936282099936e+39*cos(theta)**9 + 1.27904952821602e+38*cos(theta)**7 - 3.43918567125947e+36*cos(theta)**5 + 4.15360588316361e+34*cos(theta)**3 - 1.43063348444212e+32*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl46_m_minus_18(theta, phi):
    return 5.96366861096496e-30*(1.0 - cos(theta)**2)**9*(1.05359740921878e+41*cos(theta)**28 - 4.37648154598571e+41*cos(theta)**26 + 7.99076686767054e+41*cos(theta)**24 - 8.45000634282401e+41*cos(theta)**22 + 5.74103372115396e+41*cos(theta)**20 - 2.62842507715483e+41*cos(theta)**18 + 8.27467153919112e+40*cos(theta)**16 - 1.7955887607648e+40*cos(theta)**14 + 2.65257430567527e+39*cos(theta)**12 - 2.5936282099936e+38*cos(theta)**10 + 1.59881191027003e+37*cos(theta)**8 - 5.73197611876578e+35*cos(theta)**6 + 1.0384014707909e+34*cos(theta)**4 - 7.15316742221058e+31*cos(theta)**2 + 7.86062354089075e+28)*sin(18*phi)

@torch.jit.script
def Yl46_m_minus_17(theta, phi):
    return 2.56922706601449e-28*(1.0 - cos(theta)**2)**8.5*(3.63309451454752e+39*cos(theta)**29 - 1.62091909110582e+40*cos(theta)**27 + 3.19630674706821e+40*cos(theta)**25 - 3.67391580122783e+40*cos(theta)**23 + 2.73382558150189e+40*cos(theta)**21 - 1.38338161955517e+40*cos(theta)**19 + 4.86745384658301e+39*cos(theta)**17 - 1.1970591738432e+39*cos(theta)**15 + 2.04044177359636e+38*cos(theta)**13 - 2.35784382726691e+37*cos(theta)**11 + 1.77645767807781e+36*cos(theta)**9 - 8.18853731252255e+34*cos(theta)**7 + 2.07680294158181e+33*cos(theta)**5 - 2.38438914073686e+31*cos(theta)**3 + 7.86062354089075e+28*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl46_m_minus_16(theta, phi):
    return 1.11694912080369e-26*(1.0 - cos(theta)**2)**8*(1.21103150484917e+38*cos(theta)**30 - 5.78899675394935e+38*cos(theta)**28 + 1.22934874887239e+39*cos(theta)**26 - 1.5307982505116e+39*cos(theta)**24 + 1.24264799159177e+39*cos(theta)**22 - 6.91690809777586e+38*cos(theta)**20 + 2.70414102587945e+38*cos(theta)**18 - 7.48161983652e+37*cos(theta)**16 + 1.45745840971169e+37*cos(theta)**14 - 1.96486985605576e+36*cos(theta)**12 + 1.77645767807781e+35*cos(theta)**10 - 1.02356716406532e+34*cos(theta)**8 + 3.46133823596968e+32*cos(theta)**6 - 5.96097285184215e+30*cos(theta)**4 + 3.93031177044537e+28*cos(theta)**2 - 4.15906007454537e+25)*sin(16*phi)

@torch.jit.script
def Yl46_m_minus_15(theta, phi):
    return 4.89677424487597e-25*(1.0 - cos(theta)**2)**7.5*(3.90655324144895e+36*cos(theta)**31 - 1.99620577722391e+37*cos(theta)**29 + 4.55314351434219e+37*cos(theta)**27 - 6.12319300204639e+37*cos(theta)**25 + 5.40281735474681e+37*cos(theta)**23 - 3.29376576084565e+37*cos(theta)**21 + 1.42323211888392e+37*cos(theta)**19 - 4.40095284501176e+36*cos(theta)**17 + 9.71638939807792e+35*cos(theta)**15 - 1.51143835081212e+35*cos(theta)**13 + 1.61496152552528e+34*cos(theta)**11 - 1.13729684896146e+33*cos(theta)**9 + 4.94476890852811e+31*cos(theta)**7 - 1.19219457036843e+30*cos(theta)**5 + 1.31010392348179e+28*cos(theta)**3 - 4.15906007454537e+25*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl46_m_minus_14(theta, phi):
    return 2.16346557417279e-23*(1.0 - cos(theta)**2)**7*(1.2207978879528e+35*cos(theta)**32 - 6.65401925741305e+35*cos(theta)**30 + 1.62612268369364e+36*cos(theta)**28 - 2.3550742315563e+36*cos(theta)**26 + 2.25117389781117e+36*cos(theta)**24 - 1.49716625492984e+36*cos(theta)**22 + 7.11616059441961e+35*cos(theta)**20 - 2.44497380278431e+35*cos(theta)**18 + 6.0727433737987e+34*cos(theta)**16 - 1.07959882200866e+34*cos(theta)**14 + 1.34580127127107e+33*cos(theta)**12 - 1.13729684896146e+32*cos(theta)**10 + 6.18096113566013e+30*cos(theta)**8 - 1.98699095061405e+29*cos(theta)**6 + 3.27525980870448e+27*cos(theta)**4 - 2.07953003727268e+25*cos(theta)**2 + 2.13066602179578e+22)*sin(14*phi)

@torch.jit.script
def Yl46_m_minus_13(theta, phi):
    return 9.62681407083826e-22*(1.0 - cos(theta)**2)**6.5*(3.6993875392509e+33*cos(theta)**33 - 2.14645782497195e+34*cos(theta)**31 + 5.60731959894358e+34*cos(theta)**29 - 8.72249715391223e+34*cos(theta)**27 + 9.00469559124469e+34*cos(theta)**25 - 6.50941849969495e+34*cos(theta)**23 + 3.38864790210458e+34*cos(theta)**21 - 1.2868283172549e+34*cos(theta)**19 + 3.57220198458747e+33*cos(theta)**17 - 7.19732548005772e+32*cos(theta)**15 + 1.03523174713159e+32*cos(theta)**13 - 1.0339062263286e+31*cos(theta)**11 + 6.86773459517793e+29*cos(theta)**9 - 2.83855850087721e+28*cos(theta)**7 + 6.55051961740896e+26*cos(theta)**5 - 6.93176679090895e+24*cos(theta)**3 + 2.13066602179578e+22*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl46_m_minus_12(theta, phi):
    return 4.31169516088401e-20*(1.0 - cos(theta)**2)**6*(1.08805515860321e+32*cos(theta)**34 - 6.70768070303734e+32*cos(theta)**32 + 1.86910653298119e+33*cos(theta)**30 - 3.11517755496865e+33*cos(theta)**28 + 3.46334445817103e+33*cos(theta)**26 - 2.71225770820623e+33*cos(theta)**24 + 1.54029450095663e+33*cos(theta)**22 - 6.43414158627451e+32*cos(theta)**20 + 1.98455665810415e+32*cos(theta)**18 - 4.49832842503608e+31*cos(theta)**16 + 7.39451247951136e+30*cos(theta)**14 - 8.61588521940504e+29*cos(theta)**12 + 6.86773459517793e+28*cos(theta)**10 - 3.54819812609652e+27*cos(theta)**8 + 1.09175326956816e+26*cos(theta)**6 - 1.73294169772724e+24*cos(theta)**4 + 1.06533301089789e+22*cos(theta)**2 - 1.06214657118434e+19)*sin(12*phi)

@torch.jit.script
def Yl46_m_minus_11(theta, phi):
    return 1.9426567317875e-18*(1.0 - cos(theta)**2)**5.5*(3.10872902458059e+30*cos(theta)**35 - 2.03263051607192e+31*cos(theta)**33 + 6.02937591284256e+31*cos(theta)**31 - 1.07419915688574e+32*cos(theta)**29 + 1.28272016969298e+32*cos(theta)**27 - 1.08490308328249e+32*cos(theta)**25 + 6.69693261285489e+31*cos(theta)**23 - 3.063876945845e+31*cos(theta)**21 + 1.04450350426534e+31*cos(theta)**19 - 2.64607554413887e+30*cos(theta)**17 + 4.9296749863409e+29*cos(theta)**15 - 6.62760401492695e+28*cos(theta)**13 + 6.24339508652539e+27*cos(theta)**11 - 3.94244236232947e+26*cos(theta)**9 + 1.55964752795451e+25*cos(theta)**7 - 3.46588339545447e+23*cos(theta)**5 + 3.55111003632631e+21*cos(theta)**3 - 1.06214657118434e+19*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl46_m_minus_10(theta, phi):
    return 8.80004201373588e-17*(1.0 - cos(theta)**2)**5*(8.63535840161274e+28*cos(theta)**36 - 5.97832504727036e+29*cos(theta)**34 + 1.8841799727633e+30*cos(theta)**32 - 3.58066385628581e+30*cos(theta)**30 + 4.5811434631892e+30*cos(theta)**28 - 4.17270416647112e+30*cos(theta)**26 + 2.79038858868954e+30*cos(theta)**24 - 1.39267133902046e+30*cos(theta)**22 + 5.22251752132671e+29*cos(theta)**20 - 1.47004196896604e+29*cos(theta)**18 + 3.08104686646307e+28*cos(theta)**16 - 4.73400286780497e+27*cos(theta)**14 + 5.20282923877116e+26*cos(theta)**12 - 3.94244236232946e+25*cos(theta)**10 + 1.94955940994314e+24*cos(theta)**8 - 5.77647232575746e+22*cos(theta)**6 + 8.87777509081577e+20*cos(theta)**4 - 5.31073285592169e+18*cos(theta)**2 + 5.1761528810153e+15)*sin(10*phi)

@torch.jit.script
def Yl46_m_minus_9(theta, phi):
    return 4.00571107454053e-15*(1.0 - cos(theta)**2)**4.5*(2.33388064908453e+27*cos(theta)**37 - 1.70809287064867e+28*cos(theta)**35 + 5.70963628110091e+28*cos(theta)**33 - 1.15505285686639e+29*cos(theta)**31 + 1.57970464247903e+29*cos(theta)**29 - 1.5454459875819e+29*cos(theta)**27 + 1.11615543547582e+29*cos(theta)**25 - 6.05509277834981e+28*cos(theta)**23 + 2.48691310539367e+28*cos(theta)**21 - 7.73706299455809e+27*cos(theta)**19 + 1.81238050968416e+27*cos(theta)**17 - 3.15600191186998e+26*cos(theta)**15 + 4.00217633751628e+25*cos(theta)**13 - 3.5840385112086e+24*cos(theta)**11 + 2.16617712215905e+23*cos(theta)**9 - 8.25210332251065e+21*cos(theta)**7 + 1.77555501816315e+20*cos(theta)**5 - 1.77024428530723e+18*cos(theta)**3 + 5.1761528810153e+15*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl46_m_minus_8(theta, phi):
    return 1.83127161651504e-13*(1.0 - cos(theta)**2)**4*(6.14179118180138e+25*cos(theta)**38 - 4.74470241846854e+26*cos(theta)**36 + 1.67930478855909e+27*cos(theta)**34 - 3.60954017770747e+27*cos(theta)**32 + 5.26568214159678e+27*cos(theta)**30 - 5.51944995564964e+27*cos(theta)**28 + 4.29290552106083e+27*cos(theta)**26 - 2.52295532431242e+27*cos(theta)**24 + 1.13041504790621e+27*cos(theta)**22 - 3.86853149727905e+26*cos(theta)**20 + 1.00687806093564e+26*cos(theta)**18 - 1.97250119491874e+25*cos(theta)**16 + 2.8586973839402e+24*cos(theta)**14 - 2.9866987593405e+23*cos(theta)**12 + 2.16617712215905e+22*cos(theta)**10 - 1.03151291531383e+21*cos(theta)**8 + 2.95925836360525e+19*cos(theta)**6 - 4.42561071326808e+17*cos(theta)**4 + 2.58807644050765e+15*cos(theta)**2 - 2476628172734.59)*sin(8*phi)

@torch.jit.script
def Yl46_m_minus_7(theta, phi):
    return 8.4039207365689e-12*(1.0 - cos(theta)**2)**3.5*(1.57481825174394e+24*cos(theta)**39 - 1.2823520049915e+25*cos(theta)**37 + 4.7980136815974e+25*cos(theta)**35 - 1.09380005385075e+26*cos(theta)**33 + 1.69860714245057e+26*cos(theta)**31 - 1.90325860539643e+26*cos(theta)**29 + 1.58996500780031e+26*cos(theta)**27 - 1.00918212972497e+26*cos(theta)**25 + 4.91484803437485e+25*cos(theta)**23 - 1.84215785584716e+25*cos(theta)**21 + 5.29935821545075e+24*cos(theta)**19 - 1.16029482054043e+24*cos(theta)**17 + 1.90579825596013e+23*cos(theta)**15 - 2.29746058410808e+22*cos(theta)**13 + 1.9692519292355e+21*cos(theta)**11 - 1.14612546145981e+20*cos(theta)**9 + 4.22751194800751e+18*cos(theta)**7 - 8.85122142653616e+16*cos(theta)**5 + 862692146835883.0*cos(theta)**3 - 2476628172734.59*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl46_m_minus_6(theta, phi):
    return 3.86945569224729e-10*(1.0 - cos(theta)**2)**3*(3.93704562935986e+22*cos(theta)**40 - 3.37461053945131e+23*cos(theta)**38 + 1.3327815782215e+24*cos(theta)**36 - 3.21705898191397e+24*cos(theta)**34 + 5.30814732015804e+24*cos(theta)**32 - 6.34419535132142e+24*cos(theta)**30 + 5.67844645642967e+24*cos(theta)**28 - 3.88146972971142e+24*cos(theta)**26 + 2.04785334765619e+24*cos(theta)**24 - 8.3734447993053e+23*cos(theta)**22 + 2.64967910772537e+23*cos(theta)**20 - 6.44608233633574e+22*cos(theta)**18 + 1.19112390997508e+22*cos(theta)**16 - 1.64104327436291e+21*cos(theta)**14 + 1.64104327436291e+20*cos(theta)**12 - 1.14612546145981e+19*cos(theta)**10 + 5.28438993500938e+17*cos(theta)**8 - 1.47520357108936e+16*cos(theta)**6 + 215673036708971.0*cos(theta)**4 - 1238314086367.3*cos(theta)**2 + 1168220836.19556)*sin(6*phi)

@torch.jit.script
def Yl46_m_minus_5(theta, phi):
    return 1.78666643331353e-8*(1.0 - cos(theta)**2)**2.5*(9.60255031551185e+20*cos(theta)**41 - 8.65284753705464e+21*cos(theta)**39 + 3.60211237357162e+22*cos(theta)**37 - 9.19159709118276e+22*cos(theta)**35 + 1.60852949095698e+23*cos(theta)**33 - 2.04651462945852e+23*cos(theta)**31 + 1.95808498497575e+23*cos(theta)**29 - 1.4375813813746e+23*cos(theta)**27 + 8.19141339062474e+22*cos(theta)**25 - 3.640628173611e+22*cos(theta)**23 + 1.2617519560597e+22*cos(theta)**21 - 3.39267491386091e+21*cos(theta)**19 + 7.00661123514754e+20*cos(theta)**17 - 1.09402884957528e+20*cos(theta)**15 + 1.26234098027916e+19*cos(theta)**13 - 1.04193223769074e+18*cos(theta)**11 + 5.87154437223265e+16*cos(theta)**9 - 2.1074336729848e+15*cos(theta)**7 + 43134607341794.1*cos(theta)**5 - 412771362122.432*cos(theta)**3 + 1168220836.19556*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl46_m_minus_4(theta, phi):
    return 8.26900418061119e-7*(1.0 - cos(theta)**2)**2*(2.2863215036933e+19*cos(theta)**42 - 2.16321188426366e+20*cos(theta)**40 + 9.47924308834637e+20*cos(theta)**38 - 2.55322141421743e+21*cos(theta)**36 + 4.73096909104995e+21*cos(theta)**34 - 6.39535821705788e+21*cos(theta)**32 + 6.52694994991916e+21*cos(theta)**30 - 5.134219219195e+21*cos(theta)**28 + 3.15054361177875e+21*cos(theta)**26 - 1.51692840567125e+21*cos(theta)**24 + 5.73523616390774e+20*cos(theta)**22 - 1.69633745693046e+20*cos(theta)**20 + 3.89256179730419e+19*cos(theta)**18 - 6.83768030984548e+18*cos(theta)**16 + 9.01672128770832e+17*cos(theta)**14 - 8.68276864742283e+16*cos(theta)**12 + 5.87154437223265e+15*cos(theta)**10 - 263429209123100.0*cos(theta)**8 + 7189101223632.36*cos(theta)**6 - 103192840530.608*cos(theta)**4 + 584110418.097781*cos(theta)**2 - 545387.878709413)*sin(4*phi)

@torch.jit.script
def Yl46_m_minus_3(theta, phi):
    return 3.83417950543236e-5*(1.0 - cos(theta)**2)**1.5*(5.31702675277511e+17*cos(theta)**43 - 5.27612654698454e+18*cos(theta)**41 + 2.43057515085804e+19*cos(theta)**39 - 6.90059841680387e+19*cos(theta)**37 + 1.3517054545857e+20*cos(theta)**35 - 1.93798733850239e+20*cos(theta)**33 + 2.10546772578037e+20*cos(theta)**31 - 1.77042042041207e+20*cos(theta)**29 + 1.1668680043625e+20*cos(theta)**27 - 6.067713622685e+19*cos(theta)**25 + 2.49358094082945e+19*cos(theta)**23 - 8.07779741395456e+18*cos(theta)**21 + 2.04871673542326e+18*cos(theta)**19 - 4.0221648881444e+17*cos(theta)**17 + 6.01114752513888e+16*cos(theta)**15 - 6.67905280570987e+15*cos(theta)**13 + 533776761112059.0*cos(theta)**11 - 29269912124788.9*cos(theta)**9 + 1027014460518.91*cos(theta)**7 - 20638568106.1216*cos(theta)**5 + 194703472.69926*cos(theta)**3 - 545387.878709413*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl46_m_minus_2(theta, phi):
    return 0.00178031487177454*(1.0 - cos(theta)**2)*(1.20841517108525e+16*cos(theta)**44 - 1.25622060642489e+17*cos(theta)**42 + 6.07643787714511e+17*cos(theta)**40 - 1.81594695179049e+18*cos(theta)**38 + 3.75473737384917e+18*cos(theta)**36 - 5.69996276030114e+18*cos(theta)**34 + 6.57958664306367e+18*cos(theta)**32 - 5.90140140137356e+18*cos(theta)**30 + 4.16738572986607e+18*cos(theta)**28 - 2.333736008725e+18*cos(theta)**26 + 1.03899205867894e+18*cos(theta)**24 - 3.67172609725207e+17*cos(theta)**22 + 1.02435836771163e+17*cos(theta)**20 - 2.23453604896911e+16*cos(theta)**18 + 3.7569672032118e+15*cos(theta)**16 - 477075200407848.0*cos(theta)**14 + 44481396759338.3*cos(theta)**12 - 2926991212478.89*cos(theta)**10 + 128376807564.864*cos(theta)**8 - 3439761351.02027*cos(theta)**6 + 48675868.1748151*cos(theta)**4 - 272693.939354706*cos(theta)**2 + 252.962837991379)*sin(2*phi)

@torch.jit.script
def Yl46_m_minus_1(theta, phi):
    return 0.0827415581926583*(1.0 - cos(theta)**2)**0.5*(268536704685612.0*cos(theta)**45 - 2.92144327075556e+15*cos(theta)**43 + 1.48205801881588e+16*cos(theta)**41 - 4.65627423536024e+16*cos(theta)**39 + 1.0147938848241e+17*cos(theta)**37 - 1.62856078865747e+17*cos(theta)**35 + 1.99381413426172e+17*cos(theta)**33 - 1.90367787141083e+17*cos(theta)**31 + 1.43702956202278e+17*cos(theta)**29 - 8.64346669898148e+16*cos(theta)**27 + 4.15596823471575e+16*cos(theta)**25 - 1.59640265097916e+16*cos(theta)**23 + 4.87789698910299e+15*cos(theta)**21 - 1.17607160472058e+15*cos(theta)**19 + 220998070777165.0*cos(theta)**17 - 31805013360523.2*cos(theta)**15 + 3421645904564.48*cos(theta)**13 - 266090110225.353*cos(theta)**11 + 14264089729.4293*cos(theta)**9 - 491394478.717181*cos(theta)**7 + 9735173.63496302*cos(theta)**5 - 90897.9797849021*cos(theta)**3 + 252.962837991379*cos(theta))*sin(phi)

@torch.jit.script
def Yl46_m0(theta, phi):
    return 15881165287450.2*cos(theta)**46 - 180626440357263.0*cos(theta)**44 + 959958497629049.0*cos(theta)**42 - 3.16675964160387e+15*cos(theta)**40 + 7.26491917779712e+15*cos(theta)**38 - 1.23065980288949e+16*cos(theta)**36 + 1.59529974448637e+16*cos(theta)**34 - 1.61837822180263e+16*cos(theta)**32 + 1.30310973703589e+16*cos(theta)**30 - 8.39781830534237e+15*cos(theta)**28 + 4.34845934167043e+15*cos(theta)**26 - 1.80953813833917e+15*cos(theta)**24 + 603179379446390.0*cos(theta)**22 - 159970650576482.0*cos(theta)**20 + 33400465504979.8*cos(theta)**18 - 5407694415091.97*cos(theta)**16 + 664880460871.963*cos(theta)**14 - 60323152481.903*cos(theta)**12 + 3880436709.36218*cos(theta)**10 - 167100145.379233*cos(theta)**8 + 4413966.10435709*cos(theta)**6 - 61820.2535624242*cos(theta)**4 + 344.083043946702*cos(theta)**2 - 0.318300688202315

@torch.jit.script
def Yl46_m1(theta, phi):
    return 0.0827415581926583*(1.0 - cos(theta)**2)**0.5*(268536704685612.0*cos(theta)**45 - 2.92144327075556e+15*cos(theta)**43 + 1.48205801881588e+16*cos(theta)**41 - 4.65627423536024e+16*cos(theta)**39 + 1.0147938848241e+17*cos(theta)**37 - 1.62856078865747e+17*cos(theta)**35 + 1.99381413426172e+17*cos(theta)**33 - 1.90367787141083e+17*cos(theta)**31 + 1.43702956202278e+17*cos(theta)**29 - 8.64346669898148e+16*cos(theta)**27 + 4.15596823471575e+16*cos(theta)**25 - 1.59640265097916e+16*cos(theta)**23 + 4.87789698910299e+15*cos(theta)**21 - 1.17607160472058e+15*cos(theta)**19 + 220998070777165.0*cos(theta)**17 - 31805013360523.2*cos(theta)**15 + 3421645904564.48*cos(theta)**13 - 266090110225.353*cos(theta)**11 + 14264089729.4293*cos(theta)**9 - 491394478.717181*cos(theta)**7 + 9735173.63496302*cos(theta)**5 - 90897.9797849021*cos(theta)**3 + 252.962837991379*cos(theta))*cos(phi)

@torch.jit.script
def Yl46_m2(theta, phi):
    return 0.00178031487177454*(1.0 - cos(theta)**2)*(1.20841517108525e+16*cos(theta)**44 - 1.25622060642489e+17*cos(theta)**42 + 6.07643787714511e+17*cos(theta)**40 - 1.81594695179049e+18*cos(theta)**38 + 3.75473737384917e+18*cos(theta)**36 - 5.69996276030114e+18*cos(theta)**34 + 6.57958664306367e+18*cos(theta)**32 - 5.90140140137356e+18*cos(theta)**30 + 4.16738572986607e+18*cos(theta)**28 - 2.333736008725e+18*cos(theta)**26 + 1.03899205867894e+18*cos(theta)**24 - 3.67172609725207e+17*cos(theta)**22 + 1.02435836771163e+17*cos(theta)**20 - 2.23453604896911e+16*cos(theta)**18 + 3.7569672032118e+15*cos(theta)**16 - 477075200407848.0*cos(theta)**14 + 44481396759338.3*cos(theta)**12 - 2926991212478.89*cos(theta)**10 + 128376807564.864*cos(theta)**8 - 3439761351.02027*cos(theta)**6 + 48675868.1748151*cos(theta)**4 - 272693.939354706*cos(theta)**2 + 252.962837991379)*cos(2*phi)

@torch.jit.script
def Yl46_m3(theta, phi):
    return 3.83417950543236e-5*(1.0 - cos(theta)**2)**1.5*(5.31702675277511e+17*cos(theta)**43 - 5.27612654698454e+18*cos(theta)**41 + 2.43057515085804e+19*cos(theta)**39 - 6.90059841680387e+19*cos(theta)**37 + 1.3517054545857e+20*cos(theta)**35 - 1.93798733850239e+20*cos(theta)**33 + 2.10546772578037e+20*cos(theta)**31 - 1.77042042041207e+20*cos(theta)**29 + 1.1668680043625e+20*cos(theta)**27 - 6.067713622685e+19*cos(theta)**25 + 2.49358094082945e+19*cos(theta)**23 - 8.07779741395456e+18*cos(theta)**21 + 2.04871673542326e+18*cos(theta)**19 - 4.0221648881444e+17*cos(theta)**17 + 6.01114752513888e+16*cos(theta)**15 - 6.67905280570987e+15*cos(theta)**13 + 533776761112059.0*cos(theta)**11 - 29269912124788.9*cos(theta)**9 + 1027014460518.91*cos(theta)**7 - 20638568106.1216*cos(theta)**5 + 194703472.69926*cos(theta)**3 - 545387.878709413*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl46_m4(theta, phi):
    return 8.26900418061119e-7*(1.0 - cos(theta)**2)**2*(2.2863215036933e+19*cos(theta)**42 - 2.16321188426366e+20*cos(theta)**40 + 9.47924308834637e+20*cos(theta)**38 - 2.55322141421743e+21*cos(theta)**36 + 4.73096909104995e+21*cos(theta)**34 - 6.39535821705788e+21*cos(theta)**32 + 6.52694994991916e+21*cos(theta)**30 - 5.134219219195e+21*cos(theta)**28 + 3.15054361177875e+21*cos(theta)**26 - 1.51692840567125e+21*cos(theta)**24 + 5.73523616390774e+20*cos(theta)**22 - 1.69633745693046e+20*cos(theta)**20 + 3.89256179730419e+19*cos(theta)**18 - 6.83768030984548e+18*cos(theta)**16 + 9.01672128770832e+17*cos(theta)**14 - 8.68276864742283e+16*cos(theta)**12 + 5.87154437223265e+15*cos(theta)**10 - 263429209123100.0*cos(theta)**8 + 7189101223632.36*cos(theta)**6 - 103192840530.608*cos(theta)**4 + 584110418.097781*cos(theta)**2 - 545387.878709413)*cos(4*phi)

@torch.jit.script
def Yl46_m5(theta, phi):
    return 1.78666643331353e-8*(1.0 - cos(theta)**2)**2.5*(9.60255031551185e+20*cos(theta)**41 - 8.65284753705464e+21*cos(theta)**39 + 3.60211237357162e+22*cos(theta)**37 - 9.19159709118276e+22*cos(theta)**35 + 1.60852949095698e+23*cos(theta)**33 - 2.04651462945852e+23*cos(theta)**31 + 1.95808498497575e+23*cos(theta)**29 - 1.4375813813746e+23*cos(theta)**27 + 8.19141339062474e+22*cos(theta)**25 - 3.640628173611e+22*cos(theta)**23 + 1.2617519560597e+22*cos(theta)**21 - 3.39267491386091e+21*cos(theta)**19 + 7.00661123514754e+20*cos(theta)**17 - 1.09402884957528e+20*cos(theta)**15 + 1.26234098027916e+19*cos(theta)**13 - 1.04193223769074e+18*cos(theta)**11 + 5.87154437223265e+16*cos(theta)**9 - 2.1074336729848e+15*cos(theta)**7 + 43134607341794.1*cos(theta)**5 - 412771362122.432*cos(theta)**3 + 1168220836.19556*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl46_m6(theta, phi):
    return 3.86945569224729e-10*(1.0 - cos(theta)**2)**3*(3.93704562935986e+22*cos(theta)**40 - 3.37461053945131e+23*cos(theta)**38 + 1.3327815782215e+24*cos(theta)**36 - 3.21705898191397e+24*cos(theta)**34 + 5.30814732015804e+24*cos(theta)**32 - 6.34419535132142e+24*cos(theta)**30 + 5.67844645642967e+24*cos(theta)**28 - 3.88146972971142e+24*cos(theta)**26 + 2.04785334765619e+24*cos(theta)**24 - 8.3734447993053e+23*cos(theta)**22 + 2.64967910772537e+23*cos(theta)**20 - 6.44608233633574e+22*cos(theta)**18 + 1.19112390997508e+22*cos(theta)**16 - 1.64104327436291e+21*cos(theta)**14 + 1.64104327436291e+20*cos(theta)**12 - 1.14612546145981e+19*cos(theta)**10 + 5.28438993500938e+17*cos(theta)**8 - 1.47520357108936e+16*cos(theta)**6 + 215673036708971.0*cos(theta)**4 - 1238314086367.3*cos(theta)**2 + 1168220836.19556)*cos(6*phi)

@torch.jit.script
def Yl46_m7(theta, phi):
    return 8.4039207365689e-12*(1.0 - cos(theta)**2)**3.5*(1.57481825174394e+24*cos(theta)**39 - 1.2823520049915e+25*cos(theta)**37 + 4.7980136815974e+25*cos(theta)**35 - 1.09380005385075e+26*cos(theta)**33 + 1.69860714245057e+26*cos(theta)**31 - 1.90325860539643e+26*cos(theta)**29 + 1.58996500780031e+26*cos(theta)**27 - 1.00918212972497e+26*cos(theta)**25 + 4.91484803437485e+25*cos(theta)**23 - 1.84215785584716e+25*cos(theta)**21 + 5.29935821545075e+24*cos(theta)**19 - 1.16029482054043e+24*cos(theta)**17 + 1.90579825596013e+23*cos(theta)**15 - 2.29746058410808e+22*cos(theta)**13 + 1.9692519292355e+21*cos(theta)**11 - 1.14612546145981e+20*cos(theta)**9 + 4.22751194800751e+18*cos(theta)**7 - 8.85122142653616e+16*cos(theta)**5 + 862692146835883.0*cos(theta)**3 - 2476628172734.59*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl46_m8(theta, phi):
    return 1.83127161651504e-13*(1.0 - cos(theta)**2)**4*(6.14179118180138e+25*cos(theta)**38 - 4.74470241846854e+26*cos(theta)**36 + 1.67930478855909e+27*cos(theta)**34 - 3.60954017770747e+27*cos(theta)**32 + 5.26568214159678e+27*cos(theta)**30 - 5.51944995564964e+27*cos(theta)**28 + 4.29290552106083e+27*cos(theta)**26 - 2.52295532431242e+27*cos(theta)**24 + 1.13041504790621e+27*cos(theta)**22 - 3.86853149727905e+26*cos(theta)**20 + 1.00687806093564e+26*cos(theta)**18 - 1.97250119491874e+25*cos(theta)**16 + 2.8586973839402e+24*cos(theta)**14 - 2.9866987593405e+23*cos(theta)**12 + 2.16617712215905e+22*cos(theta)**10 - 1.03151291531383e+21*cos(theta)**8 + 2.95925836360525e+19*cos(theta)**6 - 4.42561071326808e+17*cos(theta)**4 + 2.58807644050765e+15*cos(theta)**2 - 2476628172734.59)*cos(8*phi)

@torch.jit.script
def Yl46_m9(theta, phi):
    return 4.00571107454053e-15*(1.0 - cos(theta)**2)**4.5*(2.33388064908453e+27*cos(theta)**37 - 1.70809287064867e+28*cos(theta)**35 + 5.70963628110091e+28*cos(theta)**33 - 1.15505285686639e+29*cos(theta)**31 + 1.57970464247903e+29*cos(theta)**29 - 1.5454459875819e+29*cos(theta)**27 + 1.11615543547582e+29*cos(theta)**25 - 6.05509277834981e+28*cos(theta)**23 + 2.48691310539367e+28*cos(theta)**21 - 7.73706299455809e+27*cos(theta)**19 + 1.81238050968416e+27*cos(theta)**17 - 3.15600191186998e+26*cos(theta)**15 + 4.00217633751628e+25*cos(theta)**13 - 3.5840385112086e+24*cos(theta)**11 + 2.16617712215905e+23*cos(theta)**9 - 8.25210332251065e+21*cos(theta)**7 + 1.77555501816315e+20*cos(theta)**5 - 1.77024428530723e+18*cos(theta)**3 + 5.1761528810153e+15*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl46_m10(theta, phi):
    return 8.80004201373588e-17*(1.0 - cos(theta)**2)**5*(8.63535840161274e+28*cos(theta)**36 - 5.97832504727036e+29*cos(theta)**34 + 1.8841799727633e+30*cos(theta)**32 - 3.58066385628581e+30*cos(theta)**30 + 4.5811434631892e+30*cos(theta)**28 - 4.17270416647112e+30*cos(theta)**26 + 2.79038858868954e+30*cos(theta)**24 - 1.39267133902046e+30*cos(theta)**22 + 5.22251752132671e+29*cos(theta)**20 - 1.47004196896604e+29*cos(theta)**18 + 3.08104686646307e+28*cos(theta)**16 - 4.73400286780497e+27*cos(theta)**14 + 5.20282923877116e+26*cos(theta)**12 - 3.94244236232946e+25*cos(theta)**10 + 1.94955940994314e+24*cos(theta)**8 - 5.77647232575746e+22*cos(theta)**6 + 8.87777509081577e+20*cos(theta)**4 - 5.31073285592169e+18*cos(theta)**2 + 5.1761528810153e+15)*cos(10*phi)

@torch.jit.script
def Yl46_m11(theta, phi):
    return 1.9426567317875e-18*(1.0 - cos(theta)**2)**5.5*(3.10872902458059e+30*cos(theta)**35 - 2.03263051607192e+31*cos(theta)**33 + 6.02937591284256e+31*cos(theta)**31 - 1.07419915688574e+32*cos(theta)**29 + 1.28272016969298e+32*cos(theta)**27 - 1.08490308328249e+32*cos(theta)**25 + 6.69693261285489e+31*cos(theta)**23 - 3.063876945845e+31*cos(theta)**21 + 1.04450350426534e+31*cos(theta)**19 - 2.64607554413887e+30*cos(theta)**17 + 4.9296749863409e+29*cos(theta)**15 - 6.62760401492695e+28*cos(theta)**13 + 6.24339508652539e+27*cos(theta)**11 - 3.94244236232947e+26*cos(theta)**9 + 1.55964752795451e+25*cos(theta)**7 - 3.46588339545447e+23*cos(theta)**5 + 3.55111003632631e+21*cos(theta)**3 - 1.06214657118434e+19*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl46_m12(theta, phi):
    return 4.31169516088401e-20*(1.0 - cos(theta)**2)**6*(1.08805515860321e+32*cos(theta)**34 - 6.70768070303734e+32*cos(theta)**32 + 1.86910653298119e+33*cos(theta)**30 - 3.11517755496865e+33*cos(theta)**28 + 3.46334445817103e+33*cos(theta)**26 - 2.71225770820623e+33*cos(theta)**24 + 1.54029450095663e+33*cos(theta)**22 - 6.43414158627451e+32*cos(theta)**20 + 1.98455665810415e+32*cos(theta)**18 - 4.49832842503608e+31*cos(theta)**16 + 7.39451247951136e+30*cos(theta)**14 - 8.61588521940504e+29*cos(theta)**12 + 6.86773459517793e+28*cos(theta)**10 - 3.54819812609652e+27*cos(theta)**8 + 1.09175326956816e+26*cos(theta)**6 - 1.73294169772724e+24*cos(theta)**4 + 1.06533301089789e+22*cos(theta)**2 - 1.06214657118434e+19)*cos(12*phi)

@torch.jit.script
def Yl46_m13(theta, phi):
    return 9.62681407083826e-22*(1.0 - cos(theta)**2)**6.5*(3.6993875392509e+33*cos(theta)**33 - 2.14645782497195e+34*cos(theta)**31 + 5.60731959894358e+34*cos(theta)**29 - 8.72249715391223e+34*cos(theta)**27 + 9.00469559124469e+34*cos(theta)**25 - 6.50941849969495e+34*cos(theta)**23 + 3.38864790210458e+34*cos(theta)**21 - 1.2868283172549e+34*cos(theta)**19 + 3.57220198458747e+33*cos(theta)**17 - 7.19732548005772e+32*cos(theta)**15 + 1.03523174713159e+32*cos(theta)**13 - 1.0339062263286e+31*cos(theta)**11 + 6.86773459517793e+29*cos(theta)**9 - 2.83855850087721e+28*cos(theta)**7 + 6.55051961740896e+26*cos(theta)**5 - 6.93176679090895e+24*cos(theta)**3 + 2.13066602179578e+22*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl46_m14(theta, phi):
    return 2.16346557417279e-23*(1.0 - cos(theta)**2)**7*(1.2207978879528e+35*cos(theta)**32 - 6.65401925741305e+35*cos(theta)**30 + 1.62612268369364e+36*cos(theta)**28 - 2.3550742315563e+36*cos(theta)**26 + 2.25117389781117e+36*cos(theta)**24 - 1.49716625492984e+36*cos(theta)**22 + 7.11616059441961e+35*cos(theta)**20 - 2.44497380278431e+35*cos(theta)**18 + 6.0727433737987e+34*cos(theta)**16 - 1.07959882200866e+34*cos(theta)**14 + 1.34580127127107e+33*cos(theta)**12 - 1.13729684896146e+32*cos(theta)**10 + 6.18096113566013e+30*cos(theta)**8 - 1.98699095061405e+29*cos(theta)**6 + 3.27525980870448e+27*cos(theta)**4 - 2.07953003727268e+25*cos(theta)**2 + 2.13066602179578e+22)*cos(14*phi)

@torch.jit.script
def Yl46_m15(theta, phi):
    return 4.89677424487597e-25*(1.0 - cos(theta)**2)**7.5*(3.90655324144895e+36*cos(theta)**31 - 1.99620577722391e+37*cos(theta)**29 + 4.55314351434219e+37*cos(theta)**27 - 6.12319300204639e+37*cos(theta)**25 + 5.40281735474681e+37*cos(theta)**23 - 3.29376576084565e+37*cos(theta)**21 + 1.42323211888392e+37*cos(theta)**19 - 4.40095284501176e+36*cos(theta)**17 + 9.71638939807792e+35*cos(theta)**15 - 1.51143835081212e+35*cos(theta)**13 + 1.61496152552528e+34*cos(theta)**11 - 1.13729684896146e+33*cos(theta)**9 + 4.94476890852811e+31*cos(theta)**7 - 1.19219457036843e+30*cos(theta)**5 + 1.31010392348179e+28*cos(theta)**3 - 4.15906007454537e+25*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl46_m16(theta, phi):
    return 1.11694912080369e-26*(1.0 - cos(theta)**2)**8*(1.21103150484917e+38*cos(theta)**30 - 5.78899675394935e+38*cos(theta)**28 + 1.22934874887239e+39*cos(theta)**26 - 1.5307982505116e+39*cos(theta)**24 + 1.24264799159177e+39*cos(theta)**22 - 6.91690809777586e+38*cos(theta)**20 + 2.70414102587945e+38*cos(theta)**18 - 7.48161983652e+37*cos(theta)**16 + 1.45745840971169e+37*cos(theta)**14 - 1.96486985605576e+36*cos(theta)**12 + 1.77645767807781e+35*cos(theta)**10 - 1.02356716406532e+34*cos(theta)**8 + 3.46133823596968e+32*cos(theta)**6 - 5.96097285184215e+30*cos(theta)**4 + 3.93031177044537e+28*cos(theta)**2 - 4.15906007454537e+25)*cos(16*phi)

@torch.jit.script
def Yl46_m17(theta, phi):
    return 2.56922706601449e-28*(1.0 - cos(theta)**2)**8.5*(3.63309451454752e+39*cos(theta)**29 - 1.62091909110582e+40*cos(theta)**27 + 3.19630674706821e+40*cos(theta)**25 - 3.67391580122783e+40*cos(theta)**23 + 2.73382558150189e+40*cos(theta)**21 - 1.38338161955517e+40*cos(theta)**19 + 4.86745384658301e+39*cos(theta)**17 - 1.1970591738432e+39*cos(theta)**15 + 2.04044177359636e+38*cos(theta)**13 - 2.35784382726691e+37*cos(theta)**11 + 1.77645767807781e+36*cos(theta)**9 - 8.18853731252255e+34*cos(theta)**7 + 2.07680294158181e+33*cos(theta)**5 - 2.38438914073686e+31*cos(theta)**3 + 7.86062354089075e+28*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl46_m18(theta, phi):
    return 5.96366861096496e-30*(1.0 - cos(theta)**2)**9*(1.05359740921878e+41*cos(theta)**28 - 4.37648154598571e+41*cos(theta)**26 + 7.99076686767054e+41*cos(theta)**24 - 8.45000634282401e+41*cos(theta)**22 + 5.74103372115396e+41*cos(theta)**20 - 2.62842507715483e+41*cos(theta)**18 + 8.27467153919112e+40*cos(theta)**16 - 1.7955887607648e+40*cos(theta)**14 + 2.65257430567527e+39*cos(theta)**12 - 2.5936282099936e+38*cos(theta)**10 + 1.59881191027003e+37*cos(theta)**8 - 5.73197611876578e+35*cos(theta)**6 + 1.0384014707909e+34*cos(theta)**4 - 7.15316742221058e+31*cos(theta)**2 + 7.86062354089075e+28)*cos(18*phi)

@torch.jit.script
def Yl46_m19(theta, phi):
    return 1.39790548387065e-31*(1.0 - cos(theta)**2)**9.5*(2.95007274581259e+42*cos(theta)**27 - 1.13788520195628e+43*cos(theta)**25 + 1.91778404824093e+43*cos(theta)**23 - 1.85900139542128e+43*cos(theta)**21 + 1.14820674423079e+43*cos(theta)**19 - 4.73116513887869e+42*cos(theta)**17 + 1.32394744627058e+42*cos(theta)**15 - 2.51382426507072e+41*cos(theta)**13 + 3.18308916681033e+40*cos(theta)**11 - 2.5936282099936e+39*cos(theta)**9 + 1.27904952821602e+38*cos(theta)**7 - 3.43918567125947e+36*cos(theta)**5 + 4.15360588316361e+34*cos(theta)**3 - 1.43063348444212e+32*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl46_m20(theta, phi):
    return 3.31149389509621e-33*(1.0 - cos(theta)**2)**10*(7.96519641369399e+43*cos(theta)**26 - 2.84471300489071e+44*cos(theta)**24 + 4.41090331095414e+44*cos(theta)**22 - 3.90390293038469e+44*cos(theta)**20 + 2.18159281403851e+44*cos(theta)**18 - 8.04298073609377e+43*cos(theta)**16 + 1.98592116940587e+43*cos(theta)**14 - 3.26797154459194e+42*cos(theta)**12 + 3.50139808349136e+41*cos(theta)**10 - 2.33426538899424e+40*cos(theta)**8 + 8.95334669751215e+38*cos(theta)**6 - 1.71959283562973e+37*cos(theta)**4 + 1.24608176494908e+35*cos(theta)**2 - 1.43063348444212e+32)*cos(20*phi)

@torch.jit.script
def Yl46_m21(theta, phi):
    return 7.93414043768083e-35*(1.0 - cos(theta)**2)**10.5*(2.07095106756044e+45*cos(theta)**25 - 6.82731121173771e+45*cos(theta)**23 + 9.7039872840991e+45*cos(theta)**21 - 7.80780586076939e+45*cos(theta)**19 + 3.92686706526931e+45*cos(theta)**17 - 1.286876917775e+45*cos(theta)**15 + 2.78028963716822e+44*cos(theta)**13 - 3.92156585351032e+43*cos(theta)**11 + 3.50139808349136e+42*cos(theta)**9 - 1.86741231119539e+41*cos(theta)**7 + 5.37200801850729e+39*cos(theta)**5 - 6.87837134251894e+37*cos(theta)**3 + 2.49216352989817e+35*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl46_m22(theta, phi):
    return 1.92431171017896e-36*(1.0 - cos(theta)**2)**11*(5.17737766890109e+46*cos(theta)**24 - 1.57028157869967e+47*cos(theta)**22 + 2.03783732966081e+47*cos(theta)**20 - 1.48348311354618e+47*cos(theta)**18 + 6.67567401095783e+46*cos(theta)**16 - 1.9303153766625e+46*cos(theta)**14 + 3.61437652831868e+45*cos(theta)**12 - 4.31372243886136e+44*cos(theta)**10 + 3.15125827514222e+43*cos(theta)**8 - 1.30718861783677e+42*cos(theta)**6 + 2.68600400925365e+40*cos(theta)**4 - 2.06351140275568e+38*cos(theta)**2 + 2.49216352989817e+35)*cos(22*phi)

@torch.jit.script
def Yl46_m23(theta, phi):
    return 4.72873804667603e-38*(1.0 - cos(theta)**2)**11.5*(1.24257064053626e+48*cos(theta)**23 - 3.45461947313928e+48*cos(theta)**21 + 4.07567465932162e+48*cos(theta)**19 - 2.67026960438313e+48*cos(theta)**17 + 1.06810784175325e+48*cos(theta)**15 - 2.70244152732751e+47*cos(theta)**13 + 4.33725183398242e+46*cos(theta)**11 - 4.31372243886136e+45*cos(theta)**9 + 2.52100662011378e+44*cos(theta)**7 - 7.84313170702065e+42*cos(theta)**5 + 1.07440160370146e+41*cos(theta)**3 - 4.12702280551136e+38*cos(theta))*cos(23*phi)

@torch.jit.script
def Yl46_m24(theta, phi):
    return 1.17850741252294e-39*(1.0 - cos(theta)**2)**12*(2.8579124732334e+49*cos(theta)**22 - 7.25470089359249e+49*cos(theta)**20 + 7.74378185271108e+49*cos(theta)**18 - 4.53945832745132e+49*cos(theta)**16 + 1.60216176262988e+49*cos(theta)**14 - 3.51317398552576e+48*cos(theta)**12 + 4.77097701738066e+47*cos(theta)**10 - 3.88235019497522e+46*cos(theta)**8 + 1.76470463407965e+45*cos(theta)**6 - 3.92156585351032e+43*cos(theta)**4 + 3.22320481110438e+41*cos(theta)**2 - 4.12702280551136e+38)*cos(24*phi)

@torch.jit.script
def Yl46_m25(theta, phi):
    return 2.98189127114901e-41*(1.0 - cos(theta)**2)**12.5*(6.28740744111349e+50*cos(theta)**21 - 1.4509401787185e+51*cos(theta)**19 + 1.39388073348799e+51*cos(theta)**17 - 7.26313332392212e+50*cos(theta)**15 + 2.24302646768183e+50*cos(theta)**13 - 4.21580878263091e+49*cos(theta)**11 + 4.77097701738066e+48*cos(theta)**9 - 3.10588015598018e+47*cos(theta)**7 + 1.05882278044779e+46*cos(theta)**5 - 1.56862634140413e+44*cos(theta)**3 + 6.44640962220875e+41*cos(theta))*cos(25*phi)

@torch.jit.script
def Yl46_m26(theta, phi):
    return 7.66859687268355e-43*(1.0 - cos(theta)**2)**13*(1.32035556263383e+52*cos(theta)**20 - 2.75678633956514e+52*cos(theta)**18 + 2.36959724692959e+52*cos(theta)**16 - 1.08946999858832e+52*cos(theta)**14 + 2.91593440798638e+51*cos(theta)**12 - 4.637389660894e+50*cos(theta)**10 + 4.29387931564259e+49*cos(theta)**8 - 2.17411610918612e+48*cos(theta)**6 + 5.29411390223894e+46*cos(theta)**4 - 4.70587902421239e+44*cos(theta)**2 + 6.44640962220875e+41)*cos(26*phi)

@torch.jit.script
def Yl46_m27(theta, phi):
    return 2.00696352793153e-44*(1.0 - cos(theta)**2)**13.5*(2.64071112526766e+53*cos(theta)**19 - 4.96221541121726e+53*cos(theta)**17 + 3.79135559508734e+53*cos(theta)**15 - 1.52525799802364e+53*cos(theta)**13 + 3.49912128958366e+52*cos(theta)**11 - 4.637389660894e+51*cos(theta)**9 + 3.43510345251407e+50*cos(theta)**7 - 1.30446966551167e+49*cos(theta)**5 + 2.11764556089557e+47*cos(theta)**3 - 9.41175804842478e+44*cos(theta))*cos(27*phi)

@torch.jit.script
def Yl46_m28(theta, phi):
    return 5.35237852927822e-46*(1.0 - cos(theta)**2)**14*(5.01735113800856e+54*cos(theta)**18 - 8.43576619906934e+54*cos(theta)**16 + 5.68703339263102e+54*cos(theta)**14 - 1.98283539743074e+54*cos(theta)**12 + 3.84903341854202e+53*cos(theta)**10 - 4.1736506948046e+52*cos(theta)**8 + 2.40457241675985e+51*cos(theta)**6 - 6.52234832755837e+49*cos(theta)**4 + 6.35293668268672e+47*cos(theta)**2 - 9.41175804842478e+44)*cos(28*phi)

@torch.jit.script
def Yl46_m29(theta, phi):
    return 1.45673292299555e-47*(1.0 - cos(theta)**2)**14.5*(9.03123204841541e+55*cos(theta)**17 - 1.34972259185109e+56*cos(theta)**15 + 7.96184674968342e+55*cos(theta)**13 - 2.37940247691689e+55*cos(theta)**11 + 3.84903341854202e+54*cos(theta)**9 - 3.33892055584368e+53*cos(theta)**7 + 1.44274345005591e+52*cos(theta)**5 - 2.60893933102335e+50*cos(theta)**3 + 1.27058733653734e+48*cos(theta))*cos(29*phi)

@torch.jit.script
def Yl46_m30(theta, phi):
    return 4.05273940238151e-49*(1.0 - cos(theta)**2)**15*(1.53530944823062e+57*cos(theta)**16 - 2.02458388777664e+57*cos(theta)**14 + 1.03504007745885e+57*cos(theta)**12 - 2.61734272460857e+56*cos(theta)**10 + 3.46413007668782e+55*cos(theta)**8 - 2.33724438909058e+54*cos(theta)**6 + 7.21371725027956e+52*cos(theta)**4 - 7.82681799307004e+50*cos(theta)**2 + 1.27058733653734e+48)*cos(30*phi)

@torch.jit.script
def Yl46_m31(theta, phi):
    return 1.15463129634021e-50*(1.0 - cos(theta)**2)**15.5*(2.45649511716899e+58*cos(theta)**15 - 2.8344174428873e+58*cos(theta)**13 + 1.24204809295061e+58*cos(theta)**11 - 2.61734272460857e+57*cos(theta)**9 + 2.77130406135025e+56*cos(theta)**7 - 1.40234663345435e+55*cos(theta)**5 + 2.88548690011182e+53*cos(theta)**3 - 1.56536359861401e+51*cos(theta))*cos(31*phi)

@torch.jit.script
def Yl46_m32(theta, phi):
    return 3.37559545932685e-52*(1.0 - cos(theta)**2)**16*(3.68474267575349e+59*cos(theta)**14 - 3.68474267575349e+59*cos(theta)**12 + 1.36625290224568e+59*cos(theta)**10 - 2.35560845214772e+58*cos(theta)**8 + 1.93991284294518e+57*cos(theta)**6 - 7.01173316727173e+55*cos(theta)**4 + 8.65646070033547e+53*cos(theta)**2 - 1.56536359861401e+51)*cos(32*phi)

@torch.jit.script
def Yl46_m33(theta, phi):
    return 1.01501586519763e-53*(1.0 - cos(theta)**2)**16.5*(5.15863974605488e+60*cos(theta)**13 - 4.42169121090419e+60*cos(theta)**11 + 1.36625290224568e+60*cos(theta)**9 - 1.88448676171817e+59*cos(theta)**7 + 1.16394770576711e+58*cos(theta)**5 - 2.80469326690869e+56*cos(theta)**3 + 1.73129214006709e+54*cos(theta))*cos(33*phi)

@torch.jit.script
def Yl46_m34(theta, phi):
    return 3.14743058609061e-55*(1.0 - cos(theta)**2)**17*(6.70623166987135e+61*cos(theta)**12 - 4.86386033199461e+61*cos(theta)**10 + 1.22962761202111e+61*cos(theta)**8 - 1.31914073320272e+60*cos(theta)**6 + 5.81973852883553e+58*cos(theta)**4 - 8.41407980072607e+56*cos(theta)**2 + 1.73129214006709e+54)*cos(34*phi)

@torch.jit.script
def Yl46_m35(theta, phi):
    return 1.00953883118615e-56*(1.0 - cos(theta)**2)**17.5*(8.04747800384562e+62*cos(theta)**11 - 4.8638603319946e+62*cos(theta)**9 + 9.83702089616886e+61*cos(theta)**7 - 7.91484439921633e+60*cos(theta)**5 + 2.32789541153421e+59*cos(theta)**3 - 1.68281596014521e+57*cos(theta))*cos(35*phi)

@torch.jit.script
def Yl46_m36(theta, phi):
    return 3.36139662478243e-58*(1.0 - cos(theta)**2)**18*(8.85222580423018e+63*cos(theta)**10 - 4.37747429879514e+63*cos(theta)**8 + 6.88591462731821e+62*cos(theta)**6 - 3.95742219960816e+61*cos(theta)**4 + 6.98368623460264e+59*cos(theta)**2 - 1.68281596014521e+57)*cos(36*phi)

@torch.jit.script
def Yl46_m37(theta, phi):
    return 1.16675780150007e-59*(1.0 - cos(theta)**2)**18.5*(8.85222580423018e+64*cos(theta)**9 - 3.50197943903612e+64*cos(theta)**7 + 4.13154877639092e+63*cos(theta)**5 - 1.58296887984327e+62*cos(theta)**3 + 1.39673724692053e+60*cos(theta))*cos(37*phi)

@torch.jit.script
def Yl46_m38(theta, phi):
    return 4.24345709766218e-61*(1.0 - cos(theta)**2)**19*(7.96700322380716e+65*cos(theta)**8 - 2.45138560732528e+65*cos(theta)**6 + 2.06577438819546e+64*cos(theta)**4 - 4.7489066395298e+62*cos(theta)**2 + 1.39673724692053e+60)*cos(38*phi)

@torch.jit.script
def Yl46_m39(theta, phi):
    return 1.62729151279139e-62*(1.0 - cos(theta)**2)**19.5*(6.37360257904573e+66*cos(theta)**7 - 1.47083136439517e+66*cos(theta)**5 + 8.26309755278185e+64*cos(theta)**3 - 9.49781327905959e+62*cos(theta))*cos(39*phi)

@torch.jit.script
def Yl46_m40(theta, phi):
    return 6.63234506965458e-64*(1.0 - cos(theta)**2)**20*(4.46152180533201e+67*cos(theta)**6 - 7.35415682197584e+66*cos(theta)**4 + 2.47892926583455e+65*cos(theta)**2 - 9.49781327905959e+62)*cos(40*phi)

@torch.jit.script
def Yl46_m41(theta, phi):
    return 2.9028985753037e-65*(1.0 - cos(theta)**2)**20.5*(2.67691308319921e+68*cos(theta)**5 - 2.94166272879034e+67*cos(theta)**3 + 4.95785853166911e+65*cos(theta))*cos(41*phi)

@torch.jit.script
def Yl46_m42(theta, phi):
    return 1.3839025959632e-66*(1.0 - cos(theta)**2)**21*(1.3384565415996e+69*cos(theta)**4 - 8.82498818637101e+67*cos(theta)**2 + 4.95785853166911e+65)*cos(42*phi)

@torch.jit.script
def Yl46_m43(theta, phi):
    return 7.33466908928147e-68*(1.0 - cos(theta)**2)**21.5*(5.35382616639841e+69*cos(theta)**3 - 1.7649976372742e+68*cos(theta))*cos(43*phi)

@torch.jit.script
def Yl46_m44(theta, phi):
    return 4.46373745781704e-69*(1.0 - cos(theta)**2)**22*(1.60614784991952e+70*cos(theta)**2 - 1.7649976372742e+68)*cos(44*phi)

@torch.jit.script
def Yl46_m45(theta, phi):
    return 10.6286587918185*(1.0 - cos(theta)**2)**22.5*cos(45*phi)*cos(theta)

@torch.jit.script
def Yl46_m46(theta, phi):
    return 1.1081142800943*(1.0 - cos(theta)**2)**23*cos(46*phi)

@torch.jit.script
def Yl47_m_minus_47(theta, phi):
    return 1.11399291169174*(1.0 - cos(theta)**2)**23.5*sin(47*phi)

@torch.jit.script
def Yl47_m_minus_46(theta, phi):
    return 10.8005619986252*(1.0 - cos(theta)**2)**23*sin(46*phi)*cos(theta)

@torch.jit.script
def Yl47_m_minus_45(theta, phi):
    return 4.93065211209231e-71*(1.0 - cos(theta)**2)**22.5*(1.49371750042516e+72*cos(theta)**2 - 1.60614784991952e+70)*sin(45*phi)

@torch.jit.script
def Yl47_m_minus_44(theta, phi):
    return 8.19141449881068e-70*(1.0 - cos(theta)**2)**22*(4.97905833475052e+71*cos(theta)**3 - 1.60614784991952e+70*cos(theta))*sin(44*phi)

@torch.jit.script
def Yl47_m_minus_43(theta, phi):
    return 1.56282228109413e-68*(1.0 - cos(theta)**2)**21.5*(1.24476458368763e+71*cos(theta)**4 - 8.03073924959762e+69*cos(theta)**2 + 4.41249409318551e+67)*sin(43*phi)

@torch.jit.script
def Yl47_m_minus_42(theta, phi):
    return 3.31524669825326e-67*(1.0 - cos(theta)**2)**21*(2.48952916737526e+70*cos(theta)**5 - 2.67691308319921e+69*cos(theta)**3 + 4.41249409318551e+67*cos(theta))*sin(42*phi)

@torch.jit.script
def Yl47_m_minus_41(theta, phi):
    return 7.66101794667593e-66*(1.0 - cos(theta)**2)**20.5*(4.14921527895877e+69*cos(theta)**6 - 6.69228270799802e+68*cos(theta)**4 + 2.20624704659275e+67*cos(theta)**2 - 8.26309755278185e+64)*sin(41*phi)

@torch.jit.script
def Yl47_m_minus_40(theta, phi):
    return 1.90141465028655e-64*(1.0 - cos(theta)**2)**20*(5.92745039851253e+68*cos(theta)**7 - 1.3384565415996e+68*cos(theta)**5 + 7.35415682197584e+66*cos(theta)**3 - 8.26309755278185e+64*cos(theta))*sin(40*phi)

@torch.jit.script
def Yl47_m_minus_39(theta, phi):
    return 5.01627636792244e-63*(1.0 - cos(theta)**2)**19.5*(7.40931299814066e+67*cos(theta)**8 - 2.23076090266601e+67*cos(theta)**6 + 1.83853920549396e+66*cos(theta)**4 - 4.13154877639092e+64*cos(theta)**2 + 1.18722665988245e+62)*sin(39*phi)

@torch.jit.script
def Yl47_m_minus_38(theta, phi):
    return 1.39557099912251e-61*(1.0 - cos(theta)**2)**19*(8.23256999793407e+66*cos(theta)**9 - 3.18680128952287e+66*cos(theta)**7 + 3.67707841098792e+65*cos(theta)**5 - 1.37718292546364e+64*cos(theta)**3 + 1.18722665988245e+62*cos(theta))*sin(38*phi)

@torch.jit.script
def Yl47_m_minus_37(theta, phi):
    return 4.06875368086227e-60*(1.0 - cos(theta)**2)**18.5*(8.23256999793407e+65*cos(theta)**10 - 3.98350161190358e+65*cos(theta)**8 + 6.1284640183132e+64*cos(theta)**6 - 3.4429573136591e+63*cos(theta)**4 + 5.93613329941225e+61*cos(theta)**2 - 1.39673724692053e+59)*sin(37*phi)

@torch.jit.script
def Yl47_m_minus_36(theta, phi):
    return 1.23679404188207e-58*(1.0 - cos(theta)**2)**18*(7.48415454357643e+64*cos(theta)**11 - 4.42611290211509e+64*cos(theta)**9 + 8.75494859759029e+63*cos(theta)**7 - 6.88591462731821e+62*cos(theta)**5 + 1.97871109980408e+61*cos(theta)**3 - 1.39673724692053e+59*cos(theta))*sin(36*phi)

@torch.jit.script
def Yl47_m_minus_35(theta, phi):
    return 3.90325615867939e-57*(1.0 - cos(theta)**2)**17.5*(6.23679545298036e+63*cos(theta)**12 - 4.42611290211509e+63*cos(theta)**10 + 1.09436857469879e+63*cos(theta)**8 - 1.14765243788637e+62*cos(theta)**6 + 4.94677774951021e+60*cos(theta)**4 - 6.98368623460264e+58*cos(theta)**2 + 1.40234663345435e+56)*sin(35*phi)

@torch.jit.script
def Yl47_m_minus_34(theta, phi):
    return 1.27439968653976e-55*(1.0 - cos(theta)**2)**17*(4.79753496383104e+62*cos(theta)**13 - 4.02373900192281e+62*cos(theta)**11 + 1.21596508299865e+62*cos(theta)**9 - 1.63950348269481e+61*cos(theta)**7 + 9.89355549902041e+59*cos(theta)**5 - 2.32789541153421e+58*cos(theta)**3 + 1.40234663345435e+56*cos(theta))*sin(34*phi)

@torch.jit.script
def Yl47_m_minus_33(theta, phi):
    return 4.29153030075948e-54*(1.0 - cos(theta)**2)**16.5*(3.42681068845074e+61*cos(theta)**14 - 3.35311583493567e+61*cos(theta)**12 + 1.21596508299865e+61*cos(theta)**10 - 2.04937935336851e+60*cos(theta)**8 + 1.6489259165034e+59*cos(theta)**6 - 5.81973852883553e+57*cos(theta)**4 + 7.01173316727173e+55*cos(theta)**2 - 1.23663724290507e+53)*sin(33*phi)

@torch.jit.script
def Yl47_m_minus_32(theta, phi):
    return 1.48662970462735e-52*(1.0 - cos(theta)**2)**16*(2.28454045896716e+60*cos(theta)**15 - 2.57931987302744e+60*cos(theta)**13 + 1.10542280272605e+60*cos(theta)**11 - 2.27708817040946e+59*cos(theta)**9 + 2.35560845214772e+58*cos(theta)**7 - 1.16394770576711e+57*cos(theta)**5 + 2.33724438909058e+55*cos(theta)**3 - 1.23663724290507e+53*cos(theta))*sin(32*phi)

@torch.jit.script
def Yl47_m_minus_31(theta, phi):
    return 5.28538153651375e-51*(1.0 - cos(theta)**2)**15.5*(1.42783778685448e+59*cos(theta)**16 - 1.84237133787674e+59*cos(theta)**14 + 9.21185668938372e+58*cos(theta)**12 - 2.27708817040946e+58*cos(theta)**10 + 2.94451056518465e+57*cos(theta)**8 - 1.93991284294518e+56*cos(theta)**6 + 5.84311097272644e+54*cos(theta)**4 - 6.18318621452533e+52*cos(theta)**2 + 9.78352249133755e+49)*sin(31*phi)

@torch.jit.script
def Yl47_m_minus_30(theta, phi):
    return 1.92463378568823e-49*(1.0 - cos(theta)**2)**15*(8.39904580502633e+57*cos(theta)**17 - 1.2282475585845e+58*cos(theta)**15 + 7.08604360721825e+57*cos(theta)**13 - 2.07008015491769e+57*cos(theta)**11 + 3.27167840576072e+56*cos(theta)**9 - 2.77130406135025e+55*cos(theta)**7 + 1.16862219454529e+54*cos(theta)**5 - 2.06106207150844e+52*cos(theta)**3 + 9.78352249133755e+49*cos(theta))*sin(30*phi)

@torch.jit.script
def Yl47_m_minus_29(theta, phi):
    return 7.16522315053166e-48*(1.0 - cos(theta)**2)**14.5*(4.66613655834796e+56*cos(theta)**18 - 7.6765472411531e+56*cos(theta)**16 + 5.06145971944161e+56*cos(theta)**14 - 1.72506679576474e+56*cos(theta)**12 + 3.27167840576072e+55*cos(theta)**10 - 3.46413007668782e+54*cos(theta)**8 + 1.94770365757548e+53*cos(theta)**6 - 5.15265517877111e+51*cos(theta)**4 + 4.89176124566878e+49*cos(theta)**2 - 7.05881853631858e+46)*sin(29*phi)

@torch.jit.script
def Yl47_m_minus_28(theta, phi):
    return 2.72278479720203e-46*(1.0 - cos(theta)**2)**14*(2.45586134649893e+55*cos(theta)**19 - 4.51561602420771e+55*cos(theta)**17 + 3.37430647962774e+55*cos(theta)**15 - 1.32697445828057e+55*cos(theta)**13 + 2.97425309614611e+54*cos(theta)**11 - 3.84903341854202e+53*cos(theta)**9 + 2.7824337965364e+52*cos(theta)**7 - 1.03053103575422e+51*cos(theta)**5 + 1.63058708188959e+49*cos(theta)**3 - 7.05881853631858e+46*cos(theta))*sin(28*phi)

@torch.jit.script
def Yl47_m_minus_27(theta, phi):
    return 1.05453001748702e-44*(1.0 - cos(theta)**2)**13.5*(1.22793067324946e+54*cos(theta)**20 - 2.50867556900428e+54*cos(theta)**18 + 2.10894154976734e+54*cos(theta)**16 - 9.47838898771836e+53*cos(theta)**14 + 2.47854424678842e+53*cos(theta)**12 - 3.84903341854202e+52*cos(theta)**10 + 3.4780422456705e+51*cos(theta)**8 - 1.71755172625704e+50*cos(theta)**6 + 4.07646770472398e+48*cos(theta)**4 - 3.52940926815929e+46*cos(theta)**2 + 4.70587902421239e+43)*sin(27*phi)

@torch.jit.script
def Yl47_m_minus_26(theta, phi):
    return 4.15704239669497e-43*(1.0 - cos(theta)**2)**13*(5.84728892023554e+52*cos(theta)**21 - 1.32035556263383e+53*cos(theta)**19 + 1.24055385280432e+53*cos(theta)**17 - 6.31892599181224e+52*cos(theta)**15 + 1.90657249752956e+52*cos(theta)**13 - 3.49912128958366e+51*cos(theta)**11 + 3.86449138407833e+50*cos(theta)**9 - 2.45364532322434e+49*cos(theta)**7 + 8.15293540944796e+47*cos(theta)**5 - 1.1764697560531e+46*cos(theta)**3 + 4.70587902421239e+43*cos(theta))*sin(26*phi)

@torch.jit.script
def Yl47_m_minus_25(theta, phi):
    return 1.66593182302274e-41*(1.0 - cos(theta)**2)**12.5*(2.65785860010707e+51*cos(theta)**22 - 6.60177781316916e+51*cos(theta)**20 + 6.89196584891286e+51*cos(theta)**18 - 3.94932874488265e+51*cos(theta)**16 + 1.3618374982354e+51*cos(theta)**14 - 2.91593440798638e+50*cos(theta)**12 + 3.86449138407833e+49*cos(theta)**10 - 3.06705665403042e+48*cos(theta)**8 + 1.35882256824133e+47*cos(theta)**6 - 2.94117439013274e+45*cos(theta)**4 + 2.35293951210619e+43*cos(theta)**2 - 2.93018619191307e+40)*sin(25*phi)

@torch.jit.script
def Yl47_m_minus_24(theta, phi):
    return 6.77933961187779e-40*(1.0 - cos(theta)**2)**12*(1.15559069569872e+50*cos(theta)**23 - 3.14370372055674e+50*cos(theta)**21 + 3.62735044679624e+50*cos(theta)**19 - 2.32313455581332e+50*cos(theta)**17 + 9.07891665490265e+49*cos(theta)**15 - 2.24302646768183e+49*cos(theta)**13 + 3.51317398552576e+48*cos(theta)**11 - 3.40784072670047e+47*cos(theta)**9 + 1.94117509748761e+46*cos(theta)**7 - 5.88234878026548e+44*cos(theta)**5 + 7.84313170702065e+42*cos(theta)**3 - 2.93018619191307e+40*cos(theta))*sin(24*phi)

@torch.jit.script
def Yl47_m_minus_23(theta, phi):
    return 2.79847985979336e-38*(1.0 - cos(theta)**2)**11.5*(4.81496123207802e+48*cos(theta)**24 - 1.4289562366167e+49*cos(theta)**22 + 1.81367522339812e+49*cos(theta)**20 - 1.29063030878518e+49*cos(theta)**18 + 5.67432290931415e+48*cos(theta)**16 - 1.60216176262988e+48*cos(theta)**14 + 2.92764498793813e+47*cos(theta)**12 - 3.40784072670047e+46*cos(theta)**10 + 2.42646887185951e+45*cos(theta)**8 - 9.80391463377581e+43*cos(theta)**6 + 1.96078292675516e+42*cos(theta)**4 - 1.46509309595653e+40*cos(theta)**2 + 1.71959283562973e+37)*sin(23*phi)

@torch.jit.script
def Yl47_m_minus_22(theta, phi):
    return 1.1706881168749e-36*(1.0 - cos(theta)**2)**11*(1.92598449283121e+47*cos(theta)**25 - 6.21285320268131e+47*cos(theta)**23 + 8.6365486828482e+47*cos(theta)**21 - 6.79279109886937e+47*cos(theta)**19 + 3.33783700547891e+47*cos(theta)**17 - 1.06810784175325e+47*cos(theta)**15 + 2.25203460610626e+46*cos(theta)**13 - 3.09803702427316e+45*cos(theta)**11 + 2.69607652428835e+44*cos(theta)**9 - 1.40055923339654e+43*cos(theta)**7 + 3.92156585351032e+41*cos(theta)**5 - 4.88364365318845e+39*cos(theta)**3 + 1.71959283562973e+37*cos(theta))*sin(22*phi)

@torch.jit.script
def Yl47_m_minus_21(theta, phi):
    return 4.95852411165239e-35*(1.0 - cos(theta)**2)**10.5*(7.40763266473541e+45*cos(theta)**26 - 2.58868883445055e+46*cos(theta)**24 + 3.92570394674918e+46*cos(theta)**22 - 3.39639554943468e+46*cos(theta)**20 + 1.85435389193273e+46*cos(theta)**18 - 6.67567401095783e+45*cos(theta)**16 + 1.60859614721875e+45*cos(theta)**14 - 2.58169752022763e+44*cos(theta)**12 + 2.69607652428835e+43*cos(theta)**10 - 1.75069904174568e+42*cos(theta)**8 + 6.53594308918387e+40*cos(theta)**6 - 1.22091091329711e+39*cos(theta)**4 + 8.59796417814867e+36*cos(theta)**2 - 9.58524434576218e+33)*sin(21*phi)

@torch.jit.script
def Yl47_m_minus_20(theta, phi):
    return 2.12465670327417e-33*(1.0 - cos(theta)**2)**10*(2.74356765360571e+44*cos(theta)**27 - 1.03547553378022e+45*cos(theta)**25 + 1.70682780293443e+45*cos(theta)**23 - 1.61733121401652e+45*cos(theta)**21 + 9.75975732596174e+44*cos(theta)**19 - 3.92686706526931e+44*cos(theta)**17 + 1.07239743147917e+44*cos(theta)**15 - 1.98592116940587e+43*cos(theta)**13 + 2.45097865844395e+42*cos(theta)**11 - 1.9452211574952e+41*cos(theta)**9 + 9.33706155597696e+39*cos(theta)**7 - 2.44182182659422e+38*cos(theta)**5 + 2.86598805938289e+36*cos(theta)**3 - 9.58524434576218e+33*cos(theta))*sin(20*phi)

@torch.jit.script
def Yl47_m_minus_19(theta, phi):
    return 9.20248641199569e-32*(1.0 - cos(theta)**2)**9.5*(9.79845590573467e+42*cos(theta)**28 - 3.98259820684699e+43*cos(theta)**26 + 7.11178251222678e+43*cos(theta)**24 - 7.35150551825689e+43*cos(theta)**22 + 4.87987866298087e+43*cos(theta)**20 - 2.18159281403851e+43*cos(theta)**18 + 6.70248394674481e+42*cos(theta)**16 - 1.41851512100419e+42*cos(theta)**14 + 2.04248221536996e+41*cos(theta)**12 - 1.9452211574952e+40*cos(theta)**10 + 1.16713269449712e+39*cos(theta)**8 - 4.06970304432371e+37*cos(theta)**6 + 7.16497014845723e+35*cos(theta)**4 - 4.79262217288109e+33*cos(theta)**2 + 5.10940530157899e+30)*sin(19*phi)

@torch.jit.script
def Yl47_m_minus_18(theta, phi):
    return 4.02602207266572e-30*(1.0 - cos(theta)**2)**9*(3.3787778985292e+41*cos(theta)**29 - 1.47503637290629e+42*cos(theta)**27 + 2.84471300489071e+42*cos(theta)**25 - 3.19630674706821e+42*cos(theta)**23 + 2.3237517442766e+42*cos(theta)**21 - 1.14820674423079e+42*cos(theta)**19 + 3.94263761573224e+41*cos(theta)**17 - 9.45676747336128e+40*cos(theta)**15 + 1.5711401656692e+40*cos(theta)**13 - 1.76838287045018e+39*cos(theta)**11 + 1.2968141049968e+38*cos(theta)**9 - 5.81386149189101e+36*cos(theta)**7 + 1.43299402969145e+35*cos(theta)**5 - 1.5975407242937e+33*cos(theta)**3 + 5.10940530157899e+30*cos(theta))*sin(18*phi)

@torch.jit.script
def Yl47_m_minus_17(theta, phi):
    return 1.77784320941706e-28*(1.0 - cos(theta)**2)**8.5*(1.12625929950973e+40*cos(theta)**30 - 5.26798704609391e+40*cos(theta)**28 + 1.09412038649643e+41*cos(theta)**26 - 1.33179447794509e+41*cos(theta)**24 + 1.056250792853e+41*cos(theta)**22 - 5.74103372115396e+40*cos(theta)**20 + 2.19035423096236e+40*cos(theta)**18 - 5.9104796708508e+39*cos(theta)**16 + 1.122242975478e+39*cos(theta)**14 - 1.47365239204182e+38*cos(theta)**12 + 1.2968141049968e+37*cos(theta)**10 - 7.26732686486376e+35*cos(theta)**8 + 2.38832338281908e+34*cos(theta)**6 - 3.99385181073424e+32*cos(theta)**4 + 2.55470265078949e+30*cos(theta)**2 - 2.62020784696358e+27)*sin(17*phi)

@torch.jit.script
def Yl47_m_minus_16(theta, phi):
    return 7.91888965127333e-27*(1.0 - cos(theta)**2)**8*(3.63309451454752e+38*cos(theta)**31 - 1.81654725727376e+39*cos(theta)**29 + 4.05229772776454e+39*cos(theta)**27 - 5.32717791178036e+39*cos(theta)**25 + 4.59239475153479e+39*cos(theta)**23 - 2.73382558150189e+39*cos(theta)**21 + 1.15281801629598e+39*cos(theta)**19 - 3.47675274755929e+38*cos(theta)**17 + 7.48161983652e+37*cos(theta)**15 - 1.13357876310909e+37*cos(theta)**13 + 1.17892191363345e+36*cos(theta)**11 - 8.0748076276264e+34*cos(theta)**9 + 3.41189054688439e+33*cos(theta)**7 - 7.98770362146848e+31*cos(theta)**5 + 8.51567550263164e+29*cos(theta)**3 - 2.62020784696358e+27*cos(theta))*sin(16*phi)

@torch.jit.script
def Yl47_m_minus_15(theta, phi):
    return 3.55557263504815e-25*(1.0 - cos(theta)**2)**7.5*(1.1353420357961e+37*cos(theta)**32 - 6.05515752424587e+37*cos(theta)**30 + 1.44724918848734e+38*cos(theta)**28 - 2.04891458145398e+38*cos(theta)**26 + 1.9134978131395e+38*cos(theta)**24 - 1.24264799159177e+38*cos(theta)**22 + 5.76409008147988e+37*cos(theta)**20 - 1.93152930419961e+37*cos(theta)**18 + 4.676012397825e+36*cos(theta)**16 - 8.09699116506493e+35*cos(theta)**14 + 9.82434928027879e+34*cos(theta)**12 - 8.0748076276264e+33*cos(theta)**10 + 4.26486318360549e+32*cos(theta)**8 - 1.33128393691141e+31*cos(theta)**6 + 2.12891887565791e+29*cos(theta)**4 - 1.31010392348179e+27*cos(theta)**2 + 1.29970627329543e+24)*sin(15*phi)

@torch.jit.script
def Yl47_m_minus_14(theta, phi):
    return 1.60828262371106e-23*(1.0 - cos(theta)**2)**7*(3.44043041150334e+35*cos(theta)**33 - 1.95327662072447e+36*cos(theta)**31 + 4.99051444305978e+36*cos(theta)**29 - 7.58857252390364e+36*cos(theta)**27 + 7.65399125255798e+36*cos(theta)**25 - 5.40281735474681e+36*cos(theta)**23 + 2.74480480070471e+36*cos(theta)**21 - 1.01659437063137e+36*cos(theta)**19 + 2.75059552813235e+35*cos(theta)**17 - 5.39799411004329e+34*cos(theta)**15 + 7.55719175406061e+33*cos(theta)**13 - 7.34073420693309e+32*cos(theta)**11 + 4.73873687067277e+31*cos(theta)**9 - 1.90183419558773e+30*cos(theta)**7 + 4.25783775131582e+28*cos(theta)**5 - 4.36701307827264e+26*cos(theta)**3 + 1.29970627329543e+24*cos(theta))*sin(14*phi)

@torch.jit.script
def Yl47_m_minus_13(theta, phi):
    return 7.32431047764493e-22*(1.0 - cos(theta)**2)**6.5*(1.01189129750098e+34*cos(theta)**34 - 6.10398943976398e+34*cos(theta)**32 + 1.66350481435326e+35*cos(theta)**30 - 2.71020447282273e+35*cos(theta)**28 + 2.94384278944538e+35*cos(theta)**26 - 2.25117389781117e+35*cos(theta)**24 + 1.24763854577487e+35*cos(theta)**22 - 5.08297185315686e+34*cos(theta)**20 + 1.5281086267402e+34*cos(theta)**18 - 3.37374631877706e+33*cos(theta)**16 + 5.39799411004329e+32*cos(theta)**14 - 6.11727850577758e+31*cos(theta)**12 + 4.73873687067277e+30*cos(theta)**10 - 2.37729274448467e+29*cos(theta)**8 + 7.09639625219304e+27*cos(theta)**6 - 1.09175326956816e+26*cos(theta)**4 + 6.49853136647714e+23*cos(theta)**2 - 6.2666647699876e+20)*sin(13*phi)

@torch.jit.script
def Yl47_m_minus_12(theta, phi):
    return 3.35642071771661e-20*(1.0 - cos(theta)**2)**6*(2.89111799285995e+32*cos(theta)**35 - 1.84969376962545e+33*cos(theta)**33 + 5.36614456242988e+33*cos(theta)**31 - 9.34553266490596e+33*cos(theta)**29 + 1.09031214423903e+34*cos(theta)**27 - 9.00469559124469e+33*cos(theta)**25 + 5.42451541641246e+33*cos(theta)**23 - 2.42046278721755e+33*cos(theta)**21 + 8.04267698284314e+32*cos(theta)**19 - 1.98455665810415e+32*cos(theta)**17 + 3.59866274002886e+31*cos(theta)**15 - 4.70559885059814e+30*cos(theta)**13 + 4.30794260970252e+29*cos(theta)**11 - 2.64143638276074e+28*cos(theta)**9 + 1.01377089317043e+27*cos(theta)**7 - 2.18350653913632e+25*cos(theta)**5 + 2.16617712215905e+23*cos(theta)**3 - 6.2666647699876e+20*cos(theta))*sin(12*phi)

@torch.jit.script
def Yl47_m_minus_11(theta, phi):
    return 1.54686940343682e-18*(1.0 - cos(theta)**2)**5.5*(8.03088331349985e+30*cos(theta)**36 - 5.44027579301603e+31*cos(theta)**34 + 1.67692017575934e+32*cos(theta)**32 - 3.11517755496865e+32*cos(theta)**30 + 3.89397194371082e+32*cos(theta)**28 - 3.46334445817103e+32*cos(theta)**26 + 2.26021475683853e+32*cos(theta)**24 - 1.10021035782616e+32*cos(theta)**22 + 4.02133849142157e+31*cos(theta)**20 - 1.10253147672453e+31*cos(theta)**18 + 2.24916421251804e+30*cos(theta)**16 - 3.36114203614153e+29*cos(theta)**14 + 3.5899521747521e+28*cos(theta)**12 - 2.64143638276074e+27*cos(theta)**10 + 1.26721361646304e+26*cos(theta)**8 - 3.6391775652272e+24*cos(theta)**6 + 5.41544280539762e+22*cos(theta)**4 - 3.1333323849938e+20*cos(theta)**2 + 2.95040714217872e+17)*sin(11*phi)

@torch.jit.script
def Yl47_m_minus_10(theta, phi):
    return 7.16586312000596e-17*(1.0 - cos(theta)**2)**5*(2.17050900364861e+29*cos(theta)**37 - 1.55436451229029e+30*cos(theta)**35 + 5.08157629017981e+30*cos(theta)**33 - 1.00489598547376e+31*cos(theta)**31 + 1.34274894610718e+31*cos(theta)**29 - 1.28272016969298e+31*cos(theta)**27 + 9.0408590273541e+30*cos(theta)**25 - 4.78352329489635e+30*cos(theta)**23 + 1.91492309115313e+30*cos(theta)**21 - 5.80279724591857e+29*cos(theta)**19 + 1.32303777206943e+29*cos(theta)**17 - 2.24076135742768e+28*cos(theta)**15 + 2.76150167288623e+27*cos(theta)**13 - 2.40130580250977e+26*cos(theta)**11 + 1.40801512940338e+25*cos(theta)**9 - 5.19882509318171e+23*cos(theta)**7 + 1.08308856107952e+22*cos(theta)**5 - 1.04444412833127e+20*cos(theta)**3 + 2.95040714217872e+17*cos(theta))*sin(10*phi)

@torch.jit.script
def Yl47_m_minus_9(theta, phi):
    return 3.33501456002215e-15*(1.0 - cos(theta)**2)**4.5*(5.71186579907529e+27*cos(theta)**38 - 4.31767920080637e+28*cos(theta)**36 + 1.49458126181759e+29*cos(theta)**34 - 3.1402999546055e+29*cos(theta)**32 + 4.47582982035726e+29*cos(theta)**30 - 4.5811434631892e+29*cos(theta)**28 + 3.47725347205927e+29*cos(theta)**26 - 1.99313470620681e+29*cos(theta)**24 + 8.70419586887785e+28*cos(theta)**22 - 2.90139862295928e+28*cos(theta)**20 + 7.35020984483019e+27*cos(theta)**18 - 1.4004758483923e+27*cos(theta)**16 + 1.97250119491874e+26*cos(theta)**14 - 2.00108816875814e+25*cos(theta)**12 + 1.40801512940338e+24*cos(theta)**10 - 6.49853136647714e+22*cos(theta)**8 + 1.80514760179921e+21*cos(theta)**6 - 2.61111032082817e+19*cos(theta)**4 + 1.47520357108936e+17*cos(theta)**2 - 136214549500403.0)*sin(9*phi)

@torch.jit.script
def Yl47_m_minus_8(theta, phi):
    return 1.55856188521285e-13*(1.0 - cos(theta)**2)**4*(1.46458097412187e+26*cos(theta)**39 - 1.16694032454226e+27*cos(theta)**37 + 4.27023217662169e+27*cos(theta)**35 - 9.51606046850151e+27*cos(theta)**33 + 1.44381607108299e+28*cos(theta)**31 - 1.57970464247903e+28*cos(theta)**29 + 1.28787165631825e+28*cos(theta)**27 - 7.97253882482725e+27*cos(theta)**25 + 3.78443298646863e+27*cos(theta)**23 - 1.38161839188537e+27*cos(theta)**21 + 3.86853149727905e+26*cos(theta)**19 - 8.23809322583707e+25*cos(theta)**17 + 1.31500079661249e+25*cos(theta)**15 - 1.53929859135241e+24*cos(theta)**13 + 1.28001375400307e+23*cos(theta)**11 - 7.22059040719682e+21*cos(theta)**9 + 2.57878228828458e+20*cos(theta)**7 - 5.22222064165633e+18*cos(theta)**5 + 4.91734523696453e+16*cos(theta)**3 - 136214549500403.0*cos(theta))*sin(8*phi)

@torch.jit.script
def Yl47_m_minus_7(theta, phi):
    return 7.31030322906247e-12*(1.0 - cos(theta)**2)**3.5*(3.66145243530467e+24*cos(theta)**40 - 3.07089559090069e+25*cos(theta)**38 + 1.18617560461714e+26*cos(theta)**36 - 2.79884131426515e+26*cos(theta)**34 + 4.51192522213434e+26*cos(theta)**32 - 5.26568214159678e+26*cos(theta)**30 + 4.59954162970803e+26*cos(theta)**28 - 3.06636108647202e+26*cos(theta)**26 + 1.57684707769526e+26*cos(theta)**24 - 6.28008359947897e+25*cos(theta)**22 + 1.93426574863952e+25*cos(theta)**20 - 4.57671845879837e+24*cos(theta)**18 + 8.21875497882807e+23*cos(theta)**16 - 1.09949899382315e+23*cos(theta)**14 + 1.06667812833589e+22*cos(theta)**12 - 7.22059040719682e+20*cos(theta)**10 + 3.22347786035572e+19*cos(theta)**8 - 8.70370106942722e+17*cos(theta)**6 + 1.22933630924113e+16*cos(theta)**4 - 68107274750201.3*cos(theta)**2 + 61915704318.3648)*sin(7*phi)

@torch.jit.script
def Yl47_m_minus_6(theta, phi):
    return 3.43972877896009e-10*(1.0 - cos(theta)**2)**3*(8.93037179342602e+22*cos(theta)**41 - 7.87409125871972e+23*cos(theta)**39 + 3.20588001247874e+24*cos(theta)**37 - 7.996689469329e+24*cos(theta)**35 + 1.36725006731344e+25*cos(theta)**33 - 1.69860714245057e+25*cos(theta)**31 + 1.58604883783036e+25*cos(theta)**29 - 1.13568929128593e+25*cos(theta)**27 + 6.30738831078105e+24*cos(theta)**25 - 2.73047113020825e+24*cos(theta)**23 + 9.21078927923582e+23*cos(theta)**21 - 2.40879918884125e+23*cos(theta)**19 + 4.8345617522518e+22*cos(theta)**17 - 7.32999329215435e+21*cos(theta)**15 + 8.20521637181457e+20*cos(theta)**13 - 6.56417309745166e+19*cos(theta)**11 + 3.58164206706192e+18*cos(theta)**9 - 1.24338586706103e+17*cos(theta)**7 + 2.45867261848227e+15*cos(theta)**5 - 22702424916733.8*cos(theta)**3 + 61915704318.3648*cos(theta))*sin(6*phi)

@torch.jit.script
def Yl47_m_minus_5(theta, phi):
    return 1.62288138956816e-8*(1.0 - cos(theta)**2)**2.5*(2.12627899843477e+21*cos(theta)**42 - 1.96852281467993e+22*cos(theta)**40 + 8.43652634862827e+22*cos(theta)**38 - 2.22130263036917e+23*cos(theta)**36 + 4.02132372739246e+23*cos(theta)**34 - 5.30814732015804e+23*cos(theta)**32 + 5.28682945943452e+23*cos(theta)**30 - 4.05603318316405e+23*cos(theta)**28 + 2.42591858106964e+23*cos(theta)**26 - 1.13769630425344e+23*cos(theta)**24 + 4.18672239965265e+22*cos(theta)**22 - 1.20439959442062e+22*cos(theta)**20 + 2.68586764013989e+21*cos(theta)**18 - 4.58124580759647e+20*cos(theta)**16 + 5.86086883701041e+19*cos(theta)**14 - 5.47014424787638e+18*cos(theta)**12 + 3.58164206706192e+17*cos(theta)**10 - 1.55423233382629e+16*cos(theta)**8 + 409778769747044.0*cos(theta)**6 - 5675606229183.44*cos(theta)**4 + 30957852159.1824*cos(theta)**2 - 27814781.8141801)*sin(5*phi)

@torch.jit.script
def Yl47_m_minus_4(theta, phi):
    return 7.67401563348715e-7*(1.0 - cos(theta)**2)**2*(4.94483488008086e+19*cos(theta)**43 - 4.80127515775593e+20*cos(theta)**41 + 2.16321188426366e+21*cos(theta)**39 - 6.00352062261937e+21*cos(theta)**37 + 1.14894963639784e+22*cos(theta)**35 - 1.60852949095698e+22*cos(theta)**33 + 1.7054288578821e+22*cos(theta)**31 - 1.39863213212553e+22*cos(theta)**29 + 8.98488363359124e+21*cos(theta)**27 - 4.55078521701375e+21*cos(theta)**25 + 1.8203140868055e+21*cos(theta)**23 - 5.73523616390774e+20*cos(theta)**21 + 1.41361454744205e+20*cos(theta)**19 - 2.69485047505675e+19*cos(theta)**17 + 3.90724589134027e+18*cos(theta)**15 - 4.20780326759722e+17*cos(theta)**13 + 3.25603824278356e+16*cos(theta)**11 - 1.72692481536254e+15*cos(theta)**9 + 58539824249577.8*cos(theta)**7 - 1135121245836.69*cos(theta)**5 + 10319284053.0608*cos(theta)**3 - 27814781.8141801*cos(theta))*sin(4*phi)

@torch.jit.script
def Yl47_m_minus_3(theta, phi):
    return 3.63524851662309e-5*(1.0 - cos(theta)**2)**1.5*(1.12382610910929e+18*cos(theta)**44 - 1.14316075184665e+19*cos(theta)**42 + 5.40802971065915e+19*cos(theta)**40 - 1.57987384805773e+20*cos(theta)**38 + 3.19152676777179e+20*cos(theta)**36 - 4.73096909104995e+20*cos(theta)**34 + 5.32946518088157e+20*cos(theta)**32 - 4.66210710708511e+20*cos(theta)**30 + 3.20888701199687e+20*cos(theta)**28 - 1.75030200654375e+20*cos(theta)**26 + 7.58464202835625e+19*cos(theta)**24 - 2.60692552904897e+19*cos(theta)**22 + 7.06807273721024e+18*cos(theta)**20 - 1.4971391528093e+18*cos(theta)**18 + 2.44202868208767e+17*cos(theta)**16 - 3.00557376256944e+16*cos(theta)**14 + 2.71336520231963e+15*cos(theta)**12 - 172692481536254.0*cos(theta)**10 + 7317478031197.22*cos(theta)**8 - 189186874306.115*cos(theta)**6 + 2579821013.2652*cos(theta)**4 - 13907390.90709*cos(theta)**2 + 12395.1790615776)*sin(3*phi)

@torch.jit.script
def Yl47_m_minus_2(theta, phi):
    return 0.00172434977599161*(1.0 - cos(theta)**2)*(2.49739135357619e+16*cos(theta)**45 - 2.65851337638756e+17*cos(theta)**43 + 1.31903163674613e+18*cos(theta)**41 - 4.05095858476341e+18*cos(theta)**39 + 8.62574802100484e+18*cos(theta)**37 - 1.3517054545857e+19*cos(theta)**35 + 1.61498944875199e+19*cos(theta)**33 - 1.50390551841455e+19*cos(theta)**31 + 1.10651276275754e+19*cos(theta)**29 - 6.48260002423611e+18*cos(theta)**27 + 3.0338568113425e+18*cos(theta)**25 - 1.1334458821952e+18*cos(theta)**23 + 3.36574892248107e+17*cos(theta)**21 - 7.87967975162791e+16*cos(theta)**19 + 1.43648746005157e+16*cos(theta)**17 - 2.00371584171296e+15*cos(theta)**15 + 208720400178433.0*cos(theta)**13 - 15699316503295.9*cos(theta)**11 + 813053114577.469*cos(theta)**9 - 27026696329.4449*cos(theta)**7 + 515964202.65304*cos(theta)**5 - 4635796.96903001*cos(theta)**3 + 12395.1790615776*cos(theta))*sin(2*phi)

@torch.jit.script
def Yl47_m_minus_1(theta, phi):
    return 0.0818657643097229*(1.0 - cos(theta)**2)**0.5*(542911163820911.0*cos(theta)**46 - 6.04207585542627e+15*cos(theta)**44 + 3.14055151606222e+16*cos(theta)**42 - 1.01273964619085e+17*cos(theta)**40 + 2.26993368973812e+17*cos(theta)**38 - 3.75473737384917e+17*cos(theta)**36 + 4.74996896691762e+17*cos(theta)**34 - 4.69970474504548e+17*cos(theta)**32 + 3.68837587585847e+17*cos(theta)**30 - 2.31521429437004e+17*cos(theta)**28 + 1.1668680043625e+17*cos(theta)**26 - 4.72269117581335e+16*cos(theta)**24 + 1.52988587385503e+16*cos(theta)**22 - 3.93983987581396e+15*cos(theta)**20 + 798048588917539.0*cos(theta)**18 - 125232240107060.0*cos(theta)**16 + 14908600012745.2*cos(theta)**14 - 1308276375274.65*cos(theta)**12 + 81305311457.7469*cos(theta)**10 - 3378337041.18062*cos(theta)**8 + 85994033.7755067*cos(theta)**6 - 1158949.2422575*cos(theta)**4 + 6197.58953078878*cos(theta)**2 - 5.49919213024737)*sin(phi)

@torch.jit.script
def Yl47_m0(theta, phi):
    return 31760533198865.4*cos(theta)**47 - 369173509548103.0*cos(theta)**45 + 2.00814161787155e+15*cos(theta)**43 - 6.7915800784195e+15*cos(theta)**41 + 1.60031484606437e+16*cos(theta)**39 - 2.79019600219693e+16*cos(theta)**37 + 3.7314669426971e+16*cos(theta)**35 - 3.91573691517597e+16*cos(theta)**33 + 3.27137514432423e+16*cos(theta)**31 - 2.19507856004439e+16*cos(theta)**29 + 1.18826919383737e+16*cos(theta)**27 - 5.19405338775735e+15*cos(theta)**25 + 1.82889203794273e+15*cos(theta)**23 - 515841344035129.0*cos(theta)**21 + 115486868067566.0*cos(theta)**19 - 20254619938003.9*cos(theta)**17 + 2732766182111.64*cos(theta)**15 - 276702458169.452*cos(theta)**13 + 20322779413.5756*cos(theta)**11 - 1032089443.90273*cos(theta)**9 + 33777472.7095439*cos(theta)**7 - 637310.805840451*cos(theta)**5 + 5680.13195936231*cos(theta)**3 - 15.1201383124108*cos(theta)

@torch.jit.script
def Yl47_m1(theta, phi):
    return 0.0818657643097229*(1.0 - cos(theta)**2)**0.5*(542911163820911.0*cos(theta)**46 - 6.04207585542627e+15*cos(theta)**44 + 3.14055151606222e+16*cos(theta)**42 - 1.01273964619085e+17*cos(theta)**40 + 2.26993368973812e+17*cos(theta)**38 - 3.75473737384917e+17*cos(theta)**36 + 4.74996896691762e+17*cos(theta)**34 - 4.69970474504548e+17*cos(theta)**32 + 3.68837587585847e+17*cos(theta)**30 - 2.31521429437004e+17*cos(theta)**28 + 1.1668680043625e+17*cos(theta)**26 - 4.72269117581335e+16*cos(theta)**24 + 1.52988587385503e+16*cos(theta)**22 - 3.93983987581396e+15*cos(theta)**20 + 798048588917539.0*cos(theta)**18 - 125232240107060.0*cos(theta)**16 + 14908600012745.2*cos(theta)**14 - 1308276375274.65*cos(theta)**12 + 81305311457.7469*cos(theta)**10 - 3378337041.18062*cos(theta)**8 + 85994033.7755067*cos(theta)**6 - 1158949.2422575*cos(theta)**4 + 6197.58953078878*cos(theta)**2 - 5.49919213024737)*cos(phi)

@torch.jit.script
def Yl47_m2(theta, phi):
    return 0.00172434977599161*(1.0 - cos(theta)**2)*(2.49739135357619e+16*cos(theta)**45 - 2.65851337638756e+17*cos(theta)**43 + 1.31903163674613e+18*cos(theta)**41 - 4.05095858476341e+18*cos(theta)**39 + 8.62574802100484e+18*cos(theta)**37 - 1.3517054545857e+19*cos(theta)**35 + 1.61498944875199e+19*cos(theta)**33 - 1.50390551841455e+19*cos(theta)**31 + 1.10651276275754e+19*cos(theta)**29 - 6.48260002423611e+18*cos(theta)**27 + 3.0338568113425e+18*cos(theta)**25 - 1.1334458821952e+18*cos(theta)**23 + 3.36574892248107e+17*cos(theta)**21 - 7.87967975162791e+16*cos(theta)**19 + 1.43648746005157e+16*cos(theta)**17 - 2.00371584171296e+15*cos(theta)**15 + 208720400178433.0*cos(theta)**13 - 15699316503295.9*cos(theta)**11 + 813053114577.469*cos(theta)**9 - 27026696329.4449*cos(theta)**7 + 515964202.65304*cos(theta)**5 - 4635796.96903001*cos(theta)**3 + 12395.1790615776*cos(theta))*cos(2*phi)

@torch.jit.script
def Yl47_m3(theta, phi):
    return 3.63524851662309e-5*(1.0 - cos(theta)**2)**1.5*(1.12382610910929e+18*cos(theta)**44 - 1.14316075184665e+19*cos(theta)**42 + 5.40802971065915e+19*cos(theta)**40 - 1.57987384805773e+20*cos(theta)**38 + 3.19152676777179e+20*cos(theta)**36 - 4.73096909104995e+20*cos(theta)**34 + 5.32946518088157e+20*cos(theta)**32 - 4.66210710708511e+20*cos(theta)**30 + 3.20888701199687e+20*cos(theta)**28 - 1.75030200654375e+20*cos(theta)**26 + 7.58464202835625e+19*cos(theta)**24 - 2.60692552904897e+19*cos(theta)**22 + 7.06807273721024e+18*cos(theta)**20 - 1.4971391528093e+18*cos(theta)**18 + 2.44202868208767e+17*cos(theta)**16 - 3.00557376256944e+16*cos(theta)**14 + 2.71336520231963e+15*cos(theta)**12 - 172692481536254.0*cos(theta)**10 + 7317478031197.22*cos(theta)**8 - 189186874306.115*cos(theta)**6 + 2579821013.2652*cos(theta)**4 - 13907390.90709*cos(theta)**2 + 12395.1790615776)*cos(3*phi)

@torch.jit.script
def Yl47_m4(theta, phi):
    return 7.67401563348715e-7*(1.0 - cos(theta)**2)**2*(4.94483488008086e+19*cos(theta)**43 - 4.80127515775593e+20*cos(theta)**41 + 2.16321188426366e+21*cos(theta)**39 - 6.00352062261937e+21*cos(theta)**37 + 1.14894963639784e+22*cos(theta)**35 - 1.60852949095698e+22*cos(theta)**33 + 1.7054288578821e+22*cos(theta)**31 - 1.39863213212553e+22*cos(theta)**29 + 8.98488363359124e+21*cos(theta)**27 - 4.55078521701375e+21*cos(theta)**25 + 1.8203140868055e+21*cos(theta)**23 - 5.73523616390774e+20*cos(theta)**21 + 1.41361454744205e+20*cos(theta)**19 - 2.69485047505675e+19*cos(theta)**17 + 3.90724589134027e+18*cos(theta)**15 - 4.20780326759722e+17*cos(theta)**13 + 3.25603824278356e+16*cos(theta)**11 - 1.72692481536254e+15*cos(theta)**9 + 58539824249577.8*cos(theta)**7 - 1135121245836.69*cos(theta)**5 + 10319284053.0608*cos(theta)**3 - 27814781.8141801*cos(theta))*cos(4*phi)

@torch.jit.script
def Yl47_m5(theta, phi):
    return 1.62288138956816e-8*(1.0 - cos(theta)**2)**2.5*(2.12627899843477e+21*cos(theta)**42 - 1.96852281467993e+22*cos(theta)**40 + 8.43652634862827e+22*cos(theta)**38 - 2.22130263036917e+23*cos(theta)**36 + 4.02132372739246e+23*cos(theta)**34 - 5.30814732015804e+23*cos(theta)**32 + 5.28682945943452e+23*cos(theta)**30 - 4.05603318316405e+23*cos(theta)**28 + 2.42591858106964e+23*cos(theta)**26 - 1.13769630425344e+23*cos(theta)**24 + 4.18672239965265e+22*cos(theta)**22 - 1.20439959442062e+22*cos(theta)**20 + 2.68586764013989e+21*cos(theta)**18 - 4.58124580759647e+20*cos(theta)**16 + 5.86086883701041e+19*cos(theta)**14 - 5.47014424787638e+18*cos(theta)**12 + 3.58164206706192e+17*cos(theta)**10 - 1.55423233382629e+16*cos(theta)**8 + 409778769747044.0*cos(theta)**6 - 5675606229183.44*cos(theta)**4 + 30957852159.1824*cos(theta)**2 - 27814781.8141801)*cos(5*phi)

@torch.jit.script
def Yl47_m6(theta, phi):
    return 3.43972877896009e-10*(1.0 - cos(theta)**2)**3*(8.93037179342602e+22*cos(theta)**41 - 7.87409125871972e+23*cos(theta)**39 + 3.20588001247874e+24*cos(theta)**37 - 7.996689469329e+24*cos(theta)**35 + 1.36725006731344e+25*cos(theta)**33 - 1.69860714245057e+25*cos(theta)**31 + 1.58604883783036e+25*cos(theta)**29 - 1.13568929128593e+25*cos(theta)**27 + 6.30738831078105e+24*cos(theta)**25 - 2.73047113020825e+24*cos(theta)**23 + 9.21078927923582e+23*cos(theta)**21 - 2.40879918884125e+23*cos(theta)**19 + 4.8345617522518e+22*cos(theta)**17 - 7.32999329215435e+21*cos(theta)**15 + 8.20521637181457e+20*cos(theta)**13 - 6.56417309745166e+19*cos(theta)**11 + 3.58164206706192e+18*cos(theta)**9 - 1.24338586706103e+17*cos(theta)**7 + 2.45867261848227e+15*cos(theta)**5 - 22702424916733.8*cos(theta)**3 + 61915704318.3648*cos(theta))*cos(6*phi)

@torch.jit.script
def Yl47_m7(theta, phi):
    return 7.31030322906247e-12*(1.0 - cos(theta)**2)**3.5*(3.66145243530467e+24*cos(theta)**40 - 3.07089559090069e+25*cos(theta)**38 + 1.18617560461714e+26*cos(theta)**36 - 2.79884131426515e+26*cos(theta)**34 + 4.51192522213434e+26*cos(theta)**32 - 5.26568214159678e+26*cos(theta)**30 + 4.59954162970803e+26*cos(theta)**28 - 3.06636108647202e+26*cos(theta)**26 + 1.57684707769526e+26*cos(theta)**24 - 6.28008359947897e+25*cos(theta)**22 + 1.93426574863952e+25*cos(theta)**20 - 4.57671845879837e+24*cos(theta)**18 + 8.21875497882807e+23*cos(theta)**16 - 1.09949899382315e+23*cos(theta)**14 + 1.06667812833589e+22*cos(theta)**12 - 7.22059040719682e+20*cos(theta)**10 + 3.22347786035572e+19*cos(theta)**8 - 8.70370106942722e+17*cos(theta)**6 + 1.22933630924113e+16*cos(theta)**4 - 68107274750201.3*cos(theta)**2 + 61915704318.3648)*cos(7*phi)

@torch.jit.script
def Yl47_m8(theta, phi):
    return 1.55856188521285e-13*(1.0 - cos(theta)**2)**4*(1.46458097412187e+26*cos(theta)**39 - 1.16694032454226e+27*cos(theta)**37 + 4.27023217662169e+27*cos(theta)**35 - 9.51606046850151e+27*cos(theta)**33 + 1.44381607108299e+28*cos(theta)**31 - 1.57970464247903e+28*cos(theta)**29 + 1.28787165631825e+28*cos(theta)**27 - 7.97253882482725e+27*cos(theta)**25 + 3.78443298646863e+27*cos(theta)**23 - 1.38161839188537e+27*cos(theta)**21 + 3.86853149727905e+26*cos(theta)**19 - 8.23809322583707e+25*cos(theta)**17 + 1.31500079661249e+25*cos(theta)**15 - 1.53929859135241e+24*cos(theta)**13 + 1.28001375400307e+23*cos(theta)**11 - 7.22059040719682e+21*cos(theta)**9 + 2.57878228828458e+20*cos(theta)**7 - 5.22222064165633e+18*cos(theta)**5 + 4.91734523696453e+16*cos(theta)**3 - 136214549500403.0*cos(theta))*cos(8*phi)

@torch.jit.script
def Yl47_m9(theta, phi):
    return 3.33501456002215e-15*(1.0 - cos(theta)**2)**4.5*(5.71186579907529e+27*cos(theta)**38 - 4.31767920080637e+28*cos(theta)**36 + 1.49458126181759e+29*cos(theta)**34 - 3.1402999546055e+29*cos(theta)**32 + 4.47582982035726e+29*cos(theta)**30 - 4.5811434631892e+29*cos(theta)**28 + 3.47725347205927e+29*cos(theta)**26 - 1.99313470620681e+29*cos(theta)**24 + 8.70419586887785e+28*cos(theta)**22 - 2.90139862295928e+28*cos(theta)**20 + 7.35020984483019e+27*cos(theta)**18 - 1.4004758483923e+27*cos(theta)**16 + 1.97250119491874e+26*cos(theta)**14 - 2.00108816875814e+25*cos(theta)**12 + 1.40801512940338e+24*cos(theta)**10 - 6.49853136647714e+22*cos(theta)**8 + 1.80514760179921e+21*cos(theta)**6 - 2.61111032082817e+19*cos(theta)**4 + 1.47520357108936e+17*cos(theta)**2 - 136214549500403.0)*cos(9*phi)

@torch.jit.script
def Yl47_m10(theta, phi):
    return 7.16586312000596e-17*(1.0 - cos(theta)**2)**5*(2.17050900364861e+29*cos(theta)**37 - 1.55436451229029e+30*cos(theta)**35 + 5.08157629017981e+30*cos(theta)**33 - 1.00489598547376e+31*cos(theta)**31 + 1.34274894610718e+31*cos(theta)**29 - 1.28272016969298e+31*cos(theta)**27 + 9.0408590273541e+30*cos(theta)**25 - 4.78352329489635e+30*cos(theta)**23 + 1.91492309115313e+30*cos(theta)**21 - 5.80279724591857e+29*cos(theta)**19 + 1.32303777206943e+29*cos(theta)**17 - 2.24076135742768e+28*cos(theta)**15 + 2.76150167288623e+27*cos(theta)**13 - 2.40130580250977e+26*cos(theta)**11 + 1.40801512940338e+25*cos(theta)**9 - 5.19882509318171e+23*cos(theta)**7 + 1.08308856107952e+22*cos(theta)**5 - 1.04444412833127e+20*cos(theta)**3 + 2.95040714217872e+17*cos(theta))*cos(10*phi)

@torch.jit.script
def Yl47_m11(theta, phi):
    return 1.54686940343682e-18*(1.0 - cos(theta)**2)**5.5*(8.03088331349985e+30*cos(theta)**36 - 5.44027579301603e+31*cos(theta)**34 + 1.67692017575934e+32*cos(theta)**32 - 3.11517755496865e+32*cos(theta)**30 + 3.89397194371082e+32*cos(theta)**28 - 3.46334445817103e+32*cos(theta)**26 + 2.26021475683853e+32*cos(theta)**24 - 1.10021035782616e+32*cos(theta)**22 + 4.02133849142157e+31*cos(theta)**20 - 1.10253147672453e+31*cos(theta)**18 + 2.24916421251804e+30*cos(theta)**16 - 3.36114203614153e+29*cos(theta)**14 + 3.5899521747521e+28*cos(theta)**12 - 2.64143638276074e+27*cos(theta)**10 + 1.26721361646304e+26*cos(theta)**8 - 3.6391775652272e+24*cos(theta)**6 + 5.41544280539762e+22*cos(theta)**4 - 3.1333323849938e+20*cos(theta)**2 + 2.95040714217872e+17)*cos(11*phi)

@torch.jit.script
def Yl47_m12(theta, phi):
    return 3.35642071771661e-20*(1.0 - cos(theta)**2)**6*(2.89111799285995e+32*cos(theta)**35 - 1.84969376962545e+33*cos(theta)**33 + 5.36614456242988e+33*cos(theta)**31 - 9.34553266490596e+33*cos(theta)**29 + 1.09031214423903e+34*cos(theta)**27 - 9.00469559124469e+33*cos(theta)**25 + 5.42451541641246e+33*cos(theta)**23 - 2.42046278721755e+33*cos(theta)**21 + 8.04267698284314e+32*cos(theta)**19 - 1.98455665810415e+32*cos(theta)**17 + 3.59866274002886e+31*cos(theta)**15 - 4.70559885059814e+30*cos(theta)**13 + 4.30794260970252e+29*cos(theta)**11 - 2.64143638276074e+28*cos(theta)**9 + 1.01377089317043e+27*cos(theta)**7 - 2.18350653913632e+25*cos(theta)**5 + 2.16617712215905e+23*cos(theta)**3 - 6.2666647699876e+20*cos(theta))*cos(12*phi)

@torch.jit.script
def Yl47_m13(theta, phi):
    return 7.32431047764493e-22*(1.0 - cos(theta)**2)**6.5*(1.01189129750098e+34*cos(theta)**34 - 6.10398943976398e+34*cos(theta)**32 + 1.66350481435326e+35*cos(theta)**30 - 2.71020447282273e+35*cos(theta)**28 + 2.94384278944538e+35*cos(theta)**26 - 2.25117389781117e+35*cos(theta)**24 + 1.24763854577487e+35*cos(theta)**22 - 5.08297185315686e+34*cos(theta)**20 + 1.5281086267402e+34*cos(theta)**18 - 3.37374631877706e+33*cos(theta)**16 + 5.39799411004329e+32*cos(theta)**14 - 6.11727850577758e+31*cos(theta)**12 + 4.73873687067277e+30*cos(theta)**10 - 2.37729274448467e+29*cos(theta)**8 + 7.09639625219304e+27*cos(theta)**6 - 1.09175326956816e+26*cos(theta)**4 + 6.49853136647714e+23*cos(theta)**2 - 6.2666647699876e+20)*cos(13*phi)

@torch.jit.script
def Yl47_m14(theta, phi):
    return 1.60828262371106e-23*(1.0 - cos(theta)**2)**7*(3.44043041150334e+35*cos(theta)**33 - 1.95327662072447e+36*cos(theta)**31 + 4.99051444305978e+36*cos(theta)**29 - 7.58857252390364e+36*cos(theta)**27 + 7.65399125255798e+36*cos(theta)**25 - 5.40281735474681e+36*cos(theta)**23 + 2.74480480070471e+36*cos(theta)**21 - 1.01659437063137e+36*cos(theta)**19 + 2.75059552813235e+35*cos(theta)**17 - 5.39799411004329e+34*cos(theta)**15 + 7.55719175406061e+33*cos(theta)**13 - 7.34073420693309e+32*cos(theta)**11 + 4.73873687067277e+31*cos(theta)**9 - 1.90183419558773e+30*cos(theta)**7 + 4.25783775131582e+28*cos(theta)**5 - 4.36701307827264e+26*cos(theta)**3 + 1.29970627329543e+24*cos(theta))*cos(14*phi)

@torch.jit.script
def Yl47_m15(theta, phi):
    return 3.55557263504815e-25*(1.0 - cos(theta)**2)**7.5*(1.1353420357961e+37*cos(theta)**32 - 6.05515752424587e+37*cos(theta)**30 + 1.44724918848734e+38*cos(theta)**28 - 2.04891458145398e+38*cos(theta)**26 + 1.9134978131395e+38*cos(theta)**24 - 1.24264799159177e+38*cos(theta)**22 + 5.76409008147988e+37*cos(theta)**20 - 1.93152930419961e+37*cos(theta)**18 + 4.676012397825e+36*cos(theta)**16 - 8.09699116506493e+35*cos(theta)**14 + 9.82434928027879e+34*cos(theta)**12 - 8.0748076276264e+33*cos(theta)**10 + 4.26486318360549e+32*cos(theta)**8 - 1.33128393691141e+31*cos(theta)**6 + 2.12891887565791e+29*cos(theta)**4 - 1.31010392348179e+27*cos(theta)**2 + 1.29970627329543e+24)*cos(15*phi)

@torch.jit.script
def Yl47_m16(theta, phi):
    return 7.91888965127333e-27*(1.0 - cos(theta)**2)**8*(3.63309451454752e+38*cos(theta)**31 - 1.81654725727376e+39*cos(theta)**29 + 4.05229772776454e+39*cos(theta)**27 - 5.32717791178036e+39*cos(theta)**25 + 4.59239475153479e+39*cos(theta)**23 - 2.73382558150189e+39*cos(theta)**21 + 1.15281801629598e+39*cos(theta)**19 - 3.47675274755929e+38*cos(theta)**17 + 7.48161983652e+37*cos(theta)**15 - 1.13357876310909e+37*cos(theta)**13 + 1.17892191363345e+36*cos(theta)**11 - 8.0748076276264e+34*cos(theta)**9 + 3.41189054688439e+33*cos(theta)**7 - 7.98770362146848e+31*cos(theta)**5 + 8.51567550263164e+29*cos(theta)**3 - 2.62020784696358e+27*cos(theta))*cos(16*phi)

@torch.jit.script
def Yl47_m17(theta, phi):
    return 1.77784320941706e-28*(1.0 - cos(theta)**2)**8.5*(1.12625929950973e+40*cos(theta)**30 - 5.26798704609391e+40*cos(theta)**28 + 1.09412038649643e+41*cos(theta)**26 - 1.33179447794509e+41*cos(theta)**24 + 1.056250792853e+41*cos(theta)**22 - 5.74103372115396e+40*cos(theta)**20 + 2.19035423096236e+40*cos(theta)**18 - 5.9104796708508e+39*cos(theta)**16 + 1.122242975478e+39*cos(theta)**14 - 1.47365239204182e+38*cos(theta)**12 + 1.2968141049968e+37*cos(theta)**10 - 7.26732686486376e+35*cos(theta)**8 + 2.38832338281908e+34*cos(theta)**6 - 3.99385181073424e+32*cos(theta)**4 + 2.55470265078949e+30*cos(theta)**2 - 2.62020784696358e+27)*cos(17*phi)

@torch.jit.script
def Yl47_m18(theta, phi):
    return 4.02602207266572e-30*(1.0 - cos(theta)**2)**9*(3.3787778985292e+41*cos(theta)**29 - 1.47503637290629e+42*cos(theta)**27 + 2.84471300489071e+42*cos(theta)**25 - 3.19630674706821e+42*cos(theta)**23 + 2.3237517442766e+42*cos(theta)**21 - 1.14820674423079e+42*cos(theta)**19 + 3.94263761573224e+41*cos(theta)**17 - 9.45676747336128e+40*cos(theta)**15 + 1.5711401656692e+40*cos(theta)**13 - 1.76838287045018e+39*cos(theta)**11 + 1.2968141049968e+38*cos(theta)**9 - 5.81386149189101e+36*cos(theta)**7 + 1.43299402969145e+35*cos(theta)**5 - 1.5975407242937e+33*cos(theta)**3 + 5.10940530157899e+30*cos(theta))*cos(18*phi)

@torch.jit.script
def Yl47_m19(theta, phi):
    return 9.20248641199569e-32*(1.0 - cos(theta)**2)**9.5*(9.79845590573467e+42*cos(theta)**28 - 3.98259820684699e+43*cos(theta)**26 + 7.11178251222678e+43*cos(theta)**24 - 7.35150551825689e+43*cos(theta)**22 + 4.87987866298087e+43*cos(theta)**20 - 2.18159281403851e+43*cos(theta)**18 + 6.70248394674481e+42*cos(theta)**16 - 1.41851512100419e+42*cos(theta)**14 + 2.04248221536996e+41*cos(theta)**12 - 1.9452211574952e+40*cos(theta)**10 + 1.16713269449712e+39*cos(theta)**8 - 4.06970304432371e+37*cos(theta)**6 + 7.16497014845723e+35*cos(theta)**4 - 4.79262217288109e+33*cos(theta)**2 + 5.10940530157899e+30)*cos(19*phi)

@torch.jit.script
def Yl47_m20(theta, phi):
    return 2.12465670327417e-33*(1.0 - cos(theta)**2)**10*(2.74356765360571e+44*cos(theta)**27 - 1.03547553378022e+45*cos(theta)**25 + 1.70682780293443e+45*cos(theta)**23 - 1.61733121401652e+45*cos(theta)**21 + 9.75975732596174e+44*cos(theta)**19 - 3.92686706526931e+44*cos(theta)**17 + 1.07239743147917e+44*cos(theta)**15 - 1.98592116940587e+43*cos(theta)**13 + 2.45097865844395e+42*cos(theta)**11 - 1.9452211574952e+41*cos(theta)**9 + 9.33706155597696e+39*cos(theta)**7 - 2.44182182659422e+38*cos(theta)**5 + 2.86598805938289e+36*cos(theta)**3 - 9.58524434576218e+33*cos(theta))*cos(20*phi)

@torch.jit.script
def Yl47_m21(theta, phi):
    return 4.95852411165239e-35*(1.0 - cos(theta)**2)**10.5*(7.40763266473541e+45*cos(theta)**26 - 2.58868883445055e+46*cos(theta)**24 + 3.92570394674918e+46*cos(theta)**22 - 3.39639554943468e+46*cos(theta)**20 + 1.85435389193273e+46*cos(theta)**18 - 6.67567401095783e+45*cos(theta)**16 + 1.60859614721875e+45*cos(theta)**14 - 2.58169752022763e+44*cos(theta)**12 + 2.69607652428835e+43*cos(theta)**10 - 1.75069904174568e+42*cos(theta)**8 + 6.53594308918387e+40*cos(theta)**6 - 1.22091091329711e+39*cos(theta)**4 + 8.59796417814867e+36*cos(theta)**2 - 9.58524434576218e+33)*cos(21*phi)

@torch.jit.script
def Yl47_m22(theta, phi):
    return 1.1706881168749e-36*(1.0 - cos(theta)**2)**11*(1.92598449283121e+47*cos(theta)**25 - 6.21285320268131e+47*cos(theta)**23 + 8.6365486828482e+47*cos(theta)**21 - 6.79279109886937e+47*cos(theta)**19 + 3.33783700547891e+47*cos(theta)**17 - 1.06810784175325e+47*cos(theta)**15 + 2.25203460610626e+46*cos(theta)**13 - 3.09803702427316e+45*cos(theta)**11 + 2.69607652428835e+44*cos(theta)**9 - 1.40055923339654e+43*cos(theta)**7 + 3.92156585351032e+41*cos(theta)**5 - 4.88364365318845e+39*cos(theta)**3 + 1.71959283562973e+37*cos(theta))*cos(22*phi)

@torch.jit.script
def Yl47_m23(theta, phi):
    return 2.79847985979336e-38*(1.0 - cos(theta)**2)**11.5*(4.81496123207802e+48*cos(theta)**24 - 1.4289562366167e+49*cos(theta)**22 + 1.81367522339812e+49*cos(theta)**20 - 1.29063030878518e+49*cos(theta)**18 + 5.67432290931415e+48*cos(theta)**16 - 1.60216176262988e+48*cos(theta)**14 + 2.92764498793813e+47*cos(theta)**12 - 3.40784072670047e+46*cos(theta)**10 + 2.42646887185951e+45*cos(theta)**8 - 9.80391463377581e+43*cos(theta)**6 + 1.96078292675516e+42*cos(theta)**4 - 1.46509309595653e+40*cos(theta)**2 + 1.71959283562973e+37)*cos(23*phi)

@torch.jit.script
def Yl47_m24(theta, phi):
    return 6.77933961187779e-40*(1.0 - cos(theta)**2)**12*(1.15559069569872e+50*cos(theta)**23 - 3.14370372055674e+50*cos(theta)**21 + 3.62735044679624e+50*cos(theta)**19 - 2.32313455581332e+50*cos(theta)**17 + 9.07891665490265e+49*cos(theta)**15 - 2.24302646768183e+49*cos(theta)**13 + 3.51317398552576e+48*cos(theta)**11 - 3.40784072670047e+47*cos(theta)**9 + 1.94117509748761e+46*cos(theta)**7 - 5.88234878026548e+44*cos(theta)**5 + 7.84313170702065e+42*cos(theta)**3 - 2.93018619191307e+40*cos(theta))*cos(24*phi)

@torch.jit.script
def Yl47_m25(theta, phi):
    return 1.66593182302274e-41*(1.0 - cos(theta)**2)**12.5*(2.65785860010707e+51*cos(theta)**22 - 6.60177781316916e+51*cos(theta)**20 + 6.89196584891286e+51*cos(theta)**18 - 3.94932874488265e+51*cos(theta)**16 + 1.3618374982354e+51*cos(theta)**14 - 2.91593440798638e+50*cos(theta)**12 + 3.86449138407833e+49*cos(theta)**10 - 3.06705665403042e+48*cos(theta)**8 + 1.35882256824133e+47*cos(theta)**6 - 2.94117439013274e+45*cos(theta)**4 + 2.35293951210619e+43*cos(theta)**2 - 2.93018619191307e+40)*cos(25*phi)

@torch.jit.script
def Yl47_m26(theta, phi):
    return 4.15704239669497e-43*(1.0 - cos(theta)**2)**13*(5.84728892023554e+52*cos(theta)**21 - 1.32035556263383e+53*cos(theta)**19 + 1.24055385280432e+53*cos(theta)**17 - 6.31892599181224e+52*cos(theta)**15 + 1.90657249752956e+52*cos(theta)**13 - 3.49912128958366e+51*cos(theta)**11 + 3.86449138407833e+50*cos(theta)**9 - 2.45364532322434e+49*cos(theta)**7 + 8.15293540944796e+47*cos(theta)**5 - 1.1764697560531e+46*cos(theta)**3 + 4.70587902421239e+43*cos(theta))*cos(26*phi)

@torch.jit.script
def Yl47_m27(theta, phi):
    return 1.05453001748702e-44*(1.0 - cos(theta)**2)**13.5*(1.22793067324946e+54*cos(theta)**20 - 2.50867556900428e+54*cos(theta)**18 + 2.10894154976734e+54*cos(theta)**16 - 9.47838898771836e+53*cos(theta)**14 + 2.47854424678842e+53*cos(theta)**12 - 3.84903341854202e+52*cos(theta)**10 + 3.4780422456705e+51*cos(theta)**8 - 1.71755172625704e+50*cos(theta)**6 + 4.07646770472398e+48*cos(theta)**4 - 3.52940926815929e+46*cos(theta)**2 + 4.70587902421239e+43)*cos(27*phi)

@torch.jit.script
def Yl47_m28(theta, phi):
    return 2.72278479720203e-46*(1.0 - cos(theta)**2)**14*(2.45586134649893e+55*cos(theta)**19 - 4.51561602420771e+55*cos(theta)**17 + 3.37430647962774e+55*cos(theta)**15 - 1.32697445828057e+55*cos(theta)**13 + 2.97425309614611e+54*cos(theta)**11 - 3.84903341854202e+53*cos(theta)**9 + 2.7824337965364e+52*cos(theta)**7 - 1.03053103575422e+51*cos(theta)**5 + 1.63058708188959e+49*cos(theta)**3 - 7.05881853631858e+46*cos(theta))*cos(28*phi)

@torch.jit.script
def Yl47_m29(theta, phi):
    return 7.16522315053166e-48*(1.0 - cos(theta)**2)**14.5*(4.66613655834796e+56*cos(theta)**18 - 7.6765472411531e+56*cos(theta)**16 + 5.06145971944161e+56*cos(theta)**14 - 1.72506679576474e+56*cos(theta)**12 + 3.27167840576072e+55*cos(theta)**10 - 3.46413007668782e+54*cos(theta)**8 + 1.94770365757548e+53*cos(theta)**6 - 5.15265517877111e+51*cos(theta)**4 + 4.89176124566878e+49*cos(theta)**2 - 7.05881853631858e+46)*cos(29*phi)

@torch.jit.script
def Yl47_m30(theta, phi):
    return 1.92463378568823e-49*(1.0 - cos(theta)**2)**15*(8.39904580502633e+57*cos(theta)**17 - 1.2282475585845e+58*cos(theta)**15 + 7.08604360721825e+57*cos(theta)**13 - 2.07008015491769e+57*cos(theta)**11 + 3.27167840576072e+56*cos(theta)**9 - 2.77130406135025e+55*cos(theta)**7 + 1.16862219454529e+54*cos(theta)**5 - 2.06106207150844e+52*cos(theta)**3 + 9.78352249133755e+49*cos(theta))*cos(30*phi)

@torch.jit.script
def Yl47_m31(theta, phi):
    return 5.28538153651375e-51*(1.0 - cos(theta)**2)**15.5*(1.42783778685448e+59*cos(theta)**16 - 1.84237133787674e+59*cos(theta)**14 + 9.21185668938372e+58*cos(theta)**12 - 2.27708817040946e+58*cos(theta)**10 + 2.94451056518465e+57*cos(theta)**8 - 1.93991284294518e+56*cos(theta)**6 + 5.84311097272644e+54*cos(theta)**4 - 6.18318621452533e+52*cos(theta)**2 + 9.78352249133755e+49)*cos(31*phi)

@torch.jit.script
def Yl47_m32(theta, phi):
    return 1.48662970462735e-52*(1.0 - cos(theta)**2)**16*(2.28454045896716e+60*cos(theta)**15 - 2.57931987302744e+60*cos(theta)**13 + 1.10542280272605e+60*cos(theta)**11 - 2.27708817040946e+59*cos(theta)**9 + 2.35560845214772e+58*cos(theta)**7 - 1.16394770576711e+57*cos(theta)**5 + 2.33724438909058e+55*cos(theta)**3 - 1.23663724290507e+53*cos(theta))*cos(32*phi)

@torch.jit.script
def Yl47_m33(theta, phi):
    return 4.29153030075948e-54*(1.0 - cos(theta)**2)**16.5*(3.42681068845074e+61*cos(theta)**14 - 3.35311583493567e+61*cos(theta)**12 + 1.21596508299865e+61*cos(theta)**10 - 2.04937935336851e+60*cos(theta)**8 + 1.6489259165034e+59*cos(theta)**6 - 5.81973852883553e+57*cos(theta)**4 + 7.01173316727173e+55*cos(theta)**2 - 1.23663724290507e+53)*cos(33*phi)

@torch.jit.script
def Yl47_m34(theta, phi):
    return 1.27439968653976e-55*(1.0 - cos(theta)**2)**17*(4.79753496383104e+62*cos(theta)**13 - 4.02373900192281e+62*cos(theta)**11 + 1.21596508299865e+62*cos(theta)**9 - 1.63950348269481e+61*cos(theta)**7 + 9.89355549902041e+59*cos(theta)**5 - 2.32789541153421e+58*cos(theta)**3 + 1.40234663345435e+56*cos(theta))*cos(34*phi)

@torch.jit.script
def Yl47_m35(theta, phi):
    return 3.90325615867939e-57*(1.0 - cos(theta)**2)**17.5*(6.23679545298036e+63*cos(theta)**12 - 4.42611290211509e+63*cos(theta)**10 + 1.09436857469879e+63*cos(theta)**8 - 1.14765243788637e+62*cos(theta)**6 + 4.94677774951021e+60*cos(theta)**4 - 6.98368623460264e+58*cos(theta)**2 + 1.40234663345435e+56)*cos(35*phi)

@torch.jit.script
def Yl47_m36(theta, phi):
    return 1.23679404188207e-58*(1.0 - cos(theta)**2)**18*(7.48415454357643e+64*cos(theta)**11 - 4.42611290211509e+64*cos(theta)**9 + 8.75494859759029e+63*cos(theta)**7 - 6.88591462731821e+62*cos(theta)**5 + 1.97871109980408e+61*cos(theta)**3 - 1.39673724692053e+59*cos(theta))*cos(36*phi)

@torch.jit.script
def Yl47_m37(theta, phi):
    return 4.06875368086227e-60*(1.0 - cos(theta)**2)**18.5*(8.23256999793407e+65*cos(theta)**10 - 3.98350161190358e+65*cos(theta)**8 + 6.1284640183132e+64*cos(theta)**6 - 3.4429573136591e+63*cos(theta)**4 + 5.93613329941225e+61*cos(theta)**2 - 1.39673724692053e+59)*cos(37*phi)

@torch.jit.script
def Yl47_m38(theta, phi):
    return 1.39557099912251e-61*(1.0 - cos(theta)**2)**19*(8.23256999793407e+66*cos(theta)**9 - 3.18680128952287e+66*cos(theta)**7 + 3.67707841098792e+65*cos(theta)**5 - 1.37718292546364e+64*cos(theta)**3 + 1.18722665988245e+62*cos(theta))*cos(38*phi)

@torch.jit.script
def Yl47_m39(theta, phi):
    return 5.01627636792244e-63*(1.0 - cos(theta)**2)**19.5*(7.40931299814066e+67*cos(theta)**8 - 2.23076090266601e+67*cos(theta)**6 + 1.83853920549396e+66*cos(theta)**4 - 4.13154877639092e+64*cos(theta)**2 + 1.18722665988245e+62)*cos(39*phi)

@torch.jit.script
def Yl47_m40(theta, phi):
    return 1.90141465028655e-64*(1.0 - cos(theta)**2)**20*(5.92745039851253e+68*cos(theta)**7 - 1.3384565415996e+68*cos(theta)**5 + 7.35415682197584e+66*cos(theta)**3 - 8.26309755278185e+64*cos(theta))*cos(40*phi)

@torch.jit.script
def Yl47_m41(theta, phi):
    return 7.66101794667593e-66*(1.0 - cos(theta)**2)**20.5*(4.14921527895877e+69*cos(theta)**6 - 6.69228270799802e+68*cos(theta)**4 + 2.20624704659275e+67*cos(theta)**2 - 8.26309755278185e+64)*cos(41*phi)

@torch.jit.script
def Yl47_m42(theta, phi):
    return 3.31524669825326e-67*(1.0 - cos(theta)**2)**21*(2.48952916737526e+70*cos(theta)**5 - 2.67691308319921e+69*cos(theta)**3 + 4.41249409318551e+67*cos(theta))*cos(42*phi)

@torch.jit.script
def Yl47_m43(theta, phi):
    return 1.56282228109413e-68*(1.0 - cos(theta)**2)**21.5*(1.24476458368763e+71*cos(theta)**4 - 8.03073924959762e+69*cos(theta)**2 + 4.41249409318551e+67)*cos(43*phi)

@torch.jit.script
def Yl47_m44(theta, phi):
    return 8.19141449881068e-70*(1.0 - cos(theta)**2)**22*(4.97905833475052e+71*cos(theta)**3 - 1.60614784991952e+70*cos(theta))*cos(44*phi)

@torch.jit.script
def Yl47_m45(theta, phi):
    return 4.93065211209231e-71*(1.0 - cos(theta)**2)**22.5*(1.49371750042516e+72*cos(theta)**2 - 1.60614784991952e+70)*cos(45*phi)

@torch.jit.script
def Yl47_m46(theta, phi):
    return 10.8005619986252*(1.0 - cos(theta)**2)**23*cos(46*phi)*cos(theta)

@torch.jit.script
def Yl47_m47(theta, phi):
    return 1.11399291169174*(1.0 - cos(theta)**2)**23.5*cos(47*phi)

@torch.jit.script
def Yl48_m_minus_48(theta, phi):
    return 1.11977992679758*(1.0 - cos(theta)**2)**24*sin(48*phi)

@torch.jit.script
def Yl48_m_minus_47(theta, phi):
    return 10.9715577794607*(1.0 - cos(theta)**2)**23.5*sin(47*phi)*cos(theta)

@torch.jit.script
def Yl48_m_minus_46(theta, phi):
    return 5.32872152427948e-73*(1.0 - cos(theta)**2)**23*(1.4190316254039e+74*cos(theta)**2 - 1.49371750042516e+72)*sin(46*phi)

@torch.jit.script
def Yl48_m_minus_45(theta, phi):
    return 8.94844512163766e-72*(1.0 - cos(theta)**2)**22.5*(4.730105418013e+73*cos(theta)**3 - 1.49371750042516e+72*cos(theta))*sin(45*phi)

@torch.jit.script
def Yl48_m_minus_44(theta, phi):
    return 1.72591359213969e-70*(1.0 - cos(theta)**2)**22*(1.18252635450325e+73*cos(theta)**4 - 7.46858750212579e+71*cos(theta)**2 + 4.01536962479881e+69)*sin(44*phi)

@torch.jit.script
def Yl48_m_minus_43(theta, phi):
    return 3.70167226353842e-69*(1.0 - cos(theta)**2)**21.5*(2.3650527090065e+72*cos(theta)**5 - 2.48952916737526e+71*cos(theta)**3 + 4.01536962479881e+69*cos(theta))*sin(43*phi)

@torch.jit.script
def Yl48_m_minus_42(theta, phi):
    return 8.64956538819768e-68*(1.0 - cos(theta)**2)**21*(3.94175451501083e+71*cos(theta)**6 - 6.22382291843816e+70*cos(theta)**4 + 2.00768481239941e+69*cos(theta)**2 - 7.35415682197584e+66)*sin(42*phi)

@torch.jit.script
def Yl48_m_minus_41(theta, phi):
    return 2.17102368215931e-66*(1.0 - cos(theta)**2)**20.5*(5.6310778785869e+70*cos(theta)**7 - 1.24476458368763e+70*cos(theta)**5 + 6.69228270799802e+68*cos(theta)**3 - 7.35415682197584e+66*cos(theta))*sin(41*phi)

@torch.jit.script
def Yl48_m_minus_40(theta, phi):
    return 5.79301372852641e-65*(1.0 - cos(theta)**2)**20*(7.03884734823363e+69*cos(theta)**8 - 2.07460763947939e+69*cos(theta)**6 + 1.6730706769995e+68*cos(theta)**4 - 3.67707841098792e+66*cos(theta)**2 + 1.03288719409773e+64)*sin(40*phi)

@torch.jit.script
def Yl48_m_minus_39(theta, phi):
    return 1.63029857334923e-63*(1.0 - cos(theta)**2)**19.5*(7.82094149803737e+68*cos(theta)**9 - 2.96372519925626e+68*cos(theta)**7 + 3.34614135399901e+67*cos(theta)**5 - 1.22569280366264e+66*cos(theta)**3 + 1.03288719409773e+64*cos(theta))*sin(39*phi)

@torch.jit.script
def Yl48_m_minus_38(theta, phi):
    return 4.80868993728036e-62*(1.0 - cos(theta)**2)**19*(7.82094149803737e+67*cos(theta)**10 - 3.70465649907033e+67*cos(theta)**8 + 5.57690225666501e+66*cos(theta)**6 - 3.0642320091566e+65*cos(theta)**4 + 5.16443597048865e+63*cos(theta)**2 - 1.18722665988245e+61)*sin(38*phi)

@torch.jit.script
def Yl48_m_minus_37(theta, phi):
    return 1.47901419775487e-60*(1.0 - cos(theta)**2)**18.5*(7.1099468163976e+66*cos(theta)**11 - 4.11628499896703e+66*cos(theta)**9 + 7.96700322380716e+65*cos(theta)**7 - 6.1284640183132e+64*cos(theta)**5 + 1.72147865682955e+63*cos(theta)**3 - 1.18722665988245e+61*cos(theta))*sin(37*phi)

@torch.jit.script
def Yl48_m_minus_36(theta, phi):
    return 4.72359254921895e-59*(1.0 - cos(theta)**2)**18*(5.92495568033134e+65*cos(theta)**12 - 4.11628499896703e+65*cos(theta)**10 + 9.95875402975895e+64*cos(theta)**8 - 1.02141066971887e+64*cos(theta)**6 + 4.30369664207388e+62*cos(theta)**4 - 5.93613329941225e+60*cos(theta)**2 + 1.16394770576711e+58)*sin(36*phi)

@torch.jit.script
def Yl48_m_minus_35(theta, phi):
    return 1.5609311520875e-57*(1.0 - cos(theta)**2)**17.5*(4.55765821563949e+64*cos(theta)**13 - 3.74207727178821e+64*cos(theta)**11 + 1.10652822552877e+64*cos(theta)**9 - 1.45915809959838e+63*cos(theta)**7 + 8.60739328414776e+61*cos(theta)**5 - 1.97871109980408e+60*cos(theta)**3 + 1.16394770576711e+58*cos(theta))*sin(35*phi)

@torch.jit.script
def Yl48_m_minus_34(theta, phi):
    return 5.32092101381846e-56*(1.0 - cos(theta)**2)**17*(3.25547015402821e+63*cos(theta)**14 - 3.11839772649018e+63*cos(theta)**12 + 1.10652822552877e+63*cos(theta)**10 - 1.82394762449798e+62*cos(theta)**8 + 1.43456554735796e+61*cos(theta)**6 - 4.94677774951021e+59*cos(theta)**4 + 5.81973852883553e+57*cos(theta)**2 - 1.0016761667531e+55)*sin(34*phi)

@torch.jit.script
def Yl48_m_minus_33(theta, phi):
    return 1.86611914237577e-54*(1.0 - cos(theta)**2)**16.5*(2.1703134360188e+62*cos(theta)**15 - 2.39876748191552e+62*cos(theta)**13 + 1.0059347504807e+62*cos(theta)**11 - 2.02660847166442e+61*cos(theta)**9 + 2.04937935336851e+60*cos(theta)**7 - 9.89355549902041e+58*cos(theta)**5 + 1.93991284294518e+57*cos(theta)**3 - 1.0016761667531e+55*cos(theta))*sin(33*phi)

@torch.jit.script
def Yl48_m_minus_32(theta, phi):
    return 6.71802891255276e-53*(1.0 - cos(theta)**2)**16*(1.35644589751175e+61*cos(theta)**16 - 1.71340534422537e+61*cos(theta)**14 + 8.38278958733919e+60*cos(theta)**12 - 2.02660847166442e+60*cos(theta)**10 + 2.56172419171064e+59*cos(theta)**8 - 1.6489259165034e+58*cos(theta)**6 + 4.84978210736295e+56*cos(theta)**4 - 5.00838083376552e+54*cos(theta)**2 + 7.72898276815667e+51)*sin(32*phi)

@torch.jit.script
def Yl48_m_minus_31(theta, phi):
    return 2.47748664898637e-51*(1.0 - cos(theta)**2)**15.5*(7.97909351477502e+59*cos(theta)**17 - 1.14227022948358e+60*cos(theta)**15 + 6.44829968256861e+59*cos(theta)**13 - 1.84237133787674e+59*cos(theta)**11 + 2.84636021301182e+58*cos(theta)**9 - 2.35560845214772e+57*cos(theta)**7 + 9.69956421472589e+55*cos(theta)**5 - 1.66946027792184e+54*cos(theta)**3 + 7.72898276815667e+51*cos(theta))*sin(31*phi)

@torch.jit.script
def Yl48_m_minus_30(theta, phi):
    return 9.34245728723332e-50*(1.0 - cos(theta)**2)**15*(4.43282973043057e+58*cos(theta)**18 - 7.13918893427238e+58*cos(theta)**16 + 4.60592834469186e+58*cos(theta)**14 - 1.53530944823062e+58*cos(theta)**12 + 2.84636021301182e+57*cos(theta)**10 - 2.94451056518465e+56*cos(theta)**8 + 1.61659403578765e+55*cos(theta)**6 - 4.1736506948046e+53*cos(theta)**4 + 3.86449138407833e+51*cos(theta)**2 - 5.43529027296531e+48)*sin(30*phi)

@torch.jit.script
def Yl48_m_minus_29(theta, phi):
    return 3.5965427162585e-48*(1.0 - cos(theta)**2)**14.5*(2.33306827917398e+57*cos(theta)**19 - 4.19952290251317e+57*cos(theta)**17 + 3.07061889646124e+57*cos(theta)**15 - 1.18100726786971e+57*cos(theta)**13 + 2.58760019364711e+56*cos(theta)**11 - 3.27167840576072e+55*cos(theta)**9 + 2.30942005112521e+54*cos(theta)**7 - 8.3473013896092e+52*cos(theta)**5 + 1.28816379469278e+51*cos(theta)**3 - 5.43529027296531e+48*cos(theta))*sin(29*phi)

@torch.jit.script
def Yl48_m_minus_28(theta, phi):
    return 1.41138527855448e-46*(1.0 - cos(theta)**2)**14*(1.16653413958699e+56*cos(theta)**20 - 2.33306827917398e+56*cos(theta)**18 + 1.91913681028828e+56*cos(theta)**16 - 8.43576619906934e+55*cos(theta)**14 + 2.15633349470593e+55*cos(theta)**12 - 3.27167840576072e+54*cos(theta)**10 + 2.88677506390652e+53*cos(theta)**8 - 1.3912168982682e+52*cos(theta)**6 + 3.22040948673195e+50*cos(theta)**4 - 2.71764513648265e+48*cos(theta)**2 + 3.52940926815929e+45)*sin(28*phi)

@torch.jit.script
def Yl48_m_minus_27(theta, phi):
    return 5.63847977172428e-45*(1.0 - cos(theta)**2)**13.5*(5.55492447422377e+54*cos(theta)**21 - 1.22793067324946e+55*cos(theta)**19 + 1.12890400605193e+55*cos(theta)**17 - 5.6238441327129e+54*cos(theta)**15 + 1.65871807285071e+54*cos(theta)**13 - 2.97425309614611e+53*cos(theta)**11 + 3.20752784878502e+52*cos(theta)**9 - 1.98745271181171e+51*cos(theta)**7 + 6.44081897346389e+49*cos(theta)**5 - 9.05881712160885e+47*cos(theta)**3 + 3.52940926815929e+45*cos(theta))*sin(27*phi)

@torch.jit.script
def Yl48_m_minus_26(theta, phi):
    return 2.29036131046255e-43*(1.0 - cos(theta)**2)**13*(2.52496567010171e+53*cos(theta)**22 - 6.13965336624732e+53*cos(theta)**20 + 6.2716889225107e+53*cos(theta)**18 - 3.51490258294556e+53*cos(theta)**16 + 1.1847986234648e+53*cos(theta)**14 - 2.47854424678842e+52*cos(theta)**12 + 3.20752784878502e+51*cos(theta)**10 - 2.48431588976464e+50*cos(theta)**8 + 1.07346982891065e+49*cos(theta)**6 - 2.26470428040221e+47*cos(theta)**4 + 1.76470463407965e+45*cos(theta)**2 - 2.13903592009654e+42)*sin(26*phi)

@torch.jit.script
def Yl48_m_minus_25(theta, phi):
    return 9.44895491313896e-42*(1.0 - cos(theta)**2)**12.5*(1.09781116091379e+52*cos(theta)**23 - 2.92364446011777e+52*cos(theta)**21 + 3.30088890658458e+52*cos(theta)**19 - 2.06758975467386e+52*cos(theta)**17 + 7.8986574897653e+51*cos(theta)**15 - 1.90657249752956e+51*cos(theta)**13 + 2.91593440798638e+50*cos(theta)**11 - 2.76035098862738e+49*cos(theta)**9 + 1.53352832701521e+48*cos(theta)**7 - 4.52940856080442e+46*cos(theta)**5 + 5.88234878026548e+44*cos(theta)**3 - 2.13903592009654e+42*cos(theta))*sin(25*phi)

@torch.jit.script
def Yl48_m_minus_24(theta, phi):
    return 3.9550395214376e-40*(1.0 - cos(theta)**2)**12*(4.57421317047412e+50*cos(theta)**24 - 1.32892930005353e+51*cos(theta)**22 + 1.65044445329229e+51*cos(theta)**20 - 1.14866097481881e+51*cos(theta)**18 + 4.93666093110331e+50*cos(theta)**16 - 1.3618374982354e+50*cos(theta)**14 + 2.42994533998865e+49*cos(theta)**12 - 2.76035098862738e+48*cos(theta)**10 + 1.91691040876902e+47*cos(theta)**8 - 7.54901426800737e+45*cos(theta)**6 + 1.47058719506637e+44*cos(theta)**4 - 1.06951796004827e+42*cos(theta)**2 + 1.22091091329711e+39)*sin(24*phi)

@torch.jit.script
def Yl48_m_minus_23(theta, phi):
    return 1.67798115928159e-38*(1.0 - cos(theta)**2)**11.5*(1.82968526818965e+49*cos(theta)**25 - 5.77795347849362e+49*cos(theta)**23 + 7.85925930139186e+49*cos(theta)**21 - 6.04558407799374e+49*cos(theta)**19 + 2.90391819476665e+49*cos(theta)**17 - 9.07891665490265e+48*cos(theta)**15 + 1.86918872306819e+48*cos(theta)**13 - 2.50940998966126e+47*cos(theta)**11 + 2.12990045418779e+46*cos(theta)**9 - 1.07843060971534e+45*cos(theta)**7 + 2.94117439013274e+43*cos(theta)**5 - 3.56505986682757e+41*cos(theta)**3 + 1.22091091329711e+39*cos(theta))*sin(23*phi)

@torch.jit.script
def Yl48_m_minus_22(theta, phi):
    return 7.20946318604152e-37*(1.0 - cos(theta)**2)**11*(7.03725103149864e+47*cos(theta)**26 - 2.40748061603901e+48*cos(theta)**24 + 3.57239059154175e+48*cos(theta)**22 - 3.02279203899687e+48*cos(theta)**20 + 1.61328788598148e+48*cos(theta)**18 - 5.67432290931415e+47*cos(theta)**16 + 1.33513480219157e+47*cos(theta)**14 - 2.09117499138438e+46*cos(theta)**12 + 2.12990045418779e+45*cos(theta)**10 - 1.34803826214417e+44*cos(theta)**8 + 4.9019573168879e+42*cos(theta)**6 - 8.91264966706892e+40*cos(theta)**4 + 6.10455456648556e+38*cos(theta)**2 - 6.6138185985759e+35)*sin(22*phi)

@torch.jit.script
def Yl48_m_minus_21(theta, phi):
    return 3.13425141500133e-35*(1.0 - cos(theta)**2)**10.5*(2.60638927092542e+46*cos(theta)**27 - 9.62992246415603e+46*cos(theta)**25 + 1.55321330067033e+47*cos(theta)**23 - 1.4394247804747e+47*cos(theta)**21 + 8.49098887358671e+46*cos(theta)**19 - 3.33783700547891e+46*cos(theta)**17 + 8.9008986812771e+45*cos(theta)**15 - 1.60859614721875e+45*cos(theta)**13 + 1.93627314017072e+44*cos(theta)**11 - 1.4978202912713e+43*cos(theta)**9 + 7.00279616698272e+41*cos(theta)**7 - 1.78252993341378e+40*cos(theta)**5 + 2.03485152216185e+38*cos(theta)**3 - 6.6138185985759e+35*cos(theta))*sin(21*phi)

@torch.jit.script
def Yl48_m_minus_20(theta, phi):
    return 1.37764522622734e-33*(1.0 - cos(theta)**2)**10*(9.30853311044794e+44*cos(theta)**28 - 3.70381633236771e+45*cos(theta)**26 + 6.47172208612637e+45*cos(theta)**24 - 6.54283991124863e+45*cos(theta)**22 + 4.24549443679336e+45*cos(theta)**20 - 1.85435389193273e+45*cos(theta)**18 + 5.56306167579819e+44*cos(theta)**16 - 1.1489972480134e+44*cos(theta)**14 + 1.61356095014227e+43*cos(theta)**12 - 1.4978202912713e+42*cos(theta)**10 + 8.7534952087284e+40*cos(theta)**8 - 2.97088322235631e+39*cos(theta)**6 + 5.08712880540463e+37*cos(theta)**4 - 3.30690929928795e+35*cos(theta)**2 + 3.42330155205792e+32)*sin(20*phi)

@torch.jit.script
def Yl48_m_minus_19(theta, phi):
    return 6.11773762133704e-32*(1.0 - cos(theta)**2)**9.5*(3.20983900360274e+43*cos(theta)**29 - 1.37178382680285e+44*cos(theta)**27 + 2.58868883445055e+44*cos(theta)**25 - 2.84471300489071e+44*cos(theta)**23 + 2.02166401752065e+44*cos(theta)**21 - 9.75975732596174e+43*cos(theta)**19 + 3.27238922105776e+43*cos(theta)**17 - 7.65998165342264e+42*cos(theta)**15 + 1.24120073087867e+42*cos(theta)**13 - 1.36165481024664e+41*cos(theta)**11 + 9.726105787476e+39*cos(theta)**9 - 4.24411888908044e+38*cos(theta)**7 + 1.01742576108093e+37*cos(theta)**5 - 1.10230309976265e+35*cos(theta)**3 + 3.42330155205792e+32*cos(theta))*sin(19*phi)

@torch.jit.script
def Yl48_m_minus_18(theta, phi):
    return 2.7427667480681e-30*(1.0 - cos(theta)**2)**9*(1.06994633453425e+42*cos(theta)**30 - 4.89922795286733e+42*cos(theta)**28 + 9.95649551711749e+42*cos(theta)**26 - 1.18529708537113e+43*cos(theta)**24 + 9.18938189782112e+42*cos(theta)**22 - 4.87987866298087e+42*cos(theta)**20 + 1.81799401169875e+42*cos(theta)**18 - 4.78748853338915e+41*cos(theta)**16 + 8.8657195062762e+40*cos(theta)**14 - 1.1347123418722e+40*cos(theta)**12 + 9.726105787476e+38*cos(theta)**10 - 5.30514861135055e+37*cos(theta)**8 + 1.69570960180154e+36*cos(theta)**6 - 2.75575774940663e+34*cos(theta)**4 + 1.71165077602896e+32*cos(theta)**2 - 1.70313510052633e+29)*sin(18*phi)

@torch.jit.script
def Yl48_m_minus_17(theta, phi):
    return 1.24062831914294e-28*(1.0 - cos(theta)**2)**8.5*(3.45143978882015e+40*cos(theta)**31 - 1.6893889492646e+41*cos(theta)**29 + 3.68759093226574e+41*cos(theta)**27 - 4.74118834148452e+41*cos(theta)**25 + 3.99538343383527e+41*cos(theta)**23 - 2.3237517442766e+41*cos(theta)**21 + 9.5683895352566e+40*cos(theta)**19 - 2.81616972552303e+40*cos(theta)**17 + 5.9104796708508e+39*cos(theta)**15 - 8.72855647594e+38*cos(theta)**13 + 8.84191435225091e+37*cos(theta)**11 - 5.89460956816727e+36*cos(theta)**9 + 2.42244228828792e+35*cos(theta)**7 - 5.51151549881325e+33*cos(theta)**5 + 5.7055025867632e+31*cos(theta)**3 - 1.70313510052633e+29*cos(theta))*sin(17*phi)

@torch.jit.script
def Yl48_m_minus_16(theta, phi):
    return 5.6581356846753e-27*(1.0 - cos(theta)**2)**8*(1.0785749340063e+39*cos(theta)**32 - 5.63129649754866e+39*cos(theta)**30 + 1.31699676152348e+40*cos(theta)**28 - 1.82353397749405e+40*cos(theta)**26 + 1.66474309743136e+40*cos(theta)**24 - 1.056250792853e+40*cos(theta)**22 + 4.7841947676283e+39*cos(theta)**20 - 1.56453873640168e+39*cos(theta)**18 + 3.69404979428175e+38*cos(theta)**16 - 6.2346831971e+37*cos(theta)**14 + 7.36826196020909e+36*cos(theta)**12 - 5.89460956816727e+35*cos(theta)**10 + 3.0280528603599e+34*cos(theta)**8 - 9.18585916468876e+32*cos(theta)**6 + 1.4263756466908e+31*cos(theta)**4 - 8.51567550263164e+28*cos(theta)**2 + 8.1881495217612e+25)*sin(16*phi)

@torch.jit.script
def Yl48_m_minus_15(theta, phi):
    return 2.60028119225837e-25*(1.0 - cos(theta)**2)**7.5*(3.26840889092817e+37*cos(theta)**33 - 1.81654725727376e+38*cos(theta)**31 + 4.5413681431844e+38*cos(theta)**29 - 6.75382954627424e+38*cos(theta)**27 + 6.65897238972545e+38*cos(theta)**25 - 4.59239475153479e+38*cos(theta)**23 + 2.27818798458491e+38*cos(theta)**21 - 8.23441440211412e+37*cos(theta)**19 + 2.17297046722456e+37*cos(theta)**17 - 4.15645546473333e+36*cos(theta)**15 + 5.66789381554545e+35*cos(theta)**13 - 5.35873597106116e+34*cos(theta)**11 + 3.36450317817767e+33*cos(theta)**9 - 1.31226559495554e+32*cos(theta)**7 + 2.8527512933816e+30*cos(theta)**5 - 2.83855850087721e+28*cos(theta)**3 + 8.1881495217612e+25*cos(theta))*sin(15*phi)

@torch.jit.script
def Yl48_m_minus_14(theta, phi):
    return 1.20345553308864e-23*(1.0 - cos(theta)**2)**7*(9.61296732625932e+35*cos(theta)**34 - 5.67671017898051e+36*cos(theta)**32 + 1.51378938106147e+37*cos(theta)**30 - 2.41208198081223e+37*cos(theta)**28 + 2.56114322681748e+37*cos(theta)**26 - 1.9134978131395e+37*cos(theta)**24 + 1.03553999299314e+37*cos(theta)**22 - 4.11720720105706e+36*cos(theta)**20 + 1.20720581512475e+36*cos(theta)**18 - 2.59778466545833e+35*cos(theta)**16 + 4.04849558253247e+34*cos(theta)**14 - 4.46561330921763e+33*cos(theta)**12 + 3.36450317817767e+32*cos(theta)**10 - 1.64033199369442e+31*cos(theta)**8 + 4.75458548896934e+29*cos(theta)**6 - 7.09639625219304e+27*cos(theta)**4 + 4.0940747608806e+25*cos(theta)**2 - 3.82266550969244e+22)*sin(14*phi)

@torch.jit.script
def Yl48_m_minus_13(theta, phi):
    return 5.60608805466343e-22*(1.0 - cos(theta)**2)**6.5*(2.74656209321695e+34*cos(theta)**35 - 1.72021520575167e+35*cos(theta)**33 + 4.88319155181119e+35*cos(theta)**31 - 8.31752407176631e+35*cos(theta)**29 + 9.48571565487955e+35*cos(theta)**27 - 7.65399125255798e+35*cos(theta)**25 + 4.50234779562234e+35*cos(theta)**23 - 1.96057485764622e+35*cos(theta)**21 + 6.35371481644608e+34*cos(theta)**19 - 1.5281086267402e+34*cos(theta)**17 + 2.69899705502165e+33*cos(theta)**15 - 3.43508716093664e+32*cos(theta)**13 + 3.05863925288879e+31*cos(theta)**11 - 1.82259110410491e+30*cos(theta)**9 + 6.79226498424191e+28*cos(theta)**7 - 1.41927925043861e+27*cos(theta)**5 + 1.3646915869602e+25*cos(theta)**3 - 3.82266550969244e+22*cos(theta))*sin(13*phi)

@torch.jit.script
def Yl48_m_minus_12(theta, phi):
    return 2.62709684472235e-20*(1.0 - cos(theta)**2)**6*(7.62933914782486e+32*cos(theta)**36 - 5.05945648750491e+33*cos(theta)**34 + 1.525997359941e+34*cos(theta)**32 - 2.7725080239221e+34*cos(theta)**30 + 3.38775559102841e+34*cos(theta)**28 - 2.94384278944538e+34*cos(theta)**26 + 1.87597824817598e+34*cos(theta)**24 - 8.9117038983919e+33*cos(theta)**22 + 3.17685740822304e+33*cos(theta)**20 - 8.48949237077887e+32*cos(theta)**18 + 1.68687315938853e+32*cos(theta)**16 - 2.45363368638331e+31*cos(theta)**14 + 2.54886604407399e+30*cos(theta)**12 - 1.82259110410491e+29*cos(theta)**10 + 8.49033123030238e+27*cos(theta)**8 - 2.36546541739768e+26*cos(theta)**6 + 3.4117289674005e+24*cos(theta)**4 - 1.91133275484622e+22*cos(theta)**2 + 1.74074021388544e+19)*sin(12*phi)

@torch.jit.script
def Yl48_m_minus_11(theta, phi):
    return 1.23780596161278e-18*(1.0 - cos(theta)**2)**5.5*(2.06198355346618e+31*cos(theta)**37 - 1.44555899642997e+32*cos(theta)**35 + 4.62423442406362e+32*cos(theta)**33 - 8.94357427071646e+32*cos(theta)**31 + 1.16819158311325e+33*cos(theta)**29 - 1.09031214423903e+33*cos(theta)**27 + 7.50391299270391e+32*cos(theta)**25 - 3.87465386886604e+32*cos(theta)**23 + 1.51278924201097e+32*cos(theta)**21 - 4.4681538793573e+31*cos(theta)**19 + 9.92278329052075e+30*cos(theta)**17 - 1.63575579092221e+30*cos(theta)**15 + 1.96066618774922e+29*cos(theta)**13 - 1.65690100373174e+28*cos(theta)**11 + 9.43370136700265e+26*cos(theta)**9 - 3.37923631056811e+25*cos(theta)**7 + 6.823457934801e+23*cos(theta)**5 - 6.37110918282073e+21*cos(theta)**3 + 1.74074021388544e+19*cos(theta))*sin(11*phi)

@torch.jit.script
def Yl48_m_minus_10(theta, phi):
    return 5.86098181883417e-17*(1.0 - cos(theta)**2)**5*(5.42627250912152e+29*cos(theta)**38 - 4.01544165674993e+30*cos(theta)**36 + 1.36006894825401e+31*cos(theta)**34 - 2.79486695959889e+31*cos(theta)**32 + 3.89397194371082e+31*cos(theta)**30 - 3.89397194371082e+31*cos(theta)**28 + 2.88612038180919e+31*cos(theta)**26 - 1.61443911202752e+31*cos(theta)**24 + 6.8763147364135e+30*cos(theta)**22 - 2.23407693967865e+30*cos(theta)**20 + 5.51265738362264e+29*cos(theta)**18 - 1.02234736932638e+29*cos(theta)**16 + 1.4004758483923e+28*cos(theta)**14 - 1.38075083644311e+27*cos(theta)**12 + 9.43370136700265e+25*cos(theta)**10 - 4.22404538821014e+24*cos(theta)**8 + 1.1372429891335e+23*cos(theta)**6 - 1.59277729570518e+21*cos(theta)**4 + 8.70370106942722e+18*cos(theta)**2 - 7.76422932152295e+15)*sin(10*phi)

@torch.jit.script
def Yl48_m_minus_9(theta, phi):
    return 2.78751154304613e-15*(1.0 - cos(theta)**2)**4.5*(1.39135192541577e+28*cos(theta)**39 - 1.0852545018243e+29*cos(theta)**37 + 3.88591128072573e+29*cos(theta)**35 - 8.46929381696635e+29*cos(theta)**33 + 1.2561199818422e+30*cos(theta)**31 - 1.34274894610718e+30*cos(theta)**29 + 1.06893347474415e+30*cos(theta)**27 - 6.45775644811007e+29*cos(theta)**25 + 2.98970205931022e+29*cos(theta)**23 - 1.06384616175174e+29*cos(theta)**21 + 2.90139862295928e+28*cos(theta)**19 - 6.01380805486106e+27*cos(theta)**17 + 9.33650565594868e+26*cos(theta)**15 - 1.06211602803317e+26*cos(theta)**13 + 8.57609215182059e+24*cos(theta)**11 - 4.69338376467793e+23*cos(theta)**9 + 1.62463284161929e+22*cos(theta)**7 - 3.18555459141036e+20*cos(theta)**5 + 2.90123368980907e+18*cos(theta)**3 - 7.76422932152295e+15*cos(theta))*sin(9*phi)

@torch.jit.script
def Yl48_m_minus_8(theta, phi):
    return 1.33101851880292e-13*(1.0 - cos(theta)**2)**4*(3.47837981353944e+26*cos(theta)**40 - 2.85593289953764e+27*cos(theta)**38 + 1.07941980020159e+28*cos(theta)**36 - 2.49096876969598e+28*cos(theta)**34 + 3.92537494325687e+28*cos(theta)**32 - 4.47582982035726e+28*cos(theta)**30 + 3.81761955265766e+28*cos(theta)**28 - 2.48375248004234e+28*cos(theta)**26 + 1.24570919137926e+28*cos(theta)**24 - 4.83566437159881e+27*cos(theta)**22 + 1.45069931147964e+27*cos(theta)**20 - 3.34100447492281e+26*cos(theta)**18 + 5.83531603496793e+25*cos(theta)**16 - 7.58654305737975e+24*cos(theta)**14 + 7.14674345985049e+23*cos(theta)**12 - 4.69338376467793e+22*cos(theta)**10 + 2.03079105202411e+21*cos(theta)**8 - 5.3092576523506e+19*cos(theta)**6 + 7.25308422452268e+17*cos(theta)**4 - 3.88211466076147e+15*cos(theta)**2 + 3405363737510.06)*sin(8*phi)

@torch.jit.script
def Yl48_m_minus_7(theta, phi):
    return 6.37778742419495e-12*(1.0 - cos(theta)**2)**3.5*(8.48385320375472e+24*cos(theta)**41 - 7.32290487060934e+25*cos(theta)**39 + 2.91735081135566e+26*cos(theta)**37 - 7.11705362770281e+26*cos(theta)**35 + 1.18950755856269e+27*cos(theta)**33 - 1.44381607108299e+27*cos(theta)**31 + 1.31642053539919e+27*cos(theta)**29 - 9.19908325941606e+26*cos(theta)**27 + 4.98283676551703e+26*cos(theta)**25 - 2.10246277026035e+26*cos(theta)**23 + 6.90809195942687e+25*cos(theta)**21 - 1.75842340785411e+25*cos(theta)**19 + 3.43253884409878e+24*cos(theta)**17 - 5.0576953715865e+23*cos(theta)**15 + 5.49749496911576e+22*cos(theta)**13 - 4.26671251334358e+21*cos(theta)**11 + 2.25643450224901e+20*cos(theta)**9 - 7.58465378907229e+18*cos(theta)**7 + 1.45061684490454e+17*cos(theta)**5 - 1.29403822025382e+15*cos(theta)**3 + 3405363737510.06*cos(theta))*sin(7*phi)

@torch.jit.script
def Yl48_m_minus_6(theta, phi):
    return 3.06532148899894e-10*(1.0 - cos(theta)**2)**3*(2.01996504851303e+23*cos(theta)**42 - 1.83072621765233e+24*cos(theta)**40 + 7.67723897725173e+24*cos(theta)**38 - 1.97695934102856e+25*cos(theta)**36 + 3.49855164283144e+25*cos(theta)**34 - 4.51192522213434e+25*cos(theta)**32 + 4.38806845133065e+25*cos(theta)**30 - 3.28538687836288e+25*cos(theta)**28 + 1.91647567904501e+25*cos(theta)**26 - 8.76026154275146e+24*cos(theta)**24 + 3.14004179973949e+24*cos(theta)**22 - 8.79211703927056e+23*cos(theta)**20 + 1.90696602449932e+23*cos(theta)**18 - 3.16105960724156e+22*cos(theta)**16 + 3.92678212079697e+21*cos(theta)**14 - 3.55559376111965e+20*cos(theta)**12 + 2.25643450224901e+19*cos(theta)**10 - 9.48081723634037e+17*cos(theta)**8 + 2.41769474150756e+16*cos(theta)**6 - 323509555063456.0*cos(theta)**4 + 1702681868755.03*cos(theta)**2 - 1474183436.15154)*sin(6*phi)

@torch.jit.script
def Yl48_m_minus_5(theta, phi):
    return 1.47709061060563e-8*(1.0 - cos(theta)**2)**2.5*(4.69759313607681e+21*cos(theta)**43 - 4.46518589671301e+22*cos(theta)**41 + 1.96852281467993e+23*cos(theta)**39 - 5.34313335413124e+23*cos(theta)**37 + 9.99586183666125e+23*cos(theta)**35 - 1.36725006731344e+24*cos(theta)**33 + 1.41550595204214e+24*cos(theta)**31 - 1.13289202702168e+24*cos(theta)**29 + 7.09805807053708e+23*cos(theta)**27 - 3.50410461710059e+23*cos(theta)**25 + 1.36523556510412e+23*cos(theta)**23 - 4.18672239965265e+22*cos(theta)**21 + 1.00366632868385e+22*cos(theta)**19 - 1.85944682778916e+21*cos(theta)**17 + 2.61785474719798e+20*cos(theta)**15 - 2.73507212393819e+19*cos(theta)**13 + 2.05130409295364e+18*cos(theta)**11 - 1.05342413737115e+17*cos(theta)**9 + 3.45384963072509e+15*cos(theta)**7 - 64701911012691.2*cos(theta)**5 + 567560622918.344*cos(theta)**3 - 1474183436.15154*cos(theta))*sin(5*phi)

@torch.jit.script
def Yl48_m_minus_4(theta, phi):
    return 7.13298663882281e-7*(1.0 - cos(theta)**2)**2*(1.06763480365382e+20*cos(theta)**44 - 1.06313949921738e+21*cos(theta)**42 + 4.92130703669983e+21*cos(theta)**40 - 1.40608772477138e+22*cos(theta)**38 + 2.77662828796146e+22*cos(theta)**36 - 4.02132372739246e+22*cos(theta)**34 + 4.4234561001317e+22*cos(theta)**32 - 3.77630675673894e+22*cos(theta)**30 + 2.53502073947753e+22*cos(theta)**28 - 1.34773254503869e+22*cos(theta)**26 + 5.68848152126718e+21*cos(theta)**24 - 1.90305563620575e+21*cos(theta)**22 + 5.01833164341927e+20*cos(theta)**20 - 1.03302601543842e+20*cos(theta)**18 + 1.63615921699874e+19*cos(theta)**16 - 1.95362294567014e+18*cos(theta)**14 + 1.70942007746137e+17*cos(theta)**12 - 1.05342413737115e+16*cos(theta)**10 + 431731203840636.0*cos(theta)**8 - 10783651835448.5*cos(theta)**6 + 141890155729.586*cos(theta)**4 - 737091718.075771*cos(theta)**2 + 632154.132140456)*sin(4*phi)

@torch.jit.script
def Yl48_m_minus_3(theta, phi):
    return 3.45047860784155e-5*(1.0 - cos(theta)**2)**1.5*(2.37252178589738e+18*cos(theta)**45 - 2.47241744004043e+19*cos(theta)**43 + 1.20031878943898e+20*cos(theta)**41 - 3.60535314043943e+20*cos(theta)**39 + 7.50440077827421e+20*cos(theta)**37 - 1.14894963639784e+21*cos(theta)**35 + 1.34044124246415e+21*cos(theta)**33 - 1.21816346991579e+21*cos(theta)**31 + 8.74145082578459e+20*cos(theta)**29 - 4.9916020186618e+20*cos(theta)**27 + 2.27539260850687e+20*cos(theta)**25 - 8.27415494002499e+19*cos(theta)**23 + 2.38968173496156e+19*cos(theta)**21 - 5.43697902862326e+18*cos(theta)**19 + 9.62446598234552e+17*cos(theta)**17 - 1.30241529711342e+17*cos(theta)**15 + 1.31493852112413e+16*cos(theta)**13 - 957658306701047.0*cos(theta)**11 + 47970133760070.7*cos(theta)**9 - 1540521690778.36*cos(theta)**7 + 28378031145.9172*cos(theta)**5 - 245697239.35859*cos(theta)**3 + 632154.132140456*cos(theta))*sin(3*phi)

@torch.jit.script
def Yl48_m_minus_2(theta, phi):
    return 0.0016712573995038*(1.0 - cos(theta)**2)*(5.15765605629865e+16*cos(theta)**46 - 5.61913054554643e+17*cos(theta)**44 + 2.85790187961662e+18*cos(theta)**42 - 9.01338285109858e+18*cos(theta)**40 + 1.97484231007216e+19*cos(theta)**38 - 3.19152676777179e+19*cos(theta)**36 + 3.94247424254162e+19*cos(theta)**34 - 3.80676084348684e+19*cos(theta)**32 + 2.91381694192819e+19*cos(theta)**30 - 1.78271500666493e+19*cos(theta)**28 + 8.75151003271874e+18*cos(theta)**26 - 3.44756455834375e+18*cos(theta)**24 + 1.08621897043707e+18*cos(theta)**22 - 2.71848951431163e+17*cos(theta)**20 + 5.34692554574751e+16*cos(theta)**18 - 8.1400956069589e+15*cos(theta)**16 + 939241800802950.0*cos(theta)**14 - 79804858891753.9*cos(theta)**12 + 4797013376007.07*cos(theta)**10 - 192565211347.295*cos(theta)**8 + 4729671857.65287*cos(theta)**6 - 61424309.8396476*cos(theta)**4 + 316077.066070228*cos(theta)**2 - 269.460414382121)*sin(2*phi)

@torch.jit.script
def Yl48_m_minus_1(theta, phi):
    return 0.0810172083213255*(1.0 - cos(theta)**2)**0.5*(1.09737362899971e+15*cos(theta)**47 - 1.24869567678809e+16*cos(theta)**45 + 6.64628344096889e+16*cos(theta)**43 - 2.19838606124356e+17*cos(theta)**41 + 5.06369823095426e+17*cos(theta)**39 - 8.62574802100484e+17*cos(theta)**37 + 1.12642121215475e+18*cos(theta)**35 - 1.15356389196571e+18*cos(theta)**33 + 9.39940949009095e+17*cos(theta)**31 - 6.14729312643079e+17*cos(theta)**29 + 3.24130001211805e+17*cos(theta)**27 - 1.3790258233375e+17*cos(theta)**25 + 4.72269117581335e+16*cos(theta)**23 - 1.29451881633887e+16*cos(theta)**21 + 2.81417133986711e+15*cos(theta)**19 - 478829153350524.0*cos(theta)**17 + 62616120053530.0*cos(theta)**15 - 6138835299365.69*cos(theta)**13 + 436092125091.551*cos(theta)**11 - 21396134594.1439*cos(theta)**9 + 675667408.236124*cos(theta)**7 - 12284861.9679295*cos(theta)**5 + 105359.022023409*cos(theta)**3 - 269.460414382121*cos(theta))*sin(phi)

@torch.jit.script
def Yl48_m0(theta, phi):
    return 63517620065829.3*cos(theta)**48 - 754188162465847.0*cos(theta)**46 + 4.1966921943664e+15*cos(theta)**44 - 1.4542383940918e+16*cos(theta)**42 + 3.51713274526135e+16*cos(theta)**40 - 6.30658285357208e+16*cos(theta)**38 + 8.69319165894348e+16*cos(theta)**36 - 9.42635240126401e+16*cos(theta)**34 + 8.16077731035356e+16*cos(theta)**32 - 5.69303171017632e+16*cos(theta)**30 + 3.21619323886585e+16*cos(theta)**28 - 1.47360126580762e+16*cos(theta)**26 + 5.46712798387532e+15*cos(theta)**24 - 1.63480750113715e+15*cos(theta)**22 + 390932228532796.0*cos(theta)**20 - 73907585493762.5*cos(theta)**18 + 10872942865909.3*cos(theta)**16 - 1218256903743.34*cos(theta)**14 + 100966646849.402*cos(theta)**12 - 5944512660.1789*cos(theta)**10 + 234651815.533378*cos(theta)**8 - 5688528.86141522*cos(theta)**6 + 73180.0453869882*cos(theta)**4 - 374.322482797894*cos(theta)**2 + 0.31830143095059

@torch.jit.script
def Yl48_m1(theta, phi):
    return 0.0810172083213255*(1.0 - cos(theta)**2)**0.5*(1.09737362899971e+15*cos(theta)**47 - 1.24869567678809e+16*cos(theta)**45 + 6.64628344096889e+16*cos(theta)**43 - 2.19838606124356e+17*cos(theta)**41 + 5.06369823095426e+17*cos(theta)**39 - 8.62574802100484e+17*cos(theta)**37 + 1.12642121215475e+18*cos(theta)**35 - 1.15356389196571e+18*cos(theta)**33 + 9.39940949009095e+17*cos(theta)**31 - 6.14729312643079e+17*cos(theta)**29 + 3.24130001211805e+17*cos(theta)**27 - 1.3790258233375e+17*cos(theta)**25 + 4.72269117581335e+16*cos(theta)**23 - 1.29451881633887e+16*cos(theta)**21 + 2.81417133986711e+15*cos(theta)**19 - 478829153350524.0*cos(theta)**17 + 62616120053530.0*cos(theta)**15 - 6138835299365.69*cos(theta)**13 + 436092125091.551*cos(theta)**11 - 21396134594.1439*cos(theta)**9 + 675667408.236124*cos(theta)**7 - 12284861.9679295*cos(theta)**5 + 105359.022023409*cos(theta)**3 - 269.460414382121*cos(theta))*cos(phi)

@torch.jit.script
def Yl48_m2(theta, phi):
    return 0.0016712573995038*(1.0 - cos(theta)**2)*(5.15765605629865e+16*cos(theta)**46 - 5.61913054554643e+17*cos(theta)**44 + 2.85790187961662e+18*cos(theta)**42 - 9.01338285109858e+18*cos(theta)**40 + 1.97484231007216e+19*cos(theta)**38 - 3.19152676777179e+19*cos(theta)**36 + 3.94247424254162e+19*cos(theta)**34 - 3.80676084348684e+19*cos(theta)**32 + 2.91381694192819e+19*cos(theta)**30 - 1.78271500666493e+19*cos(theta)**28 + 8.75151003271874e+18*cos(theta)**26 - 3.44756455834375e+18*cos(theta)**24 + 1.08621897043707e+18*cos(theta)**22 - 2.71848951431163e+17*cos(theta)**20 + 5.34692554574751e+16*cos(theta)**18 - 8.1400956069589e+15*cos(theta)**16 + 939241800802950.0*cos(theta)**14 - 79804858891753.9*cos(theta)**12 + 4797013376007.07*cos(theta)**10 - 192565211347.295*cos(theta)**8 + 4729671857.65287*cos(theta)**6 - 61424309.8396476*cos(theta)**4 + 316077.066070228*cos(theta)**2 - 269.460414382121)*cos(2*phi)

@torch.jit.script
def Yl48_m3(theta, phi):
    return 3.45047860784155e-5*(1.0 - cos(theta)**2)**1.5*(2.37252178589738e+18*cos(theta)**45 - 2.47241744004043e+19*cos(theta)**43 + 1.20031878943898e+20*cos(theta)**41 - 3.60535314043943e+20*cos(theta)**39 + 7.50440077827421e+20*cos(theta)**37 - 1.14894963639784e+21*cos(theta)**35 + 1.34044124246415e+21*cos(theta)**33 - 1.21816346991579e+21*cos(theta)**31 + 8.74145082578459e+20*cos(theta)**29 - 4.9916020186618e+20*cos(theta)**27 + 2.27539260850687e+20*cos(theta)**25 - 8.27415494002499e+19*cos(theta)**23 + 2.38968173496156e+19*cos(theta)**21 - 5.43697902862326e+18*cos(theta)**19 + 9.62446598234552e+17*cos(theta)**17 - 1.30241529711342e+17*cos(theta)**15 + 1.31493852112413e+16*cos(theta)**13 - 957658306701047.0*cos(theta)**11 + 47970133760070.7*cos(theta)**9 - 1540521690778.36*cos(theta)**7 + 28378031145.9172*cos(theta)**5 - 245697239.35859*cos(theta)**3 + 632154.132140456*cos(theta))*cos(3*phi)

@torch.jit.script
def Yl48_m4(theta, phi):
    return 7.13298663882281e-7*(1.0 - cos(theta)**2)**2*(1.06763480365382e+20*cos(theta)**44 - 1.06313949921738e+21*cos(theta)**42 + 4.92130703669983e+21*cos(theta)**40 - 1.40608772477138e+22*cos(theta)**38 + 2.77662828796146e+22*cos(theta)**36 - 4.02132372739246e+22*cos(theta)**34 + 4.4234561001317e+22*cos(theta)**32 - 3.77630675673894e+22*cos(theta)**30 + 2.53502073947753e+22*cos(theta)**28 - 1.34773254503869e+22*cos(theta)**26 + 5.68848152126718e+21*cos(theta)**24 - 1.90305563620575e+21*cos(theta)**22 + 5.01833164341927e+20*cos(theta)**20 - 1.03302601543842e+20*cos(theta)**18 + 1.63615921699874e+19*cos(theta)**16 - 1.95362294567014e+18*cos(theta)**14 + 1.70942007746137e+17*cos(theta)**12 - 1.05342413737115e+16*cos(theta)**10 + 431731203840636.0*cos(theta)**8 - 10783651835448.5*cos(theta)**6 + 141890155729.586*cos(theta)**4 - 737091718.075771*cos(theta)**2 + 632154.132140456)*cos(4*phi)

@torch.jit.script
def Yl48_m5(theta, phi):
    return 1.47709061060563e-8*(1.0 - cos(theta)**2)**2.5*(4.69759313607681e+21*cos(theta)**43 - 4.46518589671301e+22*cos(theta)**41 + 1.96852281467993e+23*cos(theta)**39 - 5.34313335413124e+23*cos(theta)**37 + 9.99586183666125e+23*cos(theta)**35 - 1.36725006731344e+24*cos(theta)**33 + 1.41550595204214e+24*cos(theta)**31 - 1.13289202702168e+24*cos(theta)**29 + 7.09805807053708e+23*cos(theta)**27 - 3.50410461710059e+23*cos(theta)**25 + 1.36523556510412e+23*cos(theta)**23 - 4.18672239965265e+22*cos(theta)**21 + 1.00366632868385e+22*cos(theta)**19 - 1.85944682778916e+21*cos(theta)**17 + 2.61785474719798e+20*cos(theta)**15 - 2.73507212393819e+19*cos(theta)**13 + 2.05130409295364e+18*cos(theta)**11 - 1.05342413737115e+17*cos(theta)**9 + 3.45384963072509e+15*cos(theta)**7 - 64701911012691.2*cos(theta)**5 + 567560622918.344*cos(theta)**3 - 1474183436.15154*cos(theta))*cos(5*phi)

@torch.jit.script
def Yl48_m6(theta, phi):
    return 3.06532148899894e-10*(1.0 - cos(theta)**2)**3*(2.01996504851303e+23*cos(theta)**42 - 1.83072621765233e+24*cos(theta)**40 + 7.67723897725173e+24*cos(theta)**38 - 1.97695934102856e+25*cos(theta)**36 + 3.49855164283144e+25*cos(theta)**34 - 4.51192522213434e+25*cos(theta)**32 + 4.38806845133065e+25*cos(theta)**30 - 3.28538687836288e+25*cos(theta)**28 + 1.91647567904501e+25*cos(theta)**26 - 8.76026154275146e+24*cos(theta)**24 + 3.14004179973949e+24*cos(theta)**22 - 8.79211703927056e+23*cos(theta)**20 + 1.90696602449932e+23*cos(theta)**18 - 3.16105960724156e+22*cos(theta)**16 + 3.92678212079697e+21*cos(theta)**14 - 3.55559376111965e+20*cos(theta)**12 + 2.25643450224901e+19*cos(theta)**10 - 9.48081723634037e+17*cos(theta)**8 + 2.41769474150756e+16*cos(theta)**6 - 323509555063456.0*cos(theta)**4 + 1702681868755.03*cos(theta)**2 - 1474183436.15154)*cos(6*phi)

@torch.jit.script
def Yl48_m7(theta, phi):
    return 6.37778742419495e-12*(1.0 - cos(theta)**2)**3.5*(8.48385320375472e+24*cos(theta)**41 - 7.32290487060934e+25*cos(theta)**39 + 2.91735081135566e+26*cos(theta)**37 - 7.11705362770281e+26*cos(theta)**35 + 1.18950755856269e+27*cos(theta)**33 - 1.44381607108299e+27*cos(theta)**31 + 1.31642053539919e+27*cos(theta)**29 - 9.19908325941606e+26*cos(theta)**27 + 4.98283676551703e+26*cos(theta)**25 - 2.10246277026035e+26*cos(theta)**23 + 6.90809195942687e+25*cos(theta)**21 - 1.75842340785411e+25*cos(theta)**19 + 3.43253884409878e+24*cos(theta)**17 - 5.0576953715865e+23*cos(theta)**15 + 5.49749496911576e+22*cos(theta)**13 - 4.26671251334358e+21*cos(theta)**11 + 2.25643450224901e+20*cos(theta)**9 - 7.58465378907229e+18*cos(theta)**7 + 1.45061684490454e+17*cos(theta)**5 - 1.29403822025382e+15*cos(theta)**3 + 3405363737510.06*cos(theta))*cos(7*phi)

@torch.jit.script
def Yl48_m8(theta, phi):
    return 1.33101851880292e-13*(1.0 - cos(theta)**2)**4*(3.47837981353944e+26*cos(theta)**40 - 2.85593289953764e+27*cos(theta)**38 + 1.07941980020159e+28*cos(theta)**36 - 2.49096876969598e+28*cos(theta)**34 + 3.92537494325687e+28*cos(theta)**32 - 4.47582982035726e+28*cos(theta)**30 + 3.81761955265766e+28*cos(theta)**28 - 2.48375248004234e+28*cos(theta)**26 + 1.24570919137926e+28*cos(theta)**24 - 4.83566437159881e+27*cos(theta)**22 + 1.45069931147964e+27*cos(theta)**20 - 3.34100447492281e+26*cos(theta)**18 + 5.83531603496793e+25*cos(theta)**16 - 7.58654305737975e+24*cos(theta)**14 + 7.14674345985049e+23*cos(theta)**12 - 4.69338376467793e+22*cos(theta)**10 + 2.03079105202411e+21*cos(theta)**8 - 5.3092576523506e+19*cos(theta)**6 + 7.25308422452268e+17*cos(theta)**4 - 3.88211466076147e+15*cos(theta)**2 + 3405363737510.06)*cos(8*phi)

@torch.jit.script
def Yl48_m9(theta, phi):
    return 2.78751154304613e-15*(1.0 - cos(theta)**2)**4.5*(1.39135192541577e+28*cos(theta)**39 - 1.0852545018243e+29*cos(theta)**37 + 3.88591128072573e+29*cos(theta)**35 - 8.46929381696635e+29*cos(theta)**33 + 1.2561199818422e+30*cos(theta)**31 - 1.34274894610718e+30*cos(theta)**29 + 1.06893347474415e+30*cos(theta)**27 - 6.45775644811007e+29*cos(theta)**25 + 2.98970205931022e+29*cos(theta)**23 - 1.06384616175174e+29*cos(theta)**21 + 2.90139862295928e+28*cos(theta)**19 - 6.01380805486106e+27*cos(theta)**17 + 9.33650565594868e+26*cos(theta)**15 - 1.06211602803317e+26*cos(theta)**13 + 8.57609215182059e+24*cos(theta)**11 - 4.69338376467793e+23*cos(theta)**9 + 1.62463284161929e+22*cos(theta)**7 - 3.18555459141036e+20*cos(theta)**5 + 2.90123368980907e+18*cos(theta)**3 - 7.76422932152295e+15*cos(theta))*cos(9*phi)

@torch.jit.script
def Yl48_m10(theta, phi):
    return 5.86098181883417e-17*(1.0 - cos(theta)**2)**5*(5.42627250912152e+29*cos(theta)**38 - 4.01544165674993e+30*cos(theta)**36 + 1.36006894825401e+31*cos(theta)**34 - 2.79486695959889e+31*cos(theta)**32 + 3.89397194371082e+31*cos(theta)**30 - 3.89397194371082e+31*cos(theta)**28 + 2.88612038180919e+31*cos(theta)**26 - 1.61443911202752e+31*cos(theta)**24 + 6.8763147364135e+30*cos(theta)**22 - 2.23407693967865e+30*cos(theta)**20 + 5.51265738362264e+29*cos(theta)**18 - 1.02234736932638e+29*cos(theta)**16 + 1.4004758483923e+28*cos(theta)**14 - 1.38075083644311e+27*cos(theta)**12 + 9.43370136700265e+25*cos(theta)**10 - 4.22404538821014e+24*cos(theta)**8 + 1.1372429891335e+23*cos(theta)**6 - 1.59277729570518e+21*cos(theta)**4 + 8.70370106942722e+18*cos(theta)**2 - 7.76422932152295e+15)*cos(10*phi)

@torch.jit.script
def Yl48_m11(theta, phi):
    return 1.23780596161278e-18*(1.0 - cos(theta)**2)**5.5*(2.06198355346618e+31*cos(theta)**37 - 1.44555899642997e+32*cos(theta)**35 + 4.62423442406362e+32*cos(theta)**33 - 8.94357427071646e+32*cos(theta)**31 + 1.16819158311325e+33*cos(theta)**29 - 1.09031214423903e+33*cos(theta)**27 + 7.50391299270391e+32*cos(theta)**25 - 3.87465386886604e+32*cos(theta)**23 + 1.51278924201097e+32*cos(theta)**21 - 4.4681538793573e+31*cos(theta)**19 + 9.92278329052075e+30*cos(theta)**17 - 1.63575579092221e+30*cos(theta)**15 + 1.96066618774922e+29*cos(theta)**13 - 1.65690100373174e+28*cos(theta)**11 + 9.43370136700265e+26*cos(theta)**9 - 3.37923631056811e+25*cos(theta)**7 + 6.823457934801e+23*cos(theta)**5 - 6.37110918282073e+21*cos(theta)**3 + 1.74074021388544e+19*cos(theta))*cos(11*phi)

@torch.jit.script
def Yl48_m12(theta, phi):
    return 2.62709684472235e-20*(1.0 - cos(theta)**2)**6*(7.62933914782486e+32*cos(theta)**36 - 5.05945648750491e+33*cos(theta)**34 + 1.525997359941e+34*cos(theta)**32 - 2.7725080239221e+34*cos(theta)**30 + 3.38775559102841e+34*cos(theta)**28 - 2.94384278944538e+34*cos(theta)**26 + 1.87597824817598e+34*cos(theta)**24 - 8.9117038983919e+33*cos(theta)**22 + 3.17685740822304e+33*cos(theta)**20 - 8.48949237077887e+32*cos(theta)**18 + 1.68687315938853e+32*cos(theta)**16 - 2.45363368638331e+31*cos(theta)**14 + 2.54886604407399e+30*cos(theta)**12 - 1.82259110410491e+29*cos(theta)**10 + 8.49033123030238e+27*cos(theta)**8 - 2.36546541739768e+26*cos(theta)**6 + 3.4117289674005e+24*cos(theta)**4 - 1.91133275484622e+22*cos(theta)**2 + 1.74074021388544e+19)*cos(12*phi)

@torch.jit.script
def Yl48_m13(theta, phi):
    return 5.60608805466343e-22*(1.0 - cos(theta)**2)**6.5*(2.74656209321695e+34*cos(theta)**35 - 1.72021520575167e+35*cos(theta)**33 + 4.88319155181119e+35*cos(theta)**31 - 8.31752407176631e+35*cos(theta)**29 + 9.48571565487955e+35*cos(theta)**27 - 7.65399125255798e+35*cos(theta)**25 + 4.50234779562234e+35*cos(theta)**23 - 1.96057485764622e+35*cos(theta)**21 + 6.35371481644608e+34*cos(theta)**19 - 1.5281086267402e+34*cos(theta)**17 + 2.69899705502165e+33*cos(theta)**15 - 3.43508716093664e+32*cos(theta)**13 + 3.05863925288879e+31*cos(theta)**11 - 1.82259110410491e+30*cos(theta)**9 + 6.79226498424191e+28*cos(theta)**7 - 1.41927925043861e+27*cos(theta)**5 + 1.3646915869602e+25*cos(theta)**3 - 3.82266550969244e+22*cos(theta))*cos(13*phi)

@torch.jit.script
def Yl48_m14(theta, phi):
    return 1.20345553308864e-23*(1.0 - cos(theta)**2)**7*(9.61296732625932e+35*cos(theta)**34 - 5.67671017898051e+36*cos(theta)**32 + 1.51378938106147e+37*cos(theta)**30 - 2.41208198081223e+37*cos(theta)**28 + 2.56114322681748e+37*cos(theta)**26 - 1.9134978131395e+37*cos(theta)**24 + 1.03553999299314e+37*cos(theta)**22 - 4.11720720105706e+36*cos(theta)**20 + 1.20720581512475e+36*cos(theta)**18 - 2.59778466545833e+35*cos(theta)**16 + 4.04849558253247e+34*cos(theta)**14 - 4.46561330921763e+33*cos(theta)**12 + 3.36450317817767e+32*cos(theta)**10 - 1.64033199369442e+31*cos(theta)**8 + 4.75458548896934e+29*cos(theta)**6 - 7.09639625219304e+27*cos(theta)**4 + 4.0940747608806e+25*cos(theta)**2 - 3.82266550969244e+22)*cos(14*phi)

@torch.jit.script
def Yl48_m15(theta, phi):
    return 2.60028119225837e-25*(1.0 - cos(theta)**2)**7.5*(3.26840889092817e+37*cos(theta)**33 - 1.81654725727376e+38*cos(theta)**31 + 4.5413681431844e+38*cos(theta)**29 - 6.75382954627424e+38*cos(theta)**27 + 6.65897238972545e+38*cos(theta)**25 - 4.59239475153479e+38*cos(theta)**23 + 2.27818798458491e+38*cos(theta)**21 - 8.23441440211412e+37*cos(theta)**19 + 2.17297046722456e+37*cos(theta)**17 - 4.15645546473333e+36*cos(theta)**15 + 5.66789381554545e+35*cos(theta)**13 - 5.35873597106116e+34*cos(theta)**11 + 3.36450317817767e+33*cos(theta)**9 - 1.31226559495554e+32*cos(theta)**7 + 2.8527512933816e+30*cos(theta)**5 - 2.83855850087721e+28*cos(theta)**3 + 8.1881495217612e+25*cos(theta))*cos(15*phi)

@torch.jit.script
def Yl48_m16(theta, phi):
    return 5.6581356846753e-27*(1.0 - cos(theta)**2)**8*(1.0785749340063e+39*cos(theta)**32 - 5.63129649754866e+39*cos(theta)**30 + 1.31699676152348e+40*cos(theta)**28 - 1.82353397749405e+40*cos(theta)**26 + 1.66474309743136e+40*cos(theta)**24 - 1.056250792853e+40*cos(theta)**22 + 4.7841947676283e+39*cos(theta)**20 - 1.56453873640168e+39*cos(theta)**18 + 3.69404979428175e+38*cos(theta)**16 - 6.2346831971e+37*cos(theta)**14 + 7.36826196020909e+36*cos(theta)**12 - 5.89460956816727e+35*cos(theta)**10 + 3.0280528603599e+34*cos(theta)**8 - 9.18585916468876e+32*cos(theta)**6 + 1.4263756466908e+31*cos(theta)**4 - 8.51567550263164e+28*cos(theta)**2 + 8.1881495217612e+25)*cos(16*phi)

@torch.jit.script
def Yl48_m17(theta, phi):
    return 1.24062831914294e-28*(1.0 - cos(theta)**2)**8.5*(3.45143978882015e+40*cos(theta)**31 - 1.6893889492646e+41*cos(theta)**29 + 3.68759093226574e+41*cos(theta)**27 - 4.74118834148452e+41*cos(theta)**25 + 3.99538343383527e+41*cos(theta)**23 - 2.3237517442766e+41*cos(theta)**21 + 9.5683895352566e+40*cos(theta)**19 - 2.81616972552303e+40*cos(theta)**17 + 5.9104796708508e+39*cos(theta)**15 - 8.72855647594e+38*cos(theta)**13 + 8.84191435225091e+37*cos(theta)**11 - 5.89460956816727e+36*cos(theta)**9 + 2.42244228828792e+35*cos(theta)**7 - 5.51151549881325e+33*cos(theta)**5 + 5.7055025867632e+31*cos(theta)**3 - 1.70313510052633e+29*cos(theta))*cos(17*phi)

@torch.jit.script
def Yl48_m18(theta, phi):
    return 2.7427667480681e-30*(1.0 - cos(theta)**2)**9*(1.06994633453425e+42*cos(theta)**30 - 4.89922795286733e+42*cos(theta)**28 + 9.95649551711749e+42*cos(theta)**26 - 1.18529708537113e+43*cos(theta)**24 + 9.18938189782112e+42*cos(theta)**22 - 4.87987866298087e+42*cos(theta)**20 + 1.81799401169875e+42*cos(theta)**18 - 4.78748853338915e+41*cos(theta)**16 + 8.8657195062762e+40*cos(theta)**14 - 1.1347123418722e+40*cos(theta)**12 + 9.726105787476e+38*cos(theta)**10 - 5.30514861135055e+37*cos(theta)**8 + 1.69570960180154e+36*cos(theta)**6 - 2.75575774940663e+34*cos(theta)**4 + 1.71165077602896e+32*cos(theta)**2 - 1.70313510052633e+29)*cos(18*phi)

@torch.jit.script
def Yl48_m19(theta, phi):
    return 6.11773762133704e-32*(1.0 - cos(theta)**2)**9.5*(3.20983900360274e+43*cos(theta)**29 - 1.37178382680285e+44*cos(theta)**27 + 2.58868883445055e+44*cos(theta)**25 - 2.84471300489071e+44*cos(theta)**23 + 2.02166401752065e+44*cos(theta)**21 - 9.75975732596174e+43*cos(theta)**19 + 3.27238922105776e+43*cos(theta)**17 - 7.65998165342264e+42*cos(theta)**15 + 1.24120073087867e+42*cos(theta)**13 - 1.36165481024664e+41*cos(theta)**11 + 9.726105787476e+39*cos(theta)**9 - 4.24411888908044e+38*cos(theta)**7 + 1.01742576108093e+37*cos(theta)**5 - 1.10230309976265e+35*cos(theta)**3 + 3.42330155205792e+32*cos(theta))*cos(19*phi)

@torch.jit.script
def Yl48_m20(theta, phi):
    return 1.37764522622734e-33*(1.0 - cos(theta)**2)**10*(9.30853311044794e+44*cos(theta)**28 - 3.70381633236771e+45*cos(theta)**26 + 6.47172208612637e+45*cos(theta)**24 - 6.54283991124863e+45*cos(theta)**22 + 4.24549443679336e+45*cos(theta)**20 - 1.85435389193273e+45*cos(theta)**18 + 5.56306167579819e+44*cos(theta)**16 - 1.1489972480134e+44*cos(theta)**14 + 1.61356095014227e+43*cos(theta)**12 - 1.4978202912713e+42*cos(theta)**10 + 8.7534952087284e+40*cos(theta)**8 - 2.97088322235631e+39*cos(theta)**6 + 5.08712880540463e+37*cos(theta)**4 - 3.30690929928795e+35*cos(theta)**2 + 3.42330155205792e+32)*cos(20*phi)

@torch.jit.script
def Yl48_m21(theta, phi):
    return 3.13425141500133e-35*(1.0 - cos(theta)**2)**10.5*(2.60638927092542e+46*cos(theta)**27 - 9.62992246415603e+46*cos(theta)**25 + 1.55321330067033e+47*cos(theta)**23 - 1.4394247804747e+47*cos(theta)**21 + 8.49098887358671e+46*cos(theta)**19 - 3.33783700547891e+46*cos(theta)**17 + 8.9008986812771e+45*cos(theta)**15 - 1.60859614721875e+45*cos(theta)**13 + 1.93627314017072e+44*cos(theta)**11 - 1.4978202912713e+43*cos(theta)**9 + 7.00279616698272e+41*cos(theta)**7 - 1.78252993341378e+40*cos(theta)**5 + 2.03485152216185e+38*cos(theta)**3 - 6.6138185985759e+35*cos(theta))*cos(21*phi)

@torch.jit.script
def Yl48_m22(theta, phi):
    return 7.20946318604152e-37*(1.0 - cos(theta)**2)**11*(7.03725103149864e+47*cos(theta)**26 - 2.40748061603901e+48*cos(theta)**24 + 3.57239059154175e+48*cos(theta)**22 - 3.02279203899687e+48*cos(theta)**20 + 1.61328788598148e+48*cos(theta)**18 - 5.67432290931415e+47*cos(theta)**16 + 1.33513480219157e+47*cos(theta)**14 - 2.09117499138438e+46*cos(theta)**12 + 2.12990045418779e+45*cos(theta)**10 - 1.34803826214417e+44*cos(theta)**8 + 4.9019573168879e+42*cos(theta)**6 - 8.91264966706892e+40*cos(theta)**4 + 6.10455456648556e+38*cos(theta)**2 - 6.6138185985759e+35)*cos(22*phi)

@torch.jit.script
def Yl48_m23(theta, phi):
    return 1.67798115928159e-38*(1.0 - cos(theta)**2)**11.5*(1.82968526818965e+49*cos(theta)**25 - 5.77795347849362e+49*cos(theta)**23 + 7.85925930139186e+49*cos(theta)**21 - 6.04558407799374e+49*cos(theta)**19 + 2.