# Do this import to ensure that the Gym environments get registered properly
import deep_sprl.environments
from .point_mass_2d_experiment import PointMass2DExperiment
from .abstract_experiment import CurriculumType, Learner

__all__ = ['CurriculumType', 'PointMass2DExperiment', 'Learner']
try:
    import mujoco_py
    from .pick_and_place_experiment import PickAndPlaceExperiment
    from .maze_experiment import MazeExperiment

    __all__ += ['PickAndPlaceExperiment', 'MazeExperiment']
except ModuleNotFoundError:
    pass
