"""Taken from goal gan's repo"""
import numpy as np


def is_feasible(pos, structre, size_scaling, init_x, init_y):  # the arg is the goal, not the full space!!!
    empty_space = find_empty_cells(structre, size_scaling, init_x, init_y)
    for space in empty_space:
        abs_diff = np.abs(np.array(np.array(pos).reshape(-1)[:2]) - np.array(space))
        if np.size(np.where(abs_diff < size_scaling / 2)[0]) == 2:
            return True
    return False


def find_empty_cells(structure, size_scaling, init_x, init_y):
    empty_space = []
    for i in range(len(structure)):
        for j in range(len(structure[0])):
            if structure[i][j] == 'r' or structure[i][j] == 'g' or structure[i][j] == 0:
                empty_space.append((j * size_scaling - init_x, i * size_scaling - init_y))
    return empty_space


def find_robot(structure, size_scaling):
    for i in range(len(structure)):
        for j in range(len(structure[0])):
            if structure[i][j] == 'r':
                return j * size_scaling, i * size_scaling
    assert False


def construct_maze(maze_id=0, length=1, evaluation=False):
    # define the maze to use
    if maze_id == 0:  # Bigger circle shaped
        if evaluation:
            # We fill the spaces for the samples to not sample goals within the inner circle for evaluation
            structure = [
                [1, 1, 1, 1, 1, 1, 1, 1, 1],
                [1, 'r', 0, 0, 0, 0, 0, 0, 1],
                [1, 0, 1, 1, 1, 1, 1, 0, 1],
                [1, 0, 1, 1, 1, 1, 1, 0, 1],
                [1, 0, 1, 1, 1, 1, 1, 0, 1],
                [1, 0, 1, 1, 1, 1, 1, 0, 1],
                [1, 0, 1, 1, 1, 1, 1, 0, 1],
                [1, 0, 0, 0, 0, 0, 0, 0, 1],
                [1, 1, 1, 1, 1, 1, 1, 1, 1],
            ]

        else:
            structure = [
                [1, 1, 1, 1, 1, 1, 1, 1, 1],
                [1, 'r', 0, 0, 0, 0, 0, 0, 1],
                [1, 0, 1, 1, 1, 1, 1, 0, 1],
                [1, 0, 1, 0, 0, 0, 1, 0, 1],
                [1, 0, 1, 0, 0, 0, 1, 0, 1],
                [1, 0, 1, 0, 0, 0, 1, 0, 1],
                [1, 0, 1, 1, 1, 1, 1, 0, 1],
                [1, 0, 0, 0, 0, 0, 0, 0, 1],
                [1, 1, 1, 1, 1, 1, 1, 1, 1],
            ]

        return structure
    else:
        raise NotImplementedError("The provided MazeId is not recognized")
