#!/bin/bash
#SBATCH --job-name=dual_ascent
#SBATCH -c 1  # Number of Cores per Task
#SBATCH --mem=20GB  # Requested Memory
#SBATCH --partition=cpu
#SBATCH -t 24:00:00  # Job time limit
#SBATCH -o ./uai_experiments/slurm-%x.%j.out  # %j = job ID

module load miniconda/22.11.1-1
conda activate ddrp

while getopts d:e:m:i:s: flag
do
    case "${flag}" in
        d) DATA=${OPTARG};;
        e) EPSILON=${OPTARG};;
        m) MARGINALS=${OPTARG};;
        i) ITERATION=${OPTARG};;
    esac
done

python3 -u supported_recon_experiment.py --data $DATA --epsilon $EPSILON --marginals $MARGINALS --iteration $ITERATION