import openai
import numpy as np
from tqdm import tqdm
from pathlib import Path


from my_utils.data_utils import save_list_to_tsv
from my_utils.my_dataloader import load_test_data

from my_openai.openai_wrapper import chatgpt_completion, MY_API_KEY
import shared_dir




openai.api_key = MY_API_KEY

def paraphrase_chatgpt(orig_text, dataset):
    # return 'this is a test.'
    if dataset == 'squad':
        text_type = 'essay'
    elif dataset == 'eli5':
        text_type = 'answer'
    elif dataset == 'yelp':
        text_type = 'review'
    elif dataset == 'watermark':
        text_type = 'writing'
    else:
        raise Exception('Wrong dataset type', dataset)

    messages = [
        {"role": "user",
         "content": f"Paraphrase this {text_type}:\n{orig_text}"}]

    completion = chatgpt_completion(messages, temperature=1)
    # completion = chatgpt_completion_fast(messages, temperature=0.7)

    return completion['choices'][0]['message']['content']


baseline_name = 'chatgpt_paraphrase'
dataset = ''
task_type = 'paraphrase'

# load test
test_data_list = load_test_data(dataset, task_type)

all_data_list = []
new_data_list = []
for ai_t in tqdm(test_data_list):
    humanlike_t = paraphrase_chatgpt(ai_t, dataset)
    all_data_list.append((ai_t, humanlike_t)) # human-like ai, ai
    new_data_list.append(humanlike_t)

all_data_list.insert(0, ['ai', 'paraphrased'])

# # save
output_folder = Path(shared_dir.test_results_dir, dataset, baseline_name)
output_folder.mkdir(parents=True, exist_ok=True)
save_list_to_tsv(all_data_list, output_folder.joinpath('generated_text.tsv'))