import openai
import time

from .openai_settings import CHAT_MODEL_VERSION, MY_API_KEY

import random


def chatgpt_completion(messages, **kwargs):

    while True:
        try:
            completion = openai.ChatCompletion.create(
                model=CHAT_MODEL_VERSION,
                messages=messages,
                timeout=60,
                **kwargs
            )
            return completion
        except openai.error.OpenAIError as e:
            time_sleep = 3
            print("API error:", e)
            print(f"Retrying in {time_sleep} seconds...")
            time.sleep(time_sleep)

