# default PEARL experiment settings
# all experiments should modify these settings only as needed
default_config = dict(
    env_name='cheetah-dir',
    n_train_tasks=2,
    n_eval_tasks=2,
    last_layer_size=200, # number of units for the linear output layer for the q network
    last_policy_layer_size=300, # number of units for the linear output layer for the policy
    adapter_net_size=600, # number of units for the adapter net
    net_size=300, # number of units per FC layer in each network
    path_to_weights=None, # path to pre-trained weights to load into networks
    adapt_steps=200, #Number of steps for adaptation model
    env_params=dict(
        n_tasks=2, # number of distinct tasks in this domain, shoudl equal sum of train and eval tasks
    ),
    algo_params=dict(
        num_iterations=500, # number of data sampling / training iterates
        num_initial_steps=2000, # number of transitions collected per task before training
        num_data_collect=4, # number of times to do an exploration collection num_env_steps per exploration
        num_env_steps=400, # number steps to take per exploration period
        num_train_steps_per_itr=2000, # number of meta-gradient steps taken per iteration
        num_evals=2, # number of independent evals
        num_steps_per_eval=600,  # nuumber of transitions to eval on
        batch_size=256, # number of transitions in the RL batch
        max_path_length=200, # max path length for this environment
        discount=0.99, # RL discount factor
        soft_target_tau=0.005, # for SAC target network update
        policy_lr=3E-4,
        qf_lr=3E-4,
        reward_scale=1., # scale rewards before constructing Bellman update, effectively controls weight on the entropy of the policy
        dump_eval_paths=False, # whether to save evaluation trajectories
    ),
    util_params=dict(
        base_log_dir='output',
        use_gpu=False,
        gpu_id=0,
        debug=False, # debugging triggers printing and writes logs to debug directory
    )
)



