import os
import pandas as pd


def pre_load_data(data_config):
    if not os.path.exists(data_config.data_path):
        raise FileNotFoundError(f"dataset {data_config.data_path} not found")

    df = pd.read_csv(
        data_config.data_path,
        sep=data_config.sep,
        engine='python',
        on_bad_lines='warn',
        nrows=data_config.n_sample
    )
    return df

