# Synergistic Information Retrieval: Interplay between Search and Large Language Models


## 1. create environment
```shell
conda create -n inter python=3.8
conda activate inter
pip install -r requirements.txt
pip install -U openai pyserini
```

## 2. download index and passage data 
```shell
cd ./indexes/
# download or create index data for MSMARCO including:
# 1. lucene-index-msmarco-passage.tgz
# 2. contriever_msmarco_index.tar.gz
# then unzip two tgz files into ./indexes/

cd ./data_msmarco/
# download or create passage data for MSMARCO including:
# 1. collection.tsv
# then put tsv file into ./data_msmarco/
```

## 3. run InteR
You may edit the **openai key** in `main.py` first.

```shell
mkdir runs_inter
./run_dl19.sh  # for DL'19
./run_dl20.sh  # for DL'20
```
