﻿# ePC: Overcoming Exponential Signal Decay in Deep Predictive Coding Networks
Note: for historical reasons, this codebase uses 'SO' to refer to 'sPC' and 'EO' to refer to 'ePC'.
These refer to earlier names for our methods (State Optimization & Error Optimization).
To avoid last-minute code breaks, we decided to keep the historical names in the codebase for submission.

## Folder structure
- **requirements.txt**: all packages you need to run the code.
	- We use PyTorch Lightning + wandb as the backbone of our experiments.
- **mnist_fashionmnist**: code used to produce results for (Fashion)MNIST, including all figures (see 'mnist_poc' folder)
	- Experimental runs were launched using **sweep.py**
	- For playing around with the models, we suggest using **PredictiveCodingPlayground.ipynb**
	- The datasets can be found in **datamodules**, the architectures in **get_arch.py**, all PC code in **pc_e.py**, with variants in losses and optimization procedures (SO, EO, BP) in **get_variants.py**
- **cifar**: code used to produce results for CIFAR-10/100, including all hyperparameter configs and the code for VGG and ResNet models. Mostly identical to the code in 'mnist_fashionmnist', just adapted to the setting of convolutional networks.
