import numpy as np

# For the Franka, while operating with end effector put EEF position
# at the center of the gripper finger with is 12.7cm below arm tip.
Tshift = np.array([[1, 0, 0, 0.0], [0, 1, 0, 0.0], [0, 0, 1, -0.127], [0, 0, 0, 1]])

extrapoints = [
    # gripper points
    np.array(
        [
            [1.0, 0.0, 0.0, 0.0],
            [0.0, 1.0, 0.0, 0.04],
            [0.0, 0.0, 1.0, 0.16],
            [0.0, 0.0, 0.0, 1.0],
        ]
    ),  # 1
    np.array(
        [
            [1.0, 0.0, 0.0, 0.0],
            [0.0, 1.0, 0.0, -0.04],
            [0.0, 0.0, 1.0, 0.16],
            [0.0, 0.0, 0.0, 1.0],
        ]
    ),  # 2
    # First horizontal line
    np.array(
        [
            [1.0, 0.0, 0.0, 0.0],
            [0.0, 1.0, 0.0, 0.0],
            [0.0, 0.0, 1.0, 0.08],
            [0.0, 0.0, 0.0, 1.0],
        ]
    ),  # 3
    np.array(
        [
            [1.0, 0.0, 0.0, 0.0],
            [0.0, 1.0, 0.0, 0.05],
            [0.0, 0.0, 1.0, 0.08],
            [0.0, 0.0, 0.0, 1.0],
        ]
    ),  # 4
    np.array(
        [
            [1.0, 0.0, 0.0, 0.0],
            [0.0, 1.0, 0.0, -0.05],
            [0.0, 0.0, 1.0, 0.08],
            [0.0, 0.0, 0.0, 1.0],
        ]
    ),  # 5
    # Second horizontal line
    np.array(
        [
            [1.0, 0.0, 0.0, 0.0],
            [0.0, 1.0, 0.0, 0.0],
            [0.0, 0.0, 1.0, 0.04],
            [0.0, 0.0, 0.0, 1.0],
        ]
    ),  # 6
    np.array(
        [
            [1.0, 0.0, 0.0, 0.0],
            [0.0, 1.0, 0.0, 0.05],
            [0.0, 0.0, 1.0, 0.04],
            [0.0, 0.0, 0.0, 1.0],
        ]
    ),  # 7
    np.array(
        [
            [1.0, 0.0, 0.0, 0.0],
            [0.0, 1.0, 0.0, -0.05],
            [0.0, 0.0, 1.0, 0.04],
            [0.0, 0.0, 0.0, 1.0],
        ]
    ),  # 8
]
