## General-purpose LLM-mediated Pathology model (GLMP)

**LLM-mediated pathology models for robust cross-institution generalization**

This repository contains the implementation of GLMP, a novel framework that generates robust numerical embeddings from histology image patches by first converting them into text descriptions using multimodal large language models (MLLMs). This approach prioritizes genuine biological signals over tissue source institution (TSI)-specific signatures, improving cross-TSI generalization compared to existing pathology foundation models.

### Prerequisites

- Python 3.8+
- LLM API key

### Dependencies

Install required packages:

```bash
pip install -r requirements.txt
```

### Demo

Run the complete pipeline with the provided sample data:

```bash
./run.sh
```
