"""
Clustering tools based on the Mapper algorithm.
"""

from mapperlib.core import mapper_connected_components, TrivialCover
import mapperlib.core
from mapperlib._common import (
    ParamsMixin,
    EstimatorMixin,
    clone,
    deprecated,
)


class TrivialClustering(mapperlib.core.TrivialClustering):
    """
    **DEPRECATED**: This class is deprecated and will be removed in a future
    release. Use :class:`mapperlib.core.TrivialClustering`.
    """

    @deprecated(
        'This class is deprecated and will be removed in a future release. '
        'Use mapperlib.core.TrivialClustering.'
    )
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)


class FailSafeClustering(mapperlib.core.FailSafeClustering):
    """
    **DEPRECATED**: This class is deprecated and will be removed in a future
    release. Use :class:`mapperlib.core.FailSafeClustering`.
    """

    @deprecated(
        'This class is deprecated and will be removed in a future release. '
        'Use mapperlib.core.FailSafeClustering.'
    )
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)


class _MapperClustering(EstimatorMixin, ParamsMixin):

    def __init__(self, cover=None, clustering=None, n_jobs=1):
        self.cover = cover
        self.clustering = clustering
        self.n_jobs = n_jobs

    def fit(self, X, y=None):
        X, y = self._validate_X_y(X, y)
        cover = TrivialCover() if self.cover is None \
            else self.cover
        cover = clone(cover)
        clustering = TrivialClustering() if self.clustering is None \
            else self.clustering
        clustering = clone(clustering)
        n_jobs = self.n_jobs
        y = X if y is None else y
        itm_lbls = mapper_connected_components(
            X,
            y,
            cover,
            clustering,
            n_jobs=n_jobs,
        )
        self.labels_ = [itm_lbls[i] for i, _ in enumerate(X)]
        self._set_n_features_in(X)
        return self


class MapperClustering(_MapperClustering):
    """
    **DEPRECATED**: This class is deprecated and will be removed in a future
    release. Use :class:`mapperlib.learn.MapperClustering`.
    """

    @deprecated(
        'This class is deprecated and will be removed in a future release. '
        'Use mapperlib.learn.MapperClustering.'
    )
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
