#!/bin/bash

# Load the data directory path from config.json using Python
DATA_PATH=$(python -c "import json; print(json.load(open('config.json'))['data_dir'])")

# Define common parameters
CONTAINER_NAME="learning-dynamics-models"
DATASET="fmnist"
ARCH="resnet18_fmnist"

# Train fmnist model
python train.py --dataset fmnist --arch resnet18_fmnist --random_seed 1

# Loop through epochs and run the scoring script for each
for EPOCH in {1..199}; do
    MODEL_NAME="${DATASET}/${DATASET}_resnet18_fmnist_seed_1_epoch_${EPOCH}.ckpt"
        
    python ./mislabelled_exps/score_mislabelled.py \
        --container_name ${CONTAINER_NAME} \
        --model_name ${MODEL_NAME} \
        --dataset ${DATASET} \
        --root_path ${DATA_PATH} \
        --load_from_azure_blob \
        --arch ${ARCH}
done
