import csv
import numpy as np

def load_sensor_locations(fname, partial_sensors=False):
    with open(fname, "r") as f:
        locs = csv.reader(f, delimiter=",")
        full_sensors = np.asarray([[float(w1[0].split(" ")[1]), float(w1[0].split(" ")[2])] for w1 in locs])
    if partial_sensors:
        return full_sensors[::3]
    return full_sensors