import numpy as np
from regression.regression_utils import load_pkl, save_pkl
import librosa
class SessionStoryConfig():
    def __init__(self, subject, session, session_story, dataset_loc = "./dataset"):
        self.subject = subject
        self.session = session
        self.session_story = session_story
        self.story = session_story[:-1] if session_story[-1].isnumeric() else session_story
        self.dataset_loc = dataset_loc
    
    def load_aligned_downsampled_meg(self):
        aligned_meg_timings_file_loc = f"{self.dataset_loc}/aligned_downsampled_meg/Moth{self.session}/{self.subject}/{self.session_story}-timings-sr50.npy"
        aligned_meg_data_file_loc = f"{self.dataset_loc}/aligned_downsampled_meg/Moth{self.session}/{self.subject}/{self.session_story}-brain-sr50.npy"
        timings = np.load(aligned_meg_timings_file_loc)
        brain_data = np.load(aligned_meg_data_file_loc)
        return timings, brain_data
    
    def load_aligned_audio(self, sr = None):
        audio_file = f"{self.dataset_loc}/aligned_audio/Moth{self.session}/{self.subject}/{self.session_story}.wav"
        return librosa.load(audio_file, sr = sr)
    
    def load_alignment(self):
        alignment = load_pkl(f"{self.dataset_loc}/alignment/Moth{self.session}/{self.subject}/{self.session_story}.pkl")
        return alignment["lag"], alignment["stretch_rate"]
    
    def __str__(self):
        return f"subject: {self.subject} | session {self.session} | session story {self.session_story}"
            
    
#    def load_aligned_audio(self):
        

subject_A_stories = [('A', 5, 'hangtime'), ('A', 1, 'wheretheressmoke1'), ('A', 4, 'theclosetthatateeverything'),
 ('A', 2, 'wheretheressmoke2'), ('A', 4, 'wheretheressmoke4'), ('A', 5, 'swimmingwithastronauts1'),
 ('A', 4, 'buck2'), ('A', 2, 'undertheinfluence2'), ('A', 1, 'souls'), ('A', 5, 'thatthingonmyarm'),
 ('A', 3, 'stagefright1'), ('A', 2, 'life'), ('A', 1, 'alternateithicatom1'), ('A', 2, 'undertheinfluence1'),
 ('A', 3, 'stagefright2'), ('A', 1, 'odetostepfather'), ('A', 1, 'avatar'), ('A', 4, 'buck1'), ('A', 1, 'legacy'),
 ('A', 3, 'wheretheressmoke3'), ('A', 4, 'adventuresinsayingyes'), ('A', 3, 'tildeath'), ('A', 4, 'inamoment'),
 ('A', 3, 'sloth'), ('A', 5, 'itsabox'), ('A', 2, 'myfirstdaywiththeyankees'), ('A', 3, 'fromboyhoodtofatherhood'),
 ('A', 2, 'naked'), ('A', 2, 'howtodraw'), ('A', 4, 'haveyoumethimyet'), ('A', 5, 'eyespy'), ('A', 1, 'alternateithicatom2'),
 ('A', 4, 'adollshouse'), ('A', 5, 'wheretheressmoke5'), ('A', 5, 'swimmingwithastronauts2'), ('A', 3, 'exorcism')]

subject_C_stories = [('C', 5, 'hangtime'), ('C', 1, 'wheretheressmoke1'), ('C', 4, 'theclosetthatateeverything'),
 ('C', 2, 'wheretheressmoke2'), ('C', 4, 'wheretheressmoke4'), ('C', 5, 'swimmingwithastronauts1'),
 ('C', 4, 'buck2'), ('C', 2, 'undertheinfluence2'), ('C', 1, 'souls'), ('C', 5, 'thatthingonmyarm'),
 ('C', 3, 'stagefright1'), ('C', 2, 'life'), ('C', 1, 'alternateithicatom1'), ('C', 2, 'undertheinfluence1'),
 ('C', 3, 'stagefright2'), ('C', 1, 'odetostepfather'), ('C', 1, 'avatar'), ('C', 4, 'buck1'), ('C', 1, 'legacy'),
 ('C', 3, 'wheretheressmoke3'), ('C', 4, 'adventuresinsayingyes'), ('C', 3, 'tildeath'), ('C', 4, 'inamoment'),
 ('C', 3, 'sloth'), ('C', 5, 'itsabox'), ('C', 2, 'myfirstdaywiththeyankees'), ('C', 3, 'fromboyhoodtofatherhood'),
 ('C', 2, 'naked'), ('C', 2, 'howtodraw'), ('C', 4, 'haveyoumethimyet'), ('C', 5, 'eyespy'), ('C', 1, 'alternateithicatom2'),
 ('C', 4, 'adollshouse'), ('C', 5, 'wheretheressmoke5'), ('C', 5, 'swimmingwithastronauts2'), ('C', 3, 'exorcism')]

subject_D_stories = [('D', 5, 'hangtime'), ('D', 1, 'wheretheressmoke1'), ('D', 4, 'theclosetthatateeverything'),
 ('D', 2, 'wheretheressmoke2'), ('D', 4, 'wheretheressmoke4'), ('D', 5, 'swimmingwithastronauts1'),
 ('D', 4, 'buck2'), ('D', 2, 'undertheinfluence2'), ('D', 1, 'souls'), ('D', 5, 'thatthingonmyarm'),
 ('D', 3, 'stagefright1'), ('D', 2, 'life'), ('D', 1, 'alternateithicatom1'), ('D', 2, 'undertheinfluence1'),
 ('D', 3, 'stagefright2'), ('D', 1, 'odetostepfather'), ('D', 1, 'avatar'), ('D', 4, 'buck1'), ('D', 1, 'legacy'),
 ('D', 3, 'wheretheressmoke3'), ('D', 4, 'adventuresinsayingyes'), ('D', 3, 'tildeath'), ('D', 4, 'inamoment'),
 ('D', 3, 'sloth'), ('D', 5, 'itsabox'), ('D', 2, 'myfirstdaywiththeyankees'), ('D', 3, 'fromboyhoodtofatherhood'),
 ('D', 2, 'naked'), ('D', 2, 'howtodraw'), ('D', 4, 'haveyoumethimyet'), ('D', 5, 'eyespy'), ('D', 1, 'alternateithicatom2'),
 ('D', 4, 'adollshouse'), ('D', 5, 'wheretheressmoke5'), ('D', 5, 'swimmingwithastronauts2'), ('D', 3, 'exorcism')]


def subject_train_configs(subject= "A", dataset_loc = "./data"):
    if subject == "A":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_A_stories if x[2] not in [f"wheretheressmoke{i}" for i in range(1, 6)]]
    if subject == "C":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_C_stories if x[2] not in [f"wheretheressmoke{i}" for i in range(1, 6)]]
    if subject == "D":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_D_stories if x[2] not in [f"wheretheressmoke{i}" for i in range(1, 6)]]

def subject_test_configs(subject= "A",  dataset_loc = "./data"):
    if subject == "A":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_A_stories if x[2] in [f"wheretheressmoke{i}" for i in range(1, 6)]]
    if subject == "C":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_C_stories if x[2] in [f"wheretheressmoke{i}" for i in range(1, 6)]]
    if subject == "D":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_D_stories if x[2] in [f"wheretheressmoke{i}" for i in range(1, 6)]]
    
def subject_configs(subject= "A", dataset_loc = "./data"):
    if subject == "A":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_A_stories]
    if subject == "C":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_C_stories]
    if subject == "D":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_D_stories]

def subject_unique_configs(subject= "A", dataset_loc = "./data"):
    if subject == "A":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_A_stories if not (x[2][-1].isnumeric() and int(x[2][-1])>1)]
    if subject == "C":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_C_stories if not (x[2][-1].isnumeric() and int(x[2][-1])>1)]
    if subject == "D":
        return [SessionStoryConfig(*x, dataset_loc) for x in subject_D_stories if not (x[2][-1].isnumeric() and int(x[2][-1])>1)]

