from regression.lm_embeddings.embeddings_store import MEGFeatureMapStore
import numpy as np

def delayed_word_onset_features(meg_store_loc, configs, delays = 40, fold_tensors = True):
    meg_store = MEGFeatureMapStore(meg_store_loc)
    out = []
    for config in configs:
        config_out = []
        meg_index_maps = meg_store.load_meg_map(config)
        word_occured = (meg_index_maps != -1).astype(float)
        padded_word_occured = np.concat((np.zeros(delays-1), word_occured))
        for i in range(len(meg_index_maps)):
            config_out.append(padded_word_occured[i:i+delays][None, :])
        config_features = np.stack(config_out, axis=0)
        if fold_tensors:
            config_features = config_features.reshape(config_features.shape[0], -1)
        out.append(config_features)
    return out
        
        
        