import numpy as np
import pickle as pkl

def normalize(data):
    '''time, channel'''
    mu = np.mean(data, axis=0)[None,:]
    sigma = np.std(data, axis=0)[None,:]
    return (data - mu)/sigma, mu, sigma

def concat_time_series_inputs(time_series_list):
    return np.concat(time_series_list, axis=0)
    
def unconcat_time_series_inputs(time_series_list_lens, concated_time_series):
    out = []
    assert sum(time_series_list_lens) == concated_time_series.shape[0]
    start_index = 0
    for time_series_len in time_series_list_lens:
        end_index = start_index + time_series_len
        out.append(concated_time_series[start_index:end_index])
        start_index = end_index
    return out

def load_pkl(file_loc):
    with open(file_loc, "rb") as f:
        return pkl.load(f)

def save_pkl(obj, file_loc):
    with open(file_loc, "wb") as f:
        pkl.dump(obj, f)