
# Atari

## Downloading datasets

Create a directory for the dataset and load the dataset using [gsutil](https://cloud.google.com/storage/docs/gsutil_install#install). Replace `[DIRECTORY_NAME]` and `[GAME_NAME]` accordingly (e.g., `./dqn_replay` for `[DIRECTORY_NAME]` and `Breakout` for `[GAME_NAME]`)
```
mkdir 
gsutil -m cp -R gs://atari-replay-datasets/dqn/[GAME_NAME] [DIRECTORY_NAME]
```

## Downloading Atari Roms
```
wget https://www.atarimania.com/roms/Atari-2600-VCS-ROM-Collection.zip
unzip Atari-2600-VCS-ROM-Collection.zip
mkdir roms
mv 'HC ROMS' roms
mv ROMS roms
```

## Installation
```
docker build -f Dockerfile -t radt_atari .

docker run --gpus all \
    --rm -it --name radt_$(($RANDOM % 1000 + 1000)) \
    --shm-size=30g \
    --memory=30g \
    -e HOSTNAME=$HOSTNAME \
    -v ./dqn_replay:/radt_atari/dqn_replay \
    -v ./logs:/radt_atari/logs \
    radt_atari bash
```

## Example usage

Experiments can be reproduced with the following in your Docker container:

```
./scripts/run.sh Breakout
```
